# -*- encoding: utf-8 -*-
=begin
= スキル用セリフ設定（アクター用）

    :word_1  ...セリフ情報。内容、顔倉ファイル名、顔倉インデックスの順です。
                :word_1から:word_10の中からランダムで決定します。
    :ct_type ...カットインタイプを以下から指定します。（現在４種）
      :basic ... 単純表示
      :slide ... 右からスライドイン
      :focus ... ３層表示で原点に集まる
      :long  ... 単純表示。ダメージ終了まで残る
    :ct_pic  ...カットインで表示するピクチャ名
    :ct_se   ...カットインの時に再生するＳＥ名。設定省略可
    
カットインタイプは表示原点を変更した関係で
今まで通りの演出が出来なくなったので適当に追加しておきます。
自動置換の都合でカットインタイプは全て:basicになっています。
現在カットインはデフォルトの戦闘用ピクチャ表示処理を
流用しているので入用になったら言ってください。

==更新履歴
Date     Version Author Comment

=end

#==============================================================================
# ■ NWConst::Actor
#==============================================================================
module NWConst::Actor
  SKILL_WORDS = {
    0 => { # 共通
      [1576] => { # ゴブリン
        :ct_pic => "80_gob_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Goblin Girl>I was called!", "gob_fc1", 0],
      },
      [1577] => { # ラミア
        :ct_pic => "ct_syoukan01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Lamia>I'll knock everyone down...", "syokan01", 0],
      },
      [1578] => { # カーバンクル
        :ct_pic => "80_carbuncle_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Carbuncle>I'll protect you with my magic mirror...", "carbuncle_fc1", 0],
      },
      [1579] => { # スキュラ
        :ct_pic => "ct_syoukan02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Scylla>Aha. Prey for my tentacles...", "syokan02", 0],
      },
      [1580,4352] => { # ラクシュミ
        :ct_pic => "ct_syoukan03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Lakshmi>Healing light, for everyone...", "syokan03", 0],
      },
      [1581] => { # ドラゴン
        :ct_pic => "ct_syoukan04",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Dragon>Were you the ones who called me...?", "syokan04", 0],
      },
      [1582] => { # フェニックス
        :ct_pic => "ct_syoukan05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Phoenix>Flames before life, flames after death...", "syokan05", 0],
      },
      [1583] => { # ペガサス
        :ct_pic => "ct_syoukan06",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Pegasus>My wings shall smash their protections...", "syokan06", 0],
      },
      [1584] => { # 世界樹
        :ct_pic => "ct_syoukan07",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Yggdrasil>I am the world tree...", "syokan07", 0],
      },
      [1585] => { # シルフ
        :ct_pic => "80_sylph_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Yahoooo! I'm gonna go wild!", "sylph_fc1", 2],
        :word_2 => ["\\n<Sylph>Yaaa! Winds, blow them awaaay!", "sylph_fc1", 2],
        :word_3 => ["\\n<Sylph>It's Tatsumaki!　Okay!!", "sylph_fc1", 2],
      },
      [1586] => { # ノーム
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1587] => { # ウンディーネ
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Clear and serene...", "undine_fc1", 0],
        :word_2 => ["\\n<Undine>Waters, bring forth eternal silence...", "undine_fc1", 0],
        :word_3 => ["\\n<Undine>Like flowing water...", "undine_fc1", 0],
      },
      [1588] => { # サラマンダー
        :ct_pic => "80_salamander_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Flames, blaze with a passion!", "salamander_fc1", 1],
        :word_2 => ["\\n<Salamander>Flames, burn them all down!", "salamander_fc1", 1],
        :word_3 => ["\\n<Salamander>Sweep through, crimson flames!", "salamander_fc1", 1],
      },
      [1589] => { # ジルフィ
        :ct_pic => "80_zylphe_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Zylphe>Wind... Cut them down...", "zylphe_fc1", 0],
      },
      [1590] => { # ノーマレン
        :ct_pic => "80_gnomaren_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnomaren>............", "gnomaren_fc1", 0],
      },
      [1591] => { # グランディーネ
        :ct_pic => "80_grandine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Grandine>Drown...", "grandine_fc1", 0],
      },
      [1592] => { # ギガマンドラ
        :ct_pic => "80_gigamander_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gigamander>Burn to ashes...!", "gigamander_fc1", 0],
      },
      [1593] => { # 神竜
        :ct_pic => "ct_syoukan08",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Divine Dragon>You will perish before my breath...", "syokan08", 0],
      },
      [1594] => { # 死神
        :ct_pic => "ct_syoukan09",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Reaper>Let us depart for Hades...", "syokan09", 0],
      },
      [1595] => { # サマエル
        :ct_pic => "80_samael_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Samael>Let it burn to ashes!", "samael_fc1", 0],
      },
      [1596] => { # ゲイザー
        :ct_pic => "80_gazer_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gazer>Hey, disappear into the chaos...!", "gazer_fc1", 0],
      },
      [1597] => { # スィートテンタクル
        :ct_pic => "ct_syoukan11",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sweet Tentacle>............", "syokan11", 0],
      },
      [1598] => { # カオスプレジャー
        :ct_pic => "ct_syoukan12",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Chaos Pleasure>............", "syokan12", 0],
      },
      [1599] => { # ユニバースワーム
        :ct_pic => "ct_syoukan13",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Universe Worm>............", "syokan13", 0],
      },
      [1600] => { # 噛み付きアニー
        :ct_pic => "ct_syoukan_z01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Biting Annie>*Chomp* *Chomp*", "syoukan_z_fc1", 0],
      },
      [1601] => { # アマゾネスジェーン
        :ct_pic => "ct_syoukan_z02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Amazon Jane>My whip... Take it!", "syoukan_z_fc1", 1],
      },
      [1602] => { # ネクロシェリー
        :ct_pic => "ct_syoukan_z03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Necro Sherri>Dance... My flame...", "syoukan_z_fc1", 2],
      },
      [1603] => { # 乾きのエリザベス
        :ct_pic => "ct_syoukan_z04",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Dry Elizabeth>So dry... Drink you...", "syoukan_z_fc1", 3],
      },
      [1604] => { # 身代わりクララ
        :ct_pic => "ct_syoukan_z05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Vicarious Clara>I'll protect you with my shield!", "syoukan_z_fc1", 4],
      },
      [1605] => { # 腐騎士アレクシア
        :ct_pic => "ct_syoukan_z06",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Rotting Knight Alexia>Now, linked slashes!", "syoukan_x_fc1", 1],
      },
      [1606] => { # 絢爛たる屍精姫レイナ
        :ct_pic => "ct_syoukan_z07",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Beautiful Corpse Princess Reina>Come, I will show you pleasure...", "syoukan_x_fc1", 3],
      },
      [1607] => { # 女王ネクロディア
        :ct_pic => "ct_syoukan_z08",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Queen Necrodia>Perish as you're covered in miasma...", "syoukan_x_fc2", 1],
      },
      [1608] => { # 大屍軍エリミネア
        :ct_pic => "ct_syoukan_z09",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Corpse Army Elminea>We'll overrun the world of the living...", "syoukan_x_fc1", 0],
      },
      [1609] => { # 取り憑きディアナ
        :ct_pic => "ct_syoukan_g01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Possessive Diana>Let's be together...", "syoukan_g_fc1", 0],
      },
      [1610] => { # 色情霊アンナ
        :ct_pic => "ct_syoukan_g02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Horny Anna>Do you want to play with me...?", "syoukan_g_fc1", 1],
      },
      [1611] => { # 霊魔導師エリー
        :ct_pic => "ct_syoukan_g03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Spirit Mage Ellie>Freeze your soul...", "syoukan_g_fc1", 2],
      },
      [1612] => { # ブラッディーマリー
        :ct_pic => "ct_syoukan_g04",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Bloody Mary>You'll be bloody too...", "syoukan_g_fc1", 3],
      },
      [1613] => { # 幽霊僧侶マリア
        :ct_pic => "ct_syoukan_g05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Ghost Priest Maria>Healing from the spirit world...", "syoukan_g_fc1", 4],
      },
      [1614] => { # トモエ御前
        :ct_pic => "ct_syoukan_g06",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Lady Tomoe>I've come to assist you!", "syoukan_x_fc1", 4],
      },
      [1615] => { # 大魔導師グレゴリア
        :ct_pic => "ct_syoukan_g07",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Great Mage Gregoria>I'll freeze you...fufufu.", "syoukan_x_fc1", 7],
      },
      [1616] => { # 幽淫婦マージェリー
        :ct_pic => "ct_syoukan_g08",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Tranquil Whore Margery>Please enjoy yourself... You will be delighted...", "syoukan_x_fc1", 2],
      },
      [1617] => { # 吸精皇女ヒルダ
        :ct_pic => "ct_syoukan_g09",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sucking Princess Hilda>Squeeze out everything... Until you dry up...", "syoukan_x_fc1", 6],
      },
      [1618] => { # 斬り裂きエリス
        :ct_pic => "ct_syoukan_k01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Slicing Elise>CutCutCutCutCut", "syoukan_k_fc1", 0],
      },
      [1619] => { # セントメイデン
        :ct_pic => "ct_syoukan_k02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Saint Maiden>I shall judge you in my embrace...", "syoukan_k_fc1", 1],
      },
      [1620] => { # 騒霊人形
        :ct_pic => "ct_syoukan_k03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Poltergeist Doll>Ufufu...Hahaha...", "syoukan_k_fc1", 2],
      },
      [1621] => { # シャウトマータ
        :ct_pic => "ct_syoukan_k04",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Shout Marta>SUPER LOUD...!", "syoukan_k_fc1", 3],
      },
      [1622] => { # ラブマータ
        :ct_pic => "ct_syoukan_k05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Love Marta>Let's have some fun...", "syoukan_k_fc1", 4],
      },
      [1623] => { # ベック・ザ・ビースト
        :ct_pic => "ct_syoukan_k06",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Beck the Beast>............", "hargenbeck_fc1", 0],
      },
      [1624] => { # ジャイアントセーラ
        :ct_pic => "ct_syoukan_k07",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Giant Serra>Let's plaaaay!", "giantsarah_fc1", 0],
      },
      [1625] => { # 決戦人型兵器アグニ
        :ct_pic => "ct_syoukan_k08",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Humanoid Decisive Weapon Agni>Target confirmed, commencing attack...", "syoukan_x_fc1", 5],
      },
      [1626] => { # 快楽人形・雅姫
        :ct_pic => "ct_syoukan_k09",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Pleasure Doll Miyabihime>If you are fine with a mechanical body...\nThen I promise to consort with you.", "syoukan_x_fc2", 0],
      },
      [1627] => { # 黄泉蜘蛛
        :ct_pic => "80_kagetumugi_st11",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Yomigumo>....................", "kagetumugi_fc2", 0],
      },
      [1628] => { # 魁狐々
        :ct_pic => "80_kagetumugi_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Kaiko Kitsune>....................", "kagetumugi_fc3", 0],
      },
      [1629] => { # 蘭天狗
        :ct_pic => "80_kagetumugi_st31",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Rantengu>Ahaha, let's go!!", "kagetumugi_fc4", 0],
      },
      [9376] => { # 死神
        :ct_pic => "ct_syoukan09",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Reaper>It's Joker's time...", "syokan09", 0],
      },
      [3106] => { # シルフ
        :ct_pic => "80_sylph_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Yahoooo! I'm gonna go wild!", "sylph_fc1", 2],
        :word_2 => ["\\n<Sylph>Yaaa! Winds, blow them awaaay!", "sylph_fc1", 2],
        :word_3 => ["\\n<Sylph>Here comes a tornado! Whoosh!!", "sylph_fc1", 2],
      },
      [3107] => { # ノーム
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3108] => { # ウンディーネ
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Clear and serene...", "undine_fc1", 0],
        :word_2 => ["\\n<Undine>Waters, bring forth eternal silence...", "undine_fc1", 0],
        :word_3 => ["\\n<Undine>Like flowing water...", "undine_fc1", 0],
      },
      [3109] => { # サラマンダー
        :ct_pic => "80_salamander_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Flames, blaze with a passion!", "salamander_fc1", 1],
        :word_2 => ["\\n<Salamander>Flames, burn them all down!", "salamander_fc1", 1],
        :word_3 => ["\\n<Salamander>Sweep through, crimson flames!", "salamander_fc1", 1],
      },
      [3110] => { # 創世の女神イリアス
        :ct_pic => "80_iriasu_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Ilias>With my majesty, let me bring light to all...", "iriasu_fc1", 0],
      },
      [9780] => { # 麒麟
        :ct_pic => "80_raikiri_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Kirin>....................", "raikiri_fc1", 0],
      },
      [9781] => { # 氷帰蝶
        :ct_pic => "80_korikityou_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Ice return butterfly>....................", "korikityou_fc1", 0],
      },
      [8684] => { # スライム娘
        :ct_pic => "80_slime_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Slime Girl>I came to help you~♪", "slime_fc1", 0],
      },
      [8685] => { # インプ
        :ct_pic => "80_inp_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Imp>I'll defeat you with my magic!", "inp_fc1", 0],
      },
      [8686] => { # マンドラゴラ娘
        :ct_pic => "80_mdg_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Mandragora Girl>What, don't wake me up...", "mdg_fc1", 0],
      },
      [8687] => { # ゴブリン
        :ct_pic => "80_gob_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Goblin>I felt like I was called!", "gob_fc1", 0],
      },
      [8688] => { # スキュラ
        :ct_pic => "80_scylla_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Scylla>I'll help you, hehe...", "scylla_fc1", 0],
      },
      [8689] => { # ラミア
        :ct_pic => "80_lamia_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Lamia>I will help you...", "lamia_fc1", 0],
      },
      [8690] => { # 羊娘
        :ct_pic => "80_hituzi_st04",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sheep Girl>I came to help!", "hituzi_fc1", 3],
      },
      [8691] => { # ハーピー
        :ct_pic => "80_hapy_a_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Harpy>It's here~♪ Basabasa~!", "hapy_a_fc1", 0],
      },
      [8692] => { # 銀狐二尾
        :ct_pic => "80_youko_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Two-Tailed Silver Kitsune>It's a fox ninja technique, and it's a suketachi!", "youko_fc1", 0],
      },
      [8693] => { # ミミック娘
        :ct_pic => "80_mimic_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Mimic Girl>Don't call me...", "mimic_fc1", 0],
      },
      [8694] => { # カニ娘
        :ct_pic => "80_kani_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Crab Girl>Who wants to be washed by me?", "kani_fc1", 0],
      },
      [8695] => { # ゴースト
        :ct_pic => "80_ghost_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Ghost>Urameshiya...", "ghost_fc1", 0],
      },
      [8696] => { # ミノタウロス娘
        :ct_pic => "80_mino_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Minotaur Girl>Okay, let's go wild!", "mino_fc1", 0],
      },
      [8697] => { # ケンタウロス娘
        :ct_pic => "80_centa_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Centaur Girl>Look at the clarity of my spear!", "centa_fc1", 0],
      },
      [8698] => { # アルラウネ
        :ct_pic => "80_alraune_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alraune>I'm here to help!", "alraune_fc1", 0],
      },
      [8699] => { # ねこまた
        :ct_pic => "80_nekomata_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Nekomata>Meow!", "nekomata_fc1", 0],
      },
      [8700] => { # 妖鬼
        :ct_pic => "80_youki_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Youki>I'll show you the strength of the demon!", "youki_fc1", 0],
      },
      [8701] => { # セイレーン
        :ct_pic => "80_seiren_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Siren>I'll steal your heart...", "seiren_fc1", 0],
      },
      [8702] => { # ベヒーモス娘
        :ct_pic => "80_behemoth_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Behemoth Girl>Did you call me...? If it's \n, let's show it works better than expected!", "behemoth_fc1", 0],
      },
      [8703] => { # 前鬼
        :ct_pic => "80_zenki_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Zenki>Did you call me? I'll lend you my strength!", "zenki_fc1", 0],
      },
      [8704] => { # 後鬼
        :ct_pic => "80_kouki_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Kouki>As a shikigami, I will help you...!", "kouki_fc1", 0],
      },
      [8705] => { # アモルラーム
        :ct_pic => "80_amoldoll_st11",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Amor Rahm>....................", "amoldoll_fc2", 0],
      },
      [8706] => { # アモルリーム
        :ct_pic => "80_amoldoll_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Amor Rihm>....................", "amoldoll_fc2", 3],
      },
      [8707] => { # シェスタ
        :ct_pic => "80_syesta_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Shesta>disappeared...", "syesta_fc1", 0],
      },
      [8708] => { # ライオット
        :ct_pic => "80_liot_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Riot>You're in the way! Disappear!", "liot_fc1", 0],
      },
      [8709] => { # ルクスル
        :ct_pic => "80_luksl_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luxuru>Hehe, ahahaha!!", "luksl_fc1", 0],
      },
      [8710] => { # ヴァルト
        :ct_pic => "80_valt_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Valto>Shooting begins...", "valt_fc1", 0],
      },
      [8711] => { # シニファ
        :ct_pic => "80_sinifa_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Shinifa>Ahahahahahahaha!!", "sinifa_fc1", 0],
      },
      [8712] => { # ツィンケル
        :ct_pic => "80_twinkel_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Twinkell>We will help you...", "twinkel_fc1", 0],
      },
      [8713] => { # トリロバイト
        :ct_pic => "80_trilobite_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Trilobite>Do you want to see our power...?", "trilobite_fc1", 0],
      },
      [8714] => { # アムナリオ
        :ct_pic => "80_amnario_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Amunario>I wonder if everyone can eat it...?", "amnario_fc1", 0],
      },
      [8715] => { # 白兎
        :ct_pic => "80_sirousagi_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<White Rabbit>Hello! Did you call me?", "sirousagi_fc1", 0],
      },
      [8716] => { # 死神
        :ct_pic => "80_sinigami_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Reaper>Let's finish it right away...", "sinigami_fc1", 0],
      },
      [8717] => { # ヌール・コギト
        :ct_pic => "80_nurukox_st01b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Null Cogito>■■■■■■■■■■■■■...", "nurukox_fc1", 0],
      },
      [8718] => { # 黒のアリス
        :ct_pic => "80_alice8th6_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Black Alice>Come on, let's have fun...", "alice8th_fc4", 0],
      },
      [8719] => { # アンゴルモア
        :ct_pic => "80_angolmois_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Angolmois>Are you strong? Let me show you that power!", "angolmois_fc1", 0],
      },
      [8720] => { # 七つの大罪
        :ct_pic => "80_satan_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Seven Deadly Sins>I am the original sin...", "satan_fc1", 0],
      },
      [8721] => { # ダークフェニックス
        :ct_pic => "80_darkphenix_st01b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Dark Phoenix>Now, return to reincarnation...", "darkphenix_fc1", 0],
      },
      [8722] => { # エキドナ
        :ct_pic => "80_echidna_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Echidna>Come on, fall... Ufufufufu...", "echidna_fc1", 0],
      },
      [8723] => { # マガツオオミカミ
        :ct_pic => "80_magatuomikami_st01b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Magatsu-Omikami>■■■■■■■■■■■■■...!!", "magatuomikami_fc1", 0],
      },
      [8724] => { # コスモス
        :ct_pic => "80_queenmoss_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Cosmos>Let's fill this world with chaos...", "queenmoss_fc1", 0],
      },
      [8725] => { # シンギュラリティ
        :ct_pic => "80_Singularity_st22",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Singularity>Hey, disappear...! Ahahaha...!!", "singularity_fc1", 0],
      },
      [8726] => { # 名状しがたきもの
        :ct_pic => "80_cthulhu_st01b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Indescribable>I have come to bring destruction...", "cthulhu_fc1", 0],
      },
      [8727] => { # 虚竜
        :ct_pic => "80_koron_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Koron>The greatest and most powerful power... worship in its eyes!!", "koron_fc1", 0],
      },
      [8728] => { # バアル・ゼブブ
        :ct_pic => "80_baal_zebub_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Baal Zebub>This world is me, I am the world...", "baal_zebub_fc1", 0],
      },
      [8729] => { # 星喰い
        :ct_pic => "80_hosikui_st11",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Star Eater>Dedicate everything on this planet to me...", "hosikui_fc1", 2],
      },
      [9244] => { # アバドン
        :ct_pic => "80_abaddon_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Abaddon>Then I will have you destroyed...", "abaddon_fc1", 0],
      },
      [9245] => { # メルカヴァ
        :ct_pic => "80_merkava_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Merkabah>Return to reincarnation...", "merkava_fc1", 0],
      },
      [9246] => { # 正体不明
        :ct_pic => "80_unknown5_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Unidentified>....................", "unknown5_fc1", 0],
      },
      [9247] => { # アドラメレク
        :ct_pic => "80_adramelek_st11",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Adramelech>Delete \n...", "adramelek_fc1", 0],
      },
      [9248] => { # ソニアマズダ
        :ct_pic => "80_soniamazda_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sonya Mazda>■■■■■■■■■■■■■...", "soniamazda_fc1", 0],
      },
      [9249] => { # ソニアマンユ
        :ct_pic => "80_soniamanyu_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sonya Mainyu>■■■■■■■■■■■■■...", "soniamanyu_fc1", 0],
      },
      [9250] => { # 銀河竜
        :ct_pic => "ct_syoukan10",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Galaxy Dragon>It is better to return to nothingness...", "syokan10", 0],
      },
      [9251] => { # 全てを識る者
        :ct_pic => "80_skyuba_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<The All-Knowing>I am The All-Knowing...", "skyuba_fc1", 0],
      },
      [9252] => { # 魔神
        :ct_pic => "80_mazin_st01b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Archfiend>Is this the world that will be destroyed next...?", "mazin_fc1", 0],
      },
      [9253] => { # 鬼神
        :ct_pic => "80_kizin2_st01b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Kishin>Please disappear at the end...", "kizin2_fc1", 0],
      },
      [9254] => { # 女神
        :ct_pic => "80_megami_st02b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Goddess>It will disappear forever...", "megami_fc1", 0],
      },
      [9255] => { # 次元侵蝕者
        :ct_pic => "iv_zigensinsyokusya1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Dimensional Eroder>Ufufufufufu...", "zigen_boss_fc1", 0],
      },
      [9256] => { # イザナミ
        :ct_pic => "80_izanami_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Izanami>It is better to return to the underworld...", "izanami_fc1", 0],
      },
      [9257] => { # アメノハヅチ
        :ct_pic => "80_amenohaduti_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Ame no Hazuchi>Ufufu, Ufufufufu...", "amenohaduti_fc1", 0],
      },
      [9258] => { # ノーライフキング
        :ct_pic => "80_dragonbone_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<No Life King>Disappear from my presence...!", "dragonbone_fc1", 0],
      },
      [9259] => { # 無銘の姉妹
        :ct_pic => "iv_chrome_v_kagetumugi4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Nameless Sisters>Come on, let's go!!", "chromg_fc1", 0],
      },
      [9260] => { # 八尺様
        :ct_pic => "80_hasyakusama_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Hasshaku-sama>Popopopopopo...", "hasyakusama_fc1", 0],
      },
      [9261] => { # ワールドドロウン
        :ct_pic => "80_worlddrown_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<World Drown>I will sink everything in this world into the sea...", "worlddrown_fc1", 0],
      },
      [9262] => { # 呪いの人形終異体
        :ct_pic => "80_doll_itai_st01b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Final Cursed Doll>disappears...", "doll_itai_fc1", 0],
      },
      [9263] => { # ドーラドーラ
        :ct_pic => "80_dolladolla_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Dolla-Dolla>Will you...play with me...?", "dolladolla_fc1", 0],
      },
      [9264] => { # デウスエクスマキナ
        :ct_pic => "80_deusex_st13",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Deus Ex Machina>■■■■■■■■■■■■■...", "deusex_fc1", 3],
      },
      [9265] => { # ラ・クロワ
        :ct_pic => "ct_shirom1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<La Croix>I'll lend you a hand...", "shirom_fc2", 0],
      },
      [9266] => { # マガツカルラ
        :ct_pic => "80_kagetumugi2_st11",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Magatsu-Karura>....................", "kagetumugi_fc9", 0],
      },
      [9799] => { # ジルフィ
        :ct_pic => "80_zylphe_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Zylphe>style... mowing down...", "zylphe_fc1", 0],
      },
      [9800] => { # ノーマレン
        :ct_pic => "80_gnomaren_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnomaren>....................", "gnomaren_fc1", 0],
      },
      [9801] => { # グランディーネ
        :ct_pic => "80_grandine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Grandine>Drown...", "grandine_fc1", 0],
      },
      [9802] => { # ギガマンドラ
        :ct_pic => "80_gigamander_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gigamander>Turn into ashes...!", "gigamander_fc1", 0],
      },
      [9803] => { # アンブロシア
        :ct_pic => "80_ambrosia_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Ambrosia>....................", "ambrosia_fc1", 0],
      },
      [9804] => { # ロア
        :ct_pic => "80_loa_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Loa>I will help you with the power of earth!", "loa_fc1", 0],
      },
      [9805] => { # ガタノソア
        :ct_pic => "80_ghatanothoa_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Ghatanothoa>It's the power of raging water!!", "ghatanothoa_fc1", 0],
      },
      [9806] => { # グリモワール
        :ct_pic => "80_grimoire_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Grimoire>The power of tranquil flame...", "grimoire_fc1", 0],
      },
    },
    1 => { # ルカ
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Luka>Hyaah!", "ruka_fc1", 0],
        :word_2 => ["\\n<Luka>Huh!", "ruka_fc1", 0],
        :word_3 => ["\\n<Luka>Hey!", "ruka_fc1", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc1", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc1", 0],
      },
      [917] => { # 切り返し
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>With a backslash... Teyaa!", "ruka_fc1", 0],
      },
      [918] => { # 疾風突き
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like the wind... Thrust!", "ruka_fc1", 0],
      },
      [919] => { # 払車剣
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Brandish, like a wheel... Shockwave Blade!", "ruka_fc1", 0],
      },
      [920] => { # 諸刃斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>My resolve is unwavering, Double-Edged Cut!", "ruka_fc1", 0],
      },
      [921] => { # 隼斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a falcon... A rapid slash!", "ruka_fc1", 0],
      },
      [922] => { # 火炎斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Imbue, flames... Teyaa!", "ruka_fc1", 0],
      },
      [923] => { # 氷斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Imbue, ice...Teyaa!", "ruka_fc1", 0],
      },
      [924] => { # 稲妻斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Imbue, lightning... Teyaa!", "ruka_fc1", 0],
      },
      [930] => { # エンジェルダンス
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade, dance in the heavens... Angel Dance!", "ruka_fc1", 0],
      },
      [931] => { # 真空斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Vacuum blade... Haa!", "ruka_fc1", 0],
      },
      [932] => { # 烈風剣
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance, blade of gales! Haaaa!", "ruka_fc1", 0],
      },
      [933] => { # 月影の太刀
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>A dance in the moonlight... Moonlight Blade!", "ruka_fc1", 0],
      },
      [934] => { # 魔神斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The cursed god's strike! Haa!", "ruka_fc1", 0],
      },
      [935] => { # デッドクラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of destruction carries death... Dead Crash!", "ruka_fc1", 0],
      },
      [936] => { # 二刀十字斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Come closer and see it for yourself! Cross Slash!", "ruka_fc1", 0],
      },
      [937] => { # 魔剣・首刈り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Gleam, blade of courage! Demon Decapitation!", "ruka_fc1", 0],
      },
      [938] => { # 血裂雷鳴突き
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Shine and tear through the darkness! Thunder Thrust!", "ruka_fc1", 0],
      },
      [942] => { # フレイムスラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn them down, crimson flash...\nFlame Slash!", "ruka_fc1", 0],
      },
      [943] => { # アイススラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Freeze them solid, azure flash...\nFreeze Slash!", "ruka_fc1", 0],
      },
      [944] => { # サンダースラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Cleave them away, amber flash...\nThunder Slash!", "ruka_fc1", 0],
      },
      [945] => { # 斬魔の舞
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade which smites evil shall destroy demons!\nThis dancing light is the Demon Slayer Dance!", "ruka_fc1", 0],
      },
      [946] => { # 屠竜撃
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Here it comes, a slash to fell dragons!", "ruka_fc1", 0],
      },
      [947] => { # 雲身払車剣
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blades of fog, spin like wheels... Cloudy Shockwave Blade!", "ruka_fc1", 0],
      },
      [948] => { # 滅世斬
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of darkness that cleaves this world... World-Ending Slash!", "ruka_fc1", 0],
      },
      [950] => { # 瞬剣・疾風迅雷
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Sylph, lend me your strength! Lightning Sword Flash!", "ruka_fc1", 0],
      },
      [953] => { # 死剣・乱れ星
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a chaotic shooting star... Death Sword Chaos Star!", "ruka_fc1", 0],
      },
      [954] => { # 魔影流星斬
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Witness the dark meteor's descent to earth... Demonic Meteor Slash!", "ruka_fc1", 0],
      },
      [959] => { # ギガスラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is it... the ultimate flash! Giga Slash!", "ruka_fc1", 0],
      },
      [960] => { # ラウンドオブビリオン
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the miracle of the holy sword...Round of Billion!", "ruka_fc1", 0],
      },
      [961] => { # 月下散華
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The shadow of the moon foretells death... Moonlight Sacrifice!", "ruka_fc1", 0],
      },
      [962] => { # 魔刃・雪時雨
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Rakshasa's eternal, endless slashes... Demon Sword Snowstorm!", "ruka_fc1", 0],
      },
      [964] => { # ジャスティスヘブン
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Judgment of justice, execution of divine will... \n Sword of condemnation! Justice Heaven!", "ruka_fc1", 0],
      },
      [965] => { # 閃殺
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The principle of space-time, the severance is my blade of lightning!", "ruka_fc1", 0],
      },
      [966] => { # 烈空堕天斬
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Sword which fell to earth, tear down the heavens from whence you came! Shine bright! Heaven's Severance!", "ruka_fc1", 0],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Fast like a gale, fast like thunder...! \n Instant strike, gale of thunder!", "ruka_fc1", 0],
      },
      [969] => { # 諸刃微塵斬り
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Even if this body decays... it's a double-edged sword!", "ruka_fc1", 0],
      },
      [973] => { # アトミックスラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase \n, a flash of nuclear heat... Atomic Slash!", "ruka_fc1", 0],
      },
      [974] => { # クァンタスラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of quantum... Quantus Slash!", "ruka_fc1", 0],
      },
      [975] => { # イオンスラッシュ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of atoms... ion slash!", "ruka_fc1", 0],
      },
      [9009] => { # ギガスラッシュクロス
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Double flash! Giga Slash Cross!", "ruka_fc1", 0],
      },
      [9013] => { # 九重の羅刹
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Rakshasa's jaw gate has defeated the army and banished evil!", "ruka_fc1", 0],
      },
      [9022] => { # 天軍の剣
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc1", 0],
      },
      [9023] => { # 天軍滅星
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc1", 0],
      },
      [9016] => { # 乱れ雪月花
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Snow dance...moon shadow...flowers and scattering...!", "ruka_fc1", 0],
      },
      [971] => { # 聖光六閃斬
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Catch \n, a continuous attack of light... Six flashes of holy light!", "ruka_fc1", 0],
      },
      [970] => { # メギドカリバーン
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>mowing down with the wave of darkness! Megiddo Caliburn!", "ruka_fc1", 0],
      },
      [9014] => { # メギドカブラ
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate mystery of the magic sword! Megidokabura!", "ruka_fc1", 0],
      },
      [976] => { # 癒しの剣
        :word_1 => ["\\n<Luka>The sword of healing shall bless you with the power of the Heavens!", "ruka_fc1", 0],
      },
      [977] => { # 奇跡の剣
        :word_1 => ["\\n<Luka>Oh blade of miracles, bestow upon us your protection!", "ruka_fc1", 0],
      },
      [978] => { # 大奇跡の剣
        :word_1 => ["\\n<Luka>Healing sword, God's miracle!", "ruka_fc1", 0],
      },
      [979] => { # 超奇跡の剣
        :word_1 => ["\\n<Luka>Super miraculous sword, great healing!", "ruka_fc1", 0],
      },
      [972] => { # 闇天
        :word_1 => ["\\n<Luka>The blade of Shura that cuts everything...Dark Heaven!", "ruka_fc1", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Luka>Let's go, Rapier of Justice! Ha!", "ruka_fc1", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Luka>Stake your pride on this blade!", "ruka_fc1", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Luka>A flash with this blade... Hey!", "ruka_fc1", 0],
      },
      [1007] => { # 峰打ち
        :word_1 => ["\\n<Luka>I'll let you sleep... Mineuchi!", "ruka_fc1", 0],
      },
      [1008] => { # 三連斬
        :word_1 => ["\\n<Luka>Slash again and again, Three Step Decapitation!", "ruka_fc1", 0],
      },
      [1009] => { # 居合い抜き
        :word_1 => ["\\n<Luka>Cut them with a single stroke! Iainuki!", "ruka_fc1", 0],
      },
      [1010] => { # 牙突
        :word_1 => ["\\n<Luka>Pierce everything! Fang!", "ruka_fc1", 0],
      },
      [1011] => { # 居合い・焔ノ太刀
        :word_1 => ["\\n<Luka>Burn them to ash, crimson blade! Iainuki:Flame!", "ruka_fc1", 0],
      },
      [1012] => { # 居合・吹雪ノ太刀
        :word_1 => ["\\n<Luka>Freeze them over, frigid blade! Iainuki:Blizzard!", "ruka_fc1", 0],
      },
      [1013] => { # 居合・雷土ノ太刀
        :word_1 => ["\\n<Luka>Flash, blade of lightning! Iainuki:Thunder!", "ruka_fc1", 0],
      },
      [1018] => { # 滅魂刀
        :word_1 => ["\\n<Luka>I'll destroy your soul... Haa!", "ruka_fc1", 0],
      },
      [1019] => { # 斬神斬魔
        :word_1 => ["\\n<Luka>I'll sever gods, and destroy demons...!", "ruka_fc1", 0],
      },
      [1022] => { # 縮地・焔閃
        :word_1 => ["\\n<Luka>A flash of the blade as if a flicker... Searing Flash!", "ruka_fc1", 0],
      },
      [1023] => { # 魔刀・明鏡止水
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like the water's flow... Serene Demon Sword!", "ruka_fc1", 0],
      },
      [1024] => { # 神刀・鏡花水月
        :word_1 => ["\\n<Luka>A perfectly clear, pure flash... Kyoka Suigetsu!", "ruka_fc1", 0],
      },
      [1025] => { # 微塵滅閃
        :word_1 => ["\\n<Luka>A chaotic demon blade that carves atoms... Atom-Destroying Flash!", "ruka_fc1", 0],
      },
      [1026] => { # 聖刃七星天
        :word_1 => ["\\n<Luka>Gaze upon the seven polar stars...\nTwinkling from heaven to earth, Seventh Heaven!", "ruka_fc1", 0],
      },
      [1027] => { # 桜花幻舞
        :word_1 => ["\\n<Luka>Falling cherry blossoms, dancing as if a dream...", "ruka_fc1", 0],
      },
      [1028] => { # 天墜
        :word_1 => ["\\n<Luka>Fall... Fall from heaven!", "ruka_fc1", 0],
      },
      [9041] => { # 十四連斬
        :word_1 => ["\\n<Luka>14 consecutive slashes...tee!!", "ruka_fc1", 0],
      },
      [1030] => { # 居合い・伊邪那岐
        :word_1 => ["\\n<Luka>Nagigu is a fresh blade... Iai Izanagi!", "ruka_fc1", 0],
      },
      [1031] => { # 居合い・伊邪那美
        :word_1 => ["\\n<Luka>Nagigu is the blade of death... Iai Izanami!", "ruka_fc1", 0],
      },
      [9044] => { # 修羅の舞い
        :word_1 => ["\\n<Luka>Crazy bloom! The dance of Shura is stained with scattered blood...!", "ruka_fc1", 0],
      },
      [9046] => { # 終ノ閃
        :word_1 => ["\\n<Luka>Crush into nothingness, the final flash...", "ruka_fc1", 0],
      },
      [9045] => { # 神祖烈星斬
        :word_1 => ["\\n<Luka>Cuts off the stars, God Ancestor Retsuseizan!", "ruka_fc1", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Luka>By the pride of the white blade!", "ruka_fc1", 0],
      },
      [1032] => { # 心頭滅却
        :word_1 => ["\\n<Luka>Clear your mind, and even fire can feel cool...", "ruka_fc1", 0],
      },
      [1033] => { # 肉斬骨断
        :word_1 => ["\\n<Luka>I'll cut your flesh and carve your bones! Now come on!", "ruka_fc1", 0],
      },
      [1034] => { # 切り捨て御免
        :word_1 => ["\\n<Luka>Now...to exercise my right to kill!", "ruka_fc1", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Luka>With grace...!", "ruka_fc1", 0],
      },
      [1037] => { # 則天去私
        :word_1 => ["\\n<Luka>This heart is my state...", "ruka_fc1", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Luka>Pierce, the hero's spear!", "ruka_fc1", 0],
      },
      [1052] => { # レクイエムランス
        :word_1 => ["\\n<Luka>Enemies of the Goddess deserve only a merciless burial! Slay the darkness! Requiem Lance!", "ruka_fc1", 0],
      },
      [1060] => { # サン・エリアル
        :word_1 => ["\\n<Luka>Spear of the Goddess, drive back the relentless evil! Sun Aerial!", "ruka_fc1", 0],
      },
      [1063] => { # サン・ミラージュ
        :word_1 => ["\\n<Luka>Spear of the Goddess, exemplify your justice by piercing evil! Sun Mirage!", "ruka_fc1", 0],
      },
      [1075] => { # 螺旋光槍
        :word_1 => ["\\n<Luka>Spear of spiraling light, pierce through the wicked darkness! Spiral Light Spear!", "ruka_fc1", 0],
      },
      [1076] => { # 滅魔閃槍
        :word_1 => ["\\n<Luka>Spear flash that pierces darkness, unleash destruction upon all evil! Demon Destruction Flash!", "ruka_fc1", 0],
      },
      [1077] => { # フォトンランサー
        :word_1 => ["\\n<Luka>Shatter evil, holy photons!\nPhoton Lancer!", "ruka_fc1", 0],
      },
      [1078] => { # ニーベルンヴァレスティ
        :word_1 => ["\\n<Luka>I'll engrave the secret technique of righteousness upon your body! Nibelung Valesti!", "ruka_fc1", 0],
      },
      [9054] => { # スターダストエンド
        :word_1 => ["\\n<Luka>Break, stardust! Stardust End!", "ruka_fc1", 0],
      },
      [9059] => { # 天軍乱槍
        :word_1 => ["\\n<Luka>This is the spear technique of the leader of the Heavenly Army... the Tengun Ranspear!", "ruka_fc1", 0],
      },
      [1085] => { # 祈りの聖槍
        :word_1 => ["\\n<Luka>I pray upon this spear...", "ruka_fc1", 0],
      },
      [1086] => { # 奇跡の聖槍
        :word_1 => ["\\n<Luka>Oh Ilias, bring us a miracle with this sacred spear!", "ruka_fc1", 0],
      },
      [1087] => { # 聖槍チャージ
        :word_1 => ["\\n<Luka>Sacred spear, grant us the power to eradicate evil!", "ruka_fc1", 0],
      },
      [1088] => { # 聖槍ガード
        :word_1 => ["\\n<Luka>Sacred spear, grant us a wall of divine protection!", "ruka_fc1", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Luka>Power charge... Haa!", "ruka_fc1", 0],
      },
      [1092] => { # ハイチャージ
        :word_1 => ["\\n<Luka>Power charge... Haa!", "ruka_fc1", 0],
      },
      [1093] => { # エクセルチャージ
        :word_1 => ["\\n<Luka>Full power charge... Haa!", "ruka_fc1", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Luka>Desolation, the hero's axe!", "ruka_fc1", 0],
      },
      [1112] => { # 壊斧・大山鳴動
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Lend me your strength, Gnome! Earth Rumbling Decapitation!!", "ruka_fc1", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Luka>Go wild, axe!", "ruka_fc1", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Luka>Let's go, club handling inherited from Sonya!", "ruka_fc1", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Luka>Sickle, cut away evil!", "ruka_fc1", 0],
      },
      [1158] => { # 連斬かまいたち
        :word_1 => ["\\n<Luka>Slash and tear, whirlwind sickle... \n consecutive slashes!", "ruka_fc1", 0],
      },
      [1169] => { # 死連刃
        :word_1 => ["\\n<Luka>The blades of annihilation overlap each other, carving and dividing the number of lives!", "ruka_fc1", 0],
      },
      [1170] => { # レクイエムリーパー
        :word_1 => ["\\n<Luka>You are invited to the requiem, and you should scatter...", "ruka_fc1", 0],
      },
      [9078] => { # 魔神黒鎌
        :word_1 => ["\\n<Luka>The devil's sickle combs the soul...!", "ruka_fc1", 0],
      },
      [9080] => { # エンドレスサイズ
        :word_1 => ["\\n<Luka>Endless flash of sickle...endless size!", "ruka_fc1", 0],
      },
      [9083] => { # エンドオブエンド
        :word_1 => ["\\n<Luka>This is the ultimate end...!", "ruka_fc1", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Luka>This is the power of a Scythe...!", "ruka_fc1", 0],
      },
      [9081] => { # 罪と罰
        :word_1 => ["\\n<Luka>Dust is dust, crime and punishment...!", "ruka_fc1", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Luka>Pierce, arrow of the hero!", "ruka_fc1", 0],
      },
      [1196] => { # キューピッドアロー
        :word_1 => ["\\n<Luka>Aim for the heart!\nCupid's Arrow!", "ruka_fc1", 0],
      },
      [1197] => { # オーラスター
        :word_1 => ["\\n<Luka>Be dazzled by the holy arrow of the stars!\nAura Star!", "ruka_fc1", 0],
      },
      [1217] => { # ネビュラリフレクト
        :word_1 => ["\\n<Luka>Pierce through, starlight arrow!\nNebula Reflect!", "ruka_fc1", 0],
      },
      [1218] => { # コズミックダスト
        :word_1 => ["\\n<Luka>Rain down from the cosmos!\nCosmic Dust!", "ruka_fc1", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Luka>Rain, healing arrows!", "ruka_fc1", 0],
      },
      [9098] => { # サウザンドムーン
        :word_1 => ["\\n<Luka>Pierce, thousands of lights...thousand moon!", "ruka_fc1", 0],
      },
      [9088] => { # アモールレイン
        :word_1 => ["\\n<Luka>Rain down, great arrows of love... Amor Rain!", "ruka_fc1", 0],
      },
      [9100] => { # シナイの神火
        :word_1 => ["\\n<Luka>The divine flame that consumes evil...the divine fire of Sinai!", "ruka_fc1", 0],
      },
      [9099] => { # イスカリオテの雨
        :word_1 => ["\\n<Luka>It's raining, Iscariot's rain!", "ruka_fc1", 0],
      },
      [9101] => { # 天上天下唯我独尊
        :word_1 => ["\\n<Luka>Lady Ilias's technique...!", "ruka_fc1", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Luka>Strike the darkness with the whip of justice!", "ruka_fc1", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Luka>Come, servant!", "ruka_fc1", 0],
      },
      [9114] => { # 黙示の神鞭
        :word_1 => ["\\n<Luka>Take the whip of the end upon yourself...!", "ruka_fc1", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Luka>It's a boomerang! Hey!", "ruka_fc1", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Luka>Oh! Let's go!", "ruka_fc1", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Luka>Fan, dance!", "ruka_fc1", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Luka>Aim and shoot...!", "ruka_fc1", 0],
      },
      [9147] => { # 跳弾乱舞
        :word_1 => ["\\n<Luka>Let's go, Ricochet Rainstorm...!", "ruka_fc1", 0],
      },
      [9149] => { # 至高の魔弾
        :word_1 => ["\\n<Luka>The supreme magic bullet that pierces everything...!", "ruka_fc1", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Luka>Don't worry, it's a healing bullet!", "ruka_fc1", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc1", 0],
      },
      [1374] => { # ミックスゲイズ
        :word_1 => ["\\n<Luka>With blade and fist combined!", "ruka_fc1", 0],
      },
      [1377] => { # クレイジータイム
        :word_1 => ["\\n<Luka>Take a shower of blades and fists! Crazy Time!", "ruka_fc1", 0],
      },
      [1381] => { # ツインオプティック
        :word_1 => ["\\n<Luka>The endless blade that mowing down...Twin Optic!", "ruka_fc1", 0],
      },
      [1382] => { # アームドインフェルノ
        :word_1 => ["\\n<Luka>Look at the hell of the \n blade...Armed Inferno!", "ruka_fc1", 0],
      },
      [1383] => { # アサルトランタイム
        :word_1 => ["\\n<Luka>The secret of the fist blade... Assault run time!", "ruka_fc1", 0],
      },
      [1387] => { # サウザンドブレイド
        :word_1 => ["\\n<Luka>Dance to a thousand blades...Thousand Blades!", "ruka_fc1", 0],
      },
      [1390] => { # マキシマムランタイム
        :word_1 => ["\\n<Luka>Dance, the final blade storm... Maximum Runtime!", "ruka_fc1", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Luka>I'll slice you with a blade in each hand!", "ruka_fc1", 0],
      },
      [1393] => { # セカンドシフト
        :word_1 => ["\\n<Luka>I'll slice you with a blade in each hand!", "ruka_fc1", 0],
      },
      [1394] => { # サードシフト
        :word_1 => ["\\n<Luka>Look closely, a storm of blades!", "ruka_fc1", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc1", 0],
      },
      [1400] => { # 足払い
        :word_1 => ["\\n<Luka>An opening! Leg sweep!", "ruka_fc1", 0],
      },
      [1401] => { # 飛び膝蹴り
        :word_1 => ["\\n<Luka>I got you! Flying Knee Kick!", "ruka_fc1", 0],
      },
      [1402] => { # 回し蹴り
        :word_1 => ["\\n<Luka>Kick them all away! Roundhouse!", "ruka_fc1", 0],
      },
      [1403] => { # 秘孔
        :word_1 => ["\\n<Luka>I see it! Pressure Point!", "ruka_fc1", 0],
      },
      [1405] => { # 正拳突き
        :word_1 => ["\\n<Luka>Gather my spirit and... Fist Thrust!", "ruka_fc1", 0],
      },
      [1406] => { # 羅刹掌
        :word_1 => ["\\n<Luka>Now, become one with the rakshasa! Rakshasa Palm!", "ruka_fc1", 0],
      },
      [1407] => { # 爆裂拳
        :word_1 => ["\\n<Luka>An explosive fist that can't be stopped!", "ruka_fc1", 0],
      },
      [1408] => { # 電塵連脚
        :word_1 => ["\\n<Luka>Lightning legs that can't be stopped by the eyes!", "ruka_fc1", 0],
      },
      [1425] => { # 聖光裂閃撃
        :word_1 => ["\\n<Luka>Gleam, white flash! Light Rending Fist!", "ruka_fc1", 0],
      },
      [1426] => { # 暗黒連衝拳
        :word_1 => ["\\n<Luka>Engrave, black shock! Dark Onslaught Fist!", "ruka_fc1", 0],
      },
      [1427] => { # 四天光掌
        :word_1 => ["\\n<Luka>Quad Heaven Palm, tear across the shining heavens!", "ruka_fc1", 0],
      },
      [1428] => { # 四星滅功
        :word_1 => ["\\n<Luka>Four Strike Star Destruction, bloom in the dark sky!", "ruka_fc1", 0],
      },
      [1429] => { # 烈気光掌
        :word_1 => ["\\n<Luka>A single blow to shake even the heavens... Spirit Palm!", "ruka_fc1", 0],
      },
      [1430] => { # 瞬獄殺
        :word_1 => ["\\n<Luka>All life must perish...", "ruka_fc1", 0],
      },
      [9163] => { # 破滅の鉄槌
        :word_1 => ["\\n<Luka>The judgment of the fist... the hammer of destruction!", "ruka_fc1", 0],
      },
      [9156] => { # 零拳
        :word_1 => ["\\n<Luka>Scattered, sub-zero freezing fist... Zero fist!", "ruka_fc1", 0],
      },
      [9165] => { # 聖天轟裂撃
        :word_1 => ["\\n<Luka>Breath of white light... Holy Heaven's roar ruptures!", "ruka_fc1", 0],
      },
      [9166] => { # 魔天冥煌撃
        :word_1 => ["\\n<Luka>The breath of darkness... Demon heaven's glittering attack!", "ruka_fc1", 0],
      },
      [9167] => { # 覆滅陰陽撃
        :word_1 => ["\\n<Luka>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "ruka_fc1", 0],
      },
      [9171] => { # アトミックインパクト
        :word_1 => ["\\n<Luka>I'll crush you with one shot...Atomic Impact!", "ruka_fc1", 0],
      },
      [9173] => { # 天地開闢拳
        :word_1 => ["\\n<Luka>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "ruka_fc1", 0],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Luka>....................", "ruka_fc1", 0],
      },
      [1434] => { # 当て身光掌（発動）
        :word_1 => ["\\n<Luka>I received \n... Atemi Kosho!", "ruka_fc1", 0],
      },
      [1435] => { # 金剛八連拳
        :word_1 => ["\\n<Luka>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "ruka_fc1", 0],
      },
      [1436] => { # 紅蓮大拳舞
        :word_1 => ["\\n<Luka>Dance in disorder, crimson flame! Guren Daikenbu!", "ruka_fc1", 0],
      },
      [9157] => { # 電塵乱皇脚
        :word_1 => ["\\n<Luka>flash, noble thunder! Denjinran Kokyaku!", "ruka_fc1", 0],
      },
      [9159] => { # 真・瞬獄殺
        :word_1 => ["\\n<Luka>The living will be destroyed, all things will be destroyed...", "ruka_fc1", 0],
      },
      [9164] => { # 修羅爆裂拳
        :word_1 => ["\\n<Luka>Shura's fist hits wildly! Yay!!", "ruka_fc1", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Luka>Heal, pulse of the heavens... Chakra!", "ruka_fc1", 0],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Luka>Heal, pulse of the heavens... Chakra!", "ruka_fc1", 0],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Luka>Heal, pulse of the heavens... Diffusive Chakra!", "ruka_fc1", 0],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...the ultimate chakra!", "ruka_fc1", 0],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Luka>Return to life... Ha!", "ruka_fc1", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Luka>Oh magic energy, guide my fists!", "ruka_fc1", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc1", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Luka>Holy light, destroy the darkness!", "ruka_fc1", 0],
      },
      [9188] => { # リリーマルレーン
        :word_1 => ["\\n<Luka>Along with the beautiful lily... Lily Marlane!", "ruka_fc1", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Luka>Holy will, destroy evil! \n Heaven!", "ruka_fc1", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Luka>Light, give me power!", "ruka_fc1", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Luka>Light, prevent the evil power!", "ruka_fc1", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Luka>Light, cancel the blessings of evil!", "ruka_fc1", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Luka>Black torrent, accept my order!", "ruka_fc1", 0],
      },
      [9209] => { # アシェンライト
        :word_1 => ["\\n<Luka>The fallen angel's magical power turns into holy light... \n Turns darkness into light! Ashen Light!", "ruka_fc1", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Luka>Reaper's scythe, lead them to Hades!\nDeath!", "ruka_fc1", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Luka>Torrent of black, heed my call!", "ruka_fc1", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Luka>Healing magic... Eii!", "ruka_fc1", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Luka>At \n, follow me! Yes!", "ruka_fc1", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Luka>The torrent of time breaks through logic and goes wild!", "ruka_fc1", 0],
      },
      [1561] => { # ブラックホール
        :word_1 => ["\\n<Luka>The abyss of space-time, the empty torrent! \n Sink to zero! Black hole!", "ruka_fc1", 0],
      },
      [1562] => { # スーパーノヴァ
        :word_1 => ["\\n<Luka>The end of reincarnation, the time of regression! \nBlink in the galaxy! Supernova!", "ruka_fc1", 0],
      },
      [9231] => { # カオスコメット
        :word_1 => ["\\n<Luka>Chaos meteorite, pour down in heavy rain... \n Chaos comet!", "ruka_fc1", 0],
      },
      [9232] => { # 妖星乱舞
        :word_1 => ["\\n<Luka>Look up, the star of misfortune... Yousei Ranbu!", "ruka_fc1", 0],
      },
      [9236] => { # カオスグラビディ
        :word_1 => ["\\n<Luka>Let the sickle of gravity crush your body! \n Chaos Gravidy!", "ruka_fc1", 0],
      },
      [9239] => { # 天地崩壊
        :word_1 => ["\\n<Luka>Break, world...", "ruka_fc1", 0],
      },
      [9237] => { # カオスメテオ
        :word_1 => ["\\n<Luka>Chaos meteorite, fill the earth with nothingness...", "ruka_fc1", 0],
      },
      [9240] => { # ワンダーランド・ナイトメア
        :word_1 => ["\\n<Luka>It's time to play...Wonderland Nightmare!", "ruka_fc1", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Luka>Time, stop!", "ruka_fc1", 0],
      },
      [1564] => { # カオスタイム
        :word_1 => ["\\n<Luka>Time, stop... Chaos time!", "ruka_fc1", 0],
      },
      [1566] => { # カオスオーバー
        :word_1 => ["\\n<Luka>Time to freeze... Chaos is over!", "ruka_fc1", 0],
      },
      [1567] => { # カオスクロニクル
        :word_1 => ["\\n<Luka>time is mine... Chaos Chronicle!", "ruka_fc1", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Luka>Holy light, dispel the darkness!", "ruka_fc1", 0],
      },
      [1634] => { # 天の雷
        :word_1 => ["\\n<Luka>Righteous fury, become an iron hammer to smite darkness!", "ruka_fc1", 0],
      },
      [1635] => { # 滅魔の雷
        :word_1 => ["\\n<Luka>Iron hammer of lightning, show no mercy to demons! Smite evil as your roaring thunder echoes!", "ruka_fc1", 0],
      },
      [1636] => { # 聖光波
        :word_1 => ["\\n<Luka>Holy light, smite evil and drive away the wicked!", "ruka_fc1", 0],
      },
      [1637] => { # 汚れなき光
        :word_1 => ["\\n<Luka>Purifying light, illuminate the darkness and banish the tainted!", "ruka_fc1", 0],
      },
      [1638] => { # グランドクロス
        :word_1 => ["\\n<Luka>The cross of the Goddess's will shall cleave darkness in twain!", "ruka_fc1", 0],
      },
      [1639] => { # イノセントレーザー
        :word_1 => ["\\n<Luka>Pure soul, pierce the darkness with your innocent heart! Innocent Laser!", "ruka_fc1", 0],
      },
      [1640] => { # イノセントジャッジ
        :word_1 => ["\\n<Luka>Pure judgement, cleanse the darkness!\nInnocent Judge!", "ruka_fc1", 0],
      },
      [1642] => { # 天罰
        :word_1 => ["\\n<Luka>Evil life, destroy it with judgment...!", "ruka_fc1", 0],
      },
      [1643] => { # 魔天回帰
        :word_1 => ["\\n<Luka>All lives, return to Mother Heaven...!", "ruka_fc1", 0],
      },
      [1647] => { # ヤルダバオト
        :word_1 => ["\\n<Luka>Show your holy power and destroy the divine enemy... Yaldabaoth!", "ruka_fc1", 0],
      },
      [1648] => { # カオスメサイア
        :word_1 => ["\\n<Luka>Arrival, the Messiah of Chaos...", "ruka_fc1", 0],
      },
      [1649] => { # 魔神忌光
        :word_1 => ["\\n<Luka>Disappear, the light of the devil...!", "ruka_fc1", 0],
      },
      [9270] => { # 魔神輝光
        :word_1 => ["\\n<Luka>Disappear, the shining light of the devil...!", "ruka_fc1", 0],
      },
      [9280] => { # 真・魔神輝光
        :word_1 => ["\\n<Luka>Holy element condensation...! \n Disappear, the brilliant light of the demon god...!", "ruka_fc1", 0],
      },
      [9269] => { # リブラ・レイ
        :word_1 => ["\\n<Luka>Shoot through, Holy Light... Libra Ray!", "ruka_fc1", 0],
      },
      [9273] => { # ホーリーフレア
        :word_1 => ["\\n<Luka>Shine the whitest in this world... \n Holy Flare!", "ruka_fc1", 0],
      },
      [9274] => { # 明けの明星
        :word_1 => ["\\n<Luka>....................", "ruka_fc1", 0],
      },
      [9275] => { # 発動：明けの明星
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc1", 0],
      },
      [9277] => { # 明星魔煌
        :word_1 => ["\\n<Luka>....................", "ruka_fc1", 0],
      },
      [9278] => { # 明星魔煌
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc1", 0],
      },
      [9283] => { # 聖天兎々
        :word_1 => ["\\n<Luka>Travelers of time and space, announce the sacred time... Holy Heavenly Rabbits!", "ruka_fc1", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc1", 0],
      },
      [9281] => { # 裁きの雷
        :word_1 => ["\\n<Luka>Receive the thunder of divine will...!", "ruka_fc1", 0],
      },
      [9282] => { # ビッグバン
        :word_1 => ["\\n<Luka>Everything ends and then begins...Big Bang!", "ruka_fc1", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc1", 0],
      },
      [9285] => { # ジャッジメント
        :word_1 => ["\\n<Luka>The promised land rejects you. \n In the hands of this judge, the execution will be carried out...", "ruka_fc1", 0],
      },
      [9268] => { # 聖天
        :word_1 => ["\\n<Luka>Look up at the glorious holy heavens...!", "ruka_fc1", 0],
      },
      [9271] => { # 天軍滅雷
        :word_1 => ["\\n<Luka>Destroy in the name of the leader of the angel army... the thunder of judgment!", "ruka_fc1", 0],
      },
      [9279] => { # 神の洪水
        :word_1 => ["\\n<Luka>It's a flood that will cleanse the world...!", "ruka_fc1", 0],
      },
      [9291] => { # ガブリエラの大祝福
        :word_1 => ["\\n<Luka>This is the ultimate blessing...!", "ruka_fc1", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Luka>Holy light, bring healing!", "ruka_fc1", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Luka>Dedicate your life and drive away the darkness!", "ruka_fc1", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Luka>Valiant souls, breathe once more!", "ruka_fc1", 0],
      },
      [1668] => { # 夢幻天舞
        :word_1 => ["\\n<Luka>The clear mirror, the dawn, the dreamlike heavenly dance...!", "ruka_fc1", 0],
      },
      [1669] => { # 堕天舞踏
        :word_1 => ["\\n<Luka>Uncut and infallible, Fallen Dance...!", "ruka_fc1", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Luka>....................", "ruka_fc1", 0],
      },
      [9272] => { # 聖雷輪舞
        :word_1 => ["\\n<Luka>Rotate divine punishment, dance holy lightning...!", "ruka_fc1", 0],
      },
      [9276] => { # アトミックヘブン
        :word_1 => ["\\n<Luka>Blow everything away, Atomic Heaven!", "ruka_fc1", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Luka>Darkness, roar...!", "ruka_fc1", 0],
      },
      [1675] => { # ダークエターナル
        :word_1 => ["\\n<Luka>The black of the end, fill the darkness...Dark Eternal!", "ruka_fc1", 0],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Luka>In the hour of darkness, cherry blossoms scatter in the dance of flames... \n Tremble to sleep, Majin Flame Dance!", "ruka_fc1", 0],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Luka>In the hour of darkness, being sent and dying is the work of the demon ice... \n Tremble and sleep, the demon ice funeral!", "ruka_fc1", 0],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Luka>In the hour of darkness, a voice cries out in the thunder dust... \n Tremble and sleep, demon thunder dust!", "ruka_fc1", 0],
      },
      [1680] => { # 魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the ultimate demonic moment... \n Reach the darkness, the demon black palm!", "ruka_fc1", 0],
      },
      [1681] => { # ネクローシス
        :word_1 => ["\\n<Luka>Chaos is the root, and the world will return to chaos... \n Necrosis...", "ruka_fc1", 0],
      },
      [1682] => { # アポトーシス
        :word_1 => ["\\n<Luka>Mix ■■ returns ■■■■■ is ■■■... \n appointment ■■...", "ruka_fc1", 0],
      },
      [1685] => { # カオスエクリプス
        :word_1 => ["\\n<Luka>Arrival, the eclipse of chaos...", "ruka_fc1", 0],
      },
      [1686] => { # 魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n Dance in the foam, the phantom dance of the demon!", "ruka_fc1", 0],
      },
      [1687] => { # ハルマゲドン
        :word_1 => ["\\n<Luka>The moment when light and darkness end... Armageddon!", "ruka_fc1", 0],
      },
      [1688] => { # 真・魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the demonic pole... \n Perish in the darkness, the true demon black palm!", "ruka_fc1", 0],
      },
      [1691] => { # 真・魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n End in foam, the true demon phantom dance!", "ruka_fc1", 0],
      },
      [1689] => { # シャドウフレア
        :word_1 => ["\\n<Luka>Shine the blackest in this world... \n Shadow Flare!", "ruka_fc1", 0],
      },
      [1694] => { # アンリ・マンユ
        :word_1 => ["\\n<Luka>Henri Mainyu, the hour of darkness has arrived...", "ruka_fc1", 0],
      },
      [9298] => { # ワールドブレイカー
        :word_1 => ["\\n<Luka>Destroy this world...", "ruka_fc1", 0],
      },
      [9294] => { # システム：シルフV2
        :ct_pic => "80_sylph_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>System: Sylph V2... Storm!", "ruka_fc1", 0],
      },
      [9295] => { # ノーム/ガイアGH
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Gnome/Gaia GH launches...shake the earth!", "ruka_fc1", 0],
      },
      [9296] => { # ウンディーネレーザー穿式
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Penetrate! Undine laser piercing type!", "ruka_fc1", 0],
      },
      [9297] => { # サラマンダー終式カノン
        :ct_pic => "80_salamander_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Salamander, burn this world to the ground!", "ruka_fc1", 0],
      },
      [9542] => { # 最後の魔眼
        :word_1 => ["\\n<Luka>Open up, the last evil eye...", "ruka_fc1", 0],
      },
      [2558] => { # 王者の魔眼
        :word_1 => ["\\n<Luka>This is the evil eye of the champion...", "ruka_fc1", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc1", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Luka>Residing in the sword, magical power!", "ruka_fc1", 0],
      },
      [1698] => { # 魔法剣ファイア
        :word_1 => ["\\n<Luka>Imbue my sword, power of fire!", "ruka_fc1", 0],
      },
      [1699] => { # 魔法剣ブリザード
        :word_1 => ["\\n<Luka>Imbue my sword, power of ice!", "ruka_fc1", 0],
      },
      [1700] => { # 魔法剣サンダー
        :word_1 => ["\\n<Luka>Imbue my sword, power of lightning!", "ruka_fc1", 0],
      },
      [1701] => { # 魔法剣ウィンド
        :word_1 => ["\\n<Luka>Imbue my sword, power of wind!", "ruka_fc1", 0],
      },
      [1702] => { # 魔法剣アース
        :word_1 => ["\\n<Luka>Imbue my sword, power of earth!", "ruka_fc1", 0],
      },
      [1703] => { # 魔法剣アクア
        :word_1 => ["\\n<Luka>Imbue my sword, power of water!", "ruka_fc1", 0],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<Luka>Imbue my sword, holy power!", "ruka_fc1", 0],
      },
      [1705] => { # 魔法剣ダーク
        :word_1 => ["\\n<Luka>Imbue my sword, power of darkness!", "ruka_fc1", 0],
      },
      [1706] => { # 魔法剣ポイズン
        :word_1 => ["\\n<Luka>Imbue my sword, poison magic!", "ruka_fc1", 0],
      },
      [1707] => { # 魔法剣ブライン
        :word_1 => ["\\n<Luka>Imbue my sword, darkness magic!", "ruka_fc1", 0],
      },
      [1708] => { # 魔法剣サイレンス
        :word_1 => ["\\n<Luka>Imbue my sword, silence magic!", "ruka_fc1", 0],
      },
      [1709] => { # 魔法剣パラライズ
        :word_1 => ["\\n<Luka>Imbue my sword, paralysis magic!", "ruka_fc1", 0],
      },
      [1710] => { # 魔法剣コンフューズ
        :word_1 => ["\\n<Luka>Imbue my sword, confusion magic!", "ruka_fc1", 0],
      },
      [1711] => { # 魔法剣スリープ
        :word_1 => ["\\n<Luka>Imbue my sword, sleep magic!", "ruka_fc1", 0],
      },
      [1712] => { # 魔法剣デス
        :word_1 => ["\\n<Luka>Imbue my sword, death magic!", "ruka_fc1", 0],
      },
      [1713] => { # 魔法剣ヘブン
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of ascension!", "ruka_fc1", 0],
      },
      [1714] => { # 魔法剣ドレイン
        :word_1 => ["\\n<Luka>Imbue my sword, drain magic!", "ruka_fc1", 0],
      },
      [1715] => { # 魔法剣マドレイン
        :word_1 => ["\\n<Luka>Residing in the sword, the magical power of absorption!", "ruka_fc1", 0],
      },
      [1718] => { # 魔法剣カーズ
        :word_1 => ["\\n<Luka>Residing in the sword, cursed magic!", "ruka_fc1", 0],
      },
      [1716] => { # マジックバリア
        :word_1 => ["\\n<Luka>Protect my allies from evil spells! Magic Barrier!", "ruka_fc1", 0],
      },
      [1717] => { # マジックリフレクト
        :word_1 => ["\\n<Luka>Heavenly blessing, turn the land into a magical mirror! Magic Reflect!", "ruka_fc1", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Luka>It's a Yin-Yang... Hey!", "ruka_fc1", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Luka>The secret of exorcism, the prison of rebellion! \nKnow the reward, Nine Souls Exorcism Formation!", "ruka_fc1", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Luka>A lifetime, sending it is life! \n Engraving the slightest bit...Singing life!", "ruka_fc1", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Luka>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "ruka_fc1", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Luka>I got \n!", "ruka_fc1", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Luka>Proof of a thief!", "ruka_fc1", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Luka>R-run away!", "ruka_fc1", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Luka>Actually, when I was little, I admired ninjas... Yay!", "ruka_fc1", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Luka>Wave of healing, spread a thousand ways...\nNinja Art: Healing Wave!", "ruka_fc1", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Luka>Empty cicada shells of autumn, dancing like shadows... Ninja Art: Doppelganger!", "ruka_fc1", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Luka>Smoke Screen!", "ruka_fc1", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Luka>It's a pirate technique! Yay!", "ruka_fc1", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Luka>This is justice! Ha!", "ruka_fc1", 0],
      },
      [1842] => { # 正義のファイヤーパンチ
        :word_1 => ["\\n<Luka>My fist of justice burns! Buuuuuurningggggg... Punch!", "ruka_fc1", 0],
      },
      [1843] => { # 正義のブリザードナックル
        :word_1 => ["\\n<Luka>Sparkle, my fist of justice! Freezingggggg... Punch!", "ruka_fc1", 0],
      },
      [1844] => { # 正義のサンダーキック
        :word_1 => ["\\n<Luka>Flash, my fist of justice! Shockinggggg... Punch!", "ruka_fc1", 0],
      },
      [1845] => { # ヒーロー乱舞
        :word_1 => ["\\n<Luka>This is my fist of justice! Haaaaa!", "ruka_fc1", 0],
      },
      [1846] => { # カイザーキック
        :word_1 => ["\\n<Luka>Love and justice... Kaiser kick!", "ruka_fc1", 0],
      },
      [1847] => { # カイザーファイナルソード
        :word_1 => ["\\n<Luka>Kaiser Final Sword of courage and victory!", "ruka_fc1", 0],
      },
      [1848] => { # カイザークライマックスキック
        :word_1 => ["\\n<Luka>Roar justice, shine victory! \nThis is the last Kaiser climax kick!!", "ruka_fc1", 0],
      },
      [1849] => { # ヒーローガッツ
        :word_1 => ["\\n<Luka>No matter how injured... No matter how tired... My soul of justice... Shall never fail!", "ruka_fc1", 0],
      },
      [1850] => { # カイザーリフレイン
        :word_1 => ["\\n<Luka>An unbreakable heart... Kaiser Refrain!", "ruka_fc1", 0],
      },
      [1851] => { # カイザーバリア
        :word_1 => ["\\n<Luka>Wall of Justice... Kaiser Barrier!", "ruka_fc1", 0],
      },
      [1857] => { # エクセルラッシュ
        :word_1 => ["\\n<Luka>Roar, the cry of justice! Excel Rush!", "ruka_fc1", 0],
      },
      [1858] => { # エクセルジエンド
        :word_1 => ["\\n<Luka>Infinite courage and endless victory! \n Penetrating justice...Excelge End!", "ruka_fc1", 0],
      },
      [1859] => { # エクセルシオール
        :word_1 => ["\\n<Luka>I will fight for the weak!! \n This is the proof of justice... Excelsior!", "ruka_fc1", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Luka>I can't believe I'm a magical girl... Yeah☆", "ruka_fc1", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Luka>I'll do something with the power of money...", "ruka_fc1", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Luka>Okay, I bought it!", "ruka_fc1", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Luka>Bring out the power of \nItem beyond its limits!", "ruka_fc1", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc1", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Luka>When it comes to coins, I won't lose!", "ruka_fc1", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Luka>Now, let's play a game of darkness with me!", "ruka_fc1", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Luka>Pull out a tarot card... Eii!", "ruka_fc1", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Luka>Ilias, please guide me...", "ruka_fc1", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Luka>Turn the slots...Eii!", "ruka_fc1", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Luka>Play poker with me!", "ruka_fc1", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Luka>Battle card, draw!", "ruka_fc1", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Luka>The power contained in the playing cards...!", "ruka_fc1", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Luka>Today's my lucky day...", "ruka_fc1", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Luka>It's always my turn!", "ruka_fc1", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Luka>God, please give me an item...", "ruka_fc1", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Luka>Come on, let's dance!", "ruka_fc1", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Luka>That's it! Hustle! Hustle!", "ruka_fc1", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Luka>I'll have you listen to my song!", "ruka_fc1", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Luka>I can't help it... Kira☆", "ruka_fc1", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Luka>Hey, can I talk to you for a minute?", "ruka_fc1", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Luka>Wow, you are so amazing!", "ruka_fc1", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Luka>I'm not scared of you!", "ruka_fc1", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Luka>Excuse me... I'd like some money...", "ruka_fc1", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Luka>Excuse me... I'd like an item...", "ruka_fc1", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Luka>Hey, become my ally!", "ruka_fc1", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Luka>If you keep up this, something awful's going to happen to you...", "ruka_fc1", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Luka>Why don't you just get out of here?", "ruka_fc1", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Luka>And that's when the cat attacked him...", "ruka_fc1", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Luka>And in walked the older sister...", "ruka_fc1", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Luka>As they walked by the gravestone...", "ruka_fc1", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Luka>I know it's cheesy... But I feel grate right now.", "ruka_fc1", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Luka>It's the power of the Spirit of Words... Now, listen to me...", "ruka_fc1", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Luka>Let's go to Luka's exciting laboratory!", "ruka_fc1", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Luka>Now I'm prepared for a crisis!", "ruka_fc1", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Luka>Now, let's convert the energy...", "ruka_fc1", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Luka>I will alchemize \nItem!", "ruka_fc1", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Luka>This is the power of the magic book...!", "ruka_fc1", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Luka>For the pages...", "ruka_fc1", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Luka>Makina activated...Let's go!", "ruka_fc1", 0],
      },
      [2246] => { # ビームデスサイズ
        :word_1 => ["\\n<Luka>Cut into pieces with the \n beam blade!", "ruka_fc1", 0],
      },
      [2250] => { # 反粒子レールガン
        :word_1 => ["\\n<Luka>Disappear...Anti-particle railgun!", "ruka_fc1", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Luka>I'm confident in my cooking skills!", "ruka_fc1", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Luka>Erm... Ingredients...", "ruka_fc1", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc1", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Luka>Calm down, I'll treat you right away!", "ruka_fc1", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Luka>Now, use this medicine... \n Hehe, hehehehehe...", "ruka_fc1", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Luka>An injection! Ya!", "ruka_fc1", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Luka>Things like this are fun... \n Hehe, hehehehehe...", "ruka_fc1", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Luka>Excuse me for a moment...", "ruka_fc1", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Luka>Tea is here...it's homemade by me.", "ruka_fc1", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Luka>Time for some maid service!", "ruka_fc1", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Luka>Is it almost time for the harvest...?", "ruka_fc1", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Luka>This is the king's sword technique!", "ruka_fc1", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Luka>This is the king's magic!", "ruka_fc1", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Luka>Everyone, please lend me your strength!", "ruka_fc1", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Luka>The wicked shall pay!", "ruka_fc1", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Luka>This is the power of a King...!", "ruka_fc1", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Luka>God, please give me a miracle...!", "ruka_fc1", 0],
      },
      [2432] => { # やたらめった斬り
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Kyeehhh!", "ruka_fc1", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc1", 0],
      },
      [2433] => { # 我流ファイア斬
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>I thought this up myself! Flaming Decapitation!", "ruka_fc1", 0],
      },
      [2434] => { # 燃えろ！ぐるぐる斬
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn, my fighting spirit!\nBurn! Spinning Decapitation!", "ruka_fc1", 0],
      },
      [2435] => { # 妖魔斬
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of a Hero shall smite the wicked!", "ruka_fc1", 0],
      },
      [2436] => { # 不死斬
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of a Hero shall return you to death!", "ruka_fc1", 0],
      },
      [2437] => { # 烈火天翔閃
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>My blazing sword shall judge evil! Rising Heavenly Inferno Slash!", "ruka_fc1", 0],
      },
      [2438] => { # 紅蓮廻天斬
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Rage, my crimson blade! Red Lotus Heavenly Cyclone!", "ruka_fc1", 0],
      },
      [2439] => { # 紅蓮炎舞
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance in the flames! Red Lotus Flame Dance!", "ruka_fc1", 0],
      },
      [2440] => { # プラズマブレイク
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dispel the darkness! Plasma break!", "ruka_fc1", 0],
      },
      [2441] => { # シャドウブレイク
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Cut off the light! Shadow Break!", "ruka_fc1", 0],
      },
      [2444] => { # 烈心聖光斬
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade of light, cut off the darkness! Zealous Light Slash!", "ruka_fc1", 0],
      },
      [2431] => { # シャドウラプソディ
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance with the darkness...Shadow Rhapsody!", "ruka_fc1", 0],
      },
      [2442] => { # グランドリオン
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of justice cuts everything! \nWith unwavering faith! Grand Lion!", "ruka_fc1", 0],
      },
      [2443] => { # ヴェルデリオン
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The fighting spirit of darkness destroys the light! \nWith unwavering faith! Veldt Lion!", "ruka_fc1", 0],
      },
      [2445] => { # 天塵剣
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Carve, the blade of heavenly dust...haaah!", "ruka_fc1", 0],
      },
      [2446] => { # アルティメットメサイア
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate salvation... \n Along with light! Ultimate Messiah!", "ruka_fc1", 0],
      },
      [2447] => { # シャドウメサイア
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the implied salvation... \n Dance in the darkness! Shadow Messiah!", "ruka_fc1", 0],
      },
      [2448] => { # エレメント・スピカ
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Put the power of the four spirits into your hands...!", "ruka_fc1", 0],
      },
      [2449] => { # カドラプル・ギガ
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Four spirits, give me power... \n This is the end! Quadruple Giga!!", "ruka_fc1", 0],
      },
      [2450] => { # 烈心天塵剣
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Righteous light, ominous heavenly dust... \n Now is the time to become one! Retsushin Tenjinken!", "ruka_fc1", 0],
      },
      [2451] => { # エンジェルダスト
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Turn angels into dust...Angel dust!", "ruka_fc1", 0],
      },
      [2452] => { # 八夜羅刹斬
        :ct_pic => "80_ruka_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The night of Rakshasa goes around... Eight nights of Rakshasa slash!", "ruka_fc1", 0],
      },
      [2453] => { # 烈心天塵英雄剣
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The ultimate secret of the hero...Resshin Tenjin Hero Sword!", "ruka_fc1", 0],
      },
      [2454] => { # イクスタプル・ゼタ
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The four spirits, the Kirin, and the ice butterfly... \n With everyone's power, EX-tuple Zeta!!", "ruka_fc1", 0],
      },
      [2455] => { # ロゴス・マギア
        :ct_pic => "iv_rukab3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Father of Chaos>■■■■■■■■■■■■......!!", "ruka_fc1", 0],
      },
      [2457] => { # ブレイブウォール
        :ct_pic => "ct_ruka3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the divine protection!", "ruka_fc1", 0],
      },
      [2458] => { # 勇者の号令
        :word_1 => ["\\n<Luka>Everyone, let's go with all our might!", "ruka_fc1", 0],
        :word_2 => ["\\n<Luka>No matter what enemy we are, we can defeat it!", "ruka_fc1", 0],
        :word_3 => ["\\n<Luka>Win this battle and save the world!", "ruka_fc1", 0],
        :word_4 => ["\\n<Luka>Make every battle for the hero!", "ruka_fc1", 0],
        :word_5 => ["\\n<Luka>I will definitely win this battle!", "ruka_fc1", 0],
        :word_6 => ["\\n<Luka>In the name of the hero... everyone, let's go!!", "ruka_fc1", 0],
        :word_7 => ["\\n<Luka>Our struggle will bring us victory!!", "ruka_fc1", 0],
        :word_8 => ["\\n<Luka>Muster up your fighting spirit...let's go!", "ruka_fc1", 0],
        :word_9 => ["\\n<Luka>There's a party tonight!!", "ruka_fc1", 0],
        :word_10 => ["\\n<Luka>Let's go, to gain the glory of victory!", "ruka_fc1", 0],
      },
      [9546] => { # 黎明の魔眼
        :word_1 => ["\\n<Luka>The third eye judges evil... The evil eye of dawn!", "ruka_fc1", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc1", 0],
      },
      [9639] => { # コキュートス
        :word_1 => ["\\n<Luka>Sleep in the eternal ice of the demon world... Cocytus!", "ruka_fc1", 0],
      },
      [9651] => { # 波動砲
        :word_1 => ["\\n<Luka>Disappear...wave motion gun!", "ruka_fc1", 0],
      },
      [9674] => { # 特級神具VIII:アグニカノン
        :word_1 => ["\\n<Luka>Destroy in flames, Agnicanon!", "ruka_fc1", 0],
      },
      [9675] => { # 特級神具IV:メルクリウス
        :word_1 => ["\\n<Luka>Freeze and break, Mercury!", "ruka_fc1", 0],
      },
      [9676] => { # 特級神具V:エクスパルサー
        :word_1 => ["\\n<Luka>Electric shock irradiation, Expulser!", "ruka_fc1", 0],
      },
      [9673] => { # 神具XIII:ユダ
        :word_1 => ["\\n<Luka>Blow away, Judas!", "ruka_fc1", 0],
      },
      [9677] => { # 特級神具IV:ガイアグラビディ
        :word_1 => ["\\n<Luka>Crush it, Gaia Gravidi!!", "ruka_fc1", 0],
      },
      [9678] => { # 特級神具IX:セントフレア
        :word_1 => ["\\n<Luka>Pierce, Saint Flare!!", "ruka_fc1", 0],
      },
      [9679] => { # エンドフルバースト
        :word_1 => ["\\n<Luka>All firearms activated...Endful burst!", "ruka_fc1", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Luka>Are you OK? I know some simple first aid...", "ruka_fc1", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Luka>Oh Ilias, please grant me your blessing!", "ruka_fc1", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Luka>...!", "ruka_fc1", 0],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Luka>Focus my power...!", "ruka_fc1", 0],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Luka>Ohhhhh...!", "ruka_fc1", 0],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Luka>This is my full power...!!", "ruka_fc1", 0],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Luka>This is the final secret...!", "ruka_fc1", 0],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Luka>Focus my mind...", "ruka_fc1", 0],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Luka>Make my body like steel...!", "ruka_fc1", 0],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Luka>The ultimate in concentration, the final effort...", "ruka_fc1", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Luka>With the help of \n Elemental...!", "ruka_fc1", 0],
      },
      [3111] => { # 四精霊同時召喚
        :word_1 => ["\\n<Luka>Come out, Sylph, Gnome, Undine, Salamander... \n Four spirits are summoned at the same time!", "ruka_fc1", 0],
      },
      [3116] => { # 明鏡止水
        :word_1 => ["\\n<Luka>Entrust my mind to the water's flow...", "ruka_fc1", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Luka>Calm down and take a deep breath...", "ruka_fc1", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Luka>Calm down, and use some first aid...", "ruka_fc1", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Luka>This is my way of fighting!", "ruka_fc1", 0],
      },
      [3121] => { # 背水
        :word_1 => ["\\n<Luka>This is my way of fighting!", "ruka_fc1", 0],
      },
      [3123] => { # 究極背水
        :word_1 => ["\\n<Luka>This is the ultimate crisis...!", "ruka_fc1", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Luka>Oohhhhh..!", "ruka_fc1", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :ct_pic => "ct_ruka2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go...!　Hmmmm!!", "ruka_fc1", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Luka>Why am I... Magical☆Henshin ♪", "ruka_fc1", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Luka>Stay still!", "ruka_fc1", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Luka>Time for reinforcements!", "ruka_fc1", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Luka>The power to break!", "ruka_fc1", 0],
      },
      [3132] => { # ウェポンブレイク
        :word_1 => ["\\n<Luka>The power to break...Haa!", "ruka_fc1", 0],
      },
      [3133] => { # アーマーブレイク
        :word_1 => ["\\n<Luka>The power to break defense...Haa!", "ruka_fc1", 0],
      },
      [3134] => { # マジックブレイク
        :word_1 => ["\\n<Luka>The power to break magic...Haa!", "ruka_fc1", 0],
      },
      [3135] => { # マインドブレイク
        :word_1 => ["\\n<Luka>The power to break minds...Haa!", "ruka_fc1", 0],
      },
      [3136] => { # スピードブレイク
        :word_1 => ["\\n<Luka>The power to break speed...Haa!", "ruka_fc1", 0],
      },
      [3137] => { # テクニックブレイク
        :word_1 => ["\\n<Luka>The power to break skills...Haa!", "ruka_fc1", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Luka>Geyser, gush!", "ruka_fc1", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Luka>Don't move! Sit!", "ruka_fc1", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Luka>Hehehe... I'm taking them...", "ruka_fc1", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Luka>Why am I... Se-Sexy Beam...", "ruka_fc1", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Luka>What the heck is this!? Pink Typhoon...", "ruka_fc1", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Luka>It's crap! Fantastic Hurricane♪", "ruka_fc1", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Luka>Now, it's my turn on the stage!", "ruka_fc1", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Luka>All right, today I'm going to work my hardest!", "ruka_fc1", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Luka>Pafupafu... there's no way I can do it!", "ruka_fc1", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Luka>The power of a hidden weapon...!", "ruka_fc1", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Luka>The power of grudge...!", "ruka_fc1", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Luka>...Blitzkrieg!!", "ruka_fc1", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Luka>My grudge...!", "ruka_fc1", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Luka>This is the holy grail miracle!", "ruka_fc1", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Luka>The power of the aura!", "ruka_fc1", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Luka>This is... witchcraft!", "ruka_fc1", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Luka>Huh!", "ruka_fc1", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Luka>I will protect you...!", "ruka_fc1", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Luka>Ahengers...Assemble!!", "ruka_fc1", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Luka>Double up!", "ruka_fc1", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Luka>Next action, order!", "ruka_fc1", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Luka>Concentrate your power on one point...!", "ruka_fc1", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc1", 0],
      },
      [9759] => { # ラストエクリプス
        :word_1 => ["\\n<Luka>Arrival, the final eclipse of chaos...", "ruka_fc1", 0],
      },
      [9760] => { # デスジェネシス
        :word_1 => ["\\n<Luka>The end is the beginning...Death Genesis!", "ruka_fc1", 0],
      },
      [9761] => { # ゼロユニバース
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc1", 0],
      },
      [9762] => { # 反物質対消滅
        :word_1 => ["\\n<Luka>Forbidden power, antimatter versus annihilation...", "ruka_fc1", 0],
      },
      [9763] => { # 次元削除
        :word_1 => ["\\n<Luka>Let's delete this dimension...", "ruka_fc1", 0],
      },
      [9764] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■...", "ruka_fc1", 0],
      },
      [9765] => { # ゼロシフト
        :word_1 => ["\\n<Luka>Bringing equilibrium to chaos...Zero shift!", "ruka_fc1", 0],
      },
      [3285] => { # 誘惑専用
        :word_y1 => ["\\n<Luka>I can't take it... Ahh... Even though I'm in a battle...", "ruka_fc1", 0],
      },
    },
    2 => { # ルカ
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Luka>Hyaah!", "ruka_fc4", 0],
        :word_2 => ["\\n<Luka>Huh!", "ruka_fc4", 0],
        :word_3 => ["\\n<Luka>Hey!", "ruka_fc4", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc4", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc4", 0],
      },
      [917] => { # 切り返し
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>It's a cutback... Yay!", "ruka_fc4", 0],
      },
      [918] => { # 疾風突き
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a wind...Poke!", "ruka_fc4", 0],
      },
      [919] => { # 払車剣
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The sword flashes, like a wheel...Kurumaken!", "ruka_fc4", 0],
      },
      [920] => { # 諸刃斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>I'm ready, it's a double-edged sword!", "ruka_fc4", 0],
      },
      [921] => { # 隼斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a falcon...slash multiple times!", "ruka_fc4", 0],
      },
      [922] => { # 火炎斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take shelter, flame... yay!", "ruka_fc4", 0],
      },
      [923] => { # 氷斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take shelter, ice... Yay!", "ruka_fc4", 0],
      },
      [924] => { # 稲妻斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Stay, lightning... Yay!", "ruka_fc4", 0],
      },
      [930] => { # エンジェルダンス
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade, dance to the heavens... \n Angel dance!", "ruka_fc4", 0],
      },
      [931] => { # 真空斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Vacuum blade... Ha!", "ruka_fc4", 0],
      },
      [932] => { # 烈風剣
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance, blade of fierce wind!　Aaah!!", "ruka_fc4", 0],
      },
      [933] => { # 月影の太刀
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>May dances... Shura's sword!", "ruka_fc4", 0],
      },
      [934] => { # 魔神斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Demon God's blow! Ha!!", "ruka_fc4", 0],
      },
      [935] => { # デッドクラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of destruction brings death...Dead Crash!", "ruka_fc4", 0],
      },
      [936] => { # 二刀十字斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Get close and take a look! Two-sword cross slash!", "ruka_fc4", 0],
      },
      [937] => { # 魔剣・首刈り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Shine, the blade of courage! Magic sword/decapitation!", "ruka_fc4", 0],
      },
      [938] => { # 血裂雷鳴突き
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Tear the darkness and shine the light! Thunder thrust!", "ruka_fc4", 0],
      },
      [942] => { # フレイムスラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn it down, a flash of red... \n Flame Slash!", "ruka_fc4", 0],
      },
      [943] => { # アイススラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Freezing, a flash of blue... \n Ice slash!", "ruka_fc4", 0],
      },
      [944] => { # サンダースラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Knead it down, a flash of yellow... \n Thunder Slash!", "ruka_fc4", 0],
      },
      [945] => { # 斬魔の舞
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The evil blade that destroys demons! \n Dancing in the light is Zanma no Mai!", "ruka_fc4", 0],
      },
      [946] => { # 屠竜撃
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go, the blow that slays the dragon!", "ruka_fc4", 0],
      },
      [947] => { # 雲身払車剣
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Kasumi's blade, like a wheel... Cloud body-wielding Kurumaken!", "ruka_fc4", 0],
      },
      [948] => { # 滅世斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>A dark blade that ends this world... Destruction!", "ruka_fc4", 0],
      },
      [950] => { # 瞬剣・疾風迅雷
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Sylph, give me power...! Shunken: Gale and lightning!", "ruka_fc4", 0],
      },
      [953] => { # 死剣・乱れ星
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Twinkling Meteor Sword Technique...Death Sword, Disturbing Star!", "ruka_fc4", 0],
      },
      [954] => { # 魔影流星斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Look at the dark meteor falling on the earth... Demon Shadow Meteor Slash!", "ruka_fc4", 0],
      },
      [959] => { # ギガスラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate flash... \n Giga Slash!", "ruka_fc4", 0],
      },
      [960] => { # ラウンドオブビリオン
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the miracle of the holy sword...Round of Billion!", "ruka_fc4", 0],
      },
      [961] => { # 月下散華
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Spring dies under the moon... Sanka under the moon!", "ruka_fc4", 0],
      },
      [962] => { # 魔刃・雪時雨
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The endless slash of the Rakshasa...Magic blade, Yuki Shigure!", "ruka_fc4", 0],
      },
      [964] => { # ジャスティスヘブン
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Judgment of justice, execution of divine will... \n Sword of condemnation! Justice Heaven!", "ruka_fc4", 0],
      },
      [965] => { # 閃殺
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The principle of space-time, the severance is my blade of lightning!", "ruka_fc4", 0],
      },
      [966] => { # 烈空堕天斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The sword that fell to the earth, looks up to the sky and tears apart everything! \n Shine in the eastern sky! Split Sky Fallen Slash!", "ruka_fc4", 0],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Fast like a gale, fast like thunder...! \n Instant strike, gale of thunder!", "ruka_fc4", 0],
      },
      [969] => { # 諸刃微塵斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Even if this body decays... it's a double-edged sword!", "ruka_fc4", 0],
      },
      [973] => { # アトミックスラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase \n, a flash of nuclear heat... Atomic Slash!", "ruka_fc4", 0],
      },
      [974] => { # クァンタスラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of quantum... Quantus Slash!", "ruka_fc4", 0],
      },
      [975] => { # イオンスラッシュ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of atoms... ion slash!", "ruka_fc4", 0],
      },
      [9009] => { # ギガスラッシュクロス
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Double flash! Giga Slash Cross!", "ruka_fc4", 0],
      },
      [9013] => { # 九重の羅刹
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Rakshasa's jaw gate has defeated the army and banished evil!", "ruka_fc4", 0],
      },
      [9022] => { # 天軍の剣
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc4", 0],
      },
      [9023] => { # 天軍滅星
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc4", 0],
      },
      [9016] => { # 乱れ雪月花
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Snow dance...moon shadow...flowers and scattering...!", "ruka_fc4", 0],
      },
      [971] => { # 聖光六閃斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Catch \n, a continuous attack of light... Six flashes of holy light!", "ruka_fc4", 0],
      },
      [970] => { # メギドカリバーン
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>mowing down with the wave of darkness! Megiddo Caliburn!", "ruka_fc4", 0],
      },
      [9014] => { # メギドカブラ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate mystery of the magic sword! Megidokabura!", "ruka_fc4", 0],
      },
      [976] => { # 癒しの剣
        :word_1 => ["\\n<Luka>Healing sword, God's blessings!", "ruka_fc4", 0],
      },
      [977] => { # 奇跡の剣
        :word_1 => ["\\n<Luka>Miraculous sword, divine protection!", "ruka_fc4", 0],
      },
      [978] => { # 大奇跡の剣
        :word_1 => ["\\n<Luka>Healing sword, God's miracle!", "ruka_fc4", 0],
      },
      [979] => { # 超奇跡の剣
        :word_1 => ["\\n<Luka>Super miraculous sword, great healing!", "ruka_fc4", 0],
      },
      [972] => { # 闇天
        :word_1 => ["\\n<Luka>The blade of Shura that cuts everything...Dark Heaven!", "ruka_fc4", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Luka>Let's go, Rapier of Justice! Ha!", "ruka_fc4", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Luka>Stake your pride on this blade!", "ruka_fc4", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Luka>A flash with this blade... Hey!", "ruka_fc4", 0],
      },
      [1007] => { # 峰打ち
        :word_1 => ["\\n<Luka>I'll make you sleep...Mineuchi!", "ruka_fc4", 0],
      },
      [1008] => { # 三連斬
        :word_1 => ["\\n<Luka>Repeated carving, triple slash!", "ruka_fc4", 0],
      },
      [1009] => { # 居合い抜き
        :word_1 => ["\\n<Luka>Cut off with a single sword! Iainuki!", "ruka_fc4", 0],
      },
      [1010] => { # 牙突
        :word_1 => ["\\n<Luka>Penetrate everything! Fangs!", "ruka_fc4", 0],
      },
      [1011] => { # 居合い・焔ノ太刀
        :word_1 => ["\\n<Luka>Burn it down, the Crimson Blade! Homura no Tachi!", "ruka_fc4", 0],
      },
      [1012] => { # 居合・吹雪ノ太刀
        :word_1 => ["\\n<Luka>Freezing, extremely cold blade! Fubuki no Tachi!", "ruka_fc4", 0],
      },
      [1013] => { # 居合・雷土ノ太刀
        :word_1 => ["\\n<Luka>Flash, the blade of lightning! Raito no Tachi!", "ruka_fc4", 0],
      },
      [1018] => { # 滅魂刀
        :word_1 => ["\\n<Luka>I will destroy that soul... ha!", "ruka_fc4", 0],
      },
      [1019] => { # 斬神斬魔
        :word_1 => ["\\n<Luka>Cut off the gods and destroy the demons...!", "ruka_fc4", 0],
      },
      [1022] => { # 縮地・焔閃
        :word_1 => ["\\n<Luka>A flash of a blade like a blink of an eye... Shrinkage, flame flash!", "ruka_fc4", 0],
      },
      [1023] => { # 魔刀・明鏡止水
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Follow the flow of water...Magic sword, Myokyo water stop!", "ruka_fc4", 0],
      },
      [1024] => { # 神刀・鏡花水月
        :word_1 => ["\\n<Luka>Clear, pure flash... Divine sword Kyoka Suigetsu!", "ruka_fc4", 0],
      },
      [1025] => { # 微塵滅閃
        :word_1 => ["\\n<Luka>The devil's blade is carved into fine dust... A fine flash!", "ruka_fc4", 0],
      },
      [1026] => { # 聖刃七星天
        :word_1 => ["\\n<Luka>I look up and see the Seven Pole Stars... \n Twinkle in the heavens and earth, the Holy Blade Seven Stars of Heaven!", "ruka_fc4", 0],
      },
      [1027] => { # 桜花幻舞
        :word_1 => ["\\n<Luka>The cherry blossoms are falling, the dancing is a dream...", "ruka_fc4", 0],
      },
      [1028] => { # 天墜
        :word_1 => ["\\n<Luka>Fall... Fall from heaven!", "ruka_fc4", 0],
      },
      [9041] => { # 十四連斬
        :word_1 => ["\\n<Luka>14 consecutive slashes...tee!!", "ruka_fc4", 0],
      },
      [1030] => { # 居合い・伊邪那岐
        :word_1 => ["\\n<Luka>Nagigu is a fresh blade... Iai Izanagi!", "ruka_fc4", 0],
      },
      [1031] => { # 居合い・伊邪那美
        :word_1 => ["\\n<Luka>Nagigu is the blade of death... Iai Izanami!", "ruka_fc4", 0],
      },
      [9044] => { # 修羅の舞い
        :word_1 => ["\\n<Luka>Crazy bloom! The dance of Shura is stained with scattered blood...!", "ruka_fc4", 0],
      },
      [9046] => { # 終ノ閃
        :word_1 => ["\\n<Luka>Crush into nothingness, the final flash...", "ruka_fc4", 0],
      },
      [9045] => { # 神祖烈星斬
        :word_1 => ["\\n<Luka>Cuts off the stars, God Ancestor Retsuseizan!", "ruka_fc4", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Luka>By the pride of the white blade!", "ruka_fc4", 0],
      },
      [1032] => { # 心頭滅却
        :word_1 => ["\\n<Luka>My heart is lost, fire is also cool...", "ruka_fc4", 0],
      },
      [1033] => { # 肉斬骨断
        :word_1 => ["\\n<Luka>Cut the flesh and cut the bones! Here we go!", "ruka_fc4", 0],
      },
      [1034] => { # 切り捨て御免
        :word_1 => ["\\n<Luka>Now... I'm sorry for cutting it off!", "ruka_fc4", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Luka>Be honest here...!", "ruka_fc4", 0],
      },
      [1037] => { # 則天去私
        :word_1 => ["\\n<Luka>This heart is my state...", "ruka_fc4", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Luka>Pierce, the hero's spear!", "ruka_fc4", 0],
      },
      [1052] => { # レクイエムランス
        :word_1 => ["\\n<Luka>No mercy for the divine enemy, only a funeral! \n Destroy in darkness! Requiem Lance!", "ruka_fc4", 0],
      },
      [1060] => { # サン・エリアル
        :word_1 => ["\\n<Luka>The goddess uses her spear to ward off endless evil! \n San ​​Erial!", "ruka_fc4", 0],
      },
      [1063] => { # サン・ミラージュ
        :word_1 => ["\\n<Luka>The goddess uses her spear to pierce through evil and show justice! \n Sun Mirage!", "ruka_fc4", 0],
      },
      [1075] => { # 螺旋光槍
        :word_1 => ["\\n<Luka>Spiral light spear, pierce the evil darkness! \n Spiral light spear!", "ruka_fc4", 0],
      },
      [1076] => { # 滅魔閃槍
        :word_1 => ["\\n<Luka>The flashing spear that pierces the darkness, bring destruction to all evil! \n Demon Flash Spear!", "ruka_fc4", 0],
      },
      [1077] => { # フォトンランサー
        :word_1 => ["\\n<Luka>Destroy evil, holy photon! \n Photon Lancer!", "ruka_fc4", 0],
      },
      [1078] => { # ニーベルンヴァレスティ
        :word_1 => ["\\n<Luka>The secret technique of destroying evil, carve it into your body! \n Nibeln Valesti!", "ruka_fc4", 0],
      },
      [9054] => { # スターダストエンド
        :word_1 => ["\\n<Luka>Break, stardust! Stardust End!", "ruka_fc4", 0],
      },
      [9059] => { # 天軍乱槍
        :word_1 => ["\\n<Luka>This is the spear technique of the leader of the Heavenly Army... the Tengun Ranspear!", "ruka_fc4", 0],
      },
      [1085] => { # 祈りの聖槍
        :word_1 => ["\\n<Luka>Pray for the spear...", "ruka_fc4", 0],
      },
      [1086] => { # 奇跡の聖槍
        :word_1 => ["\\n<Luka>Goddess Ilias, do a miracle on the holy spear!", "ruka_fc4", 0],
      },
      [1087] => { # 聖槍チャージ
        :word_1 => ["\\n<Luka>Holy spear, power to cut off evil!", "ruka_fc4", 0],
      },
      [1088] => { # 聖槍ガード
        :word_1 => ["\\n<Luka>Holy spear, wall of protection!", "ruka_fc4", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Luka>Energy charge... Ha!", "ruka_fc4", 0],
      },
      [1092] => { # ハイチャージ
        :word_1 => ["\\n<Luka>Energy charge... Ha!", "ruka_fc4", 0],
      },
      [1093] => { # エクセルチャージ
        :word_1 => ["\\n<Luka>Ki maximum charge... Ha!", "ruka_fc4", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Luka>Desolation, the hero's axe!", "ruka_fc4", 0],
      },
      [1112] => { # 壊斧・大山鳴動
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Lend me your strength, Norm! Breaking axe, Oyama Rado!!", "ruka_fc4", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Luka>Ax, go wild!", "ruka_fc4", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Luka>Let's go, club handling inherited from Sonya!", "ruka_fc4", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Luka>Sickle, cut away evil!", "ruka_fc4", 0],
      },
      [1158] => { # 連斬かまいたち
        :word_1 => ["\\n<Luka>Slash and tear, whirlwind sickle... \n consecutive slashes!", "ruka_fc4", 0],
      },
      [1169] => { # 死連刃
        :word_1 => ["\\n<Luka>The blades of annihilation overlap each other, carving and dividing the number of lives!", "ruka_fc4", 0],
      },
      [1170] => { # レクイエムリーパー
        :word_1 => ["\\n<Luka>You are invited to the requiem, and you should scatter...", "ruka_fc4", 0],
      },
      [9078] => { # 魔神黒鎌
        :word_1 => ["\\n<Luka>The devil's sickle combs the soul...!", "ruka_fc4", 0],
      },
      [9080] => { # エンドレスサイズ
        :word_1 => ["\\n<Luka>Endless flash of sickle...endless size!", "ruka_fc4", 0],
      },
      [9083] => { # エンドオブエンド
        :word_1 => ["\\n<Luka>This is the ultimate end...!", "ruka_fc4", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Luka>This is also the power of the sickle...!", "ruka_fc4", 0],
      },
      [9081] => { # 罪と罰
        :word_1 => ["\\n<Luka>Dust is dust, crime and punishment...!", "ruka_fc4", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Luka>Pierce, arrow of the hero!", "ruka_fc4", 0],
      },
      [1196] => { # キューピッドアロー
        :word_1 => ["\\n<Luka>Aim for that heart! \n Cupid Arrow!", "ruka_fc4", 0],
      },
      [1197] => { # オーラスター
        :word_1 => ["\\n<Luka>Lost in the stars, arrow of holy flow! \n Aura Star!", "ruka_fc4", 0],
      },
      [1217] => { # ネビュラリフレクト
        :word_1 => ["\\n<Luka>Pierce, Ikusei Ichiya! \n Nebula Reflect!", "ruka_fc4", 0],
      },
      [1218] => { # コズミックダスト
        :word_1 => ["\\n<Luka>Rain from the galaxy! \n Cosmic Dust!", "ruka_fc4", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Luka>Rain down, healing arrows!", "ruka_fc4", 0],
      },
      [9098] => { # サウザンドムーン
        :word_1 => ["\\n<Luka>Pierce, thousands of lights...thousand moon!", "ruka_fc4", 0],
      },
      [9088] => { # アモールレイン
        :word_1 => ["\\n<Luka>Rain down, great arrows of love... Amor Rain!", "ruka_fc4", 0],
      },
      [9100] => { # シナイの神火
        :word_1 => ["\\n<Luka>The divine flame that consumes evil...the divine fire of Sinai!", "ruka_fc4", 0],
      },
      [9099] => { # イスカリオテの雨
        :word_1 => ["\\n<Luka>It's raining, Iscariot's rain!", "ruka_fc4", 0],
      },
      [9101] => { # 天上天下唯我独尊
        :word_1 => ["\\n<Luka>Lady Ilias's technique...!", "ruka_fc4", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Luka>Strike the darkness with the whip of justice!", "ruka_fc4", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Luka>Come, servant!", "ruka_fc4", 0],
      },
      [9114] => { # 黙示の神鞭
        :word_1 => ["\\n<Luka>Take the whip of the end upon yourself...!", "ruka_fc4", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Luka>It's a boomerang! Hey!", "ruka_fc4", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Luka>Oh! Let's go!", "ruka_fc4", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Luka>Fan, dance!", "ruka_fc4", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Luka>Aim and shoot...!", "ruka_fc4", 0],
      },
      [9147] => { # 跳弾乱舞
        :word_1 => ["\\n<Luka>Let's go, Ricochet Rainstorm...!", "ruka_fc4", 0],
      },
      [9149] => { # 至高の魔弾
        :word_1 => ["\\n<Luka>The supreme magic bullet that pierces everything...!", "ruka_fc4", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Luka>It's a healing bullet!", "ruka_fc4", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc4", 0],
      },
      [1374] => { # ミックスゲイズ
        :word_1 => ["\\n<Luka>Blade and fist, mix gaze!", "ruka_fc4", 0],
      },
      [1377] => { # クレイジータイム
        :word_1 => ["\\n<Luka>Take it, hail the rain of blades and fists! \nCrazy time!", "ruka_fc4", 0],
      },
      [1381] => { # ツインオプティック
        :word_1 => ["\\n<Luka>The endless blade that mowing down...Twin Optic!", "ruka_fc4", 0],
      },
      [1382] => { # アームドインフェルノ
        :word_1 => ["\\n<Luka>Look at the hell of the \n blade...Armed Inferno!", "ruka_fc4", 0],
      },
      [1383] => { # アサルトランタイム
        :word_1 => ["\\n<Luka>The secret of the fist blade... Assault run time!", "ruka_fc4", 0],
      },
      [1387] => { # サウザンドブレイド
        :word_1 => ["\\n<Luka>Dance to a thousand blades...Thousand Blades!", "ruka_fc4", 0],
      },
      [1390] => { # マキシマムランタイム
        :word_1 => ["\\n<Luka>Dance, the final blade storm... Maximum Runtime!", "ruka_fc4", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Luka>Blades in both hands, slash wildly!", "ruka_fc4", 0],
      },
      [1393] => { # セカンドシフト
        :word_1 => ["\\n<Luka>Blades in both hands, slash wildly!", "ruka_fc4", 0],
      },
      [1394] => { # サードシフト
        :word_1 => ["\\n<Luka>Look closely, a storm of blades!", "ruka_fc4", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc4", 0],
      },
      [1400] => { # 足払い
        :word_1 => ["\\n<Luka>There is a chance! Foot sweep!", "ruka_fc4", 0],
      },
      [1401] => { # 飛び膝蹴り
        :word_1 => ["\\n<Luka>I received \n! Flying knee kick!", "ruka_fc4", 0],
      },
      [1402] => { # 回し蹴り
        :word_1 => ["\\n<Luka>Kick away, roundhouse kick!", "ruka_fc4", 0],
      },
      [1403] => { # 秘孔
        :word_1 => ["\\n<Luka>I saw \n! Secret hole!", "ruka_fc4", 0],
      },
      [1405] => { # 正拳突き
        :word_1 => ["\\n<Luka>Put all your spirit into it... A true fist thrust!", "ruka_fc4", 0],
      },
      [1406] => { # 羅刹掌
        :word_1 => ["\\n<Luka>Now, turn into a Rakshasa! Rakshasa palm!", "ruka_fc4", 0],
      },
      [1407] => { # 爆裂拳
        :word_1 => ["\\n<Luka>An explosive fist that can't be stopped!", "ruka_fc4", 0],
      },
      [1408] => { # 電塵連脚
        :word_1 => ["\\n<Luka>Lightning legs that can't be stopped by the eyes!", "ruka_fc4", 0],
      },
      [1425] => { # 聖光裂閃撃
        :word_1 => ["\\n<Luka>Blink, white flash! Holy light splitting flash!", "ruka_fc4", 0],
      },
      [1426] => { # 暗黒連衝拳
        :word_1 => ["\\n<Luka>Engraved \n, black shock! Dark Renchoken!", "ruka_fc4", 0],
      },
      [1427] => { # 四天光掌
        :word_1 => ["\\n<Luka>The four palms of light, dance in disorder in the shining heaven and earth!", "ruka_fc4", 0],
      },
      [1428] => { # 四星滅功
        :word_1 => ["\\n<Luka>Four star destruction, bloom in the dark sky!", "ruka_fc4", 0],
      },
      [1429] => { # 烈気光掌
        :word_1 => ["\\n<Luka>A flash of ki, reaching even the heavens... A fierce light palm!", "ruka_fc4", 0],
      },
      [1430] => { # 瞬獄殺
        :word_1 => ["\\n<Luka>The living are doomed...", "ruka_fc4", 0],
      },
      [9163] => { # 破滅の鉄槌
        :word_1 => ["\\n<Luka>The judgment of the fist... the hammer of destruction!", "ruka_fc4", 0],
      },
      [9156] => { # 零拳
        :word_1 => ["\\n<Luka>Scattered, sub-zero freezing fist... Zero fist!", "ruka_fc4", 0],
      },
      [9165] => { # 聖天轟裂撃
        :word_1 => ["\\n<Luka>Breath of white light... Holy Heaven's roar ruptures!", "ruka_fc4", 0],
      },
      [9166] => { # 魔天冥煌撃
        :word_1 => ["\\n<Luka>The breath of darkness... Demon heaven's glittering attack!", "ruka_fc4", 0],
      },
      [9167] => { # 覆滅陰陽撃
        :word_1 => ["\\n<Luka>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "ruka_fc4", 0],
      },
      [9171] => { # アトミックインパクト
        :word_1 => ["\\n<Luka>I'll crush you with one shot...Atomic Impact!", "ruka_fc4", 0],
      },
      [9173] => { # 天地開闢拳
        :word_1 => ["\\n<Luka>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "ruka_fc4", 0],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Luka>....................", "ruka_fc4", 0],
      },
      [1434] => { # 当て身光掌（発動）
        :word_1 => ["\\n<Luka>I received \n... Atemi Kosho!", "ruka_fc4", 0],
      },
      [1435] => { # 金剛八連拳
        :word_1 => ["\\n<Luka>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "ruka_fc4", 0],
      },
      [1436] => { # 紅蓮大拳舞
        :word_1 => ["\\n<Luka>Dance in disorder, crimson flame! Guren Daikenbu!", "ruka_fc4", 0],
      },
      [9157] => { # 電塵乱皇脚
        :word_1 => ["\\n<Luka>flash, noble thunder! Denjinran Kokyaku!", "ruka_fc4", 0],
      },
      [9159] => { # 真・瞬獄殺
        :word_1 => ["\\n<Luka>The living will be destroyed, all things will be destroyed...", "ruka_fc4", 0],
      },
      [9164] => { # 修羅爆裂拳
        :word_1 => ["\\n<Luka>Shura's fist hits wildly! Yay!!", "ruka_fc4", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...chakra!", "ruka_fc4", 0],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...chakra!", "ruka_fc4", 0],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Luka>Heal the Heavenly Vein... Diffusion chakra!", "ruka_fc4", 0],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...the ultimate chakra!", "ruka_fc4", 0],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Luka>Return to your lifeline... Ha!", "ruka_fc4", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Luka>Demon vein, stay in your fist!", "ruka_fc4", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc4", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc4", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Luka>Holy light, destroy the darkness!", "ruka_fc4", 0],
      },
      [9188] => { # リリーマルレーン
        :word_1 => ["\\n<Luka>Along with the beautiful lily... Lily Marlane!", "ruka_fc4", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Luka>Holy will, destroy evil! \n Heaven!", "ruka_fc4", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Luka>Light, give me power!", "ruka_fc4", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Luka>Light, prevent the evil power!", "ruka_fc4", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Luka>Light, cancel the blessings of evil!", "ruka_fc4", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Luka>Black torrent, accept my order!", "ruka_fc4", 0],
      },
      [9209] => { # アシェンライト
        :word_1 => ["\\n<Luka>The fallen angel's magical power turns into holy light... \n Turns darkness into light! Ashen Light!", "ruka_fc4", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Luka>Death's sickle, invite me to the underworld! \n Death!", "ruka_fc4", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Luka>Black torrent, accept my order!", "ruka_fc4", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc4", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Luka>At \n, follow me! Yes!", "ruka_fc4", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Luka>The torrent of time breaks through logic and goes wild!", "ruka_fc4", 0],
      },
      [1561] => { # ブラックホール
        :word_1 => ["\\n<Luka>The abyss of space-time, the empty torrent! \n Sink to zero! Black hole!", "ruka_fc4", 0],
      },
      [1562] => { # スーパーノヴァ
        :word_1 => ["\\n<Luka>The end of reincarnation, the time of regression! \nBlink in the galaxy! Supernova!", "ruka_fc4", 0],
      },
      [9231] => { # カオスコメット
        :word_1 => ["\\n<Luka>Chaos meteorite, pour down in heavy rain... \n Chaos comet!", "ruka_fc4", 0],
      },
      [9232] => { # 妖星乱舞
        :word_1 => ["\\n<Luka>Look up, the star of misfortune... Yousei Ranbu!", "ruka_fc4", 0],
      },
      [9236] => { # カオスグラビディ
        :word_1 => ["\\n<Luka>Let the sickle of gravity crush your body! \n Chaos Gravidy!", "ruka_fc4", 0],
      },
      [9239] => { # 天地崩壊
        :word_1 => ["\\n<Luka>Break, world...", "ruka_fc4", 0],
      },
      [9237] => { # カオスメテオ
        :word_1 => ["\\n<Luka>Chaos meteorite, fill the earth with nothingness...", "ruka_fc4", 0],
      },
      [9240] => { # ワンダーランド・ナイトメア
        :word_1 => ["\\n<Luka>It's time to play...Wonderland Nightmare!", "ruka_fc4", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Luka>Time, stop!", "ruka_fc4", 0],
      },
      [1564] => { # カオスタイム
        :word_1 => ["\\n<Luka>Time, stop... Chaos time!", "ruka_fc4", 0],
      },
      [1566] => { # カオスオーバー
        :word_1 => ["\\n<Luka>Time to freeze... Chaos is over!", "ruka_fc4", 0],
      },
      [1567] => { # カオスクロニクル
        :word_1 => ["\\n<Luka>time is mine... Chaos Chronicle!", "ruka_fc4", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Luka>Holy light, dispel the darkness!", "ruka_fc4", 0],
      },
      [1634] => { # 天の雷
        :word_1 => ["\\n<Luka>Good anger, become a hammer and defeat the darkness!", "ruka_fc4", 0],
      },
      [1635] => { # 滅魔の雷
        :word_1 => ["\\n<Luka>Hammer's thunder, no evil allowed! Exorcism, sound the thunder!", "ruka_fc4", 0],
      },
      [1636] => { # 聖光波
        :word_1 => ["\\n<Luka>Holy light, banish evil and destroy evil!", "ruka_fc4", 0],
      },
      [1637] => { # 汚れなき光
        :word_1 => ["\\n<Luka>Immaculate light, illuminate the darkness and drive away impurity!", "ruka_fc4", 0],
      },
      [1638] => { # グランドクロス
        :word_1 => ["\\n<Luka>The cross of divine will, split the darkness in two!", "ruka_fc4", 0],
      },
      [1639] => { # イノセントレーザー
        :word_1 => ["\\n<Luka>A pure soul, clear your heart and pierce the darkness! \n Innocent Laser!", "ruka_fc4", 0],
      },
      [1640] => { # イノセントジャッジ
        :word_1 => ["\\n<Luka>Pure judgment, destroy darkness! \n Innocent judge!", "ruka_fc4", 0],
      },
      [1642] => { # 天罰
        :word_1 => ["\\n<Luka>Evil life, destroy it with judgment...!", "ruka_fc4", 0],
      },
      [1643] => { # 魔天回帰
        :word_1 => ["\\n<Luka>All lives, return to Mother Heaven...!", "ruka_fc4", 0],
      },
      [1647] => { # ヤルダバオト
        :word_1 => ["\\n<Luka>Show your holy power and destroy the divine enemy... Yaldabaoth!", "ruka_fc4", 0],
      },
      [1648] => { # カオスメサイア
        :word_1 => ["\\n<Luka>Arrival, the Messiah of Chaos...", "ruka_fc4", 0],
      },
      [1649] => { # 魔神忌光
        :word_1 => ["\\n<Luka>Disappear, the light of the devil...!", "ruka_fc4", 0],
      },
      [9270] => { # 魔神輝光
        :word_1 => ["\\n<Luka>Disappear, the shining light of the devil...!", "ruka_fc4", 0],
      },
      [9280] => { # 真・魔神輝光
        :word_1 => ["\\n<Luka>Holy element condensation...! \n Disappear, the brilliant light of the demon god...!", "ruka_fc4", 0],
      },
      [9269] => { # リブラ・レイ
        :word_1 => ["\\n<Luka>Shoot through, Holy Light... Libra Ray!", "ruka_fc4", 0],
      },
      [9273] => { # ホーリーフレア
        :word_1 => ["\\n<Luka>Shine the whitest in this world... \n Holy Flare!", "ruka_fc4", 0],
      },
      [9274] => { # 明けの明星
        :word_1 => ["\\n<Luka>....................", "ruka_fc4", 0],
      },
      [9275] => { # 発動：明けの明星
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc4", 0],
      },
      [9277] => { # 明星魔煌
        :word_1 => ["\\n<Luka>....................", "ruka_fc4", 0],
      },
      [9278] => { # 明星魔煌
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc4", 0],
      },
      [9283] => { # 聖天兎々
        :word_1 => ["\\n<Luka>Travelers of time and space, announce the sacred time... Holy Heavenly Rabbits!", "ruka_fc4", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc4", 0],
      },
      [9281] => { # 裁きの雷
        :word_1 => ["\\n<Luka>Receive the thunder of divine will...!", "ruka_fc4", 0],
      },
      [9282] => { # ビッグバン
        :word_1 => ["\\n<Luka>Everything ends and then begins...Big Bang!", "ruka_fc4", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc4", 0],
      },
      [9285] => { # ジャッジメント
        :word_1 => ["\\n<Luka>The promised land rejects you. \n In the hands of this judge, the execution will be carried out...", "ruka_fc4", 0],
      },
      [9268] => { # 聖天
        :word_1 => ["\\n<Luka>Look up at the glorious holy heavens...!", "ruka_fc4", 0],
      },
      [9271] => { # 天軍滅雷
        :word_1 => ["\\n<Luka>Destroy in the name of the leader of the angel army... the thunder of judgment!", "ruka_fc4", 0],
      },
      [9279] => { # 神の洪水
        :word_1 => ["\\n<Luka>It's a flood that will cleanse the world...!", "ruka_fc4", 0],
      },
      [9291] => { # ガブリエラの大祝福
        :word_1 => ["\\n<Luka>This is the ultimate blessing...!", "ruka_fc4", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Luka>Holy light, bring healing!", "ruka_fc4", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Luka>Dedicate your life and drive away the darkness!", "ruka_fc4", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Luka>The warrior's soul breathes life again!", "ruka_fc4", 0],
      },
      [1668] => { # 夢幻天舞
        :word_1 => ["\\n<Luka>The clear mirror, the dawn, the dreamlike heavenly dance...!", "ruka_fc4", 0],
      },
      [1669] => { # 堕天舞踏
        :word_1 => ["\\n<Luka>Uncut and infallible, Fallen Dance...!", "ruka_fc4", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Luka>....................", "ruka_fc4", 0],
      },
      [9272] => { # 聖雷輪舞
        :word_1 => ["\\n<Luka>Rotate divine punishment, dance holy lightning...!", "ruka_fc4", 0],
      },
      [9276] => { # アトミックヘブン
        :word_1 => ["\\n<Luka>Blow everything away, Atomic Heaven!", "ruka_fc4", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Luka>Darkness, roar...!", "ruka_fc4", 0],
      },
      [1675] => { # ダークエターナル
        :word_1 => ["\\n<Luka>The black of the end, fill the darkness...Dark Eternal!", "ruka_fc4", 0],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Luka>In the hour of darkness, cherry blossoms scatter in the dance of flames... \n Tremble to sleep, Majin Flame Dance!", "ruka_fc4", 0],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Luka>In the hour of darkness, being sent and dying is the work of the demon ice... \n Tremble and sleep, the demon ice funeral!", "ruka_fc4", 0],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Luka>In the hour of darkness, a voice cries out in the thunder dust... \n Tremble and sleep, demon thunder dust!", "ruka_fc4", 0],
      },
      [1680] => { # 魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the ultimate demonic moment... \n Reach the darkness, the demon black palm!", "ruka_fc4", 0],
      },
      [1681] => { # ネクローシス
        :word_1 => ["\\n<Luka>Chaos is the root, and the world will return to chaos... \n Necrosis...", "ruka_fc4", 0],
      },
      [1682] => { # アポトーシス
        :word_1 => ["\\n<Luka>Mix ■■ returns ■■■■■ is ■■■... \n appointment ■■...", "ruka_fc4", 0],
      },
      [1685] => { # カオスエクリプス
        :word_1 => ["\\n<Luka>Arrival, the eclipse of chaos...", "ruka_fc4", 0],
      },
      [1686] => { # 魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n Dance in the foam, the phantom dance of the demon!", "ruka_fc4", 0],
      },
      [1687] => { # ハルマゲドン
        :word_1 => ["\\n<Luka>The moment when light and darkness end... Armageddon!", "ruka_fc4", 0],
      },
      [1688] => { # 真・魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the demonic pole... \n Perish in the darkness, the true demon black palm!", "ruka_fc4", 0],
      },
      [1691] => { # 真・魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n End in foam, the true demon phantom dance!", "ruka_fc4", 0],
      },
      [1689] => { # シャドウフレア
        :word_1 => ["\\n<Luka>Shine the blackest in this world... \n Shadow Flare!", "ruka_fc4", 0],
      },
      [1694] => { # アンリ・マンユ
        :word_1 => ["\\n<Luka>Henri Mainyu, the hour of darkness has arrived...", "ruka_fc4", 0],
      },
      [9298] => { # ワールドブレイカー
        :word_1 => ["\\n<Luka>Destroy this world...", "ruka_fc4", 0],
      },
      [9294] => { # システム：シルフV2
        :ct_pic => "80_sylph_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>System: Sylph V2... Storm!", "ruka_fc4", 0],
      },
      [9295] => { # ノーム/ガイアGH
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Gnome/Gaia GH launches...shake the earth!", "ruka_fc4", 0],
      },
      [9296] => { # ウンディーネレーザー穿式
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Penetrate! Undine laser piercing type!", "ruka_fc4", 0],
      },
      [9297] => { # サラマンダー終式カノン
        :ct_pic => "80_salamander_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Salamander, burn this world to the ground!", "ruka_fc4", 0],
      },
      [9542] => { # 最後の魔眼
        :word_1 => ["\\n<Luka>Open up, the last evil eye...", "ruka_fc4", 0],
      },
      [2558] => { # 王者の魔眼
        :word_1 => ["\\n<Luka>This is the evil eye of the champion...", "ruka_fc4", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc4", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Luka>Residing in the sword, magical power!", "ruka_fc4", 0],
      },
      [1698] => { # 魔法剣ファイア
        :word_1 => ["\\n<Luka>Dwell in the sword, the power of flame!", "ruka_fc4", 0],
      },
      [1699] => { # 魔法剣ブリザード
        :word_1 => ["\\n<Luka>Residing in the sword, the power of ice!", "ruka_fc4", 0],
      },
      [1700] => { # 魔法剣サンダー
        :word_1 => ["\\n<Luka>Residing in the sword, the power of thunder!", "ruka_fc4", 0],
      },
      [1701] => { # 魔法剣ウィンド
        :word_1 => ["\\n<Luka>Rest in the sword, power of the wind!", "ruka_fc4", 0],
      },
      [1702] => { # 魔法剣アース
        :word_1 => ["\\n<Luka>Rest in the sword, power of the earth!", "ruka_fc4", 0],
      },
      [1703] => { # 魔法剣アクア
        :word_1 => ["\\n<Luka>Rest in the sword, power of water!", "ruka_fc4", 0],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<Luka>Residing in the sword, sacred power!", "ruka_fc4", 0],
      },
      [1705] => { # 魔法剣ダーク
        :word_1 => ["\\n<Luka>Dwell in the sword, power of darkness!", "ruka_fc4", 0],
      },
      [1706] => { # 魔法剣ポイズン
        :word_1 => ["\\n<Luka>Residing in the sword, poisonous magic!", "ruka_fc4", 0],
      },
      [1707] => { # 魔法剣ブライン
        :word_1 => ["\\n<Luka>Dwell in the sword, magic of darkness!", "ruka_fc4", 0],
      },
      [1708] => { # 魔法剣サイレンス
        :word_1 => ["\\n<Luka>Dwell in the sword, magical power of silence!", "ruka_fc4", 0],
      },
      [1709] => { # 魔法剣パラライズ
        :word_1 => ["\\n<Luka>Dwell in the sword, paralyzing magic!", "ruka_fc4", 0],
      },
      [1710] => { # 魔法剣コンフューズ
        :word_1 => ["\\n<Luka>Dwell in the sword, magical power of confusion!", "ruka_fc4", 0],
      },
      [1711] => { # 魔法剣スリープ
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of sleep!", "ruka_fc4", 0],
      },
      [1712] => { # 魔法剣デス
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of death!", "ruka_fc4", 0],
      },
      [1713] => { # 魔法剣ヘブン
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of ascension!", "ruka_fc4", 0],
      },
      [1714] => { # 魔法剣ドレイン
        :word_1 => ["\\n<Luka>Residing in the sword, the power of absorption!", "ruka_fc4", 0],
      },
      [1715] => { # 魔法剣マドレイン
        :word_1 => ["\\n<Luka>Residing in the sword, the magical power of absorption!", "ruka_fc4", 0],
      },
      [1718] => { # 魔法剣カーズ
        :word_1 => ["\\n<Luka>Residing in the sword, cursed magic!", "ruka_fc4", 0],
      },
      [1716] => { # マジックバリア
        :word_1 => ["\\n<Luka>Protect your friends from evil techniques! \n Magic barrier!", "ruka_fc4", 0],
      },
      [1717] => { # マジックリフレクト
        :word_1 => ["\\n<Luka>Heaven's blessing turns to earth and serves as a magic mirror! \n Magic Reflect!", "ruka_fc4", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Luka>It's a Yin-Yang... Hey!", "ruka_fc4", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Luka>The secret of exorcism, the prison of rebellion! \nKnow the reward, Nine Souls Exorcism Formation!", "ruka_fc4", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Luka>A lifetime, sending it is life! \n Engraving the slightest bit...Singing life!", "ruka_fc4", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Luka>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "ruka_fc4", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Luka>I got \n!", "ruka_fc4", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Luka>Proof of a thief!", "ruka_fc4", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Luka>Now I'm running away!", "ruka_fc4", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Luka>Actually, when I was little, I admired ninjas... Yay!", "ruka_fc4", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Luka>Waves of healing, pervade thousands of places... \n Ninja art/healing waves!", "ruka_fc4", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Luka>Autumn Utsusemi dances in the shadows... \n Ninja art/Bunshin no Jutsu!", "ruka_fc4", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Luka>It's a smokescreen!", "ruka_fc4", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Luka>It's a pirate technique! Yay!", "ruka_fc4", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Luka>This is justice! Ha!", "ruka_fc4", 0],
      },
      [1842] => { # 正義のファイヤーパンチ
        :word_1 => ["\\n<Luka>Burn, the fist of justice! \n Fire... Punch!!", "ruka_fc4", 0],
      },
      [1843] => { # 正義のブリザードナックル
        :word_1 => ["\\n<Luka>Sparkle, Fist of Condemnation! \n Blizzard...Naaakkuru!!", "ruka_fc4", 0],
      },
      [1844] => { # 正義のサンダーキック
        :word_1 => ["\\n<Luka>Shine, thunderous kick! \n Thunderaaaaaaa...squeak!!", "ruka_fc4", 0],
      },
      [1845] => { # ヒーロー乱舞
        :word_1 => ["\\n<Luka>This is the fist of justice! \n Haaaaaaaaaaaaa!!", "ruka_fc4", 0],
      },
      [1846] => { # カイザーキック
        :word_1 => ["\\n<Luka>Love and justice... Kaiser kick!", "ruka_fc4", 0],
      },
      [1847] => { # カイザーファイナルソード
        :word_1 => ["\\n<Luka>Kaiser Final Sword of courage and victory!", "ruka_fc4", 0],
      },
      [1848] => { # カイザークライマックスキック
        :word_1 => ["\\n<Luka>Roar justice, shine victory! \nThis is the last Kaiser climax kick!!", "ruka_fc4", 0],
      },
      [1849] => { # ヒーローガッツ
        :word_1 => ["\\n<Luka>No matter how much you get hurt...no matter how much you kneel down...\n The soul of justice...will not give in!!", "ruka_fc4", 0],
      },
      [1850] => { # カイザーリフレイン
        :word_1 => ["\\n<Luka>An unbreakable heart... Kaiser Refrain!", "ruka_fc4", 0],
      },
      [1851] => { # カイザーバリア
        :word_1 => ["\\n<Luka>Wall of Justice... Kaiser Barrier!", "ruka_fc4", 0],
      },
      [1857] => { # エクセルラッシュ
        :word_1 => ["\\n<Luka>Roar, the cry of justice! Excel Rush!", "ruka_fc4", 0],
      },
      [1858] => { # エクセルジエンド
        :word_1 => ["\\n<Luka>Infinite courage and endless victory! \n Penetrating justice...Excelge End!", "ruka_fc4", 0],
      },
      [1859] => { # エクセルシオール
        :word_1 => ["\\n<Luka>I will fight for the weak!! \n This is the proof of justice... Excelsior!", "ruka_fc4", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Luka>I can't believe I'm a magical girl... Yeah☆", "ruka_fc4", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Luka>I'll do something with the power of money...", "ruka_fc4", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Luka>Okay, I bought it!", "ruka_fc4", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Luka>Bring out the power of \nItem beyond its limits!", "ruka_fc4", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc4", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Luka>It's a battle with coins, you won't lose!", "ruka_fc4", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Luka>Come on, it's a game of darkness with me!", "ruka_fc4", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Luka>I'll draw the tarot, hey!", "ruka_fc4", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Luka>Lady Ilias, please guide me...", "ruka_fc4", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Luka>I'll turn the slot, yeah!", "ruka_fc4", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Luka>Play poker with me!", "ruka_fc4", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Luka>Battle card, draw!", "ruka_fc4", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Luka>The power contained in the playing cards...!", "ruka_fc4", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Luka>Today, the luckiest person is...", "ruka_fc4", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Luka>It's always my turn!", "ruka_fc4", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Luka>God, please give me an item...", "ruka_fc4", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Luka>Come on, let's dance!", "ruka_fc4", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Luka>That's it! Hustle! Hustle!", "ruka_fc4", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Luka>I'll have you listen to my song!", "ruka_fc4", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Luka>I can't help it... Kira☆", "ruka_fc4", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Luka>Hey, let's talk for a while.", "ruka_fc4", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Luka>Wow, you are so amazing!", "ruka_fc4", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Luka>I'm not scared of you!", "ruka_fc4", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Luka>Well, I want money...", "ruka_fc4", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Luka>Well, I want an Item...", "ruka_fc4", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Luka>Hey, please be my friend!", "ruka_fc4", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Luka>If you continue like this, you'll be in terrible trouble...?", "ruka_fc4", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Luka>Please stand back quietly from here.", "ruka_fc4", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Luka>Then Mr. Smith was scratched by a cat...", "ruka_fc4", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Luka>When I opened the curtain, there was a lady next to me...", "ruka_fc4", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Luka>So, when I was walking near the grave...", "ruka_fc4", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Luka>The futon... was blown away...", "ruka_fc4", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Luka>It's the power of the Spirit of Words... Now, listen to me...", "ruka_fc4", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Luka>Let's go to Luka's exciting laboratory!", "ruka_fc4", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Luka>Now, prepare for the crisis!", "ruka_fc4", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Luka>Now, let's convert the energy...", "ruka_fc4", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Luka>I will alchemize \nItem!", "ruka_fc4", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Luka>This is the power of the magic book...!", "ruka_fc4", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Luka>This is also for the page...", "ruka_fc4", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Luka>Makina activated...Let's go!", "ruka_fc4", 0],
      },
      [2246] => { # ビームデスサイズ
        :word_1 => ["\\n<Luka>Cut into pieces with the \n beam blade!", "ruka_fc4", 0],
      },
      [2250] => { # 反粒子レールガン
        :word_1 => ["\\n<Luka>Disappear...Anti-particle railgun!", "ruka_fc4", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Luka>I'm confident in my cooking skills!", "ruka_fc4", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Luka>Well, what can be used as ingredients...", "ruka_fc4", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc4", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Luka>Calm down, I'll treat you right away!", "ruka_fc4", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Luka>Now, use this medicine... \n Hehe, hehehehehe...", "ruka_fc4", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Luka>I'll give you an injection! Hey!", "ruka_fc4", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Luka>Things like this are fun... \n Hehe, hehehehehe...", "ruka_fc4", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Luka>Excuse me for a moment...", "ruka_fc4", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Luka>Tea is here...it's homemade by me.", "ruka_fc4", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Luka>Let's go! Maid change!", "ruka_fc4", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Luka>Will we be able to harvest it soon...?", "ruka_fc4", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Luka>This is the king's sword technique!", "ruka_fc4", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Luka>This is the king's magic!", "ruka_fc4", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Luka>Everyone, please lend me your strength!", "ruka_fc4", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Luka>Dispel evil, divine power!", "ruka_fc4", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Luka>This is the power of the king...!", "ruka_fc4", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Luka>God, please give me a miracle...!", "ruka_fc4", 0],
      },
      [2432] => { # やたらめった斬り
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Kyoeeeeee!!", "ruka_fc4", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc4", 0],
      },
      [2433] => { # 我流ファイア斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>I'll do it my way...! \n It's a flaming sword!", "ruka_fc4", 0],
      },
      [2434] => { # 燃えろ！ぐるぐる斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn, my fighting spirit! \n Special, round and round slash!", "ruka_fc4", 0],
      },
      [2435] => { # 妖魔斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Defeat evil with the hero's blade!", "ruka_fc4", 0],
      },
      [2436] => { # 不死斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Return to dust with the hero's blade!", "ruka_fc4", 0],
      },
      [2437] => { # 烈火天翔閃
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade of blazing fire, judge evil! \n Recca Tensho Flash!", "ruka_fc4", 0],
      },
      [2438] => { # 紅蓮廻天斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blowing Sabe, Crimson Blade! \n Guren Kaitenzan!", "ruka_fc4", 0],
      },
      [2439] => { # 紅蓮炎舞
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Transform into a crimson lotus and dance! \n Guren Enmai!", "ruka_fc4", 0],
      },
      [2440] => { # プラズマブレイク
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dispel the darkness! Plasma break!", "ruka_fc4", 0],
      },
      [2441] => { # シャドウブレイク
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Cut off the light! Shadow Break!", "ruka_fc4", 0],
      },
      [2444] => { # 烈心聖光斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade of light, cut off the darkness! Zealous Light Slash!", "ruka_fc4", 0],
      },
      [2431] => { # シャドウラプソディ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance with the darkness...Shadow Rhapsody!", "ruka_fc4", 0],
      },
      [2442] => { # グランドリオン
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of justice cuts everything! \nWith unwavering faith! Grand Lion!", "ruka_fc4", 0],
      },
      [2443] => { # ヴェルデリオン
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The fighting spirit of darkness destroys the light! \nWith unwavering faith! Veldt Lion!", "ruka_fc4", 0],
      },
      [2446] => { # アルティメットメサイア
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate salvation... \n Along with light! Ultimate Messiah!", "ruka_fc4", 0],
      },
      [2447] => { # シャドウメサイア
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the implied salvation... \n Dance in the darkness! Shadow Messiah!", "ruka_fc4", 0],
      },
      [2448] => { # エレメント・スピカ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Put the power of the four spirits into your hands...!", "ruka_fc4", 0],
      },
      [2453] => { # 烈心天塵英雄剣
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The ultimate secret of the hero...Resshin Tenjin Hero Sword!", "ruka_fc4", 0],
      },
      [2449] => { # カドラプル・ギガ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Four spirits, give me power... \n This is the end! Quadruple Giga!!", "ruka_fc4", 0],
      },
      [2450] => { # 烈心天塵剣
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Righteous light, ominous heavenly dust... \n Now is the time to become one! Retsushin Tenjinken!", "ruka_fc4", 0],
      },
      [2454] => { # イクスタプル・ゼタ
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The four spirits, the Kirin, and the ice butterfly... \n With everyone's power, EX-tuple Zeta!!", "ruka_fc4", 0],
      },
      [2445] => { # 天塵剣
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Carve, the blade of heavenly dust...haaah!", "ruka_fc4", 0],
      },
      [2451] => { # エンジェルダスト
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Turn angels into dust...Angel dust!", "ruka_fc4", 0],
      },
      [2452] => { # 八夜羅刹斬
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The night of Rakshasa goes around... Eight nights of Rakshasa slash!", "ruka_fc4", 0],
      },
      [2457] => { # ブレイブウォール
        :ct_pic => "80_ruka_st31b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the divine protection!", "ruka_fc4", 0],
      },
      [2455] => { # ロゴス・マギア
        :ct_pic => "iv_rukab3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Father of Chaos>■■■■■■■■■■■■...!!", "ruka_fc4", 0],
      },
      [2458] => { # 勇者の号令
        :word_1 => ["\\n<Luka>Everyone, let's go with all our might!", "ruka_fc4", 0],
        :word_2 => ["\\n<Luka>No matter what enemy we are, we can defeat it!", "ruka_fc4", 0],
        :word_3 => ["\\n<Luka>Win this battle and save the world!", "ruka_fc4", 0],
        :word_4 => ["\\n<Luka>Make every battle for the hero!", "ruka_fc4", 0],
        :word_5 => ["\\n<Luka>I will definitely win this battle!", "ruka_fc4", 0],
        :word_6 => ["\\n<Luka>In the name of the hero... everyone, let's go!!", "ruka_fc4", 0],
        :word_7 => ["\\n<Luka>Our struggle will bring us victory!!", "ruka_fc4", 0],
        :word_8 => ["\\n<Luka>Muster up your fighting spirit...let's go!", "ruka_fc4", 0],
        :word_9 => ["\\n<Luka>There's a party tonight!!", "ruka_fc4", 0],
        :word_10 => ["\\n<Luka>Let's go, to gain the glory of victory!", "ruka_fc4", 0],
      },
      [9546] => { # 黎明の魔眼
        :word_1 => ["\\n<Luka>The third eye judges evil... The evil eye of dawn!", "ruka_fc4", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc4", 0],
      },
      [9639] => { # コキュートス
        :word_1 => ["\\n<Luka>Sleep in the eternal ice of the demon world... Cocytus!", "ruka_fc4", 0],
      },
      [9651] => { # 波動砲
        :word_1 => ["\\n<Luka>Disappear...wave motion gun!", "ruka_fc4", 0],
      },
      [9674] => { # 特級神具VIII:アグニカノン
        :word_1 => ["\\n<Luka>Destroy in flames, Agnicanon!", "ruka_fc4", 0],
      },
      [9675] => { # 特級神具IV:メルクリウス
        :word_1 => ["\\n<Luka>Freeze and break, Mercury!", "ruka_fc4", 0],
      },
      [9676] => { # 特級神具V:エクスパルサー
        :word_1 => ["\\n<Luka>Electric shock irradiation, Expulser!", "ruka_fc4", 0],
      },
      [9673] => { # 神具XIII:ユダ
        :word_1 => ["\\n<Luka>Blow away, Judas!", "ruka_fc4", 0],
      },
      [9677] => { # 特級神具IV:ガイアグラビディ
        :word_1 => ["\\n<Luka>Crush it, Gaia Gravidi!!", "ruka_fc4", 0],
      },
      [9678] => { # 特級神具IX:セントフレア
        :word_1 => ["\\n<Luka>Pierce, Saint Flare!!", "ruka_fc4", 0],
      },
      [9679] => { # エンドフルバースト
        :word_1 => ["\\n<Luka>All firearms activated...Endful burst!", "ruka_fc4", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Luka>Are you okay? It's just a first aid measure...", "ruka_fc4", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Luka>Lady Ilias, please bless me...!", "ruka_fc4", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Luka>...!", "ruka_fc4", 0],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Luka>Power to the blade...!", "ruka_fc4", 0],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Luka>Ohhh...!!", "ruka_fc4", 0],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Luka>This is my full power...!!", "ruka_fc4", 0],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Luka>This is the final secret...!", "ruka_fc4", 0],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Luka>Concentrate on your fist...", "ruka_fc4", 0],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Luka>This body is like steel...!", "ruka_fc4", 0],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Luka>The ultimate in concentration, the final effort...", "ruka_fc4", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Luka>With the help of \n Elemental...!", "ruka_fc4", 0],
      },
      [3111] => { # 四精霊同時召喚
        :word_1 => ["\\n<Luka>Come out, Sylph, Gnome, Undine, Salamander... \n Four spirits are summoned at the same time!", "ruka_fc4", 0],
      },
      [3116] => { # 明鏡止水
        :word_1 => ["\\n<Luka>This heart, in the flow of water...", "ruka_fc4", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Luka>Calm down and take a deep breath...", "ruka_fc4", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Luka>Calm down, this is first aid...", "ruka_fc4", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Luka>This is how I fight!", "ruka_fc4", 0],
      },
      [3121] => { # 背水
        :word_1 => ["\\n<Luka>This is how I fight!", "ruka_fc4", 0],
      },
      [3123] => { # 究極背水
        :word_1 => ["\\n<Luka>This is the ultimate predicament...!", "ruka_fc4", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Luka>Ohhhh...!!", "ruka_fc4", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Luka>Let's go...!　Hmmmm!!", "ruka_fc4", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Luka>Why am I... Magical☆Henshin ♪", "ruka_fc4", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Luka>Be quiet!", "ruka_fc4", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Luka>Okay, I'll request reinforcements!", "ruka_fc4", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Luka>Break that power!", "ruka_fc4", 0],
      },
      [3132] => { # ウェポンブレイク
        :word_1 => ["\\n<Luka>Breaking that power... Ha!", "ruka_fc4", 0],
      },
      [3133] => { # アーマーブレイク
        :word_1 => ["\\n<Luka>Shatter that defense... Ha!", "ruka_fc4", 0],
      },
      [3134] => { # マジックブレイク
        :word_1 => ["\\n<Luka>Breaking that magic... Ha!", "ruka_fc4", 0],
      },
      [3135] => { # マインドブレイク
        :word_1 => ["\\n<Luka>Shatter that spirit... Ha!", "ruka_fc4", 0],
      },
      [3136] => { # スピードブレイク
        :word_1 => ["\\n<Luka>Breaking that speed... Ha!", "ruka_fc4", 0],
      },
      [3137] => { # テクニックブレイク
        :word_1 => ["\\n<Luka>Breaking that skill... Ha!", "ruka_fc4", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Luka>Geyser, gush!", "ruka_fc4", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Luka>Don't move! Sit down!", "ruka_fc4", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Luka>Ehehe, I'll take it...", "ruka_fc4", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Luka>Why me... \n Se, sexy beam...", "ruka_fc4", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Luka>What is this! Pink Typhoon...", "ruka_fc4", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Luka>It's crap! Fantastic Hurricane♪", "ruka_fc4", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Luka>Come on, it's my stage!", "ruka_fc4", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Luka>Alright, I'll work a lot today too!", "ruka_fc4", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Luka>Pafupafu... there's no way I can do it!", "ruka_fc4", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Luka>The power of a hidden weapon...!", "ruka_fc4", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Luka>The power of grudge...!", "ruka_fc4", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Luka>...Blitzkrieg!!", "ruka_fc4", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Luka>My grudge...!", "ruka_fc4", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Luka>This is the holy grail miracle!", "ruka_fc4", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Luka>The power of the aura!", "ruka_fc4", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Luka>This is... witchcraft!", "ruka_fc4", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Luka>Huh!", "ruka_fc4", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Luka>I will protect you...!", "ruka_fc4", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Luka>Ahengers...Assemble!!", "ruka_fc4", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Luka>Double up!", "ruka_fc4", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Luka>Next action, order!", "ruka_fc4", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Luka>Concentrate your power on one point...!", "ruka_fc4", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc4", 0],
      },
      [9759] => { # ラストエクリプス
        :word_1 => ["\\n<Luka>Arrival, the final eclipse of chaos...", "ruka_fc4", 0],
      },
      [9760] => { # デスジェネシス
        :word_1 => ["\\n<Luka>The end is the beginning...Death Genesis!", "ruka_fc4", 0],
      },
      [9761] => { # ゼロユニバース
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc4", 0],
      },
      [9762] => { # 反物質対消滅
        :word_1 => ["\\n<Luka>Forbidden power, antimatter versus annihilation...", "ruka_fc4", 0],
      },
      [9763] => { # 次元削除
        :word_1 => ["\\n<Luka>Let's delete this dimension...", "ruka_fc4", 0],
      },
      [9764] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■...", "ruka_fc4", 0],
      },
      [9765] => { # ゼロシフト
        :word_1 => ["\\n<Luka>Bringing equilibrium to chaos...Zero shift!", "ruka_fc4", 0],
      },
      [3285] => { # 誘惑専用
        :word_y1 => ["\\n<Luka>I can't stand this... \n Ah, we're in battle...", "ruka_fc4", 0],
      },
    },
    3 => { # ルカ
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Luka>Hyaah!", "ruka_fc3", 0],
        :word_2 => ["\\n<Luka>Huh!", "ruka_fc3", 0],
        :word_3 => ["\\n<Luka>Hey!", "ruka_fc3", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc3", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc3", 0],
      },
      [917] => { # 切り返し
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>It's a cutback... Yay!", "ruka_fc3", 0],
      },
      [918] => { # 疾風突き
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a wind...Poke!", "ruka_fc3", 0],
      },
      [919] => { # 払車剣
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The sword flashes, like a wheel...Kurumaken!", "ruka_fc3", 0],
      },
      [920] => { # 諸刃斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>I'm ready, it's a double-edged sword!", "ruka_fc3", 0],
      },
      [921] => { # 隼斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a falcon...slash multiple times!", "ruka_fc3", 0],
      },
      [922] => { # 火炎斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take shelter, flame... yay!", "ruka_fc3", 0],
      },
      [923] => { # 氷斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take shelter, ice... Yay!", "ruka_fc3", 0],
      },
      [924] => { # 稲妻斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Stay, lightning... Yay!", "ruka_fc3", 0],
      },
      [930] => { # エンジェルダンス
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade, dance to the heavens... \n Angel dance!", "ruka_fc3", 0],
      },
      [931] => { # 真空斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Vacuum blade... Ha!", "ruka_fc3", 0],
      },
      [932] => { # 烈風剣
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance, blade of fierce wind!　Aaah!!", "ruka_fc3", 0],
      },
      [933] => { # 月影の太刀
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>May dances... Shura's sword!", "ruka_fc3", 0],
      },
      [934] => { # 魔神斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Demon God's blow! Ha!!", "ruka_fc3", 0],
      },
      [935] => { # デッドクラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of destruction brings death...Dead Crash!", "ruka_fc3", 0],
      },
      [936] => { # 二刀十字斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Get close and take a look! Two-sword cross slash!", "ruka_fc3", 0],
      },
      [937] => { # 魔剣・首刈り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Shine, the blade of courage! Magic sword/decapitation!", "ruka_fc3", 0],
      },
      [938] => { # 血裂雷鳴突き
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Tear the darkness and shine the light! Thunder thrust!", "ruka_fc3", 0],
      },
      [942] => { # フレイムスラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn it down, a flash of red... \n Flame Slash!", "ruka_fc3", 0],
      },
      [943] => { # アイススラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Freezing, a flash of blue... \n Ice slash!", "ruka_fc3", 0],
      },
      [944] => { # サンダースラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Knead it down, a flash of yellow... \n Thunder Slash!", "ruka_fc3", 0],
      },
      [945] => { # 斬魔の舞
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The evil blade that destroys demons! \n Dancing in the light is Zanma no Mai!", "ruka_fc3", 0],
      },
      [946] => { # 屠竜撃
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go, the blow that slays the dragon!", "ruka_fc3", 0],
      },
      [947] => { # 雲身払車剣
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Kasumi's blade, like a wheel... Cloud body-wielding Kurumaken!", "ruka_fc3", 0],
      },
      [948] => { # 滅世斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>A dark blade that ends this world... Destruction!", "ruka_fc3", 0],
      },
      [950] => { # 瞬剣・疾風迅雷
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Sylph, give me power...! Shunken: Gale and lightning!", "ruka_fc3", 0],
      },
      [953] => { # 死剣・乱れ星
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Twinkling Meteor Sword Technique...Death Sword, Disturbing Star!", "ruka_fc3", 0],
      },
      [954] => { # 魔影流星斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Look at the dark meteor falling on the earth... Demon Shadow Meteor Slash!", "ruka_fc3", 0],
      },
      [959] => { # ギガスラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate flash... \n Giga Slash!", "ruka_fc3", 0],
      },
      [960] => { # ラウンドオブビリオン
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the miracle of the holy sword...Round of Billion!", "ruka_fc3", 0],
      },
      [961] => { # 月下散華
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Spring dies under the moon... Sanka under the moon!", "ruka_fc3", 0],
      },
      [962] => { # 魔刃・雪時雨
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The endless slash of the Rakshasa...Magic blade, Yuki Shigure!", "ruka_fc3", 0],
      },
      [964] => { # ジャスティスヘブン
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Judgment of justice, execution of divine will... \n Sword of condemnation! Justice Heaven!", "ruka_fc3", 0],
      },
      [965] => { # 閃殺
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The principle of space-time, the severance is my blade of lightning!", "ruka_fc3", 0],
      },
      [966] => { # 烈空堕天斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The sword that fell to the earth, looks up to the sky and tears apart everything! \n Shine in the eastern sky! Split Sky Fallen Slash!", "ruka_fc3", 0],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Fast like a gale, fast like thunder...! \n Instant strike, gale of thunder!", "ruka_fc3", 0],
      },
      [969] => { # 諸刃微塵斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Even if this body decays... it's a double-edged sword!", "ruka_fc3", 0],
      },
      [973] => { # アトミックスラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase \n, a flash of nuclear heat... Atomic Slash!", "ruka_fc3", 0],
      },
      [974] => { # クァンタスラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of quantum... Quantus Slash!", "ruka_fc3", 0],
      },
      [975] => { # イオンスラッシュ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of atoms... ion slash!", "ruka_fc3", 0],
      },
      [9009] => { # ギガスラッシュクロス
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Double flash! Giga Slash Cross!", "ruka_fc3", 0],
      },
      [9013] => { # 九重の羅刹
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Rakshasa's jaw gate has defeated the army and banished evil!", "ruka_fc3", 0],
      },
      [9022] => { # 天軍の剣
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc3", 0],
      },
      [9023] => { # 天軍滅星
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc3", 0],
      },
      [9016] => { # 乱れ雪月花
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Snow dance...moon shadow...flowers and scattering...!", "ruka_fc3", 0],
      },
      [971] => { # 聖光六閃斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Catch \n, a continuous attack of light... Six flashes of holy light!", "ruka_fc3", 0],
      },
      [970] => { # メギドカリバーン
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>mowing down with the wave of darkness! Megiddo Caliburn!", "ruka_fc3", 0],
      },
      [9014] => { # メギドカブラ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate mystery of the magic sword! Megidokabura!", "ruka_fc3", 0],
      },
      [976] => { # 癒しの剣
        :word_1 => ["\\n<Luka>Healing sword, God's blessings!", "ruka_fc3", 0],
      },
      [977] => { # 奇跡の剣
        :word_1 => ["\\n<Luka>Miraculous sword, divine protection!", "ruka_fc3", 0],
      },
      [978] => { # 大奇跡の剣
        :word_1 => ["\\n<Luka>Healing sword, God's miracle!", "ruka_fc3", 0],
      },
      [979] => { # 超奇跡の剣
        :word_1 => ["\\n<Luka>Super miraculous sword, great healing!", "ruka_fc3", 0],
      },
      [972] => { # 闇天
        :word_1 => ["\\n<Luka>The blade of Shura that cuts everything...Dark Heaven!", "ruka_fc3", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Luka>Let's go, Rapier of Justice! Ha!", "ruka_fc3", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Luka>Stake your pride on this blade!", "ruka_fc3", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Luka>A flash with this blade... Hey!", "ruka_fc3", 0],
      },
      [1007] => { # 峰打ち
        :word_1 => ["\\n<Luka>I'll make you sleep...Mineuchi!", "ruka_fc3", 0],
      },
      [1008] => { # 三連斬
        :word_1 => ["\\n<Luka>Repeated carving, triple slash!", "ruka_fc3", 0],
      },
      [1009] => { # 居合い抜き
        :word_1 => ["\\n<Luka>Cut off with a single sword! Iainuki!", "ruka_fc3", 0],
      },
      [1010] => { # 牙突
        :word_1 => ["\\n<Luka>Penetrate everything! Fangs!", "ruka_fc3", 0],
      },
      [1011] => { # 居合い・焔ノ太刀
        :word_1 => ["\\n<Luka>Burn it down, the Crimson Blade! Homura no Tachi!", "ruka_fc3", 0],
      },
      [1012] => { # 居合・吹雪ノ太刀
        :word_1 => ["\\n<Luka>Freezing, extremely cold blade! Fubuki no Tachi!", "ruka_fc3", 0],
      },
      [1013] => { # 居合・雷土ノ太刀
        :word_1 => ["\\n<Luka>Flash, the blade of lightning! Raito no Tachi!", "ruka_fc3", 0],
      },
      [1018] => { # 滅魂刀
        :word_1 => ["\\n<Luka>I will destroy that soul... ha!", "ruka_fc3", 0],
      },
      [1019] => { # 斬神斬魔
        :word_1 => ["\\n<Luka>Cut off the gods and destroy the demons...!", "ruka_fc3", 0],
      },
      [1022] => { # 縮地・焔閃
        :word_1 => ["\\n<Luka>A flash of a blade like a blink of an eye... Shrinkage, flame flash!", "ruka_fc3", 0],
      },
      [1023] => { # 魔刀・明鏡止水
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Follow the flow of water...Magic sword, Myokyo water stop!", "ruka_fc3", 0],
      },
      [1024] => { # 神刀・鏡花水月
        :word_1 => ["\\n<Luka>Clear, pure flash... Divine sword Kyoka Suigetsu!", "ruka_fc3", 0],
      },
      [1025] => { # 微塵滅閃
        :word_1 => ["\\n<Luka>The devil's blade is carved into fine dust... A fine flash!", "ruka_fc3", 0],
      },
      [1026] => { # 聖刃七星天
        :word_1 => ["\\n<Luka>I look up and see the Seven Pole Stars... \n Twinkle in the heavens and earth, the Holy Blade Seven Stars of Heaven!", "ruka_fc3", 0],
      },
      [1027] => { # 桜花幻舞
        :word_1 => ["\\n<Luka>The cherry blossoms are falling, the dancing is a dream...", "ruka_fc3", 0],
      },
      [1028] => { # 天墜
        :word_1 => ["\\n<Luka>Fall... Fall from heaven!", "ruka_fc3", 0],
      },
      [9041] => { # 十四連斬
        :word_1 => ["\\n<Luka>14 consecutive slashes...tee!!", "ruka_fc3", 0],
      },
      [1030] => { # 居合い・伊邪那岐
        :word_1 => ["\\n<Luka>Nagigu is a fresh blade... Iai Izanagi!", "ruka_fc3", 0],
      },
      [1031] => { # 居合い・伊邪那美
        :word_1 => ["\\n<Luka>Nagigu is the blade of death... Iai Izanami!", "ruka_fc3", 0],
      },
      [9044] => { # 修羅の舞い
        :word_1 => ["\\n<Luka>Crazy bloom! The dance of Shura is stained with scattered blood...!", "ruka_fc3", 0],
      },
      [9046] => { # 終ノ閃
        :word_1 => ["\\n<Luka>Crush into nothingness, the final flash...", "ruka_fc3", 0],
      },
      [9045] => { # 神祖烈星斬
        :word_1 => ["\\n<Luka>Cuts off the stars, God Ancestor Retsuseizan!", "ruka_fc3", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Luka>By the pride of the white blade!", "ruka_fc3", 0],
      },
      [1032] => { # 心頭滅却
        :word_1 => ["\\n<Luka>My heart is lost, fire is also cool...", "ruka_fc3", 0],
      },
      [1033] => { # 肉斬骨断
        :word_1 => ["\\n<Luka>Cut the flesh and cut the bones! Here we go!", "ruka_fc3", 0],
      },
      [1034] => { # 切り捨て御免
        :word_1 => ["\\n<Luka>Now... I'm sorry for cutting it off!", "ruka_fc3", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Luka>Be honest here...!", "ruka_fc3", 0],
      },
      [1037] => { # 則天去私
        :word_1 => ["\\n<Luka>This heart is my state...", "ruka_fc3", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Luka>Pierce, the hero's spear!", "ruka_fc3", 0],
      },
      [1052] => { # レクイエムランス
        :word_1 => ["\\n<Luka>No mercy for the divine enemy, only a funeral! \n Destroy in darkness! Requiem Lance!", "ruka_fc3", 0],
      },
      [1060] => { # サン・エリアル
        :word_1 => ["\\n<Luka>The goddess uses her spear to ward off endless evil! \n San ​​Erial!", "ruka_fc3", 0],
      },
      [1063] => { # サン・ミラージュ
        :word_1 => ["\\n<Luka>The goddess uses her spear to pierce through evil and show justice! \n Sun Mirage!", "ruka_fc3", 0],
      },
      [1075] => { # 螺旋光槍
        :word_1 => ["\\n<Luka>Spiral light spear, pierce the evil darkness! \n Spiral light spear!", "ruka_fc3", 0],
      },
      [1076] => { # 滅魔閃槍
        :word_1 => ["\\n<Luka>The flashing spear that pierces the darkness, bring destruction to all evil! \n Demon Flash Spear!", "ruka_fc3", 0],
      },
      [1077] => { # フォトンランサー
        :word_1 => ["\\n<Luka>Destroy evil, holy photon! \n Photon Lancer!", "ruka_fc3", 0],
      },
      [1078] => { # ニーベルンヴァレスティ
        :word_1 => ["\\n<Luka>The secret technique of destroying evil, carve it into your body! \n Nibeln Valesti!", "ruka_fc3", 0],
      },
      [9054] => { # スターダストエンド
        :word_1 => ["\\n<Luka>Break, stardust! Stardust End!", "ruka_fc3", 0],
      },
      [9059] => { # 天軍乱槍
        :word_1 => ["\\n<Luka>This is the spear technique of the leader of the Heavenly Army... the Tengun Ranspear!", "ruka_fc3", 0],
      },
      [1085] => { # 祈りの聖槍
        :word_1 => ["\\n<Luka>Pray for the spear...", "ruka_fc3", 0],
      },
      [1086] => { # 奇跡の聖槍
        :word_1 => ["\\n<Luka>Goddess Ilias, do a miracle on the holy spear!", "ruka_fc3", 0],
      },
      [1087] => { # 聖槍チャージ
        :word_1 => ["\\n<Luka>Holy spear, power to cut off evil!", "ruka_fc3", 0],
      },
      [1088] => { # 聖槍ガード
        :word_1 => ["\\n<Luka>Holy spear, wall of protection!", "ruka_fc3", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Luka>Energy charge... Ha!", "ruka_fc3", 0],
      },
      [1092] => { # ハイチャージ
        :word_1 => ["\\n<Luka>Energy charge... Ha!", "ruka_fc3", 0],
      },
      [1093] => { # エクセルチャージ
        :word_1 => ["\\n<Luka>Ki maximum charge... Ha!", "ruka_fc3", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Luka>Desolation, the hero's axe!", "ruka_fc3", 0],
      },
      [1112] => { # 壊斧・大山鳴動
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Lend me your strength, Norm! Breaking axe, Oyama Rado!!", "ruka_fc3", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Luka>Ax, go wild!", "ruka_fc3", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Luka>Let's go, club handling inherited from Sonya!", "ruka_fc3", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Luka>Sickle, cut away evil!", "ruka_fc3", 0],
      },
      [1158] => { # 連斬かまいたち
        :word_1 => ["\\n<Luka>Slash and tear, whirlwind sickle... \n consecutive slashes!", "ruka_fc3", 0],
      },
      [1169] => { # 死連刃
        :word_1 => ["\\n<Luka>The blades of annihilation overlap each other, carving and dividing the number of lives!", "ruka_fc3", 0],
      },
      [1170] => { # レクイエムリーパー
        :word_1 => ["\\n<Luka>You are invited to the requiem, and you should scatter...", "ruka_fc3", 0],
      },
      [9078] => { # 魔神黒鎌
        :word_1 => ["\\n<Luka>The devil's sickle combs the soul...!", "ruka_fc3", 0],
      },
      [9080] => { # エンドレスサイズ
        :word_1 => ["\\n<Luka>Endless flash of sickle...endless size!", "ruka_fc3", 0],
      },
      [9083] => { # エンドオブエンド
        :word_1 => ["\\n<Luka>This is the ultimate end...!", "ruka_fc3", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Luka>This is also the power of the sickle...!", "ruka_fc3", 0],
      },
      [9081] => { # 罪と罰
        :word_1 => ["\\n<Luka>Dust is dust, crime and punishment...!", "ruka_fc3", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Luka>Pierce, arrow of the hero!", "ruka_fc3", 0],
      },
      [1196] => { # キューピッドアロー
        :word_1 => ["\\n<Luka>Aim for that heart! \n Cupid Arrow!", "ruka_fc3", 0],
      },
      [1197] => { # オーラスター
        :word_1 => ["\\n<Luka>Lost in the stars, arrow of holy flow! \n Aura Star!", "ruka_fc3", 0],
      },
      [1217] => { # ネビュラリフレクト
        :word_1 => ["\\n<Luka>Pierce, Ikusei Ichiya! \n Nebula Reflect!", "ruka_fc3", 0],
      },
      [1218] => { # コズミックダスト
        :word_1 => ["\\n<Luka>Rain from the galaxy! \n Cosmic Dust!", "ruka_fc3", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Luka>Rain down, healing arrows!", "ruka_fc3", 0],
      },
      [9098] => { # サウザンドムーン
        :word_1 => ["\\n<Luka>Pierce, thousands of lights...thousand moon!", "ruka_fc3", 0],
      },
      [9088] => { # アモールレイン
        :word_1 => ["\\n<Luka>Rain down, great arrows of love... Amor Rain!", "ruka_fc3", 0],
      },
      [9100] => { # シナイの神火
        :word_1 => ["\\n<Luka>The divine flame that consumes evil...the divine fire of Sinai!", "ruka_fc3", 0],
      },
      [9099] => { # イスカリオテの雨
        :word_1 => ["\\n<Luka>It's raining, Iscariot's rain!", "ruka_fc3", 0],
      },
      [9101] => { # 天上天下唯我独尊
        :word_1 => ["\\n<Luka>Lady Ilias's technique...!", "ruka_fc3", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Luka>Strike the darkness with the whip of justice!", "ruka_fc3", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Luka>Come, servant!", "ruka_fc3", 0],
      },
      [9114] => { # 黙示の神鞭
        :word_1 => ["\\n<Luka>Take the whip of the end upon yourself...!", "ruka_fc3", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Luka>It's a boomerang! Hey!", "ruka_fc3", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Luka>Oh! Let's go!", "ruka_fc3", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Luka>Fan, dance!", "ruka_fc3", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Luka>Aim and shoot...!", "ruka_fc3", 0],
      },
      [9147] => { # 跳弾乱舞
        :word_1 => ["\\n<Luka>Let's go, Ricochet Rainstorm...!", "ruka_fc3", 0],
      },
      [9149] => { # 至高の魔弾
        :word_1 => ["\\n<Luka>The supreme magic bullet that pierces everything...!", "ruka_fc3", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Luka>It's a healing bullet!", "ruka_fc3", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc3", 0],
      },
      [1374] => { # ミックスゲイズ
        :word_1 => ["\\n<Luka>Blade and fist, mix gaze!", "ruka_fc3", 0],
      },
      [1377] => { # クレイジータイム
        :word_1 => ["\\n<Luka>Take it, hail the rain of blades and fists! \nCrazy time!", "ruka_fc3", 0],
      },
      [1381] => { # ツインオプティック
        :word_1 => ["\\n<Luka>The endless blade that mowing down...Twin Optic!", "ruka_fc3", 0],
      },
      [1382] => { # アームドインフェルノ
        :word_1 => ["\\n<Luka>Look at the hell of the \n blade...Armed Inferno!", "ruka_fc3", 0],
      },
      [1383] => { # アサルトランタイム
        :word_1 => ["\\n<Luka>The secret of the fist blade... Assault run time!", "ruka_fc3", 0],
      },
      [1387] => { # サウザンドブレイド
        :word_1 => ["\\n<Luka>Dance to a thousand blades...Thousand Blades!", "ruka_fc3", 0],
      },
      [1390] => { # マキシマムランタイム
        :word_1 => ["\\n<Luka>Dance, the final blade storm... Maximum Runtime!", "ruka_fc3", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Luka>Blades in both hands, slash wildly!", "ruka_fc3", 0],
      },
      [1393] => { # セカンドシフト
        :word_1 => ["\\n<Luka>Blades in both hands, slash wildly!", "ruka_fc3", 0],
      },
      [1394] => { # サードシフト
        :word_1 => ["\\n<Luka>Look closely, a storm of blades!", "ruka_fc3", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc3", 0],
      },
      [1400] => { # 足払い
        :word_1 => ["\\n<Luka>There is a chance! Foot sweep!", "ruka_fc3", 0],
      },
      [1401] => { # 飛び膝蹴り
        :word_1 => ["\\n<Luka>I received \n! Flying knee kick!", "ruka_fc3", 0],
      },
      [1402] => { # 回し蹴り
        :word_1 => ["\\n<Luka>Kick away, roundhouse kick!", "ruka_fc3", 0],
      },
      [1403] => { # 秘孔
        :word_1 => ["\\n<Luka>I saw \n! Secret hole!", "ruka_fc3", 0],
      },
      [1405] => { # 正拳突き
        :word_1 => ["\\n<Luka>Put all your spirit into it... A true fist thrust!", "ruka_fc3", 0],
      },
      [1406] => { # 羅刹掌
        :word_1 => ["\\n<Luka>Now, turn into a Rakshasa! Rakshasa palm!", "ruka_fc3", 0],
      },
      [1407] => { # 爆裂拳
        :word_1 => ["\\n<Luka>An explosive fist that can't be stopped!", "ruka_fc3", 0],
      },
      [1408] => { # 電塵連脚
        :word_1 => ["\\n<Luka>Lightning legs that can't be stopped by the eyes!", "ruka_fc3", 0],
      },
      [1425] => { # 聖光裂閃撃
        :word_1 => ["\\n<Luka>Blink, white flash! Holy light splitting flash!", "ruka_fc3", 0],
      },
      [1426] => { # 暗黒連衝拳
        :word_1 => ["\\n<Luka>Engraved \n, black shock! Dark Renchoken!", "ruka_fc3", 0],
      },
      [1427] => { # 四天光掌
        :word_1 => ["\\n<Luka>The four palms of light, dance in disorder in the shining heaven and earth!", "ruka_fc3", 0],
      },
      [1428] => { # 四星滅功
        :word_1 => ["\\n<Luka>Four star destruction, bloom in the dark sky!", "ruka_fc3", 0],
      },
      [1429] => { # 烈気光掌
        :word_1 => ["\\n<Luka>A flash of ki, reaching even the heavens... A fierce light palm!", "ruka_fc3", 0],
      },
      [1430] => { # 瞬獄殺
        :word_1 => ["\\n<Luka>The living are doomed...", "ruka_fc3", 0],
      },
      [9163] => { # 破滅の鉄槌
        :word_1 => ["\\n<Luka>The judgment of the fist... the hammer of destruction!", "ruka_fc3", 0],
      },
      [9156] => { # 零拳
        :word_1 => ["\\n<Luka>Scattered, sub-zero freezing fist... Zero fist!", "ruka_fc3", 0],
      },
      [9165] => { # 聖天轟裂撃
        :word_1 => ["\\n<Luka>Breath of white light... Holy Heaven's roar ruptures!", "ruka_fc3", 0],
      },
      [9166] => { # 魔天冥煌撃
        :word_1 => ["\\n<Luka>The breath of darkness... Demon heaven's glittering attack!", "ruka_fc3", 0],
      },
      [9167] => { # 覆滅陰陽撃
        :word_1 => ["\\n<Luka>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "ruka_fc3", 0],
      },
      [9171] => { # アトミックインパクト
        :word_1 => ["\\n<Luka>I'll crush you with one shot...Atomic Impact!", "ruka_fc3", 0],
      },
      [9173] => { # 天地開闢拳
        :word_1 => ["\\n<Luka>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "ruka_fc3", 0],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Luka>....................", "ruka_fc3", 0],
      },
      [1434] => { # 当て身光掌（発動）
        :word_1 => ["\\n<Luka>I received \n... Atemi Kosho!", "ruka_fc3", 0],
      },
      [1435] => { # 金剛八連拳
        :word_1 => ["\\n<Luka>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "ruka_fc3", 0],
      },
      [1436] => { # 紅蓮大拳舞
        :word_1 => ["\\n<Luka>Dance in disorder, crimson flame! Guren Daikenbu!", "ruka_fc3", 0],
      },
      [9157] => { # 電塵乱皇脚
        :word_1 => ["\\n<Luka>flash, noble thunder! Denjinran Kokyaku!", "ruka_fc3", 0],
      },
      [9159] => { # 真・瞬獄殺
        :word_1 => ["\\n<Luka>The living will be destroyed, all things will be destroyed...", "ruka_fc3", 0],
      },
      [9164] => { # 修羅爆裂拳
        :word_1 => ["\\n<Luka>Shura's fist hits wildly! Yay!!", "ruka_fc3", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...chakra!", "ruka_fc3", 0],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...chakra!", "ruka_fc3", 0],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Luka>Heal the Heavenly Vein... Diffusion chakra!", "ruka_fc3", 0],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...the ultimate chakra!", "ruka_fc3", 0],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Luka>Return to your lifeline... Ha!", "ruka_fc3", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Luka>Demon vein, stay in your fist!", "ruka_fc3", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc3", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc3", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Luka>Holy light, destroy the darkness!", "ruka_fc3", 0],
      },
      [9188] => { # リリーマルレーン
        :word_1 => ["\\n<Luka>Along with the beautiful lily... Lily Marlane!", "ruka_fc3", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Luka>Holy will, destroy evil! \n Heaven!", "ruka_fc3", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Luka>Light, give me power!", "ruka_fc3", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Luka>Light, prevent the evil power!", "ruka_fc3", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Luka>Light, cancel the blessings of evil!", "ruka_fc3", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Luka>Black torrent, accept my order!", "ruka_fc3", 0],
      },
      [9209] => { # アシェンライト
        :word_1 => ["\\n<Luka>The fallen angel's magical power turns into holy light... \n Turns darkness into light! Ashen Light!", "ruka_fc3", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Luka>Death's sickle, invite me to the underworld! \n Death!", "ruka_fc3", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Luka>Black torrent, accept my order!", "ruka_fc3", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc3", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Luka>At \n, follow me! Yes!", "ruka_fc3", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Luka>The torrent of time breaks through logic and goes wild!", "ruka_fc3", 0],
      },
      [1561] => { # ブラックホール
        :word_1 => ["\\n<Luka>The abyss of space-time, the empty torrent! \n Sink to zero! Black hole!", "ruka_fc3", 0],
      },
      [1562] => { # スーパーノヴァ
        :word_1 => ["\\n<Luka>The end of reincarnation, the time of regression! \nBlink in the galaxy! Supernova!", "ruka_fc3", 0],
      },
      [9231] => { # カオスコメット
        :word_1 => ["\\n<Luka>Chaos meteorite, pour down in heavy rain... \n Chaos comet!", "ruka_fc3", 0],
      },
      [9232] => { # 妖星乱舞
        :word_1 => ["\\n<Luka>Look up, the star of misfortune... Yousei Ranbu!", "ruka_fc3", 0],
      },
      [9236] => { # カオスグラビディ
        :word_1 => ["\\n<Luka>Let the sickle of gravity crush your body! \n Chaos Gravidy!", "ruka_fc3", 0],
      },
      [9239] => { # 天地崩壊
        :word_1 => ["\\n<Luka>Break, world...", "ruka_fc3", 0],
      },
      [9237] => { # カオスメテオ
        :word_1 => ["\\n<Luka>Chaos meteorite, fill the earth with nothingness...", "ruka_fc3", 0],
      },
      [9240] => { # ワンダーランド・ナイトメア
        :word_1 => ["\\n<Luka>It's time to play...Wonderland Nightmare!", "ruka_fc3", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Luka>Time, stop!", "ruka_fc3", 0],
      },
      [1564] => { # カオスタイム
        :word_1 => ["\\n<Luka>Time, stop... Chaos time!", "ruka_fc3", 0],
      },
      [1566] => { # カオスオーバー
        :word_1 => ["\\n<Luka>Time to freeze... Chaos is over!", "ruka_fc3", 0],
      },
      [1567] => { # カオスクロニクル
        :word_1 => ["\\n<Luka>time is mine... Chaos Chronicle!", "ruka_fc3", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Luka>Holy light, dispel the darkness!", "ruka_fc3", 0],
      },
      [1634] => { # 天の雷
        :word_1 => ["\\n<Luka>Good anger, become a hammer and defeat the darkness!", "ruka_fc3", 0],
      },
      [1635] => { # 滅魔の雷
        :word_1 => ["\\n<Luka>Hammer's thunder, no evil allowed! Exorcism, sound the thunder!", "ruka_fc3", 0],
      },
      [1636] => { # 聖光波
        :word_1 => ["\\n<Luka>Holy light, banish evil and destroy evil!", "ruka_fc3", 0],
      },
      [1637] => { # 汚れなき光
        :word_1 => ["\\n<Luka>Immaculate light, illuminate the darkness and drive away impurity!", "ruka_fc3", 0],
      },
      [1638] => { # グランドクロス
        :word_1 => ["\\n<Luka>The cross of divine will, split the darkness in two!", "ruka_fc3", 0],
      },
      [1639] => { # イノセントレーザー
        :word_1 => ["\\n<Luka>A pure soul, clear your heart and pierce the darkness! \n Innocent Laser!", "ruka_fc3", 0],
      },
      [1640] => { # イノセントジャッジ
        :word_1 => ["\\n<Luka>Pure judgment, destroy darkness! \n Innocent judge!", "ruka_fc3", 0],
      },
      [1642] => { # 天罰
        :word_1 => ["\\n<Luka>Evil life, destroy it with judgment...!", "ruka_fc3", 0],
      },
      [1643] => { # 魔天回帰
        :word_1 => ["\\n<Luka>All lives, return to Mother Heaven...!", "ruka_fc3", 0],
      },
      [1647] => { # ヤルダバオト
        :word_1 => ["\\n<Luka>Show your holy power and destroy the divine enemy... Yaldabaoth!", "ruka_fc3", 0],
      },
      [1648] => { # カオスメサイア
        :word_1 => ["\\n<Luka>Arrival, the Messiah of Chaos...", "ruka_fc3", 0],
      },
      [1649] => { # 魔神忌光
        :word_1 => ["\\n<Luka>Disappear, the light of the devil...!", "ruka_fc3", 0],
      },
      [9270] => { # 魔神輝光
        :word_1 => ["\\n<Luka>Disappear, the shining light of the devil...!", "ruka_fc3", 0],
      },
      [9280] => { # 真・魔神輝光
        :word_1 => ["\\n<Luka>Holy element condensation...! \n Disappear, the brilliant light of the demon god...!", "ruka_fc3", 0],
      },
      [9269] => { # リブラ・レイ
        :word_1 => ["\\n<Luka>Shoot through, Holy Light... Libra Ray!", "ruka_fc3", 0],
      },
      [9273] => { # ホーリーフレア
        :word_1 => ["\\n<Luka>Shine the whitest in this world... \n Holy Flare!", "ruka_fc3", 0],
      },
      [9274] => { # 明けの明星
        :word_1 => ["\\n<Luka>....................", "ruka_fc3", 0],
      },
      [9275] => { # 発動：明けの明星
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc3", 0],
      },
      [9277] => { # 明星魔煌
        :word_1 => ["\\n<Luka>....................", "ruka_fc3", 0],
      },
      [9278] => { # 明星魔煌
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc3", 0],
      },
      [9283] => { # 聖天兎々
        :word_1 => ["\\n<Luka>Travelers of time and space, announce the sacred time... Holy Heavenly Rabbits!", "ruka_fc3", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc3", 0],
      },
      [9281] => { # 裁きの雷
        :word_1 => ["\\n<Luka>Receive the thunder of divine will...!", "ruka_fc3", 0],
      },
      [9282] => { # ビッグバン
        :word_1 => ["\\n<Luka>Everything ends and then begins...Big Bang!", "ruka_fc3", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc3", 0],
      },
      [9285] => { # ジャッジメント
        :word_1 => ["\\n<Luka>The promised land rejects you. \n In the hands of this judge, the execution will be carried out...", "ruka_fc3", 0],
      },
      [9268] => { # 聖天
        :word_1 => ["\\n<Luka>Look up at the glorious holy heavens...!", "ruka_fc3", 0],
      },
      [9271] => { # 天軍滅雷
        :word_1 => ["\\n<Luka>Destroy in the name of the leader of the angel army... the thunder of judgment!", "ruka_fc3", 0],
      },
      [9279] => { # 神の洪水
        :word_1 => ["\\n<Luka>It's a flood that will cleanse the world...!", "ruka_fc3", 0],
      },
      [9291] => { # ガブリエラの大祝福
        :word_1 => ["\\n<Luka>This is the ultimate blessing...!", "ruka_fc3", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Luka>Holy light, bring healing!", "ruka_fc3", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Luka>Dedicate your life and drive away the darkness!", "ruka_fc3", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Luka>The warrior's soul breathes life again!", "ruka_fc3", 0],
      },
      [1668] => { # 夢幻天舞
        :word_1 => ["\\n<Luka>The clear mirror, the dawn, the dreamlike heavenly dance...!", "ruka_fc3", 0],
      },
      [1669] => { # 堕天舞踏
        :word_1 => ["\\n<Luka>Uncut and infallible, Fallen Dance...!", "ruka_fc3", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Luka>....................", "ruka_fc3", 0],
      },
      [9272] => { # 聖雷輪舞
        :word_1 => ["\\n<Luka>Rotate divine punishment, dance holy lightning...!", "ruka_fc3", 0],
      },
      [9276] => { # アトミックヘブン
        :word_1 => ["\\n<Luka>Blow everything away, Atomic Heaven!", "ruka_fc3", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Luka>Darkness, roar...!", "ruka_fc3", 0],
      },
      [1675] => { # ダークエターナル
        :word_1 => ["\\n<Luka>The black of the end, fill the darkness...Dark Eternal!", "ruka_fc3", 0],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Luka>In the hour of darkness, cherry blossoms scatter in the dance of flames... \n Tremble to sleep, Majin Flame Dance!", "ruka_fc3", 0],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Luka>In the hour of darkness, being sent and dying is the work of the demon ice... \n Tremble and sleep, the demon ice funeral!", "ruka_fc3", 0],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Luka>In the hour of darkness, a voice cries out in the thunder dust... \n Tremble and sleep, demon thunder dust!", "ruka_fc3", 0],
      },
      [1680] => { # 魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the ultimate demonic moment... \n Reach the darkness, the demon black palm!", "ruka_fc3", 0],
      },
      [1681] => { # ネクローシス
        :word_1 => ["\\n<Luka>Chaos is the root, and the world will return to chaos... \n Necrosis...", "ruka_fc3", 0],
      },
      [1682] => { # アポトーシス
        :word_1 => ["\\n<Luka>Mix ■■ returns ■■■■■ is ■■■... \n appointment ■■...", "ruka_fc3", 0],
      },
      [1685] => { # カオスエクリプス
        :word_1 => ["\\n<Luka>Arrival, the eclipse of chaos...", "ruka_fc3", 0],
      },
      [1686] => { # 魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n Dance in the foam, the phantom dance of the demon!", "ruka_fc3", 0],
      },
      [1687] => { # ハルマゲドン
        :word_1 => ["\\n<Luka>The moment when light and darkness end... Armageddon!", "ruka_fc3", 0],
      },
      [1688] => { # 真・魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the demonic pole... \n Perish in the darkness, the true demon black palm!", "ruka_fc3", 0],
      },
      [1691] => { # 真・魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n End in foam, the true demon phantom dance!", "ruka_fc3", 0],
      },
      [1689] => { # シャドウフレア
        :word_1 => ["\\n<Luka>Shine the blackest in this world... \n Shadow Flare!", "ruka_fc3", 0],
      },
      [1694] => { # アンリ・マンユ
        :word_1 => ["\\n<Luka>Henri Mainyu, the hour of darkness has arrived...", "ruka_fc3", 0],
      },
      [9298] => { # ワールドブレイカー
        :word_1 => ["\\n<Luka>Destroy this world...", "ruka_fc3", 0],
      },
      [9294] => { # システム：シルフV2
        :ct_pic => "80_sylph_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>System: Sylph V2... Storm!", "ruka_fc3", 0],
      },
      [9295] => { # ノーム/ガイアGH
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Gnome/Gaia GH launches...shake the earth!", "ruka_fc3", 0],
      },
      [9296] => { # ウンディーネレーザー穿式
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Penetrate! Undine laser piercing type!", "ruka_fc3", 0],
      },
      [9297] => { # サラマンダー終式カノン
        :ct_pic => "80_salamander_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Salamander, burn this world to the ground!", "ruka_fc3", 0],
      },
      [9542] => { # 最後の魔眼
        :word_1 => ["\\n<Luka>Open up, the last evil eye...", "ruka_fc3", 0],
      },
      [2558] => { # 王者の魔眼
        :word_1 => ["\\n<Luka>This is the evil eye of the champion...", "ruka_fc3", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc3", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Luka>Residing in the sword, magical power!", "ruka_fc3", 0],
      },
      [1698] => { # 魔法剣ファイア
        :word_1 => ["\\n<Luka>Dwell in the sword, the power of flame!", "ruka_fc3", 0],
      },
      [1699] => { # 魔法剣ブリザード
        :word_1 => ["\\n<Luka>Residing in the sword, the power of ice!", "ruka_fc3", 0],
      },
      [1700] => { # 魔法剣サンダー
        :word_1 => ["\\n<Luka>Residing in the sword, the power of thunder!", "ruka_fc3", 0],
      },
      [1701] => { # 魔法剣ウィンド
        :word_1 => ["\\n<Luka>Rest in the sword, power of the wind!", "ruka_fc3", 0],
      },
      [1702] => { # 魔法剣アース
        :word_1 => ["\\n<Luka>Rest in the sword, power of the earth!", "ruka_fc3", 0],
      },
      [1703] => { # 魔法剣アクア
        :word_1 => ["\\n<Luka>Rest in the sword, power of water!", "ruka_fc3", 0],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<Luka>Residing in the sword, sacred power!", "ruka_fc3", 0],
      },
      [1705] => { # 魔法剣ダーク
        :word_1 => ["\\n<Luka>Dwell in the sword, power of darkness!", "ruka_fc3", 0],
      },
      [1706] => { # 魔法剣ポイズン
        :word_1 => ["\\n<Luka>Residing in the sword, poisonous magic!", "ruka_fc3", 0],
      },
      [1707] => { # 魔法剣ブライン
        :word_1 => ["\\n<Luka>Dwell in the sword, magic of darkness!", "ruka_fc3", 0],
      },
      [1708] => { # 魔法剣サイレンス
        :word_1 => ["\\n<Luka>Dwell in the sword, magical power of silence!", "ruka_fc3", 0],
      },
      [1709] => { # 魔法剣パラライズ
        :word_1 => ["\\n<Luka>Dwell in the sword, paralyzing magic!", "ruka_fc3", 0],
      },
      [1710] => { # 魔法剣コンフューズ
        :word_1 => ["\\n<Luka>Dwell in the sword, magical power of confusion!", "ruka_fc3", 0],
      },
      [1711] => { # 魔法剣スリープ
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of sleep!", "ruka_fc3", 0],
      },
      [1712] => { # 魔法剣デス
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of death!", "ruka_fc3", 0],
      },
      [1713] => { # 魔法剣ヘブン
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of ascension!", "ruka_fc3", 0],
      },
      [1714] => { # 魔法剣ドレイン
        :word_1 => ["\\n<Luka>Residing in the sword, the power of absorption!", "ruka_fc3", 0],
      },
      [1715] => { # 魔法剣マドレイン
        :word_1 => ["\\n<Luka>Residing in the sword, the magical power of absorption!", "ruka_fc3", 0],
      },
      [1718] => { # 魔法剣カーズ
        :word_1 => ["\\n<Luka>Residing in the sword, cursed magic!", "ruka_fc3", 0],
      },
      [1716] => { # マジックバリア
        :word_1 => ["\\n<Luka>Protect your friends from evil techniques! \n Magic barrier!", "ruka_fc3", 0],
      },
      [1717] => { # マジックリフレクト
        :word_1 => ["\\n<Luka>Heaven's blessing turns to earth and serves as a magic mirror! \n Magic Reflect!", "ruka_fc3", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Luka>It's a Yin-Yang... Hey!", "ruka_fc3", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Luka>The secret of exorcism, the prison of rebellion! \nKnow the reward, Nine Souls Exorcism Formation!", "ruka_fc3", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Luka>A lifetime, sending it is life! \n Engraving the slightest bit...Singing life!", "ruka_fc3", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Luka>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "ruka_fc3", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Luka>I got \n!", "ruka_fc3", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Luka>Proof of a thief!", "ruka_fc3", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Luka>Now I'm running away!", "ruka_fc3", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Luka>Actually, when I was little, I admired ninjas... Yay!", "ruka_fc3", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Luka>Waves of healing, pervade thousands of places... \n Ninja art/healing waves!", "ruka_fc3", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Luka>Autumn Utsusemi dances in the shadows... \n Ninja art/Bunshin no Jutsu!", "ruka_fc3", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Luka>It's a smokescreen!", "ruka_fc3", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Luka>It's a pirate technique! Yay!", "ruka_fc3", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Luka>This is justice! Ha!", "ruka_fc3", 0],
      },
      [1842] => { # 正義のファイヤーパンチ
        :word_1 => ["\\n<Luka>Burn, the fist of justice! \n Fire... Punch!!", "ruka_fc3", 0],
      },
      [1843] => { # 正義のブリザードナックル
        :word_1 => ["\\n<Luka>Sparkle, Fist of Condemnation! \n Blizzard...Naaakkuru!!", "ruka_fc3", 0],
      },
      [1844] => { # 正義のサンダーキック
        :word_1 => ["\\n<Luka>Shine, thunderous kick! \n Thunderaaaaaaa...squeak!!", "ruka_fc3", 0],
      },
      [1845] => { # ヒーロー乱舞
        :word_1 => ["\\n<Luka>This is the fist of justice! \n Haaaaaaaaaaaaa!!", "ruka_fc3", 0],
      },
      [1846] => { # カイザーキック
        :word_1 => ["\\n<Luka>Love and justice... Kaiser kick!", "ruka_fc3", 0],
      },
      [1847] => { # カイザーファイナルソード
        :word_1 => ["\\n<Luka>Kaiser Final Sword of courage and victory!", "ruka_fc3", 0],
      },
      [1848] => { # カイザークライマックスキック
        :word_1 => ["\\n<Luka>Roar justice, shine victory! \nThis is the last Kaiser climax kick!!", "ruka_fc3", 0],
      },
      [1849] => { # ヒーローガッツ
        :word_1 => ["\\n<Luka>No matter how much you get hurt...no matter how much you kneel down...\n The soul of justice...will not give in!!", "ruka_fc3", 0],
      },
      [1850] => { # カイザーリフレイン
        :word_1 => ["\\n<Luka>An unbreakable heart... Kaiser Refrain!", "ruka_fc3", 0],
      },
      [1851] => { # カイザーバリア
        :word_1 => ["\\n<Luka>Wall of Justice... Kaiser Barrier!", "ruka_fc3", 0],
      },
      [1857] => { # エクセルラッシュ
        :word_1 => ["\\n<Luka>Roar, the cry of justice! Excel Rush!", "ruka_fc3", 0],
      },
      [1858] => { # エクセルジエンド
        :word_1 => ["\\n<Luka>Infinite courage and endless victory! \n Penetrating justice...Excelge End!", "ruka_fc3", 0],
      },
      [1859] => { # エクセルシオール
        :word_1 => ["\\n<Luka>I will fight for the weak!! \n This is the proof of justice... Excelsior!", "ruka_fc3", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Luka>I can't believe I'm a magical girl... Yeah☆", "ruka_fc3", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Luka>I'll do something with the power of money...", "ruka_fc3", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Luka>Okay, I bought it!", "ruka_fc3", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Luka>Bring out the power of \nItem beyond its limits!", "ruka_fc3", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc3", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Luka>It's a battle with coins, you won't lose!", "ruka_fc3", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Luka>Come on, it's a game of darkness with me!", "ruka_fc3", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Luka>I'll draw the tarot, hey!", "ruka_fc3", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Luka>Lady Ilias, please guide me...", "ruka_fc3", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Luka>I'll turn the slot, yeah!", "ruka_fc3", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Luka>Play poker with me!", "ruka_fc3", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Luka>Battle card, draw!", "ruka_fc3", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Luka>The power contained in the playing cards...!", "ruka_fc3", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Luka>Today, the luckiest person is...", "ruka_fc3", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Luka>It's always my turn!", "ruka_fc3", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Luka>God, please give me an item...", "ruka_fc3", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Luka>Come on, let's dance!", "ruka_fc3", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Luka>That's it! Hustle! Hustle!", "ruka_fc3", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Luka>I'll have you listen to my song!", "ruka_fc3", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Luka>I can't help it... Kira☆", "ruka_fc3", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Luka>Hey, let's talk for a while.", "ruka_fc3", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Luka>Wow, you are so amazing!", "ruka_fc3", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Luka>I'm not scared of you!", "ruka_fc3", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Luka>Well, I want money...", "ruka_fc3", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Luka>Well, I want an Item...", "ruka_fc3", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Luka>Hey, please be my friend!", "ruka_fc3", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Luka>If you continue like this, you'll be in terrible trouble...?", "ruka_fc3", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Luka>Please stand back quietly from here.", "ruka_fc3", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Luka>Then Mr. Smith was scratched by a cat...", "ruka_fc3", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Luka>When I opened the curtain, there was a lady next to me...", "ruka_fc3", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Luka>So, when I was walking near the grave...", "ruka_fc3", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Luka>The futon... was blown away...", "ruka_fc3", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Luka>It's the power of the Spirit of Words... Now, listen to me...", "ruka_fc3", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Luka>Let's go to Luka's exciting laboratory!", "ruka_fc3", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Luka>Now, prepare for the crisis!", "ruka_fc3", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Luka>Now, let's convert the energy...", "ruka_fc3", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Luka>I will alchemize \nItem!", "ruka_fc3", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Luka>This is the power of the magic book...!", "ruka_fc3", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Luka>This is also for the page...", "ruka_fc3", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Luka>Makina activated...Let's go!", "ruka_fc3", 0],
      },
      [2246] => { # ビームデスサイズ
        :word_1 => ["\\n<Luka>Cut into pieces with the \n beam blade!", "ruka_fc3", 0],
      },
      [2250] => { # 反粒子レールガン
        :word_1 => ["\\n<Luka>Disappear...Anti-particle railgun!", "ruka_fc3", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Luka>I'm confident in my cooking skills!", "ruka_fc3", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Luka>Well, what can be used as ingredients...", "ruka_fc3", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc3", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Luka>Calm down, I'll treat you right away!", "ruka_fc3", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Luka>Now, use this medicine... \n Hehe, hehehehehe...", "ruka_fc3", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Luka>I'll give you an injection! Hey!", "ruka_fc3", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Luka>Things like this are fun... \n Hehe, hehehehehe...", "ruka_fc3", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Luka>Excuse me for a moment...", "ruka_fc3", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Luka>Tea is here...it's homemade by me.", "ruka_fc3", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Luka>Let's go! Maid change!", "ruka_fc3", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Luka>Will we be able to harvest it soon...?", "ruka_fc3", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Luka>This is the king's sword technique!", "ruka_fc3", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Luka>This is the king's magic!", "ruka_fc3", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Luka>Everyone, please lend me your strength!", "ruka_fc3", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Luka>Dispel evil, divine power!", "ruka_fc3", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Luka>This is the power of the king...!", "ruka_fc3", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Luka>God, please give me a miracle...!", "ruka_fc3", 0],
      },
      [2432] => { # やたらめった斬り
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Kyoeeeeee!!", "ruka_fc3", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc3", 0],
      },
      [2433] => { # 我流ファイア斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>I'll do it my way...! \n It's a flaming sword!", "ruka_fc3", 0],
      },
      [2434] => { # 燃えろ！ぐるぐる斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn, my fighting spirit! \n Special, round and round slash!", "ruka_fc3", 0],
      },
      [2435] => { # 妖魔斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Defeat evil with the hero's blade!", "ruka_fc3", 0],
      },
      [2436] => { # 不死斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Return to dust with the hero's blade!", "ruka_fc3", 0],
      },
      [2437] => { # 烈火天翔閃
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade of blazing fire, judge evil! \n Recca Tensho Flash!", "ruka_fc3", 0],
      },
      [2438] => { # 紅蓮廻天斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blowing Sabe, Crimson Blade! \n Guren Kaitenzan!", "ruka_fc3", 0],
      },
      [2439] => { # 紅蓮炎舞
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Transform into a crimson lotus and dance! \n Guren Enmai!", "ruka_fc3", 0],
      },
      [2440] => { # プラズマブレイク
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dispel the darkness! Plasma break!", "ruka_fc3", 0],
      },
      [2441] => { # シャドウブレイク
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Cut off the light! Shadow Break!", "ruka_fc3", 0],
      },
      [2444] => { # 烈心聖光斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade of light, cut off the darkness! Zealous Light Slash!", "ruka_fc3", 0],
      },
      [2431] => { # シャドウラプソディ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance with the darkness...Shadow Rhapsody!", "ruka_fc3", 0],
      },
      [2442] => { # グランドリオン
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of justice cuts everything! \nWith unwavering faith! Grand Lion!", "ruka_fc3", 0],
      },
      [2443] => { # ヴェルデリオン
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The fighting spirit of darkness destroys the light! \nWith unwavering faith! Veldt Lion!", "ruka_fc3", 0],
      },
      [2446] => { # アルティメットメサイア
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate salvation... \n Along with light! Ultimate Messiah!", "ruka_fc3", 0],
      },
      [2447] => { # シャドウメサイア
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the implied salvation... \n Dance in the darkness! Shadow Messiah!", "ruka_fc3", 0],
      },
      [2448] => { # エレメント・スピカ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Put the power of the four spirits into your hands...!", "ruka_fc3", 0],
      },
      [2453] => { # 烈心天塵英雄剣
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The ultimate secret of the hero...Resshin Tenjin Hero Sword!", "ruka_fc3", 0],
      },
      [2449] => { # カドラプル・ギガ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Four spirits, give me power... \n This is the end! Quadruple Giga!!", "ruka_fc3", 0],
      },
      [2450] => { # 烈心天塵剣
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Righteous light, ominous heavenly dust... \n Now is the time to become one! Retsushin Tenjinken!", "ruka_fc3", 0],
      },
      [2454] => { # イクスタプル・ゼタ
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The four spirits, the Kirin, and the ice butterfly... \n With everyone's power, EX-tuple Zeta!!", "ruka_fc3", 0],
      },
      [2445] => { # 天塵剣
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Carve, the blade of heavenly dust...haaah!", "ruka_fc3", 0],
      },
      [2451] => { # エンジェルダスト
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Turn angels into dust...Angel dust!", "ruka_fc3", 0],
      },
      [2452] => { # 八夜羅刹斬
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The night of Rakshasa goes around... Eight nights of Rakshasa slash!", "ruka_fc3", 0],
      },
      [2457] => { # ブレイブウォール
        :ct_pic => "80_ruka_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the divine protection!", "ruka_fc3", 0],
      },
      [2455] => { # ロゴス・マギア
        :ct_pic => "iv_rukab3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Father of Chaos>■■■■■■■■■■■■...!!", "ruka_fc3", 0],
      },
      [2458] => { # 勇者の号令
        :word_1 => ["\\n<Luka>Everyone, let's go with all our might!", "ruka_fc3", 0],
        :word_2 => ["\\n<Luka>No matter what enemy we are, we can defeat it!", "ruka_fc3", 0],
        :word_3 => ["\\n<Luka>Win this battle and save the world!", "ruka_fc3", 0],
        :word_4 => ["\\n<Luka>Make every battle for the hero!", "ruka_fc3", 0],
        :word_5 => ["\\n<Luka>I will definitely win this battle!", "ruka_fc3", 0],
        :word_6 => ["\\n<Luka>In the name of the hero... everyone, let's go!!", "ruka_fc3", 0],
        :word_7 => ["\\n<Luka>Our struggle will bring us victory!!", "ruka_fc3", 0],
        :word_8 => ["\\n<Luka>Muster up your fighting spirit...let's go!", "ruka_fc3", 0],
        :word_9 => ["\\n<Luka>There's a party tonight!!", "ruka_fc3", 0],
        :word_10 => ["\\n<Luka>Let's go, to gain the glory of victory!", "ruka_fc3", 0],
      },
      [9546] => { # 黎明の魔眼
        :word_1 => ["\\n<Luka>The third eye judges evil... The evil eye of dawn!", "ruka_fc3", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc3", 0],
      },
      [9639] => { # コキュートス
        :word_1 => ["\\n<Luka>Sleep in the eternal ice of the demon world... Cocytus!", "ruka_fc3", 0],
      },
      [9651] => { # 波動砲
        :word_1 => ["\\n<Luka>Disappear...wave motion gun!", "ruka_fc3", 0],
      },
      [9674] => { # 特級神具VIII:アグニカノン
        :word_1 => ["\\n<Luka>Destroy in flames, Agnicanon!", "ruka_fc3", 0],
      },
      [9675] => { # 特級神具IV:メルクリウス
        :word_1 => ["\\n<Luka>Freeze and break, Mercury!", "ruka_fc3", 0],
      },
      [9676] => { # 特級神具V:エクスパルサー
        :word_1 => ["\\n<Luka>Electric shock irradiation, Expulser!", "ruka_fc3", 0],
      },
      [9673] => { # 神具XIII:ユダ
        :word_1 => ["\\n<Luka>Blow away, Judas!", "ruka_fc3", 0],
      },
      [9677] => { # 特級神具IV:ガイアグラビディ
        :word_1 => ["\\n<Luka>Crush it, Gaia Gravidi!!", "ruka_fc3", 0],
      },
      [9678] => { # 特級神具IX:セントフレア
        :word_1 => ["\\n<Luka>Pierce, Saint Flare!!", "ruka_fc3", 0],
      },
      [9679] => { # エンドフルバースト
        :word_1 => ["\\n<Luka>All firearms activated...Endful burst!", "ruka_fc3", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Luka>Are you okay? It's just a first aid measure...", "ruka_fc3", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Luka>Lady Ilias, please bless me...!", "ruka_fc3", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Luka>...!", "ruka_fc3", 0],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Luka>Power to the blade...!", "ruka_fc3", 0],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Luka>Ohhh...!!", "ruka_fc3", 0],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Luka>This is my full power...!!", "ruka_fc3", 0],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Luka>This is the final secret...!", "ruka_fc3", 0],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Luka>Concentrate on your fist...", "ruka_fc3", 0],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Luka>This body is like steel...!", "ruka_fc3", 0],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Luka>The ultimate in concentration, the final effort...", "ruka_fc3", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Luka>With the help of \n Elemental...!", "ruka_fc3", 0],
      },
      [3111] => { # 四精霊同時召喚
        :word_1 => ["\\n<Luka>Come out, Sylph, Gnome, Undine, Salamander... \n Four spirits are summoned at the same time!", "ruka_fc3", 0],
      },
      [3116] => { # 明鏡止水
        :word_1 => ["\\n<Luka>This heart, in the flow of water...", "ruka_fc3", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Luka>Calm down and take a deep breath...", "ruka_fc3", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Luka>Calm down, this is first aid...", "ruka_fc3", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Luka>This is how I fight!", "ruka_fc3", 0],
      },
      [3121] => { # 背水
        :word_1 => ["\\n<Luka>This is how I fight!", "ruka_fc3", 0],
      },
      [3123] => { # 究極背水
        :word_1 => ["\\n<Luka>This is the ultimate predicament...!", "ruka_fc3", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Luka>Ohhhh...!!", "ruka_fc3", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Luka>Let's go...!　Hmmmm!!", "ruka_fc3", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Luka>Why am I... Magical☆Henshin ♪", "ruka_fc3", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Luka>Be quiet!", "ruka_fc3", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Luka>Okay, I'll request reinforcements!", "ruka_fc3", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Luka>Break that power!", "ruka_fc3", 0],
      },
      [3132] => { # ウェポンブレイク
        :word_1 => ["\\n<Luka>Breaking that power... Ha!", "ruka_fc3", 0],
      },
      [3133] => { # アーマーブレイク
        :word_1 => ["\\n<Luka>Shatter that defense... Ha!", "ruka_fc3", 0],
      },
      [3134] => { # マジックブレイク
        :word_1 => ["\\n<Luka>Breaking that magic... Ha!", "ruka_fc3", 0],
      },
      [3135] => { # マインドブレイク
        :word_1 => ["\\n<Luka>Shatter that spirit... Ha!", "ruka_fc3", 0],
      },
      [3136] => { # スピードブレイク
        :word_1 => ["\\n<Luka>Breaking that speed... Ha!", "ruka_fc3", 0],
      },
      [3137] => { # テクニックブレイク
        :word_1 => ["\\n<Luka>Breaking that skill... Ha!", "ruka_fc3", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Luka>Geyser, gush!", "ruka_fc3", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Luka>Don't move! Sit down!", "ruka_fc3", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Luka>Ehehe, I'll take it...", "ruka_fc3", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Luka>Why me... \n Se, sexy beam...", "ruka_fc3", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Luka>What is this! Pink Typhoon...", "ruka_fc3", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Luka>It's crap! Fantastic Hurricane♪", "ruka_fc3", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Luka>Come on, it's my stage!", "ruka_fc3", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Luka>Alright, I'll work a lot today too!", "ruka_fc3", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Luka>Pafupafu... there's no way I can do it!", "ruka_fc3", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Luka>The power of a hidden weapon...!", "ruka_fc3", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Luka>The power of grudge...!", "ruka_fc3", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Luka>...Blitzkrieg!!", "ruka_fc3", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Luka>My grudge...!", "ruka_fc3", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Luka>This is the holy grail miracle!", "ruka_fc3", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Luka>The power of the aura!", "ruka_fc3", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Luka>This is... witchcraft!", "ruka_fc3", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Luka>Huh!", "ruka_fc3", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Luka>I will protect you...!", "ruka_fc3", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Luka>Ahengers...Assemble!!", "ruka_fc3", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Luka>Double up!", "ruka_fc3", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Luka>Next action, order!", "ruka_fc3", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Luka>Concentrate your power on one point...!", "ruka_fc3", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc3", 0],
      },
      [9759] => { # ラストエクリプス
        :word_1 => ["\\n<Luka>Arrival, the final eclipse of chaos...", "ruka_fc3", 0],
      },
      [9760] => { # デスジェネシス
        :word_1 => ["\\n<Luka>The end is the beginning...Death Genesis!", "ruka_fc3", 0],
      },
      [9761] => { # ゼロユニバース
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc3", 0],
      },
      [9762] => { # 反物質対消滅
        :word_1 => ["\\n<Luka>Forbidden power, antimatter versus annihilation...", "ruka_fc3", 0],
      },
      [9763] => { # 次元削除
        :word_1 => ["\\n<Luka>Let's delete this dimension...", "ruka_fc3", 0],
      },
      [9764] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■...", "ruka_fc3", 0],
      },
      [9765] => { # ゼロシフト
        :word_1 => ["\\n<Luka>Bringing equilibrium to chaos...Zero shift!", "ruka_fc3", 0],
      },
      [3285] => { # 誘惑専用
        :word_y1 => ["\\n<Luka>I can't stand this... \n Ah, we're in battle...", "ruka_fc3", 0],
      },
    },
    4 => { # ルカ
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Luka>Hyaah!", "ruka_fc99", 0],
        :word_2 => ["\\n<Luka>Huh!", "ruka_fc99", 0],
        :word_3 => ["\\n<Luka>Hey!", "ruka_fc99", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc99", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go... Yay!", "ruka_fc99", 0],
      },
      [917] => { # 切り返し
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>It's a cutback... Yay!", "ruka_fc99", 0],
      },
      [918] => { # 疾風突き
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a wind...Poke!", "ruka_fc99", 0],
      },
      [919] => { # 払車剣
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The sword flashes, like a wheel...Kurumaken!", "ruka_fc99", 0],
      },
      [920] => { # 諸刃斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>I'm ready, it's a double-edged sword!", "ruka_fc99", 0],
      },
      [921] => { # 隼斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Like a falcon...slash multiple times!", "ruka_fc99", 0],
      },
      [922] => { # 火炎斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take shelter, flame... yay!", "ruka_fc99", 0],
      },
      [923] => { # 氷斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take shelter, ice... Yay!", "ruka_fc99", 0],
      },
      [924] => { # 稲妻斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Stay, lightning... Yay!", "ruka_fc99", 0],
      },
      [930] => { # エンジェルダンス
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade, dance to the heavens... \n Angel dance!", "ruka_fc99", 0],
      },
      [931] => { # 真空斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Vacuum blade... Ha!", "ruka_fc99", 0],
      },
      [932] => { # 烈風剣
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance, blade of fierce wind!　Aaah!!", "ruka_fc99", 0],
      },
      [933] => { # 月影の太刀
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>May dances... Shura's sword!", "ruka_fc99", 0],
      },
      [934] => { # 魔神斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Demon God's blow! Ha!!", "ruka_fc99", 0],
      },
      [935] => { # デッドクラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of destruction brings death...Dead Crash!", "ruka_fc99", 0],
      },
      [936] => { # 二刀十字斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Get close and take a look! Two-sword cross slash!", "ruka_fc99", 0],
      },
      [937] => { # 魔剣・首刈り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Shine, the blade of courage! Magic sword/decapitation!", "ruka_fc99", 0],
      },
      [938] => { # 血裂雷鳴突き
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Tear the darkness and shine the light! Thunder thrust!", "ruka_fc99", 0],
      },
      [942] => { # フレイムスラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn it down, a flash of red... \n Flame Slash!", "ruka_fc99", 0],
      },
      [943] => { # アイススラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Freezing, a flash of blue... \n Ice slash!", "ruka_fc99", 0],
      },
      [944] => { # サンダースラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Knead it down, a flash of yellow... \n Thunder Slash!", "ruka_fc99", 0],
      },
      [945] => { # 斬魔の舞
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The evil blade that destroys demons! \n Dancing in the light is Zanma no Mai!", "ruka_fc99", 0],
      },
      [946] => { # 屠竜撃
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go, the blow that slays the dragon!", "ruka_fc99", 0],
      },
      [947] => { # 雲身払車剣
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Kasumi's blade, like a wheel... Cloud body-wielding Kurumaken!", "ruka_fc99", 0],
      },
      [948] => { # 滅世斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>A dark blade that ends this world... Destruction!", "ruka_fc99", 0],
      },
      [950] => { # 瞬剣・疾風迅雷
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Sylph, give me power...! Shunken: Gale and lightning!", "ruka_fc99", 0],
      },
      [953] => { # 死剣・乱れ星
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Twinkling Meteor Sword Technique...Death Sword, Disturbing Star!", "ruka_fc99", 0],
      },
      [954] => { # 魔影流星斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Look at the dark meteor falling on the earth... Demon Shadow Meteor Slash!", "ruka_fc99", 0],
      },
      [959] => { # ギガスラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate flash... \n Giga Slash!", "ruka_fc99", 0],
      },
      [960] => { # ラウンドオブビリオン
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the miracle of the holy sword...Round of Billion!", "ruka_fc99", 0],
      },
      [961] => { # 月下散華
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Spring dies under the moon... Sanka under the moon!", "ruka_fc99", 0],
      },
      [962] => { # 魔刃・雪時雨
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The endless slash of the Rakshasa...Magic blade, Yuki Shigure!", "ruka_fc99", 0],
      },
      [964] => { # ジャスティスヘブン
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Judgment of justice, execution of divine will... \n Sword of condemnation! Justice Heaven!", "ruka_fc99", 0],
      },
      [965] => { # 閃殺
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The principle of space-time, the severance is my blade of lightning!", "ruka_fc99", 0],
      },
      [966] => { # 烈空堕天斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The sword that fell to the earth, looks up to the sky and tears apart everything! \n Shine in the eastern sky! Split Sky Fallen Slash!", "ruka_fc99", 0],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Fast like a gale, fast like thunder...! \n Instant strike, gale of thunder!", "ruka_fc99", 0],
      },
      [969] => { # 諸刃微塵斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Even if this body decays... it's a double-edged sword!", "ruka_fc99", 0],
      },
      [973] => { # アトミックスラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase \n, a flash of nuclear heat... Atomic Slash!", "ruka_fc99", 0],
      },
      [974] => { # クァンタスラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of quantum... Quantus Slash!", "ruka_fc99", 0],
      },
      [975] => { # イオンスラッシュ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Erase it, a flash of atoms... ion slash!", "ruka_fc99", 0],
      },
      [9009] => { # ギガスラッシュクロス
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Double flash! Giga Slash Cross!", "ruka_fc99", 0],
      },
      [9013] => { # 九重の羅刹
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Rakshasa's jaw gate has defeated the army and banished evil!", "ruka_fc99", 0],
      },
      [9022] => { # 天軍の剣
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc99", 0],
      },
      [9023] => { # 天軍滅星
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Take it, the holy sword that unites the angel army!", "ruka_fc99", 0],
      },
      [9016] => { # 乱れ雪月花
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Snow dance...moon shadow...flowers and scattering...!", "ruka_fc99", 0],
      },
      [971] => { # 聖光六閃斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Catch \n, a continuous attack of light... Six flashes of holy light!", "ruka_fc99", 0],
      },
      [970] => { # メギドカリバーン
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>mowing down with the wave of darkness! Megiddo Caliburn!", "ruka_fc99", 0],
      },
      [9014] => { # メギドカブラ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate mystery of the magic sword! Megidokabura!", "ruka_fc99", 0],
      },
      [976] => { # 癒しの剣
        :word_1 => ["\\n<Luka>Healing sword, God's blessings!", "ruka_fc99", 0],
      },
      [977] => { # 奇跡の剣
        :word_1 => ["\\n<Luka>Miraculous sword, divine protection!", "ruka_fc99", 0],
      },
      [978] => { # 大奇跡の剣
        :word_1 => ["\\n<Luka>Healing sword, God's miracle!", "ruka_fc99", 0],
      },
      [979] => { # 超奇跡の剣
        :word_1 => ["\\n<Luka>Super miraculous sword, great healing!", "ruka_fc99", 0],
      },
      [972] => { # 闇天
        :word_1 => ["\\n<Luka>The blade of Shura that cuts everything...Dark Heaven!", "ruka_fc99", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Luka>Let's go, Rapier of Justice! Ha!", "ruka_fc99", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Luka>Stake your pride on this blade!", "ruka_fc99", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Luka>A flash with this blade... Hey!", "ruka_fc99", 0],
      },
      [1007] => { # 峰打ち
        :word_1 => ["\\n<Luka>I'll make you sleep...Mineuchi!", "ruka_fc99", 0],
      },
      [1008] => { # 三連斬
        :word_1 => ["\\n<Luka>Repeated carving, triple slash!", "ruka_fc99", 0],
      },
      [1009] => { # 居合い抜き
        :word_1 => ["\\n<Luka>Cut off with a single sword! Iainuki!", "ruka_fc99", 0],
      },
      [1010] => { # 牙突
        :word_1 => ["\\n<Luka>Penetrate everything! Fangs!", "ruka_fc99", 0],
      },
      [1011] => { # 居合い・焔ノ太刀
        :word_1 => ["\\n<Luka>Burn it down, the Crimson Blade! Homura no Tachi!", "ruka_fc99", 0],
      },
      [1012] => { # 居合・吹雪ノ太刀
        :word_1 => ["\\n<Luka>Freezing, extremely cold blade! Fubuki no Tachi!", "ruka_fc99", 0],
      },
      [1013] => { # 居合・雷土ノ太刀
        :word_1 => ["\\n<Luka>Flash, the blade of lightning! Raito no Tachi!", "ruka_fc99", 0],
      },
      [1018] => { # 滅魂刀
        :word_1 => ["\\n<Luka>I will destroy that soul... ha!", "ruka_fc99", 0],
      },
      [1019] => { # 斬神斬魔
        :word_1 => ["\\n<Luka>Cut off the gods and destroy the demons...!", "ruka_fc99", 0],
      },
      [1022] => { # 縮地・焔閃
        :word_1 => ["\\n<Luka>A flash of a blade like a blink of an eye... Shrinkage, flame flash!", "ruka_fc99", 0],
      },
      [1023] => { # 魔刀・明鏡止水
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Follow the flow of water...Magic sword, Myokyo water stop!", "ruka_fc99", 0],
      },
      [1024] => { # 神刀・鏡花水月
        :word_1 => ["\\n<Luka>Clear, pure flash... Divine sword Kyoka Suigetsu!", "ruka_fc99", 0],
      },
      [1025] => { # 微塵滅閃
        :word_1 => ["\\n<Luka>The devil's blade is carved into fine dust... A fine flash!", "ruka_fc99", 0],
      },
      [1026] => { # 聖刃七星天
        :word_1 => ["\\n<Luka>I look up and see the Seven Pole Stars... \n Twinkle in the heavens and earth, the Holy Blade Seven Stars of Heaven!", "ruka_fc99", 0],
      },
      [1027] => { # 桜花幻舞
        :word_1 => ["\\n<Luka>The cherry blossoms are falling, the dancing is a dream...", "ruka_fc99", 0],
      },
      [1028] => { # 天墜
        :word_1 => ["\\n<Luka>Fall... Fall from heaven!", "ruka_fc99", 0],
      },
      [9041] => { # 十四連斬
        :word_1 => ["\\n<Luka>14 consecutive slashes...tee!!", "ruka_fc99", 0],
      },
      [1030] => { # 居合い・伊邪那岐
        :word_1 => ["\\n<Luka>Nagigu is a fresh blade... Iai Izanagi!", "ruka_fc99", 0],
      },
      [1031] => { # 居合い・伊邪那美
        :word_1 => ["\\n<Luka>Nagigu is the blade of death... Iai Izanami!", "ruka_fc99", 0],
      },
      [9044] => { # 修羅の舞い
        :word_1 => ["\\n<Luka>Crazy bloom! The dance of Shura is stained with scattered blood...!", "ruka_fc99", 0],
      },
      [9046] => { # 終ノ閃
        :word_1 => ["\\n<Luka>Crush into nothingness, the final flash...", "ruka_fc99", 0],
      },
      [9045] => { # 神祖烈星斬
        :word_1 => ["\\n<Luka>Cuts off the stars, God Ancestor Retsuseizan!", "ruka_fc99", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Luka>By the pride of the white blade!", "ruka_fc99", 0],
      },
      [1032] => { # 心頭滅却
        :word_1 => ["\\n<Luka>My heart is lost, fire is also cool...", "ruka_fc99", 0],
      },
      [1033] => { # 肉斬骨断
        :word_1 => ["\\n<Luka>Cut the flesh and cut the bones! Here we go!", "ruka_fc99", 0],
      },
      [1034] => { # 切り捨て御免
        :word_1 => ["\\n<Luka>Now... I'm sorry for cutting it off!", "ruka_fc99", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Luka>Be honest here...!", "ruka_fc99", 0],
      },
      [1037] => { # 則天去私
        :word_1 => ["\\n<Luka>This heart is my state...", "ruka_fc99", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Luka>Pierce, the hero's spear!", "ruka_fc99", 0],
      },
      [1052] => { # レクイエムランス
        :word_1 => ["\\n<Luka>No mercy for the divine enemy, only a funeral! \n Destroy in darkness! Requiem Lance!", "ruka_fc99", 0],
      },
      [1060] => { # サン・エリアル
        :word_1 => ["\\n<Luka>The goddess uses her spear to ward off endless evil! \n San ​​Erial!", "ruka_fc99", 0],
      },
      [1063] => { # サン・ミラージュ
        :word_1 => ["\\n<Luka>The goddess uses her spear to pierce through evil and show justice! \n Sun Mirage!", "ruka_fc99", 0],
      },
      [1075] => { # 螺旋光槍
        :word_1 => ["\\n<Luka>Spiral light spear, pierce the evil darkness! \n Spiral light spear!", "ruka_fc99", 0],
      },
      [1076] => { # 滅魔閃槍
        :word_1 => ["\\n<Luka>The flashing spear that pierces the darkness, bring destruction to all evil! \n Demon Flash Spear!", "ruka_fc99", 0],
      },
      [1077] => { # フォトンランサー
        :word_1 => ["\\n<Luka>Destroy evil, holy photon! \n Photon Lancer!", "ruka_fc99", 0],
      },
      [1078] => { # ニーベルンヴァレスティ
        :word_1 => ["\\n<Luka>The secret technique of destroying evil, carve it into your body! \n Nibeln Valesti!", "ruka_fc99", 0],
      },
      [9054] => { # スターダストエンド
        :word_1 => ["\\n<Luka>Break, stardust! Stardust End!", "ruka_fc99", 0],
      },
      [9059] => { # 天軍乱槍
        :word_1 => ["\\n<Luka>This is the spear technique of the leader of the Heavenly Army... the Tengun Ranspear!", "ruka_fc99", 0],
      },
      [1085] => { # 祈りの聖槍
        :word_1 => ["\\n<Luka>Pray for the spear...", "ruka_fc99", 0],
      },
      [1086] => { # 奇跡の聖槍
        :word_1 => ["\\n<Luka>Goddess Ilias, do a miracle on the holy spear!", "ruka_fc99", 0],
      },
      [1087] => { # 聖槍チャージ
        :word_1 => ["\\n<Luka>Holy spear, power to cut off evil!", "ruka_fc99", 0],
      },
      [1088] => { # 聖槍ガード
        :word_1 => ["\\n<Luka>Holy spear, wall of protection!", "ruka_fc99", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Luka>Energy charge... Ha!", "ruka_fc99", 0],
      },
      [1092] => { # ハイチャージ
        :word_1 => ["\\n<Luka>Energy charge... Ha!", "ruka_fc99", 0],
      },
      [1093] => { # エクセルチャージ
        :word_1 => ["\\n<Luka>Ki maximum charge... Ha!", "ruka_fc99", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Luka>Desolation, the hero's axe!", "ruka_fc99", 0],
      },
      [1112] => { # 壊斧・大山鳴動
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Lend me your strength, Norm! Breaking axe, Oyama Rado!!", "ruka_fc99", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Luka>Ax, go wild!", "ruka_fc99", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Luka>Let's go, club handling inherited from Sonya!", "ruka_fc99", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Luka>Sickle, cut away evil!", "ruka_fc99", 0],
      },
      [1158] => { # 連斬かまいたち
        :word_1 => ["\\n<Luka>Slash and tear, whirlwind sickle... \n consecutive slashes!", "ruka_fc99", 0],
      },
      [1169] => { # 死連刃
        :word_1 => ["\\n<Luka>The blades of annihilation overlap each other, carving and dividing the number of lives!", "ruka_fc99", 0],
      },
      [1170] => { # レクイエムリーパー
        :word_1 => ["\\n<Luka>You are invited to the requiem, and you should scatter...", "ruka_fc99", 0],
      },
      [9078] => { # 魔神黒鎌
        :word_1 => ["\\n<Luka>The devil's sickle combs the soul...!", "ruka_fc99", 0],
      },
      [9080] => { # エンドレスサイズ
        :word_1 => ["\\n<Luka>Endless flash of sickle...endless size!", "ruka_fc99", 0],
      },
      [9083] => { # エンドオブエンド
        :word_1 => ["\\n<Luka>This is the ultimate end...!", "ruka_fc99", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Luka>This is also the power of the sickle...!", "ruka_fc99", 0],
      },
      [9081] => { # 罪と罰
        :word_1 => ["\\n<Luka>Dust is dust, crime and punishment...!", "ruka_fc99", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Luka>Pierce, arrow of the hero!", "ruka_fc99", 0],
      },
      [1196] => { # キューピッドアロー
        :word_1 => ["\\n<Luka>Aim for that heart! \n Cupid Arrow!", "ruka_fc99", 0],
      },
      [1197] => { # オーラスター
        :word_1 => ["\\n<Luka>Lost in the stars, arrow of holy flow! \n Aura Star!", "ruka_fc99", 0],
      },
      [1217] => { # ネビュラリフレクト
        :word_1 => ["\\n<Luka>Pierce, Ikusei Ichiya! \n Nebula Reflect!", "ruka_fc99", 0],
      },
      [1218] => { # コズミックダスト
        :word_1 => ["\\n<Luka>Rain from the galaxy! \n Cosmic Dust!", "ruka_fc99", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Luka>Rain down, healing arrows!", "ruka_fc99", 0],
      },
      [9098] => { # サウザンドムーン
        :word_1 => ["\\n<Luka>Pierce, thousands of lights...thousand moon!", "ruka_fc99", 0],
      },
      [9088] => { # アモールレイン
        :word_1 => ["\\n<Luka>Rain down, great arrows of love... Amor Rain!", "ruka_fc99", 0],
      },
      [9100] => { # シナイの神火
        :word_1 => ["\\n<Luka>The divine flame that consumes evil...the divine fire of Sinai!", "ruka_fc99", 0],
      },
      [9099] => { # イスカリオテの雨
        :word_1 => ["\\n<Luka>It's raining, Iscariot's rain!", "ruka_fc99", 0],
      },
      [9101] => { # 天上天下唯我独尊
        :word_1 => ["\\n<Luka>Lady Ilias's technique...!", "ruka_fc99", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Luka>Strike the darkness with the whip of justice!", "ruka_fc99", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Luka>Come, servant!", "ruka_fc99", 0],
      },
      [9114] => { # 黙示の神鞭
        :word_1 => ["\\n<Luka>Take the whip of the end upon yourself...!", "ruka_fc99", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Luka>It's a boomerang! Hey!", "ruka_fc99", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Luka>Oh! Let's go!", "ruka_fc99", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Luka>Fan, dance!", "ruka_fc99", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Luka>Aim and shoot...!", "ruka_fc99", 0],
      },
      [9147] => { # 跳弾乱舞
        :word_1 => ["\\n<Luka>Let's go, Ricochet Rainstorm...!", "ruka_fc99", 0],
      },
      [9149] => { # 至高の魔弾
        :word_1 => ["\\n<Luka>The supreme magic bullet that pierces everything...!", "ruka_fc99", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Luka>It's a healing bullet!", "ruka_fc99", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc99", 0],
      },
      [1374] => { # ミックスゲイズ
        :word_1 => ["\\n<Luka>Blade and fist, mix gaze!", "ruka_fc99", 0],
      },
      [1377] => { # クレイジータイム
        :word_1 => ["\\n<Luka>Take it, hail the rain of blades and fists! \nCrazy time!", "ruka_fc99", 0],
      },
      [1381] => { # ツインオプティック
        :word_1 => ["\\n<Luka>The endless blade that mowing down...Twin Optic!", "ruka_fc99", 0],
      },
      [1382] => { # アームドインフェルノ
        :word_1 => ["\\n<Luka>Look at the hell of the \n blade...Armed Inferno!", "ruka_fc99", 0],
      },
      [1383] => { # アサルトランタイム
        :word_1 => ["\\n<Luka>The secret of the fist blade... Assault run time!", "ruka_fc99", 0],
      },
      [1387] => { # サウザンドブレイド
        :word_1 => ["\\n<Luka>Dance to a thousand blades...Thousand Blades!", "ruka_fc99", 0],
      },
      [1390] => { # マキシマムランタイム
        :word_1 => ["\\n<Luka>Dance, the final blade storm... Maximum Runtime!", "ruka_fc99", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Luka>Blades in both hands, slash wildly!", "ruka_fc99", 0],
      },
      [1393] => { # セカンドシフト
        :word_1 => ["\\n<Luka>Blades in both hands, slash wildly!", "ruka_fc99", 0],
      },
      [1394] => { # サードシフト
        :word_1 => ["\\n<Luka>Look closely, a storm of blades!", "ruka_fc99", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc99", 0],
      },
      [1400] => { # 足払い
        :word_1 => ["\\n<Luka>There is a chance! Foot sweep!", "ruka_fc99", 0],
      },
      [1401] => { # 飛び膝蹴り
        :word_1 => ["\\n<Luka>I received \n! Flying knee kick!", "ruka_fc99", 0],
      },
      [1402] => { # 回し蹴り
        :word_1 => ["\\n<Luka>Kick away, roundhouse kick!", "ruka_fc99", 0],
      },
      [1403] => { # 秘孔
        :word_1 => ["\\n<Luka>I saw \n! Secret hole!", "ruka_fc99", 0],
      },
      [1405] => { # 正拳突き
        :word_1 => ["\\n<Luka>Put all your spirit into it... A true fist thrust!", "ruka_fc99", 0],
      },
      [1406] => { # 羅刹掌
        :word_1 => ["\\n<Luka>Now, turn into a Rakshasa! Rakshasa palm!", "ruka_fc99", 0],
      },
      [1407] => { # 爆裂拳
        :word_1 => ["\\n<Luka>An explosive fist that can't be stopped!", "ruka_fc99", 0],
      },
      [1408] => { # 電塵連脚
        :word_1 => ["\\n<Luka>Lightning legs that can't be stopped by the eyes!", "ruka_fc99", 0],
      },
      [1425] => { # 聖光裂閃撃
        :word_1 => ["\\n<Luka>Blink, white flash! Holy light splitting flash!", "ruka_fc99", 0],
      },
      [1426] => { # 暗黒連衝拳
        :word_1 => ["\\n<Luka>Engraved \n, black shock! Dark Renchoken!", "ruka_fc99", 0],
      },
      [1427] => { # 四天光掌
        :word_1 => ["\\n<Luka>The four palms of light, dance in disorder in the shining heaven and earth!", "ruka_fc99", 0],
      },
      [1428] => { # 四星滅功
        :word_1 => ["\\n<Luka>Four star destruction, bloom in the dark sky!", "ruka_fc99", 0],
      },
      [1429] => { # 烈気光掌
        :word_1 => ["\\n<Luka>A flash of ki, reaching even the heavens... A fierce light palm!", "ruka_fc99", 0],
      },
      [1430] => { # 瞬獄殺
        :word_1 => ["\\n<Luka>The living are doomed...", "ruka_fc99", 0],
      },
      [9163] => { # 破滅の鉄槌
        :word_1 => ["\\n<Luka>The judgment of the fist... the hammer of destruction!", "ruka_fc99", 0],
      },
      [9156] => { # 零拳
        :word_1 => ["\\n<Luka>Scattered, sub-zero freezing fist... Zero fist!", "ruka_fc99", 0],
      },
      [9165] => { # 聖天轟裂撃
        :word_1 => ["\\n<Luka>Breath of white light... Holy Heaven's roar ruptures!", "ruka_fc99", 0],
      },
      [9166] => { # 魔天冥煌撃
        :word_1 => ["\\n<Luka>The breath of darkness... Demon heaven's glittering attack!", "ruka_fc99", 0],
      },
      [9167] => { # 覆滅陰陽撃
        :word_1 => ["\\n<Luka>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "ruka_fc99", 0],
      },
      [9171] => { # アトミックインパクト
        :word_1 => ["\\n<Luka>I'll crush you with one shot...Atomic Impact!", "ruka_fc99", 0],
      },
      [9173] => { # 天地開闢拳
        :word_1 => ["\\n<Luka>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "ruka_fc99", 0],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Luka>....................", "ruka_fc99", 0],
      },
      [1434] => { # 当て身光掌（発動）
        :word_1 => ["\\n<Luka>I received \n... Atemi Kosho!", "ruka_fc99", 0],
      },
      [1435] => { # 金剛八連拳
        :word_1 => ["\\n<Luka>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "ruka_fc99", 0],
      },
      [1436] => { # 紅蓮大拳舞
        :word_1 => ["\\n<Luka>Dance in disorder, crimson flame! Guren Daikenbu!", "ruka_fc99", 0],
      },
      [9157] => { # 電塵乱皇脚
        :word_1 => ["\\n<Luka>flash, noble thunder! Denjinran Kokyaku!", "ruka_fc99", 0],
      },
      [9159] => { # 真・瞬獄殺
        :word_1 => ["\\n<Luka>The living will be destroyed, all things will be destroyed...", "ruka_fc99", 0],
      },
      [9164] => { # 修羅爆裂拳
        :word_1 => ["\\n<Luka>Shura's fist hits wildly! Yay!!", "ruka_fc99", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...chakra!", "ruka_fc99", 0],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...chakra!", "ruka_fc99", 0],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Luka>Heal the Heavenly Vein... Diffusion chakra!", "ruka_fc99", 0],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Luka>Heal the heavenly veins...the ultimate chakra!", "ruka_fc99", 0],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Luka>Return to your lifeline... Ha!", "ruka_fc99", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Luka>Demon vein, stay in your fist!", "ruka_fc99", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc99", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc99", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Luka>Holy light, destroy the darkness!", "ruka_fc99", 0],
      },
      [9188] => { # リリーマルレーン
        :word_1 => ["\\n<Luka>Along with the beautiful lily... Lily Marlane!", "ruka_fc99", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Luka>Holy will, destroy evil! \n Heaven!", "ruka_fc99", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Luka>Light, give me power!", "ruka_fc99", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Luka>Light, prevent the evil power!", "ruka_fc99", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Luka>Light, cancel the blessings of evil!", "ruka_fc99", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Luka>Black torrent, accept my order!", "ruka_fc99", 0],
      },
      [9209] => { # アシェンライト
        :word_1 => ["\\n<Luka>The fallen angel's magical power turns into holy light... \n Turns darkness into light! Ashen Light!", "ruka_fc99", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Luka>Death's sickle, invite me to the underworld! \n Death!", "ruka_fc99", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Luka>Black torrent, accept my order!", "ruka_fc99", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Luka>It's healing magic...hey!", "ruka_fc99", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Luka>At \n, follow me! Yes!", "ruka_fc99", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Luka>The torrent of time breaks through logic and goes wild!", "ruka_fc99", 0],
      },
      [1561] => { # ブラックホール
        :word_1 => ["\\n<Luka>The abyss of space-time, the empty torrent! \n Sink to zero! Black hole!", "ruka_fc99", 0],
      },
      [1562] => { # スーパーノヴァ
        :word_1 => ["\\n<Luka>The end of reincarnation, the time of regression! \nBlink in the galaxy! Supernova!", "ruka_fc99", 0],
      },
      [9231] => { # カオスコメット
        :word_1 => ["\\n<Luka>Chaos meteorite, pour down in heavy rain... \n Chaos comet!", "ruka_fc99", 0],
      },
      [9232] => { # 妖星乱舞
        :word_1 => ["\\n<Luka>Look up, the star of misfortune... Yousei Ranbu!", "ruka_fc99", 0],
      },
      [9236] => { # カオスグラビディ
        :word_1 => ["\\n<Luka>Let the sickle of gravity crush your body! \n Chaos Gravidy!", "ruka_fc99", 0],
      },
      [9239] => { # 天地崩壊
        :word_1 => ["\\n<Luka>Break, world...", "ruka_fc99", 0],
      },
      [9237] => { # カオスメテオ
        :word_1 => ["\\n<Luka>Chaos meteorite, fill the earth with nothingness...", "ruka_fc99", 0],
      },
      [9240] => { # ワンダーランド・ナイトメア
        :word_1 => ["\\n<Luka>It's time to play...Wonderland Nightmare!", "ruka_fc99", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Luka>Time, stop!", "ruka_fc99", 0],
      },
      [1564] => { # カオスタイム
        :word_1 => ["\\n<Luka>Time, stop... Chaos time!", "ruka_fc99", 0],
      },
      [1566] => { # カオスオーバー
        :word_1 => ["\\n<Luka>Time to freeze... Chaos is over!", "ruka_fc99", 0],
      },
      [1567] => { # カオスクロニクル
        :word_1 => ["\\n<Luka>time is mine... Chaos Chronicle!", "ruka_fc99", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Luka>Holy light, dispel the darkness!", "ruka_fc99", 0],
      },
      [1634] => { # 天の雷
        :word_1 => ["\\n<Luka>Good anger, become a hammer and defeat the darkness!", "ruka_fc99", 0],
      },
      [1635] => { # 滅魔の雷
        :word_1 => ["\\n<Luka>Hammer's thunder, no evil allowed! Exorcism, sound the thunder!", "ruka_fc99", 0],
      },
      [1636] => { # 聖光波
        :word_1 => ["\\n<Luka>Holy light, banish evil and destroy evil!", "ruka_fc99", 0],
      },
      [1637] => { # 汚れなき光
        :word_1 => ["\\n<Luka>Immaculate light, illuminate the darkness and drive away impurity!", "ruka_fc99", 0],
      },
      [1638] => { # グランドクロス
        :word_1 => ["\\n<Luka>The cross of divine will, split the darkness in two!", "ruka_fc99", 0],
      },
      [1639] => { # イノセントレーザー
        :word_1 => ["\\n<Luka>A pure soul, clear your heart and pierce the darkness! \n Innocent Laser!", "ruka_fc99", 0],
      },
      [1640] => { # イノセントジャッジ
        :word_1 => ["\\n<Luka>Pure judgment, destroy darkness! \n Innocent judge!", "ruka_fc99", 0],
      },
      [1642] => { # 天罰
        :word_1 => ["\\n<Luka>Evil life, destroy it with judgment...!", "ruka_fc99", 0],
      },
      [1643] => { # 魔天回帰
        :word_1 => ["\\n<Luka>All lives, return to Mother Heaven...!", "ruka_fc99", 0],
      },
      [1647] => { # ヤルダバオト
        :word_1 => ["\\n<Luka>Show your holy power and destroy the divine enemy... Yaldabaoth!", "ruka_fc99", 0],
      },
      [1648] => { # カオスメサイア
        :word_1 => ["\\n<Luka>Arrival, the Messiah of Chaos...", "ruka_fc99", 0],
      },
      [1649] => { # 魔神忌光
        :word_1 => ["\\n<Luka>Disappear, the light of the devil...!", "ruka_fc99", 0],
      },
      [9270] => { # 魔神輝光
        :word_1 => ["\\n<Luka>Disappear, the shining light of the devil...!", "ruka_fc99", 0],
      },
      [9280] => { # 真・魔神輝光
        :word_1 => ["\\n<Luka>Holy element condensation...! \n Disappear, the brilliant light of the demon god...!", "ruka_fc99", 0],
      },
      [9269] => { # リブラ・レイ
        :word_1 => ["\\n<Luka>Shoot through, Holy Light... Libra Ray!", "ruka_fc99", 0],
      },
      [9273] => { # ホーリーフレア
        :word_1 => ["\\n<Luka>Shine the whitest in this world... \n Holy Flare!", "ruka_fc99", 0],
      },
      [9274] => { # 明けの明星
        :word_1 => ["\\n<Luka>....................", "ruka_fc99", 0],
      },
      [9275] => { # 発動：明けの明星
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc99", 0],
      },
      [9277] => { # 明星魔煌
        :word_1 => ["\\n<Luka>....................", "ruka_fc99", 0],
      },
      [9278] => { # 明星魔煌
        :word_1 => ["\\n<Luka>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "ruka_fc99", 0],
      },
      [9283] => { # 聖天兎々
        :word_1 => ["\\n<Luka>Travelers of time and space, announce the sacred time... Holy Heavenly Rabbits!", "ruka_fc99", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc99", 0],
      },
      [9281] => { # 裁きの雷
        :word_1 => ["\\n<Luka>Receive the thunder of divine will...!", "ruka_fc99", 0],
      },
      [9282] => { # ビッグバン
        :word_1 => ["\\n<Luka>Everything ends and then begins...Big Bang!", "ruka_fc99", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Luka>Ahura Mazda, bring the light of God...", "ruka_fc99", 0],
      },
      [9285] => { # ジャッジメント
        :word_1 => ["\\n<Luka>The promised land rejects you. \n In the hands of this judge, the execution will be carried out...", "ruka_fc99", 0],
      },
      [9268] => { # 聖天
        :word_1 => ["\\n<Luka>Look up at the glorious holy heavens...!", "ruka_fc99", 0],
      },
      [9271] => { # 天軍滅雷
        :word_1 => ["\\n<Luka>Destroy in the name of the leader of the angel army... the thunder of judgment!", "ruka_fc99", 0],
      },
      [9279] => { # 神の洪水
        :word_1 => ["\\n<Luka>It's a flood that will cleanse the world...!", "ruka_fc99", 0],
      },
      [9291] => { # ガブリエラの大祝福
        :word_1 => ["\\n<Luka>This is the ultimate blessing...!", "ruka_fc99", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Luka>Holy light, bring healing!", "ruka_fc99", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Luka>Dedicate your life and drive away the darkness!", "ruka_fc99", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Luka>The warrior's soul breathes life again!", "ruka_fc99", 0],
      },
      [1668] => { # 夢幻天舞
        :word_1 => ["\\n<Luka>The clear mirror, the dawn, the dreamlike heavenly dance...!", "ruka_fc99", 0],
      },
      [1669] => { # 堕天舞踏
        :word_1 => ["\\n<Luka>Uncut and infallible, Fallen Dance...!", "ruka_fc99", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Luka>....................", "ruka_fc99", 0],
      },
      [9272] => { # 聖雷輪舞
        :word_1 => ["\\n<Luka>Rotate divine punishment, dance holy lightning...!", "ruka_fc99", 0],
      },
      [9276] => { # アトミックヘブン
        :word_1 => ["\\n<Luka>Blow everything away, Atomic Heaven!", "ruka_fc99", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Luka>Darkness, roar...!", "ruka_fc99", 0],
      },
      [1675] => { # ダークエターナル
        :word_1 => ["\\n<Luka>The black of the end, fill the darkness...Dark Eternal!", "ruka_fc99", 0],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Luka>In the hour of darkness, cherry blossoms scatter in the dance of flames... \n Tremble to sleep, Majin Flame Dance!", "ruka_fc99", 0],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Luka>In the hour of darkness, being sent and dying is the work of the demon ice... \n Tremble and sleep, the demon ice funeral!", "ruka_fc99", 0],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Luka>In the hour of darkness, a voice cries out in the thunder dust... \n Tremble and sleep, demon thunder dust!", "ruka_fc99", 0],
      },
      [1680] => { # 魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the ultimate demonic moment... \n Reach the darkness, the demon black palm!", "ruka_fc99", 0],
      },
      [1681] => { # ネクローシス
        :word_1 => ["\\n<Luka>Chaos is the root, and the world will return to chaos... \n Necrosis...", "ruka_fc99", 0],
      },
      [1682] => { # アポトーシス
        :word_1 => ["\\n<Luka>Mix ■■ returns ■■■■■ is ■■■... \n appointment ■■...", "ruka_fc99", 0],
      },
      [1685] => { # カオスエクリプス
        :word_1 => ["\\n<Luka>Arrival, the eclipse of chaos...", "ruka_fc99", 0],
      },
      [1686] => { # 魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n Dance in the foam, the phantom dance of the demon!", "ruka_fc99", 0],
      },
      [1687] => { # ハルマゲドン
        :word_1 => ["\\n<Luka>The moment when light and darkness end... Armageddon!", "ruka_fc99", 0],
      },
      [1688] => { # 真・魔神黒掌
        :word_1 => ["\\n<Luka>The black soul, the demonic pole... \n Perish in the darkness, the true demon black palm!", "ruka_fc99", 0],
      },
      [1691] => { # 真・魔神幻舞
        :word_1 => ["\\n<Luka>A black night, a time filled with darkness... \n End in foam, the true demon phantom dance!", "ruka_fc99", 0],
      },
      [1689] => { # シャドウフレア
        :word_1 => ["\\n<Luka>Shine the blackest in this world... \n Shadow Flare!", "ruka_fc99", 0],
      },
      [1694] => { # アンリ・マンユ
        :word_1 => ["\\n<Luka>Henri Mainyu, the hour of darkness has arrived...", "ruka_fc99", 0],
      },
      [9298] => { # ワールドブレイカー
        :word_1 => ["\\n<Luka>Destroy this world...", "ruka_fc99", 0],
      },
      [9294] => { # システム：シルフV2
        :ct_pic => "80_sylph_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>System: Sylph V2... Storm!", "ruka_fc99", 0],
      },
      [9295] => { # ノーム/ガイアGH
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Gnome/Gaia GH launches...shake the earth!", "ruka_fc99", 0],
      },
      [9296] => { # ウンディーネレーザー穿式
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Penetrate! Undine laser piercing type!", "ruka_fc99", 0],
      },
      [9297] => { # サラマンダー終式カノン
        :ct_pic => "80_salamander_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Salamander, burn this world to the ground!", "ruka_fc99", 0],
      },
      [9542] => { # 最後の魔眼
        :word_1 => ["\\n<Luka>Open up, the last evil eye...", "ruka_fc99", 0],
      },
      [2558] => { # 王者の魔眼
        :word_1 => ["\\n<Luka>This is the evil eye of the champion...", "ruka_fc99", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc99", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Luka>Residing in the sword, magical power!", "ruka_fc99", 0],
      },
      [1698] => { # 魔法剣ファイア
        :word_1 => ["\\n<Luka>Dwell in the sword, the power of flame!", "ruka_fc99", 0],
      },
      [1699] => { # 魔法剣ブリザード
        :word_1 => ["\\n<Luka>Residing in the sword, the power of ice!", "ruka_fc99", 0],
      },
      [1700] => { # 魔法剣サンダー
        :word_1 => ["\\n<Luka>Residing in the sword, the power of thunder!", "ruka_fc99", 0],
      },
      [1701] => { # 魔法剣ウィンド
        :word_1 => ["\\n<Luka>Rest in the sword, power of the wind!", "ruka_fc99", 0],
      },
      [1702] => { # 魔法剣アース
        :word_1 => ["\\n<Luka>Rest in the sword, power of the earth!", "ruka_fc99", 0],
      },
      [1703] => { # 魔法剣アクア
        :word_1 => ["\\n<Luka>Rest in the sword, power of water!", "ruka_fc99", 0],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<Luka>Residing in the sword, sacred power!", "ruka_fc99", 0],
      },
      [1705] => { # 魔法剣ダーク
        :word_1 => ["\\n<Luka>Dwell in the sword, power of darkness!", "ruka_fc99", 0],
      },
      [1706] => { # 魔法剣ポイズン
        :word_1 => ["\\n<Luka>Residing in the sword, poisonous magic!", "ruka_fc99", 0],
      },
      [1707] => { # 魔法剣ブライン
        :word_1 => ["\\n<Luka>Dwell in the sword, magic of darkness!", "ruka_fc99", 0],
      },
      [1708] => { # 魔法剣サイレンス
        :word_1 => ["\\n<Luka>Dwell in the sword, magical power of silence!", "ruka_fc99", 0],
      },
      [1709] => { # 魔法剣パラライズ
        :word_1 => ["\\n<Luka>Dwell in the sword, paralyzing magic!", "ruka_fc99", 0],
      },
      [1710] => { # 魔法剣コンフューズ
        :word_1 => ["\\n<Luka>Dwell in the sword, magical power of confusion!", "ruka_fc99", 0],
      },
      [1711] => { # 魔法剣スリープ
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of sleep!", "ruka_fc99", 0],
      },
      [1712] => { # 魔法剣デス
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of death!", "ruka_fc99", 0],
      },
      [1713] => { # 魔法剣ヘブン
        :word_1 => ["\\n<Luka>Residing in the sword, the magic of ascension!", "ruka_fc99", 0],
      },
      [1714] => { # 魔法剣ドレイン
        :word_1 => ["\\n<Luka>Residing in the sword, the power of absorption!", "ruka_fc99", 0],
      },
      [1715] => { # 魔法剣マドレイン
        :word_1 => ["\\n<Luka>Residing in the sword, the magical power of absorption!", "ruka_fc99", 0],
      },
      [1718] => { # 魔法剣カーズ
        :word_1 => ["\\n<Luka>Residing in the sword, cursed magic!", "ruka_fc99", 0],
      },
      [1716] => { # マジックバリア
        :word_1 => ["\\n<Luka>Protect your friends from evil techniques! \n Magic barrier!", "ruka_fc99", 0],
      },
      [1717] => { # マジックリフレクト
        :word_1 => ["\\n<Luka>Heaven's blessing turns to earth and serves as a magic mirror! \n Magic Reflect!", "ruka_fc99", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Luka>It's a Yin-Yang... Hey!", "ruka_fc99", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Luka>The secret of exorcism, the prison of rebellion! \nKnow the reward, Nine Souls Exorcism Formation!", "ruka_fc99", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Luka>A lifetime, sending it is life! \n Engraving the slightest bit...Singing life!", "ruka_fc99", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Luka>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "ruka_fc99", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Luka>I got \n!", "ruka_fc99", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Luka>Proof of a thief!", "ruka_fc99", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Luka>Now I'm running away!", "ruka_fc99", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Luka>Actually, when I was little, I admired ninjas... Yay!", "ruka_fc99", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Luka>Waves of healing, pervade thousands of places... \n Ninja art/healing waves!", "ruka_fc99", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Luka>Autumn Utsusemi dances in the shadows... \n Ninja art/Bunshin no Jutsu!", "ruka_fc99", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Luka>It's a smokescreen!", "ruka_fc99", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Luka>It's a pirate technique! Yay!", "ruka_fc99", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Luka>This is justice! Ha!", "ruka_fc99", 0],
      },
      [1842] => { # 正義のファイヤーパンチ
        :word_1 => ["\\n<Luka>Burn, the fist of justice! \n Fire... Punch!!", "ruka_fc99", 0],
      },
      [1843] => { # 正義のブリザードナックル
        :word_1 => ["\\n<Luka>Sparkle, Fist of Condemnation! \n Blizzard...Naaakkuru!!", "ruka_fc99", 0],
      },
      [1844] => { # 正義のサンダーキック
        :word_1 => ["\\n<Luka>Shine, thunderous kick! \n Thunderaaaaaaa...squeak!!", "ruka_fc99", 0],
      },
      [1845] => { # ヒーロー乱舞
        :word_1 => ["\\n<Luka>This is the fist of justice! \n Haaaaaaaaaaaaa!!", "ruka_fc99", 0],
      },
      [1846] => { # カイザーキック
        :word_1 => ["\\n<Luka>Love and justice... Kaiser kick!", "ruka_fc99", 0],
      },
      [1847] => { # カイザーファイナルソード
        :word_1 => ["\\n<Luka>Kaiser Final Sword of courage and victory!", "ruka_fc99", 0],
      },
      [1848] => { # カイザークライマックスキック
        :word_1 => ["\\n<Luka>Roar justice, shine victory! \nThis is the last Kaiser climax kick!!", "ruka_fc99", 0],
      },
      [1849] => { # ヒーローガッツ
        :word_1 => ["\\n<Luka>No matter how much you get hurt...no matter how much you kneel down...\n The soul of justice...will not give in!!", "ruka_fc99", 0],
      },
      [1850] => { # カイザーリフレイン
        :word_1 => ["\\n<Luka>An unbreakable heart... Kaiser Refrain!", "ruka_fc99", 0],
      },
      [1851] => { # カイザーバリア
        :word_1 => ["\\n<Luka>Wall of Justice... Kaiser Barrier!", "ruka_fc99", 0],
      },
      [1857] => { # エクセルラッシュ
        :word_1 => ["\\n<Luka>Roar, the cry of justice! Excel Rush!", "ruka_fc99", 0],
      },
      [1858] => { # エクセルジエンド
        :word_1 => ["\\n<Luka>Infinite courage and endless victory! \n Penetrating justice...Excelge End!", "ruka_fc99", 0],
      },
      [1859] => { # エクセルシオール
        :word_1 => ["\\n<Luka>I will fight for the weak!! \n This is the proof of justice... Excelsior!", "ruka_fc99", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Luka>I can't believe I'm a magical girl... Yeah☆", "ruka_fc99", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Luka>I'll do something with the power of money...", "ruka_fc99", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Luka>Okay, I bought it!", "ruka_fc99", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Luka>Bring out the power of \nItem beyond its limits!", "ruka_fc99", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc99", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Luka>It's a battle with coins, you won't lose!", "ruka_fc99", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Luka>Come on, it's a game of darkness with me!", "ruka_fc99", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Luka>I'll draw the tarot, hey!", "ruka_fc99", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Luka>Lady Ilias, please guide me...", "ruka_fc99", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Luka>I'll turn the slot, yeah!", "ruka_fc99", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Luka>Play poker with me!", "ruka_fc99", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Luka>Battle card, draw!", "ruka_fc99", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Luka>The power contained in the playing cards...!", "ruka_fc99", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Luka>Today, the luckiest person is...", "ruka_fc99", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Luka>It's always my turn!", "ruka_fc99", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Luka>God, please give me an item...", "ruka_fc99", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Luka>Come on, let's dance!", "ruka_fc99", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Luka>That's it! Hustle! Hustle!", "ruka_fc99", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Luka>I'll have you listen to my song!", "ruka_fc99", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Luka>I can't help it... Kira☆", "ruka_fc99", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Luka>Hey, let's talk for a while.", "ruka_fc99", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Luka>Wow, you are so amazing!", "ruka_fc99", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Luka>I'm not scared of you!", "ruka_fc99", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Luka>Well, I want money...", "ruka_fc99", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Luka>Well, I want an Item...", "ruka_fc99", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Luka>Hey, please be my friend!", "ruka_fc99", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Luka>If you continue like this, you'll be in terrible trouble...?", "ruka_fc99", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Luka>Please stand back quietly from here.", "ruka_fc99", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Luka>Then Mr. Smith was scratched by a cat...", "ruka_fc99", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Luka>When I opened the curtain, there was a lady next to me...", "ruka_fc99", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Luka>So, when I was walking near the grave...", "ruka_fc99", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Luka>The futon... was blown away...", "ruka_fc99", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Luka>It's the power of the Spirit of Words... Now, listen to me...", "ruka_fc99", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Luka>Let's go to Luka's exciting laboratory!", "ruka_fc99", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Luka>Now, prepare for the crisis!", "ruka_fc99", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Luka>Now, let's convert the energy...", "ruka_fc99", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Luka>I will alchemize \nItem!", "ruka_fc99", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Luka>This is the power of the magic book...!", "ruka_fc99", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Luka>This is also for the page...", "ruka_fc99", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Luka>Makina activated...Let's go!", "ruka_fc99", 0],
      },
      [2246] => { # ビームデスサイズ
        :word_1 => ["\\n<Luka>Cut into pieces with the \n beam blade!", "ruka_fc99", 0],
      },
      [2250] => { # 反粒子レールガン
        :word_1 => ["\\n<Luka>Disappear...Anti-particle railgun!", "ruka_fc99", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Luka>I'm confident in my cooking skills!", "ruka_fc99", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Luka>Well, what can be used as ingredients...", "ruka_fc99", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc99", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Luka>Calm down, I'll treat you right away!", "ruka_fc99", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Luka>Now, use this medicine... \n Hehe, hehehehehe...", "ruka_fc99", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Luka>I'll give you an injection! Hey!", "ruka_fc99", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Luka>Things like this are fun... \n Hehe, hehehehehe...", "ruka_fc99", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Luka>Excuse me for a moment...", "ruka_fc99", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Luka>Tea is here...it's homemade by me.", "ruka_fc99", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Luka>Let's go! Maid change!", "ruka_fc99", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Luka>Will we be able to harvest it soon...?", "ruka_fc99", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Luka>This is the king's sword technique!", "ruka_fc99", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Luka>This is the king's magic!", "ruka_fc99", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Luka>Everyone, please lend me your strength!", "ruka_fc99", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Luka>Dispel evil, divine power!", "ruka_fc99", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Luka>This is the power of the king...!", "ruka_fc99", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Luka>God, please give me a miracle...!", "ruka_fc99", 0],
      },
      [2432] => { # やたらめった斬り
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Kyoeeeeee!!", "ruka_fc99", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Let's go, haa!", "ruka_fc99", 0],
      },
      [2433] => { # 我流ファイア斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>I'll do it my way...! \n It's a flaming sword!", "ruka_fc99", 0],
      },
      [2434] => { # 燃えろ！ぐるぐる斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Burn, my fighting spirit! \n Special, round and round slash!", "ruka_fc99", 0],
      },
      [2435] => { # 妖魔斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Defeat evil with the hero's blade!", "ruka_fc99", 0],
      },
      [2436] => { # 不死斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Return to dust with the hero's blade!", "ruka_fc99", 0],
      },
      [2437] => { # 烈火天翔閃
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade of blazing fire, judge evil! \n Recca Tensho Flash!", "ruka_fc99", 0],
      },
      [2438] => { # 紅蓮廻天斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blowing Sabe, Crimson Blade! \n Guren Kaitenzan!", "ruka_fc99", 0],
      },
      [2439] => { # 紅蓮炎舞
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Transform into a crimson lotus and dance! \n Guren Enmai!", "ruka_fc99", 0],
      },
      [2440] => { # プラズマブレイク
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dispel the darkness! Plasma break!", "ruka_fc99", 0],
      },
      [2441] => { # シャドウブレイク
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Cut off the light! Shadow Break!", "ruka_fc99", 0],
      },
      [2444] => { # 烈心聖光斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Blade of light, cut off the darkness! Zealous Light Slash!", "ruka_fc99", 0],
      },
      [2431] => { # シャドウラプソディ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Dance with the darkness...Shadow Rhapsody!", "ruka_fc99", 0],
      },
      [2442] => { # グランドリオン
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The blade of justice cuts everything! \nWith unwavering faith! Grand Lion!", "ruka_fc99", 0],
      },
      [2443] => { # ヴェルデリオン
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The fighting spirit of darkness destroys the light! \nWith unwavering faith! Veldt Lion!", "ruka_fc99", 0],
      },
      [2446] => { # アルティメットメサイア
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the ultimate salvation... \n Along with light! Ultimate Messiah!", "ruka_fc99", 0],
      },
      [2447] => { # シャドウメサイア
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>This is the implied salvation... \n Dance in the darkness! Shadow Messiah!", "ruka_fc99", 0],
      },
      [2448] => { # エレメント・スピカ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Put the power of the four spirits into your hands...!", "ruka_fc99", 0],
      },
      [2453] => { # 烈心天塵英雄剣
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The ultimate secret of the hero...Resshin Tenjin Hero Sword!", "ruka_fc99", 0],
      },
      [2449] => { # カドラプル・ギガ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Four spirits, give me power... \n This is the end! Quadruple Giga!!", "ruka_fc99", 0],
      },
      [2450] => { # 烈心天塵剣
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Righteous light, ominous heavenly dust... \n Now is the time to become one! Retsushin Tenjinken!", "ruka_fc99", 0],
      },
      [2454] => { # イクスタプル・ゼタ
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The four spirits, the Kirin, and the ice butterfly... \n With everyone's power, EX-tuple Zeta!!", "ruka_fc99", 0],
      },
      [2445] => { # 天塵剣
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Carve, the blade of heavenly dust...haaah!", "ruka_fc99", 0],
      },
      [2451] => { # エンジェルダスト
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>Turn angels into dust...Angel dust!", "ruka_fc99", 0],
      },
      [2452] => { # 八夜羅刹斬
        :ct_pic => "80_ruka_st99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>The night of Rakshasa goes around... Eight nights of Rakshasa slash!", "ruka_fc99", 0],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Luka>This is the divine protection!", "ruka_fc99", 0],
      },
      [2455] => { # ロゴス・マギア
        :ct_pic => "ct_ruka99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■...!!", "ruka_fc99", 0],
      },
      [2456] => { # カオス・マギア
        :ct_pic => "ct_ruka99",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■...!!", "ruka_fc99", 0],
      },
      [2458] => { # 勇者の号令
        :word_1 => ["\\n<Luka>Everyone, let's go with all our might!", "ruka_fc99", 0],
        :word_2 => ["\\n<Luka>No matter what enemy we are, we can defeat it!", "ruka_fc99", 0],
        :word_3 => ["\\n<Luka>Win this battle and save the world!", "ruka_fc99", 0],
        :word_4 => ["\\n<Luka>Make every battle for the hero!", "ruka_fc99", 0],
        :word_5 => ["\\n<Luka>I will definitely win this battle!", "ruka_fc99", 0],
        :word_6 => ["\\n<Luka>In the name of the hero... everyone, let's go!!", "ruka_fc99", 0],
        :word_7 => ["\\n<Luka>Our struggle will bring us victory!!", "ruka_fc99", 0],
        :word_8 => ["\\n<Luka>Muster up your fighting spirit...let's go!", "ruka_fc99", 0],
        :word_9 => ["\\n<Luka>There's a party tonight!!", "ruka_fc99", 0],
        :word_10 => ["\\n<Luka>Let's go, to gain the glory of victory!", "ruka_fc99", 0],
      },
      [9546] => { # 黎明の魔眼
        :word_1 => ["\\n<Luka>The third eye judges evil... The evil eye of dawn!", "ruka_fc99", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Luka>The black fire of the underworld that judges everything... Stay here!", "ruka_fc99", 0],
      },
      [9639] => { # コキュートス
        :word_1 => ["\\n<Luka>Sleep in the eternal ice of the demon world... Cocytus!", "ruka_fc99", 0],
      },
      [9651] => { # 波動砲
        :word_1 => ["\\n<Luka>Disappear...wave motion gun!", "ruka_fc99", 0],
      },
      [9674] => { # 特級神具VIII:アグニカノン
        :word_1 => ["\\n<Luka>Destroy in flames, Agnicanon!", "ruka_fc99", 0],
      },
      [9675] => { # 特級神具IV:メルクリウス
        :word_1 => ["\\n<Luka>Freeze and break, Mercury!", "ruka_fc99", 0],
      },
      [9676] => { # 特級神具V:エクスパルサー
        :word_1 => ["\\n<Luka>Electric shock irradiation, Expulser!", "ruka_fc99", 0],
      },
      [9673] => { # 神具XIII:ユダ
        :word_1 => ["\\n<Luka>Blow away, Judas!", "ruka_fc99", 0],
      },
      [9677] => { # 特級神具IV:ガイアグラビディ
        :word_1 => ["\\n<Luka>Crush it, Gaia Gravidi!!", "ruka_fc99", 0],
      },
      [9678] => { # 特級神具IX:セントフレア
        :word_1 => ["\\n<Luka>Pierce, Saint Flare!!", "ruka_fc99", 0],
      },
      [9679] => { # エンドフルバースト
        :word_1 => ["\\n<Luka>All firearms activated...Endful burst!", "ruka_fc99", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Luka>Are you okay? It's just a first aid measure...", "ruka_fc99", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Luka>Lady Ilias, please bless me...!", "ruka_fc99", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Luka>...!", "ruka_fc99", 0],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Luka>Power to the blade...!", "ruka_fc99", 0],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Luka>Ohhh...!!", "ruka_fc99", 0],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Luka>This is my full power...!!", "ruka_fc99", 0],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Luka>This is the final secret...!", "ruka_fc99", 0],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Luka>Concentrate on your fist...", "ruka_fc99", 0],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Luka>This body is like steel...!", "ruka_fc99", 0],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Luka>The ultimate in concentration, the final effort...", "ruka_fc99", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Luka>With the help of \n Elemental...!", "ruka_fc99", 0],
      },
      [3111] => { # 四精霊同時召喚
        :word_1 => ["\\n<Luka>Come out, Sylph, Gnome, Undine, Salamander... \n Four spirits are summoned at the same time!", "ruka_fc99", 0],
      },
      [3116] => { # 明鏡止水
        :word_1 => ["\\n<Luka>This heart, in the flow of water...", "ruka_fc99", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Luka>Calm down and take a deep breath...", "ruka_fc99", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Luka>Calm down, this is first aid...", "ruka_fc99", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Luka>This is how I fight!", "ruka_fc99", 0],
      },
      [3121] => { # 背水
        :word_1 => ["\\n<Luka>This is how I fight!", "ruka_fc99", 0],
      },
      [3123] => { # 究極背水
        :word_1 => ["\\n<Luka>This is the ultimate predicament...!", "ruka_fc99", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Luka>Ohhhh...!!", "ruka_fc99", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Luka>Let's go...!　Hmmmm!!", "ruka_fc99", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Luka>Why am I... Magical☆Henshin ♪", "ruka_fc99", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Luka>Be quiet!", "ruka_fc99", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Luka>Okay, I'll request reinforcements!", "ruka_fc99", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Luka>Break that power!", "ruka_fc99", 0],
      },
      [3132] => { # ウェポンブレイク
        :word_1 => ["\\n<Luka>Breaking that power... Ha!", "ruka_fc99", 0],
      },
      [3133] => { # アーマーブレイク
        :word_1 => ["\\n<Luka>Shatter that defense... Ha!", "ruka_fc99", 0],
      },
      [3134] => { # マジックブレイク
        :word_1 => ["\\n<Luka>Breaking that magic... Ha!", "ruka_fc99", 0],
      },
      [3135] => { # マインドブレイク
        :word_1 => ["\\n<Luka>Shatter that spirit... Ha!", "ruka_fc99", 0],
      },
      [3136] => { # スピードブレイク
        :word_1 => ["\\n<Luka>Breaking that speed... Ha!", "ruka_fc99", 0],
      },
      [3137] => { # テクニックブレイク
        :word_1 => ["\\n<Luka>Breaking that skill... Ha!", "ruka_fc99", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Luka>Geyser, gush!", "ruka_fc99", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Luka>Don't move! Sit down!", "ruka_fc99", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Luka>Ehehe, I'll take it...", "ruka_fc99", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Luka>Why me... \n Se, sexy beam...", "ruka_fc99", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Luka>What is this! Pink Typhoon...", "ruka_fc99", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Luka>It's crap! Fantastic Hurricane♪", "ruka_fc99", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Luka>Come on, it's my stage!", "ruka_fc99", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Luka>Alright, I'll work a lot today too!", "ruka_fc99", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Luka>Pafupafu... there's no way I can do it!", "ruka_fc99", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Luka>The power of a hidden weapon...!", "ruka_fc99", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Luka>The power of grudge...!", "ruka_fc99", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Luka>...Blitzkrieg!!", "ruka_fc99", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Luka>My grudge...!", "ruka_fc99", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Luka>This is the holy grail miracle!", "ruka_fc99", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Luka>The power of the aura!", "ruka_fc99", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Luka>This is... witchcraft!", "ruka_fc99", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Luka>Huh!", "ruka_fc99", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Luka>I will protect you...!", "ruka_fc99", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Luka>Ahengers...Assemble!!", "ruka_fc99", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Luka>Double up!", "ruka_fc99", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Luka>Next action, order!", "ruka_fc99", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Luka>Concentrate your power on one point...!", "ruka_fc99", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc99", 0],
      },
      [9759] => { # ラストエクリプス
        :word_1 => ["\\n<Luka>Arrival, the final eclipse of chaos...", "ruka_fc99", 0],
      },
      [9760] => { # デスジェネシス
        :word_1 => ["\\n<Luka>The end is the beginning...Death Genesis!", "ruka_fc99", 0],
      },
      [9761] => { # ゼロユニバース
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■■■■...", "ruka_fc99", 0],
      },
      [9762] => { # 反物質対消滅
        :word_1 => ["\\n<Luka>Forbidden power, antimatter versus annihilation...", "ruka_fc99", 0],
      },
      [9763] => { # 次元削除
        :word_1 => ["\\n<Luka>Let's delete this dimension...", "ruka_fc99", 0],
      },
      [9764] => { # カオス
        :word_1 => ["\\n<Luka>■■■■■■■■■■■■...", "ruka_fc99", 0],
      },
      [9765] => { # ゼロシフト
        :word_1 => ["\\n<Luka>Bringing equilibrium to chaos...Zero shift!", "ruka_fc99", 0],
      },
      [3285] => { # 誘惑専用
        :word_y1 => ["\\n<Luka>I can't stand this... \n Ah, we're in battle...", "ruka_fc99", 0],
      },
    },
    5 => { # アリス
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Alice>Hyaah!", "alice_fc5", 2],
        :word_2 => ["\\n<Alice>Huh!", "alice_fc5", 2],
        :word_3 => ["\\n<Alice>Hey!", "alice_fc5", 2],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Alice>Look at \n's knife skills! Ha!", "alice_fc5", 2],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Alice>Take advantage of \n's sword skills!", "alice_fc5", 2],
      },
      [917] => { # 切り返し
        :word_1 => ["\\n<Alice>With a backslash... Haa!", "alice_fc5", 2],
      },
      [918] => { # 疾風突き
        :word_1 => ["\\n<Alice>Like the wind...Gale Thrust!", "alice_fc5", 2],
      },
      [919] => { # 払車剣
        :word_1 => ["\\n<Alice>Brandish, like a wheel... Shockwave Blade!", "alice_fc5", 2],
      },
      [920] => { # 諸刃斬り
        :word_1 => ["\\n<Alice>Suffer my resolve! Double-Edged Cut!", "alice_fc5", 2],
      },
      [921] => { # 隼斬り
        :word_1 => ["\\n<Alice>Blade, dance like a falcon! Haa!", "alice_fc5", 2],
      },
      [922] => { # 火炎斬り
        :word_1 => ["\\n<Alice>Imbue, flames... Haa!", "alice_fc5", 2],
      },
      [923] => { # 氷斬り
        :word_1 => ["\\n<Alice>Imbue, ice... Haa!", "alice_fc5", 2],
      },
      [924] => { # 稲妻斬り
        :word_1 => ["\\n<Alice>Imbue, lightning... Haa!", "alice_fc5", 2],
      },
      [931] => { # 真空斬り
        :word_1 => ["\\n<Alice>Vacuum blade... Teiii!", "alice_fc5", 2],
      },
      [932] => { # 烈風剣
        :word_1 => ["\\n<Alice>Dance, blade of gales! Haaa!!", "alice_fc5", 2],
      },
      [933] => { # 月影の太刀
        :word_1 => ["\\n<Alice>Dancing in the moonlight... The Shura's mighty blade!", "alice_fc5", 2],
      },
      [934] => { # 魔神斬り
        :word_1 => ["\\n<Alice>The cursed god's strike... Haa!", "alice_fc5", 2],
      },
      [935] => { # デッドクラッシュ
        :word_1 => ["\\n<Alice>Shatter from the blade of destruction! Dead Crash!", "alice_fc5", 2],
      },
      [936] => { # 二刀十字斬り
        :word_1 => ["\\n<Alice>Behold this double-bladed brandish! Cross Slash!", "alice_fc5", 2],
      },
      [942] => { # フレイムスラッシュ
        :word_1 => ["\\n<Alice>Burn them down, crimson flash...\nFlame Slash!", "alice_fc5", 2],
      },
      [943] => { # アイススラッシュ
        :word_1 => ["\\n<Alice>Freeze them solid, azure flash...\nFreeze Slash!", "alice_fc5", 2],
      },
      [944] => { # サンダースラッシュ
        :word_1 => ["\\n<Alice>Cleave them away, amber flash...\nThunder Slash!", "alice_fc5", 2],
      },
      [946] => { # 屠竜撃
        :word_1 => ["\\n<Alice>Eat this, a slash to fell dragons!", "alice_fc5", 2],
      },
      [947] => { # 雲身払車剣
        :word_1 => ["\\n<Alice>Blades of fog, spin like wheels... Cloudy Shockwave Blade!", "alice_fc5", 2],
      },
      [948] => { # 滅世斬
        :word_1 => ["\\n<Alice>The blade of darkness that cleaves this world... World-Ending Slash!", "alice_fc5", 2],
      },
      [953] => { # 死剣・乱れ星
        :word_1 => ["\\n<Alice>Like a chaotic shooting star... Death Sword Chaos Star!", "alice_fc5", 2],
      },
      [954] => { # 魔影流星斬
        :word_1 => ["\\n<Alice>Witness the dark meteor's descent to earth... Demonic Meteor Slash!", "alice_fc5", 2],
      },
      [959] => { # ギガスラッシュ
        :word_1 => ["\\n<Alice>This is the ultimate flash...\nGiga Slash!", "alice_fc5", 2],
      },
      [961] => { # 月下散華
        :word_1 => ["\\n<Alice>The moon's shadow foretells death... Moonlight Sacrifice!", "alice_fc5", 2],
      },
      [962] => { # 魔刃・雪時雨
        :word_1 => ["\\n<Alice>Rakshasa's unending blades befall you... Demon Sword Snowstorm!", "alice_fc5", 2],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :word_1 => ["\\n<Alice>Fast as a gale, fast as thunder...! \n Instant strike, gale of thunder!", "alice_fc5", 2],
      },
      [969] => { # 諸刃微塵斬り
        :word_1 => ["\\n<Alice>Even if this body decays... it's a double-edged sword!", "alice_fc5", 2],
      },
      [973] => { # アトミックスラッシュ
        :word_1 => ["\\n<Alice>Erase \n, a flash of nuclear heat... Atomic Slash!", "alice_fc5", 2],
      },
      [974] => { # クァンタスラッシュ
        :word_1 => ["\\n<Alice>Erase it, a flash of quantum... Quantus Slash!", "alice_fc5", 2],
      },
      [975] => { # イオンスラッシュ
        :word_1 => ["\\n<Alice>Erase it, a flash of atoms... ion slash!", "alice_fc5", 2],
      },
      [9009] => { # ギガスラッシュクロス
        :word_1 => ["\\n<Alice>Double flash... Giga Slash Cross!", "alice_fc5", 2],
      },
      [9016] => { # 乱れ雪月花
        :word_1 => ["\\n<Alice>Dance of snow...Shadow of the moon...Scattered with flowers...!", "alice_fc5", 2],
      },
      [971] => { # 聖光六閃斬
        :word_1 => ["\\n<Alice>Receive the continuous attack of light... Six flashes of holy light!", "alice_fc5", 2],
      },
      [970] => { # メギドカリバーン
        :word_1 => ["\\n<Alice>Mowing down with the wave of darkness... Megiddo Caliburn!", "alice_fc5", 2],
      },
      [9014] => { # メギドカブラ
        :word_1 => ["\\n<Alice>This is the ultimate secret of the magic sword... Megidokabura!", "alice_fc5", 2],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Alice>The healing sword, the protection of the abominable light!", "alice_fc5", 2],
      },
      [972] => { # 闇天
        :word_1 => ["\\n<Alice>The blade of Shura that cuts everything...Dark Heaven!", "alice_fc5", 2],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Alice>Take advantage of my saber skills!", "alice_fc5", 2],
      },
      [985] => { # チャージレイ
        :word_1 => ["\\n<Alice>Charge..! Haa!", "alice_fc5", 2],
      },
      [986] => { # Vスラッシュ
        :word_1 => ["\\n<Alice>My victory shall be etched upon your body!", "alice_fc5", 2],
      },
      [987] => { # ダンシングサーブル
        :word_1 => ["\\n<Alice>Dance, saber! Haaaaa!", "alice_fc5", 2],
      },
      [988] => { # スプラッシュフルーレ
        :word_1 => ["\\n<Alice>Graceful and magnificent... Splash Fleuret!", "alice_fc5", 2],
      },
      [989] => { # クロスアンブル
        :word_1 => ["\\n<Alice>A twofold thrust! Take this!", "alice_fc5", 2],
      },
      [990] => { # トライジャッド
        :word_1 => ["\\n<Alice>Une, deux, trois... Triplé Juge!", "alice_fc5", 2],
      },
      [991] => { # フォティトゥリア
        :word_1 => ["\\n<Alice>A scorching dance... Forti Tria!", "alice_fc5", 2],
      },
      [992] => { # パゴストゥリア
        :word_1 => ["\\n<Alice>A crystalline dance... Pagos Tria!", "alice_fc5", 2],
      },
      [993] => { # ケラヴトゥリア
        :word_1 => ["\\n<Alice>A reverberating thunderclap... Kerav Tria!", "alice_fc5", 2],
      },
      [994] => { # ゼクスルージュ
        :word_1 => ["\\n<Alice>A glimmering, sixfold thrust... Zex Rouge!", "alice_fc5", 2],
      },
      [995] => { # プリエール
        :word_1 => ["\\n<Alice>Prière! Taste the thrust of hellfire!", "alice_fc5", 2],
      },
      [996] => { # ヴィクトワール
        :word_1 => ["\\n<Alice>The glory of victory goes to the ruler... Victoire!", "alice_fc5", 2],
      },
      [997] => { # アンスタン
        :word_1 => ["\\n<Alice>Anston! Dance, unrelenting saber!", "alice_fc5", 2],
      },
      [998] => { # ネメシス
        :word_1 => ["\\n<Alice>Grant them their punishment, merciless blade... Nemesis!", "alice_fc5", 2],
      },
      [999] => { # ノーザンクロス
        :word_1 => ["\\n<Alice>Burn to ash in the flash of this cross! Northern Cross!", "alice_fc5", 2],
      },
      [9032] => { # ギャラクシア
        :word_1 => ["\\n<Alice>Sparkle, the tip of the galactic sword! Galaxia!", "alice_fc5", 2],
      },
      [9033] => { # 魔王煉獄剣
        :word_1 => ["\\n<Alice>Take it, the Monster Lord's blade that will destroy everything... the Monster Lord's purgatory sword!", "alice_fc5", 2],
      },
      [9034] => { # ギャラクシア・エクス
        :word_1 => ["\\n<Alice>Delivered to the edge of the galaxy...Galaxia Ex!", "alice_fc5", 2],
      },
      [9031] => { # エクスィス
        :word_1 => ["\\n<Alice>A brilliant and fierce series of moves! Exis!", "alice_fc5", 2],
      },
      [9037] => { # ドゥームズデイ
        :word_1 => ["\\n<Alice>The day of revelation marks the end! Doomsday!", "alice_fc5", 2],
      },
      [9035] => { # アルテマエンデ
        :word_1 => ["\\n<Alice>The last and ultimate sword! Altemaende!", "alice_fc5", 2],
      },
      [9036] => { # 魔煌炎舞
        :word_1 => ["\\n<Alice>Dance, the demon emperor's flame! Magic flame dance!", "alice_fc5", 2],
      },
      [9029] => { # クロス・ノイエ
        :word_1 => ["\\n<Alice>Double sword tip, slash in one breath!", "alice_fc5", 2],
      },
      [9030] => { # トライ・グランテ
        :word_1 => ["\\n<Alice>The tip of the triple sword runs across the earth and defeats evil!", "alice_fc5", 2],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Alice>I bet my pride on this blade!", "alice_fc5", 2],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Alice>He will cut you into pieces with his extra white blade!", "alice_fc5", 2],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Alice>I bet the Monster Lord's pride on this white blade!", "alice_fc5", 2],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Alice>I shall end this with own hands...", "alice_fc5", 3],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Alice>Look at my spear handling! Ha!", "alice_fc5", 2],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Alice>Spear, show us your detestable miracle!", "alice_fc5", 2],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Alice>Spear, grant me your power!", "alice_fc5", 2],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Alice>Look at my ax skills! Ha!", "alice_fc5", 2],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Alice>Rampage, my tyrannical axe!", "alice_fc5", 2],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Alice>Look at my sword skills! Ha!", "alice_fc5", 2],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Alice>Look at my sickle skills! Ha!", "alice_fc5", 2],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Alice>Go mad from the Monster Lord's scythe!", "alice_fc5", 2],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Alice>Look at my bow skills! Ha!", "alice_fc5", 2],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Alice>Rain down, arrows of healing!", "alice_fc5", 2],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Alice>Crawl on the ground with more than a whip! Ha!", "alice_fc5", 2],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Alice>I ordered you to come!", "alice_fc5", 2],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Alice>Look at the other boomerang skills! Ha!", "alice_fc5", 2],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Alice>Look at \n's iron ball handling! Ha!", "alice_fc5", 2],
      },
      [1282] => { # 鉄球撃
        :word_1 => ["\\n<Alice>Eat this! Flail strike!", "alice_fc5", 2],
      },
      [1283] => { # 鉄球火炎撃
        :word_1 => ["\\n<Alice>Burn, with the strike of a flail!", "alice_fc5", 2],
      },
      [1284] => { # 鉄球氷柱撃
        :word_1 => ["\\n<Alice>Freeze, with the strike of a flail!", "alice_fc5", 2],
      },
      [1285] => { # 鉄球雷電撃
        :word_1 => ["\\n<Alice>Shock, with the strike of a flail!", "alice_fc5", 2],
      },
      [1286] => { # 触手殺し
        :word_1 => ["\\n<Alice>Crush them, Tentacle Killer!", "alice_fc5", 2],
      },
      [1287] => { # キルスキュラ
        :word_1 => ["\\n<Alice>Eat this! A destructive flail that crushes scylla!", "alice_fc5", 2],
      },
      [1288] => { # ヘビィスパイラル
        :word_1 => ["\\n<Alice>Mow them down, flail tempest! Heavy Spiral!", "alice_fc5", 2],
      },
      [1289] => { # チェインドライブ
        :word_1 => ["\\n<Alice>Take this rain of flail with your own body! Chain Drive!", "alice_fc5", 2],
      },
      [1290] => { # グランドドライブ
        :word_1 => ["\\n<Alice>Roll across the land, swift flail! Grand Drive!", "alice_fc5", 2],
      },
      [1291] => { # 天罰の鉄球
        :word_1 => ["\\n<Alice>Evil-crushing flail, drive my wrath into them!", "alice_fc5", 2],
      },
      [1292] => { # 鎖舞
        :word_1 => ["\\n<Alice>Dancing flail, dedicate this chain dance to the heavens!", "alice_fc5", 2],
      },
      [1293] => { # デッドリーメイス
        :word_1 => ["\\n<Alice>Shatter the earth... Deadly Mace!", "alice_fc5", 2],
      },
      [1294] => { # ウェイトキャノン
        :word_1 => ["\\n<Alice>Blow them to smithereens, raging strike!\nHeavy Cannon!", "alice_fc5", 2],
      },
      [1297] => { # 鉄球剛乱舞
        :word_1 => ["\\n<Alice>Crumble until not even dust remains!\nRioting Sphere!", "alice_fc5", 2],
      },
      [1298] => { # クロスメイデン
        :word_1 => ["\\n<Alice>Flash of the cross, destroy the darkness...\nCross Maiden!", "alice_fc5", 2],
      },
      [1299] => { # 神楽乱陣
        :word_1 => ["\\n<Alice>My flail war dance can be seen even from the heavens... Kagura War Formation!", "alice_fc5", 2],
      },
      [1300] => { # レイジングバースト
        :word_1 => ["\\n<Alice>Shattering flail! Demolish them, Raging Burst!", "alice_fc5", 2],
      },
      [1301] => { # 破壊の一撃
        :word_1 => ["\\n<Alice>With all my strength! Annihilate! Destructive Strike!", "alice_fc5", 2],
      },
      [1302] => { # 五星滅球撃
        :word_1 => ["\\n<Alice>A blink of an eye, a meteor of destruction... Five stars of destruction!", "alice_fc5", 2],
      },
      [1304] => { # ウロボロスアーク
        :word_1 => ["\\n<Alice>Super heavy crushing blow... Ouroboros Ark!", "alice_fc5", 2],
      },
      [1306] => { # エデンズヘブン
        :word_1 => ["\\n<Alice>Distortion, world... Eden's Heaven!", "alice_fc5", 2],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Alice>Look at Tamamo's inherited fan skills! Ha!", "alice_fc5", 2],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Alice>Look at my gun skills! Ha!", "alice_fc5", 2],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Alice>Eat these recovery bullets!", "alice_fc5", 2],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Alice>Experience \n's continuous attacks for yourself!", "alice_fc5", 2],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Alice>With blades in both hands, I shall slash with a frenzy!", "alice_fc5", 2],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Alice>Experience \n's martial arts for yourself!", "alice_fc5", 2],
      },
      [1400] => { # 足払い
        :word_1 => ["\\n<Alice>An opening! Leg sweep!", "alice_fc5", 2],
      },
      [1401] => { # 飛び膝蹴り
        :word_1 => ["\\n<Alice>Eat this! Flying Knee Kick!", "alice_fc5", 2],
      },
      [1402] => { # 回し蹴り
        :word_1 => ["\\n<Alice>Roundhouse kick!", "alice_fc5", 2],
      },
      [1403] => { # 秘孔
        :word_1 => ["\\n<Alice>I'll decide this in one strike... Pressure Point!", "alice_fc5", 2],
      },
      [1405] => { # 正拳突き
        :word_1 => ["\\n<Alice>Haaaa... Fist Thrust!", "alice_fc5", 2],
      },
      [1406] => { # 羅刹掌
        :word_1 => ["\\n<Alice>Become one with the rakshasa in the face of battle! Rakshasa Palm!", "alice_fc5", 2],
      },
      [1407] => { # 爆裂拳
        :word_1 => ["\\n<Alice>Shut up and take this, Exploding Fist! Haaaaaa!", "alice_fc5", 2],
      },
      [1408] => { # 電塵連脚
        :word_1 => ["\\n<Alice>Shut up and take this, Lightning Kick! Haaaaaa!", "alice_fc5", 2],
      },
      [1409] => { # 炎舞三連撃
        :word_1 => ["\\n<Alice>Burn, Flame Dance Fist!", "alice_fc5", 2],
      },
      [1410] => { # 氷拳乱雹撃
        :word_1 => ["\\n<Alice>Freeze, Ice Rebellion Fist!", "alice_fc5", 2],
      },
      [1411] => { # 雷神喝撃
        :word_1 => ["\\n<Alice>Scatter, Thunder God Fist!", "alice_fc5", 2],
      },
      [1412] => { # 真空波動掌
        :word_1 => ["\\n<Alice>Wave of wind...slice through the air...", "alice_fc5", 2],
      },
      [1413] => { # 土刻金剛拳
        :word_1 => ["\\n<Alice>Carve the earth, to pierce even diamond!", "alice_fc5", 2],
      },
      [1414] => { # 波断水裂蹴
        :word_1 => ["\\n<Alice>Cut the water's surface...with an instant kick!", "alice_fc5", 2],
      },
      [1431] => { # エレメントフィニッシュ
        :word_1 => ["\\n<Alice>Magical fist, engrave the brilliance of eight colors...!", "alice_fc5", 2],
      },
      [1425] => { # 聖光裂閃撃
        :word_1 => ["\\n<Alice>Gleam, white flash! Light Rending Fist!", "alice_fc5", 2],
      },
      [1426] => { # 暗黒連衝拳
        :word_1 => ["\\n<Alice>Engrave, black shock! Dark Onslaught Fist!", "alice_fc5", 2],
      },
      [1427] => { # 四天光掌
        :word_1 => ["\\n<Alice>Quad Heaven Palm, tear across the shining heavens!", "alice_fc5", 2],
      },
      [1428] => { # 四星滅功
        :word_1 => ["\\n<Alice>Four Strike Star Destruction, bloom in the dark sky!", "alice_fc5", 2],
      },
      [1429] => { # 烈気光掌
        :word_1 => ["\\n<Alice>A single blow to shake even the heavens...Reiki Kosho!", "alice_fc5", 2],
      },
      [1430] => { # 瞬獄殺
        :word_1 => ["\\n<Alice>All life must perish...", "alice_fc5", 2],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Alice>....................", "alice_fc5", 2],
      },
      [1434] => { # 当て身光掌（発動）
        :word_1 => ["\\n<Alice>I received \n... Atemi Kosho!", "alice_fc5", 2],
      },
      [1435] => { # 金剛八連拳
        :word_1 => ["\\n<Alice>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "alice_fc5", 2],
      },
      [1436] => { # 紅蓮大拳舞
        :word_1 => ["\\n<Alice>Dance wildly, the crimson flame! Guren Daikenbu!", "alice_fc5", 2],
      },
      [9157] => { # 電塵乱皇脚
        :word_1 => ["\\n<Alice>Flash, noble thunder! Denjinran Kokyaku!", "alice_fc5", 2],
      },
      [9159] => { # 真・瞬獄殺
        :word_1 => ["\\n<Alice>The living will be destroyed, all things will be destroyed...!", "alice_fc5", 2],
      },
      [9164] => { # 修羅爆裂拳
        :word_1 => ["\\n<Alice>Shura's fist hits wildly!　Aaah!!", "alice_fc5", 2],
      },
      [9163] => { # 破滅の鉄槌
        :word_1 => ["\\n<Alice>The judgment of the fist... the hammer of destruction!", "alice_fc5", 2],
      },
      [9156] => { # 零拳
        :word_1 => ["\\n<Alice>Scattered, sub-zero freezing fist...Zero Fist!", "alice_fc5", 2],
      },
      [9165] => { # 聖天轟裂撃
        :word_1 => ["\\n<Alice>Breath of white light... Holy heaven roar ruptures!", "alice_fc5", 2],
      },
      [9166] => { # 魔天冥煌撃
        :word_1 => ["\\n<Alice>Breath of darkness... Demon heaven's dark sparkle attack!", "alice_fc5", 2],
      },
      [9167] => { # 覆滅陰陽撃
        :word_1 => ["\\n<Alice>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "alice_fc5", 2],
      },
      [9173] => { # 天地開闢拳
        :word_1 => ["\\n<Alice>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "alice_fc5", 2],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Alice>Get lost in my skills...!", "alice_fc5", 2],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Alice>Heal, pulse of the heavens... My chakra!", "alice_fc5", 2],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Alice>Heal, pulse of the heavens... My chakra!", "alice_fc5", 2],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc5", 2],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc5", 2],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Alice>Pulse of life, return their soul!", "alice_fc5", 2],
      },
      [1451] => { # 裏蘇生
        :word_1 => ["\\n<Alice>The forbidden resurrection art... Haa!", "alice_fc5", 2],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Alice>Magical pulse, imbue these fists!", "alice_fc5", 2],
      },
      [1452] => { # 三魔の拳
        :word_1 => ["\\n<Alice>Breath of the three magics, imbue my fists!", "alice_fc5", 2],
      },
      [1453] => { # 四精の拳
        :word_1 => ["\\n<Alice>Breath of the Four Spirits, imbue my fists!", "alice_fc5", 2],
      },
      [1454] => { # 聖魔の拳
        :word_1 => ["\\n<Alice>Breath of the two energies, imbue my fists!", "alice_fc5", 2],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Alice>White magic, bring healing!", "alice_fc5", 2],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Alice>White magic, bring healing!", "alice_fc5", 2],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Alice>Abominable holy light, illuminate the darkness!", "alice_fc5", 2],
      },
      [1471] => { # マヒール
        :word_1 => ["\\n<Alice>Cruel winds of life, distort and shatter their body to pieces! Maheal!", "alice_fc5", 2],
      },
      [1472] => { # オールマヒール
        :word_1 => ["\\n<Alice>Cruel winds of life, distort and shatter their body to pieces! Mass Maheal!", "alice_fc5", 2],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Alice>Abominable light, destroy the demon! \n Heaven!", "alice_fc5", 2],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Alice>Abominable light, grant protection!", "alice_fc5", 2],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Alice>Abominable light, become a wall of protection!", "alice_fc5", 2],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Alice>Abominable light, cancel the blessing!", "alice_fc5", 2],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Black torrent, obey my orders!", "alice_fc5", 2],
      },
      [1496] => { # ファイア
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Raging flames, show them your power!\nFire!", "alice_fc5", 2],
      },
      [1497] => { # メガファイア
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Raging flames, scatter them like a maelstrom!\nMega Fire!", "alice_fc5", 2],
      },
      [1498] => { # ファイアテンペスト
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Vortex of embers, rampage with all your fury!\nFire Tempest!", "alice_fc5", 2],
      },
      [1499] => { # ブレイズ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Infernal breath, become a scorching nightmare!\nBlaze!", "alice_fc5", 2],
      },
      [1500] => { # オメガブレイズ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Obey my pledge, hellish inferno!\nBurn to ashes! Omega Blaze!", "alice_fc5", 2],
      },
      [1501] => { # プロミネンス
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Primordial red, revolving for an eternity!\nDoomsday inferno! Prominence!", "alice_fc5", 2],
      },
      [1502] => { # ブリザード
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Freezing ice, become a bitter chill!\nBlizzard!", "alice_fc5", 2],
      },
      [1503] => { # メガブリザード
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Freezing ice, become a cold tempest of destruction! Mega Blizzard!", "alice_fc5", 2],
      },
      [1504] => { # ブリザードストーム
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Icy vortex, cut through everything in your way!\nBlizzard Storm!", "alice_fc5", 2],
      },
      [1505] => { # フロスト
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Frozen coffin, freeze even their screams of lament! Frost!", "alice_fc5", 2],
      },
      [1506] => { # シグマフロスト
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Tides of nothingness, freeze this world of blue in time... Lifeless silence! Sigma Frost!", "alice_fc5", 2],
      },
      [1507] => { # アイスエイジ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Primordial blue, engraved upon the deepest Apocalypse! The beginning of absolute zero, Ice Age!", "alice_fc5", 2],
      },
      [9194] => { # クァンタゾーン
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Ultra-fine blink of an eye, bring about the destruction of condensation! \n Quanta Zone!", "alice_fc5", 2],
      },
      [9196] => { # イオンブラスト
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Look at the way the floating molecules scatter! \n Ion blast!", "alice_fc5", 2],
      },
      [9206] => { # オーバーカーズ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Cursed Queen, open up taboos! \n Black disaster, OverCurse!", "alice_fc5", 2],
      },
      [1508] => { # サンダー
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Pure lightning, deliver your judgement!\nThunder!", "alice_fc5", 2],
      },
      [1509] => { # メガサンダー
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Pure lightning, rain down and banish the wicked!\nMega Thunder!", "alice_fc5", 2],
      },
      [1510] => { # サンダーハリケーン
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Raging thunder, roar and tear asunder the heavens! Thunder Hurricane!", "alice_fc5", 2],
      },
      [1511] => { # スパーク
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Hammer of lightning, turn evil to ashes!\nSpark!", "alice_fc5", 2],
      },
      [1512] => { # ラムダスパーク
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Hammer of judgement, a prison of lightning to turn all to dust... Deliver your punishment! Lambda Spark!", "alice_fc5", 2],
      },
      [1513] => { # ライトニング
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Primordial spark, return them to the dust of Samsara! Apocalyptic lightning! Plasma Storm!", "alice_fc5", 2],
      },
      [9205] => { # トリニティ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Play the dance of flame, ice, and thunder! \n Trinity!", "alice_fc5", 2],
      },
      [9192] => { # ガンマバースト
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Bring the afterglow of creation, the scorching heat of the primordial! \n Gamma Burst!", "alice_fc5", 2],
      },
      [9204] => { # カオスリバレート
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The source of ultimate magic... Chaos Revelation!", "alice_fc5", 2],
      },
      [9207] => { # アポカリプス
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Hear the footsteps of the end...Apocalypse!", "alice_fc5", 2],
      },
      [9210] => { # オーバーロード
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>All of my magical power will be poured into me... \n Disappear into dust, Overlord!", "alice_fc5", 2],
      },
      [1530] => { # ドレイン
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Offer your life force unto me!\nDrain!", "alice_fc5", 2],
      },
      [1531] => { # マドレイン
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Offer your magic unto me!\nMadrain!", "alice_fc5", 2],
      },
      [1532] => { # デス
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Reaper's scythe which harvests life, lead their soul to Hades! Death!", "alice_fc5", 2],
      },
      [1533] => { # オールデス
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Reaper's scythe which harvests life, lead this flock of souls to Hades! Mass Death!", "alice_fc5", 2],
      },
      [1534] => { # ポイズン
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Flowing toxin, infect their flesh!\nPoison!", "alice_fc5", 2],
      },
      [1535] => { # ブラインド
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Darkness of night, rob them of their light!\nBlind!", "alice_fc5", 2],
      },
      [1536] => { # サイレンス
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Deny sorcery, and bring forth tranquility!\nSilence!", "alice_fc5", 2],
      },
      [1537] => { # コンフューズ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Wandering hearts, know not who you even point your blades at! Confuse!", "alice_fc5", 2],
      },
      [1538] => { # スリープ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Dreaming in daylight, your consciousness drifts with the butterfly's calling! Sleep!", "alice_fc5", 2],
      },
      [1539] => { # パラライズ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Numbing grip, have them experience the deprivation of freedom! Paralyze!", "alice_fc5", 2],
      },
      [1541] => { # ヒールタイフーン
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Tranquil breeze of life, blow and become a squall of grace! Heal Typhoon!", "alice_fc5", 2],
      },
      [1527] => { # カイザーフェニックス
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Be burned by the flames of the phoenix... \n The devil's secret technique is Kaiser Phoenix!", "alice_fc5", 2],
      },
      [1528] => { # フェニックスロンド
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Dance, the Monster Lord's phoenix... \n Dance to the crimson, Phoenix Rondo!", "alice_fc5", 2],
      },
      [1523] => { # カーズ
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The fog of darkness, bring great disaster! Curse!", "alice_fc5", 2],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Alice>It's \n, follow me! Ha!", "alice_fc5", 2],
      },
      [1547] => { # スロウ
        :word_1 => ["\\n<Alice>Turbulent stream of time, drift towards tranquility and delay their advance! Slow!", "alice_fc5", 2],
      },
      [1548] => { # オールスロウ
        :word_1 => ["\\n<Alice>Turbulent stream of time, drift towards tranquility and delay their advance! Mass Slow!", "alice_fc5", 2],
      },
      [1549] => { # クィック
        :word_1 => ["\\n<Alice>Turbulent stream of time, accelerate your pulse and hasten our advance! Quick!", "alice_fc5", 2],
      },
      [1550] => { # オールクィック
        :word_1 => ["\\n<Alice>Turbulent stream of time, accelerate your pulse and hasten our advance! Mass Quick!", "alice_fc5", 2],
      },
      [1551] => { # ストップ
        :word_1 => ["\\n<Alice>Time of zero, bring the laws of nature to a halt! Stop!", "alice_fc5", 2],
      },
      [1552] => { # オールストップ
        :word_1 => ["\\n<Alice>Time of zero, bring the laws of nature to a halt! Mass Stop!", "alice_fc5", 2],
      },
      [1553] => { # フォシル
        :word_1 => ["\\n<Alice>Turbulent stream of time, quicken their decay into dust! Fossil!", "alice_fc5", 2],
      },
      [1555] => { # リゾーン
        :word_1 => ["\\n<Alice>Gate of time, open your arms to the next world! Rezone!", "alice_fc5", 2],
      },
      [1557] => { # グラビティ
        :word_1 => ["\\n<Alice>Curse of gravity, become the shackles which crush their body! Gravity!", "alice_fc5", 2],
      },
      [1558] => { # ハイグラビティ
        :word_1 => ["\\n<Alice>Curse of gravity, become a hammer to break them apart! Mass Gravity!", "alice_fc5", 2],
      },
      [9226] => { # オーバーグラビディ
        :word_1 => ["\\n<Alice>The curse of gravity, crush both light and darkness! \nThe pinnacle of crushing, Overgravidy!", "alice_fc5", 2],
      },
      [9223] => { # オーバークイック
        :word_1 => ["\\n<Alice>The muddy current of time, carve the ultimate heartbeat! \n Overquick!", "alice_fc5", 2],
      },
      [9222] => { # オーバースロウ
        :word_1 => ["\\n<Alice>Stay in the ultimate calm in the muddy waters of \n! \n Overslow!", "alice_fc5", 2],
      },
      [9224] => { # セカンドアクト
        :word_1 => ["\\n<Alice>The muddy waters of \n, the ultimate protection for your next life! \n Second act!", "alice_fc5", 2],
      },
      [9225] => { # リライフ
        :word_1 => ["\\n<Alice>The muddy waters of time, speed up the heartbeat of life! Relife!", "alice_fc5", 2],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Alice>It's \n, follow me! Ha!", "alice_fc5", 2],
      },
      [1559] => { # コメット
        :word_1 => ["\\n<Alice>The door to the stars now opens, and will smash the earth with its deluge! Comet!", "alice_fc5", 2],
      },
      [1560] => { # メテオ
        :word_1 => ["\\n<Alice>Galactic herald of destruction, the time of heavenly disaster has arrived! Return from space! Meteor!", "alice_fc5", 2],
      },
      [1563] => { # アーク
        :word_1 => ["\\n<Alice>Disturbed and crazy, the tide of time... Ark!", "alice_fc5", 2],
      },
      [9227] => { # リピートメテオ
        :word_1 => ["\\n<Alice>Calamity from heaven, overlapping the cycle of time! \nRepeat meteorite, repeat meteorite!", "alice_fc5", 2],
      },
      [9228] => { # コメットレイン
        :word_1 => ["\\n<Alice>The star door is about to open, crush the earth and rain down! \n Comet Rain!", "alice_fc5", 2],
      },
      [9233] => { # オーバーアーク
        :word_1 => ["\\n<Alice>The tide of time is disturbed and comes to an end! \n The flow of destruction, Overark!", "alice_fc5", 2],
      },
      [9230] => { # ギャラクシー
        :word_1 => ["\\n<Alice>Swirling, the breath of a deep galaxy! Galaxy!", "alice_fc5", 2],
      },
      [9234] => { # サンスフィア
        :word_1 => ["\\n<Alice>Burn up the infinite sun! Sunsphere!", "alice_fc5", 2],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Alice>I command you, time, stop!", "alice_fc5", 2],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Alice>Abominable light, illuminate the darkness!", "alice_fc5", 2],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Alice>The warrior's soul breathes life again!", "alice_fc5", 2],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Alice>Angel's dance...!", "alice_fc5", 2],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Alice>....................", "alice_fc5", 2],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Alice>So, you're going crazy with my lewd techniques...!", "alice_fc5", 2],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Alice>Abominable light, bring healing!", "alice_fc5", 2],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Alice>With my remaining life, I will dispel the darkness!", "alice_fc5", 2],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Alice>Roar, the breath of darkness...", "alice_fc5", 2],
      },
      [1674] => { # ダークネス
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Howl, breath of the dark... Darkness!", "alice_fc5", 2],
      },
      [1675] => { # ダークエターナル
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Black of demise, fill the darkness... Dark Eternal!", "alice_fc5", 2],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Alice>At the hour of darkness, flames shall dance like falling cherry blossoms... Tremble in your sleep, Demon Flame Dance!", "alice_fc5", 2],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Alice>At the hour of darkness, they shall be sent away in works of demonic ice.... Tremble in your sleep,  Demon Ice Burial!", "alice_fc5", 2],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Alice>At the hour of darkness, screams shall echo from the dust of thunder... Tremble in your sleep, Demon Thunder Dust!", "alice_fc5", 2],
      },
      [1679] => { # ダークストリーム
        :ct_pic => "ct_alice1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Come, the tide of darkness... Dark stream!", "alice_fc5", 2],
      },
      [1683] => { # 死んでくれる？
        :word_1 => ["\\n<Alice>I'll have you die...!", "alice_fc5", 2],
      },
      [1684] => { # 魔王の暴虐
        :word_1 => ["\\n<Alice>Experience the power of the Monster Lord for yourself!", "alice_fc5", 2],
      },
      [1690] => { # 終焉の闇
        :word_1 => ["\\n<Alice>Close the darkness of the end...", "alice_fc5", 2],
      },
      [1692] => { # 裁きの炎
        :word_1 => ["\\n<Alice>Burn it down, the flames of judgment...!", "alice_fc5", 2],
      },
      [1694] => { # アンリ・マンユ
        :word_1 => ["\\n<Alice>Henri Mainyu, the hour of darkness has arrived...", "alice_fc5", 2],
      },
      [1693] => { # ビッグクランチ
        :word_1 => ["\\n<Alice>End this world...Big Crunch!", "alice_fc5", 2],
      },
      [9299] => { # ディメント・ナーギ
        :word_1 => ["\\n<Alice>A dream of pleasure shown by the Monster Lord... Demento Nagi!", "alice_fc5", 2],
      },
      [9300] => { # ネフィリム・エンデ
        :word_1 => ["\\n<Alice>Become food for the Monster Lord...Nephilim Ende!", "alice_fc5", 2],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Alice>Magical power, dwell in my blade!", "alice_fc5", 2],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Alice>Expand, magical barrier!", "alice_fc5", 2],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Alice>Sign of Yin and Yang, show me the principles of heaven and earth!", "alice_fc5", 2],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Alice>The law of exorcism, the prison of rebellion! \n Realize your retribution, Nine Souls Exorcism Team!", "alice_fc5", 2],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Alice>A lifetime, sending it is life! \n Carving the slightest bit...Singing life!", "alice_fc5", 2],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Alice>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "alice_fc5", 2],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Alice>I got \n!", "alice_fc5", 2],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Alice>This is the proof of a thief!", "alice_fc5", 2],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Alice>Come on, we're getting out of here!", "alice_fc5", 2],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Alice>Take advantage of the ninjutsu!", "alice_fc5", 2],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Alice>Go crazy in agony with Kunoichi's techniques!", "alice_fc5", 2],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Alice>Wave of healing, spread a thousand ways...\nNinja Art: Healing Wave!", "alice_fc5", 2],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Alice>Empty cicada shells of autumn, dancing like shadows... Ninja Art: Doppelganger!", "alice_fc5", 2],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Alice>I have to escape...", "alice_fc5", 2],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Alice>Admire the skills of those who live in the sea...!", "alice_fc5", 2],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Alice>This kind of mood isn't bad either!", "alice_fc5", 2],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Alice>I'm a magical girl, Magical☆Alice!", "alice_fc5", 2],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Alice>Look, this is the power of money!", "alice_fc5", 2],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Alice>Okay, I bought it!", "alice_fc5", 2],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Alice>If it takes more than \n, that's it!", "alice_fc5", 2],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Alice>Look at \n's card handling!", "alice_fc5", 2],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Alice>I shall bet upon this coin......", "alice_fc5", 2],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Alice>The Monster Lord shall play a shady game...", "alice_fc5", 2],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Alice>Shall I read your fortune with a tarot...?", "alice_fc5", 2],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Alice>As much as I detest this, I shall call out to Ilias...", "alice_fc5", 2],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Alice>Shall I spin the slots...?", "alice_fc5", 2],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Alice>Come on, play poker with me!", "alice_fc5", 2],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Alice>battle card, draw!", "alice_fc5", 2],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Alice>I will show you the power of Trump...!", "alice_fc5", 2],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Alice>Who shall the Monster Lord choose as the lucky one today...?!", "alice_fc5", 2],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Alice>It's always my turn!", "alice_fc5", 2],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Alice>What comes out, Item slot!", "alice_fc5", 2],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Alice>Look, look at my dance!", "alice_fc5", 2],
      },
      [2026] => { # 神代の舞
        :word_1 => ["\\n<Alice>Behold, the evil works of the gods...\nThis dance is dedicated to the Dark Goddess!", "alice_fc5", 2],
      },
      [2043] => { # 破護の舞
        :word_1 => ["\\n<Alice>You won't be granted any blessings♪ Dispel Dance♪", "alice_fc5", 2],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Alice>That's it! Hustle! Hustle!", "alice_fc5", 7],
      },
      [2061] => { # 蛇神の舞
        :word_1 => ["\\n<Alice>The burning heart is the dance of the snake god...♪", "alice_fc5", 2],
      },
      [2064] => { # 十六夜神楽
        :word_1 => ["\\n<Alice>This body is a dream, Waning Moon Dance...♪", "alice_fc5", 2],
      },
      [2065] => { # 宵月神楽
        :word_1 => ["\\n<Alice>This body is reality, Evening Moon Dance...♪", "alice_fc5", 2],
      },
      [9399] => { # 清めの神舞
        :word_1 => ["\\n<Alice>Exorcise the curse, the divine dance of purification...♪", "alice_fc5", 2],
      },
      [9402] => { # 無限蛇の踊り
        :word_1 => ["\\n<Alice>Not bound by any shackles...♪", "alice_fc5", 2],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Alice>Hey, listen to my song!", "alice_fc5", 2],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Alice>extra sparkle☆", "alice_fc5", 7],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Alice>I want to have a little chat with you...", "alice_fc5", 2],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Alice>You're doing quite well, I'll praise you...", "alice_fc5", 1],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Alice>Hmm, I'm disappointed in you...", "alice_fc5", 3],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Alice>You there, I want some money...", "alice_fc5", 2],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Alice>You there, I want an item...", "alice_fc5", 2],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Alice>You there, I want you to work for me!", "alice_fc5", 2],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Alice>Would you like to try the food I made...?", "alice_fc5", 2],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Alice>Hora, go home, go home!", "alice_fc5", 2],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Alice>And then Tamamo's servant fell down the stairs...kuku.", "alice_fc5", 1],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Alice>I've secretly gotten a peek inside Alma Elma's room, believe it or not...!", "alice_fc5", 2],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Alice>I hesitantly peeked through the opening...\nand there was a woman wearing a fox mask...! *trembling*", "alice_fc5", 5],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Alice>Alice is in the palace.", "alice_fc5", 7],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Alice>Enjoy the power of words!", "alice_fc5", 2],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Alice>This is the power of science!", "alice_fc5", 2],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Alice>All right, I'm prepared for a crisis!", "alice_fc5", 2],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Alice>Energy conversion... Ha!", "alice_fc5", 2],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Alice>Let's alchemize \nItem!", "alice_fc5", 2],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Alice>Look at the power of the magic book!", "alice_fc5", 2],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Alice>My body is turning into pages...", "alice_fc5", 2],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Alice>I can also use machines!", "alice_fc5", 2],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Alice>Kukuku...Let me show you my cooking!", "alice_fc5", 2],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Alice>I've got your ingredients!", "alice_fc5", 1],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Alice>Look, look at my female skills!", "alice_fc5", 2],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Alice>Now, writhe in agony at my techniques...", "alice_fc5", 2],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Alice>Look, look at my female skills!", "alice_fc5", 2],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Alice>Look, use this medicine...", "alice_fc5", 2],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Alice>Here, I'll give you an injection...", "alice_fc5", 2],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Alice>Let's spread the \n special virus!", "alice_fc5", 2],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Alice>I'm a hard worker! Sora Sora!", "alice_fc5", 2],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Alice>Now, writhe in agony at my techniques...", "alice_fc5", 2],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Alice>Tea has arrived, the devil's tea!", "alice_fc5", 2],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Alice>A maid can transform with ease!", "alice_fc5", 2],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Alice>It's about time to harvest, kukuku......", "alice_fc5", 2],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Alice>See the king's sword skills with your own eyes!", "alice_fc5", 2],
      },
      [2403] => { # 王者の刃
        :word_1 => ["\\n<Alice>Take a good look at this, Ruler's Brand!", "alice_fc5", 2],
      },
      [2404] => { # 王命剣
        :word_1 => ["\\n<Alice>Engrave upon their body... Royal Decree Sword!", "alice_fc5", 2],
      },
      [2405] => { # キングスクルセイド
        :word_1 => ["\\n<Alice>Carve the blade of belief... King's Crusade!", "alice_fc5", 2],
      },
      [2406] => { # 覇道皇塵剣
        :word_1 => ["\\n<Alice>This is the supreme king's blow... the supreme supreme sword!", "alice_fc5", 2],
      },
      [9519] => { # 真・覇王聖剣
        :word_1 => ["\\n<Alice>This is the holy sword wielded by the overlord...sigh!", "alice_fc5", 2],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Alice>This is the king's magic!", "alice_fc5", 2],
      },
      [9521] => { # 天臥裂煌
        :word_1 => ["\\n<Alice>Wang Wei, roar in the heavens and earth... Heaven and Earth's sparkle!", "alice_fc5", 2],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Alice>Servants of the Monster Lord, gather here!", "alice_fc5", 2],
      },
      [2413] => { # 王の軍隊
        :word_1 => ["\\n<Alice>Gather around, army of the Monster Lord!", "alice_fc5", 2],
      },
      [2414] => { # 王国騎士団
        :word_1 => ["\\n<Alice>Knight of the Monster Lord, show your loyalty!", "alice_fc5", 2],
      },
      [9522] => { # 覇王の親衛隊
        :word_1 => ["\\n<Alice>My Imperial Guard, destroy the enemy!", "alice_fc5", 2],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Alice>Ascend to heaven from my sermon!", "alice_fc5", 2],
      },
      [2420] => { # 王の威光
        :word_1 => ["\\n<Alice>Bow down before the authority of the Monster Lord!", "alice_fc5", 2],
      },
      [2421] => { # 王権神授
        :word_1 => ["\\n<Alice>This is the proof of the Monster Lord!", "alice_fc5", 2],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Alice>Abominable goddess, lend me your power...!", "alice_fc5", 2],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Alice>Chyoeeeee!", "alice_fc5", 2],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Alice>I never thought I'd be able to use the hero's techniques...!", "alice_fc5", 2],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Alice>Look, you're going crazy in agony at my lewd techniques!", "alice_fc5", 2],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Alice>I can control my sexual desire!", "alice_fc5", 2],
      },
      [2519] => { # ファイアワルツ
        :word_1 => ["\\n<Alice>Dance with the flames! Fire Waltz!", "alice_fc5", 2],
      },
      [2520] => { # フレアロンド
        :word_1 => ["\\n<Alice>Dance, hellish flames of reincarnation! Flare Rondo!", "alice_fc5", 2],
      },
      [2521] => { # バーンレクイエム
        :word_1 => ["\\n<Alice>Flames of the pyre, lead them to Hades! Burn Requiem!", "alice_fc5", 2],
      },
      [2522] => { # アークオベリスク
        :word_1 => ["\\n<Alice>Ancient flame, dance at the feast! Ark obelisk!", "alice_fc5", 2],
      },
      [2523] => { # 太古の炎
        :word_1 => ["\\n<Alice>The ancient hellfire that devours this world...!", "alice_fc5", 2],
      },
      [2524] => { # 魔界の煉獄
        :word_1 => ["\\n<Alice>Purgatory in the demon world, burn down this world...!", "alice_fc5", 2],
      },
      [9537] => { # 倶利伽羅の黒龍
        :word_1 => ["\\n<Alice>Black dragon, burn this world to the ground!", "alice_fc5", 2],
      },
      [2530] => { # 魔雷
        :word_1 => ["\\n<Alice>Scream throughout the twisted night! Demonic Lightning!", "alice_fc5", 2],
      },
      [2531] => { # 黒雷
        :word_1 => ["\\n<Alice>Turn even their echoing screams to dust! Black Lightning!", "alice_fc5", 2],
      },
      [2535] => { # サンスフィア
        :word_1 => ["\\n<Alice>Dazzling light, shine upon the darkness! Sun Sphere!", "alice_fc5", 2],
      },
      [2536] => { # エヴァゲリオ
        :word_1 => ["\\n<Alice>The gospel has arrived, and shall exemplify its judgement! Evagelio!", "alice_fc5", 2],
      },
      [9540] => { # 白蛇神光
        :word_1 => ["\\n<Alice>Inviting the holy light...White snake divine light!", "alice_fc5", 2],
      },
      [9541] => { # 楽園の光
        :word_1 => ["\\n<Alice>This is the light that once illuminated paradise...", "alice_fc5", 2],
      },
      [2546] => { # 毒の魔眼
        :word_1 => ["\\n<Alice>Be drenched in poison... Demon Eyes!", "alice_fc5", 2],
      },
      [2547] => { # 暗闇の魔眼
        :word_1 => ["\\n<Alice>Cover their sight in darkness... Demon Eyes!", "alice_fc5", 2],
      },
      [2548] => { # 沈黙の魔眼
        :word_1 => ["\\n<Alice>Shut your noisy mouth... Demon Eyes!", "alice_fc5", 2],
      },
      [2549] => { # 混乱の魔眼
        :word_1 => ["\\n<Alice>Go mad from confusion... Demon Eyes!", "alice_fc5", 2],
      },
      [2550] => { # 睡眠の魔眼
        :word_1 => ["\\n<Alice>Fall into a distorted dream... Demon Eyes!", "alice_fc5", 2],
      },
      [2551] => { # 麻痺の魔眼
        :word_1 => ["\\n<Alice>Take away their freedom... Demon Eyes!", "alice_fc5", 2],
      },
      [2555] => { # 暴走の魔眼
        :word_1 => ["\\n<Alice>Abandon reason and give in to rage... Demon Eyes!", "alice_fc5", 2],
      },
      [2556] => { # 石化の魔眼
        :word_1 => ["\\n<Alice>Be reduced to silent stone... Demon Eyes!", "alice_fc5", 2],
      },
      [2557] => { # 即死の魔眼
        :word_1 => ["\\n<Alice>Become a cold, lifeless corpse... Demon Eyes!", "alice_fc5", 2],
      },
      [9542] => { # 最後の魔眼
        :word_1 => ["\\n<Alice>Taste hell with the final evil eye...", "alice_fc5", 2],
      },
      [2558] => { # 王者の魔眼
        :word_1 => ["\\n<Alice>This is the evil eye of the king...", "alice_fc5", 2],
      },
      [2559] => { # 蛇神の魔眼
        :word_1 => ["\\n<Alice>The power of the snake god...the evil eye!", "alice_fc5", 2],
      },
      [9545] => { # エキドナの魔眼
        :word_1 => ["\\n<Alice>The power that corrupted and degraded paradise...", "alice_fc5", 2],
      },
      [9547] => { # 邪神の魔眼
        :word_1 => ["\\n<Alice>With my evil eye, I will return everything to darkness...!", "alice_fc5", 2],
      },
      [2561] => { # 誘惑の魔眼
        :word_1 => ["\\n<Alice>Your heart shall fill with carnal desire... Demon Eyes!", "alice_fc5", 2],
      },
      [2564] => { # 浄化の魔眼
        :word_1 => ["\\n<Alice>Return the impure ones to heaven... Demon Eyes!", "alice_fc5", 2],
      },
      [2565] => { # 回復の魔眼
        :word_1 => ["\\n<Alice>Grant healing to their wounded body... Demon Eyes!", "alice_fc5", 2],
      },
      [2566] => { # 全快の魔眼
        :word_1 => ["\\n<Alice>A blessing for those driven to the brink... Demon Eyes!", "alice_fc5", 2],
      },
      [2567] => { # 治癒の魔眼
        :word_1 => ["\\n<Alice>Grant recovery to their afflicted body... Demon Eyes!", "alice_fc5", 2],
      },
      [2568] => { # 復活の魔眼
        :word_1 => ["\\n<Alice>Return the soul to its lifeless body... Demon Eyes!", "alice_fc5", 2],
      },
      [2602] => { # 水撃
        :word_1 => ["\\n<Alice>Eat this, Water Bullet!", "alice_fc5", 2],
      },
      [2603] => { # 大海嘯
        :word_1 => ["\\n<Alice>Wash them away... Riptide!", "alice_fc5", 2],
      },
      [2605] => { # 潮吹き
        :word_1 => ["\\n<Alice>Topple them, tide of wrath!", "alice_fc5", 2],
      },
      [2606] => { # ノーチラス
        :word_1 => ["\\n<Alice>The fangs of the depths will break you...\nBe crushed with a single breath!", "alice_fc5", 2],
      },
      [2612] => { # 水中放電
        :word_1 => ["\\n<Alice>An electric discharge from the body... Go numb!", "alice_fc5", 2],
      },
      [2613] => { # 海神の電
        :word_1 => ["\\n<Alice>Sea god's thunder, deliver your ruthless judgement!", "alice_fc5", 2],
      },
      [2619] => { # 深淵に引きずり込む者
        :word_1 => ["\\n<Alice>I'll show you the abyss of the ocean's depths...", "alice_fc5", 2],
      },
      [2620] => { # 深海の供物
        :word_1 => ["\\n<Alice>You body shall be sacrificed to me...", "alice_fc5", 2],
      },
      [2624] => { # あわあわ
        :word_1 => ["\\n<Alice>Hoora, lose your mind as I cover you in bubbles!", "alice_fc5", 2],
      },
      [2625] => { # メルティウォッシュ
        :word_1 => ["\\n<Alice>Hora hora... I'll be washing you myself!", "alice_fc5", 2],
      },
      [9560] => { # 究極あわあわ地獄
        :word_1 => ["\\n<Alice>Ascend to heaven with pleasure, the ultimate frothy hell!", "alice_fc5", 2],
      },
      [2643] => { # 恍惚粘液
        :word_1 => ["\\n<Alice>Soak in ecstasy with this slime...", "alice_fc5", 2],
      },
      [2644] => { # 失禁粘液
        :word_1 => ["\\n<Alice>I'll make you leak with this slime...", "alice_fc5", 2],
      },
      [2646] => { # 消化粘液
        :word_1 => ["\\n<Alice>I'll dissolve your body and soul with this slime...", "alice_fc5", 2],
      },
      [2647] => { # 消化粘液の渦
        :word_1 => ["\\n<Alice>Drown in a whirlpool of digestive slime...", "alice_fc5", 2],
      },
      [2651] => { # ネバネバ粘液地獄
        :word_1 => ["\\n<Alice>Hoora, be flooded with a hell of slime...!", "alice_fc5", 2],
      },
      [2652] => { # ドロドロ粘液天国
        :word_1 => ["\\n<Alice>Immerse yourself in the slime and ascend to heaven...!", "alice_fc5", 2],
      },
      [2653] => { # 快楽昇天ドロドロジェル
        :word_1 => ["\\n<Alice>Melt in pleasure...!", "alice_fc5", 2],
      },
      [9569] => { # 次元侵蝕粘液
        :word_1 => ["\\n<Alice>Erode, the slime that invades dimensions...!", "alice_fc5", 2],
      },
      [2678] => { # 引っ掻き
        :word_1 => ["\\n<Alice>Eat my claws!", "alice_fc5", 2],
      },
      [2679] => { # 一撃の爪
        :word_1 => ["\\n<Alice>I'll reap your life with my claws!", "alice_fc5", 2],
      },
      [2680] => { # 咬爪乱撃
        :word_1 => ["\\n<Alice>I'll shred you apart and eat you up!", "alice_fc5", 2],
      },
      [2681] => { # 電塵爪
        :word_1 => ["\\n<Alice>Claws, bear lightning...!", "alice_fc5", 2],
      },
      [2682] => { # 乱れ電塵爪
        :word_1 => ["\\n<Alice>Rampage, claws of lightning!", "alice_fc5", 2],
      },
      [2683] => { # グリフィススクラッチ
        :word_1 => ["\\n<Alice>Burn them to ash, crimson claws!", "alice_fc5", 2],
      },
      [2684] => { # プラズマランページ
        :word_1 => ["\\n<Alice>With claws of lightning, not even dust will remain!", "alice_fc5", 2],
      },
      [2685] => { # 死舞爪
        :word_1 => ["\\n<Alice>Dance in pitch black, the claws of the underworld...!", "alice_fc5", 2],
      },
      [2685] => { # 死舞爪
        :word_1 => ["\\n<Alice>Dance in pitch black, the claws of the underworld...!", "alice_fc5", 2],
      },
      [9578] => { # 白天滅牙
        :word_1 => ["\\n<Alice>Pierce the heavens, the fangs of destruction...!", "alice_fc5", 2],
      },
      [9581] => { # 核熱獣乱牙
        :word_1 => ["\\n<Alice>Raging, fangs of nuclear heat!", "alice_fc5", 2],
      },
      [9582] => { # 超魔核熱獣撃
        :word_1 => ["\\n<Alice>The evil beast of nuclear fever will destroy this world!", "alice_fc5", 2],
      },
      [2700] => { # 啼魔咆吼
        :word_1 => ["\\n<Alice>Ohhhh...!!", "alice_fc5", 2],
      },
      [2686] => { # 噛み付き
        :word_1 => ["\\n<Alice>My fangs will shred you apart!", "alice_fc5", 2],
      },
      [2687] => { # 連続噛み付き
        :word_1 => ["\\n<Alice>I'll crush you with my fangs!", "alice_fc5", 2],
      },
      [2688] => { # 轟連牙
        :word_1 => ["\\n<Alice>These nightmarish fangs break everything! Eat this!", "alice_fc5", 2],
      },
      [2693] => { # 虚牙
        :word_1 => ["\\n<Alice>The fang of nothingness that pierces all things!", "alice_fc5", 2],
      },
      [2691] => { # 絶氷牙
        :word_1 => ["\\n<Alice>My fangs are cold as ice...!", "alice_fc5", 2],
      },
      [2692] => { # 断氷連牙
        :word_1 => ["\\n<Alice>Shred, merciless fangs of ice!", "alice_fc5", 2],
      },
      [9577] => { # 破壊の爪
        :word_1 => ["\\n<Alice>The height of beastliness...claws of destruction!", "alice_fc5", 2],
      },
      [2694] => { # 体当たり
        :word_1 => ["\\n<Alice>Ramming attack... Haaaa!", "alice_fc5", 2],
      },
      [2695] => { # 大暴れ
        :word_1 => ["\\n<Alice>I'll take you all down!", "alice_fc5", 2],
      },
      [2696] => { # 蹂躙撃
        :word_1 => ["\\n<Alice>I'll trample you... Haaaa!", "alice_fc5", 2],
      },
      [2697] => { # 威嚇
        :word_1 => ["\\n<Alice>Stay back...!", "alice_fc5", 2],
      },
      [2698] => { # おたけび
        :word_1 => ["\\n<Alice>Raaaaah......!!", "alice_fc5", 2],
      },
      [2699] => { # 破壊の咆吼
        :word_1 => ["\\n<Alice>Raaaaah......!!", "alice_fc5", 2],
      },
      [2701] => { # 獣魔合乱撃
        :word_1 => ["\\n<Alice>I'll crush you...! Raaah!!", "alice_fc5", 2],
      },
      [2702] => { # 獣魔乱舞
        :word_1 => ["\\n<Alice>I'll freely wield the might of a ferocious beast!", "alice_fc5", 2],
      },
      [2703] => { # 同種殺し
        :word_1 => ["\\n<Alice>Beast, know the power of the Monster Lord...!", "alice_fc5", 2],
      },
      [2712] => { # ベノムアタック
        :word_1 => ["\\n<Alice>Poisonous claws... Haa!", "alice_fc5", 2],
      },
      [2713] => { # ベノンザッパー
        :word_1 => ["\\n<Alice>Taste it for yourself, an assault of deadly venom!", "alice_fc5", 2],
      },
      [2715] => { # ベノムグランテ
        :word_1 => ["\\n<Alice>Carve \n, the ultimate poisonous claw!", "alice_fc5", 2],
      },
      [9579] => { # 百魔乱舞
        :word_1 => ["\\n<Alice>Runaway! Bakusou!　Haaaaa!!", "alice_fc5", 2],
      },
      [9580] => { # 空間蹂躙
        :word_1 => ["\\n<Alice>The entire space has been overrun...!", "alice_fc5", 2],
      },
      [2714] => { # ベノムバウンド
        :word_1 => ["\\n<Alice>Mow down, a flash of deadly poison!", "alice_fc5", 2],
      },
      [2716] => { # 尻尾コキ
        :word_1 => ["\\n<Alice>Hoore, taste the pleasure of my tail...!", "alice_fc5", 2],
      },
      [2717] => { # 獣の口淫
        :word_1 => ["\\n<Alice>Hoore, taste my oral skills...!", "alice_fc5", 2],
      },
      [2718] => { # ワイルドレイプ
        :word_1 => ["\\n<Alice>I'll rape you like a beast...!", "alice_fc5", 2],
      },
      [2722] => { # ぷにぷに肉球手コキ
        :word_1 => ["\\n<Alice>These paws of mine are squishy...♪", "alice_fc5", 7],
      },
      [2723] => { # ざらざら猫舌フェラ
        :word_1 => ["\\n<Alice>A rough tongue can give powerful stimulation...", "alice_fc5", 2],
      },
      [2726] => { # ビーストハウリング
        :word_1 => ["\\n<Alice>Can you see through these movements?!", "alice_fc5", 2],
      },
      [2727] => { # 獣の本能
        :word_1 => ["\\n<Alice>Now, there's no stopping me...!", "alice_fc5", 2],
      },
      [2728] => { # ルナティックハイ
        :word_1 => ["\\n<Alice>Rising instinct, destroy everything...!", "alice_fc5", 2],
      },
      [2729] => { # ジェノサイドハイ
        :word_1 => ["\\n<Alice>Blood impulse, destroy everything...", "alice_fc5", 2],
      },
      [2732] => { # ねこまねき
        :word_1 => ["\\n<Alice>Nyaa, nyaa♪", "alice_fc5", 7],
      },
      [2733] => { # ぐっすりにゃんこ
        :word_1 => ["\\n<Alice>I'm going to get some sleep...", "alice_fc5", 2],
      },
      [2734] => { # 凍てつく波動
        :word_1 => ["\\n<Alice>I'll erase all that power...!", "alice_fc5", 2],
      },
      [2740] => { # 蛇撃
        :word_1 => ["\\n<Alice>Eat this, tail strike!", "alice_fc5", 2],
      },
      [2741] => { # 蛇体薙ぎ
        :word_1 => ["\\n<Alice>I'll knock you all down with my tail!", "alice_fc5", 2],
      },
      [2742] => { # スネークパニッシャー
        :word_1 => ["\\n<Alice>I'll punish you with my serpentine body!", "alice_fc5", 2],
      },
      [2743] => { # 蛇王滅誅
        :word_1 => ["\\n<Alice>Shatter into pieces!", "alice_fc5", 2],
      },
      [2744] => { # ラミアロール
        :word_1 => ["\\n<Alice>Hoora, I'll coil around you...!", "alice_fc5", 2],
      },
      [2745] => { # ヘビィロール
        :word_1 => ["\\n<Alice>I'll coil around and around like this...kuku.", "alice_fc5", 2],
      },
      [2746] => { # 悪夢の締め付け
        :word_1 => ["\\n<Alice>I'll give you plenty of tightening...", "alice_fc5", 2],
      },
      [2747] => { # クィーンズロール
        :word_1 => ["\\n<Alice>Enjoy the Queen's embrace...", "alice_fc5", 2],
      },
      [9591] => { # ミドガルズオルム
        :word_1 => ["\\n<Alice>A great embrace, Midgardsorm...!", "alice_fc5", 2],
      },
      [2748] => { # 丸呑み
        :word_1 => ["\\n<Alice>Hoora, I'll swallow you whole...", "alice_fc5", 2],
      },
      [2749] => { # 悪夢の踊り食い
        :word_1 => ["\\n<Alice>Relish in the nightmare as you're swallowed alive...!", "alice_fc5", 2],
      },
      [2750] => { # クィーンズボア
        :word_1 => ["\\n<Alice>Become food for the Queen...", "alice_fc5", 2],
      },
      [9592] => { # ヨルムンガンド
        :word_1 => ["\\n<Alice>Jormungandr devours everything...!", "alice_fc5", 2],
      },
      [2751] => { # 石化撃
        :word_1 => ["\\n<Alice>This strike will turn you to stone...!", "alice_fc5", 2],
      },
      [2752] => { # 石化乱撃
        :word_1 => ["\\n<Alice>A barrage of petrifying blows...!", "alice_fc5", 2],
      },
      [2755] => { # 蛇尾コキ
        :word_1 => ["\\n<Alice>Hoora, taste the pleasure of my tail...!", "alice_fc5", 2],
      },
      [2756] => { # チロチロフェラ
        :word_1 => ["\\n<Alice>Squirm from my tongue...!", "alice_fc5", 2],
      },
      [2757] => { # ラミアの魔膣
        :word_1 => ["\\n<Alice>Get a taste of my devilish vagina...!", "alice_fc5", 2],
      },
      [2758] => { # 聖母蛇の抱擁
        :word_1 => ["\\n<Alice>Kuku, I'll embrace you gently...", "alice_fc5", 2],
      },
      [2759] => { # 昇天の抱擁
        :word_1 => ["\\n<Alice>I'll let you finish within my embrace...", "alice_fc5", 2],
      },
      [2760] => { # 稚児搾り
        :word_1 => ["\\n<Alice>Kuku, I'll squeeze you with affection...", "alice_fc5", 2],
      },
      [2761] => { # 夜叉淫舌
        :word_1 => ["\\n<Alice>Squirm from my tongue...!", "alice_fc5", 2],
      },
      [2762] => { # 包み乳楽
        :word_1 => ["\\n<Alice>Being smothered in my breasts is the ultimate bliss...", "alice_fc5", 2],
      },
      [2763] => { # 蛇夜伽
        :word_1 => ["\\n<Alice>Writhe in pleasure from a lamia's evening attendance...!", "alice_fc5", 2],
      },
      [2764] => { # 淫邪の蛇髪
        :word_1 => ["\\n<Alice>My hair shall indulge in you...", "alice_fc5", 2],
      },
      [2765] => { # 淫蛇の蜜壺
        :word_1 => ["\\n<Alice>My vagina is also slithering with snakes...", "alice_fc5", 2],
      },
      [2766] => { # 楽園蛇の誘惑
        :word_1 => ["\\n<Alice>The primordial snake, an invitation to corruption...", "alice_fc5", 2],
      },
      [2767] => { # ラミアの祈り
        :word_1 => ["\\n<Alice>With my prayers, bring forth healing...!", "alice_fc5", 2],
      },
      [2768] => { # ラミアの寵光
        :word_1 => ["\\n<Alice>Oh Dark Goddess, grant me a miracle...!", "alice_fc5", 2],
      },
      [2769] => { # 脱皮
        :word_1 => ["\\n<Alice>I'm molting my scales, so look away!", "alice_fc5", 2],
      },
      [2775] => { # 触手撃
        :word_1 => ["\\n<Alice>Eat a strike from my tentacles!", "alice_fc5", 2],
      },
      [2776] => { # 触手乱舞
        :word_1 => ["\\n<Alice>Run wild, my tentacles!", "alice_fc5", 2],
      },
      [2777] => { # テンタクルストーム
        :word_1 => ["\\n<Alice>Eat this, a storm of tentacles!", "alice_fc5", 2],
      },
      [2778] => { # 剛触手撃
        :word_1 => ["\\n<Alice>My tentacles will smash you!", "alice_fc5", 2],
      },
      [2779] => { # 乱打触手舞
        :word_1 => ["\\n<Alice>Be pulverized by my wild tentacles!", "alice_fc5", 2],
      },
      [2780] => { # テンタクルレイド
        :word_1 => ["\\n<Alice>I'll cleave you away with my tentacles!", "alice_fc5", 2],
      },
      [2781] => { # テンタクルブラスト
        :word_1 => ["\\n<Alice>A blow from these tentacles will shatter you into dust!", "alice_fc5", 2],
      },
      [2782] => { # ナノテンタクル
        :word_1 => ["\\n<Alice>Destroy everything with microscopic tentacles...!", "alice_fc5", 2],
      },
      [9596,9604] => { # デミウルゴス
        :word_1 => ["\\n<Alice>Release all tentacles...Release them!", "alice_fc5", 2],
      },
      [2783] => { # 触手拘束
        :word_1 => ["\\n<Alice>Hoora, I'll catch you with my tentacles!", "alice_fc5", 2],
      },
      [2784] => { # テンタクルバインド
        :word_1 => ["\\n<Alice>Kuku, I'll wrap my tentacles around you!", "alice_fc5", 2],
      },
      [2785] => { # インフェルノバインド
        :word_1 => ["\\n<Alice>Taste the hell of being wrapped in tentacles...!", "alice_fc5", 2],
      },
      [2786] => { # 蛇縊り
        :word_1 => ["\\n<Alice>These tentacles strangle snakes...!", "alice_fc5", 2],
      },
      [2787] => { # ラミアキャプチャー
        :word_1 => ["\\n<Alice>I'll kill snakes with these tentacles...!", "alice_fc5", 2],
      },
      [2788] => { # 触手愛撫
        :word_1 => ["\\n<Alice>Squirm from the pleasure of my tentacles...!", "alice_fc5", 2],
      },
      [2789] => { # 乱れ触手愛撫
        :word_1 => ["\\n<Alice>Play with them every which way, my tentacles!", "alice_fc5", 2],
      },
      [2790] => { # テンタクルワルツ
        :word_1 => ["\\n<Alice>Writhe in the maddening ecstasy of these tentacles...!", "alice_fc5", 2],
      },
      [2810] => { # 麻痺触手
        :word_1 => ["\\n<Alice>Go numb from this tentacle!", "alice_fc5", 2],
      },
      [2811] => { # 猛毒触手
        :word_1 => ["\\n<Alice>Be poisoned by this tentacle!", "alice_fc5", 2],
      },
      [2812] => { # 催淫触手
        :word_1 => ["\\n<Alice>Drown in carnal desire from this tentacle!", "alice_fc5", 2],
      },
      [2813] => { # 即死の触手
        :word_1 => ["\\n<Alice>I'll send you to the next world with this tentacle!", "alice_fc5", 2],
      },
      [2814] => { # 失禁の触手
        :word_1 => ["\\n<Alice>I'll make you pitifully incontinent with this tentacle!", "alice_fc5", 2],
      },
      [2815] => { # スミ
        :word_1 => ["\\n<Alice>How come I'm spitting ink...? I'm not an octopus!", "alice_fc5", 2],
      },
      [2816] => { # 闇霧
        :word_1 => ["\\n<Alice>Fog of darkness, blot out their surroundings!", "alice_fc5", 2],
      },
      [2817] => { # ナイトメアミスト
        :word_1 => ["\\n<Alice>Mist of nightmares, bring forth total darkness!", "alice_fc5", 2],
      },
      [2818] => { # バイオミスト
        :word_1 => ["\\n<Alice>Poison mist, blot out their surroundings!", "alice_fc5", 2],
      },
      [2820] => { # テンタクルアップ
        :word_1 => ["\\n<Alice>Awakening tentacles...!", "alice_fc5", 2],
      },
      [2821] => { # テンタクルハイアップ
        :word_1 => ["\\n<Alice>Awakening more tentacles...!", "alice_fc5", 2],
      },
      [2822] => { # テンタクルエクスアップ
        :word_1 => ["\\n<Alice>Behold, the ultimate tentacle awakening!", "alice_fc5", 2],
      },
      [3068] => { # 火の息
        :word_1 => ["\\n<Alice>Taste my breath of fire!", "alice_fc5", 2],
      },
      [3070] => { # 激しい炎
        :word_1 => ["\\n<Alice>Taste my breath of flames!", "alice_fc5", 2],
      },
      [3081] => { # バイオブレス
        :word_1 => ["\\n<Alice>Go mad in anguish from my toxic breath!", "alice_fc5", 2],
      },
      [9697] => { # マグナ・ノヴァ
        :word_1 => ["\\n<Alice>Breath of the Earth... Magna Nova!", "alice_fc5", 2],
      },
      [9696] => { # ガイアブレス
        :word_1 => ["\\n<Alice>The breath of the earth...Gaia's breath!", "alice_fc5", 2],
      },
      [9698] => { # アークブレス
        :word_1 => ["\\n<Alice>Condensed deadly poison...Arc breath!", "alice_fc5", 2],
      },
      [9701] => { # 次元侵蝕ブレス
        :word_1 => ["\\n<Alice>A breath that invades the dimension...!", "alice_fc5", 2],
      },
      [3085] => { # 毒の息
        :word_1 => ["\\n<Alice>Eat my poisonous breath!", "alice_fc5", 2],
      },
      [3086] => { # 甘い息
        :word_1 => ["\\n<Alice>This sweet fragrance shall lull you to sleep!", "alice_fc5", 2],
      },
      [3087] => { # 焼け付く息
        :word_1 => ["\\n<Alice>Go numb from this scorching breath!", "alice_fc5", 2],
      },
      [3088] => { # 臭い息
        :word_1 => ["\\n<Alice>Struggle in torment from this nightmarish breath...", "alice_fc5", 2],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Alice>Let's go, haa...!", "alice_fc5", 2],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Alice>Charge my strength...!", "alice_fc5", 2],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Alice>Focus my spirit...!", "alice_fc5", 2],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Alice>I'll show you my full power...!", "alice_fc5", 2],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Alice>Let me show you the final secret technique...!", "alice_fc5", 2],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Alice>Focus my chi into my fist...!", "alice_fc5", 2],
      },
      [3100] => { # 裏練気
        :word_1 => ["\\n<Alice>Inner chi, imbue my fist...!", "alice_fc5", 2],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Alice>My body can become as tough as steel!", "alice_fc5", 2],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Alice>The ultimate in concentration, the final effort...!", "alice_fc5", 2],
      },
      [3103] => { # 魔力集中
        :word_1 => ["\\n<Alice>Concentrate my magic...!", "alice_fc5", 2],
      },
      [9777] => { # ソフィスティケイト
        :word_1 => ["\\n<Alice>Concentrate on one point...Sophisticate!", "alice_fc5", 2],
      },
      [6183] => { # 邪神炎極ノ纏
        :word_1 => ["\\n<Alice>It will burn you down... The ultimate robe of evil divine flame!", "alice_fc5", 2],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Alice>Take a deep breath, huh...", "alice_fc5", 2],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Alice>It's at times like this that I use first aid!", "alice_fc5", 2],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Alice>Fighting on the brink is the way to victory!", "alice_fc5", 2],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Alice>From now on, I'm going to rampage...!", "alice_fc5", 2],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Alice>Let's go... Transform!", "alice_fc5", 2],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Alice>Henshin! Magical☆Alice♪", "alice_fc5", 7],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Alice>Hey, quit struggling!", "alice_fc5", 2],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Alice>Reinforcements, come to my side!", "alice_fc5", 2],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Alice>I'll break that power!", "alice_fc5", 2],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Alice>Spout, geyser!", "alice_fc5", 2],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Alice>Don't move an inch!", "alice_fc5", 2],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Alice>Kuku, I'll take those!", "alice_fc5", 2],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Alice>Teehee♪ Sexy Beam!", "alice_fc5", 7],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Alice>Teehee♪ Pink Typhoon!", "alice_fc5", 7],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Alice>Ugh♪ Fantastic Hurricane!", "alice_fc5", 7],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Alice>Now, this is my stage!", "alice_fc5", 1],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Alice>Why am I having to do all the work?!", "alice_fc5", 2],
      },
      [3161] => { # アビスドレイン
        :word_1 => ["\\n<Alice>I'll squeeze all the life out of you...", "alice_fc5", 2],
      },
      [3163] => { # スラッグドレイン
        :word_1 => ["\\n<Alice>I'm going to suck a lot out of you...!", "alice_fc5", 2],
      },
      [3164] => { # スラッグボア
        :word_1 => ["\\n<Alice>I'll dissolve you with my body...!", "alice_fc5", 2],
      },
      [3166] => { # 毒舌ナメナメ
        :word_1 => ["\\n<Alice>I'll lick you all over with my poisonous tongue...", "alice_fc5", 2],
      },
      [3167] => { # 軟体ボディ
        :word_1 => ["\\n<Alice>I'll soften my body...!", "alice_fc5", 2],
      },
      [3168] => { # 粘液大量分泌
        :word_1 => ["\\n<Alice>This mucus will nullify any impacts...", "alice_fc5", 2],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Alice>Puff Puff...If I were in my original body...", "alice_fc5", 3],
      },
      [3555] => { # 誘惑専用
        :word_y1 => ["\\n<Alice>Nnn... This one belongs to me...\n*lick-lick*...*lick-lick*......", "alice_fc5", 2],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Alice>Now, show your strength...!", "alice_fc5", 2],
      },
      [9238] => { # うさぎコメット
        :word_1 => ["\\n<Alice>Come, Rabbit's Great Meteorite!", "alice_fc5", 2],
      },
      [1568] => { # アリスインワンダーランド
        :word_1 => ["\\n<Alice>Wonderland...Alice in Wonderland!", "alice_fc5", 2],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Alice>This is the power of grudge...!", "alice_fc5", 2],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Alice>...Blitzkrieg!!", "alice_fc5", 2],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Alice>Prevent evil attacks... Brave Wall!", "alice_fc5", 2],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Alice>I forgive you...", "alice_fc5", 2],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Alice>Look at the miracle of the Holy Grail!", "alice_fc5", 2],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Alice>Look at the power of the aura!", "alice_fc5", 2],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Alice>With the extra power, this is easy!", "alice_fc5", 2],
      },
      [6079] => { # 紅の印
        :word_1 => ["\\n<Alice>Crimson mark, engrave upon their body...!", "alice_fc5", 2],
      },
      [6181] => { # エンドオブドリーム
        :word_1 => ["\\n<Alice>It's good to know the end of the dream...!", "alice_fc5", 2],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Alice>Ha!", "alice_fc5", 2],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Alice>I'll protect you!", "alice_fc5", 2],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Alice>Now, go to the Monster Lord... Assemble!!", "alice_fc5", 2],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Alice>Double up!", "alice_fc5", 2],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Alice>Next action, order!", "alice_fc5", 2],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Alice>The power of elementals...!", "alice_fc5", 2],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Alice>Concentrate your power on one point...!", "alice_fc5", 2],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Alice>■■■■■■■■■■■■■■■...", "alice_fc5", 2],
      },
    },
    6 => { # アリス
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Alice>Hyaah!", "alice_fc1", 3],
        :word_2 => ["\\n<Alice>Huh!", "alice_fc1", 3],
        :word_3 => ["\\n<Alice>Hey!", "alice_fc1", 3],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Alice>Look at \n's knife skills! Ha!", "alice_fc1", 3],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Alice>Take advantage of \n's sword skills!", "alice_fc1", 3],
      },
      [917] => { # 切り返し
        :word_1 => ["\\n<Alice>I cut back...haa!", "alice_fc1", 3],
      },
      [918] => { # 疾風突き
        :word_1 => ["\\n<Alice>Like the wind... Gale thrust!", "alice_fc1", 3],
      },
      [919] => { # 払車剣
        :word_1 => ["\\n<Alice>The sword flashes, like a wheel...Kurakushaken!", "alice_fc1", 3],
      },
      [920] => { # 諸刃斬り
        :word_1 => ["\\n<Alice>Receive my determination! A double-edged sword!", "alice_fc1", 3],
      },
      [921] => { # 隼斬り
        :word_1 => ["\\n<Alice>blade, dance like a falcon! Ha!", "alice_fc1", 3],
      },
      [922] => { # 火炎斬り
        :word_1 => ["\\n<Alice>Take shelter, flame... Ha!", "alice_fc1", 3],
      },
      [923] => { # 氷斬り
        :word_1 => ["\\n<Alice>Take shelter, ice... Ha!", "alice_fc1", 3],
      },
      [924] => { # 稲妻斬り
        :word_1 => ["\\n<Alice>Take shelter, lightning... Ha!", "alice_fc1", 3],
      },
      [931] => { # 真空斬り
        :word_1 => ["\\n<Alice>It's a vacuum blade...!", "alice_fc1", 3],
      },
      [932] => { # 烈風剣
        :word_1 => ["\\n<Alice>Dance, blade of fierce wind! Ha!!", "alice_fc1", 3],
      },
      [933] => { # 月影の太刀
        :word_1 => ["\\n<Alice>Dance in the moon...Shura's sword!", "alice_fc1", 3],
      },
      [934] => { # 魔神斬り
        :word_1 => ["\\n<Alice>The devil's blow... Ha!!", "alice_fc1", 3],
      },
      [935] => { # デッドクラッシュ
        :word_1 => ["\\n<Alice>Shatter with the blade of destruction! Dead crush!", "alice_fc1", 3],
      },
      [936] => { # 二刀十字斬り
        :word_1 => ["\\n<Alice>Behold the flash of the two swords! Two-sword cross slash!", "alice_fc1", 3],
      },
      [942] => { # フレイムスラッシュ
        :word_1 => ["\\n<Alice>Burn it down, a flash of red... \n Flame Slash!", "alice_fc1", 3],
      },
      [943] => { # アイススラッシュ
        :word_1 => ["\\n<Alice>Freezing, a flash of blue... \n Ice slash!", "alice_fc1", 3],
      },
      [944] => { # サンダースラッシュ
        :word_1 => ["\\n<Alice>Knock it down, a flash of yellow... \n Thunder slash!", "alice_fc1", 3],
      },
      [946] => { # 屠竜撃
        :word_1 => ["\\n<Alice>Catch \n, the blow that kills the dragon!", "alice_fc1", 3],
      },
      [947] => { # 雲身払車剣
        :word_1 => ["\\n<Alice>A blade of haze, like a wheel... a sword that removes the body!", "alice_fc1", 3],
      },
      [948] => { # 滅世斬
        :word_1 => ["\\n<Alice>A dark blade that ends this world... Destruction!", "alice_fc1", 3],
      },
      [953] => { # 死剣・乱れ星
        :word_1 => ["\\n<Alice>Twinkling meteor sword technique...Death sword/turbulent star!", "alice_fc1", 3],
      },
      [954] => { # 魔影流星斬
        :word_1 => ["\\n<Alice>Look at the dark meteor falling on the earth... Demonic Shadow Meteor Slash!", "alice_fc1", 3],
      },
      [959] => { # ギガスラッシュ
        :word_1 => ["\\n<Alice>This is the ultimate flash... \n Giga Slash!", "alice_fc1", 3],
      },
      [961] => { # 月下散華
        :word_1 => ["\\n<Alice>Spring dies under the moon... Sanka under the moon!", "alice_fc1", 3],
      },
      [962] => { # 魔刃・雪時雨
        :word_1 => ["\\n<Alice>The endless slash of Rakshasa...Magic blade, Yuki Shigure!", "alice_fc1", 3],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :word_1 => ["\\n<Alice>Fast as a gale, fast as thunder...! \n Instant strike, gale of thunder!", "alice_fc1", 3],
      },
      [969] => { # 諸刃微塵斬り
        :word_1 => ["\\n<Alice>Even if this body decays... it's a double-edged sword!", "alice_fc1", 3],
      },
      [973] => { # アトミックスラッシュ
        :word_1 => ["\\n<Alice>Erase \n, a flash of nuclear heat... Atomic Slash!", "alice_fc1", 3],
      },
      [974] => { # クァンタスラッシュ
        :word_1 => ["\\n<Alice>Erase it, a flash of quantum... Quantus Slash!", "alice_fc1", 3],
      },
      [975] => { # イオンスラッシュ
        :word_1 => ["\\n<Alice>Erase it, a flash of atoms... ion slash!", "alice_fc1", 3],
      },
      [9009] => { # ギガスラッシュクロス
        :word_1 => ["\\n<Alice>Double flash... Giga Slash Cross!", "alice_fc1", 3],
      },
      [9016] => { # 乱れ雪月花
        :word_1 => ["\\n<Alice>Dance of snow...Shadow of the moon...Scattered with flowers...!", "alice_fc1", 3],
      },
      [971] => { # 聖光六閃斬
        :word_1 => ["\\n<Alice>Receive the continuous attack of light... Six flashes of holy light!", "alice_fc1", 3],
      },
      [970] => { # メギドカリバーン
        :word_1 => ["\\n<Alice>Mowing down with the wave of darkness... Megiddo Caliburn!", "alice_fc1", 3],
      },
      [9014] => { # メギドカブラ
        :word_1 => ["\\n<Alice>This is the ultimate secret of the magic sword... Megidokabura!", "alice_fc1", 3],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Alice>The healing sword, the protection of the abominable light!", "alice_fc1", 3],
      },
      [972] => { # 闇天
        :word_1 => ["\\n<Alice>The blade of Shura that cuts everything...Dark Heaven!", "alice_fc1", 3],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Alice>Take advantage of my saber skills!", "alice_fc1", 3],
      },
      [985] => { # チャージレイ
        :word_1 => ["\\n<Alice>Charge... Ha!", "alice_fc1", 3],
      },
      [986] => { # Vスラッシュ
        :word_1 => ["\\n<Alice>More than \n victories will be carved into your body!", "alice_fc1", 3],
      },
      [987] => { # ダンシングサーブル
        :word_1 => ["\\n<Alice>Dance, Sable!　Aaah!", "alice_fc1", 3],
      },
      [988] => { # スプラッシュフルーレ
        :word_1 => ["\\n<Alice>Elegantly and brilliantly... Splash!", "alice_fc1", 3],
      },
      [989] => { # クロスアンブル
        :word_1 => ["\\n<Alice>Take advantage of the double tip of the sword!", "alice_fc1", 3],
      },
      [990] => { # トライジャッド
        :word_1 => ["\\n<Alice>Anne, Do, Trois...Try Jud!", "alice_fc1", 3],
      },
      [991] => { # フォティトゥリア
        :word_1 => ["\\n<Alice>Dance, scorching... Fotituria!", "alice_fc1", 3],
      },
      [992] => { # パゴストゥリア
        :word_1 => ["\\n<Alice>Dancing ice crystals...Pagosturia!", "alice_fc1", 3],
      },
      [993] => { # ケラヴトゥリア
        :word_1 => ["\\n<Alice>Sound the thunder... Keravturia!", "alice_fc1", 3],
      },
      [994] => { # ゼクスルージュ
        :word_1 => ["\\n<Alice>Sparkling, six-layered sword tip... Zex Rouge!", "alice_fc1", 3],
      },
      [995] => { # プリエール
        :word_1 => ["\\n<Alice>Priere, receive the tip of the sword of hellfire!", "alice_fc1", 3],
      },
      [996] => { # ヴィクトワール
        :word_1 => ["\\n<Alice>Glory of victory to the \n champion... Victoire!", "alice_fc1", 3],
      },
      [997] => { # アンスタン
        :word_1 => ["\\n<Alice>Unstan! Dance, the infinite sword tip!", "alice_fc1", 3],
      },
      [998] => { # ネメシス
        :word_1 => ["\\n<Alice>Give me your reward, the merciless blade... Nemesis!", "alice_fc1", 3],
      },
      [999] => { # ノーザンクロス
        :word_1 => ["\\n<Alice>Burn it out, the flash of the cross! Northern Cross!", "alice_fc1", 3],
      },
      [9032] => { # ギャラクシア
        :word_1 => ["\\n<Alice>Sparkle, the tip of the galactic sword! Galaxia!", "alice_fc1", 3],
      },
      [9033] => { # 魔王煉獄剣
        :word_1 => ["\\n<Alice>Take it, the Monster Lord's blade that will destroy everything... the Monster Lord's purgatory sword!", "alice_fc1", 3],
      },
      [9034] => { # ギャラクシア・エクス
        :word_1 => ["\\n<Alice>Delivered to the edge of the galaxy...Galaxia Ex!", "alice_fc1", 3],
      },
      [9031] => { # エクスィス
        :word_1 => ["\\n<Alice>A brilliant and fierce series of moves! Exis!", "alice_fc1", 3],
      },
      [9037] => { # ドゥームズデイ
        :word_1 => ["\\n<Alice>The day of revelation marks the end! Doomsday!", "alice_fc1", 3],
      },
      [9035] => { # アルテマエンデ
        :word_1 => ["\\n<Alice>The last and ultimate sword! Altemaende!", "alice_fc1", 3],
      },
      [9036] => { # 魔煌炎舞
        :word_1 => ["\\n<Alice>Dance, the demon emperor's flame! Magic flame dance!", "alice_fc1", 3],
      },
      [9029] => { # クロス・ノイエ
        :word_1 => ["\\n<Alice>Double sword tip, slash in one breath!", "alice_fc1", 3],
      },
      [9030] => { # トライ・グランテ
        :word_1 => ["\\n<Alice>The tip of the triple sword runs across the earth and defeats evil!", "alice_fc1", 3],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Alice>I bet my pride on this blade!", "alice_fc1", 3],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Alice>He will cut you into pieces with his extra white blade!", "alice_fc1", 3],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Alice>I bet the Monster Lord's pride on this white blade!", "alice_fc1", 3],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Alice>I will settle the matter with my own hands...", "alice_fc1", 3],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Alice>Look at my spear handling! Ha!", "alice_fc1", 3],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Alice>Spear, show me a hideous miracle!", "alice_fc1", 3],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Alice>Spear, give me strength!", "alice_fc1", 3],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Alice>Look at my ax skills! Ha!", "alice_fc1", 3],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Alice>Raging, my tyrannical axe!", "alice_fc1", 3],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Alice>Look at my sword skills! Ha!", "alice_fc1", 3],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Alice>Look at my sickle skills! Ha!", "alice_fc1", 3],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Alice>Go crazy with the Monster Lord's sickle!", "alice_fc1", 3],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Alice>Look at my bow skills! Ha!", "alice_fc1", 3],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Alice>Rain down, healing arrows!", "alice_fc1", 3],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Alice>Crawl on the ground with more than a whip! Ha!", "alice_fc1", 3],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Alice>I ordered you to come!", "alice_fc1", 3],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Alice>Look at the other boomerang skills! Ha!", "alice_fc1", 3],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Alice>Look at \n's iron ball handling! Ha!", "alice_fc1", 3],
      },
      [1282] => { # 鉄球撃
        :word_1 => ["\\n<Alice>Catch it, a blow from the iron ball!", "alice_fc1", 3],
      },
      [1283] => { # 鉄球火炎撃
        :word_1 => ["\\n<Alice>Burn, the iron ball strikes!", "alice_fc1", 3],
      },
      [1284] => { # 鉄球氷柱撃
        :word_1 => ["\\n<Alice>Freeze, a blow from the iron ball!", "alice_fc1", 3],
      },
      [1285] => { # 鉄球雷電撃
        :word_1 => ["\\n<Alice>Numb, a blow from the iron ball!", "alice_fc1", 3],
      },
      [1286] => { # 触手殺し
        :word_1 => ["\\n<Alice>Don't be crushed, kill the tentacles!", "alice_fc1", 3],
      },
      [1287] => { # キルスキュラ
        :word_1 => ["\\n<Alice>Take the hammer of destruction that will destroy Scylla!", "alice_fc1", 3],
      },
      [1288] => { # ヘビィスパイラル
        :word_1 => ["\\n<Alice>Knock down \n, a storm of iron balls! Heavy spiral!", "alice_fc1", 3],
      },
      [1289] => { # チェインドライブ
        :word_1 => ["\\n<Alice>Take it yourself, the rain of iron balls! \n Chain Drive!", "alice_fc1", 3],
      },
      [1290] => { # グランドドライブ
        :word_1 => ["\\n<Alice>Crawling on the ground, swift iron ball! Grand Drive!", "alice_fc1", 3],
      },
      [1291] => { # 天罰の鉄球
        :word_1 => ["\\n<Alice>Iron ball of evil, carve my anger into it!", "alice_fc1", 3],
      },
      [1292] => { # 鎖舞
        :word_1 => ["\\n<Alice>The dance is an iron ball, and the chain dance is dedicated to the heavens!", "alice_fc1", 3],
      },
      [1293] => { # デッドリーメイス
        :word_1 => ["\\n<Alice>Shatter the earth...Deadly Mace!", "alice_fc1", 3],
      },
      [1294] => { # ウェイトキャノン
        :word_1 => ["\\n<Alice>Shoot down \n, a furious blow! Weight Cannon!", "alice_fc1", 3],
      },
      [1297] => { # 鉄球剛乱舞
        :word_1 => ["\\n<Alice>Shatter without leaving any dust behind! Iron ball dance!", "alice_fc1", 3],
      },
      [1298] => { # クロスメイデン
        :word_1 => ["\\n<Alice>Flash of the cross, destroy the darkness...Cross Maiden", "alice_fc1", 3],
      },
      [1299] => { # 神楽乱陣
        :word_1 => ["\\n<Alice>Iron ball battle dance, look to the heavens... Kagura Ranjin!", "alice_fc1", 3],
      },
      [1300] => { # レイジングバースト
        :word_1 => ["\\n<Alice>Shattered iron ball! Blow away, Raging Burst!", "alice_fc1", 3],
      },
      [1301] => { # 破壊の一撃
        :word_1 => ["\\n<Alice>All my heart! Destroyed! A blow of destruction!", "alice_fc1", 3],
      },
      [1302] => { # 五星滅球撃
        :word_1 => ["\\n<Alice>A blink of an eye, a meteor of destruction... Five stars of destruction!", "alice_fc1", 3],
      },
      [1304] => { # ウロボロスアーク
        :word_1 => ["\\n<Alice>Super heavy crushing blow... Ouroboros Ark!", "alice_fc1", 3],
      },
      [1306] => { # エデンズヘブン
        :word_1 => ["\\n<Alice>Distortion, world... Eden's Heaven!", "alice_fc1", 3],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Alice>Look at Tamamo's inherited fan skills! Ha!", "alice_fc1", 3],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Alice>Look at my gun skills! Ha!", "alice_fc1", 3],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Alice>Take the healing bullet!", "alice_fc1", 3],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Alice>Experience \n's continuous attacks for yourself!", "alice_fc1", 3],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Alice>Blades in both hands, slash wildly!", "alice_fc1", 3],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Alice>Experience \n's martial arts for yourself!", "alice_fc1", 3],
      },
      [1400] => { # 足払い
        :word_1 => ["\\n<Alice>There is a chance! Foot sweep!", "alice_fc1", 3],
      },
      [1401] => { # 飛び膝蹴り
        :word_1 => ["\\n<Alice>Eat \n! Flying knee kick!", "alice_fc1", 3],
      },
      [1402] => { # 回し蹴り
        :word_1 => ["\\n<Alice>roundhouse kick, a flash!", "alice_fc1", 3],
      },
      [1403] => { # 秘孔
        :word_1 => ["\\n<Alice>I'll do it with one blow...Secret hole!", "alice_fc1", 3],
      },
      [1405] => { # 正拳突き
        :word_1 => ["\\n<Alice>Huh... Seiken punch!", "alice_fc1", 3],
      },
      [1406] => { # 羅刹掌
        :word_1 => ["\\n<Alice>Face the battle with \n and turn into a Rakshasa! Rakshasa palm!", "alice_fc1", 3],
      },
      [1407] => { # 爆裂拳
        :word_1 => ["\\n<Alice>Shut up and take it, the explosive fist! \n Huh!", "alice_fc1", 3],
      },
      [1408] => { # 電塵連脚
        :word_1 => ["\\n<Alice>Shut up and take it, lightning legs! \n Huh!", "alice_fc1", 3],
      },
      [1409] => { # 炎舞三連撃
        :word_1 => ["\\n<Alice>Burn, triple fire!", "alice_fc1", 3],
      },
      [1410] => { # 氷拳乱雹撃
        :word_1 => ["\\n<Alice>Freezing, frigid fist!", "alice_fc1", 3],
      },
      [1411] => { # 雷神喝撃
        :word_1 => ["\\n<Alice>Disappear, thunder god's cheer!", "alice_fc1", 3],
      },
      [1412] => { # 真空波動掌
        :word_1 => ["\\n<Alice>Wind waves... A flash of inspiration!", "alice_fc1", 3],
      },
      [1413] => { # 土刻金剛拳
        :word_1 => ["\\n<Alice>Carve into the soil and pierce even Kongo!", "alice_fc1", 3],
      },
      [1414] => { # 波断水裂蹴
        :word_1 => ["\\n<Alice>Cutting through the water surface...An instant kick!", "alice_fc1", 3],
      },
      [1431] => { # エレメントフィニッシュ
        :word_1 => ["\\n<Alice>The magic fist carves an eight-colored glow...!", "alice_fc1", 3],
      },
      [1425] => { # 聖光裂閃撃
        :word_1 => ["\\n<Alice>blink, a white flash! Holy light splitting flash!", "alice_fc1", 3],
      },
      [1426] => { # 暗黒連衝拳
        :word_1 => ["\\n<Alice>Engraved \n, black shock! Dark Renchoken!", "alice_fc1", 3],
      },
      [1427] => { # 四天光掌
        :word_1 => ["\\n<Alice>Four palms of light, dance in disorder in the shining heaven and earth!", "alice_fc1", 3],
      },
      [1428] => { # 四星滅功
        :word_1 => ["\\n<Alice>Four star destruction, bloom in the dark sky!", "alice_fc1", 3],
      },
      [1429] => { # 烈気光掌
        :word_1 => ["\\n<Alice>A flash of energy can reach the heavens... A palm of intense light!", "alice_fc1", 3],
      },
      [1430] => { # 瞬獄殺
        :word_1 => ["\\n<Alice>The living are doomed...", "alice_fc1", 3],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Alice>....................", "alice_fc1", 3],
      },
      [1434] => { # 当て身光掌（発動）
        :word_1 => ["\\n<Alice>I received \n... Atemi Kosho!", "alice_fc1", 3],
      },
      [1435] => { # 金剛八連拳
        :word_1 => ["\\n<Alice>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "alice_fc1", 3],
      },
      [1436] => { # 紅蓮大拳舞
        :word_1 => ["\\n<Alice>Dance wildly, the crimson flame! Guren Daikenbu!", "alice_fc1", 3],
      },
      [9157] => { # 電塵乱皇脚
        :word_1 => ["\\n<Alice>Flash, noble thunder! Denjinran Kokyaku!", "alice_fc1", 3],
      },
      [9159] => { # 真・瞬獄殺
        :word_1 => ["\\n<Alice>The living will be destroyed, all things will be destroyed...!", "alice_fc1", 3],
      },
      [9164] => { # 修羅爆裂拳
        :word_1 => ["\\n<Alice>Shura's fist hits wildly!　Aaah!!", "alice_fc1", 3],
      },
      [9163] => { # 破滅の鉄槌
        :word_1 => ["\\n<Alice>The judgment of the fist... the hammer of destruction!", "alice_fc1", 3],
      },
      [9156] => { # 零拳
        :word_1 => ["\\n<Alice>Scattered, sub-zero freezing fist...Zero Fist!", "alice_fc1", 3],
      },
      [9165] => { # 聖天轟裂撃
        :word_1 => ["\\n<Alice>Breath of white light... Holy heaven roar ruptures!", "alice_fc1", 3],
      },
      [9166] => { # 魔天冥煌撃
        :word_1 => ["\\n<Alice>Breath of darkness... Demon heaven's dark sparkle attack!", "alice_fc1", 3],
      },
      [9167] => { # 覆滅陰陽撃
        :word_1 => ["\\n<Alice>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "alice_fc1", 3],
      },
      [9173] => { # 天地開闢拳
        :word_1 => ["\\n<Alice>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "alice_fc1", 3],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Alice>Get lost in my skills...!", "alice_fc1", 3],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc1", 3],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc1", 3],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc1", 3],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc1", 3],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Alice>Lifeline, bring back your soul!", "alice_fc1", 3],
      },
      [1451] => { # 裏蘇生
        :word_1 => ["\\n<Alice>Forbidden technique of resurrection...ha!", "alice_fc1", 3],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Alice>Demon vein, stay in your fist!", "alice_fc1", 3],
      },
      [1452] => { # 三魔の拳
        :word_1 => ["\\n<Alice>Breath of the three demons, dwell in my fist!", "alice_fc1", 3],
      },
      [1453] => { # 四精の拳
        :word_1 => ["\\n<Alice>Breath of the four spirits, dwell in my fist!", "alice_fc1", 3],
      },
      [1454] => { # 聖魔の拳
        :word_1 => ["\\n<Alice>Breath of the holy devil, dwell in my fist!", "alice_fc1", 3],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Alice>White magic, bring healing!", "alice_fc1", 3],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Alice>White magic, bring healing!", "alice_fc1", 3],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Alice>Abominable holy light, illuminate the darkness!", "alice_fc1", 3],
      },
      [1471] => { # マヒール
        :word_1 => ["\\n<Alice>The cruel wind of life, scatter into thousands of pieces and crush it! \n Ma Heal!", "alice_fc1", 3],
      },
      [1472] => { # オールマヒール
        :word_1 => ["\\n<Alice>The cruel wind of life, scatter into thousands of pieces and crush it! \n Allma Heal!", "alice_fc1", 3],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Alice>Abominable light, destroy the demon! \n Heaven!", "alice_fc1", 3],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Alice>Abominable light, grant protection!", "alice_fc1", 3],
      },
      [1476] => { # マジック
        :word_1 => ["\\n<Alice>White torrent, become the breath of evil and bring blessings! \nMagic!", "alice_fc1", 3],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Alice>Abominable light, become a wall of protection!", "alice_fc1", 3],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Alice>Abominable light, cancel the blessing!", "alice_fc1", 3],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Black torrent, obey my orders!", "alice_fc1", 3],
      },
      [1496] => { # ファイア
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Angry flame, show your power! \nFire!", "alice_fc1", 3],
      },
      [1497] => { # メガファイア
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The angry flame turns into a whirlpool and mowing it down! \n Mega Fire!", "alice_fc1", 3],
      },
      [1498] => { # ファイアテンペスト
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>A swirl of flames, raging in anger! \n Fire Tempest!", "alice_fc1", 3],
      },
      [1499] => { # ブレイズ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Breath of hellfire, bring a scorching nightmare! \n Blaze!", "alice_fc1", 3],
      },
      [1500] => { # オメガブレイズ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>According to the pact, come, nightmare hellfire! \n Burn it to ashes! Omega Blaze!", "alice_fc1", 3],
      },
      [1501] => { # プロミネンス
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The original red invites infinite regression! \n The scorching heat of the end! Prominence!", "alice_fc1", 3],
      },
      [1502] => { # ブリザード
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Freezing ice, bring the extreme cold! \n Blizzard!", "alice_fc1", 3],
      },
      [1503] => { # メガブリザード
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Freezing ice, bring destruction with a cold storm! \n Mega blizzard!", "alice_fc1", 3],
      },
      [1504] => { # ブリザードストーム
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Cold vortex, show destruction with your endless blade! \n Blizzard Storm!", "alice_fc1", 3],
      },
      [1505] => { # フロスト
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The cold coffin doesn't freeze even the cries of grief! \nFrost!", "alice_fc1", 3],
      },
      [1506] => { # シグマフロスト
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>A torrent of zero, a frozen moment in the blue world... \n Lifeless silence! Sigma Frost!", "alice_fc1", 3],
      },
      [1507] => { # アイスエイジ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The blue root is carved into the Apocalypse pole! \n Zero degree of origin, Ice Age!", "alice_fc1", 3],
      },
      [9194] => { # クァンタゾーン
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Ultra-fine blink of an eye, bring about the destruction of condensation! \n Quanta Zone!", "alice_fc1", 3],
      },
      [9196] => { # イオンブラスト
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Look at the way the floating molecules scatter! \n Ion blast!", "alice_fc1", 3],
      },
      [9206] => { # オーバーカーズ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Cursed Queen, open up taboos! \n Black disaster, OverCurse!", "alice_fc1", 3],
      },
      [1508] => { # サンダー
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Pure thunder, bring judgment! \n Thunder!", "alice_fc1", 3],
      },
      [1509] => { # メガサンダー
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Pure thunder, exorcise evil and rain down on it! \n Mega Thunder!", "alice_fc1", 3],
      },
      [1510] => { # サンダーハリケーン
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Raging thunder, split the sky and roar! \n Thunder Hurricane!", "alice_fc1", 3],
      },
      [1511] => { # スパーク
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Hammer of lightning, defeat evil and reduce it to ashes! \n Spark!", "alice_fc1", 3],
      },
      [1512] => { # ラムダスパーク
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The hammer of judgment, the hell of thunder returned to dust... \n Show me the cause and effect! Lambda Spark!", "alice_fc1", 3],
      },
      [1513] => { # ライトニング
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The original brilliance shows the reincarnation of dust! \n Apocalyptic thunder! Lightning!", "alice_fc1", 3],
      },
      [9205] => { # トリニティ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Play the dance of flame, ice, and thunder! \n Trinity!", "alice_fc1", 3],
      },
      [9192] => { # ガンマバースト
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Bring the afterglow of creation, the scorching heat of the primordial! \n Gamma Burst!", "alice_fc1", 3],
      },
      [9204] => { # カオスリバレート
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The source of ultimate magic... Chaos Revelation!", "alice_fc1", 3],
      },
      [9207] => { # アポカリプス
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Hear the footsteps of the end...Apocalypse!", "alice_fc1", 3],
      },
      [9210] => { # オーバーロード
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>All of my magical power will be poured into me... \n Disappear into dust, Overlord!", "alice_fc1", 3],
      },
      [1530] => { # ドレイン
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Dedicate the wave of life to me! \n Drain!", "alice_fc1", 3],
      },
      [1531] => { # マドレイン
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>A torrent of magic, offer it to me! \n Madeleine!", "alice_fc1", 3],
      },
      [1532] => { # デス
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Death's scythe, which reaps life, invite its soul to the underworld! \n Death!", "alice_fc1", 3],
      },
      [1533] => { # オールデス
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Death's scythe, which reaps life, invite the swarm of souls to the underworld! \n All Death!", "alice_fc1", 3],
      },
      [1534] => { # ポイズン
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Risk the poisonous stream! \n Poison!", "alice_fc1", 3],
      },
      [1535] => { # ブラインド
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Darkness of the night, steal the light! \n Blind!", "alice_fc1", 3],
      },
      [1536] => { # サイレンス
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Refuse magic and bring silence! \n Silence!", "alice_fc1", 3],
      },
      [1537] => { # コンフューズ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>My mind is disturbed by the rolling waves, and I don't even know where the blade is heading! \n Confuse!", "alice_fc1", 3],
      },
      [1538] => { # スリープ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Daydream, a butterfly invites you to close your consciousness! \n Sleep!", "alice_fc1", 3],
      },
      [1539] => { # パラライズ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Numb arms, know that they are not vessels of freedom! \n Paralyze!", "alice_fc1", 3],
      },
      [1541] => { # ヒールタイフーン
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The peaceful wind of life, blow into a storm of blessings! \nHeal Typhoon!", "alice_fc1", 3],
      },
      [1527] => { # カイザーフェニックス
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Be burned by the flames of the phoenix... \n The devil's secret technique is Kaiser Phoenix!", "alice_fc1", 3],
      },
      [1528] => { # フェニックスロンド
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Dance, the Monster Lord's phoenix... \n Dance to the crimson, Phoenix Rondo!", "alice_fc1", 3],
      },
      [1523] => { # カーズ
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The fog of darkness, bring great disaster! Curse!", "alice_fc1", 3],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Alice>It's \n, follow me! Ha!", "alice_fc1", 3],
      },
      [1547] => { # スロウ
        :word_1 => ["\\n<Alice>The muddy stream at \n, slow down your steps and rest in peace! \n Slow!", "alice_fc1", 3],
      },
      [1548] => { # オールスロウ
        :word_1 => ["\\n<Alice>The muddy stream at \n, slow down your steps and rest in peace! \n All slow!", "alice_fc1", 3],
      },
      [1549] => { # クィック
        :word_1 => ["\\n<Alice>The muddy waters of time, quicken your steps and keep your heart beating! \nQuick!", "alice_fc1", 3],
      },
      [1550] => { # オールクィック
        :word_1 => ["\\n<Alice>The muddy waters of time, quicken your steps and keep your heart beating! \n All quick!", "alice_fc1", 3],
      },
      [1551] => { # ストップ
        :word_1 => ["\\n<Alice>Block and stop the truth, Time of Zero! \n Stop!", "alice_fc1", 3],
      },
      [1552] => { # オールストップ
        :word_1 => ["\\n<Alice>Block and stop the truth, Time of Zero! \n All stop!", "alice_fc1", 3],
      },
      [1553] => { # フォシル
        :word_1 => ["\\n<Alice>The muddy waters of time, hurry up and rot away! \n Fossil!", "alice_fc1", 3],
      },
      [1555] => { # リゾーン
        :word_1 => ["\\n<Alice>Gate of time, open, arms of another world! \n Rezone!", "alice_fc1", 3],
      },
      [1557] => { # グラビティ
        :word_1 => ["\\n<Alice>Become the curse of gravity and crush your body! \n Gravidi!", "alice_fc1", 3],
      },
      [1558] => { # ハイグラビティ
        :word_1 => ["\\n<Alice>Let the curse of gravity become a hammer and crush it! \n Hi Gravidi!", "alice_fc1", 3],
      },
      [9226] => { # オーバーグラビディ
        :word_1 => ["\\n<Alice>The curse of gravity, crush both light and darkness! \nThe pinnacle of crushing, Overgravidy!", "alice_fc1", 3],
      },
      [9223] => { # オーバークイック
        :word_1 => ["\\n<Alice>The muddy current of time, carve the ultimate heartbeat! \n Overquick!", "alice_fc1", 3],
      },
      [9222] => { # オーバースロウ
        :word_1 => ["\\n<Alice>Stay in the ultimate calm in the muddy waters of \n! \n Overslow!", "alice_fc1", 3],
      },
      [9224] => { # セカンドアクト
        :word_1 => ["\\n<Alice>The muddy waters of \n, the ultimate protection for your next life! \n Second act!", "alice_fc1", 3],
      },
      [9225] => { # リライフ
        :word_1 => ["\\n<Alice>The muddy waters of time, speed up the heartbeat of life! Relife!", "alice_fc1", 3],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Alice>It's \n, follow me! Ha!", "alice_fc1", 3],
      },
      [1559] => { # コメット
        :word_1 => ["\\n<Alice>The star door is about to open, crush the earth and rain down! \nComet!", "alice_fc1", 3],
      },
      [1560] => { # メテオ
        :word_1 => ["\\n<Alice>The galactic messenger who guides destruction comes from heaven, the hour of disaster! \n Return to the sky! Meteor!", "alice_fc1", 3],
      },
      [1563] => { # アーク
        :word_1 => ["\\n<Alice>Disturbed and crazy, the tide of time... Ark!", "alice_fc1", 3],
      },
      [9227] => { # リピートメテオ
        :word_1 => ["\\n<Alice>Calamity from heaven, overlapping the cycle of time! \nRepeat meteorite, repeat meteorite!", "alice_fc1", 3],
      },
      [9228] => { # コメットレイン
        :word_1 => ["\\n<Alice>The star door is about to open, crush the earth and rain down! \n Comet Rain!", "alice_fc1", 3],
      },
      [9233] => { # オーバーアーク
        :word_1 => ["\\n<Alice>The tide of time is disturbed and comes to an end! \n The flow of destruction, Overark!", "alice_fc1", 3],
      },
      [9230] => { # ギャラクシー
        :word_1 => ["\\n<Alice>Swirling, the breath of a deep galaxy! Galaxy!", "alice_fc1", 3],
      },
      [9234] => { # サンスフィア
        :word_1 => ["\\n<Alice>Burn up the infinite sun! Sunsphere!", "alice_fc1", 3],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Alice>I command you, time, stop!", "alice_fc1", 3],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Alice>Abominable light, illuminate the darkness!", "alice_fc1", 3],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Alice>The warrior's soul breathes life again!", "alice_fc1", 3],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Alice>Angel's dance...!", "alice_fc1", 3],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Alice>....................", "alice_fc1", 3],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Alice>So, you're going crazy with my lewd techniques...!", "alice_fc1", 3],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Alice>Abominable light, bring healing!", "alice_fc1", 3],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Alice>With my remaining life, I will dispel the darkness!", "alice_fc1", 3],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Alice>Roar, the breath of darkness...", "alice_fc1", 3],
      },
      [1674] => { # ダークネス
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Roar, the breath of darkness...Darkness!", "alice_fc1", 3],
      },
      [1675] => { # ダークエターナル
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The black of the end, fill the darkness...Dark Eternal!", "alice_fc1", 3],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Alice>In the hour of darkness, cherry blossoms scatter in the dance of flames... \n Tremble to sleep, Majin Flame Dance!", "alice_fc1", 3],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Alice>In the hour of darkness, being sent and dying is the work of the demon ice... \n Tremble and sleep, the demon ice funeral!", "alice_fc1", 3],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Alice>In the hour of darkness, a voice cries out over the thunder dust... \n Tremble and sleep, demon thunder dust!", "alice_fc1", 3],
      },
      [1679] => { # ダークストリーム
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Come, the tide of darkness... Dark stream!", "alice_fc1", 3],
      },
      [1683] => { # 死んでくれる？
        :word_1 => ["\\n<Alice>I'll have you die...!", "alice_fc1", 3],
      },
      [1684] => { # 魔王の暴虐
        :word_1 => ["\\n<Alice>Experience the power of the Monster Lord for yourself!", "alice_fc1", 3],
      },
      [1690] => { # 終焉の闇
        :word_1 => ["\\n<Alice>Close the darkness of the end...", "alice_fc1", 3],
      },
      [1692] => { # 裁きの炎
        :word_1 => ["\\n<Alice>Burn it down, the flames of judgment...!", "alice_fc1", 3],
      },
      [1694] => { # アンリ・マンユ
        :word_1 => ["\\n<Alice>Henri Mainyu, the hour of darkness has arrived...", "alice_fc1", 3],
      },
      [1693] => { # ビッグクランチ
        :word_1 => ["\\n<Alice>End this world...Big Crunch!", "alice_fc1", 3],
      },
      [9299] => { # ディメント・ナーギ
        :word_1 => ["\\n<Alice>A dream of pleasure shown by the Monster Lord... Demento Nagi!", "alice_fc1", 3],
      },
      [9300] => { # ネフィリム・エンデ
        :word_1 => ["\\n<Alice>Become food for the Monster Lord...Nephilim Ende!", "alice_fc1", 3],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Alice>Magical power, dwell in my blade!", "alice_fc1", 3],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Alice>Deploy the magical protective wall!", "alice_fc1", 3],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Alice>Sign of Yin and Yang, show me the principles of heaven and earth!", "alice_fc1", 3],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Alice>The law of exorcism, the prison of rebellion! \n Realize your retribution, Nine Souls Exorcism Team!", "alice_fc1", 3],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Alice>A lifetime, sending it is life! \n Carving the slightest bit...Singing life!", "alice_fc1", 3],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Alice>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "alice_fc1", 3],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Alice>I got \n!", "alice_fc1", 3],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Alice>This is the proof of a thief!", "alice_fc1", 3],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Alice>Yes, this is Tonzura!", "alice_fc1", 3],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Alice>Take advantage of the ninjutsu!", "alice_fc1", 3],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Alice>Go crazy in agony with Kunoichi's techniques!", "alice_fc1", 3],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Alice>Healing waves, pervade thousands of places... \n Ninja art/healing waves!", "alice_fc1", 3],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Alice>Autumn Utsusemi dances in the shadows... \n Ninja art/Bunshin no Jutsu!", "alice_fc1", 3],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Alice>I had to run away...", "alice_fc1", 3],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Alice>Admire the skills of those who live in the sea...!", "alice_fc1", 3],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Alice>This kind of mood isn't bad either!", "alice_fc1", 3],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Alice>I'm a magical girl, Magical☆Alice!", "alice_fc1", 3],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Alice>Look, this is the power of money!", "alice_fc1", 3],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Alice>Okay, I bought it!", "alice_fc1", 3],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Alice>If it takes more than \n, that's it!", "alice_fc1", 3],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Alice>Look at \n's card handling!", "alice_fc1", 3],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Alice>Should I bet on this coin...", "alice_fc1", 3],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Alice>A dark game played by the Monster Lord...", "alice_fc1", 3],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Alice>Should I try fortune-telling with \n tarot...", "alice_fc1", 3],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Alice>I know it's disgusting, but maybe I should try calling Ilias...", "alice_fc1", 3],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Alice>Should I try spinning the \n slot...", "alice_fc1", 3],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Alice>Come on, let's play poker with me!", "alice_fc1", 3],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Alice>battle card, draw!", "alice_fc1", 3],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Alice>I will show you the power of Trump...!", "alice_fc1", 3],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Alice>The Monster Lord chooses today's happy person...! ?", "alice_fc1", 3],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Alice>It's always my turn!", "alice_fc1", 3],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Alice>What comes out, Item slot!", "alice_fc1", 3],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Alice>Look, look at my dance!", "alice_fc1", 3],
      },
      [2026] => { # 神代の舞
        :word_1 => ["\\n<Alice>Look at the evil deeds... \n Dedicated to the Dark Goddess is the dance of the age of the gods!", "alice_fc1", 3],
      },
      [2043] => { # 破護の舞
        :word_1 => ["\\n<Alice>No protection will be given ♪ Dance of destruction ~ ♪", "alice_fc1", 3],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Alice>That's it! Hustle! Hustle!", "alice_fc2", 0],
      },
      [2061] => { # 蛇神の舞
        :word_1 => ["\\n<Alice>The burning heart is the dance of the snake god...♪", "alice_fc1", 3],
      },
      [2064] => { # 十六夜神楽
        :word_1 => ["\\n<Alice>This body is a dream, Izayoi Kagura...♪", "alice_fc1", 3],
      },
      [2065] => { # 宵月神楽
        :word_1 => ["\\n<Alice>This body is moving, Yozuki Kagura...♪", "alice_fc1", 3],
      },
      [9399] => { # 清めの神舞
        :word_1 => ["\\n<Alice>Exorcise the curse, the divine dance of purification...♪", "alice_fc1", 3],
      },
      [9402] => { # 無限蛇の踊り
        :word_1 => ["\\n<Alice>Not bound by any shackles...♪", "alice_fc1", 3],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Alice>Hey, listen to my song!", "alice_fc1", 3],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Alice>extra sparkle☆", "alice_fc2", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Alice>Why don't you talk to me for a while...", "alice_fc1", 3],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Alice>You're doing quite well, I'll praise you...", "alice_fc1", 1],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Alice>Hmm, I'm disappointed in you...", "alice_fc1", 3],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Alice>Hey, I want money...", "alice_fc1", 3],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Alice>Hey there, I want an item...", "alice_fc1", 3],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Alice>You should work for me over there!", "alice_fc1", 3],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Alice>Do you want to try eating the food I made...?", "alice_fc1", 3],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Alice>Come on, go home!", "alice_fc1", 3],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Alice>At \n, the gift fell down the stairs... Kuku.", "alice_fc1", 1],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Alice>I secretly peeked into Alma Elma's room and found out...!", "alice_fc1", 3],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Alice>I was frightened when I peeked through the gap... \n I saw a woman wearing a fox mask... Brrr!", "alice_fc1", 5],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Alice>Alice is a squirrel.", "alice_fc2", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Alice>Enjoy the power of words!", "alice_fc1", 3],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Alice>This is the power of science!", "alice_fc1", 3],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Alice>Now, let's prepare for the crisis!", "alice_fc1", 3],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Alice>Energy conversion... Ha!", "alice_fc1", 3],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Alice>Let's alchemize \nItem!", "alice_fc1", 3],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Alice>Look at the power of the magic book!", "alice_fc1", 3],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Alice>Turn myself into a page...", "alice_fc1", 3],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Alice>I can also use machines!", "alice_fc1", 3],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Alice>Kukuku...Let me show you my cooking!", "alice_fc1", 3],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Alice>I received the ingredients!", "alice_fc1", 1],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Alice>Look, look at my female skills!", "alice_fc1", 3],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Alice>Now, writhe in agony at my techniques...", "alice_fc1", 3],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Alice>Look, look at my female skills!", "alice_fc1", 3],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Alice>Look, use this medicine...", "alice_fc1", 3],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Alice>Look, I'll give you the injection...", "alice_fc1", 3],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Alice>Let's spread the \n special virus!", "alice_fc1", 3],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Alice>I'm a hard worker! Sora Sora!", "alice_fc1", 3],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Alice>Now, writhe in agony at my techniques...", "alice_fc1", 3],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Alice>Tea has arrived, the devil's tea!", "alice_fc1", 3],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Alice>Maids can transform at will!", "alice_fc1", 3],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Alice>It's almost time to harvest, kukuku...", "alice_fc1", 3],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Alice>See the king's sword skills with your own eyes!", "alice_fc1", 3],
      },
      [2403] => { # 王者の刃
        :word_1 => ["\\n<Alice>Look closely, the blade of the king!", "alice_fc1", 3],
      },
      [2404] => { # 王命剣
        :word_1 => ["\\n<Alice>Carve it into your body... the sword of the king's life!", "alice_fc1", 3],
      },
      [2405] => { # キングスクルセイド
        :word_1 => ["\\n<Alice>Carve the blade of belief... King's Crusade!", "alice_fc1", 3],
      },
      [2406] => { # 覇道皇塵剣
        :word_1 => ["\\n<Alice>This is the supreme king's blow... the supreme supreme sword!", "alice_fc1", 3],
      },
      [9519] => { # 真・覇王聖剣
        :word_1 => ["\\n<Alice>This is the holy sword wielded by the overlord...sigh!", "alice_fc1", 3],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Alice>This is the king's magic!", "alice_fc1", 3],
      },
      [9521] => { # 天臥裂煌
        :word_1 => ["\\n<Alice>Wang Wei, roar in the heavens and earth... Heaven and Earth's sparkle!", "alice_fc1", 3],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Alice>Servants of the Monster Lord, gather here!", "alice_fc1", 3],
      },
      [2413] => { # 王の軍隊
        :word_1 => ["\\n<Alice>Monster Lord's army, gather here!", "alice_fc1", 3],
      },
      [2414] => { # 王国騎士団
        :word_1 => ["\\n<Alice>Knight of the Monster Lord, show your loyalty!", "alice_fc1", 3],
      },
      [9522] => { # 覇王の親衛隊
        :word_1 => ["\\n<Alice>My Imperial Guard, destroy the enemy!", "alice_fc1", 3],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Alice>Ascend to heaven with my sermon!", "alice_fc1", 3],
      },
      [2420] => { # 王の威光
        :word_1 => ["\\n<Alice>Bow down to the majesty of the Monster Lord!", "alice_fc1", 3],
      },
      [2421] => { # 王権神授
        :word_1 => ["\\n<Alice>This is the proof of the Monster Lord!", "alice_fc1", 3],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Alice>Abominable goddess, lend me your power...!", "alice_fc1", 3],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Alice>Hey!!", "alice_fc1", 3],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Alice>I never thought I'd be able to use the hero's techniques...!", "alice_fc1", 3],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Alice>Look, you're going crazy in agony at my lewd techniques!", "alice_fc1", 3],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Alice>Control your sexual desire!", "alice_fc1", 3],
      },
      [2519] => { # ファイアワルツ
        :word_1 => ["\\n<Alice>Dance with the flames! Fire Waltz!", "alice_fc1", 3],
      },
      [2520] => { # フレアロンド
        :word_1 => ["\\n<Alice>Dance in the hellfire of reincarnation! Flare Rond!", "alice_fc1", 3],
      },
      [2521] => { # バーンレクイエム
        :word_1 => ["\\n<Alice>Invite me to the underworld, funeral flames! Burn Requiem!", "alice_fc1", 3],
      },
      [2522] => { # アークオベリスク
        :word_1 => ["\\n<Alice>Ancient flame, dance at the feast! Ark obelisk!", "alice_fc1", 3],
      },
      [2523] => { # 太古の炎
        :word_1 => ["\\n<Alice>The ancient hellfire that devours this world...!", "alice_fc1", 3],
      },
      [2524] => { # 魔界の煉獄
        :word_1 => ["\\n<Alice>Purgatory in the demon world, burn down this world...!", "alice_fc1", 3],
      },
      [9537] => { # 倶利伽羅の黒龍
        :word_1 => ["\\n<Alice>Black dragon, burn this world to the ground!", "alice_fc1", 3],
      },
      [9538] => { # 黄泉の狂氷
        :word_1 => ["\\n<Alice>Come from the underworld, the eternal mad ice!", "alice_fc1", 3],
      },
      [2530] => { # 魔雷
        :word_1 => ["\\n<Alice>Cry into the distorted night! Magic thunder!", "alice_fc1", 3],
      },
      [2531] => { # 黒雷
        :word_1 => ["\\n<Alice>Even the echoing screams turn to dust! Black lightning!", "alice_fc1", 3],
      },
      [9539] => { # 夢塵夜
        :word_1 => ["\\n<Alice>I can't even hear the grudge, the dream night...!", "alice_fc1", 3],
      },
      [2535] => { # サンスフィア
        :word_1 => ["\\n<Alice>Dazzling light, illuminate the darkness! Sunsphere!", "alice_fc1", 3],
      },
      [2536] => { # エヴァゲリオ
        :word_1 => ["\\n<Alice>Come, the gospel, show us the judgment! Evagelio!", "alice_fc1", 3],
      },
      [9540] => { # 白蛇神光
        :word_1 => ["\\n<Alice>Inviting the holy light...White snake divine light!", "alice_fc1", 3],
      },
      [9541] => { # 楽園の光
        :word_1 => ["\\n<Alice>This is the light that once illuminated paradise...", "alice_fc1", 3],
      },
      [2546] => { # 毒の魔眼
        :word_1 => ["\\n<Alice>Cover yourself with poison...Evil Eye!", "alice_fc1", 3],
      },
      [2547] => { # 暗闇の魔眼
        :word_1 => ["\\n<Alice>Closing your field of vision in darkness... the evil eye!", "alice_fc1", 3],
      },
      [2548] => { # 沈黙の魔眼
        :word_1 => ["\\n<Alice>Shut your noisy mouth...Evil Eye!", "alice_fc1", 3],
      },
      [2549] => { # 混乱の魔眼
        :word_1 => ["\\n<Alice>Be misled and crazy...Evil Eye!", "alice_fc1", 3],
      },
      [2550] => { # 睡眠の魔眼
        :word_1 => ["\\n<Alice>Fall into a distorted dream...Evil Eye!", "alice_fc1", 3],
      },
      [2551] => { # 麻痺の魔眼
        :word_1 => ["\\n<Alice>Take away your freedom...the evil eye!", "alice_fc1", 3],
      },
      [2555] => { # 暴走の魔眼
        :word_1 => ["\\n<Alice>Lose your reason and go mad with rage...Evil Eye!", "alice_fc1", 3],
      },
      [2556] => { # 石化の魔眼
        :word_1 => ["\\n<Alice>Become a silent stone...Evil Eye!", "alice_fc1", 3],
      },
      [2557] => { # 即死の魔眼
        :word_1 => ["\\n<Alice>Become a cold skeleton... Demon eyes!", "alice_fc1", 3],
      },
      [9542] => { # 最後の魔眼
        :word_1 => ["\\n<Alice>Taste hell with the final evil eye...", "alice_fc1", 3],
      },
      [2558] => { # 王者の魔眼
        :word_1 => ["\\n<Alice>This is the evil eye of the king...", "alice_fc1", 3],
      },
      [2559] => { # 蛇神の魔眼
        :word_1 => ["\\n<Alice>The power of the snake god...the evil eye!", "alice_fc1", 3],
      },
      [9545] => { # エキドナの魔眼
        :word_1 => ["\\n<Alice>The power that corrupted and degraded paradise...", "alice_fc1", 3],
      },
      [9547] => { # 邪神の魔眼
        :word_1 => ["\\n<Alice>With my evil eye, I will return everything to darkness...!", "alice_fc1", 3],
      },
      [2561] => { # 誘惑の魔眼
        :word_1 => ["\\n<Alice>That heart is filled with lust... the evil eye!", "alice_fc1", 3],
      },
      [2564] => { # 浄化の魔眼
        :word_1 => ["\\n<Alice>The defiled, return to heaven...the evil eye!", "alice_fc1", 3],
      },
      [2565] => { # 回復の魔眼
        :word_1 => ["\\n<Alice>Give healing to your injured body...the evil eye!", "alice_fc1", 3],
      },
      [2566] => { # 全快の魔眼
        :word_1 => ["\\n<Alice>Blessings to those who are cornered...Evil Eye!", "alice_fc1", 3],
      },
      [2567] => { # 治癒の魔眼
        :word_1 => ["\\n<Alice>Give healing to a disturbed body...the evil eye!", "alice_fc1", 3],
      },
      [2568] => { # 復活の魔眼
        :word_1 => ["\\n<Alice>Return the soul to the lifeless body...the evil eye!", "alice_fc1", 3],
      },
      [2602] => { # 水撃
        :word_1 => ["\\n<Alice>Eat it, water bullet!", "alice_fc1", 3],
      },
      [2603] => { # 大海嘯
        :word_1 => ["\\n<Alice>Push it away...a great wave!", "alice_fc1", 3],
      },
      [2605] => { # 潮吹き
        :word_1 => ["\\n<Alice>Get down, the raging tide!", "alice_fc1", 3],
      },
      [2606] => { # ノーチラス
        :word_1 => ["\\n<Alice>Crush the fangs of the deep sea... crush them in one breath!", "alice_fc1", 3],
      },
      [2612] => { # 水中放電
        :word_1 => ["\\n<Alice>Electric discharge from within the body... numb!", "alice_fc1", 3],
      },
      [2613] => { # 海神の電
        :word_1 => ["\\n<Alice>Sea God's thunder, receive merciless judgment!", "alice_fc1", 3],
      },
      [2619] => { # 深淵に引きずり込む者
        :word_1 => ["\\n<Alice>Let me show you the depths of the deep sea...", "alice_fc1", 3],
      },
      [2620] => { # 深海の供物
        :word_1 => ["\\n<Alice>I'll sacrifice myself...", "alice_fc1", 3],
      },
      [2624] => { # あわあわ
        :word_1 => ["\\n<Alice>Look, I'm covered in bubbles and writhing in agony!", "alice_fc1", 3],
      },
      [2625] => { # メルティウォッシュ
        :word_1 => ["\\n<Alice>Look, look...I'll wash the rest soon!", "alice_fc1", 3],
      },
      [9560] => { # 究極あわあわ地獄
        :word_1 => ["\\n<Alice>Ascend to heaven with pleasure, the ultimate frothy hell!", "alice_fc1", 3],
      },
      [2643] => { # 恍惚粘液
        :word_1 => ["\\n<Alice>Immerse yourself in ecstasy with this mucus...", "alice_fc1", 3],
      },
      [2644] => { # 失禁粘液
        :word_1 => ["\\n<Alice>This mucus will help you digest...", "alice_fc1", 3],
      },
      [2646] => { # 消化粘液
        :word_1 => ["\\n<Alice>Let this mucus melt your body and soul...", "alice_fc1", 3],
      },
      [2647] => { # 消化粘液の渦
        :word_1 => ["\\n<Alice>Drown in the whirlpool of digestive mucus...", "alice_fc1", 3],
      },
      [2651] => { # ネバネバ粘液地獄
        :word_1 => ["\\n<Alice>Come on, soak in the mucus hell...!", "alice_fc1", 3],
      },
      [2652] => { # ドロドロ粘液天国
        :word_1 => ["\\n<Alice>Soak yourself in slime and ascend to heaven...", "alice_fc1", 3],
      },
      [2653] => { # 快楽昇天ドロドロジェル
        :word_1 => ["\\n<Alice>Melt in pleasure...!", "alice_fc1", 3],
      },
      [9569] => { # 次元侵蝕粘液
        :word_1 => ["\\n<Alice>Erode, the slime that invades dimensions...!", "alice_fc1", 3],
      },
      [2678] => { # 引っ掻き
        :word_1 => ["\\n<Alice>Eat my nails!", "alice_fc1", 3],
      },
      [2679] => { # 一撃の爪
        :word_1 => ["\\n<Alice>Reap that life with these claws!", "alice_fc1", 3],
      },
      [2680] => { # 咬爪乱撃
        :word_1 => ["\\n<Alice>Tear it apart and eat it!", "alice_fc1", 3],
      },
      [2681] => { # 電塵爪
        :word_1 => ["\\n<Alice>Claws, hold electrical dust...!", "alice_fc1", 3],
      },
      [2682] => { # 乱れ電塵爪
        :word_1 => ["\\n<Alice>Disturb, electric dust claw!", "alice_fc1", 3],
      },
      [2683] => { # グリフィススクラッチ
        :word_1 => ["\\n<Alice>Burn the Crimson Claw!", "alice_fc1", 3],
      },
      [2684] => { # プラズマランページ
        :word_1 => ["\\n<Alice>Electric dust claws leave no dust behind!", "alice_fc1", 3],
      },
      [2685] => { # 死舞爪
        :word_1 => ["\\n<Alice>Dance in pitch black, the claws of the underworld...!", "alice_fc1", 3],
      },
      [2685] => { # 死舞爪
        :word_1 => ["\\n<Alice>Dance in pitch black, the claws of the underworld...!", "alice_fc1", 3],
      },
      [9578] => { # 白天滅牙
        :word_1 => ["\\n<Alice>Pierce the heavens, the fangs of destruction...!", "alice_fc1", 3],
      },
      [9581] => { # 核熱獣乱牙
        :word_1 => ["\\n<Alice>Raging, fangs of nuclear heat!", "alice_fc1", 3],
      },
      [9582] => { # 超魔核熱獣撃
        :word_1 => ["\\n<Alice>The evil beast of nuclear fever will destroy this world!", "alice_fc1", 3],
      },
      [2700] => { # 啼魔咆吼
        :word_1 => ["\\n<Alice>Ohhhh...!!", "alice_fc1", 3],
      },
      [2686] => { # 噛み付き
        :word_1 => ["\\n<Alice>I'll tear you apart with my fangs!", "alice_fc1", 3],
      },
      [2687] => { # 連続噛み付き
        :word_1 => ["\\n<Alice>Shatter with my fangs!", "alice_fc1", 3],
      },
      [2688] => { # 轟連牙
        :word_1 => ["\\n<Alice>Eat it, the fangs of nightmare that will crush everything!", "alice_fc1", 3],
      },
      [2693] => { # 虚牙
        :word_1 => ["\\n<Alice>The fang of nothingness that pierces all things!", "alice_fc1", 3],
      },
      [2691] => { # 絶氷牙
        :word_1 => ["\\n<Alice>My fangs, hold the ice...!", "alice_fc1", 3],
      },
      [2692] => { # 断氷連牙
        :word_1 => ["\\n<Alice>Tear apart, the merciless fangs of ice!", "alice_fc1", 3],
      },
      [9577] => { # 破壊の爪
        :word_1 => ["\\n<Alice>The height of beastliness...claws of destruction!", "alice_fc1", 3],
      },
      [2694] => { # 体当たり
        :word_1 => ["\\n<Alice>hit...haaaa!", "alice_fc1", 3],
      },
      [2695] => { # 大暴れ
        :word_1 => ["\\n<Alice>Defeat all \n!", "alice_fc1", 3],
      },
      [2696] => { # 蹂躙撃
        :word_1 => ["\\n<Alice>He's going to trample me...haaaaaaaaaaaa!", "alice_fc1", 3],
      },
      [2697] => { # 威嚇
        :word_1 => ["\\n<Alice>Hold back \n...!", "alice_fc1", 3],
      },
      [2698] => { # おたけび
        :word_1 => ["\\n<Alice>Ohhhhh...!!", "alice_fc1", 3],
      },
      [2699] => { # 破壊の咆吼
        :word_1 => ["\\n<Alice>Ohhhhh...!!", "alice_fc1", 3],
      },
      [2701] => { # 獣魔合乱撃
        :word_1 => ["\\n<Alice>I will crush you...!　Oh!!", "alice_fc1", 3],
      },
      [2702] => { # 獣魔乱舞
        :word_1 => ["\\n<Alice>Wield the fierce beast to its fullest!", "alice_fc1", 3],
      },
      [2703] => { # 同種殺し
        :word_1 => ["\\n<Alice>Beast, know the power of the Monster Lord...!", "alice_fc1", 3],
      },
      [2712] => { # ベノムアタック
        :word_1 => ["\\n<Alice>Poisonous claws... Ha!", "alice_fc1", 3],
      },
      [2713] => { # ベノンザッパー
        :word_1 => ["\\n<Alice>Experience the poisonous attack for yourself!", "alice_fc1", 3],
      },
      [2715] => { # ベノムグランテ
        :word_1 => ["\\n<Alice>Carve \n, the ultimate poisonous claw!", "alice_fc1", 3],
      },
      [9579] => { # 百魔乱舞
        :word_1 => ["\\n<Alice>Runaway! Bakusou!　Haaaaa!!", "alice_fc1", 3],
      },
      [9580] => { # 空間蹂躙
        :word_1 => ["\\n<Alice>The entire space has been overrun...!", "alice_fc1", 3],
      },
      [2714] => { # ベノムバウンド
        :word_1 => ["\\n<Alice>Mow down, a flash of deadly poison!", "alice_fc1", 3],
      },
      [2716] => { # 尻尾コキ
        :word_1 => ["\\n<Alice>Look, enjoy the pleasure with your tail...!", "alice_fc1", 3],
      },
      [2717] => { # 獣の口淫
        :word_1 => ["\\n<Alice>Come on, taste my oral skills...!", "alice_fc1", 3],
      },
      [2718] => { # ワイルドレイプ
        :word_1 => ["\\n<Alice>I'll rape you like a beast...!", "alice_fc1", 3],
      },
      [2722] => { # ぷにぷに肉球手コキ
        :word_1 => ["\\n<Alice>More squishy paws...♪", "alice_fc2", 0],
      },
      [2723] => { # ざらざら猫舌フェラ
        :word_1 => ["\\n<Alice>A rough tongue must be very irritating...", "alice_fc1", 3],
      },
      [2726] => { # ビーストハウリング
        :word_1 => ["\\n<Alice>Can you see through this behavior?", "alice_fc1", 3],
      },
      [2727] => { # 獣の本能
        :word_1 => ["\\n<Alice>I can't stop myself anymore...!", "alice_fc1", 3],
      },
      [2728] => { # ルナティックハイ
        :word_1 => ["\\n<Alice>Exciting instincts destroy everything...!", "alice_fc1", 3],
      },
      [2729] => { # ジェノサイドハイ
        :word_1 => ["\\n<Alice>Bloody impulse destroys everything...", "alice_fc1", 3],
      },
      [2732] => { # ねこまねき
        :word_1 => ["\\n<Alice>Meow, meow♪", "alice_fc2", 0],
      },
      [2733] => { # ぐっすりにゃんこ
        :word_1 => ["\\n<Alice>I'm going to sleep for a little while...", "alice_fc1", 3],
      },
      [2734] => { # 凍てつく波動
        :word_1 => ["\\n<Alice>That power will erase everything...!", "alice_fc1", 3],
      },
      [2740] => { # 蛇撃
        :word_1 => ["\\n<Alice>Eat it, tail blow!", "alice_fc1", 3],
      },
      [2741] => { # 蛇体薙ぎ
        :word_1 => ["\\n<Alice>mowing down everything with the tail!", "alice_fc1", 3],
      },
      [2742] => { # スネークパニッシャー
        :word_1 => ["\\n<Alice>Let me punish you with my snake body!", "alice_fc1", 3],
      },
      [2743] => { # 蛇王滅誅
        :word_1 => ["\\n<Alice>Shatter into pieces!", "alice_fc1", 3],
      },
      [2744] => { # ラミアロール
        :word_1 => ["\\n<Alice>Look, let's wrap it around us...!", "alice_fc1", 3],
      },
      [2745] => { # ヘビィロール
        :word_1 => ["\\n<Alice>I'll just roll it up like this... Kuku.", "alice_fc1", 3],
      },
      [2746] => { # 悪夢の締め付け
        :word_1 => ["\\n<Alice>Let's squeeze it tight...", "alice_fc1", 3],
      },
      [2747] => { # クィーンズロール
        :word_1 => ["\\n<Alice>Enjoy the Queen's embrace...", "alice_fc1", 3],
      },
      [9591] => { # ミドガルズオルム
        :word_1 => ["\\n<Alice>A great embrace, Midgardsorm...!", "alice_fc1", 3],
      },
      [2748] => { # 丸呑み
        :word_1 => ["\\n<Alice>Look, I'll swallow you whole...", "alice_fc1", 3],
      },
      [2749] => { # 悪夢の踊り食い
        :word_1 => ["\\n<Alice>Be swallowed alive and experience a nightmare...!", "alice_fc1", 3],
      },
      [2750] => { # クィーンズボア
        :word_1 => ["\\n<Alice>Become food for the Queen...", "alice_fc1", 3],
      },
      [9592] => { # ヨルムンガンド
        :word_1 => ["\\n<Alice>Jormungandr devours everything...!", "alice_fc1", 3],
      },
      [2751] => { # 石化撃
        :word_1 => ["\\n<Alice>Turn into stone with this blow...!", "alice_fc1", 3],
      },
      [2752] => { # 石化乱撃
        :word_1 => ["\\n<Alice>It's a petrifying attack...!", "alice_fc1", 3],
      },
      [2755] => { # 蛇尾コキ
        :word_1 => ["\\n<Alice>Look, enjoy the pleasure with your tail...!", "alice_fc1", 3],
      },
      [2756] => { # チロチロフェラ
        :word_1 => ["\\n<Alice>I want you to writhe in agony with this tongue...!", "alice_fc1", 3],
      },
      [2757] => { # ラミアの魔膣
        :word_1 => ["\\n<Alice>Taste my magical vagina...!", "alice_fc1", 3],
      },
      [2758] => { # 聖母蛇の抱擁
        :word_1 => ["\\n<Alice>Come on, I'll hold you gently...", "alice_fc1", 3],
      },
      [2759] => { # 昇天の抱擁
        :word_1 => ["\\n<Alice>Let's end this with your hugs...", "alice_fc1", 3],
      },
      [2760] => { # 稚児搾り
        :word_1 => ["\\n<Alice>Damn, I'll squeeze it gently...", "alice_fc1", 3],
      },
      [2761] => { # 夜叉淫舌
        :word_1 => ["\\n<Alice>I want you to writhe in agony with this tongue...!", "alice_fc1", 3],
      },
      [2762] => { # 包み乳楽
        :word_1 => ["\\n<Alice>Surround yourself with more breasts and immerse yourself in bliss...", "alice_fc1", 3],
      },
      [2763] => { # 蛇夜伽
        :word_1 => ["\\n<Alice>Writhe in agony at the serpent night...!", "alice_fc1", 3],
      },
      [2764] => { # 淫邪の蛇髪
        :word_1 => ["\\n<Alice>I'll devour you with my hair...", "alice_fc1", 3],
      },
      [2765] => { # 淫蛇の蜜壺
        :word_1 => ["\\n<Alice>There's a snake writhing in my meat pot too...", "alice_fc1", 3],
      },
      [2766] => { # 楽園蛇の誘惑
        :word_1 => ["\\n<Alice>The primordial snake, an invitation to corruption...", "alice_fc1", 3],
      },
      [2767] => { # ラミアの祈り
        :word_1 => ["\\n<Alice>My prayers bring healing...!", "alice_fc1", 3],
      },
      [2768] => { # ラミアの寵光
        :word_1 => ["\\n<Alice>Dark Goddess, give me a miracle...!", "alice_fc1", 3],
      },
      [2769] => { # 脱皮
        :word_1 => ["\\n<Alice>Look the other way and let me shed my skin!", "alice_fc1", 3],
      },
      [2775] => { # 触手撃
        :word_1 => ["\\n<Alice>Take a blow from the \n tentacle!", "alice_fc1", 3],
      },
      [2776] => { # 触手乱舞
        :word_1 => ["\\n<Alice>Disturb, my tentacles!", "alice_fc1", 3],
      },
      [2777] => { # テンタクルストーム
        :word_1 => ["\\n<Alice>Eat, a storm of tentacles!", "alice_fc1", 3],
      },
      [2778] => { # 剛触手撃
        :word_1 => ["\\n<Alice>I'll crush you with my tentacles!", "alice_fc1", 3],
      },
      [2779] => { # 乱打触手舞
        :word_1 => ["\\n<Alice>Knock it down with a disordered tentacle!", "alice_fc1", 3],
      },
      [2780] => { # テンタクルレイド
        :word_1 => ["\\n<Alice>mowing down with more tentacles!", "alice_fc1", 3],
      },
      [2781] => { # テンタクルブラスト
        :word_1 => ["\\n<Alice>A blow from the tentacle, it shatters into fine dust!", "alice_fc1", 3],
      },
      [2782] => { # ナノテンタクル
        :word_1 => ["\\n<Alice>Destroy everything with microscopic tentacles...!", "alice_fc1", 3],
      },
      [9596,9604] => { # デミウルゴス
        :word_1 => ["\\n<Alice>Release all tentacles...Release them!", "alice_fc1", 3],
      },
      [2783] => { # 触手拘束
        :word_1 => ["\\n<Alice>Look, let's wind it up with our tentacles!", "alice_fc1", 3],
      },
      [2784] => { # テンタクルバインド
        :word_1 => ["\\n<Alice>Damn, it's wrapped around me with my tentacles!", "alice_fc1", 3],
      },
      [2785] => { # インフェルノバインド
        :word_1 => ["\\n<Alice>Get wrapped up in more tentacles and experience hell...!", "alice_fc1", 3],
      },
      [2786] => { # 蛇縊り
        :word_1 => ["\\n<Alice>This is a tentacle that hangs onto a snake...!", "alice_fc1", 3],
      },
      [2787] => { # ラミアキャプチャー
        :word_1 => ["\\n<Alice>With these tentacles, I will destroy the snake...!", "alice_fc1", 3],
      },
      [2788] => { # 触手愛撫
        :word_1 => ["\\n<Alice>Writhe in pleasure with more tentacles...!", "alice_fc1", 3],
      },
      [2789] => { # 乱れ触手愛撫
        :word_1 => ["\\n<Alice>You tentacles, stop being disturbed!", "alice_fc1", 3],
      },
      [2790] => { # テンタクルワルツ
        :word_1 => ["\\n<Alice>Writhe in agony with the pleasure of the tentacles...!", "alice_fc1", 3],
      },
      [2810] => { # 麻痺触手
        :word_1 => ["\\n<Alice>Get paralyzed by these tentacles!", "alice_fc1", 3],
      },
      [2811] => { # 猛毒触手
        :word_1 => ["\\n<Alice>Get poisoned by this tentacle!", "alice_fc1", 3],
      },
      [2812] => { # 催淫触手
        :word_1 => ["\\n<Alice>Drown in your lust with these tentacles!", "alice_fc1", 3],
      },
      [2813] => { # 即死の触手
        :word_1 => ["\\n<Alice>With these tentacles, you should die in the afterlife!", "alice_fc1", 3],
      },
      [2814] => { # 失禁の触手
        :word_1 => ["\\n<Alice>Don't let this tentacle incontinence you miserably!", "alice_fc1", 3],
      },
      [2815] => { # スミ
        :word_1 => ["\\n<Alice>I'm not an octopus!", "alice_fc1", 3],
      },
      [2816] => { # 闇霧
        :word_1 => ["\\n<Alice>Mist of darkness, close your surroundings!", "alice_fc1", 3],
      },
      [2817] => { # ナイトメアミスト
        :word_1 => ["\\n<Alice>Nightmare fog, bring true darkness!", "alice_fc1", 3],
      },
      [2818] => { # バイオミスト
        :word_1 => ["\\n<Alice>Poisonous fog, close your surroundings!", "alice_fc1", 3],
      },
      [2820] => { # テンタクルアップ
        :word_1 => ["\\n<Alice>Activate the tentacles...!", "alice_fc1", 3],
      },
      [2821] => { # テンタクルハイアップ
        :word_1 => ["\\n<Alice>The tentacles will be further activated...!", "alice_fc1", 3],
      },
      [2822] => { # テンタクルエクスアップ
        :word_1 => ["\\n<Alice>Look, the ultimate tentacle activation!", "alice_fc1", 3],
      },
      [3068] => { # 火の息
        :word_1 => ["\\n<Alice>Get a breath of fire!", "alice_fc1", 3],
      },
      [3070] => { # 激しい炎
        :word_1 => ["\\n<Alice>Get the flame breath!", "alice_fc1", 3],
      },
      [3081] => { # バイオブレス
        :word_1 => ["\\n<Alice>Writhe in agony with the poisonous breath!", "alice_fc1", 3],
      },
      [9697] => { # マグナ・ノヴァ
        :word_1 => ["\\n<Alice>Breath of the Earth... Magna Nova!", "alice_fc1", 3],
      },
      [9696] => { # ガイアブレス
        :word_1 => ["\\n<Alice>The breath of the earth...Gaia's breath!", "alice_fc1", 3],
      },
      [9698] => { # アークブレス
        :word_1 => ["\\n<Alice>Condensed deadly poison...Arc breath!", "alice_fc1", 3],
      },
      [9701] => { # 次元侵蝕ブレス
        :word_1 => ["\\n<Alice>A breath that invades the dimension...!", "alice_fc1", 3],
      },
      [3085] => { # 毒の息
        :word_1 => ["\\n<Alice>Take the poison breath!", "alice_fc1", 3],
      },
      [3086] => { # 甘い息
        :word_1 => ["\\n<Alice>The sweet aroma will lull you to sleep!", "alice_fc1", 3],
      },
      [3087] => { # 焼け付く息
        :word_1 => ["\\n<Alice>Feel numb from the burning breath!", "alice_fc1", 3],
      },
      [3088] => { # 臭い息
        :word_1 => ["\\n<Alice>Struggles and suffers, nightmare breath...", "alice_fc1", 3],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Alice>Let's go, haa...!", "alice_fc1", 3],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Alice>Gather your power...!", "alice_fc1", 3],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Alice>Gather up your spirit...!", "alice_fc1", 3],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Alice>I'll show you my best...!", "alice_fc1", 3],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Alice>Let me show you the final secret technique...!", "alice_fc1", 3],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Alice>Concentrate on my fist...!", "alice_fc1", 3],
      },
      [3100] => { # 裏練気
        :word_1 => ["\\n<Alice>The strength behind it dwells in your fist...!", "alice_fc1", 3],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Alice>My body, harden it like steel!", "alice_fc1", 3],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Alice>The ultimate in concentration, the final effort...!", "alice_fc1", 3],
      },
      [3103] => { # 魔力集中
        :word_1 => ["\\n<Alice>Concentrate your magical power...!", "alice_fc1", 3],
      },
      [9777] => { # ソフィスティケイト
        :word_1 => ["\\n<Alice>Concentrate on one point...Sophisticate!", "alice_fc1", 3],
      },
      [6183] => { # 邪神炎極ノ纏
        :word_1 => ["\\n<Alice>It will burn you down... The ultimate robe of evil divine flame!", "alice_fc1", 3],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Alice>Take a deep breath, huh...", "alice_fc1", 3],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Alice>This is the time for first aid!", "alice_fc1", 3],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Alice>Backwaters are the path to victory!", "alice_fc1", 3],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Alice>From now on, I'm going to go crazy...!", "alice_fc1", 3],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Alice>Let's go... Transform!", "alice_fc1", 3],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Alice>Henshin! Magical☆Alice♪", "alice_fc2", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Alice>Hey, quiet down!", "alice_fc1", 3],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Alice>Reinforcements, gather around me!", "alice_fc1", 3],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Alice>That power will be shattered!", "alice_fc1", 3],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Alice>Spout, geyser!", "alice_fc1", 3],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Alice>Don't move an inch!", "alice_fc1", 3],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Alice>I got it!", "alice_fc1", 3],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Alice>Ufun♪ Sexy beam!", "alice_fc2", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Alice>Ugh♪ Pink Typhoon!", "alice_fc2", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Alice>Ugh♪ Fantastic Hurricane!", "alice_fc2", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Alice>Now, it's my stage!", "alice_fc1", 1],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Alice>I can't accept that more people are working!", "alice_fc1", 3],
      },
      [3161] => { # アビスドレイン
        :word_1 => ["\\n<Alice>It will squeeze out all your spirit...", "alice_fc1", 3],
      },
      [3163] => { # スラッグドレイン
        :word_1 => ["\\n<Alice>It sucks out a lot of your semen...!", "alice_fc1", 3],
      },
      [3164] => { # スラッグボア
        :word_1 => ["\\n<Alice>'s body will melt you...!", "alice_fc1", 3],
      },
      [3166] => { # 毒舌ナメナメ
        :word_1 => ["\\n<Alice>I'll lick you with my poisonous tongue...", "alice_fc1", 3],
      },
      [3167] => { # 軟体ボディ
        :word_1 => ["\\n<Alice>This body will become soft...!", "alice_fc1", 3],
      },
      [3168] => { # 粘液大量分泌
        :word_1 => ["\\n<Alice>This mucus will nullify all impacts...", "alice_fc1", 3],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Alice>Drown in my plump breasts... \n Puff, puff, puff...", "alice_fc1", 1],
      },
      [3555] => { # 誘惑専用
        :word_y1 => ["\\n<Alice>Hmm... this is mine... \n Roll it, roll it...", "alice_fc1", 3],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Alice>Now, show your strength...!", "alice_fc1", 3],
      },
      [9238] => { # うさぎコメット
        :word_1 => ["\\n<Alice>Come, Rabbit's Great Meteorite!", "alice_fc1", 3],
      },
      [1568] => { # アリスインワンダーランド
        :word_1 => ["\\n<Alice>Wonderland...Alice in Wonderland!", "alice_fc1", 3],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Alice>This is the power of grudge...!", "alice_fc1", 3],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Alice>...Blitzkrieg!!", "alice_fc1", 3],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Alice>Prevent evil attacks... Brave Wall!", "alice_fc1", 3],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Alice>I forgive you...", "alice_fc1", 3],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Alice>Look at the miracle of the Holy Grail!", "alice_fc1", 3],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Alice>Look at the power of the aura!", "alice_fc1", 3],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Alice>With the extra power, this is easy!", "alice_fc1", 3],
      },
      [6079] => { # 紅の印
        :word_1 => ["\\n<Alice>The red seal is engraved on your body...!", "alice_fc1", 3],
      },
      [6181] => { # エンドオブドリーム
        :word_1 => ["\\n<Alice>It's good to know the end of the dream...!", "alice_fc1", 3],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Alice>Ha!", "alice_fc1", 3],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Alice>I'll protect you!", "alice_fc1", 3],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Alice>Now, go to the Monster Lord... Assemble!!", "alice_fc1", 3],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Alice>Double up!", "alice_fc1", 3],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Alice>Next action, order!", "alice_fc1", 3],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Alice>The power of elementals...!", "alice_fc1", 3],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Alice>Concentrate your power on one point...!", "alice_fc1", 3],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Alice>■■■■■■■■■■■■■■■...", "alice_fc1", 3],
      },
      [4327,3488] => { # プレジャードレイン
        :word_1 => ["\\n<Alice>Let me taste your essence...", "alice_fc1", 3],
        :word_2 => ["\\n<Alice>Will I end up having my penis sucked like this...?", "alice_fc1", 3],
        :word_3 => ["\\n<Alice>If I drown in this pleasure, I won't be able to win...", "alice_fc1", 3],
      },
      [4328] => { # サタニックプレジャー
        :word_1 => ["\\n<Alice>Let's tighten it gradually...", "alice_fc1", 3],
        :word_2 => ["\\n<Alice>It must be painful...?", "alice_fc1", 3],
        :word_3 => ["\\n<Alice>Would you rather die while being squeezed...?", "alice_fc1", 3],
      },
      [4329] => { # サタニックプレジャー
        :word_1 => ["\\n<Alice>Let's tighten it gradually...", "alice_fc1", 3],
        :word_2 => ["\\n<Alice>It must be painful...?", "alice_fc1", 3],
        :word_3 => ["\\n<Alice>Would you rather die while being squeezed...?", "alice_fc1", 3],
      },
    },
    7 => { # アリス
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Alice>Hyaah!", "alice_fc7", 3],
        :word_2 => ["\\n<Alice>Huh!", "alice_fc7", 3],
        :word_3 => ["\\n<Alice>Hey!", "alice_fc7", 3],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Alice>Look at \n's knife skills! Ha!", "alice_fc7", 3],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Alice>Take advantage of \n's sword skills!", "alice_fc7", 3],
      },
      [917] => { # 切り返し
        :word_1 => ["\\n<Alice>I cut back...haa!", "alice_fc7", 3],
      },
      [918] => { # 疾風突き
        :word_1 => ["\\n<Alice>Like the wind... Gale thrust!", "alice_fc7", 3],
      },
      [919] => { # 払車剣
        :word_1 => ["\\n<Alice>The sword flashes, like a wheel...Kurakushaken!", "alice_fc7", 3],
      },
      [920] => { # 諸刃斬り
        :word_1 => ["\\n<Alice>Receive my determination! A double-edged sword!", "alice_fc7", 3],
      },
      [921] => { # 隼斬り
        :word_1 => ["\\n<Alice>blade, dance like a falcon! Ha!", "alice_fc7", 3],
      },
      [922] => { # 火炎斬り
        :word_1 => ["\\n<Alice>Take shelter, flame... Ha!", "alice_fc7", 3],
      },
      [923] => { # 氷斬り
        :word_1 => ["\\n<Alice>Take shelter, ice... Ha!", "alice_fc7", 3],
      },
      [924] => { # 稲妻斬り
        :word_1 => ["\\n<Alice>Take shelter, lightning... Ha!", "alice_fc7", 3],
      },
      [931] => { # 真空斬り
        :word_1 => ["\\n<Alice>It's a vacuum blade...!", "alice_fc7", 3],
      },
      [932] => { # 烈風剣
        :word_1 => ["\\n<Alice>Dance, blade of fierce wind! Ha!!", "alice_fc7", 3],
      },
      [933] => { # 月影の太刀
        :word_1 => ["\\n<Alice>Dance in the moon...Shura's sword!", "alice_fc7", 3],
      },
      [934] => { # 魔神斬り
        :word_1 => ["\\n<Alice>The devil's blow... Ha!!", "alice_fc7", 3],
      },
      [935] => { # デッドクラッシュ
        :word_1 => ["\\n<Alice>Shatter with the blade of destruction! Dead crush!", "alice_fc7", 3],
      },
      [936] => { # 二刀十字斬り
        :word_1 => ["\\n<Alice>Behold the flash of the two swords! Two-sword cross slash!", "alice_fc7", 3],
      },
      [942] => { # フレイムスラッシュ
        :word_1 => ["\\n<Alice>Burn it down, a flash of red... \n Flame Slash!", "alice_fc7", 3],
      },
      [943] => { # アイススラッシュ
        :word_1 => ["\\n<Alice>Freezing, a flash of blue... \n Ice slash!", "alice_fc7", 3],
      },
      [944] => { # サンダースラッシュ
        :word_1 => ["\\n<Alice>Knock it down, a flash of yellow... \n Thunder slash!", "alice_fc7", 3],
      },
      [946] => { # 屠竜撃
        :word_1 => ["\\n<Alice>Catch \n, the blow that kills the dragon!", "alice_fc7", 3],
      },
      [947] => { # 雲身払車剣
        :word_1 => ["\\n<Alice>A blade of haze, like a wheel... a sword that removes the body!", "alice_fc7", 3],
      },
      [948] => { # 滅世斬
        :word_1 => ["\\n<Alice>A dark blade that ends this world... Destruction!", "alice_fc7", 3],
      },
      [953] => { # 死剣・乱れ星
        :word_1 => ["\\n<Alice>Twinkling meteor sword technique...Death sword/turbulent star!", "alice_fc7", 3],
      },
      [954] => { # 魔影流星斬
        :word_1 => ["\\n<Alice>Look at the dark meteor falling on the earth... Demonic Shadow Meteor Slash!", "alice_fc7", 3],
      },
      [959] => { # ギガスラッシュ
        :word_1 => ["\\n<Alice>This is the ultimate flash... \n Giga Slash!", "alice_fc7", 3],
      },
      [961] => { # 月下散華
        :word_1 => ["\\n<Alice>Spring dies under the moon... Sanka under the moon!", "alice_fc7", 3],
      },
      [962] => { # 魔刃・雪時雨
        :word_1 => ["\\n<Alice>The endless slash of Rakshasa...Magic blade, Yuki Shigure!", "alice_fc7", 3],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :word_1 => ["\\n<Alice>Fast as a gale, fast as thunder...! \n Instant strike, gale of thunder!", "alice_fc7", 3],
      },
      [969] => { # 諸刃微塵斬り
        :word_1 => ["\\n<Alice>Even if this body decays... it's a double-edged sword!", "alice_fc7", 3],
      },
      [973] => { # アトミックスラッシュ
        :word_1 => ["\\n<Alice>Erase \n, a flash of nuclear heat... Atomic Slash!", "alice_fc7", 3],
      },
      [974] => { # クァンタスラッシュ
        :word_1 => ["\\n<Alice>Erase it, a flash of quantum... Quantus Slash!", "alice_fc7", 3],
      },
      [975] => { # イオンスラッシュ
        :word_1 => ["\\n<Alice>Erase it, a flash of atoms... ion slash!", "alice_fc7", 3],
      },
      [9009] => { # ギガスラッシュクロス
        :word_1 => ["\\n<Alice>Double flash... Giga Slash Cross!", "alice_fc7", 3],
      },
      [9016] => { # 乱れ雪月花
        :word_1 => ["\\n<Alice>Dance of snow...Shadow of the moon...Scattered with flowers...!", "alice_fc7", 3],
      },
      [971] => { # 聖光六閃斬
        :word_1 => ["\\n<Alice>Receive the continuous attack of light... Six flashes of holy light!", "alice_fc7", 3],
      },
      [970] => { # メギドカリバーン
        :word_1 => ["\\n<Alice>Mowing down with the wave of darkness... Megiddo Caliburn!", "alice_fc7", 3],
      },
      [9014] => { # メギドカブラ
        :word_1 => ["\\n<Alice>This is the ultimate secret of the magic sword... Megidokabura!", "alice_fc7", 3],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Alice>The healing sword, the protection of the abominable light!", "alice_fc7", 3],
      },
      [972] => { # 闇天
        :word_1 => ["\\n<Alice>The blade of Shura that cuts everything...Dark Heaven!", "alice_fc7", 3],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Alice>Take advantage of my saber skills!", "alice_fc7", 3],
      },
      [985] => { # チャージレイ
        :word_1 => ["\\n<Alice>Charge... Ha!", "alice_fc7", 3],
      },
      [986] => { # Vスラッシュ
        :word_1 => ["\\n<Alice>More than \n victories will be carved into your body!", "alice_fc7", 3],
      },
      [987] => { # ダンシングサーブル
        :word_1 => ["\\n<Alice>Dance, Sable!　Aaah!", "alice_fc7", 3],
      },
      [988] => { # スプラッシュフルーレ
        :word_1 => ["\\n<Alice>Elegantly and brilliantly... Splash!", "alice_fc7", 3],
      },
      [989] => { # クロスアンブル
        :word_1 => ["\\n<Alice>Take advantage of the double tip of the sword!", "alice_fc7", 3],
      },
      [990] => { # トライジャッド
        :word_1 => ["\\n<Alice>Anne, Do, Trois...Try Jud!", "alice_fc7", 3],
      },
      [991] => { # フォティトゥリア
        :word_1 => ["\\n<Alice>Dance, scorching... Fotituria!", "alice_fc7", 3],
      },
      [992] => { # パゴストゥリア
        :word_1 => ["\\n<Alice>Dancing ice crystals...Pagosturia!", "alice_fc7", 3],
      },
      [993] => { # ケラヴトゥリア
        :word_1 => ["\\n<Alice>Sound the thunder... Keravturia!", "alice_fc7", 3],
      },
      [994] => { # ゼクスルージュ
        :word_1 => ["\\n<Alice>Sparkling, six-layered sword tip... Zex Rouge!", "alice_fc7", 3],
      },
      [995] => { # プリエール
        :word_1 => ["\\n<Alice>Priere, receive the tip of the sword of hellfire!", "alice_fc7", 3],
      },
      [996] => { # ヴィクトワール
        :word_1 => ["\\n<Alice>Glory of victory to the \n champion... Victoire!", "alice_fc7", 3],
      },
      [997] => { # アンスタン
        :word_1 => ["\\n<Alice>Unstan! Dance, the infinite sword tip!", "alice_fc7", 3],
      },
      [998] => { # ネメシス
        :word_1 => ["\\n<Alice>Give me your reward, the merciless blade... Nemesis!", "alice_fc7", 3],
      },
      [999] => { # ノーザンクロス
        :word_1 => ["\\n<Alice>Burn it out, the flash of the cross! Northern Cross!", "alice_fc7", 3],
      },
      [9032] => { # ギャラクシア
        :word_1 => ["\\n<Alice>Sparkle, the tip of the galactic sword! Galaxia!", "alice_fc7", 3],
      },
      [9033] => { # 魔王煉獄剣
        :word_1 => ["\\n<Alice>Take it, the Monster Lord's blade that will destroy everything... the Monster Lord's purgatory sword!", "alice_fc7", 3],
      },
      [9034] => { # ギャラクシア・エクス
        :word_1 => ["\\n<Alice>Delivered to the edge of the galaxy...Galaxia Ex!", "alice_fc7", 3],
      },
      [9031] => { # エクスィス
        :word_1 => ["\\n<Alice>A brilliant and fierce series of moves! Exis!", "alice_fc7", 3],
      },
      [9037] => { # ドゥームズデイ
        :word_1 => ["\\n<Alice>The day of revelation marks the end! Doomsday!", "alice_fc7", 3],
      },
      [9035] => { # アルテマエンデ
        :word_1 => ["\\n<Alice>The last and ultimate sword! Altemaende!", "alice_fc7", 3],
      },
      [9036] => { # 魔煌炎舞
        :word_1 => ["\\n<Alice>Dance, the demon emperor's flame! Magic flame dance!", "alice_fc7", 3],
      },
      [9029] => { # クロス・ノイエ
        :word_1 => ["\\n<Alice>Double sword tip, slash in one breath!", "alice_fc7", 3],
      },
      [9030] => { # トライ・グランテ
        :word_1 => ["\\n<Alice>The tip of the triple sword runs across the earth and defeats evil!", "alice_fc7", 3],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Alice>I bet my pride on this blade!", "alice_fc7", 3],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Alice>He will cut you into pieces with his extra white blade!", "alice_fc7", 3],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Alice>I bet the Monster Lord's pride on this white blade!", "alice_fc7", 3],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Alice>I will settle the matter with my own hands...", "alice_fc7", 3],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Alice>Look at my spear handling! Ha!", "alice_fc7", 3],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Alice>Spear, show me a hideous miracle!", "alice_fc7", 3],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Alice>Spear, give me strength!", "alice_fc7", 3],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Alice>Look at my ax skills! Ha!", "alice_fc7", 3],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Alice>Raging, my tyrannical axe!", "alice_fc7", 3],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Alice>Look at my sword skills! Ha!", "alice_fc7", 3],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Alice>Look at my sickle skills! Ha!", "alice_fc7", 3],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Alice>Go crazy with the Monster Lord's sickle!", "alice_fc7", 3],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Alice>Look at my bow skills! Ha!", "alice_fc7", 3],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Alice>Rain down, healing arrows!", "alice_fc7", 3],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Alice>Crawl on the ground with more than a whip! Ha!", "alice_fc7", 3],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Alice>I ordered you to come!", "alice_fc7", 3],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Alice>Look at the other boomerang skills! Ha!", "alice_fc7", 3],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Alice>Look at \n's iron ball handling! Ha!", "alice_fc7", 3],
      },
      [1282] => { # 鉄球撃
        :word_1 => ["\\n<Alice>Catch it, a blow from the iron ball!", "alice_fc7", 3],
      },
      [1283] => { # 鉄球火炎撃
        :word_1 => ["\\n<Alice>Burn, the iron ball strikes!", "alice_fc7", 3],
      },
      [1284] => { # 鉄球氷柱撃
        :word_1 => ["\\n<Alice>Freeze, a blow from the iron ball!", "alice_fc7", 3],
      },
      [1285] => { # 鉄球雷電撃
        :word_1 => ["\\n<Alice>Numb, a blow from the iron ball!", "alice_fc7", 3],
      },
      [1286] => { # 触手殺し
        :word_1 => ["\\n<Alice>Don't be crushed, kill the tentacles!", "alice_fc7", 3],
      },
      [1287] => { # キルスキュラ
        :word_1 => ["\\n<Alice>Take the hammer of destruction that will destroy Scylla!", "alice_fc7", 3],
      },
      [1288] => { # ヘビィスパイラル
        :word_1 => ["\\n<Alice>Knock down \n, a storm of iron balls! Heavy spiral!", "alice_fc7", 3],
      },
      [1289] => { # チェインドライブ
        :word_1 => ["\\n<Alice>Take it yourself, the rain of iron balls! \n Chain Drive!", "alice_fc7", 3],
      },
      [1290] => { # グランドドライブ
        :word_1 => ["\\n<Alice>Crawling on the ground, swift iron ball! Grand Drive!", "alice_fc7", 3],
      },
      [1291] => { # 天罰の鉄球
        :word_1 => ["\\n<Alice>Iron ball of evil, carve my anger into it!", "alice_fc7", 3],
      },
      [1292] => { # 鎖舞
        :word_1 => ["\\n<Alice>The dance is an iron ball, and the chain dance is dedicated to the heavens!", "alice_fc7", 3],
      },
      [1293] => { # デッドリーメイス
        :word_1 => ["\\n<Alice>Shatter the earth...Deadly Mace!", "alice_fc7", 3],
      },
      [1294] => { # ウェイトキャノン
        :word_1 => ["\\n<Alice>Shoot down \n, a furious blow! Weight Cannon!", "alice_fc7", 3],
      },
      [1297] => { # 鉄球剛乱舞
        :word_1 => ["\\n<Alice>Shatter without leaving any dust behind! Iron ball dance!", "alice_fc7", 3],
      },
      [1298] => { # クロスメイデン
        :word_1 => ["\\n<Alice>Flash of the cross, destroy the darkness...Cross Maiden", "alice_fc7", 3],
      },
      [1299] => { # 神楽乱陣
        :word_1 => ["\\n<Alice>Iron ball battle dance, look to the heavens... Kagura Ranjin!", "alice_fc7", 3],
      },
      [1300] => { # レイジングバースト
        :word_1 => ["\\n<Alice>Shattered iron ball! Blow away, Raging Burst!", "alice_fc7", 3],
      },
      [1301] => { # 破壊の一撃
        :word_1 => ["\\n<Alice>All my heart! Destroyed! A blow of destruction!", "alice_fc7", 3],
      },
      [1302] => { # 五星滅球撃
        :word_1 => ["\\n<Alice>A blink of an eye, a meteor of destruction... Five stars of destruction!", "alice_fc7", 3],
      },
      [1304] => { # ウロボロスアーク
        :word_1 => ["\\n<Alice>Super heavy crushing blow... Ouroboros Ark!", "alice_fc7", 3],
      },
      [1306] => { # エデンズヘブン
        :word_1 => ["\\n<Alice>Distortion, world... Eden's Heaven!", "alice_fc7", 3],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Alice>Look at Tamamo's inherited fan skills! Ha!", "alice_fc7", 3],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Alice>Look at my gun skills! Ha!", "alice_fc7", 3],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Alice>Take the healing bullet!", "alice_fc7", 3],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Alice>Experience \n's continuous attacks for yourself!", "alice_fc7", 3],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Alice>Blades in both hands, slash wildly!", "alice_fc7", 3],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Alice>Experience \n's martial arts for yourself!", "alice_fc7", 3],
      },
      [1400] => { # 足払い
        :word_1 => ["\\n<Alice>There is a chance! Foot sweep!", "alice_fc7", 3],
      },
      [1401] => { # 飛び膝蹴り
        :word_1 => ["\\n<Alice>Eat \n! Flying knee kick!", "alice_fc7", 3],
      },
      [1402] => { # 回し蹴り
        :word_1 => ["\\n<Alice>roundhouse kick, a flash!", "alice_fc7", 3],
      },
      [1403] => { # 秘孔
        :word_1 => ["\\n<Alice>I'll do it with one blow...Secret hole!", "alice_fc7", 3],
      },
      [1405] => { # 正拳突き
        :word_1 => ["\\n<Alice>Huh... Seiken punch!", "alice_fc7", 3],
      },
      [1406] => { # 羅刹掌
        :word_1 => ["\\n<Alice>Face the battle with \n and turn into a Rakshasa! Rakshasa palm!", "alice_fc7", 3],
      },
      [1407] => { # 爆裂拳
        :word_1 => ["\\n<Alice>Shut up and take it, the explosive fist! \n Huh!", "alice_fc7", 3],
      },
      [1408] => { # 電塵連脚
        :word_1 => ["\\n<Alice>Shut up and take it, lightning legs! \n Huh!", "alice_fc7", 3],
      },
      [1409] => { # 炎舞三連撃
        :word_1 => ["\\n<Alice>Burn, triple fire!", "alice_fc7", 3],
      },
      [1410] => { # 氷拳乱雹撃
        :word_1 => ["\\n<Alice>Freezing, frigid fist!", "alice_fc7", 3],
      },
      [1411] => { # 雷神喝撃
        :word_1 => ["\\n<Alice>Disappear, thunder god's cheer!", "alice_fc7", 3],
      },
      [1412] => { # 真空波動掌
        :word_1 => ["\\n<Alice>Wind waves... A flash of inspiration!", "alice_fc7", 3],
      },
      [1413] => { # 土刻金剛拳
        :word_1 => ["\\n<Alice>Carve into the soil and pierce even Kongo!", "alice_fc7", 3],
      },
      [1414] => { # 波断水裂蹴
        :word_1 => ["\\n<Alice>Cutting through the water surface...An instant kick!", "alice_fc7", 3],
      },
      [1431] => { # エレメントフィニッシュ
        :word_1 => ["\\n<Alice>The magic fist carves an eight-colored glow...!", "alice_fc7", 3],
      },
      [1425] => { # 聖光裂閃撃
        :word_1 => ["\\n<Alice>blink, a white flash! Holy light splitting flash!", "alice_fc7", 3],
      },
      [1426] => { # 暗黒連衝拳
        :word_1 => ["\\n<Alice>Engraved \n, black shock! Dark Renchoken!", "alice_fc7", 3],
      },
      [1427] => { # 四天光掌
        :word_1 => ["\\n<Alice>Four palms of light, dance in disorder in the shining heaven and earth!", "alice_fc7", 3],
      },
      [1428] => { # 四星滅功
        :word_1 => ["\\n<Alice>Four star destruction, bloom in the dark sky!", "alice_fc7", 3],
      },
      [1429] => { # 烈気光掌
        :word_1 => ["\\n<Alice>A flash of energy can reach the heavens... A palm of intense light!", "alice_fc7", 3],
      },
      [1430] => { # 瞬獄殺
        :word_1 => ["\\n<Alice>The living are doomed...", "alice_fc7", 3],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Alice>....................", "alice_fc7", 3],
      },
      [1434] => { # 当て身光掌（発動）
        :word_1 => ["\\n<Alice>I received \n... Atemi Kosho!", "alice_fc7", 3],
      },
      [1435] => { # 金剛八連拳
        :word_1 => ["\\n<Alice>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "alice_fc7", 3],
      },
      [1436] => { # 紅蓮大拳舞
        :word_1 => ["\\n<Alice>Dance wildly, the crimson flame! Guren Daikenbu!", "alice_fc7", 3],
      },
      [9157] => { # 電塵乱皇脚
        :word_1 => ["\\n<Alice>Flash, noble thunder! Denjinran Kokyaku!", "alice_fc7", 3],
      },
      [9159] => { # 真・瞬獄殺
        :word_1 => ["\\n<Alice>The living will be destroyed, all things will be destroyed...!", "alice_fc7", 3],
      },
      [9164] => { # 修羅爆裂拳
        :word_1 => ["\\n<Alice>Shura's fist hits wildly!　Aaah!!", "alice_fc7", 3],
      },
      [9163] => { # 破滅の鉄槌
        :word_1 => ["\\n<Alice>The judgment of the fist... the hammer of destruction!", "alice_fc7", 3],
      },
      [9156] => { # 零拳
        :word_1 => ["\\n<Alice>Scattered, sub-zero freezing fist...Zero Fist!", "alice_fc7", 3],
      },
      [9165] => { # 聖天轟裂撃
        :word_1 => ["\\n<Alice>Breath of white light... Holy heaven roar ruptures!", "alice_fc7", 3],
      },
      [9166] => { # 魔天冥煌撃
        :word_1 => ["\\n<Alice>Breath of darkness... Demon heaven's dark sparkle attack!", "alice_fc7", 3],
      },
      [9167] => { # 覆滅陰陽撃
        :word_1 => ["\\n<Alice>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "alice_fc7", 3],
      },
      [9173] => { # 天地開闢拳
        :word_1 => ["\\n<Alice>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "alice_fc7", 3],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Alice>Get lost in my skills...!", "alice_fc7", 3],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc7", 3],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc7", 3],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc7", 3],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Alice>Heal your heavenly veins...my chakra!", "alice_fc7", 3],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Alice>Lifeline, bring back your soul!", "alice_fc7", 3],
      },
      [1451] => { # 裏蘇生
        :word_1 => ["\\n<Alice>Forbidden technique of resurrection...ha!", "alice_fc7", 3],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Alice>Demon vein, stay in your fist!", "alice_fc7", 3],
      },
      [1452] => { # 三魔の拳
        :word_1 => ["\\n<Alice>Breath of the three demons, dwell in my fist!", "alice_fc7", 3],
      },
      [1453] => { # 四精の拳
        :word_1 => ["\\n<Alice>Breath of the four spirits, dwell in my fist!", "alice_fc7", 3],
      },
      [1454] => { # 聖魔の拳
        :word_1 => ["\\n<Alice>Breath of the holy devil, dwell in my fist!", "alice_fc7", 3],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Alice>White magic, bring healing!", "alice_fc7", 3],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Alice>White magic, bring healing!", "alice_fc7", 3],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Alice>Abominable holy light, illuminate the darkness!", "alice_fc7", 3],
      },
      [1471] => { # マヒール
        :word_1 => ["\\n<Alice>The cruel wind of life, scatter into thousands of pieces and crush it! \n Ma Heal!", "alice_fc7", 3],
      },
      [1472] => { # オールマヒール
        :word_1 => ["\\n<Alice>The cruel wind of life, scatter into thousands of pieces and crush it! \n Allma Heal!", "alice_fc7", 3],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Alice>Abominable light, destroy the demon! \n Heaven!", "alice_fc7", 3],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Alice>Abominable light, grant protection!", "alice_fc7", 3],
      },
      [1476] => { # マジック
        :word_1 => ["\\n<Alice>White torrent, become the breath of evil and bring blessings! \nMagic!", "alice_fc7", 3],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Alice>Abominable light, become a wall of protection!", "alice_fc7", 3],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Alice>Abominable light, cancel the blessing!", "alice_fc7", 3],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Black torrent, obey my orders!", "alice_fc7", 3],
      },
      [1496] => { # ファイア
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Angry flame, show your power! \nFire!", "alice_fc7", 3],
      },
      [1497] => { # メガファイア
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The angry flame turns into a whirlpool and mowing it down! \n Mega Fire!", "alice_fc7", 3],
      },
      [1498] => { # ファイアテンペスト
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>A swirl of flames, raging in anger! \n Fire Tempest!", "alice_fc7", 3],
      },
      [1499] => { # ブレイズ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Breath of hellfire, bring a scorching nightmare! \n Blaze!", "alice_fc7", 3],
      },
      [1500] => { # オメガブレイズ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>According to the pact, come, nightmare hellfire! \n Burn it to ashes! Omega Blaze!", "alice_fc7", 3],
      },
      [1501] => { # プロミネンス
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The original red invites infinite regression! \n The scorching heat of the end! Prominence!", "alice_fc7", 3],
      },
      [1502] => { # ブリザード
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Freezing ice, bring the extreme cold! \n Blizzard!", "alice_fc7", 3],
      },
      [1503] => { # メガブリザード
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Freezing ice, bring destruction with a cold storm! \n Mega blizzard!", "alice_fc7", 3],
      },
      [1504] => { # ブリザードストーム
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Cold vortex, show destruction with your endless blade! \n Blizzard Storm!", "alice_fc7", 3],
      },
      [1505] => { # フロスト
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The cold coffin doesn't freeze even the cries of grief! \nFrost!", "alice_fc7", 3],
      },
      [1506] => { # シグマフロスト
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>A torrent of zero, a frozen moment in the blue world... \n Lifeless silence! Sigma Frost!", "alice_fc7", 3],
      },
      [1507] => { # アイスエイジ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The blue root is carved into the Apocalypse pole! \n Zero degree of origin, Ice Age!", "alice_fc7", 3],
      },
      [9194] => { # クァンタゾーン
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Ultra-fine blink of an eye, bring about the destruction of condensation! \n Quanta Zone!", "alice_fc7", 3],
      },
      [9196] => { # イオンブラスト
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Look at the way the floating molecules scatter! \n Ion blast!", "alice_fc7", 3],
      },
      [9206] => { # オーバーカーズ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Cursed Queen, open up taboos! \n Black disaster, OverCurse!", "alice_fc7", 3],
      },
      [1508] => { # サンダー
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Pure thunder, bring judgment! \n Thunder!", "alice_fc7", 3],
      },
      [1509] => { # メガサンダー
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Pure thunder, exorcise evil and rain down on it! \n Mega Thunder!", "alice_fc7", 3],
      },
      [1510] => { # サンダーハリケーン
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Raging thunder, split the sky and roar! \n Thunder Hurricane!", "alice_fc7", 3],
      },
      [1511] => { # スパーク
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Hammer of lightning, defeat evil and reduce it to ashes! \n Spark!", "alice_fc7", 3],
      },
      [1512] => { # ラムダスパーク
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The hammer of judgment, the hell of thunder returned to dust... \n Show me the cause and effect! Lambda Spark!", "alice_fc7", 3],
      },
      [1513] => { # ライトニング
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The original brilliance shows the reincarnation of dust! \n Apocalyptic thunder! Lightning!", "alice_fc7", 3],
      },
      [9205] => { # トリニティ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Play the dance of flame, ice, and thunder! \n Trinity!", "alice_fc7", 3],
      },
      [9192] => { # ガンマバースト
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Bring the afterglow of creation, the scorching heat of the primordial! \n Gamma Burst!", "alice_fc7", 3],
      },
      [9204] => { # カオスリバレート
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The source of ultimate magic... Chaos Revelation!", "alice_fc7", 3],
      },
      [9207] => { # アポカリプス
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Hear the footsteps of the end...Apocalypse!", "alice_fc7", 3],
      },
      [9210] => { # オーバーロード
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>All of my magical power will be poured into me... \n Disappear into dust, Overlord!", "alice_fc7", 3],
      },
      [1530] => { # ドレイン
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Dedicate the wave of life to me! \n Drain!", "alice_fc7", 3],
      },
      [1531] => { # マドレイン
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>A torrent of magic, offer it to me! \n Madeleine!", "alice_fc7", 3],
      },
      [1532] => { # デス
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Death's scythe, which reaps life, invite its soul to the underworld! \n Death!", "alice_fc7", 3],
      },
      [1533] => { # オールデス
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Death's scythe, which reaps life, invite the swarm of souls to the underworld! \n All Death!", "alice_fc7", 3],
      },
      [1534] => { # ポイズン
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Risk the poisonous stream! \n Poison!", "alice_fc7", 3],
      },
      [1535] => { # ブラインド
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Darkness of the night, steal the light! \n Blind!", "alice_fc7", 3],
      },
      [1536] => { # サイレンス
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Refuse magic and bring silence! \n Silence!", "alice_fc7", 3],
      },
      [1537] => { # コンフューズ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>My mind is disturbed by the rolling waves, and I don't even know where the blade is heading! \n Confuse!", "alice_fc7", 3],
      },
      [1538] => { # スリープ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Daydream, a butterfly invites you to close your consciousness! \n Sleep!", "alice_fc7", 3],
      },
      [1539] => { # パラライズ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Numb arms, know that they are not vessels of freedom! \n Paralyze!", "alice_fc7", 3],
      },
      [1541] => { # ヒールタイフーン
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The peaceful wind of life, blow into a storm of blessings! \nHeal Typhoon!", "alice_fc7", 3],
      },
      [1527] => { # カイザーフェニックス
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Be burned by the flames of the phoenix... \n The devil's secret technique is Kaiser Phoenix!", "alice_fc7", 3],
      },
      [1528] => { # フェニックスロンド
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Dance, the Monster Lord's phoenix... \n Dance to the crimson, Phoenix Rondo!", "alice_fc7", 3],
      },
      [1523] => { # カーズ
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The fog of darkness, bring great disaster! Curse!", "alice_fc7", 3],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Alice>It's \n, follow me! Ha!", "alice_fc7", 3],
      },
      [1547] => { # スロウ
        :word_1 => ["\\n<Alice>The muddy stream at \n, slow down your steps and rest in peace! \n Slow!", "alice_fc7", 3],
      },
      [1548] => { # オールスロウ
        :word_1 => ["\\n<Alice>The muddy stream at \n, slow down your steps and rest in peace! \n All slow!", "alice_fc7", 3],
      },
      [1549] => { # クィック
        :word_1 => ["\\n<Alice>The muddy waters of time, quicken your steps and keep your heart beating! \nQuick!", "alice_fc7", 3],
      },
      [1550] => { # オールクィック
        :word_1 => ["\\n<Alice>The muddy waters of time, quicken your steps and keep your heart beating! \n All quick!", "alice_fc7", 3],
      },
      [1551] => { # ストップ
        :word_1 => ["\\n<Alice>Block and stop the truth, Time of Zero! \n Stop!", "alice_fc7", 3],
      },
      [1552] => { # オールストップ
        :word_1 => ["\\n<Alice>Block and stop the truth, Time of Zero! \n All stop!", "alice_fc7", 3],
      },
      [1553] => { # フォシル
        :word_1 => ["\\n<Alice>The muddy waters of time, hurry up and rot away! \n Fossil!", "alice_fc7", 3],
      },
      [1555] => { # リゾーン
        :word_1 => ["\\n<Alice>Gate of time, open, arms of another world! \n Rezone!", "alice_fc7", 3],
      },
      [1557] => { # グラビティ
        :word_1 => ["\\n<Alice>Become the curse of gravity and crush your body! \n Gravidi!", "alice_fc7", 3],
      },
      [1558] => { # ハイグラビティ
        :word_1 => ["\\n<Alice>Let the curse of gravity become a hammer and crush it! \n Hi Gravidi!", "alice_fc7", 3],
      },
      [9226] => { # オーバーグラビディ
        :word_1 => ["\\n<Alice>The curse of gravity, crush both light and darkness! \nThe pinnacle of crushing, Overgravidy!", "alice_fc7", 3],
      },
      [9223] => { # オーバークイック
        :word_1 => ["\\n<Alice>The muddy current of time, carve the ultimate heartbeat! \n Overquick!", "alice_fc7", 3],
      },
      [9222] => { # オーバースロウ
        :word_1 => ["\\n<Alice>Stay in the ultimate calm in the muddy waters of \n! \n Overslow!", "alice_fc7", 3],
      },
      [9224] => { # セカンドアクト
        :word_1 => ["\\n<Alice>The muddy waters of \n, the ultimate protection for your next life! \n Second act!", "alice_fc7", 3],
      },
      [9225] => { # リライフ
        :word_1 => ["\\n<Alice>The muddy waters of time, speed up the heartbeat of life! Relife!", "alice_fc7", 3],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Alice>It's \n, follow me! Ha!", "alice_fc7", 3],
      },
      [1559] => { # コメット
        :word_1 => ["\\n<Alice>The star door is about to open, crush the earth and rain down! \nComet!", "alice_fc7", 3],
      },
      [1560] => { # メテオ
        :word_1 => ["\\n<Alice>The galactic messenger who guides destruction comes from heaven, the hour of disaster! \n Return to the sky! Meteor!", "alice_fc7", 3],
      },
      [1563] => { # アーク
        :word_1 => ["\\n<Alice>Disturbed and crazy, the tide of time... Ark!", "alice_fc7", 3],
      },
      [9227] => { # リピートメテオ
        :word_1 => ["\\n<Alice>Calamity from heaven, overlapping the cycle of time! \nRepeat meteorite, repeat meteorite!", "alice_fc7", 3],
      },
      [9228] => { # コメットレイン
        :word_1 => ["\\n<Alice>The star door is about to open, crush the earth and rain down! \n Comet Rain!", "alice_fc7", 3],
      },
      [9233] => { # オーバーアーク
        :word_1 => ["\\n<Alice>The tide of time is disturbed and comes to an end! \n The flow of destruction, Overark!", "alice_fc7", 3],
      },
      [9230] => { # ギャラクシー
        :word_1 => ["\\n<Alice>Swirling, the breath of a deep galaxy! Galaxy!", "alice_fc7", 3],
      },
      [9234] => { # サンスフィア
        :word_1 => ["\\n<Alice>Burn up the infinite sun! Sunsphere!", "alice_fc7", 3],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Alice>I command you, time, stop!", "alice_fc7", 3],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Alice>Abominable light, illuminate the darkness!", "alice_fc7", 3],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Alice>The warrior's soul breathes life again!", "alice_fc7", 3],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Alice>Angel's dance...!", "alice_fc7", 3],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Alice>....................", "alice_fc7", 3],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Alice>So, you're going crazy with my lewd techniques...!", "alice_fc7", 3],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Alice>Abominable light, bring healing!", "alice_fc7", 3],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Alice>With my remaining life, I will dispel the darkness!", "alice_fc7", 3],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Alice>Roar, the breath of darkness...", "alice_fc7", 3],
      },
      [1674] => { # ダークネス
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Roar, the breath of darkness...Darkness!", "alice_fc7", 3],
      },
      [1675] => { # ダークエターナル
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>The black of the end, fill the darkness...Dark Eternal!", "alice_fc7", 3],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Alice>In the hour of darkness, cherry blossoms scatter in the dance of flames... \n Tremble to sleep, Majin Flame Dance!", "alice_fc7", 3],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Alice>In the hour of darkness, being sent and dying is the work of the demon ice... \n Tremble and sleep, the demon ice funeral!", "alice_fc7", 3],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Alice>In the hour of darkness, a voice cries out over the thunder dust... \n Tremble and sleep, demon thunder dust!", "alice_fc7", 3],
      },
      [1679] => { # ダークストリーム
        :ct_pic => "80_alice_st51b",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alice>Come, the tide of darkness... Dark stream!", "alice_fc7", 3],
      },
      [1683] => { # 死んでくれる？
        :word_1 => ["\\n<Alice>I'll have you die...!", "alice_fc7", 3],
      },
      [1684] => { # 魔王の暴虐
        :word_1 => ["\\n<Alice>Experience the power of the Monster Lord for yourself!", "alice_fc7", 3],
      },
      [1690] => { # 終焉の闇
        :word_1 => ["\\n<Alice>Close the darkness of the end...", "alice_fc7", 3],
      },
      [1692] => { # 裁きの炎
        :word_1 => ["\\n<Alice>Burn it down, the flames of judgment...!", "alice_fc7", 3],
      },
      [1694] => { # アンリ・マンユ
        :word_1 => ["\\n<Alice>Henri Mainyu, the hour of darkness has arrived...", "alice_fc7", 3],
      },
      [1693] => { # ビッグクランチ
        :word_1 => ["\\n<Alice>End this world...Big Crunch!", "alice_fc7", 3],
      },
      [9299] => { # ディメント・ナーギ
        :word_1 => ["\\n<Alice>A dream of pleasure shown by the Monster Lord... Demento Nagi!", "alice_fc7", 3],
      },
      [9300] => { # ネフィリム・エンデ
        :word_1 => ["\\n<Alice>Become food for the Monster Lord...Nephilim Ende!", "alice_fc7", 3],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Alice>Magical power, dwell in my blade!", "alice_fc7", 3],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Alice>Deploy the magical protective wall!", "alice_fc7", 3],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Alice>Sign of Yin and Yang, show me the principles of heaven and earth!", "alice_fc7", 3],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Alice>The law of exorcism, the prison of rebellion! \n Realize your retribution, Nine Souls Exorcism Team!", "alice_fc7", 3],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Alice>A lifetime, sending it is life! \n Carving the slightest bit...Singing life!", "alice_fc7", 3],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Alice>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "alice_fc7", 3],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Alice>I got \n!", "alice_fc7", 3],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Alice>This is the proof of a thief!", "alice_fc7", 3],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Alice>Yes, this is Tonzura!", "alice_fc7", 3],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Alice>Take advantage of the ninjutsu!", "alice_fc7", 3],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Alice>Go crazy in agony with Kunoichi's techniques!", "alice_fc7", 3],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Alice>Healing waves, pervade thousands of places... \n Ninja art/healing waves!", "alice_fc7", 3],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Alice>Autumn Utsusemi dances in the shadows... \n Ninja art/Bunshin no Jutsu!", "alice_fc7", 3],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Alice>I had to run away...", "alice_fc7", 3],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Alice>Admire the skills of those who live in the sea...!", "alice_fc7", 3],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Alice>This kind of mood isn't bad either!", "alice_fc7", 3],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Alice>I'm a magical girl, Magical☆Alice!", "alice_fc7", 3],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Alice>Look, this is the power of money!", "alice_fc7", 3],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Alice>Okay, I bought it!", "alice_fc7", 3],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Alice>If it takes more than \n, that's it!", "alice_fc7", 3],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Alice>Look at \n's card handling!", "alice_fc7", 3],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Alice>Should I bet on this coin...", "alice_fc7", 3],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Alice>A dark game played by the Monster Lord...", "alice_fc7", 3],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Alice>Should I try fortune-telling with \n tarot...", "alice_fc7", 3],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Alice>I know it's disgusting, but maybe I should try calling Ilias...", "alice_fc7", 3],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Alice>Should I try spinning the \n slot...", "alice_fc7", 3],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Alice>Come on, let's play poker with me!", "alice_fc7", 3],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Alice>battle card, draw!", "alice_fc7", 3],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Alice>I will show you the power of Trump...!", "alice_fc7", 3],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Alice>The Monster Lord chooses today's happy person...! ?", "alice_fc7", 3],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Alice>It's always my turn!", "alice_fc7", 3],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Alice>What comes out, Item slot!", "alice_fc7", 3],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Alice>Look, look at my dance!", "alice_fc7", 3],
      },
      [2026] => { # 神代の舞
        :word_1 => ["\\n<Alice>Look at the evil deeds... \n Dedicated to the Dark Goddess is the dance of the age of the gods!", "alice_fc7", 3],
      },
      [2043] => { # 破護の舞
        :word_1 => ["\\n<Alice>No protection will be given ♪ Dance of destruction ~ ♪", "alice_fc7", 3],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Alice>That's it! Hustle! Hustle!", "alice_fc8", 1],
      },
      [2061] => { # 蛇神の舞
        :word_1 => ["\\n<Alice>The burning heart is the dance of the snake god...♪", "alice_fc7", 3],
      },
      [2064] => { # 十六夜神楽
        :word_1 => ["\\n<Alice>This body is a dream, Izayoi Kagura...♪", "alice_fc7", 3],
      },
      [2065] => { # 宵月神楽
        :word_1 => ["\\n<Alice>This body is moving, Yozuki Kagura...♪", "alice_fc7", 3],
      },
      [9399] => { # 清めの神舞
        :word_1 => ["\\n<Alice>Exorcise the curse, the divine dance of purification...♪", "alice_fc7", 3],
      },
      [9402] => { # 無限蛇の踊り
        :word_1 => ["\\n<Alice>Not bound by any shackles...♪", "alice_fc7", 3],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Alice>Hey, listen to my song!", "alice_fc7", 3],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Alice>extra sparkle☆", "alice_fc8", 1],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Alice>Why don't you talk to me for a while...", "alice_fc7", 3],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Alice>You're doing quite well, I'll praise you...", "alice_fc7", 1],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Alice>Hmm, I'm disappointed in you...", "alice_fc7", 3],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Alice>Hey, I want money...", "alice_fc7", 3],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Alice>Hey there, I want an item...", "alice_fc7", 3],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Alice>You should work for me over there!", "alice_fc7", 3],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Alice>Do you want to try eating the food I made...?", "alice_fc7", 3],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Alice>Come on, go home!", "alice_fc7", 3],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Alice>At \n, the gift fell down the stairs... Kuku.", "alice_fc7", 1],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Alice>I secretly peeked into Alma Elma's room and found out...!", "alice_fc7", 3],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Alice>I was frightened when I peeked through the gap... \n I saw a woman wearing a fox mask... Brrr!", "alice_fc7", 5],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Alice>Alice is a squirrel.", "alice_fc8", 1],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Alice>Enjoy the power of words!", "alice_fc7", 3],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Alice>This is the power of science!", "alice_fc7", 3],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Alice>Now, let's prepare for the crisis!", "alice_fc7", 3],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Alice>Energy conversion... Ha!", "alice_fc7", 3],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Alice>Let's alchemize \nItem!", "alice_fc7", 3],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Alice>Look at the power of the magic book!", "alice_fc7", 3],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Alice>Turn myself into a page...", "alice_fc7", 3],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Alice>I can also use machines!", "alice_fc7", 3],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Alice>Kukuku...Let me show you my cooking!", "alice_fc7", 3],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Alice>I received the ingredients!", "alice_fc7", 1],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Alice>Look, look at my female skills!", "alice_fc7", 3],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Alice>Now, writhe in agony at my techniques...", "alice_fc7", 3],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Alice>Look, look at my female skills!", "alice_fc7", 3],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Alice>Look, use this medicine...", "alice_fc7", 3],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Alice>Look, I'll give you the injection...", "alice_fc7", 3],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Alice>Let's spread the \n special virus!", "alice_fc7", 3],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Alice>I'm a hard worker! Sora Sora!", "alice_fc7", 3],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Alice>Now, writhe in agony at my techniques...", "alice_fc7", 3],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Alice>Tea has arrived, the devil's tea!", "alice_fc7", 3],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Alice>Maids can transform at will!", "alice_fc7", 3],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Alice>It's almost time to harvest, kukuku...", "alice_fc7", 3],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Alice>See the king's sword skills with your own eyes!", "alice_fc7", 3],
      },
      [2403] => { # 王者の刃
        :word_1 => ["\\n<Alice>Look closely, the blade of the king!", "alice_fc7", 3],
      },
      [2404] => { # 王命剣
        :word_1 => ["\\n<Alice>Carve it into your body... the sword of the king's life!", "alice_fc7", 3],
      },
      [2405] => { # キングスクルセイド
        :word_1 => ["\\n<Alice>Carve the blade of belief... King's Crusade!", "alice_fc7", 3],
      },
      [2406] => { # 覇道皇塵剣
        :word_1 => ["\\n<Alice>This is the supreme king's blow... the supreme supreme sword!", "alice_fc7", 3],
      },
      [9519] => { # 真・覇王聖剣
        :word_1 => ["\\n<Alice>This is the holy sword wielded by the overlord...sigh!", "alice_fc7", 3],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Alice>This is the king's magic!", "alice_fc7", 3],
      },
      [9521] => { # 天臥裂煌
        :word_1 => ["\\n<Alice>Wang Wei, roar in the heavens and earth... Heaven and Earth's sparkle!", "alice_fc7", 3],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Alice>Servants of the Monster Lord, gather here!", "alice_fc7", 3],
      },
      [2413] => { # 王の軍隊
        :word_1 => ["\\n<Alice>Monster Lord's army, gather here!", "alice_fc7", 3],
      },
      [2414] => { # 王国騎士団
        :word_1 => ["\\n<Alice>Knight of the Monster Lord, show your loyalty!", "alice_fc7", 3],
      },
      [9522] => { # 覇王の親衛隊
        :word_1 => ["\\n<Alice>My Imperial Guard, destroy the enemy!", "alice_fc7", 3],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Alice>Ascend to heaven with my sermon!", "alice_fc7", 3],
      },
      [2420] => { # 王の威光
        :word_1 => ["\\n<Alice>Bow down to the majesty of the Monster Lord!", "alice_fc7", 3],
      },
      [2421] => { # 王権神授
        :word_1 => ["\\n<Alice>This is the proof of the Monster Lord!", "alice_fc7", 3],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Alice>Abominable goddess, lend me your power...!", "alice_fc7", 3],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Alice>Hey!!", "alice_fc7", 3],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Alice>I never thought I'd be able to use the hero's techniques...!", "alice_fc7", 3],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Alice>Look, you're going crazy in agony at my lewd techniques!", "alice_fc7", 3],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Alice>Control your sexual desire!", "alice_fc7", 3],
      },
      [2519] => { # ファイアワルツ
        :word_1 => ["\\n<Alice>Dance with the flames! Fire Waltz!", "alice_fc7", 3],
      },
      [2520] => { # フレアロンド
        :word_1 => ["\\n<Alice>Dance in the hellfire of reincarnation! Flare Rond!", "alice_fc7", 3],
      },
      [2521] => { # バーンレクイエム
        :word_1 => ["\\n<Alice>Invite me to the underworld, funeral flames! Burn Requiem!", "alice_fc7", 3],
      },
      [2522] => { # アークオベリスク
        :word_1 => ["\\n<Alice>Ancient flame, dance at the feast! Ark obelisk!", "alice_fc7", 3],
      },
      [2523] => { # 太古の炎
        :word_1 => ["\\n<Alice>The ancient hellfire that devours this world...!", "alice_fc7", 3],
      },
      [2524] => { # 魔界の煉獄
        :word_1 => ["\\n<Alice>Purgatory in the demon world, burn down this world...!", "alice_fc7", 3],
      },
      [9537] => { # 倶利伽羅の黒龍
        :word_1 => ["\\n<Alice>Black dragon, burn this world to the ground!", "alice_fc7", 3],
      },
      [9538] => { # 黄泉の狂氷
        :word_1 => ["\\n<Alice>Come from the underworld, the eternal mad ice!", "alice_fc7", 3],
      },
      [2530] => { # 魔雷
        :word_1 => ["\\n<Alice>Cry into the distorted night! Magic thunder!", "alice_fc7", 3],
      },
      [2531] => { # 黒雷
        :word_1 => ["\\n<Alice>Even the echoing screams turn to dust! Black lightning!", "alice_fc7", 3],
      },
      [9539] => { # 夢塵夜
        :word_1 => ["\\n<Alice>I can't even hear the grudge, the dream night...!", "alice_fc7", 3],
      },
      [2535] => { # サンスフィア
        :word_1 => ["\\n<Alice>Dazzling light, illuminate the darkness! Sunsphere!", "alice_fc7", 3],
      },
      [2536] => { # エヴァゲリオ
        :word_1 => ["\\n<Alice>Come, the gospel, show us the judgment! Evagelio!", "alice_fc7", 3],
      },
      [9540] => { # 白蛇神光
        :word_1 => ["\\n<Alice>Inviting the holy light...White snake divine light!", "alice_fc7", 3],
      },
      [9541] => { # 楽園の光
        :word_1 => ["\\n<Alice>This is the light that once illuminated paradise...", "alice_fc7", 3],
      },
      [2546] => { # 毒の魔眼
        :word_1 => ["\\n<Alice>Cover yourself with poison...Evil Eye!", "alice_fc7", 3],
      },
      [2547] => { # 暗闇の魔眼
        :word_1 => ["\\n<Alice>Closing your field of vision in darkness... the evil eye!", "alice_fc7", 3],
      },
      [2548] => { # 沈黙の魔眼
        :word_1 => ["\\n<Alice>Shut your noisy mouth...Evil Eye!", "alice_fc7", 3],
      },
      [2549] => { # 混乱の魔眼
        :word_1 => ["\\n<Alice>Be misled and crazy...Evil Eye!", "alice_fc7", 3],
      },
      [2550] => { # 睡眠の魔眼
        :word_1 => ["\\n<Alice>Fall into a distorted dream...Evil Eye!", "alice_fc7", 3],
      },
      [2551] => { # 麻痺の魔眼
        :word_1 => ["\\n<Alice>Take away your freedom...the evil eye!", "alice_fc7", 3],
      },
      [2555] => { # 暴走の魔眼
        :word_1 => ["\\n<Alice>Lose your reason and go mad with rage...Evil Eye!", "alice_fc7", 3],
      },
      [2556] => { # 石化の魔眼
        :word_1 => ["\\n<Alice>Become a silent stone...Evil Eye!", "alice_fc7", 3],
      },
      [2557] => { # 即死の魔眼
        :word_1 => ["\\n<Alice>Become a cold skeleton... Demon eyes!", "alice_fc7", 3],
      },
      [9542] => { # 最後の魔眼
        :word_1 => ["\\n<Alice>Taste hell with the final evil eye...", "alice_fc7", 3],
      },
      [2558] => { # 王者の魔眼
        :word_1 => ["\\n<Alice>This is the evil eye of the king...", "alice_fc7", 3],
      },
      [2559] => { # 蛇神の魔眼
        :word_1 => ["\\n<Alice>The power of the snake god...the evil eye!", "alice_fc7", 3],
      },
      [9545] => { # エキドナの魔眼
        :word_1 => ["\\n<Alice>The power that corrupted and degraded paradise...", "alice_fc7", 3],
      },
      [9547] => { # 邪神の魔眼
        :word_1 => ["\\n<Alice>With my evil eye, I will return everything to darkness...!", "alice_fc7", 3],
      },
      [2561] => { # 誘惑の魔眼
        :word_1 => ["\\n<Alice>That heart is filled with lust... the evil eye!", "alice_fc7", 3],
      },
      [2564] => { # 浄化の魔眼
        :word_1 => ["\\n<Alice>The defiled, return to heaven...the evil eye!", "alice_fc7", 3],
      },
      [2565] => { # 回復の魔眼
        :word_1 => ["\\n<Alice>Give healing to your injured body...the evil eye!", "alice_fc7", 3],
      },
      [2566] => { # 全快の魔眼
        :word_1 => ["\\n<Alice>Blessings to those who are cornered...Evil Eye!", "alice_fc7", 3],
      },
      [2567] => { # 治癒の魔眼
        :word_1 => ["\\n<Alice>Give healing to a disturbed body...the evil eye!", "alice_fc7", 3],
      },
      [2568] => { # 復活の魔眼
        :word_1 => ["\\n<Alice>Return the soul to the lifeless body...the evil eye!", "alice_fc7", 3],
      },
      [2602] => { # 水撃
        :word_1 => ["\\n<Alice>Eat it, water bullet!", "alice_fc7", 3],
      },
      [2603] => { # 大海嘯
        :word_1 => ["\\n<Alice>Push it away...a great wave!", "alice_fc7", 3],
      },
      [2605] => { # 潮吹き
        :word_1 => ["\\n<Alice>Get down, the raging tide!", "alice_fc7", 3],
      },
      [2606] => { # ノーチラス
        :word_1 => ["\\n<Alice>Crush the fangs of the deep sea... crush them in one breath!", "alice_fc7", 3],
      },
      [2612] => { # 水中放電
        :word_1 => ["\\n<Alice>Electric discharge from within the body... numb!", "alice_fc7", 3],
      },
      [2613] => { # 海神の電
        :word_1 => ["\\n<Alice>Sea God's thunder, receive merciless judgment!", "alice_fc7", 3],
      },
      [2619] => { # 深淵に引きずり込む者
        :word_1 => ["\\n<Alice>Let me show you the depths of the deep sea...", "alice_fc7", 3],
      },
      [2620] => { # 深海の供物
        :word_1 => ["\\n<Alice>I'll sacrifice myself...", "alice_fc7", 3],
      },
      [2624] => { # あわあわ
        :word_1 => ["\\n<Alice>Look, I'm covered in bubbles and writhing in agony!", "alice_fc7", 3],
      },
      [2625] => { # メルティウォッシュ
        :word_1 => ["\\n<Alice>Look, look...I'll wash the rest soon!", "alice_fc7", 3],
      },
      [9560] => { # 究極あわあわ地獄
        :word_1 => ["\\n<Alice>Ascend to heaven with pleasure, the ultimate frothy hell!", "alice_fc7", 3],
      },
      [2643] => { # 恍惚粘液
        :word_1 => ["\\n<Alice>Immerse yourself in ecstasy with this mucus...", "alice_fc7", 3],
      },
      [2644] => { # 失禁粘液
        :word_1 => ["\\n<Alice>This mucus will help you digest...", "alice_fc7", 3],
      },
      [2646] => { # 消化粘液
        :word_1 => ["\\n<Alice>Let this mucus melt your body and soul...", "alice_fc7", 3],
      },
      [2647] => { # 消化粘液の渦
        :word_1 => ["\\n<Alice>Drown in the whirlpool of digestive mucus...", "alice_fc7", 3],
      },
      [2651] => { # ネバネバ粘液地獄
        :word_1 => ["\\n<Alice>Come on, soak in the mucus hell...!", "alice_fc7", 3],
      },
      [2652] => { # ドロドロ粘液天国
        :word_1 => ["\\n<Alice>Soak yourself in slime and ascend to heaven...", "alice_fc7", 3],
      },
      [2653] => { # 快楽昇天ドロドロジェル
        :word_1 => ["\\n<Alice>Melt in pleasure...!", "alice_fc7", 3],
      },
      [9569] => { # 次元侵蝕粘液
        :word_1 => ["\\n<Alice>Erode, the slime that invades dimensions...!", "alice_fc7", 3],
      },
      [2678] => { # 引っ掻き
        :word_1 => ["\\n<Alice>Eat my nails!", "alice_fc7", 3],
      },
      [2679] => { # 一撃の爪
        :word_1 => ["\\n<Alice>Reap that life with these claws!", "alice_fc7", 3],
      },
      [2680] => { # 咬爪乱撃
        :word_1 => ["\\n<Alice>Tear it apart and eat it!", "alice_fc7", 3],
      },
      [2681] => { # 電塵爪
        :word_1 => ["\\n<Alice>Claws, hold electrical dust...!", "alice_fc7", 3],
      },
      [2682] => { # 乱れ電塵爪
        :word_1 => ["\\n<Alice>Disturb, electric dust claw!", "alice_fc7", 3],
      },
      [2683] => { # グリフィススクラッチ
        :word_1 => ["\\n<Alice>Burn the Crimson Claw!", "alice_fc7", 3],
      },
      [2684] => { # プラズマランページ
        :word_1 => ["\\n<Alice>Electric dust claws leave no dust behind!", "alice_fc7", 3],
      },
      [2685] => { # 死舞爪
        :word_1 => ["\\n<Alice>Dance in pitch black, the claws of the underworld...!", "alice_fc7", 3],
      },
      [2685] => { # 死舞爪
        :word_1 => ["\\n<Alice>Dance in pitch black, the claws of the underworld...!", "alice_fc7", 3],
      },
      [9578] => { # 白天滅牙
        :word_1 => ["\\n<Alice>Pierce the heavens, the fangs of destruction...!", "alice_fc7", 3],
      },
      [9581] => { # 核熱獣乱牙
        :word_1 => ["\\n<Alice>Raging, fangs of nuclear heat!", "alice_fc7", 3],
      },
      [9582] => { # 超魔核熱獣撃
        :word_1 => ["\\n<Alice>The evil beast of nuclear fever will destroy this world!", "alice_fc7", 3],
      },
      [2700] => { # 啼魔咆吼
        :word_1 => ["\\n<Alice>Ohhhh...!!", "alice_fc7", 3],
      },
      [2686] => { # 噛み付き
        :word_1 => ["\\n<Alice>I'll tear you apart with my fangs!", "alice_fc7", 3],
      },
      [2687] => { # 連続噛み付き
        :word_1 => ["\\n<Alice>Shatter with my fangs!", "alice_fc7", 3],
      },
      [2688] => { # 轟連牙
        :word_1 => ["\\n<Alice>Eat it, the fangs of nightmare that will crush everything!", "alice_fc7", 3],
      },
      [2693] => { # 虚牙
        :word_1 => ["\\n<Alice>The fang of nothingness that pierces all things!", "alice_fc7", 3],
      },
      [2691] => { # 絶氷牙
        :word_1 => ["\\n<Alice>My fangs, hold the ice...!", "alice_fc7", 3],
      },
      [2692] => { # 断氷連牙
        :word_1 => ["\\n<Alice>Tear apart, the merciless fangs of ice!", "alice_fc7", 3],
      },
      [9577] => { # 破壊の爪
        :word_1 => ["\\n<Alice>The height of beastliness...claws of destruction!", "alice_fc7", 3],
      },
      [2694] => { # 体当たり
        :word_1 => ["\\n<Alice>hit...haaaa!", "alice_fc7", 3],
      },
      [2695] => { # 大暴れ
        :word_1 => ["\\n<Alice>Defeat all \n!", "alice_fc7", 3],
      },
      [2696] => { # 蹂躙撃
        :word_1 => ["\\n<Alice>He's going to trample me...haaaaaaaaaaaa!", "alice_fc7", 3],
      },
      [2697] => { # 威嚇
        :word_1 => ["\\n<Alice>Hold back \n...!", "alice_fc7", 3],
      },
      [2698] => { # おたけび
        :word_1 => ["\\n<Alice>Ohhhhh...!!", "alice_fc7", 3],
      },
      [2699] => { # 破壊の咆吼
        :word_1 => ["\\n<Alice>Ohhhhh...!!", "alice_fc7", 3],
      },
      [2701] => { # 獣魔合乱撃
        :word_1 => ["\\n<Alice>I will crush you...!　Oh!!", "alice_fc7", 3],
      },
      [2702] => { # 獣魔乱舞
        :word_1 => ["\\n<Alice>Wield the fierce beast to its fullest!", "alice_fc7", 3],
      },
      [2703] => { # 同種殺し
        :word_1 => ["\\n<Alice>Beast, know the power of the Monster Lord...!", "alice_fc7", 3],
      },
      [2712] => { # ベノムアタック
        :word_1 => ["\\n<Alice>Poisonous claws... Ha!", "alice_fc7", 3],
      },
      [2713] => { # ベノンザッパー
        :word_1 => ["\\n<Alice>Experience the poisonous attack for yourself!", "alice_fc7", 3],
      },
      [2715] => { # ベノムグランテ
        :word_1 => ["\\n<Alice>Carve \n, the ultimate poisonous claw!", "alice_fc7", 3],
      },
      [9579] => { # 百魔乱舞
        :word_1 => ["\\n<Alice>Runaway! Bakusou!　Haaaaa!!", "alice_fc7", 3],
      },
      [9580] => { # 空間蹂躙
        :word_1 => ["\\n<Alice>The entire space has been overrun...!", "alice_fc7", 3],
      },
      [2714] => { # ベノムバウンド
        :word_1 => ["\\n<Alice>Mow down, a flash of deadly poison!", "alice_fc7", 3],
      },
      [2716] => { # 尻尾コキ
        :word_1 => ["\\n<Alice>Look, enjoy the pleasure with your tail...!", "alice_fc7", 3],
      },
      [2717] => { # 獣の口淫
        :word_1 => ["\\n<Alice>Come on, taste my oral skills...!", "alice_fc7", 3],
      },
      [2718] => { # ワイルドレイプ
        :word_1 => ["\\n<Alice>I'll rape you like a beast...!", "alice_fc7", 3],
      },
      [2722] => { # ぷにぷに肉球手コキ
        :word_1 => ["\\n<Alice>More squishy paws...♪", "alice_fc8", 1],
      },
      [2723] => { # ざらざら猫舌フェラ
        :word_1 => ["\\n<Alice>A rough tongue must be very irritating...", "alice_fc7", 3],
      },
      [2726] => { # ビーストハウリング
        :word_1 => ["\\n<Alice>Can you see through this behavior?", "alice_fc7", 3],
      },
      [2727] => { # 獣の本能
        :word_1 => ["\\n<Alice>I can't stop myself anymore...!", "alice_fc7", 3],
      },
      [2728] => { # ルナティックハイ
        :word_1 => ["\\n<Alice>Exciting instincts destroy everything...!", "alice_fc7", 3],
      },
      [2729] => { # ジェノサイドハイ
        :word_1 => ["\\n<Alice>Bloody impulse destroys everything...", "alice_fc7", 3],
      },
      [2732] => { # ねこまねき
        :word_1 => ["\\n<Alice>Meow, meow♪", "alice_fc8", 1],
      },
      [2733] => { # ぐっすりにゃんこ
        :word_1 => ["\\n<Alice>I'm going to sleep for a little while...", "alice_fc7", 3],
      },
      [2734] => { # 凍てつく波動
        :word_1 => ["\\n<Alice>That power will erase everything...!", "alice_fc7", 3],
      },
      [2740] => { # 蛇撃
        :word_1 => ["\\n<Alice>Eat it, tail blow!", "alice_fc7", 3],
      },
      [2741] => { # 蛇体薙ぎ
        :word_1 => ["\\n<Alice>mowing down everything with the tail!", "alice_fc7", 3],
      },
      [2742] => { # スネークパニッシャー
        :word_1 => ["\\n<Alice>Let me punish you with my snake body!", "alice_fc7", 3],
      },
      [2743] => { # 蛇王滅誅
        :word_1 => ["\\n<Alice>Shatter into pieces!", "alice_fc7", 3],
      },
      [2744] => { # ラミアロール
        :word_1 => ["\\n<Alice>Look, let's wrap it around us...!", "alice_fc7", 3],
      },
      [2745] => { # ヘビィロール
        :word_1 => ["\\n<Alice>I'll just roll it up like this... Kuku.", "alice_fc7", 3],
      },
      [2746] => { # 悪夢の締め付け
        :word_1 => ["\\n<Alice>Let's squeeze it tight...", "alice_fc7", 3],
      },
      [2747] => { # クィーンズロール
        :word_1 => ["\\n<Alice>Enjoy the Queen's embrace...", "alice_fc7", 3],
      },
      [9591] => { # ミドガルズオルム
        :word_1 => ["\\n<Alice>A great embrace, Midgardsorm...!", "alice_fc7", 3],
      },
      [2748] => { # 丸呑み
        :word_1 => ["\\n<Alice>Look, I'll swallow you whole...", "alice_fc7", 3],
      },
      [2749] => { # 悪夢の踊り食い
        :word_1 => ["\\n<Alice>Be swallowed alive and experience a nightmare...!", "alice_fc7", 3],
      },
      [2750] => { # クィーンズボア
        :word_1 => ["\\n<Alice>Become food for the Queen...", "alice_fc7", 3],
      },
      [9592] => { # ヨルムンガンド
        :word_1 => ["\\n<Alice>Jormungandr devours everything...!", "alice_fc7", 3],
      },
      [2751] => { # 石化撃
        :word_1 => ["\\n<Alice>Turn into stone with this blow...!", "alice_fc7", 3],
      },
      [2752] => { # 石化乱撃
        :word_1 => ["\\n<Alice>It's a petrifying attack...!", "alice_fc7", 3],
      },
      [2755] => { # 蛇尾コキ
        :word_1 => ["\\n<Alice>Look, enjoy the pleasure with your tail...!", "alice_fc7", 3],
      },
      [2756] => { # チロチロフェラ
        :word_1 => ["\\n<Alice>I want you to writhe in agony with this tongue...!", "alice_fc7", 3],
      },
      [2757] => { # ラミアの魔膣
        :word_1 => ["\\n<Alice>Taste my magical vagina...!", "alice_fc7", 3],
      },
      [2758] => { # 聖母蛇の抱擁
        :word_1 => ["\\n<Alice>Come on, I'll hold you gently...", "alice_fc7", 3],
      },
      [2759] => { # 昇天の抱擁
        :word_1 => ["\\n<Alice>Let's end this with your hugs...", "alice_fc7", 3],
      },
      [2760] => { # 稚児搾り
        :word_1 => ["\\n<Alice>Damn, I'll squeeze it gently...", "alice_fc7", 3],
      },
      [2761] => { # 夜叉淫舌
        :word_1 => ["\\n<Alice>I want you to writhe in agony with this tongue...!", "alice_fc7", 3],
      },
      [2762] => { # 包み乳楽
        :word_1 => ["\\n<Alice>Surround yourself with more breasts and immerse yourself in bliss...", "alice_fc7", 3],
      },
      [2763] => { # 蛇夜伽
        :word_1 => ["\\n<Alice>Writhe in agony at the serpent night...!", "alice_fc7", 3],
      },
      [2764] => { # 淫邪の蛇髪
        :word_1 => ["\\n<Alice>I'll devour you with my hair...", "alice_fc7", 3],
      },
      [2765] => { # 淫蛇の蜜壺
        :word_1 => ["\\n<Alice>There's a snake writhing in my meat pot too...", "alice_fc7", 3],
      },
      [2766] => { # 楽園蛇の誘惑
        :word_1 => ["\\n<Alice>The primordial snake, an invitation to corruption...", "alice_fc7", 3],
      },
      [2767] => { # ラミアの祈り
        :word_1 => ["\\n<Alice>My prayers bring healing...!", "alice_fc7", 3],
      },
      [2768] => { # ラミアの寵光
        :word_1 => ["\\n<Alice>Dark Goddess, give me a miracle...!", "alice_fc7", 3],
      },
      [2769] => { # 脱皮
        :word_1 => ["\\n<Alice>Look the other way and let me shed my skin!", "alice_fc7", 3],
      },
      [2775] => { # 触手撃
        :word_1 => ["\\n<Alice>Take a blow from the \n tentacle!", "alice_fc7", 3],
      },
      [2776] => { # 触手乱舞
        :word_1 => ["\\n<Alice>Disturb, my tentacles!", "alice_fc7", 3],
      },
      [2777] => { # テンタクルストーム
        :word_1 => ["\\n<Alice>Eat, a storm of tentacles!", "alice_fc7", 3],
      },
      [2778] => { # 剛触手撃
        :word_1 => ["\\n<Alice>I'll crush you with my tentacles!", "alice_fc7", 3],
      },
      [2779] => { # 乱打触手舞
        :word_1 => ["\\n<Alice>Knock it down with a disordered tentacle!", "alice_fc7", 3],
      },
      [2780] => { # テンタクルレイド
        :word_1 => ["\\n<Alice>mowing down with more tentacles!", "alice_fc7", 3],
      },
      [2781] => { # テンタクルブラスト
        :word_1 => ["\\n<Alice>A blow from the tentacle, it shatters into fine dust!", "alice_fc7", 3],
      },
      [2782] => { # ナノテンタクル
        :word_1 => ["\\n<Alice>Destroy everything with microscopic tentacles...!", "alice_fc7", 3],
      },
      [9596,9604] => { # デミウルゴス
        :word_1 => ["\\n<Alice>Release all tentacles...Release them!", "alice_fc7", 3],
      },
      [2783] => { # 触手拘束
        :word_1 => ["\\n<Alice>Look, let's wind it up with our tentacles!", "alice_fc7", 3],
      },
      [2784] => { # テンタクルバインド
        :word_1 => ["\\n<Alice>Damn, it's wrapped around me with my tentacles!", "alice_fc7", 3],
      },
      [2785] => { # インフェルノバインド
        :word_1 => ["\\n<Alice>Get wrapped up in more tentacles and experience hell...!", "alice_fc7", 3],
      },
      [2786] => { # 蛇縊り
        :word_1 => ["\\n<Alice>This is a tentacle that hangs onto a snake...!", "alice_fc7", 3],
      },
      [2787] => { # ラミアキャプチャー
        :word_1 => ["\\n<Alice>With these tentacles, I will destroy the snake...!", "alice_fc7", 3],
      },
      [2788] => { # 触手愛撫
        :word_1 => ["\\n<Alice>Writhe in pleasure with more tentacles...!", "alice_fc7", 3],
      },
      [2789] => { # 乱れ触手愛撫
        :word_1 => ["\\n<Alice>You tentacles, stop being disturbed!", "alice_fc7", 3],
      },
      [2790] => { # テンタクルワルツ
        :word_1 => ["\\n<Alice>Writhe in agony with the pleasure of the tentacles...!", "alice_fc7", 3],
      },
      [2810] => { # 麻痺触手
        :word_1 => ["\\n<Alice>Get paralyzed by these tentacles!", "alice_fc7", 3],
      },
      [2811] => { # 猛毒触手
        :word_1 => ["\\n<Alice>Get poisoned by this tentacle!", "alice_fc7", 3],
      },
      [2812] => { # 催淫触手
        :word_1 => ["\\n<Alice>Drown in your lust with these tentacles!", "alice_fc7", 3],
      },
      [2813] => { # 即死の触手
        :word_1 => ["\\n<Alice>With these tentacles, you should die in the afterlife!", "alice_fc7", 3],
      },
      [2814] => { # 失禁の触手
        :word_1 => ["\\n<Alice>Don't let this tentacle incontinence you miserably!", "alice_fc7", 3],
      },
      [2815] => { # スミ
        :word_1 => ["\\n<Alice>I'm not an octopus!", "alice_fc7", 3],
      },
      [2816] => { # 闇霧
        :word_1 => ["\\n<Alice>Mist of darkness, close your surroundings!", "alice_fc7", 3],
      },
      [2817] => { # ナイトメアミスト
        :word_1 => ["\\n<Alice>Nightmare fog, bring true darkness!", "alice_fc7", 3],
      },
      [2818] => { # バイオミスト
        :word_1 => ["\\n<Alice>Poisonous fog, close your surroundings!", "alice_fc7", 3],
      },
      [2820] => { # テンタクルアップ
        :word_1 => ["\\n<Alice>Activate the tentacles...!", "alice_fc7", 3],
      },
      [2821] => { # テンタクルハイアップ
        :word_1 => ["\\n<Alice>The tentacles will be further activated...!", "alice_fc7", 3],
      },
      [2822] => { # テンタクルエクスアップ
        :word_1 => ["\\n<Alice>Look, the ultimate tentacle activation!", "alice_fc7", 3],
      },
      [3068] => { # 火の息
        :word_1 => ["\\n<Alice>Get a breath of fire!", "alice_fc7", 3],
      },
      [3070] => { # 激しい炎
        :word_1 => ["\\n<Alice>Get the flame breath!", "alice_fc7", 3],
      },
      [3081] => { # バイオブレス
        :word_1 => ["\\n<Alice>Writhe in agony with the poisonous breath!", "alice_fc7", 3],
      },
      [9697] => { # マグナ・ノヴァ
        :word_1 => ["\\n<Alice>Breath of the Earth... Magna Nova!", "alice_fc7", 3],
      },
      [9696] => { # ガイアブレス
        :word_1 => ["\\n<Alice>The breath of the earth...Gaia's breath!", "alice_fc7", 3],
      },
      [9698] => { # アークブレス
        :word_1 => ["\\n<Alice>Condensed deadly poison...Arc breath!", "alice_fc7", 3],
      },
      [9701] => { # 次元侵蝕ブレス
        :word_1 => ["\\n<Alice>A breath that invades the dimension...!", "alice_fc7", 3],
      },
      [3085] => { # 毒の息
        :word_1 => ["\\n<Alice>Take the poison breath!", "alice_fc7", 3],
      },
      [3086] => { # 甘い息
        :word_1 => ["\\n<Alice>The sweet aroma will lull you to sleep!", "alice_fc7", 3],
      },
      [3087] => { # 焼け付く息
        :word_1 => ["\\n<Alice>Feel numb from the burning breath!", "alice_fc7", 3],
      },
      [3088] => { # 臭い息
        :word_1 => ["\\n<Alice>Struggles and suffers, nightmare breath...", "alice_fc7", 3],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Alice>Let's go, haa...!", "alice_fc7", 3],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Alice>Gather your power...!", "alice_fc7", 3],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Alice>Gather up your spirit...!", "alice_fc7", 3],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Alice>I'll show you my best...!", "alice_fc7", 3],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Alice>Let me show you the final secret technique...!", "alice_fc7", 3],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Alice>Concentrate on my fist...!", "alice_fc7", 3],
      },
      [3100] => { # 裏練気
        :word_1 => ["\\n<Alice>The strength behind it dwells in your fist...!", "alice_fc7", 3],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Alice>My body, harden it like steel!", "alice_fc7", 3],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Alice>The ultimate in concentration, the final effort...!", "alice_fc7", 3],
      },
      [3103] => { # 魔力集中
        :word_1 => ["\\n<Alice>Concentrate your magical power...!", "alice_fc7", 3],
      },
      [9777] => { # ソフィスティケイト
        :word_1 => ["\\n<Alice>Concentrate on one point...Sophisticate!", "alice_fc7", 3],
      },
      [6183] => { # 邪神炎極ノ纏
        :word_1 => ["\\n<Alice>It will burn you down... The ultimate robe of evil divine flame!", "alice_fc7", 3],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Alice>Take a deep breath, huh...", "alice_fc7", 3],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Alice>This is the time for first aid!", "alice_fc7", 3],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Alice>Backwaters are the path to victory!", "alice_fc7", 3],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Alice>From now on, I'm going to go crazy...!", "alice_fc7", 3],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Alice>Let's go... Transform!", "alice_fc7", 3],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Alice>Henshin! Magical☆Alice♪", "alice_fc8", 1],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Alice>Hey, quiet down!", "alice_fc7", 3],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Alice>Reinforcements, gather around me!", "alice_fc7", 3],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Alice>That power will be shattered!", "alice_fc7", 3],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Alice>Spout, geyser!", "alice_fc7", 3],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Alice>Don't move an inch!", "alice_fc7", 3],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Alice>I got it!", "alice_fc7", 3],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Alice>Ufun♪ Sexy beam!", "alice_fc8", 1],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Alice>Ugh♪ Pink Typhoon!", "alice_fc8", 1],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Alice>Ugh♪ Fantastic Hurricane!", "alice_fc8", 1],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Alice>Now, it's my stage!", "alice_fc7", 1],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Alice>I can't accept that more people are working!", "alice_fc7", 3],
      },
      [3161] => { # アビスドレイン
        :word_1 => ["\\n<Alice>It will squeeze out all your spirit...", "alice_fc7", 3],
      },
      [3163] => { # スラッグドレイン
        :word_1 => ["\\n<Alice>It sucks out a lot of your semen...!", "alice_fc7", 3],
      },
      [3164] => { # スラッグボア
        :word_1 => ["\\n<Alice>'s body will melt you...!", "alice_fc7", 3],
      },
      [3166] => { # 毒舌ナメナメ
        :word_1 => ["\\n<Alice>I'll lick you with my poisonous tongue...", "alice_fc7", 3],
      },
      [3167] => { # 軟体ボディ
        :word_1 => ["\\n<Alice>This body will become soft...!", "alice_fc7", 3],
      },
      [3168] => { # 粘液大量分泌
        :word_1 => ["\\n<Alice>This mucus will nullify all impacts...", "alice_fc7", 3],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Alice>Drown in my plump breasts... \n Puff, puff, puff...", "alice_fc7", 3],
      },
      [3555] => { # 誘惑専用
        :word_y1 => ["\\n<Alice>Hmm... this is mine... \n Roll it, roll it...", "alice_fc7", 3],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Alice>Now, show your strength...!", "alice_fc7", 3],
      },
      [9238] => { # うさぎコメット
        :word_1 => ["\\n<Alice>Come, Rabbit's Great Meteorite!", "alice_fc7", 3],
      },
      [1568] => { # アリスインワンダーランド
        :word_1 => ["\\n<Alice>Wonderland...Alice in Wonderland!", "alice_fc7", 3],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Alice>This is the power of grudge...!", "alice_fc7", 3],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Alice>...Blitzkrieg!!", "alice_fc7", 3],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Alice>Prevent evil attacks... Brave Wall!", "alice_fc7", 3],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Alice>I forgive you...", "alice_fc7", 3],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Alice>Look at the miracle of the Holy Grail!", "alice_fc7", 3],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Alice>Look at the power of the aura!", "alice_fc7", 3],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Alice>With the extra power, this is easy!", "alice_fc7", 3],
      },
      [6079] => { # 紅の印
        :word_1 => ["\\n<Alice>The red seal is engraved on your body...!", "alice_fc7", 3],
      },
      [6181] => { # エンドオブドリーム
        :word_1 => ["\\n<Alice>It's good to know the end of the dream...!", "alice_fc7", 3],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Alice>Ha!", "alice_fc7", 3],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Alice>I'll protect you!", "alice_fc7", 3],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Alice>Now, go to the Monster Lord... Assemble!!", "alice_fc7", 3],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Alice>Double up!", "alice_fc7", 3],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Alice>Next action, order!", "alice_fc7", 3],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Alice>The power of elementals...!", "alice_fc7", 3],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Alice>Concentrate your power on one point...!", "alice_fc7", 3],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Alice>■■■■■■■■■■■■■■■...", "alice_fc7", 3],
      },
    },
    9 => { # ワールドブレイカー
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<World Breaker>Break...!", "worldbreaker_fc1", 0],
        :word_2 => ["\\n<World Breaker>Destroy...", "worldbreaker_fc1", 0],
        :word_3 => ["\\n<World Breaker>Disappear...", "worldbreaker_fc1", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<World Breaker>Destroy with this knife...", "worldbreaker_fc1", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<World Breaker>Destroy with this sword...", "worldbreaker_fc1", 0],
      },
      [917] => { # 切り返し
        :word_1 => ["\\n<World Breaker>Cut back...", "worldbreaker_fc1", 0],
      },
      [918] => { # 疾風突き
        :word_1 => ["\\n<World Breaker>Like a gale...", "worldbreaker_fc1", 0],
      },
      [919] => { # 払車剣
        :word_1 => ["\\n<World Breaker>Sword flash, like a wheel...", "worldbreaker_fc1", 0],
      },
      [920] => { # 諸刃斬り
        :word_1 => ["\\n<World Breaker>Blade of Determination...", "worldbreaker_fc1", 0],
      },
      [921] => { # 隼斬り
        :word_1 => ["\\n<World Breaker>Like a falcon...", "worldbreaker_fc1", 0],
      },
      [930] => { # エンジェルダンス
        :word_1 => ["\\n<World Breaker>blade, dance to the heavens...", "worldbreaker_fc1", 0],
      },
      [932] => { # 烈風剣
        :word_1 => ["\\n<World Breaker>Dance, blade of fierce wind...", "worldbreaker_fc1", 0],
      },
      [933] => { # 月影の太刀
        :word_1 => ["\\n<World Breaker>Dance on the moon...", "worldbreaker_fc1", 0],
      },
      [934] => { # 魔神斬り
        :word_1 => ["\\n<World Breaker>Demon God's blow...", "worldbreaker_fc1", 0],
      },
      [935] => { # デッドクラッシュ
        :word_1 => ["\\n<World Breaker>The blade of destruction brings death...", "worldbreaker_fc1", 0],
      },
      [936] => { # 二刀十字斬り
        :word_1 => ["\\n<World Breaker>Double sword flash...", "worldbreaker_fc1", 0],
      },
      [945] => { # 斬魔の舞
        :word_1 => ["\\n<World Breaker>The evil blade that destroys demons...", "worldbreaker_fc1", 0],
      },
      [946] => { # 屠竜撃
        :word_1 => ["\\n<World Breaker>A blow that slaughters the dragon...", "worldbreaker_fc1", 0],
      },
      [947] => { # 雲身払車剣
        :word_1 => ["\\n<World Breaker>Kasumi's blade, like a wheel...", "worldbreaker_fc1", 0],
      },
      [948] => { # 滅世斬
        :word_1 => ["\\n<World Breaker>A dark blade that ends this world...", "worldbreaker_fc1", 0],
      },
      [953] => { # 死剣・乱れ星
        :word_1 => ["\\n<World Breaker>Twinkling meteor sword technique...", "worldbreaker_fc1", 0],
      },
      [954] => { # 魔影流星斬
        :word_1 => ["\\n<World Breaker>A dark meteor falling on the earth...", "worldbreaker_fc1", 0],
      },
      [961] => { # 月下散華
        :word_1 => ["\\n<World Breaker>Spring dies under the moon... Sanka under the moon!", "worldbreaker_fc1", 0],
      },
      [962] => { # 魔刃・雪時雨
        :word_1 => ["\\n<World Breaker>Slash of the endless Rakshasa...", "worldbreaker_fc1", 0],
      },
      [964] => { # ジャスティスヘブン
        :word_1 => ["\\n<World Breaker>Judgment of justice, execution of divine will...", "worldbreaker_fc1", 0],
      },
      [965] => { # 閃殺
        :word_1 => ["\\n<World Breaker>The principle of space-time, the severance is my blade of lightning...", "worldbreaker_fc1", 0],
      },
      [966] => { # 裂空堕天斬
        :word_1 => ["\\n<World Breaker>Shine in the eastern sky, split the sky and fall into heaven...", "worldbreaker_fc1", 0],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :word_1 => ["\\n<World Breaker>Fast like a gale, fast like thunder...! \n Instant strike, gale of thunder!", "worldbreaker_fc1", 0],
      },
      [969] => { # 諸刃微塵斬り
        :word_1 => ["\\n<World Breaker>Even if this body decays... it's a double-edged sword!", "worldbreaker_fc1", 0],
      },
      [9013] => { # 九重の羅刹
        :word_1 => ["\\n<World Breaker>Rakshasa's jaw gate has defeated the army and banished evil...", "worldbreaker_fc1", 0],
      },
      [9022] => { # 天軍の剣
        :word_1 => ["\\n<World Breaker>Accept \n, the holy sword that unites the angel army!", "worldbreaker_fc1", 0],
      },
      [9016] => { # 乱れ雪月花
        :word_1 => ["\\n<World Breaker>Snow dance...Moon shadow...Flowers and scattering...", "worldbreaker_fc1", 0],
      },
      [971] => { # 聖光六閃斬
        :word_1 => ["\\n<World Breaker>Catch \n, a continuous attack of light... Six flashes of holy light!", "worldbreaker_fc1", 0],
      },
      [970] => { # メギドカリバーン
        :word_1 => ["\\n<World Breaker>Mowing down with waves of darkness... Megiddo Caliburn!", "worldbreaker_fc1", 0],
      },
      [9014] => { # メギドカブラ
        :word_1 => ["\\n<World Breaker>This is the ultimate mystery of the magic sword... Megidokabura!", "worldbreaker_fc1", 0],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<World Breaker>Sword, heal...", "worldbreaker_fc1", 0],
      },
      [976] => { # 癒しの剣
        :word_1 => ["\\n<World Breaker>Sword, heal...", "worldbreaker_fc1", 0],
      },
      [977] => { # 奇跡の剣
        :word_1 => ["\\n<World Breaker>Sword, heal...", "worldbreaker_fc1", 0],
      },
      [978] => { # 大奇跡の剣
        :word_1 => ["\\n<World Breaker>Sword, heal...", "worldbreaker_fc1", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<World Breaker>Sword, heal...", "worldbreaker_fc1", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<World Breaker>Now, the blade of destruction...", "worldbreaker_fc1", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<World Breaker>Destroy with this blade...", "worldbreaker_fc1", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<World Breaker>Now, the white blade of destruction...", "worldbreaker_fc1", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<World Breaker>Destroy yourself...", "worldbreaker_fc1", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<World Breaker>Destroy with this spear...", "worldbreaker_fc1", 0],
      },
      [1060] => { # サン・エリアル
        :word_1 => ["\\n<World Breaker>The dazzling spear will ward off endless evil...", "worldbreaker_fc1", 0],
      },
      [1063] => { # サン・ミラージュ
        :word_1 => ["\\n<World Breaker>Dazzling Spear, pierce through evil and show justice...", "worldbreaker_fc1", 0],
      },
      [1075] => { # 螺旋光槍
        :word_1 => ["\\n<World Breaker>Spiral light spear, piercing the evil darkness...", "worldbreaker_fc1", 0],
      },
      [1076] => { # 滅魔閃槍
        :word_1 => ["\\n<World Breaker>A flashing spear that pierces the darkness, bring destruction to all evil...", "worldbreaker_fc1", 0],
      },
      [1077] => { # フォトンランサー
        :word_1 => ["\\n<World Breaker>Destroy evil, holy photons...", "worldbreaker_fc1", 0],
      },
      [1078] => { # ニーベルンヴァレスティ
        :word_1 => ["\\n<World Breaker>The secret technique of evil, carve it into your body...", "worldbreaker_fc1", 0],
      },
      [9054] => { # スターダストエンド
        :word_1 => ["\\n<World Breaker>Shatter, stardust...Stardust End!", "worldbreaker_fc1", 0],
      },
      [9059] => { # 天軍乱槍
        :word_1 => ["\\n<World Breaker>Heavenly Army Leader's Spear Technique... Heavenly Army Spear!", "worldbreaker_fc1", 0],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<World Breaker>Spear, make a miracle happen...", "worldbreaker_fc1", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<World Breaker>Spear, destroy everything...", "worldbreaker_fc1", 0],
      },
      [1092] => { # ハイチャージ
        :word_1 => ["\\n<World Breaker>Energy Charge...", "worldbreaker_fc1", 0],
      },
      [1093] => { # エクセルチャージ
        :word_1 => ["\\n<World Breaker>Maximum energy charge...", "worldbreaker_fc1", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<World Breaker>Destroy with this ax...", "worldbreaker_fc1", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<World Breaker>Axe, dance wildly...", "worldbreaker_fc1", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<World Breaker>Destroy with this club...", "worldbreaker_fc1", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<World Breaker>Destroy with this sickle...", "worldbreaker_fc1", 0],
      },
      [1158] => { # 連斬かまいたち
        :word_1 => ["\\n<World Breaker>Cut and tear, whirlwind sickle...", "worldbreaker_fc1", 0],
      },
      [1169] => { # 死連刃
        :word_1 => ["\\n<World Breaker>The deadly blade overlaps, carving multiple times and dividing the number of lives...", "worldbreaker_fc1", 0],
      },
      [1170] => { # レクイエムリーパー
        :word_1 => ["\\n<World Breaker>Requiem that invites destruction...", "worldbreaker_fc1", 0],
      },
      [9078] => { # 魔神黒鎌
        :word_1 => ["\\n<World Breaker>The devil's sickle combs the soul...!", "worldbreaker_fc1", 0],
      },
      [9080] => { # エンドレスサイズ
        :word_1 => ["\\n<World Breaker>The endless flash of the sickle... Endless size!", "worldbreaker_fc1", 0],
      },
      [9083] => { # エンドオブエンド
        :word_1 => ["\\n<World Breaker>The ultimate end, see it with your own eyes...", "worldbreaker_fc1", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<World Breaker>Don't be fooled by the magic power of the sickle...", "worldbreaker_fc1", 0],
      },
      [9081] => { # 罪と罰
        :word_1 => ["\\n<World Breaker>Dust is dust, crime and punishment...", "worldbreaker_fc1", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<World Breaker>Break it with this arrow...", "worldbreaker_fc1", 0],
      },
      [1196] => { # キューピッドアロー
        :word_1 => ["\\n<World Breaker>Aim for that heart...", "worldbreaker_fc1", 0],
      },
      [1197] => { # オーラスター
        :word_1 => ["\\n<World Breaker>Lost in the stars, arrows of holy flow...", "worldbreaker_fc1", 0],
      },
      [1217] => { # ネビュラリフレクト
        :word_1 => ["\\n<World Breaker>Penetrate \n, Ikusei Ichiya...", "worldbreaker_fc1", 0],
      },
      [1218] => { # コズミックダスト
        :word_1 => ["\\n<World Breaker>Rain from the galaxy...", "worldbreaker_fc1", 0],
      },
      [9098] => { # サウザンドムーン
        :word_1 => ["\\n<World Breaker>Pierce, thousand lights...", "worldbreaker_fc1", 0],
      },
      [9088] => { # アモールレイン
        :word_1 => ["\\n<World Breaker>Rain down, great arrows of love...Amor Rain!", "worldbreaker_fc1", 0],
      },
      [9100] => { # シナイの神火
        :word_1 => ["\\n<World Breaker>The divine flame that burns away evil...the divine fire of Sinai!", "worldbreaker_fc1", 0],
      },
      [9099] => { # イスカリオテの雨
        :word_1 => ["\\n<World Breaker>Rain of Iscariot!", "worldbreaker_fc1", 0],
      },
      [9101] => { # 天上天下唯我独尊
        :word_1 => ["\\n<World Breaker>Let's use the goddess' technique...", "worldbreaker_fc1", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<World Breaker>rains healing arrows...", "worldbreaker_fc1", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<World Breaker>Destroy with this whip...", "worldbreaker_fc1", 0],
      },
      [9114] => { # 黙示の神鞭
        :word_1 => ["\\n<World Breaker>Watch the end with the silent whip...", "worldbreaker_fc1", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<World Breaker>Come, Servant...", "worldbreaker_fc1", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<World Breaker>Destroy with this boomerang...", "worldbreaker_fc1", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<World Breaker>Destroy with this iron ball...", "worldbreaker_fc1", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<World Breaker>This fan...", "worldbreaker_fc1", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<World Breaker>Destroy with this gun...", "worldbreaker_fc1", 0],
      },
      [9147] => { # 跳弾乱舞
        :word_1 => ["\\n<World Breaker>Take it, the ricocheting rainstorm...!", "worldbreaker_fc1", 0],
      },
      [9149] => { # 至高の魔弾
        :word_1 => ["\\n<World Breaker>The supreme magic bullet that pierces everything...", "worldbreaker_fc1", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<World Breaker>Healing Bullet...", "worldbreaker_fc1", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<World Breaker>Dance on the blade...", "worldbreaker_fc1", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<World Breaker>Now, let's cut the chaos...", "worldbreaker_fc1", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<World Breaker>Shatter with this one blow...", "worldbreaker_fc1", 0],
      },
      [9171] => { # アトミックインパクト
        :word_1 => ["\\n<World Breaker>Break with one shot...Atomic Impact!", "worldbreaker_fc1", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<World Breaker>Heal Heavenly Vein...", "worldbreaker_fc1", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<World Breaker>Demonic vein, dwell in your fist...", "worldbreaker_fc1", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<World Breaker>White torrent, heal your injured body...", "worldbreaker_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<World Breaker>White torrent, destroy the darkness...", "worldbreaker_fc1", 0],
      },
      [9188] => { # リリーマルレーン
        :word_1 => ["\\n<World Breaker>Along with the beautiful Yuri...Lily Mar Lane!", "worldbreaker_fc1", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<World Breaker>Immortal high will, bring evil to God's mercy...", "worldbreaker_fc1", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<World Breaker>White torrent, give me power...", "worldbreaker_fc1", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<World Breaker>White torrent, prevent evil power...", "worldbreaker_fc1", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<World Breaker>A white torrent that hates evil, protects evil and exorcises walls...", "worldbreaker_fc1", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<World Breaker>Black torrent, obey my orders...", "worldbreaker_fc1", 0],
      },
      [9209] => { # アシェンライト
        :word_1 => ["\\n<World Breaker>The fallen angel's magical power converts into holy light...\n Turns darkness into light! Ashen Light!", "worldbreaker_fc1", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<World Breaker>The scythe of the god of death that reaps life, invite its soul to the underworld...", "worldbreaker_fc1", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<World Breaker>Black torrent, obey my orders...", "worldbreaker_fc1", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<World Breaker>The peaceful wind of life, blows like a storm of blessings...", "worldbreaker_fc1", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<World Breaker>The torrent of time, follow my will and carve your steps...", "worldbreaker_fc1", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<World Breaker>The torrent of time at \n, distorts space-time and brings destruction...", "worldbreaker_fc1", 0],
      },
      [9232] => { # 妖星乱舞
        :word_1 => ["\\n<World Breaker>Look up, the evil star...Yosei Ranbu!", "worldbreaker_fc1", 0],
      },
      [9236] => { # カオスグラビディ
        :word_1 => ["\\n<World Breaker>Gravitational sickle, crush your body... \n Chaos Gravidy!", "worldbreaker_fc1", 0],
      },
      [9239] => { # 天地崩壊
        :word_1 => ["\\n<World Breaker>Break, world...", "worldbreaker_fc1", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<World Breaker>Time, stop...", "worldbreaker_fc1", 0],
      },
      [1564] => { # カオスタイム
        :word_1 => ["\\n<World Breaker>Time, stop...", "worldbreaker_fc1", 0],
      },
      [1565] => { # カオスドライブ
        :word_1 => ["\\n<World Breaker>Time, stop...", "worldbreaker_fc1", 0],
      },
      [1566] => { # カオスオーバー
        :word_1 => ["\\n<World Breaker>Time freezes...", "worldbreaker_fc1", 0],
      },
      [1567] => { # カオスクロニクル
        :word_1 => ["\\n<World Breaker>At \n, I am...", "worldbreaker_fc1", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<World Breaker>Holy light, dispel the darkness...", "worldbreaker_fc1", 0],
      },
      [1634] => { # 天の雷
        :word_1 => ["\\n<World Breaker>Good anger becomes a hammer and defeats the darkness...", "worldbreaker_fc1", 0],
      },
      [1635] => { # 滅魔の雷
        :word_1 => ["\\n<World Breaker>Hammer's thunder, no evil allowed...", "worldbreaker_fc1", 0],
      },
      [1636] => { # 聖光波
        :word_1 => ["\\n<World Breaker>Holy light, banish evil and destroy evil...", "worldbreaker_fc1", 0],
      },
      [1637] => { # 汚れなき光
        :word_1 => ["\\n<World Breaker>Immaculate light, illuminate the darkness and remove impurity...", "worldbreaker_fc1", 0],
      },
      [1639] => { # イノセントレーザー
        :word_1 => ["\\n<World Breaker>A pure maiden, clears her heart and pierces the darkness...", "worldbreaker_fc1", 0],
      },
      [1640] => { # イノセントジャッジ
        :word_1 => ["\\n<World Breaker>Pure judgment, destroy darkness...", "worldbreaker_fc1", 0],
      },
      [1642] => { # 天罰
        :word_1 => ["\\n<World Breaker>Evil life, destroy it with judgment...", "worldbreaker_fc1", 0],
      },
      [1643] => { # 魔天回帰
        :word_1 => ["\\n<World Breaker>All lives, return to Mother Heaven...", "worldbreaker_fc1", 0],
      },
      [1647] => { # ヤルダバオト
        :word_1 => ["\\n<World Breaker>Demonstrate holy power and destroy divine enemies...", "worldbreaker_fc1", 0],
      },
      [1649] => { # 魔神忌光
        :word_1 => ["\\n<World Breaker>Disappear, the light of the demon...", "worldbreaker_fc1", 0],
      },
      [9270] => { # 魔神輝光
        :word_1 => ["\\n<World Breaker>Disappear, the brilliant light of the devil...", "worldbreaker_fc1", 0],
      },
      [9280] => { # 真・魔神輝光
        :word_1 => ["\\n<World Breaker>Holy element condensation... \n Disappear, the brilliant light of the devil...", "worldbreaker_fc1", 0],
      },
      [9269] => { # リブラ・レイ
        :word_1 => ["\\n<World Breaker>Shoot through \n, Holy Light...", "worldbreaker_fc1", 0],
      },
      [9274] => { # 明けの明星
        :word_1 => ["\\n<World Breaker>....................", "worldbreaker_fc1", 0],
      },
      [9275] => { # 発動：明けの明星
        :word_1 => ["\\n<World Breaker>My mother is the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...!", "worldbreaker_fc1", 0],
      },
      [9273] => { # ホーリーフレア
        :word_1 => ["\\n<World Breaker>Shine the whitest in this world...\n Holy Flare!", "worldbreaker_fc1", 0],
      },
      [9281] => { # 裁きの雷
        :word_1 => ["\\n<World Breaker>Receive \n, divine lightning...", "worldbreaker_fc1", 0],
      },
      [9283] => { # 聖天兎々
        :word_1 => ["\\n<World Breaker>Travelers of time and space, announce the sacred time... Holy Ten Rabbits!", "worldbreaker_fc1", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<World Breaker>Destroy Ahura Mazda...!", "worldbreaker_fc1", 0],
      },
      [9282] => { # ビッグバン
        :word_1 => ["\\n<World Breaker>Everything ends and begins...Big Bang!", "worldbreaker_fc1", 0],
      },
      [9272] => { # 聖雷輪舞
        :word_1 => ["\\n<World Breaker>Spin divine punishment, dance holy lightning...", "worldbreaker_fc1", 0],
      },
      [9276] => { # アトミックヘブン
        :word_1 => ["\\n<World Breaker>All disappear, Atomic Heaven...", "worldbreaker_fc1", 0],
      },
      [9268] => { # 聖天
        :word_1 => ["\\n<World Breaker>Look up at the glorious holy heavens...", "worldbreaker_fc1", 0],
      },
      [9271] => { # 天軍滅雷
        :word_1 => ["\\n<World Breaker>Destroy in the name of the leader of the angel army... Lightning of judgment!", "worldbreaker_fc1", 0],
      },
      [9279] => { # 神の洪水
        :word_1 => ["\\n<World Breaker>Let's wipe out this world...", "worldbreaker_fc1", 0],
      },
      [9291] => { # ガブリエラの大祝福
        :word_1 => ["\\n<World Breaker>Let's give the ultimate blessing...", "worldbreaker_fc1", 0],
      },
      [1670] => { # 瞑想
        :word_1 => ["\\n<World Breaker>....................", "worldbreaker_fc1", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<World Breaker>Holy light, bring healing...", "worldbreaker_fc1", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<World Breaker>Dedicate your life and dispel the darkness...", "worldbreaker_fc1", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<World Breaker>The warrior's soul breathes life again...", "worldbreaker_fc1", 0],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<World Breaker>Angel's Dance...", "worldbreaker_fc1", 0],
      },
      [1668] => { # 夢幻天舞
        :word_1 => ["\\n<World Breaker>Dawn as a clear mirror, Mugen Tenmai...", "worldbreaker_fc1", 0],
      },
      [1669] => { # 堕天舞踏
        :word_1 => ["\\n<World Breaker>Uncut and infallible, Fallen Butoh...", "worldbreaker_fc1", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<World Breaker>....................", "worldbreaker_fc1", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<World Breaker>Darkness, destroy it...!", "worldbreaker_fc1", 0],
      },
      [1675] => { # ダークエターナル
        :word_1 => ["\\n<World Breaker>The black of the end, fill the darkness...", "worldbreaker_fc1", 0],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<World Breaker>In the hour of darkness, cherry blossoms scatter in the dance of flames...", "worldbreaker_fc1", 0],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<World Breaker>In the hour of darkness, being sent and dying is the work of the demon ice...", "worldbreaker_fc1", 0],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<World Breaker>In the hour of darkness, a voice screams in the thunder dust...", "worldbreaker_fc1", 0],
      },
      [1686] => { # 魔神幻舞
        :word_1 => ["\\n<World Breaker>A black night, an hour filled with darkness...", "worldbreaker_fc1", 0],
      },
      [1680] => { # 魔神黒掌
        :word_1 => ["\\n<World Breaker>Black Soul, Demon Time Kiwami...", "worldbreaker_fc1", 0],
      },
      [1689] => { # シャドウフレア
        :word_1 => ["\\n<World Breaker>Shine the blackest in this world... \n Shadow Flare!", "worldbreaker_fc1", 0],
      },
      [1687] => { # ハルマゲドン
        :word_1 => ["\\n<World Breaker>The time when light and darkness end... Armageddon!", "worldbreaker_fc1", 0],
      },
      [1688] => { # 真・魔神黒掌
        :word_1 => ["\\n<World Breaker>The black soul, the ultimate demon time... \n Perish in the darkness, the true demon black palm!", "worldbreaker_fc1", 0],
      },
      [1691] => { # 真・魔神幻舞
        :word_1 => ["\\n<World Breaker>A black night, a time filled with darkness... \n End in foam, the true demon phantom dance!", "worldbreaker_fc1", 0],
      },
      [1690] => { # 裁きの炎
        :word_1 => ["\\n<World Breaker>Burn it down, the flames of judgment...!", "worldbreaker_fc1", 0],
      },
      [1691] => { # ビッグクランチ
        :word_1 => ["\\n<World Breaker>End this world...Big Crunch!", "worldbreaker_fc1", 0],
      },
      [9298] => { # ワールドブレイカー
        :word_1 => ["\\n<World Breaker>Destroy this world...", "worldbreaker_fc1", 0],
      },
      [9294] => { # システム：シルフV2
        :ct_pic => "80_sylph_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<World Breaker>System: Sylph V2... Storm!", "worldbreaker_fc1", 0],
      },
      [9295] => { # ノーム/ガイアGH
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<World Breaker>Gnome/Gaia GH launches...Shake the earth!", "worldbreaker_fc1", 0],
      },
      [9296] => { # ウンディーネレーザー穿式
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<World Breaker>Penetrate \n! Undine laser piercing type!", "worldbreaker_fc1", 0],
      },
      [9297] => { # サラマンダー終式カノン
        :ct_pic => "80_salamander_st02",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<World Breaker>Salamander, burn this world to the ground!", "worldbreaker_fc1", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<World Breaker>The magical power resides in the sword...", "worldbreaker_fc1", 0],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<World Breaker>A sacred power resides in the sword...", "worldbreaker_fc1", 0],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<World Breaker>Deploy the magical protective wall...", "worldbreaker_fc1", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<World Breaker>Sign of Yin and Yang, let me know the truth...", "worldbreaker_fc1", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<World Breaker>A piece of life, sending it is life! \n Slightly carved...", "worldbreaker_fc1", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<World Breaker>Move forward to the left, move to the right and move to the left...The step of the shaman, that is, Yu...", "worldbreaker_fc1", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<World Breaker>Take away \n...", "worldbreaker_fc1", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<World Breaker>This is the essence of a thief...", "worldbreaker_fc1", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<World Breaker>Destroy it later...", "worldbreaker_fc1", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<World Breaker>Shinobi no Jutsu, carve it into your eyes...", "worldbreaker_fc1", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<World Breaker>Waves of healing, pervade thousands of places...", "worldbreaker_fc1", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<World Breaker>Autumn Utsusemi dances in the shadows...", "worldbreaker_fc1", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<World Breaker>Use \n smoke bomb...", "worldbreaker_fc1", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<World Breaker>Pirate's ferocious technique...", "worldbreaker_fc1", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<World Breaker>This is a blow of justice...", "worldbreaker_fc1", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<World Breaker>This is the blow of a magical girl...", "worldbreaker_fc1", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<World Breaker>The witch's abominable curse...", "worldbreaker_fc1", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<World Breaker>Let's use the power of gold...", "worldbreaker_fc1", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<World Breaker>Let me sell this...", "worldbreaker_fc1", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<World Breaker>Use \nItem...", "worldbreaker_fc1", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<World Breaker>Destroy with this card...", "worldbreaker_fc1", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<World Breaker>Win with \n coins...", "worldbreaker_fc1", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<World Breaker>Destroy yourself in the dark game...", "worldbreaker_fc1", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<World Breaker>Tarot, show me your destiny...", "worldbreaker_fc1", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<World Breaker>The Oracle of Ilias...", "worldbreaker_fc1", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<World Breaker>Good luck, \n slot...", "worldbreaker_fc1", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<World Breaker>Compete with \n poker...", "worldbreaker_fc1", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<World Breaker>battle card, draw...", "worldbreaker_fc1", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<World Breaker>The power contained in the playing cards...", "worldbreaker_fc1", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<World Breaker>Shine, lucky star...", "worldbreaker_fc1", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<World Breaker>It's always been my turn...", "worldbreaker_fc1", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<World Breaker>God, please give me the item...", "worldbreaker_fc1", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<World Breaker>Divine dance...", "worldbreaker_fc1", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<World Breaker>That's it! Hustle! Hustle!", "worldbreaker_fc1", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<World Breaker>Divine song...", "worldbreaker_fc1", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<World Breaker>Kira☆", "worldbreaker_fc1", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<World Breaker>Before you destroy it, let's listen to it...", "worldbreaker_fc1", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<World Breaker>Looks like it will be worth destroying...", "worldbreaker_fc1", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<World Breaker>It's not worth destroying...", "worldbreaker_fc1", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<World Breaker>Destroy \n or get money...", "worldbreaker_fc1", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<World Breaker>Destroy \n or else Item...", "worldbreaker_fc1", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<World Breaker>Let's destroy \n together...", "worldbreaker_fc1", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<World Breaker>I will crush you...", "worldbreaker_fc1", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<World Breaker>Leave...", "worldbreaker_fc1", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<World Breaker>Everything will collapse eventually...", "worldbreaker_fc1", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<World Breaker>Regarding the relationship between destruction and reproduction...", "worldbreaker_fc1", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<World Breaker>Tomorrow, this world will collapse.", "worldbreaker_fc1", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<World Breaker>Destroy the world...", "worldbreaker_fc1", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<World Breaker>The power of words...", "worldbreaker_fc1", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<World Breaker>This is the power of science...", "worldbreaker_fc1", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<World Breaker>Prepare for the crisis...", "worldbreaker_fc1", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<World Breaker>Convert energy...", "worldbreaker_fc1", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<World Breaker>Alchemize \nItem...", "worldbreaker_fc1", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<World Breaker>Magic book technique, show your power...", "worldbreaker_fc1", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<World Breaker>Become the \n page...", "worldbreaker_fc1", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<World Breaker>This is the power of Machina...", "worldbreaker_fc1", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<World Breaker>Let's cook divine food...", "worldbreaker_fc1", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<World Breaker>Get the \n ingredients...", "worldbreaker_fc1", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<World Breaker>Taste the divine female...", "worldbreaker_fc1", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<World Breaker>I will now perform surgery...", "worldbreaker_fc1", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<World Breaker>Now, take this medicine...", "worldbreaker_fc1", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<World Breaker>Receive the \n injection...", "worldbreaker_fc1", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<World Breaker>God's judgment with the \n virus...", "worldbreaker_fc1", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<World Breaker>The virtue of labor...", "worldbreaker_fc1", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<World Breaker>Tea is here...", "worldbreaker_fc1", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<World Breaker>Maid Change...", "worldbreaker_fc1", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<World Breaker>Now, it's time to harvest...", "worldbreaker_fc1", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<World Breaker>Take the king's sword with your own body...", "worldbreaker_fc1", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<World Breaker>Experience the magic of the \n king for yourself...", "worldbreaker_fc1", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<World Breaker>Army of destruction, gather here...", "worldbreaker_fc1", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<World Breaker>Come on, ascend to heaven...", "worldbreaker_fc1", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<World Breaker>Bow down to the majesty of destruction...", "worldbreaker_fc1", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<World Breaker>shows the will to destroy...", "worldbreaker_fc1", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<World Breaker>...Blitzkrieg!!", "worldbreaker_fc1", 0],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<World Breaker>Yaaaaa...!", "worldbreaker_fc1", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<World Breaker>This is the sword of the hero...", "worldbreaker_fc1", 0],
      },
      [2433] => { # 我流ファイア斬
        :word_1 => ["\\n<World Breaker>My own flame...", "worldbreaker_fc1", 0],
      },
      [2434] => { # 燃えろ！ぐるぐる斬
        :word_1 => ["\\n<World Breaker>Burn, my fighting spirit...", "worldbreaker_fc1", 0],
      },
      [2435] => { # 妖魔斬
        :word_1 => ["\\n<World Breaker>Defeat evil with the hero's blade...", "worldbreaker_fc1", 0],
      },
      [2436] => { # 不死斬
        :word_1 => ["\\n<World Breaker>Return to dust with the hero's blade...", "worldbreaker_fc1", 0],
      },
      [2437] => { # 烈火天翔閃
        :word_1 => ["\\n<World Breaker>Blade of blazing fire, judge evil...", "worldbreaker_fc1", 0],
      },
      [2438] => { # 紅蓮廻天斬
        :word_1 => ["\\n<World Breaker>Fukisabe, Crimson Blade...", "worldbreaker_fc1", 0],
      },
      [2439] => { # 紅蓮炎舞
        :word_1 => ["\\n<World Breaker>Transform into crimson and dance...", "worldbreaker_fc1", 0],
      },
      [2440] => { # プラズマブレイク
        :word_1 => ["\\n<World Breaker>Dispel the darkness, a flash of electrical charge...", "worldbreaker_fc1", 0],
      },
      [2441] => { # シャドウブレイク
        :word_1 => ["\\n<World Breaker>A blade tainted by darkness...", "worldbreaker_fc1", 0],
      },
      [2444] => { # 烈心聖光斬
        :word_1 => ["\\n<World Breaker>Blade of light, cut the darkness...", "worldbreaker_fc1", 0],
      },
      [2431] => { # シャドウラプソディ
        :word_1 => ["\\n<World Breaker>Dance with the darkness...", "worldbreaker_fc1", 0],
      },
      [2442] => { # グランドリオン
        :word_1 => ["\\n<World Breaker>The blade of justice cuts everything...", "worldbreaker_fc1", 0],
      },
      [2443] => { # ヴェルデリオン
        :word_1 => ["\\n<World Breaker>The fighting spirit of darkness destroys the light... \n With unwavering faith, Veldt Lion...!", "worldbreaker_fc1", 0],
      },
      [2446] => { # アルティメットメサイア
        :word_1 => ["\\n<World Breaker>This is the ultimate salvation... \n Together with the light, the Ultimate Messiah...!", "worldbreaker_fc1", 0],
      },
      [2447] => { # シャドウメサイア
        :word_1 => ["\\n<World Breaker>This is the implied salvation... \n Dance in the darkness, Shadow Messiah...!", "worldbreaker_fc1", 0],
      },
      [2448] => { # エレメント・スピカ
        :word_1 => ["\\n<World Breaker>The power of the four spirits, put it in this arm...", "worldbreaker_fc1", 0],
      },
      [2449] => { # カドラプル・ギガ
        :word_1 => ["\\n<World Breaker>The power of the four spirits... Quadruple Giga!!", "worldbreaker_fc1", 0],
      },
      [2450] => { # 烈心天塵剣
        :word_1 => ["\\n<World Breaker>Righteous light, ominous heavenly dust... \n Now is the time to become one! Retsushin Tenjinken!", "worldbreaker_fc1", 0],
      },
      [2445] => { # 天塵剣
        :word_1 => ["\\n<World Breaker>carved, the blade of heavenly dust...", "worldbreaker_fc1", 0],
      },
      [2451] => { # エンジェルダスト
        :word_1 => ["\\n<World Breaker>Angel turned to dust...", "worldbreaker_fc1", 0],
      },
      [2452] => { # 八夜羅刹斬
        :word_1 => ["\\n<World Breaker>The night of Rakshasa goes around...", "worldbreaker_fc1", 0],
      },
      [2453] => { # 烈心天塵英雄剣
        :word_1 => ["\\n<World Breaker>The ultimate secret of the hero...Resshin Tenjin Hero Sword...", "worldbreaker_fc1", 0],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<World Breaker>Prevent evil attacks...", "worldbreaker_fc1", 0],
      },
      [3005] => { # ナノフレア
        :word_1 => ["\\n<World Breaker>shatters into tiny pieces... Nanoflare!", "worldbreaker_fc1", 0],
      },
      [9546] => { # 黎明の魔眼
        :word_1 => ["\\n<World Breaker>The third eye judges evil...the evil eye of dawn!", "worldbreaker_fc1", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<World Breaker>The black fire of the underworld that judges everything... Stay here!", "worldbreaker_fc1", 0],
      },
      [9639] => { # コキュートス
        :word_1 => ["\\n<World Breaker>Sleep in the eternal ice of the demon world... Cocytus...", "worldbreaker_fc1", 0],
      },
      [9673] => { # 神具XIII:ユダ
        :word_1 => ["\\n<World Breaker>Blow away \n, divine tool Judas!", "worldbreaker_fc1", 0],
      },
      [9674] => { # 特級神具VIII:アグニカノン
        :word_1 => ["\\n<World Breaker>Destroy in flames, Agnicanon...", "worldbreaker_fc1", 0],
      },
      [9675] => { # 特級神具IV:メルクリウス
        :word_1 => ["\\n<World Breaker>Freeze and break, Mercurius...", "worldbreaker_fc1", 0],
      },
      [9676] => { # 特級神具V:エクスパルサー
        :word_1 => ["\\n<World Breaker>Electric shock irradiation, Expulser...", "worldbreaker_fc1", 0],
      },
      [9677] => { # 特級神具IV:ガイアグラビディ
        :word_1 => ["\\n<World Breaker>Crush, Gaia Gravidi!", "worldbreaker_fc1", 0],
      },
      [9678] => { # 特級神具IX:セントフレア
        :word_1 => ["\\n<World Breaker>Pierce, Saint Flare!", "worldbreaker_fc1", 0],
      },
      [9679] => { # エンドフルバースト
        :word_1 => ["\\n<World Breaker>All firearms activated, Endful Burst...", "worldbreaker_fc1", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<World Breaker>Let's take care of \n...", "worldbreaker_fc1", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<World Breaker>Pray to heaven...", "worldbreaker_fc1", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<World Breaker>True power...", "worldbreaker_fc1", 0],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<World Breaker>Accumulate power...", "worldbreaker_fc1", 0],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<World Breaker>Get fired up...", "worldbreaker_fc1", 0],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<World Breaker>Show your full power", "worldbreaker_fc1", 0],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<World Breaker>Let me show you the final secret technique...!", "worldbreaker_fc1", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<World Breaker>Calm your mind and take a deep breath...", "worldbreaker_fc1", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<World Breaker>Calm your mind and take first aid...", "worldbreaker_fc1", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<World Breaker>This is the power of hardship...", "worldbreaker_fc1", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<World Breaker>WOooo...!!", "worldbreaker_fc1", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<World Breaker>Transform with the urge to destroy...!", "worldbreaker_fc1", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<World Breaker>Magical☆Breika...Transformation!", "worldbreaker_fc1", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<World Breaker>The grudge of destruction...", "worldbreaker_fc1", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<World Breaker>Capture \n...", "worldbreaker_fc1", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<World Breaker>Call for reinforcements...", "worldbreaker_fc1", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<World Breaker>Let's steal that power...", "worldbreaker_fc1", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<World Breaker>Intermittent Spring, burst...", "worldbreaker_fc1", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<World Breaker>Calm down...", "worldbreaker_fc1", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<World Breaker>Steal the pants...", "worldbreaker_fc1", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<World Breaker>Uffun♪ Sexy Beam!", "worldbreaker_fc1", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<World Breaker>Ufun♪ Pink Typhoon!", "worldbreaker_fc1", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<World Breaker>Ufun♪ Fantastic Hurricane!", "worldbreaker_fc1", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<World Breaker>Now, it's my stage...", "worldbreaker_fc1", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<World Breaker>Behold the miracle of the Holy Grail...", "worldbreaker_fc1", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<World Breaker>Let's work to our heart's content...", "worldbreaker_fc1", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<World Breaker>Pafupafu, puffafu...", "worldbreaker_fc1", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<World Breaker>The power of this weapon...", "worldbreaker_fc1", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<World Breaker>Let it disappear with the power of the aura...", "worldbreaker_fc1", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<World Breaker>Use \n learning technique...", "worldbreaker_fc1", 0],
      },
      [6173] => { # 量子パルサー
        :word_1 => ["\\n<World Breaker>Destroy in quantum units...Quantum Pulsar!", "worldbreaker_fc1", 0],
      },
      [6183] => { # 胡蝶夢天
        :word_1 => ["\\n<World Breaker>Dream of butterflies...", "worldbreaker_fc1", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<World Breaker>Break...", "worldbreaker_fc1", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<World Breaker>Will you protect it without destroying it...?", "worldbreaker_fc1", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<World Breaker>Assemble...!!", "worldbreaker_fc1", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<World Breaker>Double Up...!", "worldbreaker_fc1", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<World Breaker>next action, order...!", "worldbreaker_fc1", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<World Breaker>The power of the \n elemental...!", "worldbreaker_fc1", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<World Breaker>Concentrate your power on one point...!", "worldbreaker_fc1", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<World Breaker>■■■■■■■■■■■■■■■...", "worldbreaker_fc1", 0],
      },
      [9760] => { # デスジェネシス
        :word_1 => ["\\n<World Breaker>The end is the beginning...Death Genesis!", "worldbreaker_fc1", 0],
      },
      [3284] => { # 誘惑専用
        :word_y1 => ["\\n<World Breaker>....................", "worldbreaker_fc1", 0],
      },
      [4420] => { # サタニックプレジャー
        :ct_pic => "80_alice_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<World Breaker>Let's walk through infinite time together...Alice!", "worldbreaker_fc1", 0],
      },
    },
    10 => { # ジャッジメント
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Judgment>Time of judgment...", "judgement_fc1", 0],
        :word_2 => ["\\n<Judgment>Purify...", "judgement_fc1", 0],
        :word_3 => ["\\n<Judgment>Buy it...", "judgement_fc1", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Judgment>This knife is God's judgment...", "judgement_fc1", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Judgment>This sword is God's judgment...", "judgement_fc1", 0],
      },
      [917] => { # 切り返し
        :word_1 => ["\\n<Judgment>Switchback...", "judgement_fc1", 0],
      },
      [918] => { # 疾風突き
        :word_1 => ["\\n<Judgment>Like a gale...", "judgement_fc1", 0],
      },
      [919] => { # 払車剣
        :word_1 => ["\\n<Judgment>Sword flash, like a wheel...", "judgement_fc1", 0],
      },
      [920] => { # 諸刃斬り
        :word_1 => ["\\n<Judgment>Blade of determination...", "judgement_fc1", 0],
      },
      [921] => { # 隼斬り
        :word_1 => ["\\n<Judgment>Like a falcon...", "judgement_fc1", 0],
      },
      [930] => { # エンジェルダンス
        :word_1 => ["\\n<Judgment>blade, dance to the heavens...", "judgement_fc1", 0],
      },
      [932] => { # 烈風剣
        :word_1 => ["\\n<Judgment>Dance, blade of fierce wind...", "judgement_fc1", 0],
      },
      [933] => { # 月影の太刀
        :word_1 => ["\\n<Judgment>Dance on the moon...", "judgement_fc1", 0],
      },
      [934] => { # 魔神斬り
        :word_1 => ["\\n<Judgment>Demon God's blow...", "judgement_fc1", 0],
      },
      [935] => { # デッドクラッシュ
        :word_1 => ["\\n<Judgment>The blade of destruction brings death...", "judgement_fc1", 0],
      },
      [936] => { # 二刀十字斬り
        :word_1 => ["\\n<Judgment>Double sword flash...", "judgement_fc1", 0],
      },
      [945] => { # 斬魔の舞
        :word_1 => ["\\n<Judgment>The evil blade that destroys demons...", "judgement_fc1", 0],
      },
      [946] => { # 屠竜撃
        :word_1 => ["\\n<Judgment>A blow that slaughters the dragon...", "judgement_fc1", 0],
      },
      [947] => { # 雲身払車剣
        :word_1 => ["\\n<Judgment>Kasumi's blade, like a wheel...", "judgement_fc1", 0],
      },
      [948] => { # 滅世斬
        :word_1 => ["\\n<Judgment>A dark blade that ends this world...", "judgement_fc1", 0],
      },
      [953] => { # 死剣・乱れ星
        :word_1 => ["\\n<Judgment>Twinkling meteor sword technique...", "judgement_fc1", 0],
      },
      [954] => { # 魔影流星斬
        :word_1 => ["\\n<Judgment>A dark meteor falling on the earth...", "judgement_fc1", 0],
      },
      [961] => { # 月下散華
        :word_1 => ["\\n<Judgment>Spring dies under the moon... Sanka under the moon!", "judgement_fc1", 0],
      },
      [962] => { # 魔刃・雪時雨
        :word_1 => ["\\n<Judgment>Slash of the endless Rakshasa...", "judgement_fc1", 0],
      },
      [964] => { # ジャスティスヘブン
        :word_1 => ["\\n<Judgment>Judgment of justice, execution of divine will...", "judgement_fc1", 0],
      },
      [965] => { # 閃殺
        :word_1 => ["\\n<Judgment>The law of space-time, the severance is my blade of lightning...", "judgement_fc1", 0],
      },
      [966] => { # 裂空堕天斬
        :word_1 => ["\\n<Judgment>Shine in the eastern sky, split sky and fall...", "judgement_fc1", 0],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :word_1 => ["\\n<Judgment>Fast like a gale, fast like thunder...", "judgement_fc1", 0],
      },
      [969] => { # 諸刃微塵斬り
        :word_1 => ["\\n<Judgment>Even if this body decays... it's a double-edged sword!", "judgement_fc1", 0],
      },
      [9013] => { # 九重の羅刹
        :word_1 => ["\\n<Judgment>Rakshasa's Chin Gate has defeated the army and banished evil...", "judgement_fc1", 0],
      },
      [9022] => { # 天軍の剣
        :word_1 => ["\\n<Judgment>Accept the holy sword that binds the angel army...", "judgement_fc1", 0],
      },
      [9023] => { # 天軍滅星
        :word_1 => ["\\n<Judgment>Accept the holy sword that binds the angel army...", "judgement_fc1", 0],
      },
      [9016] => { # 乱れ雪月花
        :word_1 => ["\\n<Judgment>Snow dance...Moon shadow...Flowers and scattering...", "judgement_fc1", 0],
      },
      [971] => { # 聖光六閃斬
        :word_1 => ["\\n<Judgment>A continuous attack of light... Six flashes of holy light!", "judgement_fc1", 0],
      },
      [970] => { # メギドカリバーン
        :word_1 => ["\\n<Judgment>Mowing down with waves of darkness... Megiddo Caliburn!", "judgement_fc1", 0],
      },
      [9014] => { # メギドカブラ
        :word_1 => ["\\n<Judgment>This is the ultimate mystery of the magic sword... Megidokabura!", "judgement_fc1", 0],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Judgment>Healing sword, God's blessing...", "judgement_fc1", 0],
      },
      [976] => { # 癒しの剣
        :word_1 => ["\\n<Judgment>Healing sword, God's blessing...", "judgement_fc1", 0],
      },
      [977] => { # 奇跡の剣
        :word_1 => ["\\n<Judgment>Healing sword, a dazzling miracle...", "judgement_fc1", 0],
      },
      [978] => { # 大奇跡の剣
        :word_1 => ["\\n<Judgment>Healing sword, God's miracle...", "judgement_fc1", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Judgment>This sharp sword is God's judgment...", "judgement_fc1", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Judgment>This blade will judge you...", "judgement_fc1", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Judgment>This blade is God's judgment...", "judgement_fc1", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Judgment>This white blade will judge you...", "judgement_fc1", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Judgment>Push yourself...", "judgement_fc1", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Judgment>This spear is God's judgment...", "judgement_fc1", 0],
      },
      [1060] => { # サン・エリアル
        :word_1 => ["\\n<Judgment>The goddess uses her spear to pay off infinite evil...", "judgement_fc1", 0],
      },
      [1063] => { # サン・ミラージュ
        :word_1 => ["\\n<Judgment>Goddess uses a spear to pierce evil and show justice...", "judgement_fc1", 0],
      },
      [1075] => { # 螺旋光槍
        :word_1 => ["\\n<Judgment>Spiral light spear, piercing the evil darkness...", "judgement_fc1", 0],
      },
      [1076] => { # 滅魔閃槍
        :word_1 => ["\\n<Judgment>A flashing spear that pierces the darkness, bringing destruction to all evil...", "judgement_fc1", 0],
      },
      [1077] => { # フォトンランサー
        :word_1 => ["\\n<Judgment>Destroy evil, holy photons...", "judgement_fc1", 0],
      },
      [1078] => { # ニーベルンヴァレスティ
        :word_1 => ["\\n<Judgment>The secret technique of evil, carve it into your body...", "judgement_fc1", 0],
      },
      [9054] => { # スターダストエンド
        :word_1 => ["\\n<Judgment>Shatter, stardust...Stardust end!", "judgement_fc1", 0],
      },
      [9059] => { # 天軍乱槍
        :word_1 => ["\\n<Judgment>This is the spear technique of the leader of the Heavenly Army... Heavenly Army Spear!", "judgement_fc1", 0],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Judgment>Spear, make a miracle happen...", "judgement_fc1", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Judgment>A deadly divine will on the spear...", "judgement_fc1", 0],
      },
      [1092] => { # ハイチャージ
        :word_1 => ["\\n<Judgment>Energy charge...", "judgement_fc1", 0],
      },
      [1093] => { # エクセルチャージ
        :word_1 => ["\\n<Judgment>Maximum energy charge...", "judgement_fc1", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Judgment>This ax is God's judgment...", "judgement_fc1", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Judgment>Ax, show your divine will...", "judgement_fc1", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Judgment>This club is God's judgment...", "judgement_fc1", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Judgment>This sickle is God's judgment...", "judgement_fc1", 0],
      },
      [1158] => { # 連斬かまいたち
        :word_1 => ["\\n<Judgment>Cut and tear, whirlwind sickle...", "judgement_fc1", 0],
      },
      [1169] => { # 死連刃
        :word_1 => ["\\n<Judgment>The deadly blade overlaps, carving multiple times and dividing the number of lives...", "judgement_fc1", 0],
      },
      [1170] => { # レクイエムリーパー
        :word_1 => ["\\n<Judgment>A requiem that invites evil souls...", "judgement_fc1", 0],
      },
      [9078] => { # 魔神黒鎌
        :word_1 => ["\\n<Judgment>A black sickle combs the soul...", "judgement_fc1", 0],
      },
      [9080] => { # エンドレスサイズ
        :word_1 => ["\\n<Judgment>The endless flash of the sickle, the endless size...", "judgement_fc1", 0],
      },
      [9083] => { # エンドオブエンド
        :word_1 => ["\\n<Judgment>The ultimate end, see it with your own eyes...", "judgement_fc1", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Judgment>Don't be fooled by the magic power of the sickle...", "judgement_fc1", 0],
      },
      [9081] => { # 罪と罰
        :word_1 => ["\\n<Judgment>Dust is dust, crime and punishment...", "judgement_fc1", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Judgment>This arrow is God's judgment...", "judgement_fc1", 0],
      },
      [1196] => { # キューピッドアロー
        :word_1 => ["\\n<Judgment>Aim for that heart...", "judgement_fc1", 0],
      },
      [1197] => { # オーラスター
        :word_1 => ["\\n<Judgment>Lost in the stars, arrows of holy flow...", "judgement_fc1", 0],
      },
      [1217] => { # ネビュラリフレクト
        :word_1 => ["\\n<Judgment>Penetrate, Ikusei Ichiya...", "judgement_fc1", 0],
      },
      [1218] => { # コズミックダスト
        :word_1 => ["\\n<Judgment>Rain from the galaxy...", "judgement_fc1", 0],
      },
      [9098] => { # サウザンドムーン
        :word_1 => ["\\n<Judgment>Pierce, thousand lights...", "judgement_fc1", 0],
      },
      [9088] => { # アモールレイン
        :word_1 => ["\\n<Judgment>Rain down, great arrows of love...", "judgement_fc1", 0],
      },
      [9100] => { # シナイの神火
        :word_1 => ["\\n<Judgment>God's flame that burns away evil...", "judgement_fc1", 0],
      },
      [9099] => { # イスカリオテの雨
        :word_1 => ["\\n<Judgment>Rain of Iscariot...", "judgement_fc1", 0],
      },
      [9101] => { # 天上天下唯我独尊
        :word_1 => ["\\n<Judgment>Lady Ilias's power...", "judgement_fc1", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Judgment>rain down healing arrows...", "judgement_fc1", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Judgment>This whip is God's judgment...", "judgement_fc1", 0],
      },
      [9114] => { # 黙示の神鞭
        :word_1 => ["\\n<Judgment>Take the whip of the end with your own body...", "judgement_fc1", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Judgment>Come, servant...", "judgement_fc1", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Judgment>This boomerang is God's judgment...", "judgement_fc1", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Judgment>This iron ball is God's judgment...", "judgement_fc1", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Judgment>This fan is God's judgment...", "judgement_fc1", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Judgment>This gun is God's judgment...", "judgement_fc1", 0],
      },
      [9147] => { # 跳弾乱舞
        :word_1 => ["\\n<Judgment>Receive \n, Ricochet Rainstorm...", "judgement_fc1", 0],
      },
      [9149] => { # 至高の魔弾
        :word_1 => ["\\n<Judgment>The supreme magic bullet that penetrates everything...", "judgement_fc1", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Judgment>Healing Bullet...", "judgement_fc1", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Judgment>God's judgment, rain of blades...", "judgement_fc1", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Judgment>Come on, let's cut the chaos...", "judgement_fc1", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Judgment>This blow is God's judgment...", "judgement_fc1", 0],
      },
      [9171] => { # アトミックインパクト
        :word_1 => ["\\n<Judgment>Break, Atomic Impact...", "judgement_fc1", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Judgment>Heal Heavenly Vein...", "judgement_fc1", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Judgment>Demon vein, reside in your fist...", "judgement_fc1", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Judgment>White torrent, heal your injured body...", "judgement_fc1", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Judgment>Galactic waves, bring the tide of life... \n Cosmo Heal...", "judgement_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Judgment>White torrent, destroy the darkness...", "judgement_fc1", 0],
      },
      [9188] => { # リリーマルレーン
        :word_1 => ["\\n<Judgment>With the beautiful lily... Lily Marlane...", "judgement_fc1", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Judgment>Immortal high will, evil evil to God's mercy...", "judgement_fc1", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Judgment>White torrent, give me power...", "judgement_fc1", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Judgment>White torrent, prevent evil power...", "judgement_fc1", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Judgment>A white torrent that hates evil, protects evil and exorcises walls...", "judgement_fc1", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Judgment>Black torrent, obey my orders...", "judgement_fc1", 0],
      },
      [9209] => { # アシェンライト
        :word_1 => ["\\n<Judgment>The fallen angel's magical power transforms into holy light... \n Turns darkness into light... Ashen Light!", "judgement_fc1", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Judgment>The scythe of the god of death that reaps life, invite its soul to the underworld...", "judgement_fc1", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Judgment>Black torrent, obey my orders...", "judgement_fc1", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Judgment>The peaceful wind of life, blows like a storm of blessings...", "judgement_fc1", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Judgment>The torrent of time at \n, carve out your steps according to my will...", "judgement_fc1", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Judgment>The torrent of time distorts space-time and brings destruction...", "judgement_fc1", 0],
      },
      [9232] => { # 妖星乱舞
        :word_1 => ["\\n<Judgment>Look up, the evil star... Yousei Ranbu...", "judgement_fc1", 0],
      },
      [9236] => { # カオスグラビディ
        :word_1 => ["\\n<Judgment>Scythe of gravity, crush your body... \n Chaos Gravidy...", "judgement_fc1", 0],
      },
      [9239] => { # 天地崩壊
        :word_1 => ["\\n<Judgment>Break, world...", "judgement_fc1", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Judgment>Time, stop...", "judgement_fc1", 0],
      },
      [1564] => { # カオスタイム
        :word_1 => ["\\n<Judgment>Time, stop...", "judgement_fc1", 0],
      },
      [1565] => { # カオスドライブ
        :word_1 => ["\\n<Judgment>Time, stop...", "judgement_fc1", 0],
      },
      [1566] => { # カオスオーバー
        :word_1 => ["\\n<Judgment>: Freeze...", "judgement_fc1", 0],
      },
      [1567] => { # カオスクロニクル
        :word_1 => ["\\n<Judgment>At \n, I am...", "judgement_fc1", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Judgment>Holy light, dispel the darkness...", "judgement_fc1", 0],
      },
      [1634] => { # 天の雷
        :word_1 => ["\\n<Judgment>Good anger becomes a hammer and defeats the darkness...", "judgement_fc1", 0],
      },
      [1635] => { # 滅魔の雷
        :word_1 => ["\\n<Judgment>Hammer's thunder, no evil allowed...", "judgement_fc1", 0],
      },
      [1636] => { # 聖光波
        :word_1 => ["\\n<Judgment>Holy light, banish evil and destroy evil...", "judgement_fc1", 0],
      },
      [1637] => { # 汚れなき光
        :word_1 => ["\\n<Judgment>Immaculate light, illuminate the darkness and remove impurity...", "judgement_fc1", 0],
      },
      [1639] => { # イノセントレーザー
        :word_1 => ["\\n<Judgment>A pure maiden, clears her heart and pierces the darkness...", "judgement_fc1", 0],
      },
      [1640] => { # イノセントジャッジ
        :word_1 => ["\\n<Judgment>Pure judgment, destroy darkness...", "judgement_fc1", 0],
      },
      [1642] => { # 天罰
        :word_1 => ["\\n<Judgment>Evil life, destroy it with judgment...", "judgement_fc1", 0],
      },
      [1643] => { # 魔天回帰
        :word_1 => ["\\n<Judgment>All lives, return to Mother Heaven...", "judgement_fc1", 0],
      },
      [1647] => { # ヤルダバオト
        :word_1 => ["\\n<Judgment>Show your holy power and destroy the divine enemy...", "judgement_fc1", 0],
      },
      [1649] => { # 魔神忌光
        :word_1 => ["\\n<Judgment>Disappear, the light of the devil...", "judgement_fc1", 0],
      },
      [9270] => { # 魔神輝光
        :word_1 => ["\\n<Judgment>Disappear, the shining light of the devil...", "judgement_fc1", 0],
      },
      [9280] => { # 真・魔神輝光
        :word_1 => ["\\n<Judgment>Holy element condensation... \n Disappear, the brilliant light of the devil...", "judgement_fc1", 0],
      },
      [9269] => { # リブラ・レイ
        :word_1 => ["\\n<Judgment>Shoot through \n, Holy Light...", "judgement_fc1", 0],
      },
      [9274] => { # 明けの明星
        :word_1 => ["\\n<Judgment>....................", "judgement_fc1", 0],
      },
      [9275] => { # 発動：明けの明星
        :word_1 => ["\\n<Judgment>My mother is the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...!", "judgement_fc1", 0],
      },
      [9277] => { # 明星魔煌
        :word_1 => ["\\n<Judgment>....................", "judgement_fc1", 0],
      },
      [9278] => { # 明星魔煌
        :word_1 => ["\\n<Judgment>I am the morning star, the child of the dawn... \n The star that fell to the earth, the one who gains victory...", "judgement_fc1", 0],
      },
      [9273] => { # ホーリーフレア
        :word_1 => ["\\n<Judgment>Shine the whitest in this world... \n Holy Flare!", "judgement_fc1", 0],
      },
      [9281] => { # 裁きの雷
        :word_1 => ["\\n<Judgment>Receive the thunder of divine will...!", "judgement_fc1", 0],
      },
      [9282] => { # ビッグバン
        :word_1 => ["\\n<Judgment>Everything ends and begins...Big Bang!", "judgement_fc1", 0],
      },
      [9283] => { # 聖天兎々
        :word_1 => ["\\n<Judgment>Travelers of time and space, announce the sacred time... Holy Heaven Rabbits...", "judgement_fc1", 0],
      },
      [9284] => { # アフラ・マズダ
        :word_1 => ["\\n<Judgment>Ahura Mazda, behold the light of God...", "judgement_fc1", 0],
      },
      [9272] => { # 聖雷輪舞
        :word_1 => ["\\n<Judgment>Spin divine punishment, dance holy lightning...", "judgement_fc1", 0],
      },
      [9276] => { # アトミックヘブン
        :word_1 => ["\\n<Judgment>All disappear, Atomic Heaven...", "judgement_fc1", 0],
      },
      [9285] => { # ジャッジメント
        :word_1 => ["\\n<Judgment>The promised land rejects you. \n In the hands of this judge, the execution will be carried out...", "judgement_fc1", 0],
      },
      [9268] => { # 聖天
        :word_1 => ["\\n<Judgment>Look up at the glorious holy heavens...", "judgement_fc1", 0],
      },
      [9271] => { # 天軍滅雷
        :word_1 => ["\\n<Judgment>Destroy in the name of the leader of the angel army... the thunder of judgment...", "judgement_fc1", 0],
      },
      [9279] => { # 神の洪水
        :word_1 => ["\\n<Judgment>Let's cleanse this world with God's flood...", "judgement_fc1", 0],
      },
      [9291] => { # ガブリエラの大祝福
        :word_1 => ["\\n<Judgment>Let's give the ultimate blessing...", "judgement_fc1", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Judgment>Holy light, bring healing...", "judgement_fc1", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Judgment>Dedicate your life and dispel the darkness...", "judgement_fc1", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Judgment>The warrior's soul breathes life again...", "judgement_fc1", 0],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Judgment>Angel's Dance...", "judgement_fc1", 0],
      },
      [1668] => { # 夢幻天舞
        :word_1 => ["\\n<Judgment>The clear mirror, the dawn, the dreamy heavenly dance...", "judgement_fc1", 0],
      },
      [1669] => { # 堕天舞踏
        :word_1 => ["\\n<Judgment>Uncut and infallible, Fallen Butoh...", "judgement_fc1", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Judgment>....................", "judgement_fc1", 0],
      },
      [1670] => { # 瞑想
        :word_1 => ["\\n<Judgment>....................", "judgement_fc1", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Judgment>Abominable dark power...", "judgement_fc1", 0],
      },
      [1675] => { # ダークエターナル
        :word_1 => ["\\n<Judgment>The black of the end, fill the darkness...", "judgement_fc1", 0],
      },
      [1676] => { # 魔人炎舞
        :word_1 => ["\\n<Judgment>In the hour of darkness, cherry blossoms scatter in the dance of flames...", "judgement_fc1", 0],
      },
      [1677] => { # 魔氷葬
        :word_1 => ["\\n<Judgment>In the hour of darkness, being sent and dying is the work of demon ice...", "judgement_fc1", 0],
      },
      [1678] => { # 魔雷塵
        :word_1 => ["\\n<Judgment>In the hour of darkness, a voice screams in the thunder dust...", "judgement_fc1", 0],
      },
      [1686] => { # 魔神幻舞
        :word_1 => ["\\n<Judgment>A black night, an hour filled with darkness...", "judgement_fc1", 0],
      },
      [1680] => { # 魔神黒掌
        :word_1 => ["\\n<Judgment>Black Soul, Demon Time Kiwami...", "judgement_fc1", 0],
      },
      [1689] => { # シャドウフレア
        :word_1 => ["\\n<Judgment>Shine the blackest in this world... \n Shadow Flare!", "judgement_fc1", 0],
      },
      [1687] => { # ハルマゲドン
        :word_1 => ["\\n<Judgment>The time when light and darkness end... Armageddon!", "judgement_fc1", 0],
      },
      [1688] => { # 真・魔神黒掌
        :word_1 => ["\\n<Judgment>The black soul, the ultimate demonic moment... \n Perish in the darkness, the true demon black palm...", "judgement_fc1", 0],
      },
      [1691] => { # 真・魔神幻舞
        :word_1 => ["\\n<Judgment>A black night, a time filled with darkness... \n End in foam, the true demon phantom dance...", "judgement_fc1", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Judgment>The power of magic resides in the sword...", "judgement_fc1", 0],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<Judgment>Dwell in the sword, divine power...", "judgement_fc1", 0],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Judgment>Deploy the magical protective wall...", "judgement_fc1", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Judgment>The sign of Yin and Yang, let me know the truth...", "judgement_fc1", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Judgment>A piece of life, sending it is life! \n Engraving a minute...", "judgement_fc1", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Judgment>Move forward to the left, move to the right, move to the left...The step of the shaman, that is, Yu...", "judgement_fc1", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Judgment>Requisition...", "judgement_fc1", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Judgment>This is the essence of a thief...", "judgement_fc1", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Judgment>Showing your back...", "judgement_fc1", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Judgment>Ninja Jutsu, carve it into your eyes...", "judgement_fc1", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Judgment>Healing waves, pervade thousands of places...", "judgement_fc1", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Judgment>Autumn Utsusemi dances in the shadows...", "judgement_fc1", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Judgment>Use \n smoke bomb...", "judgement_fc1", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Judgment>Pirate's ferocious technique...", "judgement_fc1", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Judgment>This is a blow of justice...", "judgement_fc1", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Judgment>This is the blow of a magical girl...", "judgement_fc1", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Judgment>The witch's abominable curse...", "judgement_fc1", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Judgment>Let's use the power of gold...", "judgement_fc1", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Judgment>Let me sell this...", "judgement_fc1", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Judgment>Use \nItem...", "judgement_fc1", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Judgment>Receive the judgment of the \n card...", "judgement_fc1", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Judgment>Win with \n coins...", "judgement_fc1", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Judgment>Now, let's play a dark game...", "judgement_fc1", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Judgment>Tarot, show me your destiny...", "judgement_fc1", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Judgment>The oracle of Ilias...", "judgement_fc1", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Judgment>Good luck, \n slot...", "judgement_fc1", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Judgment>Compete in poker...", "judgement_fc1", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Judgment>battle card, draw...", "judgement_fc1", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Judgment>The power contained in the \n playing card...", "judgement_fc1", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Judgment>Shine, your lucky star...", "judgement_fc1", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Judgment>It's always been my turn...", "judgement_fc1", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Judgment>God, please give me an item...", "judgement_fc1", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Judgment>Divine dance...", "judgement_fc1", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Judgment>That's it! Hustle! Hustle!", "judgement_fc1", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Judgment>A divine song...", "judgement_fc1", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Judgment>Kira☆", "judgement_fc1", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Judgment>Before the judgment, let's hear the story...", "judgement_fc1", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Judgment>Advance on the glorious path...", "judgement_fc1", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Judgment>Go to hell...", "judgement_fc1", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Judgment>Judgment or money...", "judgement_fc1", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Judgment>Judgment or Item...", "judgement_fc1", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Judgment>Come with God...", "judgement_fc1", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Judgment>You'll fall into hell...", "judgement_fc1", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Judgment>Leave...", "judgement_fc1", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Judgment>Everything will be enveloped in light...", "judgement_fc1", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Judgment>Let's talk about reproduction controlled by God.", "judgement_fc1", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Judgment>Let's talk about dark reproduction.", "judgement_fc1", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Judgment>Let's talk about the reproduction of clergy.", "judgement_fc1", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Judgment>The Spirit of God...", "judgement_fc1", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Judgment>This is the power of science...", "judgement_fc1", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Judgment>Prepare for the crisis...", "judgement_fc1", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Judgment>Convert energy...", "judgement_fc1", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Judgment>Alchemize \nItem...", "judgement_fc1", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Judgment>Magic book art, show your power...", "judgement_fc1", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Judgment>Become page \n...", "judgement_fc1", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Judgment>This is the power of Machina...", "judgement_fc1", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Judgment>Let's cook divine food...", "judgement_fc1", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Judgment>Get the \n ingredients...", "judgement_fc1", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Judgment>Taste the divine female...", "judgement_fc1", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Judgment>I will now perform surgery...", "judgement_fc1", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Judgment>Now, take this medicine...", "judgement_fc1", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Judgment>Receive the injection...", "judgement_fc1", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Judgment>God's judgment with the \n virus...", "judgement_fc1", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Judgment>The virtue of labor...", "judgement_fc1", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Judgment>Tea is here...", "judgement_fc1", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Judgment>Maid Change...", "judgement_fc1", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Judgment>Now, it's time to harvest...", "judgement_fc1", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Judgment>Take the king's sword with your own body...", "judgement_fc1", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Judgment>Experience the king's magic for yourself...", "judgement_fc1", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Judgment>God's army, gather here...", "judgement_fc1", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Judgment>Now, ascend to heaven...", "judgement_fc1", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Judgment>Bow down to the majesty of God...", "judgement_fc1", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Judgment>Showing God's miracle...", "judgement_fc1", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Judgment>...Blitzkrieg!!", "judgement_fc1", 0],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Judgment>Yaaaaa...!", "judgement_fc1", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Judgment>This is the sword of the hero...", "judgement_fc1", 0],
      },
      [2433] => { # 我流ファイア斬
        :word_1 => ["\\n<Judgment>My own flame...", "judgement_fc1", 0],
      },
      [2434] => { # 燃えろ！ぐるぐる斬
        :word_1 => ["\\n<Judgment>Burn, my fighting spirit...", "judgement_fc1", 0],
      },
      [2435] => { # 妖魔斬
        :word_1 => ["\\n<Judgment>Defeat evil with the hero's blade...", "judgement_fc1", 0],
      },
      [2436] => { # 不死斬
        :word_1 => ["\\n<Judgment>Return to dust with the hero's blade...", "judgement_fc1", 0],
      },
      [2437] => { # 烈火天翔閃
        :word_1 => ["\\n<Judgment>Blade of blazing fire, judge evil...", "judgement_fc1", 0],
      },
      [2438] => { # 紅蓮廻天斬
        :word_1 => ["\\n<Judgment>Blowing Sabe, Crimson Blade...", "judgement_fc1", 0],
      },
      [2439] => { # 紅蓮炎舞
        :word_1 => ["\\n<Judgment>Transform into a crimson lotus and dance...", "judgement_fc1", 0],
      },
      [2440] => { # プラズマブレイク
        :word_1 => ["\\n<Judgment>Dispel the darkness, a flash of electrical charge...", "judgement_fc1", 0],
      },
      [2441] => { # シャドウブレイク
        :word_1 => ["\\n<Judgment>A blade tainted by darkness...", "judgement_fc1", 0],
      },
      [2444] => { # 烈心聖光斬
        :word_1 => ["\\n<Judgment>Blade of light, cut off the darkness...", "judgement_fc1", 0],
      },
      [2431] => { # シャドウラプソディ
        :word_1 => ["\\n<Judgment>Dance with the darkness...", "judgement_fc1", 0],
      },
      [2442] => { # グランドリオン
        :word_1 => ["\\n<Judgment>The blade of justice cuts everything...", "judgement_fc1", 0],
      },
      [2443] => { # ヴェルデリオン
        :word_1 => ["\\n<Judgment>The fighting spirit of darkness destroys the light... \n With unwavering faith... Veldt Lion...!", "judgement_fc1", 0],
      },
      [2446] => { # アルティメットメサイア
        :word_1 => ["\\n<Judgment>This is the ultimate salvation... \n Along with the light, the Ultimate Messiah...!", "judgement_fc1", 0],
      },
      [2447] => { # シャドウメサイア
        :word_1 => ["\\n<Judgment>This is the implied salvation... \n Dance in the darkness, Shadow Messiah...!", "judgement_fc1", 0],
      },
      [2448] => { # エレメント・スピカ
        :word_1 => ["\\n<Judgment>Put the power of the four spirits into this arm...", "judgement_fc1", 0],
      },
      [2449] => { # カドラプル・ギガ
        :word_1 => ["\\n<Judgment>The power of the four spirits... Quadruple Giga!!", "judgement_fc1", 0],
      },
      [2450] => { # 烈心天塵剣
        :word_1 => ["\\n<Judgment>Righteous light, calamitous heaven dust... \n Now is the time to unite, fierce spirit heaven dust sword...", "judgement_fc1", 0],
      },
      [2445] => { # 天塵剣
        :word_1 => ["\\n<Judgment>carved, the blade of heavenly dust...", "judgement_fc1", 0],
      },
      [2451] => { # エンジェルダスト
        :word_1 => ["\\n<Judgment>Angel turned to dust...", "judgement_fc1", 0],
      },
      [2452] => { # 八夜羅刹斬
        :word_1 => ["\\n<Judgment>The night of Rakshasa goes around...", "judgement_fc1", 0],
      },
      [2453] => { # 烈心天塵英雄剣
        :word_1 => ["\\n<Judgment>The ultimate secret of the hero...Resshin Tenjin Hero Sword...", "judgement_fc1", 0],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Judgment>Prevent evil attacks...", "judgement_fc1", 0],
      },
      [9546] => { # 黎明の魔眼
        :word_1 => ["\\n<Judgment>The third eye judges evil... The evil eye of dawn!", "judgement_fc1", 0],
      },
      [9607] => { # 
        :word_1 => ["\\n<Judgment>Let's show our will with the infallible wind...", "judgement_fc1", 0],
      },
      [3049] => { # 
        :word_1 => ["\\n<Judgment>Flood of judgment, Tidal wave...", "judgement_fc1", 0],
      },
      [9685] => { # 
        :word_1 => ["\\n<Judgment>Can you hear the stars crying...", "judgement_fc1", 0],
      },
      [9637] => { # 冥府の業火
        :word_1 => ["\\n<Judgment>The black fire of the underworld that judges everything... Stay here!", "judgement_fc1", 0],
      },
      [9639] => { # コキュートス
        :word_1 => ["\\n<Judgment>Sleep in the eternal ice of the demon world... Cocytus...", "judgement_fc1", 0],
      },
      [9673] => { # 神具XIII:ユダ
        :word_1 => ["\\n<Judgment>Blow away, divine tool Juda...", "judgement_fc1", 0],
      },
      [9674] => { # 特級神具VIII:アグニカノン
        :word_1 => ["\\n<Judgment>Destroy in flames, Agnicanon...", "judgement_fc1", 0],
      },
      [9675] => { # 特級神具IV:メルクリウス
        :word_1 => ["\\n<Judgment>Freeze and break, Mercurius...", "judgement_fc1", 0],
      },
      [9676] => { # 特級神具V:エクスパルサー
        :word_1 => ["\\n<Judgment>Electric shock irradiation, Expulser...", "judgement_fc1", 0],
      },
      [9677] => { # 特級神具IV:ガイアグラビディ
        :word_1 => ["\\n<Judgment>Destroy, Gaia Gravidi...", "judgement_fc1", 0],
      },
      [9678] => { # 特級神具IX:セントフレア
        :word_1 => ["\\n<Judgment>Penetrate, Saint Flair...", "judgement_fc1", 0],
      },
      [9679] => { # エンドフルバースト
        :word_1 => ["\\n<Judgment>All firearms activated, Endful Burst...", "judgement_fc1", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Judgment>Let's take care of \n...", "judgement_fc1", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Judgment>Pray to heaven...", "judgement_fc1", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Judgment>True power...", "judgement_fc1", 0],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Judgment>Accumulate power...", "judgement_fc1", 0],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Judgment>Get fired up...", "judgement_fc1", 0],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Judgment>Show your full power", "judgement_fc1", 0],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Judgment>Let me show you the final secret technique...", "judgement_fc1", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Judgment>The power of elemental...", "judgement_fc1", 0],
      },
      [3110] => { # イリアス
        :ct_pic => "80_iriasu_st41",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Judgment>Behold the power of God... \n Come, Ilias!", "judgement_fc1", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Judgment>Calm your mind and take a deep breath...", "judgement_fc1", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Judgment>Calm your mind and take first aid...", "judgement_fc1", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Judgment>This is the power of predicament...", "judgement_fc1", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Judgment>WOooo...!!", "judgement_fc1", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Judgment>Transform with the power of God!", "judgement_fc1", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Judgment>Magical☆Judgment...Transformation!", "judgement_fc1", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Judgment>Abominable grudge...", "judgement_fc1", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Judgment>Capture \n...", "judgement_fc1", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Judgment>Call for reinforcements...", "judgement_fc1", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Judgment>Let's steal that power...", "judgement_fc1", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Judgment>Intermittent Spring, play...", "judgement_fc1", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Judgment>Calm down...", "judgement_fc1", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Judgment>Requisition of \n pants...", "judgement_fc1", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Judgment>Uffun♪ Sexy beam!", "judgement_fc1", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Judgment>Ufun♪ Pink Typhoon!", "judgement_fc1", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Judgment>Umph♪ Fantastic Hurricane...", "judgement_fc1", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Judgment>Now, it's my stage...", "judgement_fc1", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Judgment>Behold the miracle of the Holy Grail...", "judgement_fc1", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Judgment>Let's work to our heart's content...", "judgement_fc1", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Judgment>Pafupafu, puffafu...", "judgement_fc1", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Judgment>The power of this weapon...", "judgement_fc1", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Judgment>The power of aura...", "judgement_fc1", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Judgment>Should I use the monster's technique...", "judgement_fc1", 0],
      },
      [6174] => { # 十次元圧縮
        :word_1 => ["\\n<Judgment>If you fold the dimension... it's like this.", "judgement_fc1", 0],
      },
      [6183] => { # 胡蝶夢天
        :word_1 => ["\\n<Judgment>Dream of butterflies...", "judgement_fc1", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Judgment>shield blow...", "judgement_fc1", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Judgment>protect...", "judgement_fc1", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Judgment>Assemble...!!", "judgement_fc1", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Judgment>Double up...!", "judgement_fc1", 0],
      },
      [3284] => { # 誘惑専用
        :word_y1 => ["\\n<Judgment>....................", "judgement_fc1", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Judgment>Next action, order...!", "judgement_fc1", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Judgment>Concentrate your power on one point...", "judgement_fc1", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Judgment>■■■■■■■■■■■■■■■...", "judgement_fc1", 0],
      },
      [9760] => { # デスジェネシス
        :word_1 => ["\\n<Judgment>The end is the beginning...Death Genesis!", "judgement_fc1", 0],
      },
      [4421] => { # アストラル666
        :word_1 => ["\\n<Judgment>Astral 666...", "judgement_fc1", 0],
      },
      [4422] => { # 心ない天使
        :word_1 => ["\\n<Judgment>Heartless angel...", "judgement_fc1", 0],
      },
    },
    12 => { # シルフ
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Sylph>Ei!", "sylph_fc1", 0],
        :word_2 => ["\\n<Sylph>Ya!", "sylph_fc1", 0],
        :word_3 => ["\\n<Sylph>Yay!", "sylph_fc1", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Sylph>It's a knife! Oh no!", "sylph_fc1", 0],
      },
      [901] => { # ナイフ投げ
        :word_1 => ["\\n<Sylph>Here's a knife throw! Eiyaa!", "sylph_fc1", 0],
      },
      [902] => { # 連続ナイフ投げ
        :word_1 => ["\\n<Sylph>A rapid knife throw! Ei, ei, eii!", "sylph_fc1", 0],
      },
      [904] => { # トリックナイフ
        :word_1 => ["\\n<Sylph>MysssteeeriOooous knife♪　Eiyaa!", "sylph_fc1", 0],
      },
      [905] => { # アサシンスロー
        :word_1 => ["\\n<Sylph>Scaaaary knife! Shya!", "sylph_fc1", 0],
      },
      [907] => { # アサシンダンス
        :word_1 => ["\\n<Sylph>Fluttering towards the next world! Assassin Dance!", "sylph_fc1", 0],
      },
      [908] => { # ナイフインフィニティ
        :word_1 => ["\\n<Sylph>I'm going to throw lots... Knife Infinity!", "sylph_fc1", 0],
      },
      [911] => { # アサシンストーム
        :word_1 => ["\\n<Sylph>It's an underworld storm! Assassin Storm!", "sylph_fc1", 0],
      },
      [9002] => { # 絶命
        :word_1 => ["\\n<Sylph>Hey, give it to me!", "sylph_fc1", 0],
      },
      [912] => { # イオンストリーク
        :word_1 => ["\\n<Sylph>The ion blade is torn! Ion streak!", "sylph_fc1", 0],
      },
      [9003] => { # 雷旺
        :word_1 => ["\\n<Sylph>Endless and final lightning? ...Rai Wang!", "sylph_fc1", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Sylph>sword! Yes!", "sylph_fc1", 0],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Sylph>Healing sword, heaven's protection!", "sylph_fc1", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Sylph>Rapier! Yes!", "sylph_fc1", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Sylph>I entrust the spirit's pride to my rapier♪", "sylph_fc1", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Sylph>Tsujigiri is fun♪", "sylph_fc1", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Sylph>I'll bet my pride!", "sylph_fc1", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Sylph>My stomach is full!", "sylph_fc1", 2],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Sylph>It's a spear! Yes!", "sylph_fc1", 0],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Sylph>It's the miracle of the spear~♪", "sylph_fc1", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Sylph>Give me the power of the spear♪", "sylph_fc1", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Sylph>It's an ax!　Come on!", "sylph_fc1", 0],
      },
      [1099] => { # 暴塵斧
        :word_1 => ["\\n<Sylph>A violent axe! Whaaam!", "sylph_fc1", 0],
      },
      [1106] => { # 轟炎斧
        :word_1 => ["\\n<Sylph>It's a fiery axe! Whaaam!", "sylph_fc1", 0],
      },
      [1109] => { # 轟炎乱斧
        :word_1 => ["\\n<Sylph>It's a fiery axe! Run wiiiild!!", "sylph_fc1", 0],
      },
      [1115] => { # 微塵連斧
        :word_1 => ["\\n<Sylph>Let's go! Axe slaughter incident: Sylph edition!", "sylph_fc1", 0],
      },
      [1117] => { # タイタンズレガシー
        :word_1 => ["\\n<Sylph>I'm going with a bang! Titans Legacy!", "sylph_fc1", 0],
      },
      [9065] => { # コスモレガシー
        :word_1 => ["\\n<Sylph>I'm going with a bang! Cosmo Legacy!", "sylph_fc1", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Sylph>Let's begin! The axe festival!", "sylph_fc1", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Sylph>It's a club! Zudon!", "sylph_fc1", 0],
      },
      [1128] => { # 旋棍一閃撃
        :word_1 => ["\\n<Sylph>A swift club! swoooosh!!", "sylph_fc1", 0],
      },
      [1131] => { # 轟氷撃
        :word_1 => ["\\n<Sylph>With a cracking strike, baaam!", "sylph_fc1", 0],
      },
      [1137] => { # スライム潰し
        :word_1 => ["\\n<Sylph>I'm sOooorry, miss slime! Wham!", "sylph_fc1", 0],
      },
      [1145] => { # 鬼神乱破
        :word_1 => ["\\n<Sylph>Just like Miss Oni, bam-bam-baaam!", "sylph_fc1", 0],
      },
      [9070] => { # 土精大乱撃
        :word_1 => ["\\n<Sylph>Like a gnome... a great attack on the earth spirits!", "sylph_fc1", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Sylph>It's a sickle! Shakin!", "sylph_fc1", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Sylph>Mysterious Sickle Magic! Nyonyonyon!", "sylph_fc1", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Sylph>It's a bow!　Shuba!", "sylph_fc1", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Sylph>Healing arrow, zaza!", "sylph_fc1", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Sylph>Whip! Sssssssssssssssss!", "sylph_fc1", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Sylph>Come, my servant~♪", "sylph_fc1", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Sylph>Boomerang! Hyuu!", "sylph_fc1", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Sylph>It's an iron ball! Zugan!", "sylph_fc1", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Sylph>It's a fan! Basshu!", "sylph_fc1", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Sylph>gun! Bakyuun!", "sylph_fc1", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Sylph>Healing bullet... Bakyuun!", "sylph_fc1", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Sylph>continuous attack!　Zuba zu ba zu ba!", "sylph_fc1", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Sylph>I'll kill you right away! Zuba Zuba Time!", "sylph_fc1", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Sylph>It's Sylph Kempo! Yay!", "sylph_fc1", 0],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Sylph>Sylph Kairaku Kenpo! Meow meow!", "sylph_fc1", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Sylph>Hang in there! Wind chakra!", "sylph_fc1", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Sylph>Attribute Power, Panchi!", "sylph_fc1", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Sylph>Healing magic! Yes!", "sylph_fc1", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Sylph>Galactic waves, the power of healing! \n Cosmo Heal!", "sylph_fc1", 0],
      },
      [1460] => { # ヒール
        :word_1 => ["\\n<Sylph>Tranquil winds, heal their body!\nHeal!", "sylph_fc1", 0],
      },
      [1461] => { # メガヒール
        :word_1 => ["\\n<Sylph>Wave of life, breathe your deep breath!\nMega Heal!", "sylph_fc1", 0],
      },
      [1462] => { # オールヒール
        :word_1 => ["\\n<Sylph>Tranquil winds, heal us with your great power!\nMass Heal!", "sylph_fc1", 0],
      },
      [1463] => { # オールメガヒール
        :word_1 => ["\\n<Sylph>Wave of life, become a storm!\nMass Mega Heal!", "sylph_fc1", 0],
      },
      [1464] => { # キュア
        :word_1 => ["\\n<Sylph>Greaaat winds of serenity, relieve their ailing body! Cure!", "sylph_fc1", 0],
      },
      [1465] => { # オールキュア
        :word_1 => ["\\n<Sylph>Greaaat winds of serenity, relieve us with your squall! Mass Cure!", "sylph_fc1", 0],
      },
      [1466] => { # レイズ
        :word_1 => ["\\n<Sylph>Wave of life, come back to us again!\nRaise!", "sylph_fc1", 0],
      },
      [1467] => { # メガレイズ
        :word_1 => ["\\n<Sylph>Swirling soul, make a surprising comeback!\nMega Raise!", "sylph_fc1", 0],
      },
      [1468] => { # オールメガレイズ
        :word_1 => ["\\n<Sylph>Swirling souls, so round and fluffy!\nMass Mega Raise!", "sylph_fc1", 0],
      },
      [9179,8882] => { # ディレイヒール
        :word_1 => ["\\n<Sylph>Rebuilding at the end of turn! Delay Heal!", "sylph_fc1", 0],
      },
      [9178,8881] => { # ラピッドヒール
        :word_1 => ["\\n<Sylph>I'll heal you right away! Rapid Heal!", "sylph_fc1", 0],
      },
      [9182] => { # ハイレイズ
        :word_1 => ["\\n<Sylph>Revive and work immediately! High raise!", "sylph_fc1", 0],
      },
      [9183] => { # リレイズ
        :word_1 => ["\\n<Sylph>Come back to life! Reraise!", "sylph_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Sylph>Holy light, let's go!", "sylph_fc1", 0],
      },
      [1469] => { # ホーリーアロー
        :word_1 => ["\\n<Sylph>Holy light, shoot down the baddies♪\nHoly Arrow!", "sylph_fc1", 0],
      },
      [1470] => { # ニルヴァーナ
        :word_1 => ["\\n<Sylph>O magnificent holy light!\nI'll be judgement! Nirvana!", "sylph_fc1", 0],
      },
      [9185] => { # エターナル
        :word_1 => ["\\n<Sylph>Blow away with eternal waves! Eternal!", "sylph_fc1", 0],
      },
      [9186] => { # マグニフィセントワン
        :word_1 => ["\\n<Sylph>Anger! Magnificent One!", "sylph_fc1", 0],
      },
      [9187] => { # アヴェ・マリア
        :word_1 => ["\\n<Sylph>Something auspicious, Ave Maria!", "sylph_fc1", 0],
      },
      [1473] => { # ヘブン
        :word_1 => ["\\n<Sylph>O high power, send the baddies away!\nHeaven!", "sylph_fc1", 0],
      },
      [1474,9190] => { # オールヘブン
        :word_1 => ["\\n<Sylph>Great power, send the bad guy away! \n All Heaven!", "sylph_fc1", 0],
      },
      [1475] => { # アタック
        :word_1 => ["\\n<Sylph>White energy, max out our poweeer! ♪!\nEnhance Attack!", "sylph_fc1", 0],
      },
      [1476] => { # マジック
        :word_1 => ["\\n<Sylph>White energy, boost our magical power♪\nEnhance Magic!", "sylph_fc1", 0],
      },
      [1477] => { # ガード
        :word_1 => ["\\n<Sylph>White energy, make us safe with your steel armor♪ Enhance Guard!", "sylph_fc1", 0],
      },
      [1478] => { # マインド
        :word_1 => ["\\n<Sylph>White energy, make us safe with your magic wall! ♪\nEnhance Mind!", "sylph_fc1", 0],
      },
      [1479] => { # テクニック
        :word_1 => ["\\n<Sylph>White energy, maximum skill, Technique!♪\nAh, I messed it up... One more time, Enhance Technique!", "sylph_fc1", 0],
      },
      [1480] => { # オールアタック
        :word_1 => ["\\n<Sylph>White energy, max out our poweeer! ♪\nMass Attack!", "sylph_fc1", 0],
      },
      [1481] => { # オールマジック
        :word_1 => ["\\n<Sylph>White energy, boost our magical power♪\nMass Enhance Magic!", "sylph_fc1", 0],
      },
      [1482] => { # オールガード
        :word_1 => ["\\n<Sylph>White energy, make us safe with your steel armor♪ Mass Enhance Guard!", "sylph_fc1", 0],
      },
      [1483] => { # オールマインド
        :word_1 => ["\\n<Sylph>White energy, make us safe with your magic wall♪ Mass Enhance Mind!", "sylph_fc1", 0],
      },
      [1484] => { # オールテクニック
        :word_1 => ["\\n<Sylph>White energy, energize us with maximum skill!\nMass Technique!", "sylph_fc1", 0],
      },
      [1485] => { # ジルオール
        :word_1 => ["\\n<Sylph>White energy, give us a miracle!\nWe can do anything, Mass Omni Enhance!", "sylph_fc1", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Sylph>White power, protect power!", "sylph_fc1", 0],
      },
      [1486] => { # マジックカーテン
        :word_1 => ["\\n<Sylph>Spinning cycle, make pain into our gain!\nMagic Curtain!", "sylph_fc1", 0],
      },
      [1487] => { # マジックウォール
        :word_1 => ["\\n<Sylph>Magical barrier, protect us all!\nMagic wall!", "sylph_fc1", 0],
      },
      [9184] => { # ブレイブ
        :word_1 => ["\\n<Sylph>Love and love! Brave!", "sylph_fc1", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Sylph>Bad power, bye! \n Cancelled!", "sylph_fc1", 0],
      },
      [1493] => { # オールクリア
        :word_1 => ["\\n<Sylph>White energy, make the bad stuff go bye-bye!\nAll Clear!", "sylph_fc1", 0],
      },
      [10001] => { # オーバーヒール
        :word_1 => ["\\n<Sylph>Great salvation with \n Limit Topper! \n Over Heal!", "sylph_fc1", 0],
      },
      [10002] => { # オーバーキュア
        :word_1 => ["\\n<Sylph>Miraculous view, blessing view! \n Overcure!", "sylph_fc1", 0],
      },
      [10003] => { # アンチェインド
        :word_1 => ["\\n<Sylph>Make your chain shine with the miraculous light!! \n Unchained!", "sylph_fc1", 0],
      },
      [10004] => { # オーバーレイズ
        :word_1 => ["\\n<Sylph>Happy resurrection festival for everyone! \nOverraise!", "sylph_fc1", 0],
      },
      [10005] => { # オールリレイズ
        :word_1 => ["\\n<Sylph>Come back to life through reincarnation! \n All re-raise!", "sylph_fc1", 0],
      },
      [10006] => { # オールブレイブ
        :word_1 => ["\\n<Sylph>Full of energy, child of the wind! \n All Brave!", "sylph_fc1", 0],
      },
      [10007] => { # オーバージルオール
        :word_1 => ["\\n<Sylph>The great miracle of the wind! \n Ultimate protection! Overjill all!", "sylph_fc1", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Sylph>Black Power, listen to what I say!", "sylph_fc1", 0],
      },
      [1496] => { # ファイア
        :word_1 => ["\\n<Sylph>Angry flames, burn fiercely!\nFire!", "sylph_fc1", 0],
      },
      [1497] => { # メガファイア
        :word_1 => ["\\n<Sylph>Angry flames, swirl round and round!\nMega Fire!", "sylph_fc1", 0],
      },
      [1498] => { # ファイアテンペスト
        :word_1 => ["\\n<Sylph>Swirling flames, run wild!\nFire Tempest!", "sylph_fc1", 0],
      },
      [1499] => { # ブレイズ
        :word_1 => ["\\n<Sylph>Incredible flames, leave no trace of them!\nBlaze!", "sylph_fc1", 0],
      },
      [1500] => { # オメガブレイズ
        :word_1 => ["\\n<Sylph>Burning promise, a nightmarish flame!\nBurn to a crisp, Omega Blaze!", "sylph_fc1", 0],
      },
      [1501] => { # プロミネンス
        :word_1 => ["\\n<Sylph>Primordial red, swirling infinitey!\nA scorching end, Prominence!", "sylph_fc1", 0],
      },
      [1502] => { # ブリザード
        :word_1 => ["\\n<Sylph>Chilly ice, so cold!\nBlizzard!", "sylph_fc1", 0],
      },
      [1503] => { # メガブリザード
        :word_1 => ["\\n<Sylph>Chilly ice, a cold farewell storm!\nMega Blizzard!", "sylph_fc1", 0],
      },
      [1504] => { # ブリザードストーム
        :word_1 => ["\\n<Sylph>Cold vortex, freeze the land!\nBlizzard Storm!", "sylph_fc1", 0],
      },
      [1505] => { # フロスト
        :word_1 => ["\\n<Sylph>Cold coffin, freeze even their cries!\nFrost!", "sylph_fc1", 0],
      },
      [1506] => { # シグマフロスト
        :word_1 => ["\\n<Sylph>Freezing zero, a blue world...\nBe silent, Sigma Frost!", "sylph_fc1", 0],
      },
      [1507] => { # アイスエイジ
        :word_1 => ["\\n<Sylph>Primordial blue, maximum freeze!\nThe beginning of ice, Ice Age!", "sylph_fc1", 0],
      },
      [9194] => { # クァンタゾーン
        :word_1 => ["\\n<Sylph>Blinking, Quanta Zone!", "sylph_fc1", 0],
      },
      [9196] => { # イオンブラスト
        :word_1 => ["\\n<Sylph>Ion blast of floating molecules!", "sylph_fc1", 0],
      },
      [9206] => { # オーバーカーズ
        :word_1 => ["\\n<Sylph>Cursed Queen, OverCurse!", "sylph_fc1", 0],
      },
      [1508] => { # サンダー
        :word_1 => ["\\n<Sylph>Rolling thunder, give them heaven's judgement!\nThunder!", "sylph_fc1", 0],
      },
      [1509] => { # メガサンダー
        :word_1 => ["\\n<Sylph>Rolling thunder, shock the bad guys!\nMega Thunder!", "sylph_fc1", 0],
      },
      [1510] => { # サンダーハリケーン
        :word_1 => ["\\n<Sylph>Sparkly lightning, crash down from the sky!\nThunder Hurricane!", "sylph_fc1", 0],
      },
      [1511] => { # スパーク
        :word_1 => ["\\n<Sylph>Booming thunder, flatten evil!\nSpark!", "sylph_fc1", 0],
      },
      [1512] => { # ラムダスパーク
        :word_1 => ["\\n<Sylph>Judgement hammer, scatter them all...\nBlow them away, Lambda Spark!", "sylph_fc1", 0],
      },
      [1513] => { # ライトニング
        :word_1 => ["\\n<Sylph>Primordial spark, the end is near!\nRolling thunder, Plasma Storm!", "sylph_fc1", 0],
      },
      [1514] => { # ウィンド
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Playful winds, cut them up!\nWind!", "sylph_fc1", 0],
      },
      [1515] => { # エアロ
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Lively winds, blow like a tempest!\nAero!", "sylph_fc1", 0],
      },
      [1516] => { # デルタエアロ
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Swirling green, like an incredible storm!\nTogether we dance! Delta Aero!", "sylph_fc1", 0],
      },
      [9198] => { # エクスエアロ
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Very green and endless storm! \n Even Sylph was surprised, Ex Aero!", "sylph_fc1", 0],
      },
      [9199] => { # エメラルドナイト
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>The world of Sylph has arrived! Emerald Night!", "sylph_fc1", 0],
      },
      [9205] => { # トリニティ
        :word_1 => ["\\n<Sylph>Fire and ice, thunder and lightning! Trinity!", "sylph_fc1", 0],
      },
      [9192] => { # ガンマバースト
        :word_1 => ["\\n<Sylph>Burn the old light! Gamma Burst!", "sylph_fc1", 0],
      },
      [9204] => { # カオスリバレート
        :word_1 => ["\\n<Sylph>The source of magical power...Chaos Revelation♪", "sylph_fc1", 0],
      },
      [9207] => { # アポカリプス
        :word_1 => ["\\n<Sylph>The footsteps at the end, Apocalypse!", "sylph_fc1", 0],
      },
      [9210] => { # オーバーロード
        :word_1 => ["\\n<Sylph>I'll use all of my magical power... \n Blow away! Overload!", "sylph_fc1", 0],
      },
      [1530] => { # ドレイン
        :word_1 => ["\\n<Sylph>I'm drinking your power! ♪\nDrain!", "sylph_fc1", 0],
      },
      [1531] => { # マドレイン
        :word_1 => ["\\n<Sylph>I'm drinking your magic! ♪\nMadrain!", "sylph_fc1", 0],
      },
      [1532] => { # デス
        :word_1 => ["\\n<Sylph>Scaaary reaper, take their soul!\nDeath!", "sylph_fc1", 0],
      },
      [1533] => { # オールデス
        :word_1 => ["\\n<Sylph>Scaaary reaper, take their souls!\nMass Death!", "sylph_fc1", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Sylph>Secret magic of Chi Pa Pa!", "sylph_fc1", 0],
      },
      [1534] => { # ポイズン
        :word_1 => ["\\n<Sylph>Drip, drip! ♪\nPoison!", "sylph_fc1", 0],
      },
      [1535] => { # ブラインド
        :word_1 => ["\\n<Sylph>Stumble! ♪\nBlind!", "sylph_fc1", 0],
      },
      [1536] => { # サイレンス
        :word_1 => ["\\n<Sylph>Quiet quiet...\nSilence!", "sylph_fc1", 0],
      },
      [1537] => { # コンフューズ
        :word_1 => ["\\n<Sylph>Chi Pa Pa! Chi Pa Pa!\nConfuse!", "sylph_fc1", 0],
      },
      [1538] => { # スリープ
        :word_1 => ["\\n<Sylph>Snoozy snory!\nSleep!", "sylph_fc1", 0],
      },
      [1539] => { # パラライズ
        :word_1 => ["\\n<Sylph>Bzzzt, bzzzt!\nParalyze!", "sylph_fc1", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Sylph>Tranquil breeze, heal with a wOooosh!\nHeal Typhoon!", "sylph_fc1", 0],
      },
      [1523] => { # カーズ
        :word_1 => ["\\n<Sylph>Dark mist! Curse!", "sylph_fc1", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Sylph>hours go round and round, Chiipappa!", "sylph_fc1", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Sylph>Mysterious power, the power of time~♪", "sylph_fc1", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Sylph>Holy light, Chiipappa!", "sylph_fc1", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Sylph>Come back to life and start working~♪", "sylph_fc1", 0],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Sylph>It's an angel's dance~♪", "sylph_fc1", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Sylph>....................", "sylph_fc1", 0],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Sylph>Hey, let's play with me♪", "sylph_fc1", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Sylph>Holy light, healing Chiipappa!", "sylph_fc1", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Sylph>Uh! Mmm! What's up!!", "sylph_fc1", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Sylph>Power of darkness...hehehe...", "sylph_fc1", 0],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Sylph>Power of darkness...hehehe...", "sylph_fc1", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Sylph>It's a magic sword~♪", "sylph_fc1", 0],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Sylph>Expand, magical barrier!", "sylph_fc1", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Sylph>Yin-Yang Ofuda! Yay!", "sylph_fc1", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Sylph>The law of exorcism, the prison of rebellion! \n I don't know what it is, but it's the Nine Souls Exorcism Team!", "sylph_fc1", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Sylph>Healing Ofuda... Life-giving chant!", "sylph_fc1", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Sylph>Yin-Yang step, Rararan♪ Rararan♪", "sylph_fc1", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Sylph>Itadaki \n!", "sylph_fc1", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Sylph>It's proof of a thief!", "sylph_fc1", 0],
      },
      [1751] => { # 盗む
        :word_1 => ["\\n<Sylph>Thank you!", "sylph_fc1", 0],
      },
      [1755] => { # ぶんどる
        :word_1 => ["\\n<Sylph>will be lost♪", "sylph_fc1", 0],
      },
      [1760] => { # HPを盗む
        :word_1 => ["\\n<Sylph>Your HP, I'll be taking it♪", "sylph_fc1", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Sylph>Wow! Nigero!", "sylph_fc1", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Sylph>Ninninnin~♪", "sylph_fc1", 0],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Sylph>It's a kunoichi technique~♪", "sylph_fc1", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Sylph>Healing jutsu!", "sylph_fc1", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Sylph>I've cloned myself again today, Chi Pa Pa!", "sylph_fc1", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Sylph>Smokescreen, Eiyaa!", "sylph_fc1", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Sylph>It's a pirate's special move!", "sylph_fc1", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Sylph>Silfman! Hey!!", "sylph_fc1", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Sylph>Magical☆Sylph's exciting magic♪", "sylph_fc1", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Sylph>Maido♪", "sylph_fc1", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Sylph>is in stock♪", "sylph_fc1", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Sylph>Secret Item ~ Eiya!", "sylph_fc1", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Sylph>card, Shuba!", "sylph_fc1", 0],
      },
      [1984] => { # カード投げ
        :word_1 => ["\\n<Sylph>Card, shuba!", "sylph_fc1", 0],
      },
      [1985] => { # バニシングカード
        :word_1 => ["\\n<Sylph>Invisible card, shubababa!", "sylph_fc1", 0],
      },
      [1986] => { # スラッシュカード
        :word_1 => ["\\n<Sylph>Card Zaku!", "sylph_fc1", 0],
      },
      [1987] => { # ミリオンカード
        :word_1 => ["\\n<Sylph>Card, do it!", "sylph_fc1", 0],
      },
      [1988] => { # ジャックポット
        :word_1 => ["\\n<Sylph>Heeere I cOooome! Jackpot!", "sylph_fc1", 0],
      },
      [9376] => { # きまぐれジョーカー
        :word_1 => ["\\n<Sylph>Joker is off!", "sylph_fc1", 0],
      },
      [9377] => { # プログレッシブジャックポット
        :word_1 => ["\\n<Sylph>Progressive...? Jackpot!!", "sylph_fc1", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Sylph>Heads or tails...I'll throw the coin♪", "sylph_fc1", 0],
      },
      [1990] => { # 闇の罰ゲーム
        :word_1 => ["\\n<Sylph>If you lose, it's a punishment game♪", "sylph_fc1", 0],
      },
      [1991] => { # 死のルーレット
        :word_1 => ["\\n<Sylph>Roulette of death, spinning around~♪", "sylph_fc1", 0],
      },
      [1992] => { # ランダマイザ
        :word_1 => ["\\n<Sylph>Insane randomizer!", "sylph_fc1", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Sylph>Tarot fortune telling~♪ What will come out?", "sylph_fc1", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Sylph>I can hear the voice of Goddess-sama~!", "sylph_fc1", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Sylph>slot, go round and round!", "sylph_fc1", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Sylph>Let's play poker~♪", "sylph_fc1", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Sylph>battle card, draw♪", "sylph_fc1", 0],
      },
      868..885 => { # アタックドロー
        :word_1 => ["\\n<Sylph>Attack card, draw♪", "sylph_fc1", 0],
      },
      886..889 => { # ヒールドロー
        :word_1 => ["\\n<Sylph>Heal card, draw♪", "sylph_fc1", 0],
      },
      890..899 => { # サポートドロー
        :word_1 => ["\\n<Sylph>Support card, draw♪", "sylph_fc1", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Sylph>Trump power, yay!", "sylph_fc1", 0],
      },
      [2002] => { # スペードのキング
        :word_1 => ["\\n<Sylph>It's the King of Spades♪", "sylph_fc1", 0],
      },
      [2003] => { # クラブのジャック
        :word_1 => ["\\n<Sylph>Jack of Clubs, eiyaa!", "sylph_fc1", 0],
      },
      [2004] => { # ダイヤのクィーン
        :word_1 => ["\\n<Sylph>Queen of Diamonds, eiyaa!", "sylph_fc1", 0],
      },
      [2005] => { # ハートのエース
        :word_1 => ["\\n<Sylph>Ace of Hearts, eiyaa!", "sylph_fc1", 0],
      },
      [2006] => { # ジョーカーデス
        :word_1 => ["\\n<Sylph>Too bad, it was a joker♪", "sylph_fc1", 0],
      },
      [2007] => { # シャッフルカード
        :word_1 => ["\\n<Sylph>I'll draw something random... Eii!", "sylph_fc1", 0],
      },
      [2008] => { # 幸運の星
        :word_1 => ["\\n<Sylph>Lucky Power, who is this...?", "sylph_fc1", 0],
      },
      [2009] => { # ラッキーハンター
        :word_1 => ["\\n<Sylph>Happy, come on~♪", "sylph_fc1", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Sylph>It's always my turn♪", "sylph_fc1", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Sylph>Give me \nItem♪", "sylph_fc1", 0],
      },
      [2011] => { # 天の贈り物
        :word_1 => ["\\n<Sylph>Items are falling from the sky♪", "sylph_fc1", 0],
      },
      [2012] => { # アイテムスロット
        :word_1 => ["\\n<Sylph>Item slot, round and round♪", "sylph_fc1", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Sylph>Dance♪ Dance♪ Dance♪", "sylph_fc1", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Sylph>That's it! Hustle! Hustle!", "sylph_fc1", 7],
      },
      [2018] => { # たつまきダンス
        :word_1 => ["\\n<Sylph>Spin spin, whoosh woosh♪ Tornado daaance♪", "sylph_fc1", 0],
      },
      [2028] => { # エレメンタルダンス
        :word_1 => ["\\n<Sylph>All the spirits together, dancing...♪", "sylph_fc1", 0],
      },
      [2029] => { # 大精霊の舞い
        :word_1 => ["\\n<Sylph>Spirit dance is so exciting♪", "sylph_fc1", 0],
      },
      [9386] => { # コズミックダンス
        :word_1 => ["\\n<Sylph>It's the dance of the twinkling galaxies~♪", "sylph_fc1", 0],
      },
      [2037] => { # フェアリーダンス
        :word_1 => ["\\n<Sylph>We're all friends♪ Fairy Dance♪", "sylph_fc1", 0],
      },
      [2038] => { # ミステリーダンス
        :word_1 => ["\\n<Sylph>Mystery~♪ Mystery~♪", "sylph_fc1", 0],
      },
      [2045] => { # 召喚の踊り
        :word_1 => ["\\n<Sylph>Summon, come on~♪", "sylph_fc1", 0],
      },
      [2050] => { # 生贄の舞い
        :word_1 => ["\\n<Sylph>Bye-bye Dance♪", "sylph_fc1", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Sylph>Sylph's song, Chiipappa♪", "sylph_fc1", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Sylph>Kira☆", "sylph_fc1", 7],
      },
      [2084] => { # ちぃぱっぱの歌
        :word_1 => ["\\n<Sylph>Chi Pa Pa! Chi Pa Pa!\nThe flower on your head goes Chi Pa Pa!", "sylph_fc1", 7],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Sylph>Hey, let's talk to me♪", "sylph_fc1", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Sylph>Wow, that's amazing♪", "sylph_fc1", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Sylph>Boring...", "sylph_fc1", 1],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Sylph>Hey, give me the money♪", "sylph_fc1", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Sylph>Hey, give me the item♪", "sylph_fc1", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Sylph>Hey, let's be friends♪", "sylph_fc1", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Sylph>If I get angry, I'll be scared! There'll be a typhoon!", "sylph_fc1", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Sylph>Go home now... there's going to be a typhoon soon.", "sylph_fc1", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Sylph>Well, the gnome got buried in the sand...", "sylph_fc1", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Sylph>Gnome-chan, you're naked when you take a bath!", "sylph_fc1", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Sylph>At that time, Norm-chan's slap hell...", "sylph_fc1", 4],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Sylph>Sylph knows!", "sylph_fc1", 2],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Sylph>I was surprised by Kotodama Power!", "sylph_fc1", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Sylph>The basics of science are Chiipappa!", "sylph_fc1", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Sylph>Chi Pa Pa prepares you against danger!", "sylph_fc1", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Sylph>Power conversion! Mmmmm!", "sylph_fc1", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Sylph>I will alchemize \nItem♪", "sylph_fc1", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Sylph>The power of the demon book, yay!", "sylph_fc1", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Sylph>pages, bubbly...", "sylph_fc1", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Sylph>Tinkering with the machine, Chiipappa!", "sylph_fc1", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Sylph>I'll make some food, Chiipappa!", "sylph_fc1", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Sylph>Get ingredients~!", "sylph_fc1", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Sylph>This is Sylph's female judgment♪", "sylph_fc1", 0],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Sylph>Let's play doctor~♪", "sylph_fc1", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Sylph>Sylph's heart-pounding surgery~♪", "sylph_fc1", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Sylph>Sylph's drug chiipappa!", "sylph_fc1", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Sylph>It's an injection~♪", "sylph_fc1", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Sylph>Sylph's drug chiipappa!", "sylph_fc1", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Sylph>Maid Sylph Chiipappa!", "sylph_fc1", 0],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Sylph>Sylph's service feels good, right?", "sylph_fc1", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Sylph>With Sylph's tea, chichichichichii pappa!!", "sylph_fc1", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Sylph>Silf Chain!", "sylph_fc1", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Sylph>Let's harvest!", "sylph_fc1", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Sylph>Osama power, yay!", "sylph_fc1", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Sylph>Osama Magic, yay!", "sylph_fc1", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Sylph>Come, my servant~♪", "sylph_fc1", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Sylph>Sylph's funny sermon♪", "sylph_fc1", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Sylph>Sylph Lord~♪", "sylph_fc1", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Sylph>Sylph's prayer will bring about a miracle♪", "sylph_fc1", 0],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Sylph>Chipapapapa!!", "sylph_fc1", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Sylph>Brave Power! Oh no!!", "sylph_fc1", 0],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Sylph>Hey, let's play with me♪", "sylph_fc1", 0],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Sylph>Pervy stuff won't work on me♪", "sylph_fc1", 0],
      },
      [2694,2695] => { # 体当たり
        :word_1 => ["\\n<Sylph>We're colliding!", "sylph_fc1", 0],
      },
      [3028] => { # ファイアボール
        :word_1 => ["\\n<Sylph>Fwooosh! Fireball!", "sylph_fc1", 0],
      },
      [3029] => { # 火柱
        :word_1 => ["\\n<Sylph>Leaping magma! Flame Pillar!", "sylph_fc1", 0],
      },
      [3030] => { # マグマ
        :word_1 => ["\\n<Sylph>Magma, big bOooom!♪", "sylph_fc1", 0],
      },
      [3031] => { # 氷結
        :word_1 => ["\\n<Sylph>Brrrr! Freeze!", "sylph_fc1", 0],
      },
      [3032] => { # 氷柱
        :word_1 => ["\\n<Sylph>Bursting through the ground! Icicle!", "sylph_fc1", 0],
      },
      [3033] => { # 大氷河
        :word_1 => ["\\n<Sylph>Craaack... Glacier♪", "sylph_fc1", 0],
      },
      [3034] => { # 落雷
        :word_1 => ["\\n<Sylph>Bzzt! Thunderbolt!", "sylph_fc1", 0],
      },
      [3035] => { # 稲妻
        :word_1 => ["\\n<Sylph>The sky's angry! Lightning!", "sylph_fc1", 0],
      },
      [3036] => { # 大轟雷
        :word_1 => ["\\n<Sylph>Thunderclap, craaaash!", "sylph_fc1", 0],
      },
      [3037] => { # かまいたち
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Whoosh whoosh! Slicing Gust!", "sylph_fc1", 0],
      },
      [3038] => { # 突風
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Blow, blow, blow! Squall!", "sylph_fc1", 0],
      },
      [3039] => { # 大旋風
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Winds, slice them up! Whirlwind!", "sylph_fc1", 0],
      },
      [3040] => { # シャムシール
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>style okonomiyaki! Shamshir~!", "sylph_fc1", 0],
      },
      [3041] => { # テラサイクロン
        :ct_pic => "80_sylph_st05",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Sylph>Storm of dreams, a festival of devastation!\nTera CyclOooone!", "sylph_fc1", 0],
      },
      [3042] => { # 崖崩れ
        :word_1 => ["\\n<Sylph>Rumble-rumble boom! Landslide!", "sylph_fc1", 0],
      },
      [3043] => { # 地震
        :word_1 => ["\\n<Sylph>Just like Gnomey... Earthquake!", "sylph_fc1", 0],
      },
      [3044] => { # 大地の怒り
        :word_1 => ["\\n<Sylph>Calm down, Gnomey! Wrath of the Earth!", "sylph_fc1", 0],
      },
      [3045] => { # 大地咆吼
        :word_1 => ["\\n<Sylph>Gnome-chan explodes! Boom!", "sylph_fc1", 0],
      },
      [3046] => { # 鉄砲水
        :word_1 => ["\\n<Sylph>Splash, crash, Flash Flood!", "sylph_fc1", 0],
      },
      [3047] => { # 津波
        :word_1 => ["\\n<Sylph>Here it cooomes! Tsunami!", "sylph_fc1", 0],
      },
      [3048] => { # 大洪水
        :word_1 => ["\\n<Sylph>Great Flood, big splaaaash!", "sylph_fc1", 0],
      },
      [3049] => { # タイダルウェイブ
        :word_1 => ["\\n<Sylph>Water Gogo, Tidal Wave!", "sylph_fc1", 0],
      },
      [3050] => { # 毒沼
        :word_1 => ["\\n<Sylph>Drip-drip, drip-drip.... Poison Marsh!", "sylph_fc1", 0],
      },
      [3051] => { # 猛毒旋風
        :word_1 => ["\\n<Sylph>Poisonous whirlwind♪", "sylph_fc1", 0],
      },
      [3052] => { # 恍惚の風
        :word_1 => ["\\n<Sylph>Become sluggish with the lovely wind♪", "sylph_fc1", 0],
        :word_2 => ["\\n<Sylph>Hehe, I'll make you cum with my special move♪", "sylph_fc1", 0],
        :word_3 => ["\\n<Sylph>Be enchanted by my wind♪", "sylph_fc1", 0],
      },
      [3053] => { # 風のセレナーデ
        :word_1 => ["\\n<Sylph>Sweeeet breeze♪ Wind Serenade!", "sylph_fc1", 0],
      },
      [9685] => { # 星吼
        :word_1 => ["\\n<Sylph>It's the roar of the stars~♪", "sylph_fc1", 0],
      },
      [9686] => { # 星護蝶
        :word_1 => ["\\n<Sylph>It's the light that will destroy civilization~♪", "sylph_fc1", 0],
      },
      [3055] => { # フェアリーヒール
        :word_1 => ["\\n<Sylph>Great nature, heal their wounds♪", "sylph_fc1", 0],
      },
      [3056] => { # ワンダーヒール
        :word_1 => ["\\n<Sylph>Great nature, heal us all♪", "sylph_fc1", 0],
      },
      [3057] => { # マジカルライズ
        :word_1 => ["\\n<Sylph>Great nature, give them your breath of life♪", "sylph_fc1", 0],
      },
      [3062] => { # 星の癒し
        :word_1 => ["\\n<Sylph>Star, heal me~♪", "sylph_fc1", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Sylph>mmmmmm...!", "sylph_fc1", 0],
      },
      [3103] => { # 魔力集中
        :word_1 => ["\\n<Sylph>Magic power, concentration~♪", "sylph_fc1", 0],
      },
      [9775] => { # コンセントレイト
        :word_1 => ["\\n<Sylph>Concentrate magical power, Concentrate~!", "sylph_fc1", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Sylph>It's the power of elementals!", "sylph_fc1", 0],
      },
      [3112] => { # 風の戯れ
        :word_1 => ["\\n<Sylph>Dancing with the wind, lala laran♪", "sylph_fc1", 0],
      },
      [3113] => { # 疾風の極み
        :word_1 => ["\\n<Sylph>An empty heart, dancing in the wind~♪", "sylph_fc1", 0],
      },
      [3114] => { # 大地の息吹
        :word_1 => ["\\n<Sylph>Gnome-chan, let's play♪", "sylph_fc1", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Sylph>Take a deep breath...Suha...", "sylph_fc1", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Sylph>It's just a first aid measure...", "sylph_fc1", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Sylph>Sylph is in danger!", "sylph_fc1", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Sylph>Sylph, Oh dear♪", "sylph_fc1", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Sylph>Seigi Mikata, Silfman! reply!!", "sylph_fc1", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Sylph>Henshin! Magical☆Shilf♪", "sylph_fc1", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Sylph>Do your best and you'll make it!", "sylph_fc1", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Sylph>Reinforcements, please help!", "sylph_fc1", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Sylph>I'm going to break out~♪", "sylph_fc1", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Sylph>Geyser... Dobashan!", "sylph_fc1", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Sylph>What is Shit Yeah...?", "sylph_fc1", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Sylph>hehe, I'll take it~♪", "sylph_fc1", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Sylph>Teehee♪ Sexy Beam!", "sylph_fc1", 3],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Sylph>Teehee♪ Pink Typhoon!", "sylph_fc1", 3],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Sylph>Uffun♪ Fantastic Hurricane!", "sylph_fc1", 3],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Sylph>It's my stage~♪", "sylph_fc1", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Sylph>I'll do my best~♪", "sylph_fc1", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Sylph>Puff Puff... Wow! It's bullying!", "sylph_fc1", 4],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Sylph>Weapon power is up!", "sylph_fc1", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Sylph>Time, stop~♪", "sylph_fc1", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Sylph>Grudge Power~♪", "sylph_fc1", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Sylph>...Blitzkrieg♪", "sylph_fc1", 0],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Sylph>Protect \n, Brave Wall!", "sylph_fc1", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Sylph>Grudge, chills...", "sylph_fc1", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Sylph>It's the miracle of the Holy Grail~♪", "sylph_fc1", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Sylph>Bibi Bibi ~♪", "sylph_fc1", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Sylph>It's a fun magic~♪", "sylph_fc1", 0],
      },
      [6074] => { # 風牙
        :word_1 => ["\\n<Sylph>Fangs of wind! Eiiiii!", "sylph_fc1", 0],
      },
      [6155] => { # 風祭り
        :word_1 => ["\\n<Sylph>-style festival, have a blast!", "sylph_fc1", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Sylph>Hey!", "sylph_fc1", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Sylph>I'll protect you!", "sylph_fc1", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Sylph>Sylph Assemble!!", "sylph_fc1", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Sylph>Double up!", "sylph_fc1", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Sylph>Next action, order!", "sylph_fc1", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Sylph>Concentrate on one point!", "sylph_fc1", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Sylph>■■■■■■■■■■■■■■■...", "sylph_fc1", 0],
      },
      [3983] => { # 快楽の風
        :word_1 => ["\\n<Sylph>Ejaculate with \n-style caress~♪", "sylph_fc1", 0],
        :word_2 => ["\\n<Sylph>I'll give you my wind as a gift♪", "sylph_fc1", 0],
        :word_3 => ["\\n<Sylph>It feels better than actually touching it, right?", "sylph_fc1", 0],
        :word_4 => ["\\n<Sylph>Spread your semen in this wind♪", "sylph_fc1", 0],
      },
      [3984] => { # 快楽の風
        :word_1 => ["\\n<Sylph>My wind tickles all over your body♪", "sylph_fc1", 0],
        :word_2 => ["\\n<Sylph>Look, look, it feels good, right?", "sylph_fc1", 0],
        :word_3 => ["\\n<Sylph>Hey, it's refreshing~♪", "sylph_fc1", 0],
        :word_4 => ["\\n<Sylph>I'll play with the wind to every corner of your body♪", "sylph_fc1", 0],
      },
      [3985] => { # 恍惚の風
        :word_1 => ["\\n<Sylph>Become sluggish with the lovely wind♪", "sylph_fc1", 0],
        :word_2 => ["\\n<Sylph>Hehe, I'll make you cum with my special move♪", "sylph_fc1", 0],
        :word_3 => ["\\n<Sylph>Be enchanted by my wind♪", "sylph_fc1", 0],
      },
      [3986] => { # 風のセレナーデ・誘惑専用
        :word_1 => ["\\n<Sylph>I'll bully you first~♪", "sylph_fc1", 0],
        :word_2 => ["\\n<Sylph>I blame the umbrella part...♪", "sylph_fc1", 0],
        :word_3 => ["\\n<Sylph>Look, look, look~♪ Your penis is going tight~♪", "sylph_fc1", 0],
        :word_4 => ["\\n<Sylph>Ehehe, I'm getting so tight♪", "sylph_fc1", 0],
        :word_5 => ["\\n<Sylph>Just like this, let's have fun~♪", "sylph_fc1", 0],
        :word_y1 => ["\\n<Sylph>Luka's penis......", "sylph_fc1", 0],
      },
    },
    13 => { # ノーム
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 1],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2002] => { # スペードのキング
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2003] => { # クラブのジャック
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2004] => { # ダイヤのクィーン
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2005] => { # ハートのエース
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2006] => { # ジョーカーデス
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2007] => { # シャッフルカード
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Gnome>That's it! Hustle! Hustle!", "gnome_fc1", 0],
      },
      [2018] => { # たつまきダンス
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2037] => { # フェアリーダンス
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2038] => { # ミステリーダンス
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2045] => { # 召喚の踊り
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2050] => { # 生贄の舞い
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Gnome>...Kira☆", "gnome_fc1", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3028] => { # ファイアボール
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3029] => { # 火柱
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3030] => { # マグマ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3031] => { # 氷結
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3032] => { # 氷柱
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3033] => { # 大氷河
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3034] => { # 落雷
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3035] => { # 稲妻
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3036] => { # 大轟雷
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3037] => { # かまいたち
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3038] => { # 突風
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3039] => { # 大旋風
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3042] => { # 崖崩れ
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3043] => { # 地震
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3044] => { # 大地の怒り
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3045] => { # 大地咆吼
        :ct_pic => "80_gnome_st21",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3046] => { # 鉄砲水
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3047] => { # 津波
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3048] => { # 大洪水
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3050] => { # 毒沼
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3051] => { # 猛毒旋風
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3052] => { # 恍惚の風
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3053] => { # 風のセレナーデ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [9685] => { # 星吼
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [9686] => { # 星護蝶
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [3055] => { # フェアリーヒール
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3056] => { # ワンダーヒール
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3057] => { # マジカルライズ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [3112] => { # 風の戯れ
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3114] => { # 大地の息吹
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 1],
      },
      [3489] => { # 誘惑専用
        :word_y1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Gnome>............", "gnome_fc1", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Gnome>....................", "gnome_fc1", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Gnome>■■■■■■■■■■■■■■■...", "gnome_fc1", 0],
      },
    },
    14 => { # ウンディーネ
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Undine>I'm going...", "undine_fc1", 0],
        :word_2 => ["\\n<Undine>I'm bothering you...", "undine_fc1", 0],
        :word_3 => ["\\n<Undine>disappear...", "undine_fc1", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Undine>I'll cut you to pieces...", "undine_fc1", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Undine>I'll cut you in two...", "undine_fc1", 0],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Undine>Healing sword, heavenly protection...", "undine_fc1", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Undine>I want to be able to open a hole...?", "undine_fc1", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Undine>The pride of a water spirit is in this blade...!", "undine_fc1", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Undine>Meikagami Water Stopping Blade...", "undine_fc1", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Undine>I will cut your heart with this white blade...", "undine_fc1", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Undine>I'll ask you if you're prepared...", "undine_fc1", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Undine>Pierce...", "undine_fc1", 0],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Undine>Spear, miracle of healing...", "undine_fc1", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Undine>Power to the spear...", "undine_fc1", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Undine>I'm going wild...", "undine_fc1", 0],
      },
      [1099] => { # 暴塵斧
        :word_1 => ["\\n<Undine>Break them, Violent Axe...!", "undine_fc1", 0],
      },
      [1106] => { # 轟炎斧
        :word_1 => ["\\n<Undine>Burn them down, Fire Roar Axe...!", "undine_fc1", 0],
      },
      [1109] => { # 轟炎乱斧
        :word_1 => ["\\n<Undine>Burn to the bone, Violent Inferno Axe...!", "undine_fc1", 0],
      },
      [1115] => { # 微塵連斧
        :word_1 => ["\\n<Undine>I will smash you to bits, Pulverizing Axe...!", "undine_fc1", 0],
      },
      [1117] => { # タイタンズレガシー
        :word_1 => ["\\n<Undine>Break like a giant...Titans Legacy!", "undine_fc1", 0],
      },
      [9065] => { # コスモレガシー
        :word_1 => ["\\n<Undine>Shatter the galaxy... Cosmo Legacy!", "undine_fc1", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Undine>The power of a raging axe...", "undine_fc1", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Undine>I'll crush you...", "undine_fc1", 0],
      },
      [1128] => { # 旋棍一閃撃
        :word_1 => ["\\n<Undine>A swift swing of the club, Spinning Club Strike...", "undine_fc1", 0],
      },
      [1131] => { # 轟氷撃
        :word_1 => ["\\n<Undine>Be carved into a glacier, Roaring Ice Club...", "undine_fc1", 0],
      },
      [1137] => { # スライム潰し
        :word_1 => ["\\n<Undine>What a detestable technique...", "undine_fc1", 0],
      },
      [1145] => { # 鬼神乱破
        :word_1 => ["\\n<Undine>The kishin's wild onslaught, Chaotic Kishin Club...", "undine_fc1", 0],
      },
      [9070] => { # 土精大乱撃
        :word_1 => ["\\n<Undine>I wonder if I can do it like a gnome... Great earth spirit attack!", "undine_fc1", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Undine>I will end my life with \n sickle...", "undine_fc1", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Undine>Be confused by the sickle...", "undine_fc1", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Undine>A bow blow...", "undine_fc1", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Undine>Rain down your healing arrows...", "undine_fc1", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Undine>I'll discipline you with a whip...", "undine_fc1", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Undine>Servant, come...!", "undine_fc1", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Undine>Boomerangs are something that a viscous demon knows...", "undine_fc1", 0],
      },
      [1260] => { # ノビールショット
        :word_1 => ["\\n<Undine>With my arm stretched out... Haa!", "undine_fc1", 0],
      },
      [1261] => { # 燕落とし
        :word_1 => ["\\n<Undine>A bird flying through the skies...", "undine_fc1", 0],
      },
      [1265] => { # ツインブーメラン
        :word_1 => ["\\n<Undine>Soar, double boomerang...", "undine_fc1", 0],
      },
      [1266] => { # エアロダート
        :word_1 => ["\\n<Undine>Slice them apart, boomerang of wind...", "undine_fc1", 0],
      },
      [1267] => { # メルティスルー
        :word_1 => ["\\n<Undine>Have a taste of this digestive slime boomerang...", "undine_fc1", 0],
      },
      [1272] => { # フィフスエッジ
        :word_1 => ["\\n<Undine>Like five shooting stars, Fifth Edge...", "undine_fc1", 0],
      },
      [1273] => { # 四天風車輪
        :word_1 => ["\\n<Undine>Wheels of wind, shred amidst the chaos... Five Heavenly Wheels...", "undine_fc1", 0],
      },
      [1274] => { # 影螺旋
        :word_1 => ["\\n<Undine>This spiraling blade shall lead you to your demise, Shadow Spiral...", "undine_fc1", 0],
      },
      [1275] => { # シャドウエンハウンス
        :word_1 => ["\\n<Undine>Submerge in the shadow, Shadow Enhance...!", "undine_fc1", 0],
      },
      [1278] => { # シュプルエッジ
        :word_1 => ["\\n<Undine>A cutter sharpened by water pressure...!", "undine_fc1", 0],
      },
      [1280] => { # 魔擲乱星
        :word_1 => ["\\n<Undine>Dance, carve, pierce, demonic disturbance star...!", "undine_fc1", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Undine>That's a heavy blow...", "undine_fc1", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Undine>Let's dance together...?", "undine_fc1", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Undine>I'll shoot through \n...", "undine_fc1", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Undine>Healing bullet...", "undine_fc1", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Undine>I'll carve it into many layers...", "undine_fc1", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Undine>I'll use continuous attacks...", "undine_fc1", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Undine>It's barbaric to beat someone down...", "undine_fc1", 0],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Undine>Take the technique of pleasure...", "undine_fc1", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Undine>Water vein chakra...", "undine_fc1", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Undine>Entrust the flowing demonic vein to your fist...", "undine_fc1", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Undine>White torrent, heal your injured body...", "undine_fc1", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Undine>Galactic waves, bring the tide of life... \n Cosmo Heal...", "undine_fc1", 0],
      },
      [1460] => { # ヒール
        :word_1 => ["\\n<Undine>Tranquil winds of life, restore their wounded body... Heal...", "undine_fc1", 0],
      },
      [1461] => { # メガヒール
        :word_1 => ["\\n<Undine>Heartening waves of life, restore them with your lively breath... Mega Heal...", "undine_fc1", 0],
      },
      [1462] => { # オールヒール
        :word_1 => ["\\n<Undine>Tranquil winds of life, renew us with your grace... Mass Heal...", "undine_fc1", 0],
      },
      [1463] => { # オールメガヒール
        :word_1 => ["\\n<Undine>Heartening waves of life, sweep through with a squall of grace... Mass Mega Heal...", "undine_fc1", 0],
      },
      [1464] => { # キュア
        :word_1 => ["\\n<Undine>Winds of serenity, bring peace to their afflicted body... Cure...", "undine_fc1", 0],
      },
      [1465] => { # オールキュア
        :word_1 => ["\\n<Undine>Winds of serenity, usher in tranquility with a gale of blessings... Mass Cure...", "undine_fc1", 0],
      },
      [1466] => { # レイズ
        :word_1 => ["\\n<Undine>Heartening waves of the soul, return them to life once more... Raise...", "undine_fc1", 0],
      },
      [1467] => { # メガレイズ
        :word_1 => ["\\n<Undine>Soul in the flux, defy reason and arise once more... Mega Raise...", "undine_fc1", 0],
      },
      [1468] => { # オールメガレイズ
        :word_1 => ["\\n<Undine>Lost in the flux of a thousand souls, defy reason and arise once more... Mass Mega Raise...", "undine_fc1", 0],
      },
      [9179,8882] => { # ディレイヒール
        :word_1 => ["\\n<Undine>Healing breath comes late... Delay Heal...", "undine_fc1", 0],
      },
      [9178,8881] => { # ラピッドヒール
        :word_1 => ["\\n<Undine>Storm, a pioneering miracle...Rapid Heal...", "undine_fc1", 0],
      },
      [9182] => { # ハイレイズ
        :word_1 => ["\\n<Undine>Wandering soul, a vibrant and fulfilling comeback... \n High raise...", "undine_fc1", 0],
      },
      [9183] => { # リレイズ
        :word_1 => ["\\n<Undine>Breath of flux, bring reincarnation at the end... \n Reraise...", "undine_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Undine>White torrent, destroy the darkness...", "undine_fc1", 0],
      },
      [1469] => { # ホーリーアロー
        :word_1 => ["\\n<Undine>Holy light, pierce through the darkness and smite evil... Holy Arrow...", "undine_fc1", 0],
      },
      [1470] => { # ニルヴァーナ
        :word_1 => ["\\n<Undine>Torrent of white that leads to enlightenment, demonstrate your unwavering righteousness... Judgement is my name... Nirvana...", "undine_fc1", 0],
      },
      [9185] => { # エターナル
        :word_1 => ["\\n<Undine>Eternal waves, bring the infallibility of dawn... \n Eternal...", "undine_fc1", 0],
      },
      [9186] => { # マグニフィセントワン
        :word_1 => ["\\n<Undine>Know the wrath of God, the Magnificent One...", "undine_fc1", 0],
      },
      [9187] => { # アヴェ・マリア
        :word_1 => ["\\n<Undine>Eternity and reincarnation, blessing and infallibility... \n Eternal gospel, Ave Maria...", "undine_fc1", 0],
      },
      [1473] => { # ヘブン
        :word_1 => ["\\n<Undine>Immortal high will, grace the wicked with your divine presence... Heaven...", "undine_fc1", 0],
      },
      [1474,9190] => { # オールヘブン
        :word_1 => ["\\n<Undine>Immortal high will, bring the swarms of evil to God's mercy... \n All Heaven...", "undine_fc1", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Undine>White torrent, give me power...", "undine_fc1", 0],
      },
      [1475] => { # アタック
        :word_1 => ["\\n<Undine>Torrent of white, bless us with your breath of strength... Enhance Attack...", "undine_fc1", 0],
      },
      [1476] => { # マジック
        :word_1 => ["\\n<Undine>Torrent of white, bless us with your breath of magic... Enhance Magic...", "undine_fc1", 0],
      },
      [1477] => { # ガード
        :word_1 => ["\\n<Undine>Torrent of white, grant us the protection of your stalwart armor... Enhance Guard...", "undine_fc1", 0],
      },
      [1478] => { # マインド
        :word_1 => ["\\n<Undine>Torrent of white, grant us the protection of your consecrated barrier... Enhance Mind...", "undine_fc1", 0],
      },
      [1479] => { # テクニック
        :word_1 => ["\\n<Undine>Torrent of white, bless us with the apex of skill... Enhance Technique...", "undine_fc1", 0],
      },
      [1480] => { # オールアタック
        :word_1 => ["\\n<Undine>Torrent of white, bless us with your breath of strength... Mass Enhance Attack...", "undine_fc1", 0],
      },
      [1481] => { # オールマジック
        :word_1 => ["\\n<Undine>Torrent of white, bless us with your breath of magic... Mass Enhance Magic...", "undine_fc1", 0],
      },
      [1482] => { # オールガード
        :word_1 => ["\\n<Undine>Torrent of white, grant us the protection of your stalwart armor... Mass Enhance Guard...", "undine_fc1", 0],
      },
      [1483] => { # オールマインド
        :word_1 => ["\\n<Undine>Torrent of white, grant us the protection of your consecrated barrier... Mass Enhance Mind...", "undine_fc1", 0],
      },
      [1484] => { # オールテクニック
        :word_1 => ["\\n<Undine>Torrent of white, bless us with the apex of skill... Mass Enhance Technique...", "undine_fc1", 0],
      },
      [1485] => { # ジルオール
        :word_1 => ["\\n<Undine>Tide of solace, bestow upon us a grand miracle... Mercy and divine protection... Mass Omni Enhance...", "undine_fc1", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Undine>White torrent, prevent evil power...", "undine_fc1", 0],
      },
      [1486] => { # マジックカーテン
        :word_1 => ["\\n<Undine>Samsara of sorcery that circles round, bestow upon us grace beyond reason... Magic Curtain...", "undine_fc1", 0],
      },
      [1487] => { # マジックウォール
        :word_1 => ["\\n<Undine>Barrier of sorcery, become an iron wall of divine protection... Magic Wall...", "undine_fc1", 0],
      },
      [1488] => { # アクアペンタゴン
        :word_1 => ["\\n<Undine>Isolate yourself from the evil waves... \n Aqua Pentagon...", "undine_fc1", 0],
      },
      [9184] => { # ブレイブ
        :word_1 => ["\\n<Undine>White torrent, bring calm and youthful life... \n Brave...", "undine_fc1", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Undine>A white torrent that hates evil, protects evil and exorcises walls... \n Cancel...", "undine_fc1", 0],
      },
      [1489] => { # キャンセル
        :word_1 => ["\\n<Undine>Wave of white which detests the wicked, lift the barriers that protect evil... Dispel...", "undine_fc1", 0],
      },
      [1493] => { # オールクリア
        :word_1 => ["\\n<Undine>Waves of white, negate the waves of evil which weaken us... All Clear...", "undine_fc1", 0],
      },
      [10001] => { # オーバーヒール
        :word_1 => ["\\n<Undine>Beyond the limits, miraculous waves, bring great salvation... \n Over Heal...", "undine_fc1", 0],
      },
      [10002] => { # オーバーキュア
        :word_1 => ["\\n<Undine>Save the world and bring the miraculous wind and eternal blessings... \n Overcure...", "undine_fc1", 0],
      },
      [10003] => { # アンチェインド
        :word_1 => ["\\n<Undine>Miraculous light, release from the shackles of bondage... \n Unchained...", "undine_fc1", 0],
      },
      [10004] => { # オーバーレイズ
        :word_1 => ["\\n<Undine>A thousand souls lost in flux, miraculous second coming... \n Overraise...", "undine_fc1", 0],
      },
      [10005] => { # オールリレイズ
        :word_1 => ["\\n<Undine>Breath of flux, bring reincarnation at the end... \n All reraise...", "undine_fc1", 0],
      },
      [10006] => { # オールブレイブ
        :word_1 => ["\\n<Undine>White torrent, bring calm and youthful life... \n All Brave...", "undine_fc1", 0],
      },
      [10007] => { # オーバージルオール
        :word_1 => ["\\n<Undine>A torrent of healing, bring a great miracle... \n The ultimate protection, Overjill All...", "undine_fc1", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Undine>Black torrent, obey my orders...", "undine_fc1", 0],
      },
      [1496] => { # ファイア
        :word_1 => ["\\n<Undine>Raging flames, show them your power...\nFire...", "undine_fc1", 0],
      },
      [1497] => { # メガファイア
        :word_1 => ["\\n<Undine>Raging flames, scatter them like a maelstrom...\nMega Fire...", "undine_fc1", 0],
      },
      [1498] => { # ファイアテンペスト
        :word_1 => ["\\n<Undine>Vortex of embers, rampage with all your fury... Fire Tempest...", "undine_fc1", 0],
      },
      [1499] => { # ブレイズ
        :word_1 => ["\\n<Undine>Infernal breath, become a scorching nightmare... Blaze...", "undine_fc1", 0],
      },
      [1500] => { # オメガブレイズ
        :word_1 => ["\\n<Undine>Obey my pledge, hellish inferno...\nBurn to ashes... Omega Blaze...", "undine_fc1", 0],
      },
      [1501] => { # プロミネンス
        :word_1 => ["\\n<Undine>Primordial red, revolving for an eternity...\nDoomsday inferno... Prominence...", "undine_fc1", 0],
      },
      [1502] => { # ブリザード
        :word_1 => ["\\n<Undine>Freezing ice, become a bitter chill...\nBlizzard...", "undine_fc1", 0],
      },
      [1503] => { # メガブリザード
        :word_1 => ["\\n<Undine>Freezing ice, become a cold tempest of destruction... Mega Blizzard...", "undine_fc1", 0],
      },
      [1504] => { # ブリザードストーム
        :word_1 => ["\\n<Undine>Icy vortex, cut through everything in your way... Blizzard Storm...", "undine_fc1", 0],
      },
      [1505] => { # フロスト
        :word_1 => ["\\n<Undine>Frozen coffin, freeze even their screams of lament... Frost...", "undine_fc1", 0],
      },
      [1506] => { # シグマフロスト
        :word_1 => ["\\n<Undine>Tides of nothingness, freeze this world of blue in time... Lifeless silence, Sigma Frost...", "undine_fc1", 0],
      },
      [1507] => { # アイスエイジ
        :word_1 => ["\\n<Undine>Primordial blue, engraved upon the deepest Apocalypse... The beginning of absolute zero, Ice Age...", "undine_fc1", 0],
      },
      [9194] => { # クァンタゾーン
        :word_1 => ["\\n<Undine>Ultra-fine blink, bring about the destruction of congealing... \n Quantazone...", "undine_fc1", 0],
      },
      [9196] => { # イオンブラスト
        :word_1 => ["\\n<Undine>Look at the way the floating molecules scatter...\n Ion blast...", "undine_fc1", 0],
      },
      [9206] => { # オーバーカーズ
        :word_1 => ["\\n<Undine>The cursed queen, open up the taboos... \n The black disaster, Overcars...", "undine_fc1", 0],
      },
      [1508] => { # サンダー
        :word_1 => ["\\n<Undine>Pure lightning, deliver your judgement...\nThunder...", "undine_fc1", 0],
      },
      [1509] => { # メガサンダー
        :word_1 => ["\\n<Undine>Pure lightning, rain down and banish the wicked... Mega Thunder...", "undine_fc1", 0],
      },
      [1510] => { # サンダーハリケーン
        :word_1 => ["\\n<Undine>Raging thunder, roar and tear asunder the heavens...\nThunder Hurricane...", "undine_fc1", 0],
      },
      [1511] => { # スパーク
        :word_1 => ["\\n<Undine>Hammer of lightning, turn evil to ashes...\nSpark...", "undine_fc1", 0],
      },
      [1512] => { # ラムダスパーク
        :word_1 => ["\\n<Undine>Hammer of judgement, a prison of lightning to turn all to dust... Deliver your punishment... Lambda Spark...", "undine_fc1", 0],
      },
      [1513] => { # ライトニング
        :word_1 => ["\\n<Undine>Primordial spark, return them to the dust of Samsara... Apocalyptic lightning, Plasma Storm...", "undine_fc1", 0],
      },
      [1514] => { # ウィンド
        :word_1 => ["\\n<Undine>Dancing wind, become a blade to slice them to pieces... Wind...", "undine_fc1", 0],
      },
      [1515] => { # エアロ
        :word_1 => ["\\n<Undine>Violent wind, rage like a ceaseless storm...\nAero...", "undine_fc1", 0],
      },
      [1516] => { # デルタエアロ
        :word_1 => ["\\n<Undine>Boundless green, dancing with energy...\nBecome a sixfold cyclone, Delta Aero...", "undine_fc1", 0],
      },
      [9205] => { # トリニティ
        :word_1 => ["\\n<Undine>Play the dance of flame, ice, and thunder... \n Trinity...", "undine_fc1", 0],
      },
      [9192] => { # ガンマバースト
        :word_1 => ["\\n<Undine>Afterglow of creation, bring the scorching heat of the primordial... \n Gamma Burst...", "undine_fc1", 0],
      },
      [9207] => { # アポカリプス
        :word_1 => ["\\n<Undine>Hear the footsteps of the end, Apocalypse...", "undine_fc1", 0],
      },
      [9210] => { # オーバーロード
        :word_1 => ["\\n<Undine>This magical power, burn it all down... \n Disappear into dust, Overlord...", "undine_fc1", 0],
      },
      [9204] => { # カオスリバレート
        :word_1 => ["\\n<Undine>Wandering, the source of the ultimate magic...Chaos Revelation...", "undine_fc1", 0],
      },
      [1530] => { # ドレイン
        :word_1 => ["\\n<Undine>Offer your life force unto me...\nDrain...", "undine_fc1", 0],
      },
      [1531] => { # マドレイン
        :word_1 => ["\\n<Undine>Offer your magic unto me...\nMadrain...", "undine_fc1", 0],
      },
      [1532] => { # デス
        :word_1 => ["\\n<Undine>Reaper's scythe which harvests life, lead their soul to Hades... Death...", "undine_fc1", 0],
      },
      [1533] => { # オールデス
        :word_1 => ["\\n<Undine>Reaper's scythe which harvests life, lead this flock of souls to Hades... Mass Death...", "undine_fc1", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Undine>Torrent of black, heed my call...", "undine_fc1", 0],
      },
      [1534] => { # ポイズン
        :word_1 => ["\\n<Undine>Flowing toxin, infect their flesh...\nPoison...", "undine_fc1", 0],
      },
      [1535] => { # ブラインド
        :word_1 => ["\\n<Undine>Darkness of night, rob them of their light...\nBlind...", "undine_fc1", 0],
      },
      [1536] => { # サイレンス
        :word_1 => ["\\n<Undine>Deny sorcery, and bring forth tranquility... Silence...", "undine_fc1", 0],
      },
      [1537] => { # コンフューズ
        :word_1 => ["\\n<Undine>Wandering hearts, know not who you even point your blades at... Confuse...", "undine_fc1", 0],
      },
      [1538] => { # スリープ
        :word_1 => ["\\n<Undine>Dreaming in daylight, your consciousness drifts with the butterfly's calling... Sleep...", "undine_fc1", 0],
      },
      [1539] => { # パラライズ
        :word_1 => ["\\n<Undine>Numbing grip, have them experience the deprivation of freedom... Paralyze...", "undine_fc1", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Undine>Tranquil breeze of life, blow and become a squall of grace... Heal Typhoon...", "undine_fc1", 0],
      },
      [1523] => { # カーズ
        :word_1 => ["\\n<Undine>The fog of darkness, bring great disaster...Cars...", "undine_fc1", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Undine>The torrent of time, follow my will and carve your steps...", "undine_fc1", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Undine>The torrent of time, distort time and space and bring about destruction...", "undine_fc1", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Undine>Holy light, dispel the darkness...", "undine_fc1", 0],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Undine>Enjoy the beautiful sexual techniques...", "undine_fc1", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Undine>Holy light, bring healing...", "undine_fc1", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Undine>I will self-destruct with holy power...", "undine_fc1", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Undine>The warrior's soul breathes life again...", "undine_fc1", 0],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Undine>Angel's dance...", "undine_fc1", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Undine>....................", "undine_fc1", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Undine>Breath of darkness...", "undine_fc1", 0],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Undine>Breath of darkness...", "undine_fc1", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Undine>Magical power, this blade...", "undine_fc1", 0],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Undine>I shall protect us with a magical barrier...", "undine_fc1", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Undine>The sign of Yin and Yang, let me know the truth...", "undine_fc1", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Undine>The world of exorcism, the prison of rebellion... \n Realize your retribution, the Nine Souls Exorcism Formation...", "undine_fc1", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Undine>One piece of life, sending life is life... \n Carving the slightest bit... chanting life...", "undine_fc1", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Undine>Move forward to the left, move to the right and move to the left...The step of the shaman, that is, Yu...", "undine_fc1", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Undine>I'll take \n...", "undine_fc1", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Undine>This is the proof of a thief...", "undine_fc1", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Undine>Now, let's run away...", "undine_fc1", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Undine>I also remember Shinobi's techniques...", "undine_fc1", 0],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Undine>I also remember \n Kunoichi's technique...", "undine_fc1", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Undine>Wave of healing, spread a thousand ways...\nNinja Art: Healing Wave...", "undine_fc1", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Undine>Empty cicada shells of autumn, dancing like shadows... Ninja Art: Doppelganger...", "undine_fc1", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Undine>I'll run away with a smoke bomb...", "undine_fc1", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Undine>I don't want to be a pirate, but...", "undine_fc1", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Undine>I have to fight brilliantly...ha.", "undine_fc1", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Undine>Magical☆Undine, let's go...!", "undine_fc1", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Undine>I don't have much desire for money, but...", "undine_fc1", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Undine>Can you sell me this...?", "undine_fc1", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Undine>I will use \nItem...", "undine_fc1", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Undine>Receive the \n card...", "undine_fc1", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Undine>Let's compete with coins...", "undine_fc1", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Undine>Let's compete in the game of darkness...", "undine_fc1", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Undine>I'll draw the tarot...", "undine_fc1", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Undine>I can hear the voice of the goddess...", "undine_fc1", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Undine>I'll turn the slot...", "undine_fc1", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Undine>Let's play poker...", "undine_fc1", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Undine>Battle card, draw...!", "undine_fc1", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Undine>The power contained in the playing cards...!", "undine_fc1", 0],
      },
      [2002] => { # スペードのキング
        :word_1 => ["\\n<Undine>Receive the King of Spades...", "undine_fc1", 0],
      },
      [2003] => { # クラブのジャック
        :word_1 => ["\\n<Undine>Receive the Jack of Clubs...", "undine_fc1", 0],
      },
      [2004] => { # ダイヤのクィーン
        :word_1 => ["\\n<Undine>Receive the Queen of Diamonds...", "undine_fc1", 0],
      },
      [2005] => { # ハートのエース
        :word_1 => ["\\n<Undine>Receive the Ace of Hearts...", "undine_fc1", 0],
      },
      [2006] => { # ジョーカーデス
        :word_1 => ["\\n<Undine>Too bad, it was a joker...", "undine_fc1", 0],
      },
      [2007] => { # シャッフルカード
        :word_1 => ["\\n<Undine>I wonder which card I will pull...?", "undine_fc1", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Undine>I'll tell you your happiness...", "undine_fc1", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Undine>It's always been my turn...", "undine_fc1", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Undine>I will receive \nItem...", "undine_fc1", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Undine>Look at the water spirit dance...", "undine_fc1", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Undine>That's it! Hustle! Hustle!", "undine_fc1", 0],
      },
      [2018] => { # たつまきダンス
        :word_1 => ["\\n<Undine>Spin spin, whoosh whoosh... Tornado dance...♪", "undine_fc1", 0],
      },
      [2028] => { # エレメンタルダンス
        :word_1 => ["\\n<Undine>Dance with wind and earth...♪ Dance with water and fire...♪", "undine_fc1", 0],
      },
      [2029] => { # 大精霊の舞い
        :word_1 => ["\\n<Undine>Universal Spirit, give me power...", "undine_fc1", 0],
      },
      [9386] => { # コズミックダンス
        :word_1 => ["\\n<Undine>Dance of the twinkling galaxies...♪", "undine_fc1", 0],
      },
      [2037] => { # フェアリーダンス
        :word_1 => ["\\n<Undine>Everyone's a friend...♪\nFairy Dance...♪", "undine_fc1", 0],
      },
      [2038] => { # ミステリーダンス
        :word_1 => ["\\n<Undine>Mystery, mystery...♪", "undine_fc1", 0],
      },
      [2045] => { # 召喚の踊り
        :word_1 => ["\\n<Undine>Lord of the summons, come according to my dance...", "undine_fc1", 0],
      },
      [2050] => { # 生贄の舞い
        :word_1 => ["\\n<Undine>I offer up this life of mine...", "undine_fc1", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Undine>Listen to the water spirit's song...", "undine_fc1", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Undine>Kira☆", "undine_fc1", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Undine>Let's calm down and talk...", "undine_fc1", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Undine>Quite...", "undine_fc1", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Undine>Don't approach, you'll get contaminated...", "undine_fc1", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Undine>Won't you give me money...?", "undine_fc1", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Undine>Won't you give me the item...?", "undine_fc1", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Undine>Don't join us...?", "undine_fc1", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Undine>I'll wrap it up and melt it...", "undine_fc1", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Undine>Quickly disappear...", "undine_fc1", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Undine>Sylph and gnome went hiking...", "undine_fc1", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Undine>A boy who wandered into a spring...", "undine_fc1", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Undine>The ghosts of the women who threw themselves into the fountain...", "undine_fc1", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Undine>Sinking into the spring...", "undine_fc1", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Undine>The power of words...", "undine_fc1", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Undine>I'm also learning science...", "undine_fc1", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Undine>In preparation for such a situation...", "undine_fc1", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Undine>I will convert the energy...", "undine_fc1", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Undine>I will alchemize \nItem...", "undine_fc1", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Undine>Magic book technique, show your power...", "undine_fc1", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Undine>I'll turn this body into a page...", "undine_fc1", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Undine>I had to use Machina...", "undine_fc1", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Undine>I'm going to cook...", "undine_fc1", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Undine>I'll get the ingredients...", "undine_fc1", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Undine>Taste my female...", "undine_fc1", 0],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Undine>I'll make you feel comfortable...", "undine_fc1", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Undine>If you don't treat \n...", "undine_fc1", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Undine>Take this medicine...", "undine_fc1", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Undine>Now, let's get the injection...", "undine_fc1", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Undine>I will spread the \n virus...", "undine_fc1", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Undine>I work sometimes...", "undine_fc1", 0],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Undine>Pleasure service, let's taste it...?", "undine_fc1", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Undine>I was able to brew tea with the spring water...", "undine_fc1", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Undine>Maid change...", "undine_fc1", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Undine>Looks like it's harvest time...", "undine_fc1", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Undine>This is the king's technique...", "undine_fc1", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Undine>This is the king's magic...", "undine_fc1", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Undine>I will summon the \n army...", "undine_fc1", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Undine>Now, ascend to the heavens...", "undine_fc1", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Undine>Bow down to the king's majesty...", "undine_fc1", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Undine>Look at the miracle of the king...", "undine_fc1", 0],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Undine>Yaaaaaaaaa...!!", "undine_fc1", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Undine>Let's go, the hero's special move...", "undine_fc1", 0],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Undine>Come on, I'll make you comfortable...", "undine_fc1", 0],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Undine>Pleasure doesn't work...", "undine_fc1", 0],
      },
      [2609] => { # ダイヤモンドダスト
        :word_1 => ["\\n<Undine>Freeze...", "undine_fc1", 0],
      },
      [2635] => { # スライムとげとげ
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Form my slime into a needle...", "undine_fc1", 0],
      },
      [2636] => { # スライムスプラッシュ
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Take these slime bullets...", "undine_fc1", 0],
      },
      [2637] => { # スライムグングニル
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Pierce, spear of slime...", "undine_fc1", 0],
      },
      [9566] => { # 重加速粘弾
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Heavy accelerated bullet of mucus...Ei...", "undine_fc1", 0],
      },
      [9567] => { # 超重加速粘弾
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Mucus super-heavy accelerated bullet...Ei...", "undine_fc1", 0],
      },
      [2638] => { # スライムドロウ
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>I shall caress you with my slime...", "undine_fc1", 0],
      },
      [2639] => { # スライムヘブン
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>I will wrap your entire body in slime...", "undine_fc1", 0],
      },
      [2640] => { # スライムユートピア
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Ascend to heaven in a utopia of slime...", "undine_fc1", 0],
      },
      [2641] => { # メルトシュトローム
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Melt in the wave of mucus... Meltstrom...", "undine_fc1", 0],
      },
      [2642] => { # ナノシュトローム
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Tsunami that destroys up to Nano Level, Nano Strom...", "undine_fc1", 0],
      },
      [9568] => { # カオスシュトローム
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Drown in chaos...Chaos Strom...", "undine_fc1", 0],
      },
      [2643] => { # 恍惚粘液
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Immerse yourself in ecstasy with this slime...", "undine_fc1", 0],
      },
      [2644] => { # 失禁粘液
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>This slime will make you incontinent...", "undine_fc1", 0],
      },
      [2645] => { # 溶解液
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Melt away...", "undine_fc1", 0],
      },
      [2646] => { # 消化粘液
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Do you want to dissolve into mush...?", "undine_fc1", 0],
      },
      [2647] => { # 消化粘液の渦
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Drown in a whirlpool of digestive slime...", "undine_fc1", 0],
      },
      [2648] => { # ブロブボア
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>I shall assimilate you completely...", "undine_fc1", 0],
      },
      [2649] => { # 蝕肉のレクイエム
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Melt them away, Glutton's Requiem...", "undine_fc1", 0],
      },
      [2650] => { # 消化粘液浸食
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>I shall gradually spread my digestive fluids...", "undine_fc1", 0],
      },
      [2652] => { # ドロドロ粘液天国
        :word_1 => ["\\n<Undine>I'll send you to heaven with mucus...", "undine_fc1", 0],
      },
      [2654] => { # スライム自爆
        :word_1 => ["\\n<Undine>Stand back, I will now self-destruct...", "undine_fc1", 0],
      },
      [2655] => { # 群体核融合
        :word_1 => ["\\n<Undine>Nuclear fusion has begun...", "undine_fc1", 0],
      },
      [9570] => { # 究極群体核融合
        :word_1 => ["\\n<Undine>nuclear fusion starts, whole cell critical reaction...", "undine_fc1", 0],
      },
      [9571] => { # カナディザスター
        :word_1 => ["\\n<Undine>I'll blow everything away...", "undine_fc1", 0],
      },
      [9572] => { # スライムエリクシル
        :word_1 => ["\\n<Undine>Relief with healing slime...", "undine_fc1", 0],
      },
      [9573] => { # カナデの加護
        :word_1 => ["\\n<Undine>Kanade-sama's blessing...", "undine_fc1", 0],
      },
      [2656] => { # スライムヒール
        :word_1 => ["\\n<Undine>I will heal you with slime...", "undine_fc1", 0],
      },
      [2657] => { # スライムメガヒール
        :word_1 => ["\\n<Undine>I will greatly heal you with slime...", "undine_fc1", 0],
      },
      [2658] => { # スライムオールヒール
        :word_1 => ["\\n<Undine>I will heal everyone with slime...", "undine_fc1", 0],
      },
      [2659] => { # スライムオールメガヒール
        :word_1 => ["\\n<Undine>I will bring miraculous healing with slime...", "undine_fc1", 0],
      },
      [2660] => { # スライムキュア
        :word_1 => ["\\n<Undine>I will cure you with slime...", "undine_fc1", 0],
      },
      [2661] => { # スライムオールキュア
        :word_1 => ["\\n<Undine>I will cure everyone with slime...", "undine_fc1", 0],
      },
      [2662] => { # スライムレイズ
        :word_1 => ["\\n<Undine>I will revive you with my slime...", "undine_fc1", 0],
      },
      [2663] => { # アクアシールド
        :word_1 => ["\\n<Undine>Shield of slime, protect us...", "undine_fc1", 0],
      },
      [2664] => { # アクアミラー
        :word_1 => ["\\n<Undine>I'll turn the mucus into a mirror...", "undine_fc1", 0],
      },
      [2665] => { # アクアメタボル
        :word_1 => ["\\n<Undine>I shall protect you with my slime...", "undine_fc1", 0],
      },
      [2666] => { # アクアリジョン
        :word_1 => ["\\n<Undine>I will accelerate your metabolism with my slime...", "undine_fc1", 0],
      },
      [2667] => { # にせものスライム
        :word_1 => ["\\n<Undine>I shall make a clone...", "undine_fc1", 0],
      },
      [2668] => { # 究極スライムディフェンス
        :word_1 => ["\\n<Undine>Protect \n, the ultimate shield...", "undine_fc1", 0],
      },
      [2669] => { # ネバーランドフロンティア
        :word_1 => ["\\n<Undine>Return to your pure form...Neverland Frontier...", "undine_fc1", 0],
      },
      [2670] => { # 分裂
        :word_1 => ["\\n<Undine>I can easily divide myself...", "undine_fc1", 0],
      },
      [2671] => { # ディバインディスティニー
        :word_1 => ["\\n<Undine>I can divide myself many times easily...", "undine_fc1", 0],
      },
      [2672] => { # 究極群体
        :word_1 => ["\\n<Undine>Fill the earth and create the ultimate colony...", "undine_fc1", 0],
      },
      [3028] => { # ファイアボール
        :word_1 => ["\\n<Undine>Rain down, Fireball...", "undine_fc1", 0],
      },
      [3029] => { # 火柱
        :word_1 => ["\\n<Undine>Burst forth, magma of the earth... Flame Pillar...", "undine_fc1", 0],
      },
      [3030] => { # マグマ
        :word_1 => ["\\n<Undine>Fury of the land, turn into scorching heat... Magma...", "undine_fc1", 0],
      },
      [3031] => { # 氷結
        :word_1 => ["\\n<Undine>Be frozen, Freeze...", "undine_fc1", 0],
      },
      [3032] => { # 氷柱
        :word_1 => ["\\n<Undine>Tower through the frozen earth... Icicle...", "undine_fc1", 0],
      },
      [3033] => { # 大氷河
        :word_1 => ["\\n<Undine>Demonstrate silence, eternal freezing... Glacier...", "undine_fc1", 0],
      },
      [3034] => { # 落雷
        :word_1 => ["\\n<Undine>Come, thunder... Thunderbolt...", "undine_fc1", 0],
      },
      [3035] => { # 稲妻
        :word_1 => ["\\n<Undine>Now comes the wrath of the heavens... Lightning...", "undine_fc1", 0],
      },
      [3036] => { # 大轟雷
        :word_1 => ["\\n<Undine>Illuminate the dark night, primordial flash... Thunderclap...", "undine_fc1", 0],
      },
      [3037] => { # かまいたち
        :word_1 => ["\\n<Undine>A blade of wind, Slicing Gust...", "undine_fc1", 0],
      },
      [3038] => { # 突風
        :word_1 => ["\\n<Undine>A raging wind approaches... Squall...", "undine_fc1", 0],
      },
      [3039] => { # 大旋風
        :word_1 => ["\\n<Undine>Violent winds, slice like a thousand blades... Whirlwind...", "undine_fc1", 0],
      },
      [3041] => { # テラサイクロン
        :word_1 => ["\\n<Undine>Nightmare storm, overrun the earth... \n Terra cyclone...", "undine_fc1", 0],
      },
      [3042] => { # 崖崩れ
        :word_1 => ["\\n<Undine>The earth roars... Landslide...", "undine_fc1", 0],
      },
      [3043] => { # 地震
        :word_1 => ["\\n<Undine>Let your body tremble with unwavering fury... Earthquake...", "undine_fc1", 0],
      },
      [3044] => { # 大地の怒り
        :word_1 => ["\\n<Undine>Breath of the planet, let your cry be heard... Wrath of the Earth...", "undine_fc1", 0],
      },
      [3045] => { # 大地咆吼
        :word_1 => ["\\n<Undine>Fiercely roaring, the anger of the mother star... \n The earth roars...", "undine_fc1", 0],
      },
      [3046] => { # 鉄砲水
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>A fierce torrent, Flash Flood...", "undine_fc1", 0],
      },
      [3047] => { # 津波
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Swallow everything and wash it away... Tsunami...", "undine_fc1", 0],
      },
      [3048] => { # 大洪水
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>Taintless stream, cleanse this earth... Great Flood...", "undine_fc1", 0],
      },
      [3049] => { # タイダルウェイブ
        :ct_pic => "80_undine_st01",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Undine>The tyrant's baptism swallows all...\nTidal Wave...", "undine_fc1", 0],
      },
      [3050] => { # 毒沼
        :word_1 => ["\\n<Undine>Toxic miasma, drench this land... Poison Marsh...", "undine_fc1", 0],
      },
      [3051] => { # 猛毒旋風
        :word_1 => ["\\n<Undine>Merciless winds, carry forth miasma... Toxic Whirlwind...", "undine_fc1", 0],
      },
      [3052] => { # 恍惚の風
        :word_1 => ["\\n<Undine>Green breath, whisper sweetly... Winds of Ecstasy...", "undine_fc1", 0],
      },
      [3053] => { # 風のセレナーデ
        :word_1 => ["\\n<Undine>The garden of pleasure sweetly entices you, Wind Serenade...", "undine_fc1", 0],
      },
      [9685] => { # 星吼
        :word_1 => ["\\n<Undine>Sound, the roar of the stars...", "undine_fc1", 0],
      },
      [9686] => { # 星護蝶
        :word_1 => ["\\n<Undine>The light of the end that destroys civilization...", "undine_fc1", 0],
      },
      [3055] => { # フェアリーヒール
        :word_1 => ["\\n<Undine>Great nature, heal their wounds...", "undine_fc1", 0],
      },
      [3056] => { # ワンダーヒール
        :word_1 => ["\\n<Undine>Great nature, heal us all...", "undine_fc1", 0],
      },
      [3057] => { # マジカルライズ
        :word_1 => ["\\n<Undine>Great nature, revive them with your breath of life...", "undine_fc1", 0],
      },
      [3062] => { # 星の癒し
        :word_1 => ["\\n<Undine>Star, give me healing protection...", "undine_fc1", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Undine>It's a simple fix...", "undine_fc1", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Undine>I pray to Mother Nature...", "undine_fc1", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Undine>I have to regain my strength...", "undine_fc1", 0],
      },
      [3103] => { # 魔力集中
        :word_1 => ["\\n<Undine>I'll concentrate my magical power...", "undine_fc1", 0],
      },
      [9775] => { # コンセントレイト
        :word_1 => ["\\n<Undine>Concentration of magical power, Concentrate...", "undine_fc1", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Undine>This is the power of the spirit...", "undine_fc1", 0],
      },
      [3112] => { # 風の戯れ
        :word_1 => ["\\n<Undine>Just like Sylph, I can make my body into a gale...", "undine_fc1", 0],
      },
      [3114] => { # 大地の息吹
        :word_1 => ["\\n<Undine>Just like Gnome, I can take the earth's breath into my body...", "undine_fc1", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Undine>I need to take a deep breath and get in shape...", "undine_fc1", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Undine>If we don't take first aid...", "undine_fc1", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Undine>This is a backwater formation...", "undine_fc1", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Undine>I'm going to clear up my daily frustrations...", "undine_fc1", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Undine>Good boy hero...transformation!", "undine_fc1", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Undine>Transformation, Magical☆Undine... \n I wish I could have a sylph or a gnome do it.", "undine_fc1", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Undine>I'll make you unable to move...", "undine_fc1", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Undine>I'll call for help...", "undine_fc1", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Undine>Get weaker...", "undine_fc1", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Undine>I'll make a fountain here...", "undine_fc1", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Undine>Be quiet...", "undine_fc1", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Undine>What are you wearing in front of me...?", "undine_fc1", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Undine>Ugh♪ Sexy beam...", "undine_fc1", 0],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Undine>ugh♪ Pink Typhoon...", "undine_fc1", 0],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Undine>Uffun♪ Fantastic Hurricane...", "undine_fc1", 0],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Undine>Now, it's my stage...", "undine_fc1", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Undine>Looks like I'll be busy...", "undine_fc1", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Undine>Is it okay to have a body made of mucus...? \n puff puff, puff puff...", "undine_fc1", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Undine>Interesting weapon...", "undine_fc1", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Undine>Time, stop...", "undine_fc1", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Undine>The water witch will bring judgment...", "undine_fc1", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Undine>...Blitzkrieg!!", "undine_fc1", 0],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Undine>Protect me, Brave Wall...", "undine_fc1", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Undine>Don't pollute the water...", "undine_fc1", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Undine>Miracle of the Holy Grail...", "undine_fc1", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Undine>A gentle aura...", "undine_fc1", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Undine>I'll use monster techniques...", "undine_fc1", 0],
      },
      [6157] => { # 深蒼流
        :word_1 => ["\\n<Undine>Swallow the land, deep sea of blue...", "undine_fc1", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Undine>I gave up...", "undine_fc1", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Undine>I will protect \n...", "undine_fc1", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Undine>Assemble!!", "undine_fc1", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Undine>double up!", "undine_fc1", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Undine>Next action, order!", "undine_fc1", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Undine>Concentrate on one point...", "undine_fc1", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Undine>■■■■■■■■■■■■■■■...", "undine_fc1", 0],
      },
      [3509] => { # ヌルヌル攻撃
        :word_1 => ["\\n<Undine>disappear...", "undine_fc1", 0],
      },
      [4900] => { # アクアシェイク
        :word_1 => ["\\n<Undine>If you leak this, you have no qualifications...", "undine_fc1", 0],
        :word_2 => ["\\n<Undine>Endure this pleasure...", "undine_fc1", 0],
        :word_3 => ["\\n<Undine>It will feel good...but please be patient...", "undine_fc1", 0],
      },
      [4901] => { # アクアストローク・誘惑専用
        :word_1 => ["\\n<Undine>How long can you withstand this stimulation...?", "undine_fc1", 0],
        :word_2 => ["\\n<Undine>Come on, let it all out... If you don't mind ending it here...", "undine_fc1", 0],
        :word_3 => ["\\n<Undine>It will be easier if you give in to this torture...", "undine_fc1", 0],
        :word_y1 => ["\\n<Undine>I'll take your semen...", "undine_fc1", 0],
      },
      [4902] => { # アクアストローク
        :word_1 => ["\\n<Undine>How long can you withstand this stimulation...?", "undine_fc1", 0],
        :word_2 => ["\\n<Undine>Come on, climax... If you don't mind ending here...", "undine_fc1", 0],
        :word_3 => ["\\n<Undine>It will be easier if you give in to this torture...", "undine_fc1", 0],
      },
      [4903] => { # アクアプリズン
        :word_1 => ["\\n<Undine>I'll wrap your body...", "undine_fc1", 0],
      },
      [4904] => { # アクアプリズン
        :word_1 => ["\\n<Undine>I'll wrap your body...", "undine_fc1", 0],
      },
      [4905] => { # メルティックアクア
        :word_1 => ["\\n<Undine>Just stay like this and become one with me...", "undine_fc1", 0],
        :word_2 => ["\\n<Undine>Now, end it...", "undine_fc1", 0],
        :word_3 => ["\\n<Undine>I'll just squeeze out your semen and melt it...", "undine_fc1", 0],
        :word_4 => ["\\n<Undine>If you stimulate the genitals, it will leak, right?", "undine_fc1", 0],
        :word_5 => ["\\n<Undine>It's okay to stay like this and get comfortable...", "undine_fc1", 0],
      },
    },
    15 => { # サラマンダー
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Salamander>Ha!", "salamander_fc1", 2],
        :word_2 => ["\\n<Salamander>ti!", "salamander_fc1", 2],
        :word_3 => ["\\n<Salamander>Hyaah!", "salamander_fc1", 2],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Salamander>Slash!", "salamander_fc1", 2],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Salamander>Kill!", "salamander_fc1", 2],
      },
      [917] => { # 切り返し
        :word_1 => ["\\n<Salamander>Backslash... Haa!", "salamander_fc1", 2],
      },
      [918] => { # 疾風突き
        :word_1 => ["\\n<Salamander>Like a gale... Thrust!", "salamander_fc1", 2],
      },
      [919] => { # 払車剣
        :word_1 => ["\\n<Salamander>Brandish, like a wheel... Shockwave Blade!", "salamander_fc1", 2],
      },
      [920] => { # 諸刃斬り
        :word_1 => ["\\n<Salamander>I'm prepared for this... Double-Edged Cut!", "salamander_fc1", 2],
      },
      [921] => { # 隼斬り
        :word_1 => ["\\n<Salamander>Like a falcon... A rapid slash!", "salamander_fc1", 2],
      },
      [932] => { # 烈風剣
        :word_1 => ["\\n<Salamander>Dance, tempestuous steel! Cyclone Blade!", "salamander_fc1", 2],
      },
      [933] => { # 月影の太刀
        :word_1 => ["\\n<Salamander>Dancing in the moonlight... The Shura's mighty blade!", "salamander_fc1", 2],
      },
      [934] => { # 魔神斬り
        :word_1 => ["\\n<Salamander>The cursed god's strike! Haaa!!", "salamander_fc1", 2],
      },
      [935] => { # デッドクラッシュ
        :word_1 => ["\\n<Salamander>Blade of destruction delivers death to all! Dead Crash!", "salamander_fc1", 2],
      },
      [936] => { # 二刀十字斬り
        :word_1 => ["\\n<Salamander>Witness up-close my miraculous technique! Cross-slash!", "salamander_fc1", 2],
      },
      [940] => { # 極竜斬
        :word_1 => ["\\n<Salamander>Taste for yourself, the flaming wrath of dragonfire! Ultra Dragon Slash!", "salamander_fc1", 2],
      },
      [941] => { # ヒートウェイブ
        :word_1 => ["\\n<Salamander>Flashing dragonfire, turn them into dust! Heat Wave!", "salamander_fc1", 2],
      },
      [952] => { # デスバウンド
        :word_1 => ["\\n<Salamander>Dance, cursed blade of the Shura! Deathbound!", "salamander_fc1", 2],
      },
      [963] => { # 皇竜九炎陣
        :word_1 => ["\\n<Salamander>Dance in flames, blade of the lizard king! Dragon Emperor's Flame Slash!", "salamander_fc1", 2],
      },
      [9011] => { # 乱刃・気炎万丈
        :word_1 => ["\\n<Salamander>Entrust the crimson flame to this blade... Ranbana - Kien Banjo!", "salamander_fc1", 2],
      },
      [9012] => { # サウザンドブラッド
        :word_1 => ["\\n<Salamander>Stained with fresh blood...Thousand Blood!", "salamander_fc1", 2],
      },
      [9017] => { # 竜臥閃
        :word_1 => ["\\n<Salamander>Lie down on my sword... Ryuga flash!", "salamander_fc1", 2],
      },
      [9018,9020] => { # 覇光ノ刃
        :word_1 => ["\\n<Salamander>Now, let's cut and tie...!", "salamander_fc1", 2],
      },
      [9019,9021] => { # 覇光ノ刃（発動）
        :word_1 => ["\\n<Salamander>I saw \n... The Blade of Light!", "salamander_fc1", 2],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Salamander>Healing sword, breath of protection!", "salamander_fc1", 2],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Salamander>Pierce!", "salamander_fc1", 2],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Salamander>Have faith in this blade for sure victory!", "salamander_fc1", 2],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Salamander>is cut in two!", "salamander_fc1", 2],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Salamander>Have faith in this white blade for sure victory!", "salamander_fc1", 2],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Salamander>A warrior's end...", "salamander_fc1", 2],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Salamander>Pierce!", "salamander_fc1", 2],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Salamander>Spear, show us a grand miracle!", "salamander_fc1", 2],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Salamander>I place my belief in victory in this spear!", "salamander_fc1", 2],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Salamander>Crush \n!", "salamander_fc1", 2],
      },
      [1099] => { # 暴塵斧
        :word_1 => ["\\n<Salamander>Break them, Violent Axe!", "salamander_fc1", 2],
      },
      [1106] => { # 轟炎斧
        :word_1 => ["\\n<Salamander>Burn them down, Fire Roar Axe!", "salamander_fc1", 2],
      },
      [1109] => { # 轟炎乱斧
        :word_1 => ["\\n<Salamander>Burn to the bone! Violent Inferno Axe!", "salamander_fc1", 2],
      },
      [1115] => { # 微塵連斧
        :word_1 => ["\\n<Salamander>I'll smash you to bits! Pulverizing axe!", "salamander_fc1", 2],
      },
      [1117] => { # タイタンズレガシー
        :word_1 => ["\\n<Salamander>Break like a giant...Titans Legacy!", "salamander_fc1", 2],
      },
      [9065] => { # コスモレガシー
        :word_1 => ["\\n<Salamander>Shatter the galaxy...Cosmo Legacy!", "salamander_fc1", 2],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Salamander>Axe, rage like a blaze!", "salamander_fc1", 2],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Salamander>Crush \n!", "salamander_fc1", 2],
      },
      [1128] => { # 旋棍一閃撃
        :word_1 => ["\\n<Salamander>A swift swing of the club... Spinning Club Strike!", "salamander_fc1", 2],
      },
      [1131] => { # 轟氷撃
        :word_1 => ["\\n<Salamander>Be carved into a glacier! Roaring Ice Club!", "salamander_fc1", 2],
      },
      [1137] => { # スライム潰し
        :word_1 => ["\\n<Salamander>A blow that could even crush Undine...!", "salamander_fc1", 2],
      },
      [1145] => { # 鬼神乱破
        :word_1 => ["\\n<Salamander>Eat this, the kishin's wild onslaught...\nChaotic Kishin Club!", "salamander_fc1", 2],
      },
      [9070] => { # 土精大乱撃
        :word_1 => ["\\n<Salamander>Harnessing the power of the earth... a great earth spirit attack!", "salamander_fc1", 2],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Salamander>Cut off \n!", "salamander_fc1", 2],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Salamander>Be mystified by my scythe's magic!", "salamander_fc1", 2],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Salamander>shoots through!", "salamander_fc1", 2],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Salamander>Healing arrow, bless us with life!", "salamander_fc1", 2],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Salamander>Prostrate!", "salamander_fc1", 2],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Salamander>Come, servant!", "salamander_fc1", 2],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Salamander>Boomerang!", "salamander_fc1", 2],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Salamander>Crush!", "salamander_fc1", 2],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Salamander>I don't really like it, but...", "salamander_fc1", 2],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Salamander>Shoot through \n!", "salamander_fc1", 2],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Salamander>Eat this healing bullet!", "salamander_fc1", 2],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Salamander>A slight slash!", "salamander_fc1", 2],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Salamander>I've even mastered dual wielding...!", "salamander_fc1", 2],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>empty fist, eat!", "salamander_fc1", 2],
      },
      [1400] => { # 足払い
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>An opening! Leg Sweep!", "salamander_fc1", 2],
      },
      [1401] => { # 飛び膝蹴り
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>I've got you! Flying Knee Kick!", "salamander_fc1", 2],
      },
      [1402] => { # 回し蹴り
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Kick them all away, Roundhouse!", "salamander_fc1", 2],
      },
      [1403] => { # 秘孔
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>I see it! Pressure Point!", "salamander_fc1", 2],
      },
      [1405] => { # 正拳突き
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Gather my spirit and... Fist Thrust!", "salamander_fc1", 2],
      },
      [1406] => { # 羅刹掌
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Now, to become one with the rakshasa! Rakshasa Palm!", "salamander_fc1", 2],
      },
      [1407] => { # 爆裂拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>An explosive fist that cannot be stopped by the eyes!", "salamander_fc1", 2],
      },
      [1408] => { # 電塵連脚
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Lightning legs that can't be seen!", "salamander_fc1", 2],
      },
      [1409] => { # 炎舞三連撃
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Burn, Flame Dance Fist!", "salamander_fc1", 2],
      },
      [1410] => { # 氷拳乱雹撃
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Freeze, Ice Rebellion Fist!", "salamander_fc1", 2],
      },
      [1411] => { # 雷神喝撃
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Scatter, Thunder God Fist!", "salamander_fc1", 2],
      },
      [1412] => { # 真空波動掌
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Wave of wind...slice through the air...", "salamander_fc1", 2],
      },
      [1413] => { # 土刻金剛拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Carve the earth, to pierce even diamond!", "salamander_fc1", 2],
      },
      [1414] => { # 波断水裂蹴
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Cut the water's surface...with an instant kick!", "salamander_fc1", 2],
      },
      [1417] => { # 爆炎拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Entrust unto this fist the fire spirit's power... Great Flame Fist!", "salamander_fc1", 2],
      },
      [1418] => { # ドレインキラー
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Life-sucking demon, be destroyed from within by my fist wave!", "salamander_fc1", 2],
      },
      [1425] => { # 聖光裂閃撃
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Gleam, white flash! Light Rending Fist!", "salamander_fc1", 2],
      },
      [1426] => { # 暗黒連衝拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Engrave, black shock! Dark Onslaught Fist!", "salamander_fc1", 2],
      },
      [1427] => { # 四天光掌
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Quad Heaven Palm, tear across the shining heavens!", "salamander_fc1", 2],
      },
      [1428] => { # 四星滅功
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Four Strike Star Destruction, bloom in the dark sky!", "salamander_fc1", 2],
      },
      [1429] => { # 烈気光掌
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>A single blow to shake even the heavens... Spirit Palm!", "salamander_fc1", 2],
      },
      [1430] => { # 瞬獄殺
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>All life must perish...", "salamander_fc1", 2],
      },
      [1431] => { # エレメントフィニッシュ
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Magical fist, engrave the brilliance of eight colors...!", "salamander_fc1", 2],
      },
      [1432] => { # 黒炎十六掌
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Incinerate them, dragon fists! Sixteen Palm Black Flames!", "salamander_fc1", 2],
      },
      [9161] => { # 神竜乱掌
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Strike, Divine Dragon's Fist! Shinryu Ransho!", "salamander_fc1", 2],
      },
      [9163] => { # 破滅の鉄槌
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>The judgment of the fist... the hammer of destruction!", "salamander_fc1", 2],
      },
      [9156] => { # 零拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>scatters, a subzero freezing fist... Zero Fist!", "salamander_fc1", 2],
      },
      [9169] => { # 九星覇影弾
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Kyusei's camp, run on the ground...Kyuusei Hakage Bullet!", "salamander_fc1", 2],
      },
      [9165] => { # 聖天轟裂撃
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Breath of white light... Sacred Heaven's roar ruptures!", "salamander_fc1", 2],
      },
      [9166] => { # 魔天冥煌撃
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Breath of darkness... Demon heaven's glittering attack!", "salamander_fc1", 2],
      },
      [9167] => { # 覆滅陰陽撃
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "salamander_fc1", 2],
      },
      [9173] => { # 天地開闢拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Open the heavens and destroy the earth... Heaven and Earth Opening Fist!", "salamander_fc1", 2],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Salamander>....................", "salamander_fc1", 2],
      },
      [1434] => { # 当て身光掌（発動）
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>I received \n... ​​Amitami light palm!", "salamander_fc1", 2],
      },
      [1435] => { # 金剛八連拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "salamander_fc1", 2],
      },
      [1436] => { # 紅蓮大拳舞
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Dance in disorder, crimson flame! Guren Daikenbu!", "salamander_fc1", 2],
      },
      [9157] => { # 電塵乱皇脚
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Flash, noble thunder! Denjinran Kokyaku!", "salamander_fc1", 2],
      },
      [9159] => { # 真・瞬獄殺
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>The living will be destroyed, all things will be destroyed... \n This fist has no enemy!", "salamander_fc1", 2],
      },
      [9164] => { # 修羅爆裂拳
        :ct_pic => "80_salamander_st03",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Salamander>Shura's fist hits wildly!　Aaah!!", "salamander_fc1", 2],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Salamander>Drown in pleasure...!", "salamander_fc1", 2],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Salamander>Heal, pulse of the heavens... Chakra!", "salamander_fc1", 2],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Salamander>Heal, pulse of the heavens... Chakra!", "salamander_fc1", 2],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Salamander>Heal, pulse of the heavens... Diffusive Chakra!", "salamander_fc1", 2],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Salamander>Heal the Heavenly Veins...Ultimate Chakra!", "salamander_fc1", 2],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Salamander>Breathe once more... Haa!", "salamander_fc1", 2],
      },
      [1451] => { # 裏蘇生
        :word_1 => ["\\n<Salamander>The forbidden resurrection art... Haa!", "salamander_fc1", 2],
      },
      [1452] => { # 三魔の拳
        :word_1 => ["\\n<Salamander>Breath of the three magics, imbue these fists!", "salamander_fc1", 2],
      },
      [1453] => { # 四精の拳
        :word_1 => ["\\n<Salamander>Breath of the Four Spirits, imbue these fists!", "salamander_fc1", 2],
      },
      [1454] => { # 聖魔の拳
        :word_1 => ["\\n<Salamander>Breath of the two energies, imbue these fists!", "salamander_fc1", 2],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Salamander>Gather the pulse of magic into my fists!", "salamander_fc1", 2],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Salamander>White torrent, heal your injured body!", "salamander_fc1", 2],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Salamander>White torrent, heal your injured body!", "salamander_fc1", 2],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Salamander>White torrent, destroy the darkness!", "salamander_fc1", 2],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Salamander>Immortal high will, bring evil to God's mercy! \n Heaven!", "salamander_fc1", 2],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Salamander>White torrent, give me power!", "salamander_fc1", 2],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Salamander>White torrent, prevent evil power!", "salamander_fc1", 2],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Salamander>A white torrent that hates evil, protects the devil and exorcises the wall! \n Cancelled!", "salamander_fc1", 2],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Salamander>Black torrent, obey my orders!", "salamander_fc1", 2],
      },
      [1514] => { # ウィンド
        :word_1 => ["\\n<Salamander>Dancing wind, become a blade to slice them to pieces! Wind!", "salamander_fc1", 2],
      },
      [1515] => { # エアロ
        :word_1 => ["\\n<Salamander>Violent wind, rage like a ceaseless storm!\nAero!", "salamander_fc1", 2],
      },
      [1516] => { # デルタエアロ
        :word_1 => ["\\n<Salamander>Boundless green, dancing with energy!\nBecome a sixfold cyclone, Delta Aero!", "salamander_fc1", 2],
      },
      [1524] => { # ドラゴンフレア
        :word_1 => ["\\n<Salamander>Burn up the dragon's soul! Dragon Flare!", "salamander_fc1", 2],
      },
      [1525] => { # ドラゴンフレアバースト
        :word_1 => ["\\n<Salamander>The flame of beginning that rules everything... \n Realize reincarnation! Dragon Flare Burst!", "salamander_fc1", 2],
      },
      [1526] => { # ドラゴングレイズ
        :word_1 => ["\\n<Salamander>Dance wildly, the dragon's soul...Dragon Glaze!", "salamander_fc1", 2],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Salamander>Reaper's scythe which harvests life, lead their soul to Hades! Death!", "salamander_fc1", 2],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Salamander>Torrent of black, heed my call!", "salamander_fc1", 2],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Salamander>Tranquil breeze of life, blow and become a squall of grace! Heal Typhoon!", "salamander_fc1", 2],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Salamander>The torrent of time, follow my will and carve your steps!", "salamander_fc1", 2],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Salamander>The torrent of time, distort time and space and bring destruction!", "salamander_fc1", 2],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Salamander>Holy light, dispel the darkness!", "salamander_fc1", 2],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Salamander>Drown in pleasure...!", "salamander_fc1", 2],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Salamander>Holy light, bring healing!", "salamander_fc1", 2],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Salamander>I dedicate this life to heaven...!", "salamander_fc1", 2],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Salamander>The soul of the warrior, revive!", "salamander_fc1", 2],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Salamander>It's an angel's move...!", "salamander_fc1", 2],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Salamander>....................", "salamander_fc1", 2],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Salamander>The power of darkness, blaze...!", "salamander_fc1", 2],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Salamander>The power of darkness, blaze...!", "salamander_fc1", 2],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Salamander>Residing in the sword, my magic!", "salamander_fc1", 2],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Salamander>Expand, magical barrier!", "salamander_fc1", 2],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Salamander>The sign of Yin and Yang, let me know the truth!", "salamander_fc1", 2],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Salamander>The law of exorcism, the prison of rebellion! \n Realize your retribution, Nine Souls Exorcism Team!", "salamander_fc1", 2],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Salamander>A lifetime, sending it is life! \n Carve out the slightest...Singing of life!", "salamander_fc1", 2],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Salamander>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "salamander_fc1", 2],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Salamander>I'll give you \n!", "salamander_fc1", 2],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Salamander>This is a thief's technique!", "salamander_fc1", 2],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Salamander>I'm reluctant to do so, but we're withdrawing...", "salamander_fc1", 2],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Salamander>I also have knowledge of ninjutsu!!", "salamander_fc1", 2],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Salamander>Drown in pleasure...!", "salamander_fc1", 2],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Salamander>Wave of healing, spread a thousand ways...\nNinja Art: Healing Wave!", "salamander_fc1", 2],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Salamander>Empty cicada shells of autumn, dancing like shadows... Ninja Art: Doppelganger!", "salamander_fc1", 2],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Salamander>Didn't think I'd have to flee using a smoke distraction...", "salamander_fc1", 2],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Salamander>Pirates have a knack for tricks!", "salamander_fc1", 2],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Salamander>The anger of the flame dwells in this body... Ha!", "salamander_fc1", 2],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :word_1 => ["\\n<Salamander>Magical☆Salamander...\n...Don't look.", "salamander_fc1", 2],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Salamander>I don't like making money tell me things, but...", "salamander_fc1", 2],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Salamander>Would you like me to sell you this...", "salamander_fc1", 2],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Salamander>Use \nItem!", "salamander_fc1", 2],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Salamander>The \n card can also be used as a weapon...", "salamander_fc1", 2],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Salamander>Shall we have a coin toss?", "salamander_fc1", 2],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Salamander>Shall we play a shady game?", "salamander_fc1", 2],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Salamander>I'll tell your fate with a tarot...", "salamander_fc1", 2],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Salamander>I don't even want to hear the Goddess's voice...", "salamander_fc1", 2],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Salamander>I shouldn't get too hooked on slots...", "salamander_fc1", 2],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Salamander>I shouldn't get too hooked on poker...", "salamander_fc1", 2],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Salamander>battle card, draw!", "salamander_fc1", 2],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Salamander>Let's show the power of Trump!", "salamander_fc1", 2],
      },
      [2002] => { # スペードのキング
        :word_1 => ["\\n<Salamander>I'll show you the power of the King of Spades!", "salamander_fc1", 2],
      },
      [2003] => { # クラブのジャック
        :word_1 => ["\\n<Salamander>I'll show you the power of the Jack of Clubs!", "salamander_fc1", 2],
      },
      [2004] => { # ダイヤのクィーン
        :word_1 => ["\\n<Salamander>I'll show you the power of the Queen of Diamonds!", "salamander_fc1", 2],
      },
      [2005] => { # ハートのエース
        :word_1 => ["\\n<Salamander>I'll show you the power of the Ace of Hearts!", "salamander_fc1", 2],
      },
      [2006] => { # ジョーカーデス
        :word_1 => ["\\n<Salamander>Too bad, it was a joker!", "salamander_fc1", 2],
      },
      [2007] => { # シャッフルカード
        :word_1 => ["\\n<Salamander>Who knows which card I'll draw...", "salamander_fc1", 2],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Salamander>I hope you'll see the lucky star...", "salamander_fc1", 2],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Salamander>It's always my turn!", "salamander_fc1", 2],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Salamander>Let's receive \nItem...!", "salamander_fc1", 2],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Salamander>Even with this, the Four Spirits will protect my dance!", "salamander_fc1", 2],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Salamander>That's it! Hustle! Hustle!", "salamander_fc1", 2],
      },
      [2018] => { # たつまきダンス
        :word_1 => ["\\n<Salamander>Tornado Dance, spin round and rooound!\n...Even if that's how Sylph does it, it doesn't suit me.", "salamander_fc1", 2],
      },
      [2028] => { # エレメンタルダンス
        :word_1 => ["\\n<Salamander>Wind and earth, water and fire... Show your fury♪", "salamander_fc1", 2],
      },
      [2029] => { # 大精霊の舞い
        :word_1 => ["\\n<Salamander>Sylph, gnome, water slime...let's go!", "salamander_fc1", 2],
      },
      [9386] => { # コズミックダンス
        :word_1 => ["\\n<Salamander>Dancing in the dazzling galaxy...♪", "salamander_fc1", 2],
      },
      [2037] => { # フェアリーダンス
        :word_1 => ["\\n<Salamander>Fairy Dance, I invite you to be friends...♪", "salamander_fc1", 2],
      },
      [2038] => { # ミステリーダンス
        :word_1 => ["\\n<Salamander>Mystery, mystery...♪", "salamander_fc1", 2],
      },
      [2045] => { # 召喚の踊り
        :word_1 => ["\\n<Salamander>Lord of summons, respond to my dance...♪", "salamander_fc1", 2],
      },
      [2050] => { # 生贄の舞い
        :word_1 => ["\\n<Salamander>I offer up this life of mine...♪", "salamander_fc1", 2],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Salamander>I don't know much about singing...", "salamander_fc1", 2],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Salamander>Kira☆", "salamander_fc1", 2],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Salamander>Can we talk for a moment?", "salamander_fc1", 2],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Salamander>Looks like a pretty good plot...", "salamander_fc1", 2],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Salamander>This isn't worth talking about, come back!", "salamander_fc1", 2],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Salamander>I need some money...", "salamander_fc1", 2],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Salamander>I need an item...", "salamander_fc1", 2],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Salamander>Would you be fine with being my apprentice?", "salamander_fc1", 2],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Salamander>Do you want to be burned to a crisp...?", "salamander_fc1", 2],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Salamander>I'm not taking any apprentices, now get out of here already...", "salamander_fc1", 2],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Salamander>Granberia was in the middle of training when the lava...", "salamander_fc1", 2],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Salamander>Whenever male warriors come to me seeking apprenticeship, I do this under the guise of test...", "salamander_fc1", 2],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Salamander>When I showed my face around the Forest of Spirits, I heard Sylph crying...", "salamander_fc1", 2],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Salamander>My name is Salamander, though I'm not \\*\\fba\\*\\fb salamander. At the volcano, I'm what you call a relaxalotl.", "salamander_fc1", 1],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Salamander>My words have a soul...!", "salamander_fc1", 2],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Salamander>The power of science can't be underestimated...!", "salamander_fc1", 2],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Salamander>I'm used to extreme environments!", "salamander_fc1", 2],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Salamander>Converts energy!", "salamander_fc1", 2],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Salamander>Let's alchemize \nItem!", "salamander_fc1", 2],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Salamander>Magic book technique, show your power!", "salamander_fc1", 2],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Salamander>I'm turning into pages...?", "salamander_fc1", 2],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Salamander>It's a convenience of civilization, it's not bad...", "salamander_fc1", 2],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Salamander>Let's cook, I hope it doesn't turn into charcoal waste...", "salamander_fc1", 2],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Salamander>I'll get some ingredients...!", "salamander_fc1", 2],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Salamander>It's a small knife...!", "salamander_fc1", 2],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Salamander>Drown in pleasure...!", "salamander_fc1", 2],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Salamander>Now, let's start the treatment!", "salamander_fc1", 2],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Salamander>Now, take this medicine!", "salamander_fc1", 2],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Salamander>For those who don't know, this is an injection!", "salamander_fc1", 2],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Salamander>Let's spread a special virus...", "salamander_fc1", 2],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Salamander>I'm surprisingly homely...", "salamander_fc1", 2],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Salamander>Drown in pleasure...!", "salamander_fc1", 2],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Salamander>The tea is brewed, but it's boiling...", "salamander_fc1", 2],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Salamander>Maid change...!", "salamander_fc1", 2],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Salamander>Come on, it's time to harvest!", "salamander_fc1", 2],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Salamander>Take the king's sword with your own body!", "salamander_fc1", 2],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Salamander>Experience the king's magic for yourself!", "salamander_fc1", 2],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Salamander>Summon my army!", "salamander_fc1", 2],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Salamander>Now, I invite you to heaven!", "salamander_fc1", 2],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Salamander>Bow down before the Fire Spirit's authority!", "salamander_fc1", 2],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Salamander>Look at the miracle of the king!", "salamander_fc1", 2],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Salamander>Doryaaaaaa...!!", "salamander_fc1", 2],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Salamander>Am I the hero? That's interesting too...!", "salamander_fc1", 2],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Salamander>Come on, writhe in pleasure!", "salamander_fc1", 2],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Salamander>I'll endure the pleasure...!", "salamander_fc1", 2],
      },
      [2596] => { # 竜魂魔導
        :word_1 => ["\\n<Salamander>Awaken, true dragon's soul!", "salamander_fc1", 2],
      },
      [2678] => { # 引っ掻き
        :word_1 => ["\\n<Salamander>Eat these claws!", "salamander_fc1", 2],
      },
      [2686] => { # 噛み付き
        :word_1 => ["\\n<Salamander>I'll tear you apart with these fangs!", "salamander_fc1", 2],
      },
      [2689] => { # 双炎牙
        :word_1 => ["\\n<Salamander>I'll crush you with fiery fangs!", "salamander_fc1", 2],
      },
      [2690] => { # バーミリオンファング
        :word_1 => ["\\n<Salamander>Take these scorching fangs!", "salamander_fc1", 2],
      },
      [2691] => { # 絶氷牙
        :word_1 => ["\\n<Salamander>I'll crush you with icy fangs!", "salamander_fc1", 2],
      },
      [2692] => { # 断氷連牙
        :word_1 => ["\\n<Salamander>Shred, merciless fangs of ice!", "salamander_fc1", 2],
      },
      [2696] => { # 蹂躙撃
        :word_1 => ["\\n<Salamander>I'll trample you....!", "salamander_fc1", 2],
      },
      [2698] => { # おたけび
        :word_1 => ["\\n<Salamander>Raaaaah...!!", "salamander_fc1", 2],
      },
      [2699] => { # 破壊の咆吼
        :word_1 => ["\\n<Salamander>Raaaaaaah!!", "salamander_fc1", 2],
      },
      [2734] => { # 凍てつく波動
        :word_1 => ["\\n<Salamander>Let's erase that blessing!", "salamander_fc1", 0],
      },
      [2830] => { # 羽ばたき
        :word_1 => ["\\n<Salamander>I'll blow you away!", "salamander_fc1", 2],
      },
      [2831] => { # 強風
        :word_1 => ["\\n<Salamander>A fierce gale!", "salamander_fc1", 2],
      },
      [2832] => { # 超風
        :word_1 => ["\\n<Salamander>I'll blow everything away... Cyclone!", "salamander_fc1", 2],
      },
      [3028] => { # ファイアボール
        :word_1 => ["\\n<Salamander>Rain down, Fireball!", "salamander_fc1", 2],
      },
      [3029] => { # 火柱
        :word_1 => ["\\n<Salamander>Burst forth, magma of the earth! Flame Pillar", "salamander_fc1", 2],
      },
      [3030] => { # マグマ
        :word_1 => ["\\n<Salamander>Fury of the land, turn into scorching heat... Magma!", "salamander_fc1", 2],
      },
      [3031] => { # 氷結
        :word_1 => ["\\n<Salamander>Be frozen, Freeze!", "salamander_fc1", 2],
      },
      [3032] => { # 氷柱
        :word_1 => ["\\n<Salamander>Tower through the frozen earth! Icicle!", "salamander_fc1", 2],
      },
      [3033] => { # 大氷河
        :word_1 => ["\\n<Salamander>Demonstrate silence, eternal freezing... Glacier!", "salamander_fc1", 2],
      },
      [3034] => { # 落雷
        :word_1 => ["\\n<Salamander>Come, thunder! Thunderbolt!", "salamander_fc1", 2],
      },
      [3035] => { # 稲妻
        :word_1 => ["\\n<Salamander>Now comes the wrath of the heavens! Lightning!", "salamander_fc1", 2],
      },
      [3036] => { # 大轟雷
        :word_1 => ["\\n<Salamander>Illuminate the dark night, primordial flash... Thunderclap!", "salamander_fc1", 2],
      },
      [3037] => { # かまいたち
        :word_1 => ["\\n<Salamander>A blade of wind, Slicing Gust!", "salamander_fc1", 2],
      },
      [3038] => { # 突風
        :word_1 => ["\\n<Salamander>A raging wind approaches! Squall!", "salamander_fc1", 2],
      },
      [3039] => { # 大旋風
        :word_1 => ["\\n<Salamander>Violent winds, slice like a thousand blades! Whirlwind!", "salamander_fc1", 2],
      },
      [3041] => { # テラサイクロン
        :word_1 => ["\\n<Salamander>Nightmare storm, overwhelm the earth! \n Terra Cyclone!", "salamander_fc1", 2],
      },
      [3042] => { # 崖崩れ
        :word_1 => ["\\n<Salamander>The earth roars! Landslide!", "salamander_fc1", 2],
      },
      [3043] => { # 地震
        :word_1 => ["\\n<Salamander>Let your body tremble with unwavering fury! Earthquake!", "salamander_fc1", 2],
      },
      [3044] => { # 大地の怒り
        :word_1 => ["\\n<Salamander>Breath of the planet, let your cry be heard! Wrath of the Earth!", "salamander_fc1", 2],
      },
      [3045] => { # 大地咆吼
        :word_1 => ["\\n<Salamander>Fiercely roaring, the anger of the mother star! \n Earth roar...!", "salamander_fc1", 2],
      },
      [3046] => { # 鉄砲水
        :word_1 => ["\\n<Salamander>A fierce torrent, Flash Flood!", "salamander_fc1", 2],
      },
      [3049] => { # タイダルウェイブ
        :word_1 => ["\\n<Salamander>The tyrant's baptism swallows all!\nTidal Wave!", "salamander_fc1", 2],
      },
      [3047] => { # 津波
        :word_1 => ["\\n<Salamander>Swallow everything and wash it away! Tsunami!", "salamander_fc1", 2],
      },
      [3048] => { # 大洪水
        :word_1 => ["\\n<Salamander>Taintless stream, cleanse this earth! Great Flood!", "salamander_fc1", 2],
      },
      [3049] => { # タイダルウェイブ
        :word_1 => ["\\n<Salamander>The tyrant's baptism swallows all!\nTidal Wave!", "salamander_fc1", 2],
      },
      [3050] => { # 毒沼
        :word_1 => ["\\n<Salamander>Toxic miasma, drench this land! Poison Marsh!", "salamander_fc1", 2],
      },
      [3051] => { # 猛毒旋風
        :word_1 => ["\\n<Salamander>Merciless winds, carry forth miasma... Toxic Whirlwind!", "salamander_fc1", 2],
      },
      [3052] => { # 恍惚の風
        :word_1 => ["\\n<Salamander>Green breath, whisper sweetly! Winds of Ecstasy!", "salamander_fc1", 2],
      },
      [3053] => { # 風のセレナーデ
        :word_1 => ["\\n<Salamander>The garden of pleasure sweetly entices you, Wind Serenade!", "salamander_fc1", 2],
      },
      [9685] => { # 星吼
        :word_1 => ["\\n<Salamander>Sound, the roar of the stars!", "salamander_fc1", 2],
      },
      [9686] => { # 星護蝶
        :word_1 => ["\\n<Salamander>The light of the end that will destroy civilization!!", "salamander_fc1", 2],
      },
      [3055] => { # フェアリーヒール
        :word_1 => ["\\n<Salamander>Great nature, heal our wounds!", "salamander_fc1", 2],
      },
      [3056] => { # ワンダーヒール
        :word_1 => ["\\n<Salamander>Great nature, heal us all!", "salamander_fc1", 2],
      },
      [3057] => { # マジカルライズ
        :word_1 => ["\\n<Salamander>Great nature, bring forth your breath of life!", "salamander_fc1", 2],
      },
      [3062] => { # 星の癒し
        :word_1 => ["\\n<Salamander>Star, give us healing blessings...!", "salamander_fc1", 2],
      },
      [3102] => { # 竜鋼体
        :word_1 => ["\\n<Salamander>Steel myself with a dragon's spirit... Haaa!", "salamander_fc1", 2],
      },
      [3068] => { # 火の息
        :word_1 => ["\\n<Salamander>Taste my fiery breath!", "salamander_fc1", 2],
      },
      [3069] => { # 火炎の息
        :word_1 => ["\\n<Salamander>Burn in my breath of flames!", "salamander_fc1", 2],
      },
      [3070] => { # 激しい炎
        :word_1 => ["\\n<Salamander>You'll be burned you to a crisp from my infernal flames!", "salamander_fc1", 2],
      },
      [3071] => { # 灼熱の炎
        :word_1 => ["\\n<Salamander>You'll be reduced to ashes from this white-hot inferno!", "salamander_fc1", 2],
      },
      [3072] => { # 煉獄の火炎
        :word_1 => ["\\n<Salamander>Burn out, the flames of purgatory...!", "salamander_fc1", 2],
      },
      [9585] => { # 神竜乱牙
        :word_1 => ["\\n<Salamander>Break, True Dragon's Fang!", "salamander_fc1", 2],
      },
      [9586] => { # 虚竜牙
        :word_1 => ["\\n<Salamander>Destroy the Fang of the Void Dragon!", "salamander_fc1", 2],
      },
      [9687] => { # 神竜大海嘯
        :word_1 => ["\\n<Salamander>Come, the great ocean called by the divine dragon!", "salamander_fc1", 2],
      },
      [9688] => { # 虚竜の大海嘯
        :word_1 => ["\\n<Salamander>Return the tsunami of nothingness to zero!", "salamander_fc1", 2],
      },
      [3073] => { # 核熱の息
        :word_1 => ["\\n<Salamander>I'll wipe it out with my nuclear heat breath!", "salamander_fc1", 2],
      },
      [3078] => { # 量子の息
        :word_1 => ["\\n<Salamander>Shatter with quantum breath!", "salamander_fc1", 2],
      },
      [9692] => { # 無塵焔
        :word_1 => ["\\n<Salamander>A dustless flame that leaves no dust behind...!", "salamander_fc1", 2],
      },
      [3074] => { # 冷たい息
        :word_1 => ["\\n<Salamander>Taste my cold breath...!", "salamander_fc1", 2],
      },
      [3075] => { # 凍り付く息
        :word_1 => ["\\n<Salamander>Freeze until you shatter...!", "salamander_fc1", 2],
      },
      [3076] => { # 凍える吹雪
        :word_1 => ["\\n<Salamander>Rot away in a blizzard...!", "salamander_fc1", 2],
      },
      [3077] => { # 輝く息
        :word_1 => ["\\n<Salamander>This frigid breath will freeze your very soul...!", "salamander_fc1", 2],
      },
      [9693] => { # 極零光
        :word_1 => ["\\n<Salamander>Disappear in the frigid light... polar zero light!", "salamander_fc1", 2],
      },
      [3087] => { # 焼け付く息
        :word_1 => ["\\n<Salamander>Now, go numb...!", "salamander_fc1", 2],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Salamander>This'll be easy to treat...", "salamander_fc1", 2],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Salamander>Pray to myself...", "salamander_fc1", 2],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Salamander>I'm going seriously!", "salamander_fc1", 2],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Salamander>Charging power...!", "salamander_fc1", 2],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Salamander>I'm getting fired up...!", "salamander_fc1", 2],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Salamander>Going full power..!", "salamander_fc1", 2],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Salamander>Focus my mind into my fists...!", "salamander_fc1", 2],
      },
      [3100] => { # 裏練気
        :word_1 => ["\\n<Salamander>Focus my inner mind into my fist...!", "salamander_fc1", 2],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Salamander>My body is like steel...!", "salamander_fc1", 2],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Salamander>The ultimate in concentration, the final effort!", "salamander_fc1", 2],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Salamander>The power of elementals!", "salamander_fc1", 2],
      },
      [3112] => { # 風の戯れ
        :word_1 => ["\\n<Salamander>Did you think I couldn't use the wind's power...?", "salamander_fc1", 2],
      },
      [3114] => { # 大地の息吹
        :word_1 => ["\\n<Salamander>Did you think I couldn't use the earth's power...?", "salamander_fc1", 2],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Salamander>Take a deep breath...", "salamander_fc1", 2],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Salamander>Take some emergency measures...", "salamander_fc1", 2],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Salamander>This is when a warrior's duty matters most!", "salamander_fc1", 2],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Salamander>Now, I'm going to demolish everything!", "salamander_fc1", 2],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Salamander>Transformation... He's a hero of fire!", "salamander_fc1", 2],
      },
      [3128, 9784] => { # 魔法少女変身
        :word_1 => ["\\n<Salamander>Transformation, Magical☆Salamander...Don't look at me.", "salamander_fc1", 2],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Salamander>I'll restrain your movement!", "salamander_fc1", 2],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Salamander>I'm calling for reinforcements!", "salamander_fc1", 2],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Salamander>I'll break your power!", "salamander_fc1", 2],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Salamander>I read the clue... here!", "salamander_fc1", 2],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Salamander>That's enough already!", "salamander_fc1", 2],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Salamander>You haven't trained enough, I'm confiscating your underwear!", "salamander_fc1", 2],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Salamander>Teehee♪ Sexy Beam!", "salamander_fc1", 2],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Salamander>Teehee♪ Pink Typhoon!", "salamander_fc1", 2],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Salamander>Uffun♪ Fantastic Hurricane!", "salamander_fc1", 2],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Salamander>Now, it's my stage!", "salamander_fc1", 2],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Salamander>I'm willing to work too...!", "salamander_fc1", 2],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Salamander>Try not to get yourself burned...\nPuff puff, puff puff...", "salamander_fc1", 2],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Salamander>Look at the power of this weapon!", "salamander_fc1", 2],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Salamander>Time, stop!", "salamander_fc1", 2],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Salamander>This is the power of grudge...!", "salamander_fc1", 2],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Salamander>...Blitzkrieg!!", "salamander_fc1", 2],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Salamander>Defend \n, Brave Wall!", "salamander_fc1", 2],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Salamander>Grudge, burn up...!", "salamander_fc1", 2],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Salamander>Look at the miracle of the Holy Grail!", "salamander_fc1", 2],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Salamander>Look at the power of the aura!", "salamander_fc1", 2],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Salamander>Use monster techniques!", "salamander_fc1", 2],
      },
      [6158] => { # アグニの焦炎
        :word_1 => ["\\n<Salamander>Burn into dust...! Raaaah!!", "salamander_fc1", 2],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Salamander>I gave up!", "salamander_fc1", 2],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Salamander>Become a guardian...!", "salamander_fc1", 2],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Salamander>Assemble!!", "salamander_fc1", 2],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Salamander>Double up!", "salamander_fc1", 2],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Salamander>Next action, order!", "salamander_fc1", 2],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Salamander>I will concentrate my power on one point!", "salamander_fc1", 2],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Salamander>■■■■■■■■■■■■■■■...", "salamander_fc1", 2],
      },
      [5155] => { # 禁撃連握・誘惑専用
        :word_1 => ["\\n<Salamander>Can you see through this technique?", "salamander_fc1", 0],
        :word_2 => ["\\n<Salamander>I didn't want to leave a man's weakness full of gaps!", "salamander_fc1", 0],
        :word_3 => ["\\n<Salamander>Writhe in agony with this technique!", "salamander_fc1", 0],
        :word_y1 => ["\\n<Salamander>I'm taking your semen..!", "salamander_fc1", 2],
      },
      [5156] => { # 火神連脚
        :word_1 => ["\\n<Salamander>Eat my foot technique!", "salamander_fc1", 0],
        :word_2 => ["\\n<Salamander>slow! My upper body is empty!", "salamander_fc1", 0],
        :word_3 => ["\\n<Salamander>Writhe in agony with this foot technique!", "salamander_fc1", 0],
      },
      [5157] => { # 火神連脚
        :word_1 => ["\\n<Salamander>Eat my foot technique!", "salamander_fc1", 0],
        :word_2 => ["\\n<Salamander>slow! My upper body is empty!", "salamander_fc1", 0],
        :word_3 => ["\\n<Salamander>Writhe in agony with this foot technique!", "salamander_fc1", 0],
      },
      [5158] => { # 火龍の抱擁
        :word_1 => ["\\n<Salamander>Not yet...! Writhe in my chest!", "salamander_fc1", 0],
        :word_2 => ["\\n<Salamander>Fufu, my heart must be hot...!", "salamander_fc1", 0],
        :word_3 => ["\\n<Salamander>Let's hug each other even more!", "salamander_fc1", 0],
      },
      [5159] => { # 火龍の抱擁
        :word_1 => ["\\n<Salamander>Will you try to end it with my embrace...?", "salamander_fc1", 0],
        :word_2 => ["\\n<Salamander>I'm also good at closing techniques...!", "salamander_fc1", 0],
        :word_3 => ["\\n<Salamander>You must be immature to allow someone to approach you like this!", "salamander_fc1", 0],
      },
      [5160] => { # フレイムシュタイナー
        :word_1 => ["\\n<Salamander>My techniques are ever-changing, and I can do whatever I want with my throwing techniques and closing techniques!", "salamander_fc1", 0],
        :word_2 => ["\\n<Salamander>Hey, how about this kind of technique! ?", "salamander_fc1", 0],
        :word_3 => ["\\n<Salamander>I'm going to go a little harder!", "salamander_fc1", 0],
      },
    },
    16 => { # グランベリア
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Granberia>Hyaah!", "granberia_fc3", 4],
        :word_2 => ["\\n<Granberia>Huh!", "granberia_fc3", 4],
        :word_3 => ["\\n<Granberia>Kill!", "granberia_fc3", 4],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Granberia>Even if it is a knife, there is no stagnation in my blade...!", "granberia_fc3", 4],
      },
      [*917..975, *9008..9025] => { # 剣技
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sword...!", "granberia_fc3", 4],
      },
      [917] => { # 切り返し
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Cut back... Ha!", "granberia_fc3", 4],
      },
      [918] => { # 疾風突き
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Like the wind... it penetrates!", "granberia_fc3", 4],
      },
      [919] => { # 払車剣
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Sword flash, like a wheel...shake sword!", "granberia_fc3", 4],
      },
      [920] => { # 諸刃斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>With determination in mind...a double-edged blade!", "granberia_fc3", 4],
      },
      [921] => { # 隼斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Like a falcon...slash multiple times!", "granberia_fc3", 4],
      },
      [922] => { # 火炎斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Take shelter, flame... Ha!", "granberia_fc3", 4],
      },
      [923] => { # 氷斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Take shelter, ice... Ha!", "granberia_fc3", 4],
      },
      [924] => { # 稲妻斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Take shelter, lightning... Ha!", "granberia_fc3", 4],
      },
      [931] => { # 真空斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Vacuum blade... Ha!", "granberia_fc3", 4],
      },
      [932] => { # 烈風剣
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Dance, blade of fierce wind!　Aaah!!", "granberia_fc3", 4],
      },
      [933] => { # 月影の太刀
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>May dances... Shura's sword!", "granberia_fc3", 4],
      },
      [934] => { # 魔神斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Majin's blow! Sei!!", "granberia_fc3", 4],
      },
      [935] => { # デッドクラッシュ
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>The blade of destruction brings death... Dead Crash!", "granberia_fc3", 4],
      },
      [936] => { # 二刀十字斬り
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Get close to \n and take a look! Two-sword cross slash!", "granberia_fc3", 4],
      },
      [940] => { # 極竜斬
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Carve the dragon's anger into your body! Gokuryuzan!", "granberia_fc3", 4],
      },
      [941] => { # ヒートウェイブ
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>The dragon's sword flashes into pieces! Heatwave!", "granberia_fc3", 4],
      },
      [942] => { # フレイムスラッシュ
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Burn it down, a flash of red... \n Flame Slash!", "granberia_fc3", 4],
      },
      [943] => { # アイススラッシュ
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Freezing, a flash of blue... \n Ice slash!", "granberia_fc3", 4],
      },
      [944] => { # サンダースラッシュ
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Knead away, a flash of yellow... \n Thunder Slash!", "granberia_fc3", 4],
      },
      [946] => { # 屠竜撃
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Look at the blow that can kill even a dragon!", "granberia_fc3", 4],
      },
      [947] => { # 雲身払車剣
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Kasumi's blade, like a wheel... Cloud body-wiping Kuruma sword!", "granberia_fc3", 4],
      },
      [948] => { # 滅世斬
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>A dark blade that ends this world... Destruction!", "granberia_fc3", 4],
      },
      [952] => { # デスバウンド
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Dance wildly, the blade of Shura...Deathbound!", "granberia_fc3", 4],
      },
      [953] => { # 死剣・乱れ星
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Twinkling Meteor Sword Technique...Death Sword/Disturbed Star!", "granberia_fc3", 4],
      },
      [954] => { # 魔影流星斬
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Look at the dark meteor falling on the earth... Demonic Shadow Meteor Slash!", "granberia_fc3", 4],
      },
      [959] => { # ギガスラッシュ
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>This is the ultimate flash... \n Giga Slash!", "granberia_fc3", 4],
      },
      [961] => { # 月下散華
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Spring dies under the February moon... Sanka under the moon!", "granberia_fc3", 4],
      },
      [962] => { # 魔刃・雪時雨
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Slash of the endless Rakshasa...Magic blade, Yuki Shigure!", "granberia_fc3", 4],
      },
      [963] => { # 皇竜九炎陣
        :ct_pic => "ct_granberia2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Dance in the flames, the blade of the supreme dragon...Kingryuu's nine flame formations!", "granberia_fc3", 4],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :ct_pic => "ct_granberia2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Fast like a gale, fast like thunder...! \n Instant strike, gale of thunder!", "granberia_fc3", 4],
      },
      [969] => { # 諸刃微塵斬り
        :ct_pic => "ct_granberia2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Even if this body decays... it's a double-edged sword!", "granberia_fc3", 4],
      },
      [970] => { # メギドカリバーン
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Mowing down with the wave of darkness! Megiddo Caliburn!", "granberia_fc3", 4],
      },
      [971] => { # 聖光六閃斬
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Receive a continuous attack of light... Six flashes of holy light!", "granberia_fc3", 4],
      },
      [973] => { # アトミックスラッシュ
        :ct_pic => "ct_granberia2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Erase \n, a flash of nuclear heat... Atomic Slash!", "granberia_fc3", 4],
      },
      [974] => { # クァンタスラッシュ
        :ct_pic => "ct_granberia2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Erase \n, a flash of quantum... Quantus Slash!", "granberia_fc3", 4],
      },
      [975] => { # イオンスラッシュ
        :ct_pic => "ct_granberia2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Erase \n, a flash of atoms... ion slash!", "granberia_fc3", 4],
      },
      [9009] => { # ギガスラッシュクロス
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>double flash! Giga Slash Cross!", "granberia_fc3", 4],
      },
      [9011] => { # 乱刃・気炎万丈
        :ct_pic => "ct_granberia2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Accept \n, my secret technique... Ranbana, Kien Banjo!", "granberia_fc3", 4],
      },
      [9012] => { # サウザンドブラッド
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Stained with fresh blood...Thousand Blood!", "granberia_fc3", 4],
      },
      [9014] => { # メギドカブラ
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>This is the ultimate mystery of the magic sword! Megidokabura!", "granberia_fc3", 4],
      },
      [9016] => { # 乱れ雪月花
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Snow dance...Moon shadow...Flowers and scattering...!", "granberia_fc3", 4],
      },
      [9017] => { # 竜臥閃
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Lie down on my sword... Ryuga flash!", "granberia_fc3", 4],
      },
      [9024] => { # 次元断
        :ct_pic => "ct_granberia3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>My sword flashes, cutting through dimensions...!", "granberia_fc3", 4],
      },
      [9018,9020] => { # 覇光ノ刃
        :word_1 => ["\\n<Granberia>Here we come...", "granberia_fc3", 4],
      },
      [9019,9021] => { # 覇光ノ刃（発動）
        :ct_pic => "ct_granberia1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Slash...Hako no Yaiba!", "granberia_fc3", 4],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Granberia>Healing sword, grant protection!", "granberia_fc3", 4],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Granberia>With this blade...pierce!", "granberia_fc3", 4],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Granberia>A warrior's pride in my blade!", "granberia_fc3", 4],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Granberia>Look at the sharpness of my white blade...!", "granberia_fc3", 4],
      },
      [1007] => { # 峰打ち
        :word_1 => ["\\n<Granberia>Get some sleep... Mine hit!", "granberia_fc3", 4],
      },
      [1008] => { # 三連斬
        :word_1 => ["\\n<Granberia>Repeated carving, triple slash!", "granberia_fc3", 4],
      },
      [1009] => { # 居合い抜き
        :word_1 => ["\\n<Granberia>Cut off with a single sword! Iainuki!", "granberia_fc3", 4],
      },
      [1010] => { # 牙突
        :word_1 => ["\\n<Granberia>Penetrates everything! Fangs!", "granberia_fc3", 4],
      },
      [1011] => { # 居合い・焔ノ太刀
        :word_1 => ["\\n<Granberia>Burn the crimson blade! Homura no Tachi!", "granberia_fc3", 4],
      },
      [1012] => { # 居合・吹雪ノ太刀
        :word_1 => ["\\n<Granberia>Freezing, extremely cold blade! Fubuki no Tachi!", "granberia_fc3", 4],
      },
      [1013] => { # 居合・雷土ノ太刀
        :word_1 => ["\\n<Granberia>Flash, the blade of lightning! Raito no Tachi!", "granberia_fc3", 4],
      },
      [1018] => { # 滅魂刀
        :word_1 => ["\\n<Granberia>Destroy that soul... ha!", "granberia_fc3", 4],
      },
      [1019] => { # 斬神斬魔
        :word_1 => ["\\n<Granberia>Cut off the gods and destroy the demons...!", "granberia_fc3", 4],
      },
      [1022] => { # 縮地・焔閃
        :word_1 => ["\\n<Granberia>A flash of a blade like a blink of an eye... Shrinkage and flame flash!", "granberia_fc3", 4],
      },
      [1023] => { # 魔刀・明鏡止水
        :word_1 => ["\\n<Granberia>A quiet heart, cutting off everything...Magical sword, Myokyo water stop!", "granberia_fc3", 4],
      },
      [1024] => { # 神刀・鏡花水月
        :word_1 => ["\\n<Granberia>Clear, pure flash... Divine sword Kyoka Suigetsu!", "granberia_fc3", 4],
      },
      [1025] => { # 微塵滅閃
        :word_1 => ["\\n<Granberia>The devil's blade is carved into fine dust... A fine flash!", "granberia_fc3", 4],
      },
      [1026] => { # 聖刃七星天
        :word_1 => ["\\n<Granberia>Look up and see the Seven Pole Stars... \n Twinkle in the heavens and earth, the Holy Blade Seven Stars!", "granberia_fc3", 4],
      },
      [1027] => { # 桜花幻舞
        :word_1 => ["\\n<Granberia>The cherry blossoms fall, the dancing is a dream...", "granberia_fc3", 4],
      },
      [1028] => { # 天墜
        :word_1 => ["\\n<Granberia>Fall... Fall from heaven!", "granberia_fc3", 4],
      },
      [9041] => { # 十四連斬
        :word_1 => ["\\n<Granberia>Fourteen consecutive slashes... Sei!!", "granberia_fc3", 4],
      },
      [1030] => { # 居合い・伊邪那岐
        :word_1 => ["\\n<Granberia>Nagi is a raw blade... Iai Izanagi!", "granberia_fc3", 4],
      },
      [1031] => { # 居合い・伊邪那美
        :word_1 => ["\\n<Granberia>Nagi is the blade of death...Iai Izanami!", "granberia_fc3", 4],
      },
      [9044] => { # 修羅の舞い
        :word_1 => ["\\n<Granberia>Crazy bloom! The dance of Shura is stained with scattered blood...!", "granberia_fc3", 4],
      },
      [9046] => { # 終ノ閃
        :word_1 => ["\\n<Granberia>Crush into nothingness, the final flash...!", "granberia_fc3", 4],
      },
      [9045] => { # 神祖烈星斬
        :word_1 => ["\\n<Granberia>Cuts off the stars, God Ancestor Retsuseizan!", "granberia_fc3", 4],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Granberia>On the pride of the warrior!", "granberia_fc3", 4],
      },
      [1032] => { # 心頭滅却
        :word_1 => ["\\n<Granberia>My heart is destroyed, the fire is also cool...", "granberia_fc3", 4],
      },
      [1033] => { # 肉斬骨断
        :word_1 => ["\\n<Granberia>Cut the flesh and cut the bones! Here we go!", "granberia_fc3", 4],
      },
      [1034] => { # 切り捨て御免
        :word_1 => ["\\n<Granberia>Now... I'm sorry for cutting it off!", "granberia_fc3", 4],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Granberia>Is this the end of a warrior...", "granberia_fc3", 4],
      },
      [1037] => { # 則天去私
        :word_1 => ["\\n<Granberia>This heart is my state...", "granberia_fc3", 4],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Granberia>Only pierce through with my spear...!", "granberia_fc3", 4],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Granberia>Spear, make a miracle happen!", "granberia_fc3", 4],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Granberia>A warrior's belief in a spear...!", "granberia_fc3", 4],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Granberia>With my strength... I will crush it!", "granberia_fc3", 4],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Granberia>Ax, go wild!", "granberia_fc3", 4],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Granberia>With my strength... I will crush it!", "granberia_fc3", 4],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sickle...!", "granberia_fc3", 4],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Granberia>Don't be fooled by my sickle...!", "granberia_fc3", 4],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Granberia>I don't like projectiles, but...ha!", "granberia_fc3", 4],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Granberia>Rain down, healing arrows!", "granberia_fc3", 4],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Granberia>Wielding a whip...haaaaaaaaaa!", "granberia_fc3", 4],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Granberia>Come, servant!", "granberia_fc3", 4],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Granberia>I don't like projectiles, but...ha!", "granberia_fc3", 4],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Granberia>With my strength... I will crush it!", "granberia_fc3", 4],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Granberia>I don't have the personality to dance on the battlefield, but...", "granberia_fc3", 4],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Granberia>I don't like projectiles, but...ha!", "granberia_fc3", 4],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Granberia>Eat the healing bullet!", "granberia_fc3", 4],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Granberia>My blade, dance wildly...!", "granberia_fc3", 4],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Granberia>Blades in both hands, slashing wildly!", "granberia_fc3", 4],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Granberia>Hit me with a deadly blow!", "granberia_fc3", 4],
      },
      [1417] => { # 爆炎拳
        :word_1 => ["\\n<Granberia>Entrust the dragon's flame to this fist... Bakuenken!", "granberia_fc3", 4],
      },
      [1418] => { # ドレインキラー
        :word_1 => ["\\n<Granberia>Destroy the spirit-sucking monster from within with the wave fist!", "granberia_fc3", 4],
      },
      [1432] => { # 黒炎十六掌
        :word_1 => ["\\n<Granberia>Burn it down, the dragon's fist... Sixteen palms of black flame!", "granberia_fc3", 4],
      },
      [9161] => { # 神竜乱掌
        :word_1 => ["\\n<Granberia>Strike \n, Divine Dragon's Fist... Divine Dragon Ransho!", "granberia_fc3", 4],
      },
      [9169] => { # 九星覇影弾
        :word_1 => ["\\n<Granberia>Kyusei's camp, run on the ground...Kyuusei Hakage Bullet!", "granberia_fc3", 4],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc3", 6],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Granberia>Heal the heavenly veins...chakra!", "granberia_fc3", 4],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Granberia>Demon vein, dwell in my fist!", "granberia_fc3", 4],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Granberia>White torrent, heal your injured body!", "granberia_fc3", 4],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Granberia>White torrent, destroy the darkness!", "granberia_fc3", 4],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Granberia>Immortal high will, bring evil to heaven's mercy! \n Heaven!", "granberia_fc3", 4],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Granberia>White torrent, give me power!", "granberia_fc3", 4],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Granberia>White torrent, prevent evil power!", "granberia_fc3", 4],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Granberia>A white torrent that hates evil, protects the devil and exorcises the wall! \n Cancel!", "granberia_fc3", 4],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Granberia>Black torrent, obey my orders!", "granberia_fc3", 4],
      },
      [1524] => { # ドラゴンフレア
        :word_1 => ["\\n<Granberia>Burn up the dragon's soul! Dragon Flare!", "granberia_fc3", 4],
      },
      [1525] => { # ドラゴンフレアバースト
        :word_1 => ["\\n<Granberia>The flame of beginning that rules everything... \n Realize reincarnation! Dragon Flare Burst!", "granberia_fc3", 4],
      },
      [1526] => { # ドラゴングレイズ
        :word_1 => ["\\n<Granberia>Dance wildly, the dragon's soul...Dragon Glaze!", "granberia_fc3", 4],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Granberia>The scythe of the god of death that reaps life, invite its soul to the underworld! \n Death!", "granberia_fc3", 4],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Granberia>Black torrent, obey my orders!", "granberia_fc3", 4],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Granberia>The peaceful wind of life, blow into a storm of blessings! \nHeal Typhoon!", "granberia_fc3", 4],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Granberia>The torrent of time at \n, carve your steps according to my will!", "granberia_fc3", 4],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Granberia>The torrent of time, distort time and space and bring destruction!", "granberia_fc3", 4],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Granberia>Time, stop!", "granberia_fc3", 4],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Granberia>Holy light, dispel the darkness!", "granberia_fc3", 4],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc3", 6],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Granberia>Holy light, bring healing!", "granberia_fc3", 4],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Granberia>Dedicate your life and banish the darkness!", "granberia_fc3", 4],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Granberia>The warrior's soul breathes life again!", "granberia_fc3", 4],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Granberia>This is a heavenly dance...!", "granberia_fc3", 4],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Granberia>....................", "granberia_fc3", 4],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Granberia>Take the wave of darkness with your own body...!", "granberia_fc3", 4],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc3", 6],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Granberia>The power of magic resides in my sword!", "granberia_fc3", 4],
      },
      [1698] => { # 魔法剣ファイア
        :word_1 => ["\\n<Granberia>Residing in my sword, the power of flame!", "granberia_fc3", 4],
      },
      [1699] => { # 魔法剣ブリザード
        :word_1 => ["\\n<Granberia>Rest in my sword, the power of ice!", "granberia_fc3", 4],
      },
      [1700] => { # 魔法剣サンダー
        :word_1 => ["\\n<Granberia>Residing in my sword, the power of thunder!", "granberia_fc3", 4],
      },
      [1701] => { # 魔法剣ウィンド
        :word_1 => ["\\n<Granberia>Rest in my sword, power of the wind!", "granberia_fc3", 4],
      },
      [1702] => { # 魔法剣アース
        :word_1 => ["\\n<Granberia>Rest in my sword, power of the earth!", "granberia_fc3", 4],
      },
      [1703] => { # 魔法剣アクア
        :word_1 => ["\\n<Granberia>Rest in my sword, power of water!", "granberia_fc3", 4],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<Granberia>Residing in my sword, holy power!", "granberia_fc3", 4],
      },
      [1705] => { # 魔法剣ダーク
        :word_1 => ["\\n<Granberia>Residing in my sword, power of darkness!", "granberia_fc3", 4],
      },
      [1706] => { # 魔法剣ポイズン
        :word_1 => ["\\n<Granberia>Residing in my sword, poisonous magic!", "granberia_fc3", 4],
      },
      [1707] => { # 魔法剣ブライン
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of darkness!", "granberia_fc3", 4],
      },
      [1708] => { # 魔法剣サイレンス
        :word_1 => ["\\n<Granberia>Residing in my sword, magical power of silence!", "granberia_fc3", 4],
      },
      [1709] => { # 魔法剣パラライズ
        :word_1 => ["\\n<Granberia>Residing in my sword, paralyzing magic!", "granberia_fc3", 4],
      },
      [1710] => { # 魔法剣コンフューズ
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of chaos!", "granberia_fc3", 4],
      },
      [1711] => { # 魔法剣スリープ
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of sleep!", "granberia_fc3", 4],
      },
      [1712] => { # 魔法剣デス
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of death!", "granberia_fc3", 4],
      },
      [1713] => { # 魔法剣ヘブン
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of ascension!", "granberia_fc3", 4],
      },
      [1714] => { # 魔法剣ドレイン
        :word_1 => ["\\n<Granberia>Residing in my sword, absorbing magic!", "granberia_fc3", 4],
      },
      [1715] => { # 魔法剣マドレイン
        :word_1 => ["\\n<Granberia>Residing in my sword, the magical power of absorption!", "granberia_fc3", 4],
      },
      [1718] => { # 魔法剣カーズ
        :word_1 => ["\\n<Granberia>Residing in my sword, cursed magic!", "granberia_fc3", 4],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Granberia>Deploy the magical protective wall!", "granberia_fc3", 4],
      },
      [1716] => { # マジックバリア
        :word_1 => ["\\n<Granberia>Protect your friends from evil techniques! \n Magic barrier!", "granberia_fc3", 4],
      },
      [1717] => { # マジックリフレクト
        :word_1 => ["\\n<Granberia>Heaven's blessing turns to earth and becomes a magic mirror! \n Magic reflect!", "granberia_fc3", 4],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Granberia>The sign of Yin and Yang, let me know the truth!", "granberia_fc3", 4],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Granberia>A piece of life, sending it is life! \n Carve out the slightest...Singing of life!", "granberia_fc3", 4],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Granberia>Move forward to the left, move to the right and move to the left...the step of the shrine, that is, Yu!", "granberia_fc3", 4],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Granberia>Get \n!", "granberia_fc3", 4],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Granberia>This is the essence of a thief!", "granberia_fc3", 4],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Granberia>I will show my back...", "granberia_fc3", 4],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Granberia>Shinobi no jutsu, carve it into your eyes!", "granberia_fc3", 4],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc3", 6],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Granberia>Healing waves, pervade thousands of places... \n Ninja art/healing waves!", "granberia_fc3", 4],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Granberia>Autumn Utsusemi dances in the shadows... \n Ninpo/Bunshin no Jutsu!", "granberia_fc3", 4],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Granberia>Use \n smoke bomb!", "granberia_fc3", 4],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Granberia>This is the secret pirate technique!", "granberia_fc3", 4],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Granberia>A flash of justice...haaaaaaah!", "granberia_fc3", 4],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Let's go to \n, seriously!　Aaah!!", "granberia_fc3", 4],
      },
      [1852] => { # マジカルスター
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Shattered, magical shooting star!", "granberia_fc3", 4],
      },
      [1853] => { # マジカルオーラ
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Penetrate, the wave of magic!", "granberia_fc3", 4],
      },
      [1854] => { # マジカルヒール
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Let's heal with the power of magic!", "granberia_fc3", 4],
      },
      [1855] => { # 円環の理
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Guide the lost soul, the principle of the circle!", "granberia_fc3", 4],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Granberia>This is my grudge...", "granberia_fc3", 4],
      },
      [1862] => { # 禍星
        :word_1 => ["\\n<Granberia>Come, misfortune star...", "granberia_fc3", 4],
      },
      [1863] => { # カーズウェーブ
        :word_1 => ["\\n<Granberia>delivered, wave of curse...", "granberia_fc3", 4],
      },
      [1864] => { # ワルプルギスの夜
        :word_1 => ["\\n<Granberia>Offer your flesh and blood to the witch's night...", "granberia_fc3", 4],
      },
      [1865] => { # 呪詩
        :word_1 => ["\\n<Granberia>Sound, the cursed poem...", "granberia_fc3", 4],
      },
      [1866] => { # アルテマ
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>This is the lost ancient magic... Ultima!", "granberia_fc3", 4],
      },
      [1867] => { # 胡蝶夢天
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>A dream of endless pleasure... Phalaenopsis dream heaven!", "granberia_fc3", 4],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Granberia>Should I use gold...", "granberia_fc3", 4],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Granberia>Would you like me to sell you this...", "granberia_fc3", 4],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Granberia>Use \nItem!", "granberia_fc3", 4],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Granberia>Carve it, card!", "granberia_fc3", 4],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Granberia>Battle with \n coins!", "granberia_fc3", 4],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Granberia>It's a game of darkness!", "granberia_fc3", 4],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Granberia>Tarot, show us your destiny!", "granberia_fc3", 4],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Granberia>I can hear the voice of the goddess...", "granberia_fc3", 4],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Granberia>slot, good luck!", "granberia_fc3", 4],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Granberia>It's time to play poker!", "granberia_fc3", 4],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Granberia>Battle Card, Draw!", "granberia_fc3", 4],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Granberia>The power contained in the playing cards...!", "granberia_fc3", 4],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Granberia>Today, the luckiest person is...", "granberia_fc3", 4],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Granberia>It's always my turn!", "granberia_fc3", 4],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Granberia>Heaven, please give me an item...", "granberia_fc3", 4],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Granberia>Let's dance...!", "granberia_fc3", 4],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Granberia>So! Hustle! Hustle!", "granberia_fc3", 4],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Granberia>Come on, listen to my song...!", "granberia_fc3", 4],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Granberia>Kira☆", "granberia_fc3", 4],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Granberia>If you have something to say, let me ask you before I kill you...", "granberia_fc3", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Granberia>That's pretty good, let me praise you...", "granberia_fc3", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Granberia>An existence like you is called 'shame'...", "granberia_fc3", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Granberia>People over there, leave your money behind!", "granberia_fc3", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Granberia>People over there, leave your items behind!", "granberia_fc3", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Granberia>...Come with me.", "granberia_fc3", 4],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Granberia>Do you want to become the rust of this sword? ?", "granberia_fc3", 4],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Granberia>Disappear!", "granberia_fc3", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Granberia>Then, Erubetie flows into the waterway...", "granberia_fc3", 1],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Granberia>Then Alma Elma cut my chest...", "granberia_fc3", 6],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Granberia>Then Tamamo comes out of the well, soaking wet...", "granberia_fc3", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Granberia>I won with the sword...", "granberia_fc3", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Granberia>This is the power of words!", "granberia_fc3", 4],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Granberia>This is the power of science!", "granberia_fc3", 4],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Granberia>We are already prepared!", "granberia_fc3", 4],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Granberia>Convert \n energy!", "granberia_fc3", 4],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Granberia>Alchemize \nItem!", "granberia_fc3", 4],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Granberia>Magic book technique, show your power!", "granberia_fc3", 4],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Granberia>Let's go to \n page...", "granberia_fc3", 4],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Granberia>This is the power of Makina!", "granberia_fc3", 4],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Granberia>I'm not good at cooking, but...", "granberia_fc3", 4],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Granberia>Get the ingredients!", "granberia_fc3", 4],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Granberia>I chop meat with my scalpel!", "granberia_fc3", 4],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc3", 6],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Granberia>Look at the brightness of my female!", "granberia_fc3", 4],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Granberia>Now, take this medicine!", "granberia_fc3", 4],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Granberia>It's an injection!", "granberia_fc3", 4],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Granberia>Spreading \n's special virus!", "granberia_fc3", 4],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Granberia>Let's work...", "granberia_fc3", 4],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc3", 6],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Granberia>Tea is here...", "granberia_fc3", 4],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Granberia>Maid Change!", "granberia_fc3", 4],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Granberia>Now, it's time to harvest...", "granberia_fc3", 4],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Granberia>Take the king's sword with your own body!", "granberia_fc3", 4],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Granberia>Experience the magic of the \n king for yourself!", "granberia_fc3", 4],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Granberia>Our army, gather here!", "granberia_fc3", 4],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Granberia>Now, ascend to heaven!", "granberia_fc3", 4],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Granberia>Bow down to my majesty!", "granberia_fc3", 4],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Granberia>The miracle of the king is shown here!", "granberia_fc3", 4],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Granberia>...Blitzkrieg!!", "granberia_fc3", 4],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Granberia>Seryaaaaa!!", "granberia_fc3", 4],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Granberia>This is the flash of a hero...haaaaaaaaaa!", "granberia_fc3", 4],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Granberia>Prevent evil attacks... Brave Wall!", "granberia_fc3", 4],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc3", 6],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Granberia>I don't give in to pleasure...!", "granberia_fc3", 0],
      },
      [2596] => { # 竜魂魔導
        :word_1 => ["\\n<Granberia>Awaken, the soul of the true dragon!", "granberia_fc3", 4],
      },
      [2678] => { # 引っ掻き
        :word_1 => ["\\n<Granberia>Eat these claws!", "granberia_fc3", 4],
      },
      [2686] => { # 噛み付き
        :word_1 => ["\\n<Granberia>Tear it apart with these fangs!", "granberia_fc3", 4],
      },
      [2689] => { # 双炎牙
        :word_1 => ["\\n<Granberia>Shatter with flaming fangs!", "granberia_fc3", 4],
      },
      [2690] => { # バーミリオンファング
        :word_1 => ["\\n<Granberia>Take it, Scorching Fang!", "granberia_fc3", 4],
      },
      [2691] => { # 絶氷牙
        :word_1 => ["\\n<Granberia>Shatter with ice fangs!", "granberia_fc3", 4],
      },
      [2692] => { # 断氷連牙
        :word_1 => ["\\n<Granberia>Tear apart, the merciless fangs of ice!", "granberia_fc3", 4],
      },
      [2696] => { # 蹂躙撃
        :word_1 => ["\\n<Granberia>Overrun... Oooh!", "granberia_fc3", 4],
      },
      [2698] => { # おたけび
        :word_1 => ["\\n<Granberia>Ohhhhh...!!", "granberia_fc3", 4],
      },
      [2699] => { # 破壊の咆吼
        :word_1 => ["\\n<Granberia>Oh!!", "granberia_fc3", 4],
      },
      [2734] => { # 凍てつく波動
        :word_1 => ["\\n<Granberia>Cut off the blessings... Blow away!", "granberia_fc3", 0],
      },
      [2830] => { # 羽ばたき
        :word_1 => ["\\n<Granberia>Blow away!", "granberia_fc3", 4],
      },
      [2831] => { # 強風
        :word_1 => ["\\n<Granberia>A fierce wind blows!", "granberia_fc3", 4],
      },
      [2832] => { # 超風
        :word_1 => ["\\n<Granberia>Erase everything... super wind!", "granberia_fc3", 4],
      },
      [3046] => { # 鉄砲水
        :word_1 => ["\\n<Granberia>Fierce muddy current, flash flood!", "granberia_fc3", 4],
      },
      [3047] => { # 津波
        :word_1 => ["\\n<Granberia>Swallow everything and wash it away! Tsunami!", "granberia_fc3", 4],
      },
      [3049] => { # タイダルウェイブ
        :word_1 => ["\\n<Granberia>The baptism of the tyrant who swallows everything! \n Tidal Wave!", "granberia_fc3", 4],
      },
      [3068] => { # 火の息
        :word_1 => ["\\n<Granberia>Eat the \n fireball!", "granberia_fc3", 4],
      },
      [3069] => { # 火炎の息
        :word_1 => ["\\n<Granberia>Burn with flame breath!", "granberia_fc3", 4],
      },
      [3070] => { # 激しい炎
        :word_1 => ["\\n<Granberia>Burn it down with fierce flames!", "granberia_fc3", 4],
      },
      [3071] => { # 灼熱の炎
        :word_1 => ["\\n<Granberia>Turn into dust with scorching flames!", "granberia_fc3", 4],
      },
      [3072] => { # 煉獄の火炎
        :word_1 => ["\\n<Granberia>Burn out, the flames of purgatory...!", "granberia_fc3", 4],
      },
      [9585] => { # 神竜乱牙
        :word_1 => ["\\n<Granberia>shatters, the true dragon fang!", "granberia_fc3", 4],
      },
      [9586] => { # 虚竜牙
        :word_1 => ["\\n<Granberia>Destroy the Fang of the Void Dragon!", "granberia_fc3", 4],
      },
      [9687] => { # 神竜大海嘯
        :word_1 => ["\\n<Granberia>Come, the great ocean called by the divine dragon...!", "granberia_fc3", 4],
      },
      [9688] => { # 虚竜の大海嘯
        :word_1 => ["\\n<Granberia>Return the tsunami of nothingness to zero...!", "granberia_fc3", 4],
      },
      [3073] => { # 核熱の息
        :word_1 => ["\\n<Granberia>Disappear with nuclear heat breath...!", "granberia_fc3", 4],
      },
      [3078] => { # 量子の息
        :word_1 => ["\\n<Granberia>Shattered by quantum breath...!", "granberia_fc3", 4],
      },
      [9692] => { # 無塵焔
        :word_1 => ["\\n<Granberia>A dustless flame that leaves no dust behind...!", "granberia_fc3", 4],
      },
      [3074] => { # 冷たい息
        :word_1 => ["\\n<Granberia>Freeze in the cold...!", "granberia_fc3", 4],
      },
      [3075] => { # 凍り付く息
        :word_1 => ["\\n<Granberia>Freezes to the point of shattering...!", "granberia_fc3", 4],
      },
      [3076] => { # 凍える吹雪
        :word_1 => ["\\n<Granberia>Rot in the blizzard...!", "granberia_fc3", 4],
      },
      [3077] => { # 輝く息
        :word_1 => ["\\n<Granberia>Extremely cold breath that freezes even the soul...", "granberia_fc3", 4],
      },
      [9693] => { # 極零光
        :word_1 => ["\\n<Granberia>Disappear in the frigid light... Polar zero light!", "granberia_fc3", 4],
      },
      [3087] => { # 焼け付く息
        :word_1 => ["\\n<Granberia>Come on, get numb...!", "granberia_fc3", 4],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Granberia>Let's take care of \n...", "granberia_fc3", 4],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Granberia>Pray to heaven...", "granberia_fc3", 4],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Granberia>This is my seriousness...!", "granberia_fc3", 4],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Granberia>Accumulate power...!", "granberia_fc3", 4],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Granberia>Get fired up...!", "granberia_fc3", 4],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sword...!", "granberia_fc3", 4],
      },
      [3100] => { # 裏練気
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sword...!", "granberia_fc3", 0],
      },
      [3102] => { # 竜鋼体
        :word_1 => ["\\n<Granberia>I will solidify my body with the dragon's fighting spirit... Ha!", "granberia_fc3", 4],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Granberia>Let me show you the final secret technique...!", "granberia_fc3", 4],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Granberia>The power of elemental...!", "granberia_fc3", 4],
      },
      [3116] => { # 明鏡止水
        :word_1 => ["\\n<Granberia>This heart is in the flow of water...!", "granberia_fc3", 4],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Granberia>Take a deep breath to rest your body...", "granberia_fc3", 4],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Granberia>If you don't treat your body...", "granberia_fc3", 4],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Granberia>Have you been chased...", "granberia_fc3", 4],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Granberia>Wow...!!", "granberia_fc3", 4],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Granberia>Transform with a passionate belief in your heart!", "granberia_fc3", 4],
      },
      [3128, 9784] => { # 魔法少女変身
        :ct_pic => "ct_granberia5",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>――Transformation! Magical Girl Gran☆Beria!!", "granberia_fc3", 4],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Granberia>I feel a grudge for being turned into a magical girl...", "granberia_fc3", 4],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Granberia>I captured \n...!", "granberia_fc3", 4],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Granberia>Call for reinforcements!", "granberia_fc3", 4],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Granberia>Break that power!", "granberia_fc3", 4],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Granberia>Intermittent Spring, that's it!", "granberia_fc3", 4],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Granberia>Don't move!", "granberia_fc3", 4],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Granberia>What kind of pants are you wearing... \n For reference, let me show you!", "granberia_fc3", 4],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Granberia>Umph, sexy beam...", "granberia_fc3", 6],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Granberia>Umph, Pink Typhoon...", "granberia_fc3", 6],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Granberia>Ugh, Fantastic Hurricane...", "granberia_fc3", 6],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Granberia>Now, it's my stage!", "granberia_fc3", 4],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Granberia>Look at the miracle of the Holy Grail!", "granberia_fc3", 4],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Granberia>Look at my struggle!", "granberia_fc3", 4],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Granberia>puff puff, puff puff...", "granberia_fc3", 4],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Granberia>Look at the power of this weapon!", "granberia_fc3", 4],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Granberia>Look at the power of \n aura!", "granberia_fc3", 4],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Granberia>How about this technique! ?", "granberia_fc3", 4],
      },
      [6115] => { # 竜拳
        :word_1 => ["\\n<Granberia>Take \n, Dragon's Fist!", "granberia_fc3", 4],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Granberia>Eat \n...!", "granberia_fc3", 4],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Granberia>I will protect you...!", "granberia_fc3", 4],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Granberia>Now... Assemble!!", "granberia_fc3", 4],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Granberia>Double up!", "granberia_fc3", 4],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Granberia>Next action, order!", "granberia_fc3", 4],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Granberia>Concentrate your power on one point...!", "granberia_fc3", 4],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Granberia>■■■■■■■■■■■■■■■...", "granberia_fc3", 4],
      },
      [3741] => { # しこしこ
        :word_1 => ["\\n<Granberia>Come on. I hope it ends in my hands...!", "granberia_fc3", 0],
        :word_2 => ["\\n<Granberia>Let me taste your essence...!", "granberia_fc3", 0],
        :word_3 => ["\\n<Granberia>Look, let's handle it...!", "granberia_fc3", 0],
      },
    },
    17 => { # グランベリア
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Granberia>Hyaah!", "granberia_fc4", 3],
        :word_2 => ["\\n<Granberia>Huh!", "granberia_fc4", 3],
        :word_3 => ["\\n<Granberia>Kill!", "granberia_fc4", 3],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Granberia>Even if it is a knife, there is no stagnation in my blade...!", "granberia_fc4", 3],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sword...!", "granberia_fc4", 3],
      },
      [917] => { # 切り返し
        :word_1 => ["\\n<Granberia>Cut back... Ha!", "granberia_fc4", 3],
      },
      [918] => { # 疾風突き
        :word_1 => ["\\n<Granberia>Like the wind... it penetrates!", "granberia_fc4", 3],
      },
      [919] => { # 払車剣
        :word_1 => ["\\n<Granberia>Sword flash, like a wheel...shake sword!", "granberia_fc4", 3],
      },
      [920] => { # 諸刃斬り
        :word_1 => ["\\n<Granberia>With determination in mind...a double-edged blade!", "granberia_fc4", 3],
      },
      [921] => { # 隼斬り
        :word_1 => ["\\n<Granberia>Like a falcon...slash multiple times!", "granberia_fc4", 3],
      },
      [922] => { # 火炎斬り
        :word_1 => ["\\n<Granberia>Take shelter, flame... Ha!", "granberia_fc4", 3],
      },
      [923] => { # 氷斬り
        :word_1 => ["\\n<Granberia>Take shelter, ice... Ha!", "granberia_fc4", 3],
      },
      [924] => { # 稲妻斬り
        :word_1 => ["\\n<Granberia>Take shelter, lightning... Ha!", "granberia_fc4", 3],
      },
      [931] => { # 真空斬り
        :word_1 => ["\\n<Granberia>Vacuum blade... Ha!", "granberia_fc4", 3],
      },
      [932] => { # 烈風剣
        :word_1 => ["\\n<Granberia>Dance, blade of fierce wind!　Aaah!!", "granberia_fc4", 3],
      },
      [933] => { # 月影の太刀
        :word_1 => ["\\n<Granberia>May dances... Shura's sword!", "granberia_fc4", 3],
      },
      [934] => { # 魔神斬り
        :word_1 => ["\\n<Granberia>Majin's blow! Sei!!", "granberia_fc4", 3],
      },
      [935] => { # デッドクラッシュ
        :word_1 => ["\\n<Granberia>The blade of destruction brings death... Dead Crash!", "granberia_fc4", 3],
      },
      [936] => { # 二刀十字斬り
        :word_1 => ["\\n<Granberia>Get close to \n and take a look! Two-sword cross slash!", "granberia_fc4", 3],
      },
      [940] => { # 極竜斬
        :word_1 => ["\\n<Granberia>Carve the dragon's anger into your body! Gokuryuzan!", "granberia_fc4", 3],
      },
      [941] => { # ヒートウェイブ
        :word_1 => ["\\n<Granberia>The dragon's sword flashes into pieces! Heatwave!", "granberia_fc4", 3],
      },
      [942] => { # フレイムスラッシュ
        :word_1 => ["\\n<Granberia>Burn it down, a flash of red... \n Flame Slash!", "granberia_fc4", 3],
      },
      [943] => { # アイススラッシュ
        :word_1 => ["\\n<Granberia>Freezing, a flash of blue... \n Ice slash!", "granberia_fc4", 3],
      },
      [944] => { # サンダースラッシュ
        :word_1 => ["\\n<Granberia>Knead away, a flash of yellow... \n Thunder Slash!", "granberia_fc4", 3],
      },
      [946] => { # 屠竜撃
        :word_1 => ["\\n<Granberia>Look at the blow that can kill even a dragon!", "granberia_fc4", 3],
      },
      [947] => { # 雲身払車剣
        :word_1 => ["\\n<Granberia>Kasumi's blade, like a wheel... Cloud body-wiping Kuruma sword!", "granberia_fc4", 3],
      },
      [948] => { # 滅世斬
        :word_1 => ["\\n<Granberia>A dark blade that ends this world... Destruction!", "granberia_fc4", 3],
      },
      [952] => { # デスバウンド
        :word_1 => ["\\n<Granberia>Dance wildly, the blade of Shura...Deathbound!", "granberia_fc4", 3],
      },
      [953] => { # 死剣・乱れ星
        :word_1 => ["\\n<Granberia>Twinkling Meteor Sword Technique...Death Sword/Disturbed Star!", "granberia_fc4", 3],
      },
      [954] => { # 魔影流星斬
        :word_1 => ["\\n<Granberia>Look at the dark meteor falling on the earth... Demonic Shadow Meteor Slash!", "granberia_fc4", 3],
      },
      [959] => { # ギガスラッシュ
        :word_1 => ["\\n<Granberia>This is the ultimate flash... \n Giga Slash!", "granberia_fc4", 3],
      },
      [961] => { # 月下散華
        :word_1 => ["\\n<Granberia>Spring dies under the February moon... Sanka under the moon!", "granberia_fc4", 3],
      },
      [962] => { # 魔刃・雪時雨
        :word_1 => ["\\n<Granberia>Slash of the endless Rakshasa...Magic blade, Yuki Shigure!", "granberia_fc4", 3],
      },
      [963] => { # 皇竜九炎陣
        :word_1 => ["\\n<Granberia>Dance in the flames, the blade of the supreme dragon...Kingryuu's nine flame formations!", "granberia_fc4", 3],
      },
      [968] => { # 瞬撃・疾風雷鳴
        :word_1 => ["\\n<Granberia>Fast like a gale, fast like thunder...! \n Instant strike, gale of thunder!", "granberia_fc4", 3],
      },
      [969] => { # 諸刃微塵斬り
        :word_1 => ["\\n<Granberia>Even if this body decays... it's a double-edged sword!", "granberia_fc4", 3],
      },
      [970] => { # メギドカリバーン
        :word_1 => ["\\n<Granberia>Mowing down with the wave of darkness! Megiddo Caliburn!", "granberia_fc4", 3],
      },
      [971] => { # 聖光六閃斬
        :word_1 => ["\\n<Granberia>Receive a continuous attack of light... Six flashes of holy light!", "granberia_fc4", 3],
      },
      [973] => { # アトミックスラッシュ
        :word_1 => ["\\n<Granberia>Erase \n, a flash of nuclear heat... Atomic Slash!", "granberia_fc4", 3],
      },
      [974] => { # クァンタスラッシュ
        :word_1 => ["\\n<Granberia>Erase \n, a flash of quantum... Quantus Slash!", "granberia_fc4", 3],
      },
      [975] => { # イオンスラッシュ
        :word_1 => ["\\n<Granberia>Erase \n, a flash of atoms... ion slash!", "granberia_fc4", 3],
      },
      [9009] => { # ギガスラッシュクロス
        :word_1 => ["\\n<Granberia>double flash! Giga Slash Cross!", "granberia_fc4", 3],
      },
      [9011] => { # 乱刃・気炎万丈
        :word_1 => ["\\n<Granberia>Accept \n, my secret technique... Ranbana, Kien Banjo!", "granberia_fc4", 3],
      },
      [9012] => { # サウザンドブラッド
        :word_1 => ["\\n<Granberia>Stained with fresh blood...Thousand Blood!", "granberia_fc4", 3],
      },
      [9014] => { # メギドカブラ
        :word_1 => ["\\n<Granberia>This is the ultimate mystery of the magic sword! Megidokabura!", "granberia_fc4", 3],
      },
      [9016] => { # 乱れ雪月花
        :word_1 => ["\\n<Granberia>Snow dance...Moon shadow...Flowers and scattering...!", "granberia_fc4", 3],
      },
      [9017] => { # 竜臥閃
        :word_1 => ["\\n<Granberia>Lie down on my sword... Ryuga flash!", "granberia_fc4", 3],
      },
      [9024] => { # 次元断
        :word_1 => ["\\n<Granberia>My sword flashes, cutting through dimensions...!", "granberia_fc4", 3],
      },
      [9018,9020] => { # 覇光ノ刃
        :word_1 => ["\\n<Granberia>Here we come...", "granberia_fc4", 3],
      },
      [9019,9021] => { # 覇光ノ刃（発動）
        :word_1 => ["\\n<Granberia>Slash...Hako no Yaiba!", "granberia_fc4", 3],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Granberia>Healing sword, grant protection!", "granberia_fc4", 3],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Granberia>With this blade...pierce!", "granberia_fc4", 3],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Granberia>A warrior's pride in my blade!", "granberia_fc4", 3],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Granberia>Look at the sharpness of my white blade...!", "granberia_fc4", 3],
      },
      [1007] => { # 峰打ち
        :word_1 => ["\\n<Granberia>Get some sleep... Mine hit!", "granberia_fc4", 3],
      },
      [1008] => { # 三連斬
        :word_1 => ["\\n<Granberia>Repeated carving, triple slash!", "granberia_fc4", 3],
      },
      [1009] => { # 居合い抜き
        :word_1 => ["\\n<Granberia>Cut off with a single sword! Iainuki!", "granberia_fc4", 3],
      },
      [1010] => { # 牙突
        :word_1 => ["\\n<Granberia>Penetrates everything! Fangs!", "granberia_fc4", 3],
      },
      [1011] => { # 居合い・焔ノ太刀
        :word_1 => ["\\n<Granberia>Burn the crimson blade! Homura no Tachi!", "granberia_fc4", 3],
      },
      [1012] => { # 居合・吹雪ノ太刀
        :word_1 => ["\\n<Granberia>Freezing, extremely cold blade! Fubuki no Tachi!", "granberia_fc4", 3],
      },
      [1013] => { # 居合・雷土ノ太刀
        :word_1 => ["\\n<Granberia>Flash, the blade of lightning! Raito no Tachi!", "granberia_fc4", 3],
      },
      [1018] => { # 滅魂刀
        :word_1 => ["\\n<Granberia>Destroy that soul... ha!", "granberia_fc4", 3],
      },
      [1019] => { # 斬神斬魔
        :word_1 => ["\\n<Granberia>Cut off the gods and destroy the demons...!", "granberia_fc4", 3],
      },
      [1022] => { # 縮地・焔閃
        :word_1 => ["\\n<Granberia>A flash of a blade like a blink of an eye... Shrinkage and flame flash!", "granberia_fc4", 3],
      },
      [1023] => { # 魔刀・明鏡止水
        :word_1 => ["\\n<Granberia>A quiet heart, cutting off everything...Magical sword, Myokyo water stop!", "granberia_fc4", 3],
      },
      [1024] => { # 神刀・鏡花水月
        :word_1 => ["\\n<Granberia>Clear, pure flash... Divine sword Kyoka Suigetsu!", "granberia_fc4", 3],
      },
      [1025] => { # 微塵滅閃
        :word_1 => ["\\n<Granberia>The devil's blade is carved into fine dust... A fine flash!", "granberia_fc4", 3],
      },
      [1026] => { # 聖刃七星天
        :word_1 => ["\\n<Granberia>Look up and see the Seven Pole Stars... \n Twinkle in the heavens and earth, the Holy Blade Seven Stars!", "granberia_fc4", 3],
      },
      [1027] => { # 桜花幻舞
        :word_1 => ["\\n<Granberia>The cherry blossoms fall, the dancing is a dream...", "granberia_fc4", 3],
      },
      [1028] => { # 天墜
        :word_1 => ["\\n<Granberia>Fall... Fall from heaven!", "granberia_fc4", 3],
      },
      [9041] => { # 十四連斬
        :word_1 => ["\\n<Granberia>Fourteen consecutive slashes... Sei!!", "granberia_fc4", 3],
      },
      [1030] => { # 居合い・伊邪那岐
        :word_1 => ["\\n<Granberia>Nagi is a raw blade... Iai Izanagi!", "granberia_fc4", 3],
      },
      [1031] => { # 居合い・伊邪那美
        :word_1 => ["\\n<Granberia>Nagi is the blade of death...Iai Izanami!", "granberia_fc4", 3],
      },
      [9044] => { # 修羅の舞い
        :word_1 => ["\\n<Granberia>Crazy bloom! The dance of Shura is stained with scattered blood...!", "granberia_fc4", 3],
      },
      [9046] => { # 終ノ閃
        :word_1 => ["\\n<Granberia>Crush into nothingness, the final flash...!", "granberia_fc4", 3],
      },
      [9045] => { # 神祖烈星斬
        :word_1 => ["\\n<Granberia>Cuts off the stars, God Ancestor Retsuseizan!", "granberia_fc4", 3],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Granberia>On the pride of the warrior!", "granberia_fc4", 3],
      },
      [1032] => { # 心頭滅却
        :word_1 => ["\\n<Granberia>My heart is destroyed, the fire is also cool...", "granberia_fc4", 3],
      },
      [1033] => { # 肉斬骨断
        :word_1 => ["\\n<Granberia>Cut the flesh and cut the bones! Here we go!", "granberia_fc4", 3],
      },
      [1034] => { # 切り捨て御免
        :word_1 => ["\\n<Granberia>Now... I'm sorry for cutting it off!", "granberia_fc4", 3],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Granberia>Is this the end of a warrior...", "granberia_fc4", 3],
      },
      [1037] => { # 則天去私
        :word_1 => ["\\n<Granberia>This heart is my state...", "granberia_fc4", 3],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Granberia>Only pierce through with my spear...!", "granberia_fc4", 3],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Granberia>Spear, make a miracle happen!", "granberia_fc4", 3],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Granberia>A warrior's belief in a spear...!", "granberia_fc4", 3],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Granberia>With my strength... I will crush it!", "granberia_fc4", 3],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Granberia>Ax, go wild!", "granberia_fc4", 3],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Granberia>With my strength... I will crush it!", "granberia_fc4", 3],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sickle...!", "granberia_fc4", 3],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Granberia>Don't be fooled by my sickle...!", "granberia_fc4", 3],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Granberia>I don't like projectiles, but...ha!", "granberia_fc4", 3],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Granberia>Rain down, healing arrows!", "granberia_fc4", 3],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Granberia>Wielding a whip...haaaaaaaaaa!", "granberia_fc4", 3],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Granberia>Come, servant!", "granberia_fc4", 3],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Granberia>I don't like projectiles, but...ha!", "granberia_fc4", 3],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Granberia>With my strength... I will crush it!", "granberia_fc4", 3],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Granberia>I don't have the personality to dance on the battlefield, but...", "granberia_fc4", 3],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Granberia>I don't like projectiles, but...ha!", "granberia_fc4", 3],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Granberia>Eat the healing bullet!", "granberia_fc4", 3],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Granberia>My blade, dance wildly...!", "granberia_fc4", 3],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Granberia>Blades in both hands, slashing wildly!", "granberia_fc4", 3],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Granberia>Hit me with a deadly blow!", "granberia_fc4", 3],
      },
      [1417] => { # 爆炎拳
        :word_1 => ["\\n<Granberia>Entrust the dragon's flame to this fist... Bakuenken!", "granberia_fc4", 3],
      },
      [1418] => { # ドレインキラー
        :word_1 => ["\\n<Granberia>Destroy the spirit-sucking monster from within with the wave fist!", "granberia_fc4", 3],
      },
      [1432] => { # 黒炎十六掌
        :word_1 => ["\\n<Granberia>Burn it down, the dragon's fist... Sixteen palms of black flame!", "granberia_fc4", 3],
      },
      [9161] => { # 神竜乱掌
        :word_1 => ["\\n<Granberia>Strike \n, Divine Dragon's Fist... Divine Dragon Ransho!", "granberia_fc4", 3],
      },
      [9169] => { # 九星覇影弾
        :word_1 => ["\\n<Granberia>Kyusei's camp, run on the ground...Kyuusei Hakage Bullet!", "granberia_fc4", 3],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc4", 5],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Granberia>Heal the heavenly veins...chakra!", "granberia_fc4", 3],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Granberia>Demon vein, dwell in my fist!", "granberia_fc4", 3],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Granberia>White torrent, heal your injured body!", "granberia_fc4", 3],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Granberia>White torrent, destroy the darkness!", "granberia_fc4", 3],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Granberia>Immortal high will, bring evil to heaven's mercy! \n Heaven!", "granberia_fc4", 3],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Granberia>White torrent, give me power!", "granberia_fc4", 3],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Granberia>White torrent, prevent evil power!", "granberia_fc4", 3],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Granberia>A white torrent that hates evil, protects the devil and exorcises the wall! \n Cancel!", "granberia_fc4", 3],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Granberia>Black torrent, obey my orders!", "granberia_fc4", 3],
      },
      [1524] => { # ドラゴンフレア
        :word_1 => ["\\n<Granberia>Burn up the dragon's soul! Dragon Flare!", "granberia_fc4", 3],
      },
      [1525] => { # ドラゴンフレアバースト
        :word_1 => ["\\n<Granberia>The flame of beginning that rules everything... \n Realize reincarnation! Dragon Flare Burst!", "granberia_fc4", 3],
      },
      [1526] => { # ドラゴングレイズ
        :word_1 => ["\\n<Granberia>Dance wildly, the dragon's soul...Dragon Glaze!", "granberia_fc4", 3],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Granberia>The scythe of the god of death that reaps life, invite its soul to the underworld! \n Death!", "granberia_fc4", 3],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Granberia>Black torrent, obey my orders!", "granberia_fc4", 3],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Granberia>The peaceful wind of life, blow into a storm of blessings! \nHeal Typhoon!", "granberia_fc4", 3],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Granberia>The torrent of time at \n, carve your steps according to my will!", "granberia_fc4", 3],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Granberia>The torrent of time, distort time and space and bring destruction!", "granberia_fc4", 3],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Granberia>Time, stop!", "granberia_fc4", 3],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Granberia>Holy light, dispel the darkness!", "granberia_fc4", 3],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc4", 5],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Granberia>Holy light, bring healing!", "granberia_fc4", 3],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Granberia>Dedicate your life and banish the darkness!", "granberia_fc4", 3],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Granberia>The warrior's soul breathes life again!", "granberia_fc4", 3],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Granberia>This is a heavenly dance...!", "granberia_fc4", 3],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Granberia>....................", "granberia_fc4", 3],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Granberia>Take the wave of darkness with your own body...!", "granberia_fc4", 3],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc4", 5],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Granberia>The power of magic resides in my sword!", "granberia_fc4", 3],
      },
      [1698] => { # 魔法剣ファイア
        :word_1 => ["\\n<Granberia>Residing in my sword, the power of flame!", "granberia_fc4", 3],
      },
      [1699] => { # 魔法剣ブリザード
        :word_1 => ["\\n<Granberia>Rest in my sword, the power of ice!", "granberia_fc4", 3],
      },
      [1700] => { # 魔法剣サンダー
        :word_1 => ["\\n<Granberia>Residing in my sword, the power of thunder!", "granberia_fc4", 3],
      },
      [1701] => { # 魔法剣ウィンド
        :word_1 => ["\\n<Granberia>Rest in my sword, power of the wind!", "granberia_fc4", 3],
      },
      [1702] => { # 魔法剣アース
        :word_1 => ["\\n<Granberia>Rest in my sword, power of the earth!", "granberia_fc4", 3],
      },
      [1703] => { # 魔法剣アクア
        :word_1 => ["\\n<Granberia>Rest in my sword, power of water!", "granberia_fc4", 3],
      },
      [1704] => { # 魔法剣ホーリー
        :word_1 => ["\\n<Granberia>Residing in my sword, holy power!", "granberia_fc4", 3],
      },
      [1705] => { # 魔法剣ダーク
        :word_1 => ["\\n<Granberia>Residing in my sword, power of darkness!", "granberia_fc4", 3],
      },
      [1706] => { # 魔法剣ポイズン
        :word_1 => ["\\n<Granberia>Residing in my sword, poisonous magic!", "granberia_fc4", 3],
      },
      [1707] => { # 魔法剣ブライン
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of darkness!", "granberia_fc4", 3],
      },
      [1708] => { # 魔法剣サイレンス
        :word_1 => ["\\n<Granberia>Residing in my sword, magical power of silence!", "granberia_fc4", 3],
      },
      [1709] => { # 魔法剣パラライズ
        :word_1 => ["\\n<Granberia>Residing in my sword, paralyzing magic!", "granberia_fc4", 3],
      },
      [1710] => { # 魔法剣コンフューズ
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of chaos!", "granberia_fc4", 3],
      },
      [1711] => { # 魔法剣スリープ
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of sleep!", "granberia_fc4", 3],
      },
      [1712] => { # 魔法剣デス
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of death!", "granberia_fc4", 3],
      },
      [1713] => { # 魔法剣ヘブン
        :word_1 => ["\\n<Granberia>Residing in my sword, the magic of ascension!", "granberia_fc4", 3],
      },
      [1714] => { # 魔法剣ドレイン
        :word_1 => ["\\n<Granberia>Residing in my sword, absorbing magic!", "granberia_fc4", 3],
      },
      [1715] => { # 魔法剣マドレイン
        :word_1 => ["\\n<Granberia>Residing in my sword, the magical power of absorption!", "granberia_fc4", 3],
      },
      [1718] => { # 魔法剣カーズ
        :word_1 => ["\\n<Granberia>Residing in my sword, cursed magic!", "granberia_fc4", 3],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Granberia>Deploy the magical protective wall!", "granberia_fc4", 3],
      },
      [1716] => { # マジックバリア
        :word_1 => ["\\n<Granberia>Protect your friends from evil techniques! \n Magic barrier!", "granberia_fc4", 3],
      },
      [1717] => { # マジックリフレクト
        :word_1 => ["\\n<Granberia>Heaven's blessing turns to earth and becomes a magic mirror! \n Magic reflect!", "granberia_fc4", 3],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Granberia>The sign of Yin and Yang, let me know the truth!", "granberia_fc4", 3],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Granberia>A piece of life, sending it is life! \n Carve out the slightest...Singing of life!", "granberia_fc4", 3],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Granberia>Move forward to the left, move to the right and move to the left...the step of the shrine, that is, Yu!", "granberia_fc4", 3],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Granberia>Get \n!", "granberia_fc4", 3],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Granberia>This is the essence of a thief!", "granberia_fc4", 3],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Granberia>I will show my back...", "granberia_fc4", 3],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Granberia>Shinobi no jutsu, carve it into your eyes!", "granberia_fc4", 3],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc4", 5],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Granberia>Healing waves, pervade thousands of places... \n Ninja art/healing waves!", "granberia_fc4", 3],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Granberia>Autumn Utsusemi dances in the shadows... \n Ninpo/Bunshin no Jutsu!", "granberia_fc4", 3],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Granberia>Use \n smoke bomb!", "granberia_fc4", 3],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Granberia>This is the secret pirate technique!", "granberia_fc4", 3],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Granberia>A flash of justice...haaaaaaah!", "granberia_fc4", 3],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Let's go to \n, seriously!　Aaah!!", "granberia_fc4", 3],
      },
      [1852] => { # マジカルスター
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Shattered, magical shooting star!", "granberia_fc4", 3],
      },
      [1853] => { # マジカルオーラ
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Penetrate, the wave of magic!", "granberia_fc4", 3],
      },
      [1854] => { # マジカルヒール
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Let's heal with the power of magic!", "granberia_fc4", 3],
      },
      [1855] => { # 円環の理
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Guide the lost soul, the principle of the circle!", "granberia_fc4", 3],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Granberia>This is my grudge...", "granberia_fc4", 3],
      },
      [1862] => { # 禍星
        :word_1 => ["\\n<Granberia>Come, misfortune star...", "granberia_fc4", 3],
      },
      [1863] => { # カーズウェーブ
        :word_1 => ["\\n<Granberia>delivered, wave of curse...", "granberia_fc4", 3],
      },
      [1864] => { # ワルプルギスの夜
        :word_1 => ["\\n<Granberia>Offer your flesh and blood to the witch's night...", "granberia_fc4", 3],
      },
      [1865] => { # 呪詩
        :word_1 => ["\\n<Granberia>Sound, the cursed poem...", "granberia_fc4", 3],
      },
      [1866] => { # アルテマ
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>This is the lost ancient magic... Ultima!", "granberia_fc4", 3],
      },
      [1867] => { # 胡蝶夢天
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>A dream of endless pleasure... Phalaenopsis dream heaven!", "granberia_fc4", 3],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Granberia>Should I use gold...", "granberia_fc4", 3],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Granberia>Would you like me to sell you this...", "granberia_fc4", 3],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Granberia>Use \nItem!", "granberia_fc4", 3],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Granberia>Carve it, card!", "granberia_fc4", 3],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Granberia>Battle with \n coins!", "granberia_fc4", 3],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Granberia>It's a game of darkness!", "granberia_fc4", 3],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Granberia>Tarot, show us your destiny!", "granberia_fc4", 3],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Granberia>I can hear the voice of the goddess...", "granberia_fc4", 3],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Granberia>slot, good luck!", "granberia_fc4", 3],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Granberia>It's time to play poker!", "granberia_fc4", 3],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Granberia>Battle Card, Draw!", "granberia_fc4", 3],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Granberia>The power contained in the playing cards...!", "granberia_fc4", 3],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Granberia>Today, the luckiest person is...", "granberia_fc4", 3],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Granberia>It's always my turn!", "granberia_fc4", 3],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Granberia>Heaven, please give me an item...", "granberia_fc4", 3],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Granberia>Let's dance...!", "granberia_fc4", 3],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Granberia>So! Hustle! Hustle!", "granberia_fc4", 3],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Granberia>Come on, listen to my song...!", "granberia_fc4", 3],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Granberia>Kira☆", "granberia_fc4", 3],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Granberia>If you have something to say, let me ask you before I kill you...", "granberia_fc4", 3],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Granberia>That's pretty good, let me praise you...", "granberia_fc4", 3],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Granberia>An existence like you is called 'shame'...", "granberia_fc4", 3],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Granberia>People over there, leave your money behind!", "granberia_fc4", 3],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Granberia>People over there, leave your items behind!", "granberia_fc4", 3],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Granberia>...Come with me.", "granberia_fc4", 3],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Granberia>Do you want to become the rust of this sword? ?", "granberia_fc4", 3],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Granberia>Disappear!", "granberia_fc4", 3],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Granberia>Then, Erubetie flows into the waterway...", "granberia_fc4", 4],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Granberia>Then Alma Elma cut my chest...", "granberia_fc4", 5],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Granberia>Then Tamamo comes out of the well, soaking wet...", "granberia_fc4", 3],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Granberia>I won with the sword...", "granberia_fc4", 3],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Granberia>This is the power of words!", "granberia_fc4", 3],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Granberia>This is the power of science!", "granberia_fc4", 3],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Granberia>We are already prepared!", "granberia_fc4", 3],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Granberia>Convert \n energy!", "granberia_fc4", 3],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Granberia>Alchemize \nItem!", "granberia_fc4", 3],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Granberia>Magic book technique, show your power!", "granberia_fc4", 3],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Granberia>Let's go to \n page...", "granberia_fc4", 3],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Granberia>This is the power of Makina!", "granberia_fc4", 3],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Granberia>I'm not good at cooking, but...", "granberia_fc4", 3],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Granberia>Get the ingredients!", "granberia_fc4", 3],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Granberia>I chop meat with my scalpel!", "granberia_fc4", 3],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc4", 5],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Granberia>Look at the brightness of my female!", "granberia_fc4", 3],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Granberia>Now, take this medicine!", "granberia_fc4", 3],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Granberia>It's an injection!", "granberia_fc4", 3],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Granberia>Spreading \n's special virus!", "granberia_fc4", 3],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Granberia>Let's work...", "granberia_fc4", 3],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc4", 5],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Granberia>Tea is here...", "granberia_fc4", 3],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Granberia>Maid Change!", "granberia_fc4", 3],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Granberia>Now, it's time to harvest...", "granberia_fc4", 3],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Granberia>Take the king's sword with your own body!", "granberia_fc4", 3],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Granberia>Experience the magic of the \n king for yourself!", "granberia_fc4", 3],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Granberia>Our army, gather here!", "granberia_fc4", 3],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Granberia>Now, ascend to heaven!", "granberia_fc4", 3],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Granberia>Bow down to my majesty!", "granberia_fc4", 3],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Granberia>The miracle of the king is shown here!", "granberia_fc4", 3],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Granberia>...Blitzkrieg!!", "granberia_fc4", 3],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Granberia>Seryaaaaa!!", "granberia_fc4", 3],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Granberia>This is the flash of a hero...haaaaaaaaaa!", "granberia_fc4", 3],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Granberia>Prevent evil attacks... Brave Wall!", "granberia_fc4", 3],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Granberia>I'm not good at things like this, but...", "granberia_fc4", 5],
      },
      2511..2513 => { # 淫技・自己強化
        :word_1 => ["\\n<Granberia>I don't give in to pleasure...!", "granberia_fc4", 3],
      },
      [2596] => { # 竜魂魔導
        :word_1 => ["\\n<Granberia>Awaken, the soul of the true dragon!", "granberia_fc4", 3],
      },
      [2678] => { # 引っ掻き
        :word_1 => ["\\n<Granberia>Eat these claws!", "granberia_fc4", 3],
      },
      [2686] => { # 噛み付き
        :word_1 => ["\\n<Granberia>Tear it apart with these fangs!", "granberia_fc4", 3],
      },
      [2689] => { # 双炎牙
        :word_1 => ["\\n<Granberia>Shatter with flaming fangs!", "granberia_fc4", 3],
      },
      [2690] => { # バーミリオンファング
        :word_1 => ["\\n<Granberia>Take it, Scorching Fang!", "granberia_fc4", 3],
      },
      [2691] => { # 絶氷牙
        :word_1 => ["\\n<Granberia>Shatter with ice fangs!", "granberia_fc4", 3],
      },
      [2692] => { # 断氷連牙
        :word_1 => ["\\n<Granberia>Tear apart, the merciless fangs of ice!", "granberia_fc4", 3],
      },
      [2696] => { # 蹂躙撃
        :word_1 => ["\\n<Granberia>Overrun... Oooh!", "granberia_fc4", 3],
      },
      [2698] => { # おたけび
        :word_1 => ["\\n<Granberia>Ohhhhh...!!", "granberia_fc4", 3],
      },
      [2699] => { # 破壊の咆吼
        :word_1 => ["\\n<Granberia>Oh!!", "granberia_fc4", 3],
      },
      [2734] => { # 凍てつく波動
        :word_1 => ["\\n<Granberia>Cut off the blessings... Blow away!", "granberia_fc4", 3],
      },
      [2830] => { # 羽ばたき
        :word_1 => ["\\n<Granberia>Blow away!", "granberia_fc4", 3],
      },
      [2831] => { # 強風
        :word_1 => ["\\n<Granberia>A fierce wind blows!", "granberia_fc4", 3],
      },
      [2832] => { # 超風
        :word_1 => ["\\n<Granberia>Erase everything... super wind!", "granberia_fc4", 3],
      },
      [3046] => { # 鉄砲水
        :word_1 => ["\\n<Granberia>Fierce muddy current, flash flood!", "granberia_fc4", 3],
      },
      [3047] => { # 津波
        :word_1 => ["\\n<Granberia>Swallow everything and wash it away! Tsunami!", "granberia_fc4", 3],
      },
      [3049] => { # タイダルウェイブ
        :word_1 => ["\\n<Granberia>The baptism of the tyrant who swallows everything! \n Tidal Wave!", "granberia_fc4", 3],
      },
      [3068] => { # 火の息
        :word_1 => ["\\n<Granberia>Eat the \n fireball!", "granberia_fc4", 3],
      },
      [3069] => { # 火炎の息
        :word_1 => ["\\n<Granberia>Burn with flame breath!", "granberia_fc4", 3],
      },
      [3070] => { # 激しい炎
        :word_1 => ["\\n<Granberia>Burn it down with fierce flames!", "granberia_fc4", 3],
      },
      [3071] => { # 灼熱の炎
        :word_1 => ["\\n<Granberia>Turn into dust with scorching flames!", "granberia_fc4", 3],
      },
      [3072] => { # 煉獄の火炎
        :word_1 => ["\\n<Granberia>Burn out, the flames of purgatory...!", "granberia_fc4", 3],
      },
      [9585] => { # 神竜乱牙
        :word_1 => ["\\n<Granberia>shatters, the true dragon fang!", "granberia_fc4", 3],
      },
      [9586] => { # 虚竜牙
        :word_1 => ["\\n<Granberia>Destroy the Fang of the Void Dragon!", "granberia_fc4", 3],
      },
      [9687] => { # 神竜大海嘯
        :word_1 => ["\\n<Granberia>Come, the great ocean called by the divine dragon...!", "granberia_fc4", 3],
      },
      [9688] => { # 虚竜の大海嘯
        :word_1 => ["\\n<Granberia>Return the tsunami of nothingness to zero...!", "granberia_fc4", 3],
      },
      [3073] => { # 核熱の息
        :word_1 => ["\\n<Granberia>Disappear with nuclear heat breath...!", "granberia_fc4", 3],
      },
      [3078] => { # 量子の息
        :word_1 => ["\\n<Granberia>Shattered by quantum breath...!", "granberia_fc4", 3],
      },
      [9692] => { # 無塵焔
        :word_1 => ["\\n<Granberia>A dustless flame that leaves no dust behind...!", "granberia_fc4", 3],
      },
      [3074] => { # 冷たい息
        :word_1 => ["\\n<Granberia>Freeze in the cold...!", "granberia_fc4", 3],
      },
      [3075] => { # 凍り付く息
        :word_1 => ["\\n<Granberia>Freezes to the point of shattering...!", "granberia_fc4", 3],
      },
      [3076] => { # 凍える吹雪
        :word_1 => ["\\n<Granberia>Rot in the blizzard...!", "granberia_fc4", 3],
      },
      [3077] => { # 輝く息
        :word_1 => ["\\n<Granberia>Extremely cold breath that freezes even the soul...", "granberia_fc4", 3],
      },
      [9693] => { # 極零光
        :word_1 => ["\\n<Granberia>Disappear in the frigid light... Polar zero light!", "granberia_fc4", 3],
      },
      [3087] => { # 焼け付く息
        :word_1 => ["\\n<Granberia>Come on, get numb...!", "granberia_fc4", 3],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Granberia>Let's take care of \n...", "granberia_fc4", 3],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Granberia>Pray to heaven...", "granberia_fc4", 3],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Granberia>This is my seriousness...!", "granberia_fc4", 3],
      },
      [3096] => { # 力溜め
        :word_1 => ["\\n<Granberia>Accumulate power...!", "granberia_fc4", 3],
      },
      [3097] => { # 気合い溜め
        :word_1 => ["\\n<Granberia>Get fired up...!", "granberia_fc4", 3],
      },
      [3098] => { # 全力溜め
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sword...!", "granberia_fc4", 3],
      },
      [3100] => { # 裏練気
        :word_1 => ["\\n<Granberia>Look at the sharpness of my sword...!", "granberia_fc4", 3],
      },
      [3102] => { # 竜鋼体
        :word_1 => ["\\n<Granberia>I will solidify my body with the dragon's fighting spirit... Ha!", "granberia_fc4", 3],
      },
      [9772] => { # 最終奥義
        :word_1 => ["\\n<Granberia>Let me show you the final secret technique...!", "granberia_fc4", 3],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Granberia>The power of elemental...!", "granberia_fc4", 3],
      },
      [3116] => { # 明鏡止水
        :word_1 => ["\\n<Granberia>This heart is in the flow of water...!", "granberia_fc4", 3],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Granberia>Take a deep breath to rest your body...", "granberia_fc4", 3],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Granberia>If you don't treat your body...", "granberia_fc4", 3],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Granberia>Have you been chased...", "granberia_fc4", 3],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Granberia>Wow...!!", "granberia_fc4", 3],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Granberia>Transform with a passionate belief in your heart!", "granberia_fc4", 3],
      },
      [3128, 9784] => { # 魔法少女変身
        :ct_pic => "ct_granberia4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Granberia>Henshin☆彡 Magical Girl Gran☆Beria!!", "granberia_fc4", 3],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Granberia>I feel a grudge for being turned into a magical girl...", "granberia_fc4", 3],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Granberia>I captured \n...!", "granberia_fc4", 3],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Granberia>Call for reinforcements!", "granberia_fc4", 3],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Granberia>Break that power!", "granberia_fc4", 3],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Granberia>Intermittent Spring, that's it!", "granberia_fc4", 3],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Granberia>Don't move!", "granberia_fc4", 3],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Granberia>What kind of pants are you wearing... \n For reference, let me show you!", "granberia_fc4", 3],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Granberia>Uffun♪ Sexy beam!", "granberia_fc4", 4],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Granberia>Uffun♪ Pink Typhoon!", "granberia_fc4", 4],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Granberia>Ufun♪ Fantastic Hurricane!", "granberia_fc4", 4],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Granberia>Now, it's my stage!", "granberia_fc4", 3],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Granberia>Look at the miracle of the Holy Grail!", "granberia_fc4", 3],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Granberia>Look at my struggle!", "granberia_fc4", 3],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Granberia>puff puff, puff puff...", "granberia_fc4", 3],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Granberia>Look at the power of this weapon!", "granberia_fc4", 3],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Granberia>Look at the power of \n aura!", "granberia_fc4", 3],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Granberia>How about this technique! ?", "granberia_fc4", 3],
      },
      [6115] => { # 竜拳
        :word_1 => ["\\n<Granberia>Take \n, Dragon's Fist!", "granberia_fc4", 3],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Granberia>Eat \n...!", "granberia_fc4", 3],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Granberia>I will protect you...!", "granberia_fc4", 3],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Granberia>Now... Assemble!!", "granberia_fc4", 3],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Granberia>Double up!", "granberia_fc4", 3],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Granberia>Next action, order!", "granberia_fc4", 3],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Granberia>Concentrate your power on one point...!", "granberia_fc4", 3],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Granberia>■■■■■■■■■■■■■■■...", "granberia_fc4", 3],
      },
      [3741] => { # しこしこ
        :word_1 => ["\\n<Granberia>Come on. I hope it ends in my hands...!", "granberia_fc4", 3],
        :word_2 => ["\\n<Granberia>Let me taste your essence...!", "granberia_fc4", 3],
        :word_3 => ["\\n<Granberia>Look, let's handle it...!", "granberia_fc4", 3],
      },
    },
    19 => { # アルマエルマ
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Alma Elma>Good!", "arumaeruma_fc2", 0],
        :word_2 => ["\\n<Alma Elma>Aha♪", "arumaeruma_fc2", 0],
        :word_3 => ["\\n<Alma Elma>Hey!", "arumaeruma_fc2", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Alma Elma>Try my knife skills...?", "arumaeruma_fc2", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Alma Elma>Even the sword can be used...", "arumaeruma_fc2", 0],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Alma Elma>Come on, heal...♪", "arumaeruma_fc2", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Alma Elma>Take a look at my rapier skills...?", "arumaeruma_fc2", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Alma Elma>Pride is what shines at night...", "arumaeruma_fc2", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Alma Elma>This blade is beautiful, isn't it...?", "arumaeruma_fc2", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Alma Elma>Connect your feelings to the blade...", "arumaeruma_fc2", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Alma Elma>Should I settle this honorably...?", "arumaeruma_fc2", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Alma Elma>I'll penetrate you, hehehe...", "arumaeruma_fc2", 0],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Alma Elma>Now, recover...♪", "arumaeruma_fc2", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Alma Elma>Come on, let's move...!", "arumaeruma_fc2", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Alma Elma>I don't like relying on brute force, but...!", "arumaeruma_fc2", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Alma Elma>Let me show you my axe dance...♪", "arumaeruma_fc2", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Alma Elma>I don't like relying on brute force, but...!", "arumaeruma_fc2", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Alma Elma>I'll invite you to die...", "arumaeruma_fc2", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Alma Elma>Now, fall into delusion...", "arumaeruma_fc2", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Alma Elma>Take a look at my bow skills...?", "arumaeruma_fc2", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Alma Elma>Now, recover...♪", "arumaeruma_fc2", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Alma Elma>Do you want to be trained by me...?", "arumaeruma_fc2", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Alma Elma>Come, servant!", "arumaeruma_fc2", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Alma Elma>Let's go, yeah!", "arumaeruma_fc2", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Alma Elma>I don't like relying on brute force, but...!", "arumaeruma_fc2", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Alma Elma>Come on, let's dance beautifully...!", "arumaeruma_fc2", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Alma Elma>Ne・ra・i・u・chi♪", "arumaeruma_fc2", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Alma Elma>Now, recover...♪", "arumaeruma_fc2", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Alma Elma>Myriad blades, let's go!", "arumaeruma_fc2", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Alma Elma>Now, let's dance...!", "arumaeruma_fc2", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>I'm going...", "arumaeruma_fc2", 0],
      },
      [1400] => { # 足払い
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>You've left your feet open!", "arumaeruma_fc2", 0],
      },
      [1401] => { # 飛び膝蹴り
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Haa! Flying Knee Kick!", "arumaeruma_fc2", 0],
      },
      [1402] => { # 回し蹴り
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Here I go, Roundhouse!", "arumaeruma_fc2", 0],
      },
      [1403] => { # 秘孔
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>I've got you now... Pressure Point!", "arumaeruma_fc2", 0],
      },
      [1405] => { # 正拳突き
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>A knockout blow... Fist Thrust!", "arumaeruma_fc2", 0],
      },
      [1406] => { # 羅刹掌
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>The rakshasa's fist... Rakshasa Palm!", "arumaeruma_fc2", 0],
      },
      [1407] => { # 爆裂拳
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Be mystified... Explosive Fist!", "arumaeruma_fc2", 0],
      },
      [1408] => { # 電塵連脚
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Be mystified... Lightning Kick!", "arumaeruma_fc2", 0],
      },
      [1409] => { # 炎舞三連撃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Burn... Flame Dance Fist!", "arumaeruma_fc2", 0],
      },
      [1410] => { # 氷拳乱雹撃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Freeze... Ice Rebellion Fist!", "arumaeruma_fc2", 0],
      },
      [1411] => { # 雷神喝撃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Scatter... Thunder God Fist!", "arumaeruma_fc2", 0],
      },
      [1412] => { # 真空波動掌
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Wave of wind...slice through the air...", "arumaeruma_fc2", 0],
      },
      [1413] => { # 土刻金剛拳
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Carve the earth, to pierce even diamond!", "arumaeruma_fc2", 0],
      },
      [1414] => { # 波断水裂蹴
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Cut the water's surface...with an instant kick!", "arumaeruma_fc2", 0],
      },
      [1425] => { # 聖光裂閃撃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Get a taste of this white flash! Light Rending Fist!", "arumaeruma_fc2", 0],
      },
      [1426] => { # 暗黒連衝拳
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Get a taste of this black shock! Dark Onslaught Fist!", "arumaeruma_fc2", 0],
      },
      [1427] => { # 四天光掌
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Quad Heaven Palm, tear across the shining heavens...!", "arumaeruma_fc2", 0],
      },
      [1428] => { # 四星滅功
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Four Strike Star Destruction, bloom in the dark sky...!", "arumaeruma_fc2", 0],
      },
      [1429] => { # 烈気光掌
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>A single blow to shake even the heavens... Spirit Palm!", "arumaeruma_fc2", 0],
      },
      [1430] => { # 瞬獄殺
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>The secret art of death...", "arumaeruma_fc2", 0],
      },
      [1431] => { # エレメントフィニッシュ
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Magical fist, engrave the brilliance of eight colors!", "arumaeruma_fc2", 0],
      },
      [9163] => { # 破滅の鉄槌
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>The judgment of the fist... the hammer of destruction!", "arumaeruma_fc2", 0],
      },
      [9156] => { # 零拳
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Scattered, sub-zero freezing fist... Zero Fist!", "arumaeruma_fc2", 0],
      },
      [9165] => { # 聖天轟裂撃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Breath of white light... Holy Heaven's roar ruptures!", "arumaeruma_fc2", 0],
      },
      [9166] => { # 魔天冥煌撃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Breath of darkness...Demon heaven's glittering attack!", "arumaeruma_fc2", 0],
      },
      [9167] => { # 覆滅陰陽撃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>The Yin-Yang formula resides in this fist... Overturning Yin-Yang attack!", "arumaeruma_fc2", 0],
      },
      [9172] => { # 炎拳氷巴
        :ct_pic => "ct_arumaeruma3",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Entrust fire and ice to this fist...Flame Fist Hyo Tomoe!", "arumaeruma_fc2", 0],
      },
      [9173] => { # 天地開闢拳
        :ct_pic => "ct_arumaeruma4",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Open the heavens and strike the earth... Heaven and Earth Opening Fist!", "arumaeruma_fc2", 0],
      },
      [1437] => { # サキュバスビンタ
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Clench your teeth... Yaaa!", "arumaeruma_fc2", 0],
      },
      [1438] => { # ラッシュビンタ
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>I'll send you flying... Yayayaaa!", "arumaeruma_fc2", 0],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Come on, I'll make you feel good...", "arumaeruma_fc2", 0],
      },
      [1439] => { # 魔掌・乳搾り
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Now, I'll squeeze your milk out...", "arumaeruma_fc2", 0],
      },
      [1440] => { # 魔掌・失禁の誘い
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>I'll make you leak, fufufu...", "arumaeruma_fc2", 0],
      },
      [1441] => { # 総撫閃
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Here it comes, a flash of caress...", "arumaeruma_fc2", 0],
      },
      [1442] => { # 瞬迅乱撫
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Be aroused, ufufufu...!", "arumaeruma_fc2", 0],
      },
      [1443] => { # 古式淫闘法
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Let me give you a taste of the sexual art from ancient times...", "arumaeruma_fc2", 0],
      },
      [1444] => { # 古式淫闘法・瀉葬
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>I will dry you up with my ancient lewd techniques...", "arumaeruma_fc2", 0],
      },
      [1445] => { # 古式淫闘法・虚快虚楽
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>An ancient ultimate lewd technique that no one knows about...", "arumaeruma_fc2", 0],
      },
      [9174] => { # メギドハーロット
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>I will sacrifice you for the end... Megid Harlot!", "arumaeruma_fc2", 0],
      },
      [1433] => { # 当て身光掌
        :word_1 => ["\\n<Alma Elma>....................", "arumaeruma_fc2", 0],
      },
      [1434] => { # 当て身光掌（発動）
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>There's a chance... Amitami light palm!", "arumaeruma_fc2", 0],
      },
      [1435] => { # 金剛八連拳
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Break everything, Kongo's fist... Kongo's eight consecutive fists!", "arumaeruma_fc2", 0],
      },
      [1436] => { # 紅蓮大拳舞
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Dance in disorder, the crimson flame! Guren Daikenbu!", "arumaeruma_fc2", 0],
      },
      [9157] => { # 電塵乱皇脚
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Flash, noble thunder! Denjinran Kokyaku!", "arumaeruma_fc2", 0],
      },
      [9159] => { # 真・瞬獄殺
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>The living will be destroyed, all things will be destroyed...", "arumaeruma_fc2", 0],
      },
      [9164] => { # 修羅爆裂拳
        :ct_pic => "ct_arumaeruma1",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Shura's fist strikes wildly!　Aaah!!", "arumaeruma_fc2", 0],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Alma Elma>Healing wave... Chakra!", "arumaeruma_fc2", 0],
      },
      [1446] => { # チャクラ
        :word_1 => ["\\n<Alma Elma>Healing wave... Chakra!", "arumaeruma_fc2", 0],
      },
      [1447] => { # 拡散チャクラ
        :word_1 => ["\\n<Alma Elma>Healing wave... Diffusive Chakra!", "arumaeruma_fc2", 0],
      },
      [1449] => { # 究極チャクラ
        :word_1 => ["\\n<Alma Elma>Healing waves...the ultimate chakra!", "arumaeruma_fc2", 0],
      },
      [1450] => { # 蘇生
        :word_1 => ["\\n<Alma Elma>Come back to us... Yaa!", "arumaeruma_fc2", 0],
      },
      [1451] => { # 裏蘇生
        :word_1 => ["\\n<Alma Elma>The forbidden resurrection art... Yaa!", "arumaeruma_fc2", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Alma Elma>Magical pulse, imbue these fist!", "arumaeruma_fc2", 0],
      },
      [1452] => { # 三魔の拳
        :word_1 => ["\\n<Alma Elma>Breath of the three magics, imbue these fists!", "arumaeruma_fc2", 0],
      },
      [1453] => { # 四精の拳
        :word_1 => ["\\n<Alma Elma>Breath of the four spirits, imbue these fists!", "arumaeruma_fc2", 0],
      },
      [1454] => { # 聖魔の拳
        :word_1 => ["\\n<Alma Elma>Breath of the two energies, imbue these fists!", "arumaeruma_fc2", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Alma Elma>White torrent, heal your injured body!", "arumaeruma_fc2", 0],
      },
      [9180] => { # コスモヒール
        :word_1 => ["\\n<Alma Elma>White torrent, heal your injured body!", "arumaeruma_fc2", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Alma Elma>White torrent, destroy the darkness!", "arumaeruma_fc2", 0],
      },
      [1473, 1474, 9190] => { # ヘブン
        :word_1 => ["\\n<Alma Elma>Immortal high will, bring evil to God's mercy! \n Heaven!", "arumaeruma_fc2", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Alma Elma>White torrent, give me power!", "arumaeruma_fc2", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Alma Elma>White torrent, prevent evil power!", "arumaeruma_fc2", 0],
      },
      [*1489..1490] => { # キャンセル
        :word_1 => ["\\n<Alma Elma>A white torrent that hates evil, protect the devil and exorcise the wall! \n Cancelled!", "arumaeruma_fc2", 0],
      },
      [1490] => { # オールキャンセル
        :word_1 => ["\\n<Alma Elma>A white torrent that hates evil, protects demons and exorcises walls... \n All canceled...!", "arumaeruma_fc2", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Alma Elma>Black torrent, obey my orders!", "arumaeruma_fc2", 0],
      },
      [1514] => { # ウィンド
        :word_1 => ["\\n<Alma Elma>Dancing wind, become a blade to slice them to pieces! Wind!", "arumaeruma_fc2", 0],
      },
      [1515] => { # エアロ
        :word_1 => ["\\n<Alma Elma>Violent wind, rage like a ceaseless storm!\nAero!", "arumaeruma_fc2", 0],
      },
      [1516] => { # デルタエアロ
        :word_1 => ["\\n<Alma Elma>Boundless green, dancing with energy!\nBecome a sixfold cyclone, Delta Aero!", "arumaeruma_fc2", 0],
      },
      [9198] => { # エクスエアロ
        :word_1 => ["\\n<Alma Elma>Seamless dark green, dancing in an endless storm! \n Scattered to the extreme, Ex Aero!", "arumaeruma_fc2", 0],
      },
      [9199] => { # エメラルドナイト
        :word_1 => ["\\n<Alma Elma>The green world perishes in the wind... Emerald Night!", "arumaeruma_fc2", 0],
      },
      [9211] => { # ヴァイヴ
        :word_1 => ["\\n<Alma Elma>Trembling waves, bring sweet joy! \nVibe!", "arumaeruma_fc2", 0],
      },
      [9212] => { # ジェル
        :word_1 => ["\\n<Alma Elma>Sticky water mass, drown in obscene pleasure! \n Gel!", "arumaeruma_fc2", 0],
      },
      [9214] => { # グランスアード
        :word_1 => ["\\n<Alma Elma>Sake Pond Meat Forest, depart for the paradise of pleasure! \n Glance Ard!", "arumaeruma_fc2", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Alma Elma>Reaper's scythe which harvests life, lead their soul to Hades! Death!", "arumaeruma_fc2", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Alma Elma>Torrent of black, obey my command!", "arumaeruma_fc2", 0],
      },
      [1540] => { # ミニマムファンタズム
        :word_1 => ["\\n<Alma Elma>Return to the prison of time, and know how weak you truly are!! Minimum Phantasm!", "arumaeruma_fc2", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Alma Elma>Tranquil breeze of life, blow and become a squall of grace!\nHeal Typhoon!", "arumaeruma_fc2", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Alma Elma>The torrent of time, follow my will and carve your steps!", "arumaeruma_fc2", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Alma Elma>Torrent of time, distort time and space and bring destruction!", "arumaeruma_fc2", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Alma Elma>Holy light, dispel the darkness!", "arumaeruma_fc2", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Alma Elma>Warrior's soul, please come back!", "arumaeruma_fc2", 0],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Alma Elma>Light like an angel...", "arumaeruma_fc2", 0],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Alma Elma>I'll show you heaven...", "arumaeruma_fc2", 0],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Alma Elma>Holy light, bring healing...", "arumaeruma_fc2", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Alma Elma>Now, let's do something flashy...", "arumaeruma_fc2", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Alma Elma>....................", "arumaeruma_fc2", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Alma Elma>Enjoy the power of darkness...?", "arumaeruma_fc2", 0],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Alma Elma>Enjoy the power of darkness...?", "arumaeruma_fc2", 0],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Alma Elma>Magical power resides in the sword...!", "arumaeruma_fc2", 0],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Alma Elma>Magical barrier, expand...!", "arumaeruma_fc2", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Alma Elma>Make the sign of Yin and Yang known!", "arumaeruma_fc2", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Alma Elma>The law of exorcism, the prison of rebellion! \n Realize your retribution, Nine Souls Exorcism Team!", "arumaeruma_fc2", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Alma Elma>One piece of life, sending it is life! \n Carving out the slightest...Singing life!", "arumaeruma_fc2", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Alma Elma>Move forward to the left, move to the right and move to the left...the step of the shaman, that is, Yu!", "arumaeruma_fc2", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Alma Elma>I'll get \n...♪", "arumaeruma_fc2", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Alma Elma>I'll show you the proof of being a thief...", "arumaeruma_fc2", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Alma Elma>Hurry up, let's move♪", "arumaeruma_fc2", 0],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Alma Elma>Shinobi no jutsu, carve it into your eyes!", "arumaeruma_fc2", 0],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Alma Elma>Want to try out Kunoichi's technique...?", "arumaeruma_fc2", 0],
      },
      [1805] => { # 忍術・回復
        :word_1 => ["\\n<Alma Elma>Wave of healing, spread a thousand ways...\nNinja Art: Healing Wave!", "arumaeruma_fc2", 0],
      },
      [1806] => { # 忍術・分身
        :word_1 => ["\\n<Alma Elma>Empty cicada shells of autumn, dancing like shadows... Ninja Art: Doppelganger!", "arumaeruma_fc2", 0],
      },
      [1807] => { # 忍術・煙幕隠れ
        :word_1 => ["\\n<Alma Elma>We'll escape with this smoke bomb♪", "arumaeruma_fc2", 0],
      },
      [*1813..1837, *9333..9338] => { # 海賊技
        :word_1 => ["\\n<Alma Elma>Let's go♪", "arumaeruma_fc2", 0],
      },
      [*1842..1851, *1857..1859] => { # ヒーロー技
        :word_1 => ["\\n<Alma Elma>Let's go ♪ Hey ♪", "arumaeruma_fc2", 0],
      },
      [*1852..1856, *1860..1861, *1866..1867] => { # ヒーロー技・魔法少女
        :ct_pic => "ct_arumaeruma2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Magical☆Alma, Ei...♪", "arumaeruma_fc2", 0],
      },
      [*1874..1887, *9342..9347] => { # 商技
        :word_1 => ["\\n<Alma Elma>It's the power of money♪", "arumaeruma_fc2", 0],
      },
      [*1888..1917, *9346..9363] => { # 商技・購入
        :word_1 => ["\\n<Alma Elma>I'll get this♪", "arumaeruma_fc2", 0],
      },
      [*1921..1982, *9367..9372] => { # EXアイテム
        :word_1 => ["\\n<Alma Elma>I will use \nItem♪", "arumaeruma_fc2", 0],
      },
      [*1984..1988,9376,9377] => { # オラクル・攻撃
        :word_1 => ["\\n<Alma Elma>How about playing cards...?", "arumaeruma_fc2", 0],
      },
      [1989] => { # コイントス
        :word_1 => ["\\n<Alma Elma>Let's have a coin toss♪", "arumaeruma_fc2", 0],
      },
      1990..1992 => { # 闇のゲーム
        :word_1 => ["\\n<Alma Elma>Let's play a shady game♪", "arumaeruma_fc2", 0],
      },
      [1993] => { # タロット
        :word_1 => ["\\n<Alma Elma>How about I give a tarot reading...?", "arumaeruma_fc2", 0],
      },
      [1994] => { # 女神の託宣
        :word_1 => ["\\n<Alma Elma>What a disgusting voice...", "arumaeruma_fc2", 0],
      },
      [1995] => { # スロット
        :word_1 => ["\\n<Alma Elma>Let's play the slots♪", "arumaeruma_fc2", 0],
      },
      [1996] => { # ポーカー
        :word_1 => ["\\n<Alma Elma>Let's play poker♪", "arumaeruma_fc2", 0],
      },
      [*1997..2001,9378,9379] => { # オラクル・カードバトル
        :word_1 => ["\\n<Alma Elma>Battle Card, Draw!", "arumaeruma_fc2", 0],
      },
      [*2002..2006, *7744] => { # オラクル・トランプ
        :word_1 => ["\\n<Alma Elma>The power contained in the playing cards...♪", "arumaeruma_fc2", 0],
      },
      [2008, 2009] => { # 幸運の星・ラッキーハンター
        :word_1 => ["\\n<Alma Elma>Today, the luckiest one is...", "arumaeruma_fc2", 0],
      },
      [2010] => { # ずっと俺のターン
        :word_1 => ["\\n<Alma Elma>It's always my turn♪", "arumaeruma_fc2", 0],
      },
      2011..2014 => { # アイテムスロット
        :word_1 => ["\\n<Alma Elma>God, give me the item♪", "arumaeruma_fc2", 0],
      },
      [*2016..2069, *9384..9403] => { # 踊り
        :word_1 => ["\\n<Alma Elma>I'll show you my dance...♪", "arumaeruma_fc2", 0],
      },
      [2047,9396] => { # ハッスルダンス
        :word_1 => ["\\n<Alma Elma>That's it! Hustle! Hustle!", "arumaeruma_fc2", 0],
      },
      [*2071..2106, *9405..9431] => { # 歌
        :word_1 => ["\\n<Alma Elma>I'll let you hear my song...♪", "arumaeruma_fc2", 0],
      },
      [2081,9422] => { # キラッ☆
        :word_1 => ["\\n<Alma Elma>Kira☆", "arumaeruma_fc2", 0],
      },
      [2109] => { # 話し掛ける
        :word_1 => ["\\n<Alma Elma>Can't we have a talk...?", "arumaeruma_fc2", 0],
      },
      [2110,2111,9433] => { # ほめる
        :word_1 => ["\\n<Alma Elma>It's a big deal, hehe...", "arumaeruma_fc2", 0],
      },
      [2112,2113,9434] => { # 挑発する
        :word_1 => ["\\n<Alma Elma>It's a waste of time...", "arumaeruma_fc2", 0],
      },
      [2114] => { # お金をもらう
        :word_1 => ["\\n<Alma Elma>Could I have some money?", "arumaeruma_fc2", 0],
      },
      [2115] => { # アイテムをもらう
        :word_1 => ["\\n<Alma Elma>Could I have an item?", "arumaeruma_fc2", 0],
      },
      [2116] => { # 仲間に誘う
        :word_1 => ["\\n<Alma Elma>Will you come along with us...?", "arumaeruma_fc2", 0],
      },
      [2117] => { # おどす
        :word_1 => ["\\n<Alma Elma>Do you want to have a painful experience...?", "arumaeruma_fc2", 0],
      },
      [2118] => { # 帰ってもらう
        :word_1 => ["\\n<Alma Elma>Go home already...", "arumaeruma_fc2", 0],
      },
      [2119] => { # おもしろい話
        :word_1 => ["\\n<Alma Elma>And then Granberry...", "arumaeruma_fc2", 0],
      },
      [2120] => { # いやらしい話
        :word_1 => ["\\n<Alma Elma>And then Granberry...", "arumaeruma_fc2", 0],
      },
      [2121] => { # 怖い話
        :word_1 => ["\\n<Alma Elma>Then Tamamo came out from the darkness...", "arumaeruma_fc2", 0],
      },
      [2122] => { # 寒いギャグ
        :word_1 => ["\\n<Alma Elma>Need a ride? I can get you where you need to go, so all aboard the suck-you-bus!", "arumaeruma_fc2", 0],
      },
      [*2123..2128, *9435..9439] => { # 話術
        :word_1 => ["\\n<Alma Elma>The power of words...", "arumaeruma_fc2", 0],
      },
      [*2132..2146, *9443..9450] => { # 魔導科学
        :word_1 => ["\\n<Alma Elma>Come on, it's science time♪", "arumaeruma_fc2", 0],
      },
      [2147, 2148] => { # 魔導科学・防護
        :word_1 => ["\\n<Alma Elma>I have to be prepared...", "arumaeruma_fc2", 0],
      },
      [*2149..2154, *9451..9454] => { # 魔導科学・変換
        :word_1 => ["\\n<Alma Elma>I will convert the energy...", "arumaeruma_fc2", 0],
      },
      [*2157..2198, *9459..9460]  => { # 錬金術・アイテム
        :word_1 => ["\\n<Alma Elma>I will alchemize \nItem...", "arumaeruma_fc2", 0],
      },
      [*2200..2222, *9464..9471]  => { # 魔本術
        :word_1 => ["\\n<Alma Elma>Magic book technique, show your power!", "arumaeruma_fc2", 0],
      },
      [2223, 2224] => { # ページ化
        :word_1 => ["\\n<Alma Elma>Take good care of them...", "arumaeruma_fc2", 0],
      },
      [*2230..2253, *9475..9480] => { # マキナ
        :word_1 => ["\\n<Alma Elma>Machines are so naughty...", "arumaeruma_fc2", 0],
      },
      [*2257..2319, 2322, 2323, *9483..9488] => { # 料理
        :word_1 => ["\\n<Alma Elma>Would you like to try my cooking?", "arumaeruma_fc2", 0],
      },
      [2320] => { # 食材採取
        :word_1 => ["\\n<Alma Elma>I'll get the ingredients♪", "arumaeruma_fc2", 0],
      },
      [*2327..2333, *9490..9491] => { # 医術・攻撃
        :word_1 => ["\\n<Alma Elma>Try eating a female...?", "arumaeruma_fc2", 0],
      },
      [*2334..2335, 9493] => { # 医術・快楽
        :word_1 => ["\\n<Alma Elma>Where does it feel good...?", "arumaeruma_fc2", 0],
      },
      [*2336..2343, *9494..9498] => { # 医術・回復
        :word_1 => ["\\n<Alma Elma>Now, it's time for surgery...", "arumaeruma_fc2", 0],
      },
      [*2344..2356, 2363, *9499..9502] => { # 医術・強化
        :word_1 => ["\\n<Alma Elma>Now, take this medicine...", "arumaeruma_fc2", 0],
      },
      [2357] => { # お注射なのじゃ！
        :word_1 => ["\\n<Alma Elma>Here's your shot, ufufu...", "arumaeruma_fc2", 0],
      },
      [*2358..2362, 9492] => { # 医術・状態異常
        :word_1 => ["\\n<Alma Elma>Should I spread the \n virus...", "arumaeruma_fc2", 0],
      },
      [*2367..2376, 9507, 9508, 9510] => { # メイド技・攻撃
        :word_1 => ["\\n<Alma Elma>I will serve you...♪", "arumaeruma_fc2", 0],
      },
      [*2377..2388, 9506, 9509, *9511..9514] => { # メイド技・快楽
        :word_1 => ["\\n<Alma Elma>I will serve you...♪", "arumaeruma_fc2", 0],
      },
      [*2389..2392, 9515] => { # メイド技・回復
        :word_1 => ["\\n<Alma Elma>Tea is here...♪", "arumaeruma_fc2", 0],
      },
      2393..2396 => { # メイド技・自己補助
        :word_1 => ["\\n<Alma Elma>Maid Change...♪", "arumaeruma_fc2", 0],
      },
      [2397] => { # 家庭菜園の収穫
        :word_1 => ["\\n<Alma Elma>I need to harvest♪", "arumaeruma_fc2", 0],
      },
      [*2403..2406, 9519, 9521] => { # 王技・剣技
        :word_1 => ["\\n<Alma Elma>This is the power of the Queen...♪", "arumaeruma_fc2", 0],
      },
      [*2407..2412, 9520] => { # 王技・魔法
        :word_1 => ["\\n<Alma Elma>This is the power of the Queen...♪", "arumaeruma_fc2", 0],
      },
      [*2413..2417, 9522] => { # 王技・軍隊
        :word_1 => ["\\n<Alma Elma>This is the power of the Queen...♪", "arumaeruma_fc2", 0],
      },
      [2418, 2419] => { # 王技・説法
        :word_1 => ["\\n<Alma Elma>My, you've been bad children...", "arumaeruma_fc2", 0],
      },
      [2420, 2421] => { # 王の威光・王権神授
        :word_1 => ["\\n<Alma Elma>Now, kneel before me...", "arumaeruma_fc2", 0],
      },
      [*2422..2425, 9523] => { # 恩寵
        :word_1 => ["\\n<Alma Elma>I'll show you the miracle of the king♪", "arumaeruma_fc2", 0],
      },
      [2432] => { # やたらめった斬り
        :word_1 => ["\\n<Alma Elma>Yayayayaah...♪", "arumaeruma_fc2", 0],
      },
      [*2433..2456] => { # 勇者技・攻撃
        :word_1 => ["\\n<Alma Elma>Being a hero looks like fun...♪", "arumaeruma_fc2", 0],
      },
      [*2460..2510, *9527..9533] => { # 淫技
        :word_1 => ["\\n<Alma Elma>Let's do something that feels good, hehehe...", "arumaeruma_fc2", 0],
      },
      [2460] => { # 手淫
        :word_1 => ["\\n<Alma Elma>I'll use my hands to play with you...", "arumaeruma_fc2", 0],
      },
      [2461] => { # 恍惚の指使い
        :word_1 => ["\\n<Alma Elma>Immerse yourself in ecstasy from my hands...", "arumaeruma_fc2", 0],
      },
      [2462] => { # 昇天の指使い
        :word_1 => ["\\n<Alma Elma>Ascend to heaven from my hands...", "arumaeruma_fc2", 0],
      },
      [2465] => { # 口淫
        :word_1 => ["\\n<Alma Elma>I'll use my mouth to play with you...", "arumaeruma_fc2", 0],
      },
      [2466] => { # 至福の口淫
        :word_1 => ["\\n<Alma Elma>I'll give you blissful ecstasy with my mouth...", "arumaeruma_fc2", 0],
      },
      [2467] => { # 種吸いの口淫
        :word_1 => ["\\n<Alma Elma>I'll suck you dry with my mouth...", "arumaeruma_fc2", 0],
      },
      [2468] => { # パイズリ
        :word_1 => ["\\n<Alma Elma>Enjoy my breasts...", "arumaeruma_fc2", 0],
      },
      [2469] => { # 慈愛の乳圧
        :word_1 => ["\\n<Alma Elma>Taste the affection of my breasts...", "arumaeruma_fc2", 0],
      },
      [2470] => { # 悪夢の胸搾り
        :word_1 => ["\\n<Alma Elma>Enjoy a nightmare from my breasts...", "arumaeruma_fc2", 0],
      },
      [2471] => { # 騎乗位
        :word_1 => ["\\n<Alma Elma>I'm going to rape you, ufufu...", "arumaeruma_fc2", 0],
      },
      [2472] => { # 天上のカーマストラ
        :word_1 => ["\\n<Alma Elma>Get a taste of heavenly pleasure...", "arumaeruma_fc2", 0],
      },
      [2473] => { # 傾国の夢
        :word_1 => ["\\n<Alma Elma>I'll take everything away from you...", "arumaeruma_fc2", 0],
      },
      [2476] => { # ヘブンズキッス
        :word_1 => ["\\n<Alma Elma>You'll ascend from this kiss of heaven...", "arumaeruma_fc2", 0],
      },
      [2477] => { # デスキッス
        :word_1 => ["\\n<Alma Elma>I'll take you to the next world with this kiss of death...", "arumaeruma_fc2", 0],
      },
      [2482] => { # QUJC
        :word_1 => ["\\n<Alma Elma>This is the ultimate pleasure technique...", "arumaeruma_fc2", 0],
      },
      [2483] => { # 小悪魔の指技
        :word_1 => ["\\n<Alma Elma>I'll use my fingers to play with you...", "arumaeruma_fc2", 0],
      },
      [2484] => { # ラフィンジェンド
        :word_1 => ["\\n<Alma Elma>Get a feel of my hands...", "arumaeruma_fc2", 0],
      },
      [2485] => { # 小悪魔の口技
        :word_1 => ["\\n<Alma Elma>My mouth will make you moan...*lick*.", "arumaeruma_fc2", 0],
      },
      [2486] => { # ティンキュルス
        :word_1 => ["\\n<Alma Elma>Squirm from my mouth, ufufu...", "arumaeruma_fc2", 0],
      },
      [2487] => { # 小悪魔のパイズリ
        :word_1 => ["\\n<Alma Elma>My breasts feel good, don't they?", "arumaeruma_fc2", 0],
      },
      [2488] => { # メロソフィ
        :word_1 => ["\\n<Alma Elma>I'll pinch you between my breasts...", "arumaeruma_fc2", 0],
      },
      [2489] => { # 小悪魔レイプ
        :word_1 => ["\\n<Alma Elma>Girls will enjoy this too...", "arumaeruma_fc2", 0],
      },
      [2490] => { # エナジードレイン
        :word_1 => ["\\n<Alma Elma>Now, I'll drain your energy...", "arumaeruma_fc2", 0],
      },
      [2491] => { # ナイトメアドレイン
        :word_1 => ["\\n<Alma Elma>I'll let you taste a nightmare of draining...", "arumaeruma_fc2", 0],
      },
      [2492] => { # クィーンズドレイン
        :word_1 => ["\\n<Alma Elma>Now, you get to be drained by a queen...", "arumaeruma_fc2", 0],
      },
      [9531] => { # リリスドレイン
        :word_1 => ["\\n<Alma Elma>The height of lewdness, the ultimate energy drain...", "arumaeruma_fc2", 0],
      },
      [9532] => { # バビロンズドレイン
        :word_1 => ["\\n<Alma Elma>I'll let you taste the great slut's drain...", "arumaeruma_fc2", 0],
      },
      [2493] => { # テイルドレイン
        :word_1 => ["\\n<Alma Elma>I'll suck your energy with my tail...", "arumaeruma_fc2", 0],
      },
      [2494] => { # テイルドレイン・フラン
        :word_1 => ["\\n<Alma Elma>My tail will suck your life away...", "arumaeruma_fc2", 0],
      },
      [2495] => { # メルティックキッス
        :word_1 => ["\\n<Alma Elma>I'll give you nice kiss...", "arumaeruma_fc2", 0],
      },
      [2496] => { # メルティックボア
        :word_1 => ["\\n<Alma Elma>I'll swallow you whole with my tail...", "arumaeruma_fc2", 0],
      },
      [2497] => { # サキュバスアーツ
        :word_1 => ["\\n<Alma Elma>Ruin with ancient sexual techniques...♪", "arumaeruma_fc2", 0],
      },
      [2498] => { # サキュバスアーツ零式
        :word_1 => ["\\n<Alma Elma>Ruin with ancient sexual techniques...♪", "arumaeruma_fc2", 0],
      },
      [2499] => { # リリスオルギア
        :word_1 => ["\\n<Alma Elma>Going crazy with the flesh is the devil's ultimate skill... \n Going crazy in agony with infinite pleasure! Lilith Orgia!", "arumaeruma_fc2", 0],
      },
      [9533] => { # ワールドオルガスム
        :word_1 => ["\\n<Alma Elma>world, be immersed in a nightmare of pleasure...", "arumaeruma_fc2", 0],
      },
      [9527] => { # ライトニングジョブ
        :word_1 => ["\\n<Alma Elma>I'll make you cum in an instant...", "arumaeruma_fc2", 0],
      },
      [9528] => { # ナイトメアアーツ
        :word_1 => ["\\n<Alma Elma>End your nightmare with the arts...!", "arumaeruma_fc2", 0],
      },
      [9529] => { # オーバーグローリー
        :word_1 => ["\\n<Alma Elma>The ultimate pleasure art... Over Glory!", "arumaeruma_fc2", 0],
      },
      [9530] => { # 死に至る快楽
        :word_1 => ["\\n<Alma Elma>I will let you fully enjoy the pleasure that will lead to death...", "arumaeruma_fc2", 0],
      },
      [2500] => { # カオスナイトメア
        :word_1 => ["\\n<Alma Elma>Drown in a chaotic nightmare...", "arumaeruma_fc2", 0],
      },
      [2511] => { # 悦楽の防護
        :word_1 => ["\\n<Alma Elma>I take pride in my endurance...", "arumaeruma_fc2", 0],
      },
      [2512] => { # 悦楽の遮断
        :word_1 => ["\\n<Alma Elma>Pleasure will not work against me...", "arumaeruma_fc2", 0],
      },
      [2513] => { # 快楽こそ糧
        :word_1 => ["\\n<Alma Elma>I devour pleasure. That is what it means to be a succubus♪", "arumaeruma_fc2", 0],
      },
      [2550] => { # 睡眠の魔眼
        :word_1 => ["\\n<Alma Elma>Sleep with my evil eye...♪", "arumaeruma_fc2", 0],
      },
      [2558] => { # 最後の魔眼
        :word_1 => ["\\n<Alma Elma>With the last evil eye, be disturbed...♪", "arumaeruma_fc2", 0],
      },
      [2560] => { # 恍惚の魔眼
        :word_1 => ["\\n<Alma Elma>Immerse yourself in ecstasy with my evil eye...♪", "arumaeruma_fc2", 0],
      },
      [2561] => { # 誘惑の魔眼
        :word_1 => ["\\n<Alma Elma>I will steal your heart with my evil eye...♪", "arumaeruma_fc2", 0],
      },
      [2562] => { # 失禁の魔眼
        :word_1 => ["\\n<Alma Elma>Please leak it with my evil eye...♪", "arumaeruma_fc2", 0],
      },
      [2563] => { # 絶頂の魔眼
        :word_1 => ["\\n<Alma Elma>Journey to the height of pleasure... Demons Eyes!", "arumaeruma_fc2", 0],
      },
      [9543] => { # 大淫婦の魔眼
        :word_1 => ["\\n<Alma Elma>This is the evil eye of the great prostitute of Babylon...!", "arumaeruma_fc2", 0],
      },
      [2569] => { # 永眠の誘い
        :word_1 => ["\\n<Alma Elma>Depart towards a neverending dream...", "arumaeruma_fc2", 0],
      },
      [2570] => { # 快楽昇天
        :word_1 => ["\\n<Alma Elma>I'll let you ascend, ufufu...", "arumaeruma_fc2", 0],
      },
      [2590] => { # 紫のサバト
        :word_1 => ["\\n<Alma Elma>Let's dance under the purple moon...", "arumaeruma_fc2", 0],
      },
      [3037] => { # かまいたち
        :word_1 => ["\\n<Alma Elma>Let's play, Slicing Gust...", "arumaeruma_fc2", 0],
      },
      [3038] => { # 突風
        :word_1 => ["\\n<Alma Elma>Squall, come play with me...", "arumaeruma_fc2", 0],
      },
      [3040] => { # シャムシール
        :word_1 => ["\\n<Alma Elma>Shred infinitely, gale of blades! Shamshir!", "arumaeruma_fc2", 0],
      },
      [3041] => { # テラサイクロン
        :word_1 => ["\\n<Alma Elma>Storm of nightmares, devastate the land...\nTera Cyclone!", "arumaeruma_fc2", 0],
      },
      [9683] => { # 塵風
        :word_1 => ["\\n<Alma Elma>The wind that returns everything to dust...dust wind!", "arumaeruma_fc2", 0],
      },
      [9684] => { # 千夜・塵風
        :word_1 => ["\\n<Alma Elma>The wind that returns everything to dust... Chiya Dust Wind!", "arumaeruma_fc2", 0],
      },
      [3094] => { # 手当て
        :word_1 => ["\\n<Alma Elma>Let me take care of that...", "arumaeruma_fc2", 0],
      },
      [3095] => { # お祈り
        :word_1 => ["\\n<Alma Elma>It's not in my nature to do this, but...", "arumaeruma_fc2", 0],
      },
      [1004, 1672, 2515, 2735, 2736, *3096..3105, 3116, 9005, 9075, 9115, *9772..9779, 10008] => { # 肉体自己強化
        :word_1 => ["\\n<Alma Elma>Let's go...!", "arumaeruma_fc2", 0],
      },
      [3099] => { # 練気
        :word_1 => ["\\n<Alma Elma>Focus...", "arumaeruma_fc2", 0],
      },
      [3100] => { # 裏練気
        :word_1 => ["\\n<Alma Elma>Focus my inner mind...!", "arumaeruma_fc2", 0],
      },
      [3101] => { # 鋼体
        :word_1 => ["\\n<Alma Elma>Steel Body...!", "arumaeruma_fc2", 0],
      },
      [9774] => { # 最終練気
        :word_1 => ["\\n<Alma Elma>The ultimate in concentration, the final effort...!", "arumaeruma_fc2", 0],
      },
      [2515] => { # 快楽のショータイム
        :word_1 => ["\\n<Alma Elma>Come on, it's showtime...♪", "arumaeruma_fc2", 0],
      },
      [9115] => { # 快楽の支配者
        :word_1 => ["\\n<Alma Elma>I will rule you...♪", "arumaeruma_fc2", 0],
      },
      [*3106..3115] => { # エレメンタル
        :word_1 => ["\\n<Alma Elma>The power of elemental...!", "arumaeruma_fc2", 0],
      },
      [3112] => { # 風の戯れ
        :word_1 => ["\\n<Alma Elma>Come now, let's dance with the wind...", "arumaeruma_fc2", 0],
      },
      [3113] => { # 疾風の極み
        :word_1 => ["\\n<Alma Elma>Let's dance with the wind...♪", "arumaeruma_fc2", 0],
      },
      [*3117..3118, 9782] => { # 深呼吸
        :word_1 => ["\\n<Alma Elma>Calm down, take a deep breath...", "arumaeruma_fc2", 0],
      },
      [3119, 3120] => { # 自己治療
        :word_1 => ["\\n<Alma Elma>Calm down, and use emergency treatment...", "arumaeruma_fc2", 0],
      },
      3121..3123 => { # 背水
        :word_1 => ["\\n<Alma Elma>Looks like I'm in trouble...", "arumaeruma_fc2", 0],
      },
      [3124, 3125] => { # バーサーカー化
        :word_1 => ["\\n<Alma Elma>I'm going to vent some frustration...", "arumaeruma_fc2", 0],
      },
      [*3126..3127, 9783] => { # ヒーロー変身
        :word_1 => ["\\n<Alma Elma>Transform into an ally of justice... Hey!", "arumaeruma_fc2", 0],
      },
      [3128, 9784] => { # 魔法少女変身
        :ct_pic => "ct_arumaeruma2",
        :ct_se => "wind10",
        :ct_type => :basic,
        :word_1 => ["\\n<Alma Elma>Henshin, Magical☆Alma♪", "arumaeruma_fc2", 0],
      },
      [3130] => { # 確保ホールド
        :word_1 => ["\\n<Alma Elma>Caught you♪", "arumaeruma_fc2", 0],
      },
      [3131] => { # 援軍要請
        :word_1 => ["\\n<Alma Elma>Heeeelp us♪", "arumaeruma_fc2", 0],
      },
      3132..3143 => { # ブレイク・インパクト
        :word_1 => ["\\n<Alma Elma>I'll break it...!", "arumaeruma_fc2", 0],
      },
      [3144, 3145, 9797] => { # 間歇泉
        :word_1 => ["\\n<Alma Elma>Intermittent spring, try taking a bath...?", "arumaeruma_fc2", 0],
      },
      [3146] => { # なだめる
        :word_1 => ["\\n<Alma Elma>Calm down now, fufu...", "arumaeruma_fc2", 0],
      },
      [3148] => { # 破廉恥盗み
        :word_1 => ["\\n<Alma Elma>Can I get your panties...?", "arumaeruma_fc2", 0],
      },
      [3149] => { # セクシービーム
        :word_1 => ["\\n<Alma Elma>Ufun♪ Sexy Beam ♡", "arumaeruma_fc2", 1],
      },
      [3150] => { # ピンクタイフーン
        :word_1 => ["\\n<Alma Elma>Ufun♪ Pink Typhoon♡", "arumaeruma_fc2", 1],
      },
      [9798] => { # ファンタスティックハリケーン
        :word_1 => ["\\n<Alma Elma>Uffun♪ Fantastic Hurricane♡", "arumaeruma_fc2", 1],
      },
      [3151] => { # ステージタイム
        :word_1 => ["\\n<Alma Elma>Now, it's my stage♪", "arumaeruma_fc2", 0],
      },
      [3153] => { # ハードジョブモード
        :word_1 => ["\\n<Alma Elma>I'm going to work hard♪", "arumaeruma_fc2", 0],
      },
      3277..3281 => { # ぱふぱふ
        :word_1 => ["\\n<Alma Elma>Puff puff, puff puff...", "arumaeruma_fc2", 0],
      },
      [4019] => { # 誘惑専用
        :word_y1 => ["\\n<Alma Elma>Fufu... Let me taste Luka-boy's semen...", "arumaeruma_fc2", 0],
      },
      [*3380..3464] => { # 装備武器
        :word_1 => ["\\n<Alma Elma>Let's see the power of this weapon...?", "arumaeruma_fc2", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Alma Elma>Time, stop!", "arumaeruma_fc2", 0],
      },
      1862..1865 => { # ヒーロー技・魔女
        :word_1 => ["\\n<Alma Elma>This is the power of the witch...!", "arumaeruma_fc2", 0],
      },
      [2426] => { # ブリッツクリーグ
        :word_1 => ["\\n<Alma Elma>...Blitzkrieg!!", "arumaeruma_fc2", 0],
      },
      [2457] => { # ブレイブウォール
        :word_1 => ["\\n<Alma Elma>Block \n, Brave Wall!", "arumaeruma_fc2", 0],
      },
      [3129] => { # 魔女変身
        :word_1 => ["\\n<Alma Elma>Should I hold a grudge...", "arumaeruma_fc2", 0],
      },
      [3152] => { # 聖杯の奇跡
        :word_1 => ["\\n<Alma Elma>The miracle of the Holy Grail...hehe.", "arumaeruma_fc2", 0],
      },
      [*9707..9726] => { # サイコ
        :word_1 => ["\\n<Alma Elma>Taste my aura...?", "arumaeruma_fc2", 0],
      },
      [9721] => { # サイコストリーム
        :word_1 => ["\\n<Alma Elma>Pleasure tide of telekinesis...Psycho Stream!", "arumaeruma_fc2", 0],
      },
      [9725] => { # サイコエントロピー
        :word_1 => ["\\n<Alma Elma>Spread the pleasure of chaos to the maximum...!", "arumaeruma_fc2", 0],
      },
      6071..6300 => { # 妖術
        :word_1 => ["\\n<Alma Elma>How about this kind of technique...?", "arumaeruma_fc2", 0],
      },
      [6085] => { # 肉体の解放
        :word_1 => ["\\n<Alma Elma>Sear the image of my body into your eyes...♪", "arumaeruma_fc2", 0],
      },
      [*9118..9122] => { # シールド攻撃
        :word_1 => ["\\n<Alma Elma>Ahaha...", "arumaeruma_fc2", 0],
      },
      [*9123..9130] => { # シールド防御
        :word_1 => ["\\n<Alma Elma>I will protect you...", "arumaeruma_fc2", 0],
      },
      [9131,9132] => { # シールドアッセンブル
        :word_1 => ["\\n<Alma Elma>Assemble!!", "arumaeruma_fc2", 0],
      },
      [9380] => { # ダブルアップ
        :word_1 => ["\\n<Alma Elma>double up!", "arumaeruma_fc2", 0],
      },
      [2129] => { # 行動予約
        :word_1 => ["\\n<Alma Elma>Next action, order!", "arumaeruma_fc2", 0],
      },
      [*9785..9792] => { # 収束・拡散
        :word_1 => ["\\n<Alma Elma>I will concentrate my power on one point...!", "arumaeruma_fc2", 0],
      },
      [*9759..9770] => { # カオス
        :word_1 => ["\\n<Alma Elma>■■■■■■■■■■■■■■■...", "arumaeruma_fc2", 0],
      },
      [4123] => { # ロマノステリ・アル
        :word_1 => ["\\n<Alma Elma>Fufu... Luka-boy's penis is delicious...♪", "arumaeruma_fc2", 0],
        :word_2 => ["\\n<Alma Elma>Your penis feels good, right?", "arumaeruma_fc2", 0],
        :word_3 => ["\\n<Alma Elma>Come on... pee in your mouth...♪", "arumaeruma_fc2", 0],
      },
      [4124] => { # ロマノステリ・エル
        :word_1 => ["\\n<Alma Elma>I'll make girls feel good with my mouth too...♪", "arumaeruma_fc2", 0],
        :word_2 => ["\\n<Alma Elma>Do you want me to cum in your mouth? Ufufu...", "arumaeruma_fc2", 0],
        :word_3 => ["\\n<Alma Elma>I'll lick the place that feels good...♪", "arumaeruma_fc2", 0],
      },
      [4125] => { # メロソフィ・ドーラ
        :word_1 => ["\\n<Alma Elma>Look, I'm going to make you cum with my breasts...♪", "arumaeruma_fc2", 0],
        :word_2 => ["\\n<Alma Elma>Succubus breasts feel good...♪", "arumaeruma_fc2", 0],
        :word_3 => ["\\n<Alma Elma>I will squeeze out the semen with my breasts...♪", "arumaeruma_fc2", 0],
      },
      [4364] => { # ハッスルダンス
        :word_1 => ["\\n<Alma Elma>That's it! Hustle! Hustle!", "arumaeruma_fc2", 0],
      },
    },
    21 => { # たまも
      [1, *3..13, 47, *53..58, 3500] => { # 攻撃
        :word_1 => ["\\n<Tamamo>That's right!", "tamamo_fc1", 0],
        :word_2 => ["\\n<Tamamo>Look!", "tamamo_fc1", 0],
        :word_3 => ["\\n<Tamamo>Hyaah!", "tamamo_fc1", 0],
      },
      [*901..912, *9001..9004] => { # 短剣技
        :word_1 => ["\\n<Tamamo>My knife hurts a little!", "tamamo_fc1", 0],
      },
      [*917..975, *9008..9025] => { # 剣技
        :word_1 => ["\\n<Tamamo>A single sword cut... Okay!", "tamamo_fc1", 0],
      },
      976..979 => { # 癒しの剣
        :word_1 => ["\\n<Tamamo>Healing sword, God's blessings!", "tamamo_fc1", 0],
      },
      [*985..1000, *9029..9037] => { # 尖剣技
        :word_1 => ["\\n<Tamamo>Poke it a lot!", "tamamo_fc1", 0],
      },
      [*1001..1003] => { # ノブレス・オブリージュ
        :word_1 => ["\\n<Tamamo>The pride of the fox tribe is in this blade!", "tamamo_fc1", 0],
      },
      [*1007..1031, *9041..9046] => { # 刀技
        :word_1 => ["\\n<Tamamo>A single sword cut... Okay!", "tamamo_fc1", 0],
      },
      1032..1037 => { # 刀技・自己強化
        :word_1 => ["\\n<Tamamo>By the pride of the white blade!", "tamamo_fc1", 0],
      },
      [1036] => { # 切腹
        :word_1 => ["\\n<Tamamo>I don't feel like it...", "tamamo_fc1", 0],
      },
      [*1041..1084, *9050..9059] => { # 槍技
        :word_1 => ["\\n<Tamamo>I'll skewer you with my spear!", "tamamo_fc1", 0],
      },
      1085..1088 => { # 槍技・回復補助
        :word_1 => ["\\n<Tamamo>Spear, make a miracle happen!", "tamamo_fc1", 0],
      },
      1089..1093 => { # 槍技・自己強化
        :word_1 => ["\\n<Tamamo>Spirit for the spear...!", "tamamo_fc1", 0],
      },
      [*1099..1117, *9063..9066] => { # 斧技
        :word_1 => ["\\n<Tamamo>Power is at full throttle! Hmph!", "tamamo_fc1", 0],
      },
      [1118] => { # 乱れ斧
        :word_1 => ["\\n<Tamamo>It's Maki-wari time!", "tamamo_fc1", 0],
      },
      [*1124..1150, *9070..9074] => { # 棍技
        :word_1 => ["\\n<Tamamo>Power is at full throttle! Hmph!", "tamamo_fc1", 0],
      },
      [*1156..1173, *9078..9083] => { # 鎌技
        :word_1 => ["\\n<Tamamo>Come on, let's invite you to die...!", "tamamo_fc1", 0],
      },
      1174..1176 => { # 鎌技・状態異常
        :word_1 => ["\\n<Tamamo>Don't be fooled by the magic power of the sickle!", "tamamo_fc1", 0],
      },
      [*1182..1224, *9087..9101] => { # 弓技
        :word_1 => ["\\n<Tamamo>Aim well... Hmph!", "tamamo_fc1", 0],
      },
      [1225, 1226] => { # ヒールアロー
        :word_1 => ["\\n<Tamamo>Rain down, healing arrows!", "tamamo_fc1", 0],
      },
      [*1232..1251, *9105..9114] => { # 鞭技
        :word_1 => ["\\n<Tamamo>Now, it's time for Oshioki!", "tamamo_fc1", 0],
      },
      1252..1255 => { # サーバント
        :word_1 => ["\\n<Tamamo>Come, servant!", "tamamo_fc1", 0],
      },
      1260..1280 => { # 投擲技
        :word_1 => ["\\n<Tamamo>So, go get it!", "tamamo_fc1", 0],
      },
      1282..1306 => { # 鉄球技
        :word_1 => ["\\n<Tamamo>Power is at full throttle! Hmph!", "tamamo_fc1", 0],
      },
      [*1309..1335, *9137..9139] => { # 扇技
        :word_1 => ["\\n<Tamamo>I wonder if it's time to dance...♪", "tamamo_fc1", 0],
      },
      [1309] => { # 重ね扇
        :word_1 => ["\\n<Tamamo>A momentary slash...a stacked fan!", "tamamo_fc1", 0],
      },
      [1311] => { # 真空扇
        :word_1 => ["\\n<Tamamo>rolls up, the blade of the wind! Vacuum fan!", "tamamo_fc1", 0],
      },
      [1312] => { # 狐月扇
        :word_1 => ["\\n<Tamamo>Shatter the earth... Fox Moon Fan!", "tamamo_fc1", 0],
      },
      [1313] => { # 狐月乱扇
        :word_1 => ["\\n<Tamamo>Dance, the turbulent fan of the earth! Kitsunetsuki Ransen!", "tamamo_fc1", 0],
      },
      [1314] => { # 扇舞
        :word_1 => ["\\n<Tamamo>The waving wind...fan dance!", "tamamo_fc1", 0],
      },
      [1315] => { # 扇嵐
        :word_1 => ["\\n<Tamamo>Falling cherry blossoms... Fan storm!", "tamamo_fc1", 0],
      },
      [1316] => { # 花鳥風月
        :word_1 => ["\\n<Tamamo>Maeya Tori, Uageya Full Moon...Kachofuugetsu!", "tamamo_fc1", 0],
      },
      [1325] => { # 感電扇
        :word_1 => ["\\n<Tamamo>Numbing shock... electric shock fan!", "tamamo_fc1", 0],
      },
      [1326] => { # 召雷扇
        :word_1 => ["\\n<Tamamo>Summon the thunder god... Summon the thunder fan!", "tamamo_fc1", 0],
      },
      [1327] => { # 呪怨扇
        :word_1 => ["\\n<Tamamo>The arm of the underworld that invites you into darkness... Ju-on Fan!", "tamamo_fc1", 0],
      },
      [1328] => { # 落葉の舞い
        :word_1 => ["\\n<Tamamo>Falling leaves, autumn sky...", "tamamo_fc1", 0],
      },
      [1329] => { # 九絶胡蝶扇
        :word_1 => ["\\n<Tamamo>The ghostly dance of butterflies... Kuzetsu butterfly fan!", "tamamo_fc1", 0],
      },
      [1331] => { # 銀河連扇
        :word_1 => ["\\n<Tamamo>Thousands of light years, the brightness of the galaxy...Galaxy Rensen!", "tamamo_fc1", 0],
      },
      [1333] => { # 零尾虚空扇
        :word_1 => ["\\n<Tamamo>Invisible mystery... Zero-tailed sky fan!", "tamamo_fc1", 0],
      },
      [9139] => { # 九星闇扇
        :word_1 => ["\\n<Tamamo>Nine stars, dance in the darkness... Nine Star Dark Fan!", "tamamo_fc1", 0],
      },
      [*1338..1366, *9143..9151] => { # 銃技
        :word_1 => ["\\n<Tamamo>Aim well... Hmph!", "tamamo_fc1", 0],
      },
      [1367, 1368] => { # 回復弾
        :word_1 => ["\\n<Tamamo>It's a healing bullet!", "tamamo_fc1", 0],
      },
      1374..1395 => { # 多武器技
        :word_1 => ["\\n<Tamamo>Come on, let's carve it!", "tamamo_fc1", 0],
      },
      [1393, 1394] => { # セカンドシフト
        :word_1 => ["\\n<Tamamo>Let me show you the dance of the blade...!", "tamamo_fc1", 0],
      },
      [*1400..1438, *9156..9173] => { # 格闘
        :word_1 => ["\\n<Tamamo>Tamamo's martial arts...that's it!", "tamamo_fc1", 0],
      },
      [*1439..1445, 9174] => { # 格闘・快楽
        :word_1 => ["\\n<Tamamo>Come on, let's make you happy...", "tamamo_fc1", 2],
      },
      1446..1451 => { # チャクラ
        :word_1 => ["\\n<Tamamo>Heal the heavenly veins... Chakra!", "tamamo_fc1", 0],
      },
      1452..1454 => { # 属性の拳
        :word_1 => ["\\n<Tamamo>Demon vein, stay in your fist!", "tamamo_fc1", 0],
      },
      [*1460..1468, *9178..9184,8881,8882, *10001..10006] => { # 白魔法・回復
        :word_1 => ["\\n<Tamamo>White torrent, heal your injured body!", "tamamo_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Tamamo>White torrent, destroy the darkness!", "tamamo_fc1", 0],
      },
      [1460] => { # ヒール
        :word_1 => ["\\n<Tamamo>Peaceful wind of life, heal your injured body! \nHeal!", "tamamo_fc1", 0],
      },
      [1461] => { # メガヒール
        :word_1 => ["\\n<Tamamo>Bring the reassuring vibrations of life, the fierce breath! \n Mega Heal!", "tamamo_fc1", 0],
      },
      [1462] => { # オールヒール
        :word_1 => ["\\n<Tamamo>Peaceful wind of life, heal us with your arms! \nAll Heal!", "tamamo_fc1", 0],
      },
      [1463] => { # オールメガヒール
        :word_1 => ["\\n<Tamamo>The reassuring vibrations of life, become a storm of blessings and blow up! \n All Mega Heal!", "tamamo_fc1", 0],
      },
      [1464] => { # キュア
        :word_1 => ["\\n<Tamamo>The highest wind of peace, bring peace to your disturbed body! \n Cure!", "tamamo_fc1", 0],
      },
      [1465] => { # オールキュア
        :word_1 => ["\\n<Tamamo>Lead to peace with the highest wind of peace and storm of blessings! \n All Cure!", "tamamo_fc1", 0],
      },
      [1466] => { # レイズ
        :word_1 => ["\\n<Tamamo>The wave of a strong soul, bring life once again! \n Raise!", "tamamo_fc1", 0],
      },
      [1467] => { # メガレイズ
        :word_1 => ["\\n<Tamamo>My wandering soul, defy logic and move forward again! \n Mega raise!", "tamamo_fc1", 0],
      },
      [1468] => { # オールメガレイズ
        :word_1 => ["\\n<Tamamo>A thousand souls lost in flux, defy logic and make a comeback! \n All Mega Raise!", "tamamo_fc1", 0],
      },
      [9179,8882] => { # ディレイヒール
        :word_1 => ["\\n<Tamamo>The breath of healing that comes late...Delay Heal!", "tamamo_fc1", 0],
      },
      [9178,8881] => { # ラピッドヒール
        :word_1 => ["\\n<Tamamo>Storm, a pioneering miracle...Rapid Heal!", "tamamo_fc1", 0],
      },
      [9182] => { # ハイレイズ
        :word_1 => ["\\n<Tamamo>My wandering soul, have a vibrant and fulfilling comeback! \n High raise!", "tamamo_fc1", 0],
      },
      [9183] => { # リレイズ
        :word_1 => ["\\n<Tamamo>Breath of flux, bring reincarnation at the end! \n Reraise!", "tamamo_fc1", 0],
      },
      [*1469..1472, *9185..9189] => { # 白魔法・攻撃
        :word_1 => ["\\n<Tamamo>White torrent, destroy the darkness!", "tamamo_fc1", 0],
      },
      [1469] => { # ホーリーアロー
        :word_1 => ["\\n<Tamamo>Holy light, penetrate the darkness and defeat evil! \n Holy Arrow!", "tamamo_fc1", 0],
      },
      [1470] => { # ニルヴァーナ
        :word_1 => ["\\n<Tamamo>The white torrent that leads to Nirvana, show us unwavering justice! \nMy name is referee! Nirvana!", "tamamo_fc1", 0],
      },
      [9185] => { # エターナル
        :word_1 => ["\\n<Tamamo>Eternal waves, bring the infallibility of dawn! \n Eternal!", "tamamo_fc1", 0],
      },
      [9186] => { # マグニフィセントワン
        :word_1 => ["\\n<Tamamo>Know the wrath of God... Magnificent One!", "tamamo_fc1", 0],
      },
      [9187] => { # アヴェマリア
        :word_1 => ["\\n<Tamamo>Eternity and reincarnation, blessing and infallibility... \n Eternal gospel, Hail Mary!", "tamamo_fc1", 0],
      },
      [1473] => { # ヘブン
        :word_1 => ["\\n<Tamamo>Immortal high will, bring evil to God's mercy! \n Heaven!", "tamamo_fc1", 0],
      },
      [1474,9190] => { # オールヘブン
        :word_1 => ["\\n<Tamamo>Immortal high will, bring the swarms of evil to God's mercy! \n All Heaven!", "tamamo_fc1", 0],
      },
      [*1475..1485, 10007] => { # 白魔法・補助
        :word_1 => ["\\n<Tamamo>White torrent, give me power!", "tamamo_fc1", 0],
      },
      [1475] => { # アタック
        :word_1 => ["\\n<Tamamo>White torrent, become a breath of power and bring blessings! \n Attack!", "tamamo_fc1", 0],
      },
      [1476] => { # マジック
        :word_1 => ["\\n<Tamamo>White torrent, become the breath of evil and bring blessings! \nMagic!", "tamamo_fc1", 0],
      },
      [1477] => { # ガード
        :word_1 => ["\\n<Tamamo>White torrent, become solid armor and bring protection! \n Guard!", "tamamo_fc1", 0],
      },
      [1478] => { # マインド
        :word_1 => ["\\n<Tamamo>White torrent, become a wall to repel demons and bring protection! \n Mind!", "tamamo_fc1", 0],
      },
      [1479] => { # テクニック
        :word_1 => ["\\n<Tamamo>White torrent, the height of skill is here! \n Technique!", "tamamo_fc1", 0],
      },
      [1480] => { # オールアタック
        :word_1 => ["\\n<Tamamo>White torrent, become a breath of power and benefit us! \n All attack!", "tamamo_fc1", 0],
      },
      [1481] => { # オールマジック
        :word_1 => ["\\n<Tamamo>White torrent, become the breath of demons and benefit us! \n All magic!", "tamamo_fc1", 0],
      },
      [1482] => { # オールガード
        :word_1 => ["\\n<Tamamo>White torrent, become a solid armor and protect us! \n All guard!", "tamamo_fc1", 0],
      },
      [1483] => { # オールマインド
        :word_1 => ["\\n<Tamamo>White torrent, protect us by becoming a wall to repel demons! \n All Mind!", "tamamo_fc1", 0],
      },
      [1484] => { # オールテクニック
        :word_1 => ["\\n<Tamamo>White torrent, show us the height of your skill! \n All techniques!", "tamamo_fc1", 0],
      },
      [1485] => { # ジルオール
        :word_1 => ["\\n<Tamamo>A torrent of healing, bring about a great miracle! \n Mercy and protection! Jill all!", "tamamo_fc1", 0],
      },
      [*1486..1488, 1491..1493] => { # 白魔法・防護
        :word_1 => ["\\n<Tamamo>White torrent, prevent evil power!", "tamamo_fc1", 0],
      },
      [1486] => { # マジックカーテン
        :word_1 => ["\\n<Tamamo>The magical reincarnation that goes around, give us blessings beyond reason! \n Magic curtain!", "tamamo_fc1", 0],
      },
      [1487] => { # マジックウォール
        :word_1 => ["\\n<Tamamo>Magical wall, give us impregnable protection! \nMagic Wall!", "tamamo_fc1", 0],
      },
      [9184] => { # ブレイブ
        :word_1 => ["\\n<Tamamo>White torrent, bring about a peaceful and youthful life! \nBrave!", "tamamo_fc1", 0],
      },
      [*1489..1490, 1493] => { # キャンセル
        :word_1 => ["\\n<Tamamo>A white torrent that hates evil, protects the devil and exorcises the wall! \n Cancelled!", "tamamo_fc1", 0],
      },
      [1489] => { # キャンセル
        :word_1 => ["\\n<Tamamo>A white wave that hates evil, protects evil and exorcises walls! \n Cancelled!", "tamamo_fc1", 0],
      },
      [1493] => { # オールクリア
        :word_1 => ["\\n<Tamamo>White wave, cancel out the evil wave that weakens you! \n All clear!", "tamamo_fc1", 0],
      },
      [10001] => { # オーバーヒール
        :word_1 => ["\\n<Tamamo>Beyond the limits, miraculous waves, bring great salvation! \n Over Heal!", "tamamo_fc1", 0],
      },
      [10002] => { # オーバーキュア
        :word_1 => ["\\n<Tamamo>Save the world and bring miraculous winds and eternal blessings! \n Overcure!", "tamamo_fc1", 0],
      },
      [10003] => { # アンチェインド
        :word_1 => ["\\n<Tamamo>Miraculous light, release yourself from the shackles of bondage! \n Unchained!", "tamamo_fc1", 0],
      },
      [10004] => { # オーバーレイズ
        :word_1 => ["\\n<Tamamo>A thousand souls lost in flux, a miraculous second coming! \nOverraise!", "tamamo_fc1", 0],
      },
      [10005] => { # オールリレイズ
        :word_1 => ["\\n<Tamamo>Breath of flux, bring reincarnation at the end! \n All re-raise!", "tamamo_fc1", 0],
      },
      [10006] => { # オールブレイブ
        :word_1 => ["\\n<Tamamo>White torrent, bring calm and youthful life! \n All Brave!", "tamamo_fc1", 0],
      },
      [10007] => { # オーバージルオール
        :word_1 => ["\\n<Tamamo>A torrent of healing, bring about a great miracle! \n Ultimate protection! Overjill all!", "tamamo_fc1", 0],
      },
      [*1496..1531, *9192..9218] => { # 黒魔法・攻撃
        :word_1 => ["\\n<Tamamo>Black torrent, obey my orders!", "tamamo_fc1", 0],
      },
      [1496] => { # ファイア
        :word_1 => ["\\n<Tamamo>Angry flame, show your power! \n Fire!", "tamamo_fc1", 0],
      },
      [1497] => { # メガファイア
        :word_1 => ["\\n<Tamamo>The angry flame turns into a whirlpool and mowing it down! \n Mega fire!", "tamamo_fc1", 0],
      },
      [1498] => { # ファイアテンペスト
        :word_1 => ["\\n<Tamamo>A vortex of flames, raging in anger! \n Fire Tempest!", "tamamo_fc1", 0],
      },
      [1499] => { # ブレイズ
        :word_1 => ["\\n<Tamamo>Breath of hellfire, bring a scorching nightmare! \n Blaze!", "tamamo_fc1", 0],
      },
      [1500] => { # オメガブレイズ
        :word_1 => ["\\n<Tamamo>According to the pact, come, hellfire of nightmare! \n Burn it to ashes! Omega Blaze!", "tamamo_fc1", 0],
      },
      [1501] => { # プロミネンス
        :word_1 => ["\\n<Tamamo>The original red invites infinite regression! \n The scorching heat of the end! Prominence!", "tamamo_fc1", 0],
      },
      [1502] => { # ブリザード
        :word_1 => ["\\n<Tamamo>Freezing ice, bring the extreme cold! \n Blizzard!", "tamamo_fc1", 0],
      },
      [1503] => { # メガブリザード
        :word_1 => ["\\n<Tamamo>Freezing ice, bring destruction with a cold storm! \n Mega blizzard!", "tamamo_fc1", 0],
      },
      [1504] => { # ブリザードストーム
        :word_1 => ["\\n<Tamamo>Cold whirlpool, show destruction with your endless blade! \n Blizzard Storm!", "tamamo_fc1", 0],
      },
      [1505] => { # フロスト
        :word_1 => ["\\n<Tamamo>The cold coffin does not freeze even the cries of grief! \n Frost!", "tamamo_fc1", 0],
      },
      [1506] => { # シグマフロスト
        :word_1 => ["\\n<Tamamo>A torrent of zero, a frozen moment in the blue world... \n Lifeless silence! Sigma Frost!", "tamamo_fc1", 0],
      },
      [1507] => { # アイスエイジ
        :word_1 => ["\\n<Tamamo>The blue root is carved into the Apocalypse pole! Zero degree of \n origin, Ice Age!", "tamamo_fc1", 0],
      },
      [9194] => { # クァンタゾーン
        :word_1 => ["\\n<Tamamo>Ultra-fine blink, bring about the destruction of condensation! \nQuantazone!", "tamamo_fc1", 0],
      },
      [9196] => { # イオンブラスト
        :word_1 => ["\\n<Tamamo>Look at the way the floating molecules scatter! \n Ion Blast!", "tamamo_fc1", 0],
      },
      [9206] => { # オーバーカーズ
        :word_1 => ["\\n<Tamamo>Cursed Queen, open up taboos! \n Black disaster, OverCurse!", "tamamo_fc1", 0],
      },
      [1508] => { # サンダー
        :word_1 => ["\\n<Tamamo>Pure thunder, bring judgment! \n Thunder!", "tamamo_fc1", 0],
      },
      [1509] => { # メガサンダー
        :word_1 => ["\\n<Tamamo>Pure thunder, exorcise evil and rain down on it! \n Mega Thunder!", "tamamo_fc1", 0],
      },
      [1510] => { # サンダーハリケーン
        :word_1 => ["\\n<Tamamo>Raging thunder, split the sky and roar! \n Thunder Hurricane!", "tamamo_fc1", 0],
      },
      [1511] => { # スパーク
        :word_1 => ["\\n<Tamamo>Hammer of lightning, defeat evil and reduce it to ashes! \n Spark!", "tamamo_fc1", 0],
      },
      [1512] => { # ラムダスパーク
        :word_1 => ["\\n<Tamamo>Hammer of judgment, hell of thunder returned to dust... \n Show cause and effect! Lambda Spark!", "tamamo_fc1", 0],
      },
      [1513] => { # ライトニング
        :word_1 => ["\\n<Tamamo>The original brilliance shows the reincarnation of dust! \n Apocalyptic thunder! Lightning!", "tamamo_fc1", 0],
      },
      [9205] => { # トリニティ
        :word_1 => ["\\n<Tamamo>Play the dance of flame, ice, and thunder! \n Trinity!", "tamamo_fc1", 0],
      },
      [9192] => { # ガンマバースト
        :word_1 => ["\\n<Tamamo>Bring on the afterglow of creation, the scorching heat of the primordial! \n Gamma burst!", "tamamo_fc1", 0],
      },
      [9207] => { # アポカリプス
        :word_1 => ["\\n<Tamamo>Hear the footsteps of the end...Apocalypse!", "tamamo_fc1", 0],
      },
      [1517] => { # アース
        :word_1 => ["\\n<Tamamo>Mighty earth, be violent and show your anger! \n Earth!", "tamamo_fc1", 0],
      },
      [1518] => { # クェイク
        :word_1 => ["\\n<Tamamo>Angry star, tremble and rage! \n Quake!", "tamamo_fc1", 0],
      },
      [1519] => { # ゼータクェイク
        :word_1 => ["\\n<Tamamo>Primordial Taiji, eating is the foundation of Goroku! \n Carve your wrath! Zetaquake!", "tamamo_fc1", 0],
      },
      [9200] => { # エクスクェイク
        :word_1 => ["\\n<Tamamo>The primordial Taiji leads to absolute nothingness! \n Master your anger! Exquake!", "tamamo_fc1", 0],
      },
      [9201] => { # アンバーガイア
        :word_1 => ["\\n<Tamamo>Hear the angry roar of the earth... Amber Gaia!", "tamamo_fc1", 0],
      },
      [9210] => { # オーバーロード
        :word_1 => ["\\n<Tamamo>This magical power, burn it all down... \n Disappear into dust, Overlord!", "tamamo_fc1", 0],
      },
      [9204] => { # カオスリバレート
        :word_1 => ["\\n<Tamamo>The source of ultimate magic... Chaos Revelation!", "tamamo_fc1", 0],
      },
      [1530] => { # ドレイン
        :word_1 => ["\\n<Tamamo>Dedicate the wave of life to me! \n Drain!", "tamamo_fc1", 0],
      },
      [1531] => { # マドレイン
        :word_1 => ["\\n<Tamamo>A torrent of magic, offer it to me! \n Madeleine!", "tamamo_fc1", 0],
      },
      [1532, 1533] => { # デス
        :word_1 => ["\\n<Tamamo>The scythe of the god of death that reaps life, invite its soul to the underworld! \n Death!", "tamamo_fc1", 0],
      },
      [1532] => { # デス
        :word_1 => ["\\n<Tamamo>The scythe of the god of death that reaps life, invite its soul to the underworld! \n Death!", "tamamo_fc1", 0],
      },
      [1533] => { # オールデス
        :word_1 => ["\\n<Tamamo>The scythe of the god of death that reaps life, invite the swarm of souls to the underworld! \n All Death!", "tamamo_fc1", 0],
      },
      1534..1540 => { # 黒魔法・状態異常
        :word_1 => ["\\n<Tamamo>Black torrent, obey my orders!", "tamamo_fc1", 0],
      },
      [1534] => { # ポイズン
        :word_1 => ["\\n<Tamamo>Risk the poisonous stream! \n Poison!", "tamamo_fc1", 0],
      },
      [1535] => { # ブラインド
        :word_1 => ["\\n<Tamamo>Darkness of the night, steal the light! \n Blind!", "tamamo_fc1", 0],
      },
      [1536] => { # サイレンス
        :word_1 => ["\\n<Tamamo>Refuse magic and bring silence! \n Silence!", "tamamo_fc1", 0],
      },
      [1537] => { # コンフューズ
        :word_1 => ["\\n<Tamamo>My heart is disturbed by the floating waves, and I don't even know where the blade is headed! \n Confuse!", "tamamo_fc1", 0],
      },
      [1538] => { # スリープ
        :word_1 => ["\\n<Tamamo>Daydream, a butterfly invites you to close your consciousness! \n Sleep!", "tamamo_fc1", 0],
      },
      [1539] => { # パラライズ
        :word_1 => ["\\n<Tamamo>Numb arms, know that they are not vessels of freedom! \n Paralyze!", "tamamo_fc1", 0],
      },
      [1541] => { # ヒールタイフーン
        :word_1 => ["\\n<Tamamo>The peaceful wind of life, blow into a storm of blessings! \nHeal Typhoon!", "tamamo_fc1", 0],
      },
      [1523] => { # カーズ
        :word_1 => ["\\n<Tamamo>Mist of darkness, bring great disaster! Curse!", "tamamo_fc1", 0],
      },
      [*1547..1558, *9222..9226] => { # 時魔法・状態異常
        :word_1 => ["\\n<Tamamo>The torrent of time at \n, carve your steps according to my will!", "tamamo_fc1", 0],
      },
      [1547] => { # スロウ
        :word_1 => ["\\n<Tamamo>The muddy stream at \n, slow down your steps and rest in peace! \n Slow!", "tamamo_fc1", 0],
      },
      [1548] => { # オールスロウ
        :word_1 => ["\\n<Tamamo>The muddy stream at \n, slow down your steps and rest in peace! \n All slow!", "tamamo_fc1", 0],
      },
      [1549] => { # クィック
        :word_1 => ["\\n<Tamamo>The muddy waters of time, quicken your steps and keep your heart beating! \nQuick!", "tamamo_fc1", 0],
      },
      [1550] => { # オールクィック
        :word_1 => ["\\n<Tamamo>The muddy waters of \n, quicken your steps and keep your heart beating! \n All quick!", "tamamo_fc1", 0],
      },
      [1551] => { # ストップ
        :word_1 => ["\\n<Tamamo>Block and stop the truth, Time of Zero! \n Stop!", "tamamo_fc1", 0],
      },
      [1552] => { # オールストップ
        :word_1 => ["\\n<Tamamo>Block and stop the truth, Time of Zero! \n All stop!", "tamamo_fc1", 0],
      },
      [1553] => { # フォシル
        :word_1 => ["\\n<Tamamo>The muddy waters of \n, hurry up and rot away! \n Fossil!", "tamamo_fc1", 0],
      },
      [1555] => { # リゾーン
        :word_1 => ["\\n<Tamamo>Gate of time, open, arms of another world! \n Rezone!", "tamamo_fc1", 0],
      },
      [1557] => { # グラビティ
        :word_1 => ["\\n<Tamamo>Become the curse of gravity and crush your body! \n Gravidi!", "tamamo_fc1", 0],
      },
      [1558] => { # ハイグラビティ
        :word_1 => ["\\n<Tamamo>Let the curse of gravity become a hammer and crush it! \n Hi Gravidi!", "tamamo_fc1", 0],
      },
      [9226] => { # オーバーグラビディ
        :word_1 => ["\\n<Tamamo>The curse of gravity, crush both light and darkness! \nThe pinnacle of crushing, Overgravidy!", "tamamo_fc1", 0],
      },
      [9223] => { # オーバークイック
        :word_1 => ["\\n<Tamamo>The muddy stream of \n time, carve the ultimate heartbeat! \n Overquick!", "tamamo_fc1", 0],
      },
      [9222] => { # オーバースロウ
        :word_1 => ["\\n<Tamamo>Stay in the ultimate calm in the muddy stream at \n! \n Overslow!", "tamamo_fc1", 0],
      },
      [9224] => { # セカンドアクト
        :word_1 => ["\\n<Tamamo>The muddy waters of \n, the ultimate protection for your next life! \n Second act!", "tamamo_fc1", 0],
      },
      [9225] => { # リライフ
        :word_1 => ["\\n<Tamamo>The muddy stream of time, speed up the heartbeat of life! Relife!", "tamamo_fc1", 0],
      },
      [*1559..1563, *9227..9240] => { # 時魔法・攻撃
        :word_1 => ["\\n<Tamamo>Torrent of time, distort time and space and bring destruction!", "tamamo_fc1", 0],
      },
      [1559] => { # コメット
        :word_1 => ["\\n<Tamamo>The door of the stars is about to open, crush the earth and rain down! \n Comet!", "tamamo_fc1", 0],
      },
      [1560] => { # メテオ
        :word_1 => ["\\n<Tamamo>The galactic messenger who guides destruction comes from heaven, the hour of disaster! \n Return to the sky! Meteor!", "tamamo_fc1", 0],
      },
      [1563] => { # アーク
        :word_1 => ["\\n<Tamamo>Disturbed and crazy, the tide of time... Ark!", "tamamo_fc1", 0],
      },
      [9227] => { # リピートメテオ
        :word_1 => ["\\n<Tamamo>Calamity from heaven, come upon the cycle of time! \nRepeat meteorite, repeat meteorite!", "tamamo_fc1", 0],
      },
      [9228] => { # コメットレイン
        :word_1 => ["\\n<Tamamo>The star door will open, crush the earth and rain down! \n Comet Rain!", "tamamo_fc1", 0],
      },
      [9233] => { # オーバーアーク
        :word_1 => ["\\n<Tamamo>The tide at \n is disturbed and comes to an end! \n The flow of destruction, Overark!", "tamamo_fc1", 0],
      },
      [9230] => { # ギャラクシー
        :word_1 => ["\\n<Tamamo>Swirl, the breath of the deep galaxy! Galaxy!", "tamamo_fc1", 0],
      },
      [9234] => { # サンスフィア
        :word_1 => ["\\n<Tamamo>Burn up the infinite sun! Sunsphere!", "tamamo_fc1", 0],
      },
      1564..1568 => { # 時魔法・時間停止
        :word_1 => ["\\n<Tamamo>It's time, stop!", "tamamo_fc1", 0],
      },
      [*1633..1650, *9268..9285, 10061] => { # 聖技・攻撃
        :word_1 => ["\\n<Tamamo>Holy light, dispel the darkness!", "tamamo_fc1", 0],
      },
      [*1651..1659, *9286..9288] => { # 聖技・快楽
        :word_1 => ["\\n<Tamamo>Come on, let's make you happy...", "tamamo_fc1", 2],
      },
      [*1660..1665, 9289, 9293] => { # 聖技・回復
        :word_1 => ["\\n<Tamamo>Holy light, bring healing!", "tamamo_fc1", 0],
      },
      [1666, 9290] => { # 聖者の自爆
        :word_1 => ["\\n<Tamamo>Dedicate your life and dispel the darkness!", "tamamo_fc1", 0],
      },
      [1667] => { # エインヘリアル
        :word_1 => ["\\n<Tamamo>The warrior's soul breathes life again...!", "tamamo_fc1", 0],
      },
      [1668, 1669] => { # 夢幻天舞・堕天舞踏
        :word_1 => ["\\n<Tamamo>Like an angel, fluttering...", "tamamo_fc1", 0],
      },
      [1670, 1671] => { # 瞑想
        :word_1 => ["\\n<Tamamo>....................", "tamamo_fc1", 0],
      },
      [*1674..1694, *9294..9298, 10062] => { # 闇技・攻撃
        :word_1 => ["\\n<Tamamo>Blow away the darkness!", "tamamo_fc1", 0],
      },
      [9299, 9300] => { # 闇技・快楽
        :word_1 => ["\\n<Tamamo>Come on, let's make you happy...", "tamamo_fc1", 2],
      },
      1698..1718 => { # 魔法剣
        :word_1 => ["\\n<Tamamo>The power of magic resides in the sword!", "tamamo_fc1", 0],
      },
      [1716, 1717] => { # 魔法剣・防護
        :word_1 => ["\\n<Tamamo>Deploy \n, magical protective wall!", "tamamo_fc1", 0],
      },
      [*1723..1741, *9304..9315] => { # 陰陽
        :word_1 => ["\\n<Tamamo>The sign of Yin and Yang, let me know the reason!", "tamamo_fc1", 0],
      },
      [1723] => { # 陰陽・風暗符
        :word_1 => ["\\n<Tamamo>If you are in trouble, you are in trouble, if you are in trouble, you are in trouble! \n Receive the wind curse, wind code!", "tamamo_fc1", 0],
      },
      [1724] => { # 陰陽・土黙符
        :word_1 => ["\\n<Tamamo>The dragon snake's tomb is silent on the ground! \n Receive the earth curse, earth silence sign!", "tamamo_fc1", 0],
      },
      [1725] => { # 陰陽・水淀符
        :word_1 => ["\\n<Tamamo>Flatten the tide and move away from the muddy current! \n Receive the water curse, water stop sign!", "tamamo_fc1", 0],
      },
      [1726] => { # 陰陽・光吸符
        :word_1 => ["\\n<Tamamo>The light of heaven and earth, follow the alliance and surrender the beat of the drum! \n Light up the dark night, light absorber!", "tamamo_fc1", 0],
      },
      [1727] => { # 陰陽・炎乱唱
        :word_1 => ["\\n<Tamamo>A great calamity of Yin and Yang, make it a roaring feast! \n Receive the flame curse...flame chant!", "tamamo_fc1", 0],
      },
      [1728] => { # 陰陽・氷夢唱
        :word_1 => ["\\n<Tamamo>Winter day is frozen, like a big dream! \n Receive the ice curse... Ice dream chant!", "tamamo_fc1", 0],
      },
      [1729] => { # 陰陽・雷痺唱
        :word_1 => ["\\n<Tamamo>Tendou is the fierce lightning that defeats violence! \n Receive the thunder curse...Lightning paralysis chant!", "tamamo_fc1", 0],
      },
      [1730] => { # 陰陽・闇貪唱
        :word_1 => ["\\n<Tamamo>If Yin and Yang intersect, heaven and earth will match! \nBe swallowed up by black...Darkness chants!", "tamamo_fc1", 0],
      },
      [1734] => { # 陰陽・狐の嫁入り
        :word_1 => ["\\n<Tamamo>Fox Shunraku looks like Togen! The fox's marriage!", "tamamo_fc1", 0],
      },
      [1735] => { # 陰陽・狐嵐
        :word_1 => ["\\n<Tamamo>Autumn wind falling leaves, same as dust in front of the wind! \nFox Arashi, mowed down in a single breeze!", "tamamo_fc1", 0],
      },
      [1736] => { # 陰陽・朧月夜
        :word_1 => ["\\n<Tamamo>A wandering journey, a single dream... \n A butterfly's slumber, a hazy moonlit night!", "tamamo_fc1", 0],
      },
      [1737] => { # 陰陽・騒月
        :word_1 => ["\\n<Tamamo>The blood of the fox that makes noise in May falls red on the silent earth! \n Ooma ga time! Noisy moon!", "tamamo_fc1", 0],
      },
      [1738] => { # 陰陽・畏月
        :word_1 => ["\\n<Tamamo>The great elephant, the intangible, rules the trigram of all things! \n Look up in awe! Awe moon!", "tamamo_fc1", 0],
      },
      [1739] => { # 陰陽・月詠
        :word_1 => ["\\n<Tamamo>Listen to the song of the moon... Yin-Yang/Tsukuyomi!", "tamamo_fc1", 0],
      },
      [9315] => { # 陰陽・傾世塵吼
        :word_1 => ["\\n<Tamamo>Shatter, O earth... Yin-Yang, tilting world!", "tamamo_fc1", 0],
      },
      [9308] => { # 陰陽・傾世元禳
        :word_1 => ["\\n<Tamamo>Drown in the kindness of the earth...Yin-Yang, Reverse World Genrei!", "tamamo_fc1", 0],
      },
      [1740] => { # 陰陽・魔祓陣
        :word_1 => ["\\n<Tamamo>....................", "tamamo_fc1", 0],
      },
      [1741] => { # 陰陽・魔祓陣（発動）
        :word_1 => ["\\n<Tamamo>The law of exorcism, the prison of rebellion! \nRecognize your retribution, Nine Souls Exorcism Team!", "tamamo_fc1", 0],
      },
      [9310] => { # 陰陽外行・万祓陣（発動）
        :word_1 => ["\\n<Tamamo>The law of exorcism, the prison of rebellion! \n Realize your retribution, all exorcisms of all souls!", "tamamo_fc1", 0],
      },
      [9312] => { # 陰陽外行・天地人
        :word_1 => ["\\n<Tamamo>Heaven, earth, and humanity, benefit from the harmony of Yin and Yang! \n Yin and Yang go out, Tenchijin!", "tamamo_fc1", 0],
      },
      [9304] => { # 陰陽外行・炎水陣
        :word_1 => ["\\n<Tamamo>A party of roaring heat, compete in the muddy waters! \n Come with me, Yin-Yang Outing, Ensuijin!", "tamamo_fc1", 0],
      },
      [9305] => { # 陰陽外行・氷風陣
        :word_1 => ["\\n<Tamamo>Freezing on winter days, if it changes, we will be in trouble! \n Come with me, Yin-Yang Outing, Hyofujin!", "tamamo_fc1", 0],
      },
      [9306] => { # 陰陽外行・雷土陣
        :word_1 => ["\\n<Tamamo>A fierce lightning bolt and a roaring dragon snake will defeat the violence! \n Come with me, Yin-Yang Outing, Raidojin!", "tamamo_fc1", 0],
      },
      [9311] => { # 陰陽外行・星ノ諱
        :word_1 => ["\\n<Tamamo>Space star, respected and despised is the hour of destruction! \n Yin-Yang goes out, Hoshinomata!", "tamamo_fc1", 0],
      },
      [9309] => { # 陰陽外行・万祓陣
        :word_1 => ["\\n<Tamamo>....................", "tamamo_fc1", 0],
      },
      [9313] => { # 陰陽極行・神ノ理
        :word_1 => ["\\n<Tamamo>God's principle leads to all things...Yin-Yang polarity, God's principle!", "tamamo_fc1", 0],
      },
      [1742, 9316] => { # 陰陽・回復
        :word_1 => ["\\n<Tamamo>A piece of life, sending it is life! \nCreate the slightest...Singing of life!", "tamamo_fc1", 0],
      },
      [1742] => { # 陰陽・命活唱
        :word_1 => ["\\n<Tamamo>A piece of life, sending it is life! \nCreate the slightest...Singing of life!", "tamamo_fc1", 0],
      },
      [9316] => { # 陰陽・究活唱
        :word_1 => ["\\n<Tamamo>One piece of life, mastering it is the ultimate endeavor! \nThe breath of life... Yin-Yang Kyukatsu chant!", "tamamo_fc1", 0],
      },
      [*1743..1747] => { # 禹歩
        :word_1 => ["\\n<Tamamo>forward left, right forward left...the step of the shaman, that is Yu!", "tamamo_fc1", 0],
      },
      [1743] => { # 霊禹歩
        :word_1 => ["\\n<Tamamo>Move forward to the left, move forward to the right... \n Step of the shrine, that is, Yu!", "tamamo_fc1", 0],
      },
      [1744] => { # 神禹歩
        :word_1 => ["\\n<Tamamo>Move forward to the left, move left to the right... \n God's steps, that is, the steps!", "tamamo_fc1", 0],
      },
      [1747] => { # 絶禹歩
        :word_1 => ["\\n<Tamamo>Move forward to the left, move to the right and move to the left... \n A perfect step, that is, a ball!", "tamamo_fc1", 0],
      },
      [*1751..1762, 1765] => { # 盗む
        :word_1 => ["\\n<Tamamo>I got it!", "tamamo_fc1", 0],
      },
      [1763,1766] => { # 盗賊の証
        :word_1 => ["\\n<Tamamo>This is the essence of a thief!", "tamamo_fc1", 0],
      },
      [1764] => { # とんずら
        :word_1 => ["\\n<Tamamo>I'm going to make a mistake~♪", "tamamo_fc1", 1],
      },
      [*1778..1799, *9320..9327]  => { # 忍術
        :word_1 => ["\\n<Tamamo>Shinobi no jutsu, carve it into your eyes!", "tamamo_fc1", 0],
      },
      [1778] => { # 忍法・火遁
        :word_1 => ["\\n<Tamamo>Crimson hellfire, lick the earth! \n Ninpo/Katon!", "tamamo_fc1", 0],
      },
      [1779] => { # 忍法・水遁
        :word_1 => ["\\n<Tamamo>Endless torrent, attack the earth! \n Ninpo/Suiton!", "tamamo_fc1", 0],
      },
      [1780] => { # 忍法・雷迅
        :word_1 => ["\\n<Tamamo>Dazzling lightning, run on the earth! \n Ninpo - Raijin!", "tamamo_fc1", 0],
      },
      [1786] => { # 忍法・散り桜
        :word_1 => ["\\n<Tamamo>Confused, like falling cherry blossoms! \n Ninja Arts: Falling Cherry Blossoms!", "tamamo_fc1", 0],
      },
      [1792] => { # 忍奥義・五行烈風陣
        :word_1 => ["\\n<Tamamo>Storm, the magical wind of the five elements! \n Ninja Secret Technique: Five Elements Reppuu Formation!", "tamamo_fc1", 0],
      },
      [1793] => { # 忍奥義・乱れ螺旋殺
        :word_1 => ["\\n<Tamamo>Disturb the spiral and turn into a corpse! \n Ninja Secret Technique: Disturbed Spiral Kill!", "tamamo_fc1", 0],
      },
      [9322] => { # 虚術・葬星
        :word_1 => ["\\n<Tamamo>Funeral, the breath of the planet... Imagination/Funeral Star!", "tamamo_fc1", 0],
      },
      [9325] => { # 虚術・星龍
        :word_1 => ["\\n<Tamamo>Come and destroy the Hollow Star Dragon... Imagination Star Dragon!", "tamamo_fc1", 0],
      },
      [1799] => { # 虚術・火遁爆熱
        :word_1 => ["\\n<Tamamo>Extreme hellfire, lick the earth! \n Kyojutsu Katon Explosive Heat!", "tamamo_fc1", 0],
      },
      [9320] => { # 虚術・水遁瀑布
        :word_1 => ["\\n<Tamamo>Extreme torrent, attack the earth! \nKyojutsu Katon is explosive!", "tamamo_fc1", 0],
      },
      [9321] => { # 虚術・雷迅閃光
        :word_1 => ["\\n<Tamamo>Extreme lightning, run on the earth! \n Illusion: Lightning Flash!", "tamamo_fc1", 0],
      },
      [1794] => { # 狐忍法・ぐるぐる車輪
        :word_1 => ["\\n<Tamamo>Let's go, like a wheel spinning loudly! \n Fox Ninpo: Round and Round Wheel!", "tamamo_fc1", 0],
      },
      [1795] => { # 狐忍法・回転鬼火
        :word_1 => ["\\n<Tamamo>The flame is my servant, follow the roaring wheels! \n Fox Ninpo: Rotating Onibi!", "tamamo_fc1", 0],
      },
      [1796] => { # 狐忍法・轟炎輪
        :word_1 => ["\\n<Tamamo>The scorching heat of ten thousand elephants, purify the earth and scorch the heavens! \n Fox Ninpo: Todoroen Ring!", "tamamo_fc1", 0],
      },
      [1798] => { # 禁術・九尾烈葬
        :word_1 => ["\\n<Tamamo>Invite Kokonoe, funeral in the underworld... \n Decay in the scorching heat, funeral of the nine tails!", "tamamo_fc1", 0],
      },
      [9323] => { # 禁術・零尾の虚郭
        :word_1 => ["\\n<Tamamo>This world is known as the butterfly's dream... Forbidden jutsu: Zero-Tail's false home!", "tamamo_fc1", 0],
      },
      [9327] => { # 禁術・九十九葬炎
        :word_1 => ["\\n<Tamamo>Ninety-nine bonfires, the path to the underworld... \n Invite me to the darkness, ninety-nine funeral flames!", "tamamo_fc1", 0],
      },
      [*1800..1804,1808,9328,9329]  => { # 忍術・快楽
        :word_1 => ["\\n<Tamamo>Come on, let's make you happy...", "tamamo_fc1", 2],
      },
      [1800] => { # 淫技・男殺しの魔蜘蛛
        :word_1 => ["\\n<Tamamo>It's good to writhe in my hands...", "tamamo_fc1", 0],
      },
      [1801] => { # 淫技・男嫐りの夜蛇
        :word_1 => ["\\n<Tamamo>Enjoy you